/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd;

import java.io.InputStream;
import java.io.OutputStream;
import rb.httpd.HttpAccessTable;
import rb.httpd.HttpClass;
import rb.httpd.RequestArguments;
import rb.httpd.RequestHeader;
import rb.httpd.RequestProcessorClass;
import rb.util.StringUtil;
import rb.util.SystemRB;

public class Redirect
extends RequestProcessorClass {
    boolean log = SystemRB.getPropertyBoolean("rb.httpd.redirect.log", false);
    static String[] redirectKey;
    static HttpAccessTable[] redirectTable;
    static final String prpLog = "rb.httpd.redirect.log";

    static {
        Redirect.init();
    }

    String getUserAgent(String[] stringArray) {
        String string = "user-agent:";
        int n = stringArray.length;
        while (--n >= 0) {
            String string2 = stringArray[n].toLowerCase();
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string.length()).trim();
            if (this.log) {
                SystemRB.log(this, "User-Agent: " + string3, null);
            }
            return string3;
        }
        if (this.log) {
            SystemRB.log(this, "'User-Agent:' line not found in request ", null);
        }
        return null;
    }

    public static void init() {
        HttpAccessTable httpAccessTable = new HttpAccessTable("rb.httpd.redirect", "=?");
        redirectKey = new String[httpAccessTable.keys.length];
        redirectTable = new HttpAccessTable[redirectKey.length];
        int n = 0;
        while (n < redirectKey.length) {
            Redirect.redirectKey[n] = httpAccessTable.keys[n].toLowerCase();
            Redirect.redirectTable[n] = new HttpAccessTable("rb.httpd.redirect." + httpAccessTable.values[n], "=?");
            ++n;
        }
    }

    public void replyTo(RequestHeader requestHeader, InputStream inputStream, OutputStream outputStream) throws Throwable {
        this.init(requestHeader, outputStream);
        this.arguments = new RequestArguments(requestHeader.getURLParameters());
        if ("showClassInfo".equals(this.arguments.get("cmd"))) {
            this.showClassInfo();
            return;
        }
        String string = HttpAccessTable.translateFileName(requestHeader.getURLPath(), false);
        String string2 = this.getUserAgent(requestHeader.getLines());
        if (string2 != null) {
            int n = 0;
            while (n < redirectKey.length) {
                if (string2.indexOf(redirectKey[n]) >= 0) {
                    string = redirectTable[n].translate(string);
                    break;
                }
                ++n;
            }
        }
        string = StringUtil.replace(string, ":", "|");
        string = StringUtil.replace(string, "\\", "/");
        String string3 = "file:///" + HttpClass.toURL(string);
        if (this.log) {
            SystemRB.log(this, "Redirect to: \"" + string3 + "\" (\"" + string + "\")", null);
        }
        this.sendRedirect(string3);
    }

    void showClassInfo() {
        String string = "?cmd=showClassInfo&";
        this.sendHeader("text/html", -1L, true);
        this.sendHtmlStart("Redirect processor &copy; RB");
        this.print.print("<h2><center>Redirect processor</center></h2>");
        this.print.print("<table border=0 cellpadding=5 cellspacing=0 width=\"100%\"><tbody>");
        String string2 = this.arguments.get(prpLog);
        if (string2 != null) {
            this.log = "true".equals(string2);
            SystemRB.setProperty(prpLog, "" + this.log);
        }
        this.print.print("<tr><td>rb.httpd.redirect.log=");
        this.sendLink("" + this.log, String.valueOf(string) + prpLog + "=" + !this.log, "", "Set to " + !this.log);
        this.print.print("</td><td>If true, write redirect actions to server log file</td></tr>");
        this.print.print("</tbody></table>");
        this.print.print("</body></html>\n");
        this.print.flush();
    }
}

