/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd.address;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import rb.httpd.address.ABAddress;
import rb.httpd.address.ABAddressBook;
import rb.httpd.address.ABClass;
import rb.httpd.address.ABEntry;
import rb.httpd.address.ABPage;
import rb.httpd.address.ABPerson;
import rb.util.IDDictionarySlave;
import rb.util.SystemRB;

public class ABAddressReader
extends ABClass {
    ABAddressBook book;

    void readBookFrom(ABAddressBook aBAddressBook, File file) {
        DataInputStream dataInputStream;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            SystemRB.log(this, "Could not open address book file " + file.getPath(), null);
            return;
        }
        this.book = aBAddressBook;
        aBAddressBook.contents = new IDDictionarySlave();
        Method[] methodArray = this.getClass().getMethods();
        try {
            while (dataInputStream.available() > 0) {
                String string = dataInputStream.readUTF();
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                Long l = new Long(dataInputStream.readLong());
                Long l2 = new Long(dataInputStream.readLong());
                long[] lArray = new long[n];
                String[] stringArray = new String[n2];
                int n3 = 0;
                while (n3 < n) {
                    lArray[n3] = dataInputStream.readLong();
                    ++n3;
                }
                n3 = 0;
                while (n3 < n2) {
                    stringArray[n3] = dataInputStream.readUTF();
                    ++n3;
                }
                n3 = 0;
                while (!methodArray[n3].getName().equals(string)) {
                    ++n3;
                }
                methodArray[n3].invoke((Object)this, l, l2, lArray, stringArray);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            SystemRB.log(this, "Error while reading address book file: " + file.getAbsolutePath(), invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            SystemRB.log(this, "Error while reading address book file: " + file.getAbsolutePath(), exception);
        }
        aBAddressBook.contents = ((IDDictionarySlave)aBAddressBook.contents).asIDDictionary();
    }

    public void remove0(long l, long l2, long[] lArray, String[] stringArray) {
        this.book.getEntry(l).remove();
    }

    public void setAddress0(long l, long l2, long[] lArray, String[] stringArray) {
        ABAddress aBAddress = (ABAddress)this.book.getOrAddEntry(l, (ABEntry)new ABAddress());
        aBAddress.setData(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], (ABAddress)this.book.getEntry(lArray[0]), (ABPerson)this.book.getEntry(lArray[1]));
        aBAddress.lastModified = l2;
    }

    public void setAddress1(long l, long l2, long[] lArray, String[] stringArray) {
        ABAddress aBAddress = (ABAddress)this.book.getOrAddEntry(l, (ABEntry)new ABAddress());
        aBAddress.setData(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], stringArray[7], stringArray[8], stringArray[9], stringArray[10], stringArray[11], (ABAddress)this.book.getEntry(lArray[0]), (ABPerson)this.book.getEntry(lArray[1]));
        aBAddress.lastModified = l2;
    }

    public void setEntries0(long l, long l2, long[] lArray, String[] stringArray) {
        ABPage aBPage = (ABPage)this.book.getEntry(l);
        Enumeration enumeration = ((Vector)aBPage.entries.clone()).elements();
        while (enumeration.hasMoreElements()) {
            aBPage.setEntry((ABEntry)enumeration.nextElement(), false);
        }
        int n = 0;
        while (n < lArray.length) {
            aBPage.setEntry(this.book.getEntry(lArray[n]), true);
            ++n;
        }
        aBPage.lastModified = l2;
    }

    public void setPage0(long l, long l2, long[] lArray, String[] stringArray) {
        ABPage aBPage = (ABPage)this.book.getOrAddEntry(l, (ABEntry)new ABPage());
        aBPage.setData(stringArray[0], stringArray[1], stringArray[2].equals("1"));
        aBPage.lastModified = l2;
    }

    public void setPerson0(long l, long l2, long[] lArray, String[] stringArray) {
        ABPerson aBPerson = (ABPerson)this.book.getOrAddEntry(l, (ABEntry)new ABPerson());
        aBPerson.setData(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        aBPerson.lastModified = l2;
    }

    static void writeTo(File file, String string, ABEntry aBEntry, long[] lArray, String[] stringArray) {
        DataOutput dataOutput;
        if (file == null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            dataOutput = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)dataOutput).writeUTF(string);
            ((DataOutputStream)dataOutput).writeInt(lArray.length);
            ((DataOutputStream)dataOutput).writeInt(stringArray.length);
            ((DataOutputStream)dataOutput).writeLong(aBEntry.getID());
            ((DataOutputStream)dataOutput).writeLong(aBEntry.lastModified);
            int n = 0;
            while (n < lArray.length) {
                ((DataOutputStream)dataOutput).writeLong(lArray[n]);
                ++n;
            }
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] == null) {
                    ((DataOutputStream)dataOutput).writeUTF("");
                } else {
                    ((DataOutputStream)dataOutput).writeUTF(stringArray[n]);
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            SystemRB.log(null, "Error while writing into buffer: ABAddressReader::writeTo(" + file + ", " + string + ", " + aBEntry + ",...)", iOException);
            return;
        }
        try {
            dataOutput = new RandomAccessFile(file, "rw");
            ((RandomAccessFile)dataOutput).seek(((RandomAccessFile)dataOutput).length());
            ((RandomAccessFile)dataOutput).write(byteArrayOutputStream.toByteArray());
            ((RandomAccessFile)dataOutput).close();
        }
        catch (IOException iOException) {
            SystemRB.log(null, "Error while writing buffer to log file: ABAddressReader::writeTo(" + file + ", " + string + ", " + aBEntry + ",...)", iOException);
        }
    }
}

