/*
 * Decompiled with CFR 0.152.
 */
package rb.util;

import java.util.NoSuchElementException;
import rb.util.IntEnumerationRB;
import rb.util.IntVectorEnumeratorRB;
import rb.util.PrimitiveVectorRB;

public class IntVectorRB
extends PrimitiveVectorRB {
    protected int[] elementData;

    public IntVectorRB() {
        this(10);
    }

    public IntVectorRB(int n) {
        this(n, 0);
    }

    public IntVectorRB(int n, int n2) {
        this.elementData = new int[n];
        this.capacityIncrement = n2;
    }

    public final synchronized void addElement(int n) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = n;
    }

    public void addElements(int[] nArray) {
        this.insertElements(nArray, this.elementCount, nArray.length);
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public synchronized Object clone() {
        try {
            IntVectorRB intVectorRB = (IntVectorRB)super.clone();
            intVectorRB.elementData = new int[this.elementCount];
            System.arraycopy(this.elementData, 0, intVectorRB.elementData, 0, this.elementCount);
            return intVectorRB;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final boolean contains(int n) {
        return this.indexOf(n, 0) >= 0;
    }

    public final synchronized void copyInto(int[] nArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            nArray[n] = this.elementData[n];
        }
    }

    public final synchronized int elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public final synchronized IntEnumerationRB elements() {
        return new IntVectorEnumeratorRB(this);
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            int[] nArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new int[n3];
            System.arraycopy(nArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized int firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public final synchronized int indexOf(int n, int n2) {
        int n3 = n2;
        while (n3 < this.elementCount) {
            if (n == this.elementData[n3]) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public final synchronized void insertElementAt(int n, int n2) {
        if (n2 >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.elementCount - n2);
        this.elementData[n2] = n;
        ++this.elementCount;
    }

    public final synchronized void insertElements(int[] nArray, int n, int n2) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + n2);
        System.arraycopy(this.elementData, n, this.elementData, n + n2, this.elementCount - n);
        System.arraycopy(nArray, 0, this.elementData, n, n2);
        this.elementCount += n2;
    }

    public final synchronized int lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(int n, int n2) {
        int n3 = n2;
        while (n3 >= 0) {
            if (n == this.elementData[n3]) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public final synchronized boolean removeElement(int n) {
        int n2 = this.indexOf(n);
        if (n2 >= 0) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
    }

    public final synchronized void setElementAt(int n, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        this.elementData[n2] = n;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        this.copyInto(nArray);
        return nArray;
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        IntEnumerationRB intEnumerationRB = this.elements();
        stringBuffer.append("IntVectorRB[");
        int n2 = 0;
        while (n2 <= n) {
            stringBuffer.append(intEnumerationRB.nextElement());
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            int[] nArray = this.elementData;
            this.elementData = new int[this.elementCount];
            System.arraycopy(nArray, 0, this.elementData, 0, this.elementCount);
        }
    }
}

