/* Script to Answer On Voice Calls */

Call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'
Call RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'
Call RxFuncAdd 'SysCls', 'RexxUtil', 'SysCls'
Call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
Call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
Call RxFuncAdd 'RxAsyncRead', 'RXASYNC', 'RxAsyncRead'
Call RxFuncAdd 'RxAsyncWait', 'RXASYNC', 'RxAsyncWait'
call RxFuncAdd 'RxAsyncLoadFuncs', 'RXASYNC', 'RxAsyncLoadFuncs'
call RxAsyncLoadFuncs

signal on halt

/* [Global] */
comport="com2"
init="AT&F1H0E1V1"
hang="ATZ"
offhook="ATH1"
command_delay=0.5    /* delay between AT commands (sec) */
silence='ATMO'

/* [AON+RINGING Emulation] AVC56 ONLY !!! */
ringing="ATR1"
/* RingTime=30 */
RingTime=10
AonInit="ATS30=0S99=1S78=63S72=30S7="RingTime

/* [Voice] */
RingCount=5
VoiceInit="ATE0J2#CLS=8"
baudrate="AT#BDR=0"
speaker="AT#VLS=2"
record="AT#VRX"
playback="AT#VTX"
beep_1="AT#VTS=[933,0,12]"
dle=x2c(10)
dle_etx=x2c(10)x2c(3)
cancel=x2c(10)x2c(18)
VoiceDir=".\VOICE"
GreetDir=".\GREET"

/* [DTMFs] */


/* [Internal] Don't modify w/o necessity !!! */
PortHandle=''
remaining=''
end_rec=1
aonname=1
debug=0
mainlog=1
lend=x2c(a5)
num=0
crlf=d2c(13)d2c(10)


/* ------------- Entry Point -------------- */

Call SysCls

rc=crlf "       Automatic AVC56 AutoAnswer v 1.00 (c) By Alek Winner." crlf
say rc
if mainlog then call charout rclog,rc

call comport_check

rc = RxAsyncWrite( PortHandle, 0, init||crlf, 'Remaining' )
if rc <> 0 then signal err1

call check_string "Init", "OK", "  Modem not ready... Exitting... ;("


/* ------------ AutoAnswer Part ------------------ */

call voice_init

caller="1319056"

do i=1 to length(caller)

hallo=substr(caller,i,1)".gsm"
call play_file

end

call close_all
signal term


/* --- Check Port State --------*/
comport_check:
if stream(comport,'c','open') = 'NOTREADY:32' then signal err0

call stream comport,'c','close'
rc = RxAsyncOpen( Comport, 'PortHandle' )

rc = RxAsyncSetLnCtrl( PortHandle, 57600, 8, 'N', 1 )
if rc <> 0 then signal err0

rc=RxAsyncSetDcbInfo(PortHandle,'',50,'00001001','10000000','','','','','' )
return

err0:
rc=crlf " "date()"  " time() "  Comport is not respond... ;(" crlf crlf
say rc
if mainlog then call charout rclog,rc
call beep 262,250
exit
/* -----------------------------*/



/* -- Check Modem String --------- */
check_string:
PARSE ARG deb_str, ok_str, err_str

InpStr = ""
do until InpStr=ok_str||crlf | InpStr='ERROR'||crlf
rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
if rc <> 0 then signal err1
db=deb_str InpStr crlf
if debug then call charout debug.log,db
end

if InpStr = ok_str||crlf then return

err1:
rc=crlf " "date()"  " time() err_str "rc="rc "InpStr="InpStr crlf crlf
say rc
if mainlog then call charout rclog,rc
call beep 262,250
signal halt
/* -- Check Modem String - Ends -- */



/* ----- Close All Files -------*/
close_all:
call stream hallo,'c','close'
call stream voicename,'c','close'
call stream numlog,'c','close'
call stream rclog,'c','close'
call stream debug.log,'c','close'
return
/* -----------------------------*/


/* ---- Play Voice File --------*/
play_file:

rc = RxAsyncWrite( PortHandle, 0, playback||crlf, 'Remaining' )
if rc <> 0 then signal err1
call check_string "Playback", "CONNECT", "  PlayBack Failed... Exitting... ;("

rc=" "date()"  " time() "  Playing..." crlf
say rc
if mainlog then call charout rclog,rc

do forever

write_buf=''

do 50

rc=charin(hallo,,1)
if c2x(rc)="" then signal done_play

if c2x(rc)=10 then write_buf=write_buf||rc
write_buf=write_buf||rc

if chars()=1 then
  do
  rc=SysGetKey(noecho)
  call RxAsyncWrite PortHandle, 2, cancel, 'Remaining'
  signal done_play
  end

end

rc = RxAsyncWrite( PortHandle, 0, write_buf, 'Remaining' )
if rc <> 0 then signal done_play

end

done_play:


call RxAsyncWrite PortHandle, 2, dle_etx, 'Remaining'

call cancel_stream

call stream hallo,'c','close'
return
/* ----------------------------------------- */

/* ------------ Voice Initialization ------------------------- */

voice_init:

rc = RxAsyncWrite( PortHandle, 0, VoiceInit||crlf, 'Remaining' )
if rc <> 0 then signal err1
call check_string "VoiceInit", "OK", "Error entering to Voice mode... Exitting... ;("


rc = RxAsyncWrite( PortHandle, 0, speaker||crlf, 'Remaining' )
if rc <> 0 then signal err1
call check_string "Speaker", "VCON", "  Error setting audio device... ;("
return

/* ---------------  Voice Init Endp  -------------------------*/


/* ---- Reading Tail of Stream from Port ---- */

cancel_stream:

rc=" "date()"  " time() "  Done..." crlf
say rc
if mainlog then call charout rclog,rc

do until rc='VCON'||crlf
db = RxAsyncRead( PortHandle, 0, 0, 'rc' )
db="process end" rc crlf
if debug then call charout debug.log,db
end

return

/* -------------- End Proc ----------------- */


fals_key:
key=c2d(SysGetKey())

sel_key:
select
when key=27 | key=32 then
do
rc=" "date()"  " time() "  ESC pressed, Aborting... ;)" crlf
say rc
if mainlog then call charout rclog,rc

call ring_break

rc=crlf
num=num+length(rc)
call charout numlog,rc
call stream numlog,'c','close'

signal patrol
end

when key=13 then
do
call ring_break
signal ring_end
end

when key=110 | key=78 then    /* (N) */
do
call play_new
signal space
end

otherwise
return
end
halt:
say " 㡨..."
term:

call close_all
call RxAsyncClose PortHandle

/*
do until rc=-1
rc = RxAsyncRead( PortHandle, 0, 0, 'InpStr' )
db="Echo" InpStr crlf
if debug then call charout debug.log,db
end
*/

prog_quit: