#include "manycode.h"

#include <stdlib.h>
#include <string.h>

#ifdef DMALLOC
#include <dmalloc.h>
#endif

static char tab_alt[256] =
{
   /* ######################################################################## */
   /* # dos-koi.tab */
   /* # cp866 -> KOI8-R recoding table for Russian Apache */
   /* # by Dmitry A. Pashko (dap@stack.net) */
   /* ######################################################################## */

               0x00,
    /* 0x01 */ 0x01,/* ? - const */
    /* 0x02 */ 0x02,/* ? - const */
    /* 0x03 */ 0x03,/* ? - const */
    /* 0x04 */ 0x04,/* ? - const */
    /* 0x05 */ 0x05,/* ? - const */
    /* 0x06 */ 0x06,/* ? - const */
    /* 0x07 */ 0x07,/* ? - const */
    /* 0x08 */ 0x08,/* ? - const */
    /* 0x09 */ 0x09,/* ? - const */
    /* 0x0a */ 0x0a,/* ? - const */
    /* 0x0b */ 0x0b,/* ? - const */
    /* 0x0c */ 0x0c,/* ? - const */
    /* 0x0d */ 0x0d,/* ? - const */
    /* 0x0e */ 0x0e,/* ? - const */
    /* 0x0f */ 0x0f,/* ? - const */
    /* 0x10 */ 0x10,/* ? - const */
    /* 0x11 */ 0x11,/* ? - const */
    /* 0x12 */ 0x12,/* ? - const */
    /* 0x13 */ 0x13,/* ? - const */
    /* 0x14 */ 0x14,/* ? - const */
    /* 0x15 */ 0x15,/* ? - const */
    /* 0x16 */ 0x16,/* ? - const */
    /* 0x17 */ 0x17,/* ? - const */
    /* 0x18 */ 0x18,/* ? - const */
    /* 0x19 */ 0x19,/* ? - const */
    /* 0x1a */ 0x1a,/* ? - const */
    /* 0x1b */ 0x1b,/* ? - const */
    /* 0x1c */ 0x1c,/* ? - const */
    /* 0x1d */ 0x1d,/* ? - const */
    /* 0x1e */ 0x1e,/* ? - const */
    /* 0x1f */ 0x1f,/* ? - const */
    /* 0x20 */ 0x20,/*   - const */
    /* 0x21 */ 0x21,/* ! - const */
    /* 0x22 */ 0x22,/* " - const */
    /* 0x23 */ 0x23,/* # - const */
    /* 0x24 */ 0x24,/* $ - const */
    /* 0x25 */ 0x25,/* % - const */
    /* 0x26 */ 0x26,/* & - const */
    /* 0x27 */ 0x27,/* ' - const */
    /* 0x28 */ 0x28,/* ( - const */
    /* 0x29 */ 0x29,/* ) - const */
    /* 0x2a */ 0x2a,/* * - const */
    /* 0x2b */ 0x2b,/* + - const */
    /* 0x2c */ 0x2c,/* , - const */
    /* 0x2d */ 0x2d,/* - - const */
    /* 0x2e */ 0x2e,/* . - const */
    /* 0x2f */ 0x2f,/* / - const */
    /* 0x30 */ 0x30,/* 0 - const */
    /* 0x31 */ 0x31,/* 1 - const */
    /* 0x32 */ 0x32,/* 2 - const */
    /* 0x33 */ 0x33,/* 3 - const */
    /* 0x34 */ 0x34,/* 4 - const */
    /* 0x35 */ 0x35,/* 5 - const */
    /* 0x36 */ 0x36,/* 6 - const */
    /* 0x37 */ 0x37,/* 7 - const */
    /* 0x38 */ 0x38,/* 8 - const */
    /* 0x39 */ 0x39,/* 9 - const */
    /* 0x3a */ 0x3a,/* : - const */
    /* 0x3b */ 0x3b,/* ; - const */
    /* 0x3c */ 0x3c,/* < - const */
    /* 0x3d */ 0x3d,/* = - const */
    /* 0x3e */ 0x3e,/* > - const */
    /* 0x3f */ 0x3f,/* ? - const */
    /* 0x40 */ 0x40,/* @ - const */
    /* 0x41 */ 0x41,/* A - const */
    /* 0x42 */ 0x42,/* B - const */
    /* 0x43 */ 0x43,/* C - const */
    /* 0x44 */ 0x44,/* D - const */
    /* 0x45 */ 0x45,/* E - const */
    /* 0x46 */ 0x46,/* F - const */
    /* 0x47 */ 0x47,/* G - const */
    /* 0x48 */ 0x48,/* H - const */
    /* 0x49 */ 0x49,/* I - const */
    /* 0x4a */ 0x4a,/* J - const */
    /* 0x4b */ 0x4b,/* K - const */
    /* 0x4c */ 0x4c,/* L - const */
    /* 0x4d */ 0x4d,/* M - const */
    /* 0x4e */ 0x4e,/* N - const */
    /* 0x4f */ 0x4f,/* O - const */
    /* 0x50 */ 0x50,/* P - const */
    /* 0x51 */ 0x51,/* Q - const */
    /* 0x52 */ 0x52,/* R - const */
    /* 0x53 */ 0x53,/* S - const */
    /* 0x54 */ 0x54,/* T - const */
    /* 0x55 */ 0x55,/* U - const */
    /* 0x56 */ 0x56,/* V - const */
    /* 0x57 */ 0x57,/* W - const */
    /* 0x58 */ 0x58,/* X - const */
    /* 0x59 */ 0x59,/* Y - const */
    /* 0x5a */ 0x5a,/* Z - const */
    /* 0x5b */ 0x5b,/* [ - const */
    /* 0x5c */ 0x5c,/* \ - const */
    /* 0x5d */ 0x5d,/* ] - const */
    /* 0x5e */ 0x5e,/* ^ - const */
    /* 0x5f */ 0x5f,/* _ - const */
    /* 0x60 */ 0x60,/* ` - const */
    /* 0x61 */ 0x61,/* a - const */
    /* 0x62 */ 0x62,/* b - const */
    /* 0x63 */ 0x63,/* c - const */
    /* 0x64 */ 0x64,/* d - const */
    /* 0x65 */ 0x65,/* e - const */
    /* 0x66 */ 0x66,/* f - const */
    /* 0x67 */ 0x67,/* g - const */
    /* 0x68 */ 0x68,/* h - const */
    /* 0x69 */ 0x69,/* i - const */
    /* 0x6a */ 0x6a,/* j - const */
    /* 0x6b */ 0x6b,/* k - const */
    /* 0x6c */ 0x6c,/* l - const */
    /* 0x6d */ 0x6d,/* m - const */
    /* 0x6e */ 0x6e,/* n - const */
    /* 0x6f */ 0x6f,/* o - const */
    /* 0x70 */ 0x70,/* p - const */
    /* 0x71 */ 0x71,/* q - const */
    /* 0x72 */ 0x72,/* r - const */
    /* 0x73 */ 0x73,/* s - const */
    /* 0x74 */ 0x74,/* t - const */
    /* 0x75 */ 0x75,/* u - const */
    /* 0x76 */ 0x76,/* v - const */
    /* 0x77 */ 0x77,/* w - const */
    /* 0x78 */ 0x78,/* x - const */
    /* 0x79 */ 0x79,/* y - const */
    /* 0x7a */ 0x7a,/* z - const */
    /* 0x7b */ 0x7b,/* { - const */
    /* 0x7c */ 0x7c,/* | - const */
    /* 0x7d */ 0x7d,/* } - const */
    /* 0x7e */ 0x7e,/* ~ - const */
    /* 0x7f */ 0x7f,/* ? - const */
    /* 0x80 */ 0xe1,/* A */
    /* 0x81 */ 0xe2,/* B */
    /* 0x82 */ 0xf7,/* V */
    /* 0x83 */ 0xe7,/* G */
    /* 0x84 */ 0xe4,/* D */
    /* 0x85 */ 0xe5,/* E */
    /* 0x86 */ 0xf6,/* Zh */
    /* 0x87 */ 0xfa,/* Z */
    /* 0x88 */ 0xe9,/* I */
    /* 0x89 */ 0xea,/* Y */
    /* 0x8a */ 0xeb,/* K */
    /* 0x8b */ 0xec,/* L */
    /* 0x8c */ 0xed,/* M */
    /* 0x8d */ 0xee,/* N */
    /* 0x8e */ 0xef,/* O */
    /* 0x8f */ 0xf0,/* P */
    /* 0x90 */ 0xf2,/* R */
    /* 0x91 */ 0xf3,/* S */
    /* 0x92 */ 0xf4,/* T */
    /* 0x93 */ 0xf5,/* U */
    /* 0x94 */ 0xe6,/* F */
    /* 0x95 */ 0xe8,/* Kh */
    /* 0x96 */ 0xe3,/* Cz */
    /* 0x97 */ 0xfe,/* Ch */
    /* 0x98 */ 0xfb,/* Sh */
    /* 0x99 */ 0xfd,/* Sch */
    /* 0x9a */ 0xff,/* ` */
    /* 0x9b */ 0xf9,/* Y */
    /* 0x9c */ 0xf8,/* ' */
    /* 0x9d */ 0xfc,/* E */
    /* 0x9e */ 0xe0,/* Yu */
    /* 0x9f */ 0xf1,/* Ya */
    /* 0xa0 */ 0xc1,/* a */
    /* 0xa1 */ 0xc2,/* b */
    /* 0xa2 */ 0xd7,/* v */
    /* 0xa3 */ 0xc7,/* g */
    /* 0xa4 */ 0xc4,/* d */
    /* 0xa5 */ 0xc5,/* e */
    /* 0xa6 */ 0xd6,/* zh */
    /* 0xa7 */ 0xda,/* z */
    /* 0xa8 */ 0xc9,/* i */
    /* 0xa9 */ 0xca,/* y */
    /* 0xaa */ 0xcb,/* k */
    /* 0xab */ 0xcc,/* l */
    /* 0xac */ 0xcd,/* m */
    /* 0xad */ 0xce,/* n */
    /* 0xae */ 0xcf,/* o */
    /* 0xaf */ 0xd0,/* p */
    /* 0xb0 */ 0x90,/* ? */
    /* 0xb1 */ 0x91,/* ? */
    /* 0xb2 */ 0x92,/* ? */
    /* 0xb3 */ 0x81,/* ? */
    /* 0xb4 */ 0x87,/* ? */
    /* 0xb5 */ 0xb2,/* ? */
    /* 0xb6 */ 0xb4,/* ? */
    /* 0xb7 */ 0xa7,/* ? */
    /* 0xb8 */ 0xa6,/* ? */
    /* 0xb9 */ 0xb5,/* ? */
    /* 0xba */ 0xa1,/* ? */
    /* 0xbb */ 0xa8,/* ? */
    /* 0xbc */ 0xae,/* ? */
    /* 0xbd */ 0xad,/* ? */
    /* 0xbe */ 0xac,/* ? */
    /* 0xbf */ 0x83,/* ? */
    /* 0xc0 */ 0x84,/* ? */
    /* 0xc1 */ 0x89,/* ? */
    /* 0xc2 */ 0x88,/* ? */
    /* 0xc3 */ 0x86,/* ? */
    /* 0xc4 */ 0x80,/* ? */
    /* 0xc5 */ 0x8a,/* ? */
    /* 0xc6 */ 0xaf,/* ? */
    /* 0xc7 */ 0xb0,/* ? */
    /* 0xc8 */ 0xab,/* ? */
    /* 0xc9 */ 0xa5,/* ? */
    /* 0xca */ 0xbb,/* ? */
    /* 0xcb */ 0xb8,/* ? */
    /* 0xcc */ 0xb1,/* ? */
    /* 0xcd */ 0xa0,/* ? */
    /* 0xce */ 0xbe,/* ? */
    /* 0xcf */ 0xb9,/* ? */
    /* 0xd0 */ 0xba,/* ? */
    /* 0xd1 */ 0xb6,/* ? */
    /* 0xd2 */ 0xb7,/* ? */
    /* 0xd3 */ 0xaa,/* ? */
    /* 0xd4 */ 0xa9,/* ? */
    /* 0xd5 */ 0xa2,/* ? */
    /* 0xd6 */ 0xa4,/* ? */
    /* 0xd7 */ 0xbd,/* ? */
    /* 0xd8 */ 0xbc,/* ? */
    /* 0xd9 */ 0x85,/* ? */
    /* 0xda */ 0x82,/* ? */
    /* 0xdb */ 0x8d,/* ? */
    /* 0xdc */ 0x8c,/* ? */
    /* 0xdd */ 0x8e,/* ? */
    /* 0xde */ 0x8f,/* ? */
    /* 0xdf */ 0x8b,/* ? */
    /* 0xe0 */ 0xd2,/* r */
    /* 0xe1 */ 0xd3,/* s */
    /* 0xe2 */ 0xd4,/* t */
    /* 0xe3 */ 0xd5,/* u */
    /* 0xe4 */ 0xc6,/* f */
    /* 0xe5 */ 0xc8,/* kh */
    /* 0xe6 */ 0xc3,/* cz */
    /* 0xe7 */ 0xde,/* ch */
    /* 0xe8 */ 0xdb,/* sh */
    /* 0xe9 */ 0xdd,/* sch */
    /* 0xea */ 0xdf,/* ` */
    /* 0xeb */ 0xd9,/* y */
    /* 0xec */ 0xd8,/* ' */
    /* 0xed */ 0xdc,/* e */
    /* 0xee */ 0xc0,/* yu */
    /* 0xef */ 0xd1,/* ya */
    /* 0xf0 */ 0xb3,/* E */
    /* 0xf1 */ 0xa3,/* e */
    /* 0xf2 */ 0x3f,/* E */
    /* 0xf3 */ 0x3f,/* e */
    /* 0xf4 */ 0x3f,/* I */
    /* 0xf5 */ 0x3f,/* i */
    /* 0xf6 */ 0x3f,/* U~ */
    /* 0xf7 */ 0x3f,/* y^ */
    /* 0xf8 */ 0x9c,/* circ */
    /* 0xf9 */ 0x95,/* ? */
    /* 0xfa */ 0x9e,/* . */
    /* 0xfb */ 0x96,/* ? */
    /* 0xfc */ 0x3f,/* ? */
    /* 0xfd */ 0x3f,/* ? */
    /* 0xfe */ 0x94,/* ? */
    /* 0xff */ 0x9a,/*  */};

static char tab_iso[256] =
{
   /* ######################################################################## */
   /* # iso-koi.tab */
   /* # ISO-8859-5 -> KOI8-R recoding table for Russian Apache */
   /* # by Dmitry A. Pashko (dap@stack.net) */
   /* ######################################################################## */

               0x00,
    /* 0x01 */ 0x01,/* ? - const */
    /* 0x02 */ 0x02,/* ? - const */
    /* 0x03 */ 0x03,/* ? - const */
    /* 0x04 */ 0x04,/* ? - const */
    /* 0x05 */ 0x05,/* ? - const */
    /* 0x06 */ 0x06,/* ? - const */
    /* 0x07 */ 0x07,/* ? - const */
    /* 0x08 */ 0x08,/* ? - const */
    /* 0x09 */ 0x09,/* ? - const */
    /* 0x0a */ 0x0a,/* ? - const */
    /* 0x0b */ 0x0b,/* ? - const */
    /* 0x0c */ 0x0c,/* ? - const */
    /* 0x0d */ 0x0d,/* ? - const */
    /* 0x0e */ 0x0e,/* ? - const */
    /* 0x0f */ 0x0f,/* ? - const */
    /* 0x10 */ 0x10,/* ? - const */
    /* 0x11 */ 0x11,/* ? - const */
    /* 0x12 */ 0x12,/* ? - const */
    /* 0x13 */ 0x13,/* ? - const */
    /* 0x14 */ 0x14,/* ? - const */
    /* 0x15 */ 0x15,/* ? - const */
    /* 0x16 */ 0x16,/* ? - const */
    /* 0x17 */ 0x17,/* ? - const */
    /* 0x18 */ 0x18,/* ? - const */
    /* 0x19 */ 0x19,/* ? - const */
    /* 0x1a */ 0x1a,/* ? - const */
    /* 0x1b */ 0x1b,/* ? - const */
    /* 0x1c */ 0x1c,/* ? - const */
    /* 0x1d */ 0x1d,/* ? - const */
    /* 0x1e */ 0x1e,/* ? - const */
    /* 0x1f */ 0x1f,/* ? - const */
    /* 0x20 */ 0x20,/*   - const */
    /* 0x21 */ 0x21,/* ! - const */
    /* 0x22 */ 0x22,/* " - const */
    /* 0x23 */ 0x23,/* , // - const */
    /* 0x24 */ 0x24,/* $ - const */
    /* 0x25 */ 0x25,/* % - const */
    /* 0x26 */ 0x26,/* & - const */
    /* 0x27 */ 0x27,/* ' - const */
    /* 0x28 */ 0x28,/* ( - const */
    /* 0x29 */ 0x29,/* ) - const */
    /* 0x2a */ 0x2a,/* * - const */
    /* 0x2b */ 0x2b,/* + - const */
    /* 0x2c */ 0x2c,/* , - const */
    /* 0x2d */ 0x2d,/* - - const */
    /* 0x2e */ 0x2e,/* . - const */
    /* 0x2f */ 0x2f,/* / - const */
    /* 0x30 */ 0x30,/* 0 - const */
    /* 0x31 */ 0x31,/* 1 - const */
    /* 0x32 */ 0x32,/* 2 - const */
    /* 0x33 */ 0x33,/* 3 - const */
    /* 0x34 */ 0x34,/* 4 - const */
    /* 0x35 */ 0x35,/* 5 - const */
    /* 0x36 */ 0x36,/* 6 - const */
    /* 0x37 */ 0x37,/* 7 - const */
    /* 0x38 */ 0x38,/* 8 - const */
    /* 0x39 */ 0x39,/* 9 - const */
    /* 0x3a */ 0x3a,/* : - const */
    /* 0x3b */ 0x3b,/* ; - const */
    /* 0x3c */ 0x3c,/* < - const */
    /* 0x3d */ 0x3d,/* = - const */
    /* 0x3e */ 0x3e,/* > - const */
    /* 0x3f */ 0x3f,/* ? - const */
    /* 0x40 */ 0x40,/* @ - const */
    /* 0x41 */ 0x41,/* A - const */
    /* 0x42 */ 0x42,/* B - const */
    /* 0x43 */ 0x43,/* C - const */
    /* 0x44 */ 0x44,/* D - const */
    /* 0x45 */ 0x45,/* E - const */
    /* 0x46 */ 0x46,/* F - const */
    /* 0x47 */ 0x47,/* G - const */
    /* 0x48 */ 0x48,/* H - const */
    /* 0x49 */ 0x49,/* I - const */
    /* 0x4a */ 0x4a,/* J - const */
    /* 0x4b */ 0x4b,/* K - const */
    /* 0x4c */ 0x4c,/* L - const */
    /* 0x4d */ 0x4d,/* M - const */
    /* 0x4e */ 0x4e,/* N - const */
    /* 0x4f */ 0x4f,/* O - const */
    /* 0x50 */ 0x50,/* P - const */
    /* 0x51 */ 0x51,/* Q - const */
    /* 0x52 */ 0x52,/* R - const */
    /* 0x53 */ 0x53,/* S - const */
    /* 0x54 */ 0x54,/* T - const */
    /* 0x55 */ 0x55,/* U - const */
    /* 0x56 */ 0x56,/* V - const */
    /* 0x57 */ 0x57,/* W - const */
    /* 0x58 */ 0x58,/* X - const */
    /* 0x59 */ 0x59,/* Y - const */
    /* 0x5a */ 0x5a,/* Z - const */
    /* 0x5b */ 0x5b,/* [ - const */
    /* 0x5c */ 0x5c,/* \ - const */
    /* 0x5d */ 0x5d,/* ] - const */
    /* 0x5e */ 0x5e,/* ^ - const */
    /* 0x5f */ 0x5f,/* _ - const */
    /* 0x60 */ 0x60,/* ` - const */
    /* 0x61 */ 0x61,/* a - const */
    /* 0x62 */ 0x62,/* b - const */
    /* 0x63 */ 0x63,/* c - const */
    /* 0x64 */ 0x64,/* d - const */
    /* 0x65 */ 0x65,/* e - const */
    /* 0x66 */ 0x66,/* f - const */
    /* 0x67 */ 0x67,/* g - const */
    /* 0x68 */ 0x68,/* h - const */
    /* 0x69 */ 0x69,/* i - const */
    /* 0x6a */ 0x6a,/* j - const */
    /* 0x6b */ 0x6b,/* k - const */
    /* 0x6c */ 0x6c,/* l - const */
    /* 0x6d */ 0x6d,/* m - const */
    /* 0x6e */ 0x6e,/* n - const */
    /* 0x6f */ 0x6f,/* o - const */
    /* 0x70 */ 0x70,/* p - const */
    /* 0x71 */ 0x71,/* q - const */
    /* 0x72 */ 0x72,/* r - const */
    /* 0x73 */ 0x73,/* s - const */
    /* 0x74 */ 0x74,/* t - const */
    /* 0x75 */ 0x75,/* u - const */
    /* 0x76 */ 0x76,/* v - const */
    /* 0x77 */ 0x77,/* w - const */
    /* 0x78 */ 0x78,/* x - const */
    /* 0x79 */ 0x79,/* y - const */
    /* 0x7a */ 0x7a,/* z - const */
    /* 0x7b */ 0x7b,/* { - const */
    /* 0x7c */ 0x7c,/* | - const */
    /* 0x7d */ 0x7d,/* } - const */
    /* 0x7e */ 0x7e,/* ~ - const */
    /* 0x7f */ 0x7f,/* ? - const */
    /* 0x80 */ 0x3f,/* ? */
    /* 0x81 */ 0x3f,/* ? */
    /* 0x82 */ 0x3f,/* ? */
    /* 0x83 */ 0x3f,/* ? */
    /* 0x84 */ 0x3f,/* ? */
    /* 0x85 */ 0x3f,/* ? */
    /* 0x86 */ 0x3f,/* ? */
    /* 0x87 */ 0x3f,/* ? */
    /* 0x88 */ 0x3f,/* ? */
    /* 0x89 */ 0x3f,/* ? */
    /* 0x8a */ 0x3f,/* ? */
    /* 0x8b */ 0x3f,/* ? */
    /* 0x8c */ 0x3f,/* ? */
    /* 0x8d */ 0x3f,/* ? */
    /* 0x8e */ 0x3f,/* ? */
    /* 0x8f */ 0x3f,/* ? */
    /* 0x90 */ 0x3f,/* ? */
    /* 0x91 */ 0x3f,/* ? */
    /* 0x92 */ 0x3f,/* ? */
    /* 0x93 */ 0x3f,/* ? */
    /* 0x94 */ 0x3f,/* ? */
    /* 0x95 */ 0x3f,/* ? */
    /* 0x96 */ 0x3f,/* ? */
    /* 0x97 */ 0x3f,/* ? */
    /* 0x98 */ 0x3f,/* ? */
    /* 0x99 */ 0x3f,/* ? */
    /* 0x9a */ 0x3f,/* ? */
    /* 0x9b */ 0x3f,/* ? */
    /* 0x9c */ 0x3f,/* ? */
    /* 0x9d */ 0x3f,/* ? */
    /* 0x9e */ 0x3f,/* ? */
    /* 0x9f */ 0x3f,/* ? */
    /* 0xa0 */ 0x9a,/*  */
    /* 0xa1 */ 0xb3,/* E */
    /* 0xa2 */ 0x3f,/* h */
    /* 0xa3 */ 0x3f,/* G' */
    /* 0xa4 */ 0x3f,/* E */
    /* 0xa5 */ 0x3f,/* S */
    /* 0xa6 */ 0x3f,/* I */
    /* 0xa7 */ 0x3f,/* I */
    /* 0xa8 */ 0x3f,/* J */
    /* 0xa9 */ 0x3f,/* L' */
    /* 0xaa */ 0x3f,/* H' */
    /* 0xab */ 0x3f,/* h */
    /* 0xac */ 0x3f,/* K' */
    /* 0xad */ 0x2d,/* - */
    /* 0xae */ 0x3f,/* U~ */
    /* 0xaf */ 0x3f,/* Cz, */
    /* 0xb0 */ 0xe1,/* A */
    /* 0xb1 */ 0xe2,/* B */
    /* 0xb2 */ 0xf7,/* V */
    /* 0xb3 */ 0xe7,/* G */
    /* 0xb4 */ 0xe4,/* D */
    /* 0xb5 */ 0xe5,/* E */
    /* 0xb6 */ 0xf6,/* Zh */
    /* 0xb7 */ 0xfa,/* Z */
    /* 0xb8 */ 0xe9,/* I */
    /* 0xb9 */ 0xea,/* Y */
    /* 0xba */ 0xeb,/* K */
    /* 0xbb */ 0xec,/* L */
    /* 0xbc */ 0xed,/* M */
    /* 0xbd */ 0xee,/* N */
    /* 0xbe */ 0xef,/* O */
    /* 0xbf */ 0xf0,/* P */
    /* 0xc0 */ 0xf2,/* R */
    /* 0xc1 */ 0xf3,/* S */
    /* 0xc2 */ 0xf4,/* T */
    /* 0xc3 */ 0xf5,/* U */
    /* 0xc4 */ 0xe6,/* F */
    /* 0xc5 */ 0xe8,/* Kh */
    /* 0xc6 */ 0xe3,/* Cz */
    /* 0xc7 */ 0xfe,/* Ch */
    /* 0xc8 */ 0xfb,/* Sh */
    /* 0xc9 */ 0xfd,/* Sch */
    /* 0xca */ 0xff,/* ` */
    /* 0xcb */ 0xf9,/* Y */
    /* 0xcc */ 0xf8,/* ' */
    /* 0xcd */ 0xfc,/* E */
    /* 0xce */ 0xe0,/* Yu */
    /* 0xcf */ 0xf1,/* Ya */
    /* 0xd0 */ 0xc1,/* a */
    /* 0xd1 */ 0xc2,/* b */
    /* 0xd2 */ 0xd7,/* v */
    /* 0xd3 */ 0xc7,/* g */
    /* 0xd4 */ 0xc4,/* d */
    /* 0xd5 */ 0xc5,/* e */
    /* 0xd6 */ 0xd6,/* zh - const */
    /* 0xd7 */ 0xda,/* z */
    /* 0xd8 */ 0xc9,/* i */
    /* 0xd9 */ 0xca,/* y */
    /* 0xda */ 0xcb,/* k */
    /* 0xdb */ 0xcc,/* l */
    /* 0xdc */ 0xcd,/* m */
    /* 0xdd */ 0xce,/* n */
    /* 0xde */ 0xcf,/* o */
    /* 0xdf */ 0xd0,/* p */
    /* 0xe0 */ 0xd2,/* r */
    /* 0xe1 */ 0xd3,/* s */
    /* 0xe2 */ 0xd4,/* t */
    /* 0xe3 */ 0xd5,/* u */
    /* 0xe4 */ 0xc6,/* f */
    /* 0xe5 */ 0xc8,/* kh */
    /* 0xe6 */ 0xc3,/* cz */
    /* 0xe7 */ 0xde,/* ch */
    /* 0xe8 */ 0xdb,/* sh */
    /* 0xe9 */ 0xdd,/* sch */
    /* 0xea */ 0xdf,/* ` */
    /* 0xeb */ 0xd9,/* y */
    /* 0xec */ 0xd8,/* ' */
    /* 0xed */ 0xdc,/* e */
    /* 0xee */ 0xc0,/* yu */
    /* 0xef */ 0xd1,/* ya */
    /* 0xf0 */ 0x3f,/* ? */
    /* 0xf1 */ 0xa3,/* e */
    /* 0xf2 */ 0x3f,/* h */
    /* 0xf3 */ 0x3f,/* g' */
    /* 0xf4 */ 0x3f,/* e */
    /* 0xf5 */ 0x3f,/* s */
    /* 0xf6 */ 0x3f,/* i */
    /* 0xf7 */ 0x3f,/* i */
    /* 0xf8 */ 0x3f,/* j */
    /* 0xf9 */ 0x3f,/* l' */
    /* 0xfa */ 0x3f,/* n' */
    /* 0xfb */ 0x3f,/* h */
    /* 0xfc */ 0x3f,/* k' */
    /* 0xfd */ 0x15,/* , // */
    /* 0xfe */ 0x3f,/* y^ */
    /* 0xff */ 0x3f,/* cz, */
};

static char tab_mac[256] =
{
   /* ######################################################################## */
   /* # mac-koi.tab */
   /* # Mac Cyrillic -> KOI8-R recoding table for Russian Apache */
   /* # by Dmitry A. Pashko (dap@stack.net) */
   /* ######################################################################## */

               0x00,
    /* 0x01 */ 0x01,/* ? - const */
    /* 0x02 */ 0x02,/* ? - const */
    /* 0x03 */ 0x03,/* ? - const */
    /* 0x04 */ 0x04,/* ? - const */
    /* 0x05 */ 0x05,/* ? - const */
    /* 0x06 */ 0x06,/* ? - const */
    /* 0x07 */ 0x07,/* ? - const */
    /* 0x08 */ 0x08,/* ? - const */
    /* 0x09 */ 0x09,/* ? - const */
    /* 0x0a */ 0x0a,/* ? - const */
    /* 0x0b */ 0x0b,/* ? - const */
    /* 0x0c */ 0x0c,/* ? - const */
    /* 0x0d */ 0x0d,/* ? - const */
    /* 0x0e */ 0x0e,/* ? - const */
    /* 0x0f */ 0x0f,/* ? - const */
    /* 0x10 */ 0x10,/* ? - const */
    /* 0x11 */ 0x11,/* ? - const */
    /* 0x12 */ 0x12,/* ? - const */
    /* 0x13 */ 0x13,/* ? - const */
    /* 0x14 */ 0x14,/* ? - const */
    /* 0x15 */ 0x15,/* ? - const */
    /* 0x16 */ 0x16,/* ? - const */
    /* 0x17 */ 0x17,/* ? - const */
    /* 0x18 */ 0x18,/* ? - const */
    /* 0x19 */ 0x19,/* ? - const */
    /* 0x1a */ 0x1a,/* ? - const */
    /* 0x1b */ 0x1b,/* ? - const */
    /* 0x1c */ 0x1c,/* ? - const */
    /* 0x1d */ 0x1d,/* ? - const */
    /* 0x1e */ 0x1e,/* ? - const */
    /* 0x1f */ 0x1f,/* ? - const */
    /* 0x20 */ 0x20,/*   - const */
    /* 0x21 */ 0x21,/* ! - const */
    /* 0x22 */ 0x22,/* " - const */
    /* 0x23 */ 0x23,/* , // - const */
    /* 0x24 */ 0x24,/* $ - const */
    /* 0x25 */ 0x25,/* % - const */
    /* 0x26 */ 0x26,/* & - const */
    /* 0x27 */ 0x27,/* ' - const */
    /* 0x28 */ 0x28,/* ( - const */
    /* 0x29 */ 0x29,/* ) - const */
    /* 0x2a */ 0x2a,/* * - const */
    /* 0x2b */ 0x2b,/* + - const */
    /* 0x2c */ 0x2c,/* , - const */
    /* 0x2d */ 0x2d,/* - - const */
    /* 0x2e */ 0x2e,/* . - const */
    /* 0x2f */ 0x2f,/* / - const */
    /* 0x30 */ 0x30,/* 0 - const */
    /* 0x31 */ 0x31,/* 1 - const */
    /* 0x32 */ 0x32,/* 2 - const */
    /* 0x33 */ 0x33,/* 3 - const */
    /* 0x34 */ 0x34,/* 4 - const */
    /* 0x35 */ 0x35,/* 5 - const */
    /* 0x36 */ 0x36,/* 6 - const */
    /* 0x37 */ 0x37,/* 7 - const */
    /* 0x38 */ 0x38,/* 8 - const */
    /* 0x39 */ 0x39,/* 9 - const */
    /* 0x3a */ 0x3a,/* : - const */
    /* 0x3b */ 0x3b,/* ; - const */
    /* 0x3c */ 0x3c,/* < - const */
    /* 0x3d */ 0x3d,/* = - const */
    /* 0x3e */ 0x3e,/* > - const */
    /* 0x3f */ 0x3f,/* ? - const */
    /* 0x40 */ 0x40,/* @ - const */
    /* 0x41 */ 0x41,/* A - const */
    /* 0x42 */ 0x42,/* B - const */
    /* 0x43 */ 0x43,/* C - const */
    /* 0x44 */ 0x44,/* D - const */
    /* 0x45 */ 0x45,/* E - const */
    /* 0x46 */ 0x46,/* F - const */
    /* 0x47 */ 0x47,/* G - const */
    /* 0x48 */ 0x48,/* H - const */
    /* 0x49 */ 0x49,/* I - const */
    /* 0x4a */ 0x4a,/* J - const */
    /* 0x4b */ 0x4b,/* K - const */
    /* 0x4c */ 0x4c,/* L - const */
    /* 0x4d */ 0x4d,/* M - const */
    /* 0x4e */ 0x4e,/* N - const */
    /* 0x4f */ 0x4f,/* O - const */
    /* 0x50 */ 0x50,/* P - const */
    /* 0x51 */ 0x51,/* Q - const */
    /* 0x52 */ 0x52,/* R - const */
    /* 0x53 */ 0x53,/* S - const */
    /* 0x54 */ 0x54,/* T - const */
    /* 0x55 */ 0x55,/* U - const */
    /* 0x56 */ 0x56,/* V - const */
    /* 0x57 */ 0x57,/* W - const */
    /* 0x58 */ 0x58,/* X - const */
    /* 0x59 */ 0x59,/* Y - const */
    /* 0x5a */ 0x5a,/* Z - const */
    /* 0x5b */ 0x5b,/* [ - const */
    /* 0x5c */ 0x5c,/* \ - const */
    /* 0x5d */ 0x5d,/* ] - const */
    /* 0x5e */ 0x5e,/* ^ - const */
    /* 0x5f */ 0x5f,/* _ - const */
    /* 0x60 */ 0x60,/* ` - const */
    /* 0x61 */ 0x61,/* a - const */
    /* 0x62 */ 0x62,/* b - const */
    /* 0x63 */ 0x63,/* c - const */
    /* 0x64 */ 0x64,/* d - const */
    /* 0x65 */ 0x65,/* e - const */
    /* 0x66 */ 0x66,/* f - const */
    /* 0x67 */ 0x67,/* g - const */
    /* 0x68 */ 0x68,/* h - const */
    /* 0x69 */ 0x69,/* i - const */
    /* 0x6a */ 0x6a,/* j - const */
    /* 0x6b */ 0x6b,/* k - const */
    /* 0x6c */ 0x6c,/* l - const */
    /* 0x6d */ 0x6d,/* m - const */
    /* 0x6e */ 0x6e,/* n - const */
    /* 0x6f */ 0x6f,/* o - const */
    /* 0x70 */ 0x70,/* p - const */
    /* 0x71 */ 0x71,/* q - const */
    /* 0x72 */ 0x72,/* r - const */
    /* 0x73 */ 0x73,/* s - const */
    /* 0x74 */ 0x74,/* t - const */
    /* 0x75 */ 0x75,/* u - const */
    /* 0x76 */ 0x76,/* v - const */
    /* 0x77 */ 0x77,/* w - const */
    /* 0x78 */ 0x78,/* x - const */
    /* 0x79 */ 0x79,/* y - const */
    /* 0x7a */ 0x7a,/* z - const */
    /* 0x7b */ 0x7b,/* { - const */
    /* 0x7c */ 0x7c,/* | - const */
    /* 0x7d */ 0x7d,/* } - const */
    /* 0x7e */ 0x7e,/* ~ - const */
    /* 0x7f */ 0x7f,/* ? - const */
    /* 0x80 */ 0xe1,/* A */
    /* 0x81 */ 0xe2,/* B */
    /* 0x82 */ 0xf7,/* V */
    /* 0x83 */ 0xe7,/* G */
    /* 0x84 */ 0xe4,/* D */
    /* 0x85 */ 0xe5,/* E */
    /* 0x86 */ 0xf6,/* Zh */
    /* 0x87 */ 0xfa,/* Z */
    /* 0x88 */ 0xe9,/* I */
    /* 0x89 */ 0xea,/* Y */
    /* 0x8a */ 0xeb,/* K */
    /* 0x8b */ 0xec,/* L */
    /* 0x8c */ 0xed,/* M */
    /* 0x8d */ 0xee,/* N */
    /* 0x8e */ 0xef,/* O */
    /* 0x8f */ 0xf0,/* P */
    /* 0x90 */ 0xf2,/* R */
    /* 0x91 */ 0xf3,/* S */
    /* 0x92 */ 0xf4,/* T */
    /* 0x93 */ 0xf5,/* U */
    /* 0x94 */ 0xe6,/* F */
    /* 0x95 */ 0xe8,/* Kh */
    /* 0x96 */ 0xe3,/* Cz */
    /* 0x97 */ 0xfe,/* Ch */
    /* 0x98 */ 0xfb,/* Sh */
    /* 0x99 */ 0xfd,/* Sch */
    /* 0x9a */ 0xff,/* ` */
    /* 0x9b */ 0xf9,/* Y */
    /* 0x9c */ 0xf8,/* ' */
    /* 0x9d */ 0xfc,/* E */
    /* 0x9e */ 0xe0,/* Yu */
    /* 0x9f */ 0xf1,/* Ya */
    /* 0xa0 */ 0x8a,/* ? */
    /* 0xa1 */ 0x9c,/* circ */
    /* 0xa2 */ 0x3f,/* c */
    /* 0xa3 */ 0x3f,/* L */
    /* 0xa4 */ 0x15,/* , // */
    /* 0xa5 */ 0x07,/* ? */
    /* 0xa6 */ 0x14,/* p */
    /* 0xa7 */ 0x3f,/* I */
    /* 0xa8 */ 0x52,/* (R) */
    /* 0xa9 */ 0xbf,/* (C) */
    /* 0xaa */ 0x54,/* ? */
    /* 0xab */ 0x3f,/* h */
    /* 0xac */ 0x3f,/* h */
    /* 0xad */ 0x3f,/* ? */
    /* 0xae */ 0x3f,/* G' */
    /* 0xaf */ 0x3f,/* g' */
    /* 0xb0 */ 0x3f,/* ? */
    /* 0xb1 */ 0x2b,/* +- */
    /* 0xb2 */ 0x98,/* ? */
    /* 0xb3 */ 0x99,/* ? */
    /* 0xb4 */ 0x3f,/* i */
    /* 0xb5 */ 0xde,/* mu */
    /* 0xb6 */ 0x3f,/* ? */
    /* 0xb7 */ 0x3f,/* J */
    /* 0xb8 */ 0x3f,/* E */
    /* 0xb9 */ 0x3f,/* e */
    /* 0xba */ 0x3f,/* I */
    /* 0xbb */ 0x3f,/* i */
    /* 0xbc */ 0x3f,/* L' */
    /* 0xbd */ 0x3f,/* l' */
    /* 0xbe */ 0x3f,/* H' */
    /* 0xbf */ 0x3f,/* n' */
    /* 0xc0 */ 0x3f,/* j */
    /* 0xc1 */ 0x3f,/* S */
    /* 0xc2 */ 0x83,/* ^ */
    /* 0xc3 */ 0x96,/* ? */
    /* 0xc4 */ 0x3f,/* ? */
    /* 0xc5 */ 0x97,/* ? */
    /* 0xc6 */ 0x3f,/* ? */
    /* 0xc7 */ 0x27,/* " */
    /* 0xc8 */ 0x27,/* " */
    /* 0xc9 */ 0x3a,/* ? */
    /* 0xca */ 0x9a,/*  */
    /* 0xcb */ 0x3f,/* h */
    /* 0xcc */ 0x3f,/* h */
    /* 0xcd */ 0x3f,/* K' */
    /* 0xce */ 0x3f,/* k' */
    /* 0xcf */ 0x3f,/* s */
    /* 0xd0 */ 0x2d,/* ? */
    /* 0xd1 */ 0x2d,/* ? */
    /* 0xd2 */ 0x27,/* ? */
    /* 0xd3 */ 0x27,/* ? */
    /* 0xd4 */ 0x27,/* ? */
    /* 0xd5 */ 0x27,/* ? */
    /* 0xd6 */ 0x9f,/* / */
    /* 0xd7 */ 0x27,/* ? */
    /* 0xd8 */ 0x3f,/* U~ */
    /* 0xd9 */ 0x3f,/* y^ */
    /* 0xda */ 0x3f,/* Cz, */
    /* 0xdb */ 0x3f,/* cz, */
    /* 0xdc */ 0x3f,/* ? */
    /* 0xdd */ 0xb3,/* E */
    /* 0xde */ 0xa3,/* e */
    /* 0xdf */ 0xd1,/* ya */
    /* 0xe0 */ 0xc1,/* a */
    /* 0xe1 */ 0xc2,/* b */
    /* 0xe2 */ 0xd7,/* v */
    /* 0xe3 */ 0xc7,/* g */
    /* 0xe4 */ 0xc4,/* d */
    /* 0xe5 */ 0xc5,/* e */
    /* 0xe6 */ 0xd6,/* zh */
    /* 0xe7 */ 0xda,/* z */
    /* 0xe8 */ 0xc9,/* i */
    /* 0xe9 */ 0xca,/* y */
    /* 0xea */ 0xcb,/* k */
    /* 0xeb */ 0xcc,/* l */
    /* 0xec */ 0xcd,/* m */
    /* 0xed */ 0xce,/* n */
    /* 0xee */ 0xcf,/* o */
    /* 0xef */ 0xd0,/* p */
    /* 0xf0 */ 0xd2,/* r */
    /* 0xf1 */ 0xd3,/* s */
    /* 0xf2 */ 0xd4,/* t */
    /* 0xf3 */ 0xd5,/* u */
    /* 0xf4 */ 0xc6,/* f */
    /* 0xf5 */ 0xc8,/* kh */
    /* 0xf6 */ 0xc3,/* cz */
    /* 0xf7 */ 0xde,/* ch */
    /* 0xf8 */ 0xdb,/* sh */
    /* 0xf9 */ 0xdd,/* sch */
    /* 0xfa */ 0xdf,/* ` */
    /* 0xfb */ 0xd9,/* y */
    /* 0xfc */ 0xd8,/* ' */
    /* 0xfd */ 0xdc,/* e */
    /* 0xfe */ 0xc0,/* yu */
    /* 0xff */ 0x3f,/* ? */
};

static char tab_win[256] =
{
   /* ######################################################################## */
   /* # win-koi.tab */
   /* # Windows-1251 -> KOI8-R recoding table for Russian Apache */
   /* # by Dmitry A. Pashko (dap@stack.net) */
   /* ######################################################################## */

               0x00,
    /* 0x01 */ 0x01,/* ? - const */
    /* 0x02 */ 0x02,/* ? - const */
    /* 0x03 */ 0x03,/* ? - const */
    /* 0x04 */ 0x04,/* ? - const */
    /* 0x05 */ 0x05,/* ? - const */
    /* 0x06 */ 0x06,/* ? - const */
    /* 0x07 */ 0x07,/* ? - const */
    /* 0x08 */ 0x08,/* ? - const */
    /* 0x09 */ 0x09,/* ? - const */
    /* 0x0a */ 0x0a,/* ? - const */
    /* 0x0b */ 0x0b,/* ? - const */
    /* 0x0c */ 0x0c,/* ? - const */
    /* 0x0d */ 0x0d,/* ? - const */
    /* 0x0e */ 0x0e,/* ? - const */
    /* 0x0f */ 0x0f,/* ? - const */
    /* 0x10 */ 0x10,/* ? - const */
    /* 0x11 */ 0x11,/* ? - const */
    /* 0x12 */ 0x12,/* ? - const */
    /* 0x13 */ 0x13,/* ? - const */
    /* 0x14 */ 0x14,/* ? - const */
    /* 0x15 */ 0x15,/* ? - const */
    /* 0x16 */ 0x16,/* ? - const */
    /* 0x17 */ 0x17,/* ? - const */
    /* 0x18 */ 0x18,/* ? - const */
    /* 0x19 */ 0x19,/* ? - const */
    /* 0x1a */ 0x1a,/* ? - const */
    /* 0x1b */ 0x1b,/* ? - const */
    /* 0x1c */ 0x1c,/* ? - const */
    /* 0x1d */ 0x1d,/* ? - const */
    /* 0x1e */ 0x1e,/* ? - const */
    /* 0x1f */ 0x1f,/* ? - const */
    /* 0x20 */ 0x20,/*   - const */
    /* 0x21 */ 0x21,/* ! - const */
    /* 0x22 */ 0x22,/* " - const */
    /* 0x23 */ 0x23,/* , // - const */
    /* 0x24 */ 0x24,/* $ - const */
    /* 0x25 */ 0x25,/* % - const */
    /* 0x26 */ 0x26,/* & - const */
    /* 0x27 */ 0x27,/* ' - const */
    /* 0x28 */ 0x28,/* ( - const */
    /* 0x29 */ 0x29,/* ) - const */
    /* 0x2a */ 0x2a,/* * - const */
    /* 0x2b */ 0x2b,/* + - const */
    /* 0x2c */ 0x2c,/* , - const */
    /* 0x2d */ 0x2d,/* - - const */
    /* 0x2e */ 0x2e,/* . - const */
    /* 0x2f */ 0x2f,/* / - const */
    /* 0x30 */ 0x30,/* 0 - const */
    /* 0x31 */ 0x31,/* 1 - const */
    /* 0x32 */ 0x32,/* 2 - const */
    /* 0x33 */ 0x33,/* 3 - const */
    /* 0x34 */ 0x34,/* 4 - const */
    /* 0x35 */ 0x35,/* 5 - const */
    /* 0x36 */ 0x36,/* 6 - const */
    /* 0x37 */ 0x37,/* 7 - const */
    /* 0x38 */ 0x38,/* 8 - const */
    /* 0x39 */ 0x39,/* 9 - const */
    /* 0x3a */ 0x3a,/* : - const */
    /* 0x3b */ 0x3b,/* ; - const */
    /* 0x3c */ 0x3c,/* < - const */
    /* 0x3d */ 0x3d,/* = - const */
    /* 0x3e */ 0x3e,/* > - const */
    /* 0x3f */ 0x3f,/* ? - const */
    /* 0x40 */ 0x40,/* @ - const */
    /* 0x41 */ 0x41,/* A - const */
    /* 0x42 */ 0x42,/* B - const */
    /* 0x43 */ 0x43,/* C - const */
    /* 0x44 */ 0x44,/* D - const */
    /* 0x45 */ 0x45,/* E - const */
    /* 0x46 */ 0x46,/* F - const */
    /* 0x47 */ 0x47,/* G - const */
    /* 0x48 */ 0x48,/* H - const */
    /* 0x49 */ 0x49,/* I - const */
    /* 0x4a */ 0x4a,/* J - const */
    /* 0x4b */ 0x4b,/* K - const */
    /* 0x4c */ 0x4c,/* L - const */
    /* 0x4d */ 0x4d,/* M - const */
    /* 0x4e */ 0x4e,/* N - const */
    /* 0x4f */ 0x4f,/* O - const */
    /* 0x50 */ 0x50,/* P - const */
    /* 0x51 */ 0x51,/* Q - const */
    /* 0x52 */ 0x52,/* R - const */
    /* 0x53 */ 0x53,/* S - const */
    /* 0x54 */ 0x54,/* T - const */
    /* 0x55 */ 0x55,/* U - const */
    /* 0x56 */ 0x56,/* V - const */
    /* 0x57 */ 0x57,/* W - const */
    /* 0x58 */ 0x58,/* X - const */
    /* 0x59 */ 0x59,/* Y - const */
    /* 0x5a */ 0x5a,/* Z - const */
    /* 0x5b */ 0x5b,/* [ - const */
    /* 0x5c */ 0x5c,/* \ - const */
    /* 0x5d */ 0x5d,/* ] - const */
    /* 0x5e */ 0x5e,/* ^ - const */
    /* 0x5f */ 0x5f,/* _ - const */
    /* 0x60 */ 0x60,/* ` - const */
    /* 0x61 */ 0x61,/* a - const */
    /* 0x62 */ 0x62,/* b - const */
    /* 0x63 */ 0x63,/* c - const */
    /* 0x64 */ 0x64,/* d - const */
    /* 0x65 */ 0x65,/* e - const */
    /* 0x66 */ 0x66,/* f - const */
    /* 0x67 */ 0x67,/* g - const */
    /* 0x68 */ 0x68,/* h - const */
    /* 0x69 */ 0x69,/* i - const */
    /* 0x6a */ 0x6a,/* j - const */
    /* 0x6b */ 0x6b,/* k - const */
    /* 0x6c */ 0x6c,/* l - const */
    /* 0x6d */ 0x6d,/* m - const */
    /* 0x6e */ 0x6e,/* n - const */
    /* 0x6f */ 0x6f,/* o - const */
    /* 0x70 */ 0x70,/* p - const */
    /* 0x71 */ 0x71,/* q - const */
    /* 0x72 */ 0x72,/* r - const */
    /* 0x73 */ 0x73,/* s - const */
    /* 0x74 */ 0x74,/* t - const */
    /* 0x75 */ 0x75,/* u - const */
    /* 0x76 */ 0x76,/* v - const */
    /* 0x77 */ 0x77,/* w - const */
    /* 0x78 */ 0x78,/* x - const */
    /* 0x79 */ 0x79,/* y - const */
    /* 0x7a */ 0x7a,/* z - const */
    /* 0x7b */ 0x7b,/* { - const */
    /* 0x7c */ 0x7c,/* | - const */
    /* 0x7d */ 0x7d,/* } - const */
    /* 0x7e */ 0x7e,/* ~ - const */
    /* 0x7f */ 0x7f,/* ? - const */
    /* 0x80 */ 0x3f,/* h */
    /* 0x81 */ 0x3f,/* G' */
    /* 0x82 */ 0x27,/* ? */
    /* 0x83 */ 0x3f,/* g' */
    /* 0x84 */ 0x27,/* ? */
    /* 0x85 */ 0x3a,/* ? */
    /* 0x86 */ 0x8a,/* ? */
    /* 0x87 */ 0xbc,/* ? */
    /* 0x88 */ 0x3f,/* ? */
    /* 0x89 */ 0x25,/* ? */
    /* 0x8a */ 0x3f,/* L' */
    /* 0x8b */ 0x27,/* ? */
    /* 0x8c */ 0x3f,/* H' */
    /* 0x8d */ 0x3f,/* K' */
    /* 0x8e */ 0x3f,/* h */
    /* 0x8f */ 0x3f,/* Cz, */
    /* 0x90 */ 0x3f,/* h */
    /* 0x91 */ 0x27,/* ? */
    /* 0x92 */ 0x27,/* ? */
    /* 0x93 */ 0x27,/* ? */
    /* 0x94 */ 0x27,/* ? */
    /* 0x95 */ 0x07,/* ? */
    /* 0x96 */ 0x2d,/* ? */
    /* 0x97 */ 0x2d,/* ? */
    /* 0x98 */ 0x3f,/* ? */
    /* 0x99 */ 0x54,/* ? */
    /* 0x9a */ 0x3f,/* l' */
    /* 0x9b */ 0x27,/* ? */
    /* 0x9c */ 0x3f,/* n' */
    /* 0x9d */ 0x3f,/* k' */
    /* 0x9e */ 0x3f,/* h */
    /* 0x9f */ 0x3f,/* cz, */
    /* 0xa0 */ 0x20,/* nonbreaking space */
    /* 0xa1 */ 0x3f,/* U~ */
    /* 0xa2 */ 0x3f,/* y^ */
    /* 0xa3 */ 0x3f,/* J */
    /* 0xa4 */ 0x3f,/* ? */
    /* 0xa5 */ 0x3f,/* ? */
    /* 0xa6 */ 0x81,/* | */
    /* 0xa7 */ 0x15,/* , // */
    /* 0xa8 */ 0xb3,/* E */
    /* 0xa9 */ 0xbf,/* (C) */
    /* 0xaa */ 0x3f,/* E */
    /* 0xab */ 0x27,/* " */
    /* 0xac */ 0x83,/* ^ */
    /* 0xad */ 0x2d,/* - */
    /* 0xae */ 0x52,/* (R) */
    /* 0xaf */ 0x3f,/* I */
    /* 0xb0 */ 0x9c,/* circ */
    /* 0xb1 */ 0x2b,/* +- */
    /* 0xb2 */ 0x3f,/* I */
    /* 0xb3 */ 0x3f,/* i */
    /* 0xb4 */ 0x3f,/* ? */
    /* 0xb5 */ 0xde,/* mu */
    /* 0xb6 */ 0x14,/* p */
    /* 0xb7 */ 0x9e,/* . */
    /* 0xb8 */ 0xa3,/* e */
    /* 0xb9 */ 0x3f,/* ? */
    /* 0xba */ 0x3f,/* e */
    /* 0xbb */ 0x27,/* " */
    /* 0xbc */ 0x3f,/* j */
    /* 0xbd */ 0x3f,/* S */
    /* 0xbe */ 0x3f,/* s */
    /* 0xbf */ 0x3f,/* i */
    /* 0xc0 */ 0xe1,/* A */
    /* 0xc1 */ 0xe2,/* B */
    /* 0xc2 */ 0xf7,/* V */
    /* 0xc3 */ 0xe7,/* G */
    /* 0xc4 */ 0xe4,/* D */
    /* 0xc5 */ 0xe5,/* E */
    /* 0xc6 */ 0xf6,/* Zh */
    /* 0xc7 */ 0xfa,/* Z */
    /* 0xc8 */ 0xe9,/* I */
    /* 0xc9 */ 0xea,/* Y */
    /* 0xca */ 0xeb,/* K */
    /* 0xcb */ 0xec,/* L */
    /* 0xcc */ 0xed,/* M */
    /* 0xcd */ 0xee,/* N */
    /* 0xce */ 0xef,/* O */
    /* 0xcf */ 0xf0,/* P */
    /* 0xd0 */ 0xf2,/* R */
    /* 0xd1 */ 0xf3,/* S */
    /* 0xd2 */ 0xf4,/* T */
    /* 0xd3 */ 0xf5,/* U */
    /* 0xd4 */ 0xe6,/* F */
    /* 0xd5 */ 0xe8,/* Kh */
    /* 0xd6 */ 0xe3,/* Cz */
    /* 0xd7 */ 0xfe,/* Ch */
    /* 0xd8 */ 0xfb,/* Sh */
    /* 0xd9 */ 0xfd,/* Sch */
    /* 0xda */ 0xff,/* ` */
    /* 0xdb */ 0xf9,/* Y */
    /* 0xdc */ 0xf8,/* ' */
    /* 0xdd */ 0xfc,/* E */
    /* 0xde */ 0xe0,/* Yu */
    /* 0xdf */ 0xf1,/* Ya */
    /* 0xe0 */ 0xc1,/* a */
    /* 0xe1 */ 0xc2,/* b */
    /* 0xe2 */ 0xd7,/* v */
    /* 0xe3 */ 0xc7,/* g */
    /* 0xe4 */ 0xc4,/* d */
    /* 0xe5 */ 0xc5,/* e */
    /* 0xe6 */ 0xd6,/* zh */
    /* 0xe7 */ 0xda,/* z */
    /* 0xe8 */ 0xc9,/* i */
    /* 0xe9 */ 0xca,/* y */
    /* 0xea */ 0xcb,/* k */
    /* 0xeb */ 0xcc,/* l */
    /* 0xec */ 0xcd,/* m */
    /* 0xed */ 0xce,/* n */
    /* 0xee */ 0xcf,/* o */
    /* 0xef */ 0xd0,/* p */
    /* 0xf0 */ 0xd2,/* r */
    /* 0xf1 */ 0xd3,/* s */
    /* 0xf2 */ 0xd4,/* t */
    /* 0xf3 */ 0xd5,/* u */
    /* 0xf4 */ 0xc6,/* f */
    /* 0xf5 */ 0xc8,/* kh */
    /* 0xf6 */ 0xc3,/* cz */
    /* 0xf7 */ 0xde,/* ch */
    /* 0xf8 */ 0xdb,/* sh */
    /* 0xf9 */ 0xdd,/* sch */
    /* 0xfa */ 0xdf,/* ` */
    /* 0xfb */ 0xd9,/* y */
    /* 0xfc */ 0xd8,/* ' */
    /* 0xfd */ 0xdc,/* e */
    /* 0xfe */ 0xc0,/* yu */
    /* 0xff */ 0xd1,/* ya */
};

static char tab_koi_win[256] =
{
   /* ######################################################################## */
   /* # koi-win.tab */
   /* # KOI8-R -> Windows-1251 recoding table for Russian Apache */
   /* # by Dmitry A. Pashko (dap@stack.net) */
   /* ######################################################################## */
               0x00,
    /* 0x01 */ 0x01,/* ? - const */
    /* 0x02 */ 0x02,/* ? - const */
    /* 0x03 */ 0x03,/* ? - const */
    /* 0x04 */ 0x04,/* ? - const */
    /* 0x05 */ 0x05,/* ? - const */
    /* 0x06 */ 0x06,/* ? - const */
    /* 0x07 */ 0x07,/* ? - const */
    /* 0x08 */ 0x08,/* ? - const */
    /* 0x09 */ 0x09,/* ? - const */
    /* 0x0a */ 0x0a,/* ? - const */
    /* 0x0b */ 0x0b,/* ? - const */
    /* 0x0c */ 0x0c,/* ? - const */
    /* 0x0d */ 0x0d,/* ? - const */
    /* 0x0e */ 0x0e,/* ? - const */
    /* 0x0f */ 0x0f,/* ? - const */
    /* 0x10 */ 0x10,/* ? - const */
    /* 0x11 */ 0x11,/* ? - const */
    /* 0x12 */ 0x12,/* ? - const */
    /* 0x13 */ 0x13,/* ? - const */
    /* 0x14 */ 0x14,/* ? - const */
    /* 0x15 */ 0x15,/* ? - const */
    /* 0x16 */ 0x16,/* ? - const */
    /* 0x17 */ 0x17,/* ? - const */
    /* 0x18 */ 0x18,/* ? - const */
    /* 0x19 */ 0x19,/* ? - const */
    /* 0x1a */ 0x1a,/* ? - const */
    /* 0x1b */ 0x1b,/* ? - const */
    /* 0x1c */ 0x1c,/* ? - const */
    /* 0x1d */ 0x1d,/* ? - const */
    /* 0x1e */ 0x1e,/* ? - const */
    /* 0x1f */ 0x1f,/* ? - const */
    /* 0x20 */ 0x20,/*   - const */
    /* 0x21 */ 0x21,/* ! - const */
    /* 0x22 */ 0x22,/* " - const */
    /* 0x23 */ 0x23,/* # - const */
    /* 0x24 */ 0x24,/* $ - const */
    /* 0x25 */ 0x25,/* % - const */
    /* 0x26 */ 0x26,/* & - const */
    /* 0x27 */ 0x27,/* ' - const */
    /* 0x28 */ 0x28,/* ( - const */
    /* 0x29 */ 0x29,/* ) - const */
    /* 0x2a */ 0x2a,/* * - const */
    /* 0x2b */ 0x2b,/* + - const */
    /* 0x2c */ 0x2c,/* , - const */
    /* 0x2d */ 0x2d,/* - - const */
    /* 0x2e */ 0x2e,/* . - const */
    /* 0x2f */ 0x2f,/* / - const */
    /* 0x30 */ 0x30,/* 0 - const */
    /* 0x31 */ 0x31,/* 1 - const */
    /* 0x32 */ 0x32,/* 2 - const */
    /* 0x33 */ 0x33,/* 3 - const */
    /* 0x34 */ 0x34,/* 4 - const */
    /* 0x35 */ 0x35,/* 5 - const */
    /* 0x36 */ 0x36,/* 6 - const */
    /* 0x37 */ 0x37,/* 7 - const */
    /* 0x38 */ 0x38,/* 8 - const */
    /* 0x39 */ 0x39,/* 9 - const */
    /* 0x3a */ 0x3a,/* : - const */
    /* 0x3b */ 0x3b,/* ; - const */
    /* 0x3c */ 0x3c,/* < - const */
    /* 0x3d */ 0x3d,/* = - const */
    /* 0x3e */ 0x3e,/* > - const */
    /* 0x3f */ 0x3f,/* ? - const */
    /* 0x40 */ 0x40,/* @ - const */
    /* 0x41 */ 0x41,/* A - const */
    /* 0x42 */ 0x42,/* B - const */
    /* 0x43 */ 0x43,/* C - const */
    /* 0x44 */ 0x44,/* D - const */
    /* 0x45 */ 0x45,/* E - const */
    /* 0x46 */ 0x46,/* F - const */
    /* 0x47 */ 0x47,/* G - const */
    /* 0x48 */ 0x48,/* H - const */
    /* 0x49 */ 0x49,/* I - const */
    /* 0x4a */ 0x4a,/* J - const */
    /* 0x4b */ 0x4b,/* K - const */
    /* 0x4c */ 0x4c,/* L - const */
    /* 0x4d */ 0x4d,/* M - const */
    /* 0x4e */ 0x4e,/* N - const */
    /* 0x4f */ 0x4f,/* O - const */
    /* 0x50 */ 0x50,/* P - const */
    /* 0x51 */ 0x51,/* Q - const */
    /* 0x52 */ 0x52,/* R - const */
    /* 0x53 */ 0x53,/* S - const */
    /* 0x54 */ 0x54,/* T - const */
    /* 0x55 */ 0x55,/* U - const */
    /* 0x56 */ 0x56,/* V - const */
    /* 0x57 */ 0x57,/* W - const */
    /* 0x58 */ 0x58,/* X - const */
    /* 0x59 */ 0x59,/* Y - const */
    /* 0x5a */ 0x5a,/* Z - const */
    /* 0x5b */ 0x5b,/* [ - const */
    /* 0x5c */ 0x5c,/* \ - const */
    /* 0x5d */ 0x5d,/* ] - const */
    /* 0x5e */ 0x5e,/* ^ - const */
    /* 0x5f */ 0x5f,/* _ - const */
    /* 0x60 */ 0x60,/* ` - const */
    /* 0x61 */ 0x61,/* a - const */
    /* 0x62 */ 0x62,/* b - const */
    /* 0x63 */ 0x63,/* c - const */
    /* 0x64 */ 0x64,/* d - const */
    /* 0x65 */ 0x65,/* e - const */
    /* 0x66 */ 0x66,/* f - const */
    /* 0x67 */ 0x67,/* g - const */
    /* 0x68 */ 0x68,/* h - const */
    /* 0x69 */ 0x69,/* i - const */
    /* 0x6a */ 0x6a,/* j - const */
    /* 0x6b */ 0x6b,/* k - const */
    /* 0x6c */ 0x6c,/* l - const */
    /* 0x6d */ 0x6d,/* m - const */
    /* 0x6e */ 0x6e,/* n - const */
    /* 0x6f */ 0x6f,/* o - const */
    /* 0x70 */ 0x70,/* p - const */
    /* 0x71 */ 0x71,/* q - const */
    /* 0x72 */ 0x72,/* r - const */
    /* 0x73 */ 0x73,/* s - const */
    /* 0x74 */ 0x74,/* t - const */
    /* 0x75 */ 0x75,/* u - const */
    /* 0x76 */ 0x76,/* v - const */
    /* 0x77 */ 0x77,/* w - const */
    /* 0x78 */ 0x78,/* x - const */
    /* 0x79 */ 0x79,/* y - const */
    /* 0x7a */ 0x7a,/* z - const */
    /* 0x7b */ 0x7b,/* { - const */
    /* 0x7c */ 0x7c,/* | - const */
    /* 0x7d */ 0x7d,/* } - const */
    /* 0x7e */ 0x7e,/* ~ - const */
    /* 0x7f */ 0x7f,/* ? - const */
    /* 0x80 */ 0x2d,/* ? */
    /* 0x81 */ 0xa6,/* ? */
    /* 0x82 */ 0x2d,/* ? */
    /* 0x83 */ 0xac,/* ? */
    /* 0x84 */ 0x4c,/* ? */
    /* 0x85 */ 0x2d,/* ? */
    /* 0x86 */ 0x2b,/* ? */
    /* 0x87 */ 0x2b,/* ? */
    /* 0x88 */ 0x54,/* ? */
    /* 0x89 */ 0x2b,/* ? */
    /* 0x8a */ 0x2b,/* ? */
    /* 0x8b */ 0x2d,/* ? */
    /* 0x8c */ 0x2d,/* ? */
    /* 0x8d */ 0x2d,/* ? */
    /* 0x8e */ 0xa6,/* ? */
    /* 0x8f */ 0xa6,/* ? */
    /* 0x90 */ 0x2d,/* ? */
    /* 0x91 */ 0x2d,/* ? */
    /* 0x92 */ 0x2d,/* ? */
    /* 0x93 */ 0x3f,/* ? */
    /* 0x94 */ 0xa6,/* ? */
    /* 0x95 */ 0x95,/* ? - const */
    /* 0x96 */ 0x76,/* ? */
    /* 0x97 */ 0x3f,/* ? */
    /* 0x98 */ 0x3f,/* ? */
    /* 0x99 */ 0x3f,/* ? */
    /* 0x9a */ 0xa0,/*  */
    /* 0x9b */ 0x3f,/* ? */
    /* 0x9c */ 0xb0,/* circ */
    /* 0x9d */ 0x3f,/* ^2 */
    /* 0x9e */ 0xb7,/* . */
    /* 0x9f */ 0x3f,/* / */
    /* 0xa0 */ 0x3d,/* ? */
    /* 0xa1 */ 0xa6,/* ? */
    /* 0xa2 */ 0x2d,/* ? */
    /* 0xa3 */ 0xb8,/* e */
    /* 0xa4 */ 0xe3,/* ? */
    /* 0xa5 */ 0xe3,/* ? */
    /* 0xa6 */ 0xac,/* ? */
    /* 0xa7 */ 0xac,/* ? */
    /* 0xa8 */ 0xac,/* ? */
    /* 0xa9 */ 0x4c,/* ? */
    /* 0xaa */ 0x4c,/* ? */
    /* 0xab */ 0x4c,/* ? */
    /* 0xac */ 0x2d,/* ? */
    /* 0xad */ 0x2d,/* ? */
    /* 0xae */ 0x2d,/* ? */
    /* 0xaf */ 0xa6,/* ? */
    /* 0xb0 */ 0xa6,/* ? */
    /* 0xb1 */ 0xa6,/* ? */
    /* 0xb2 */ 0xa6,/* ? */
    /* 0xb3 */ 0xa8,/* E */
    /* 0xb4 */ 0xa6,/* ? */
    /* 0xb5 */ 0xa6,/* ? */
    /* 0xb6 */ 0x54,/* ? */
    /* 0xb7 */ 0x54,/* ? */
    /* 0xb8 */ 0x54,/* ? */
    /* 0xb9 */ 0xa6,/* ? */
    /* 0xba */ 0xa6,/* ? */
    /* 0xbb */ 0xa6,/* ? */
    /* 0xbc */ 0x2b,/* ? */
    /* 0xbd */ 0x2b,/* ? */
    /* 0xbe */ 0x2b,/* ? */
    /* 0xbf */ 0xa9,/* (C) */
    /* 0xc0 */ 0xfe,/* yu */
    /* 0xc1 */ 0xe0,/* a */
    /* 0xc2 */ 0xe1,/* b */
    /* 0xc3 */ 0xf6,/* cz */
    /* 0xc4 */ 0xe4,/* d */
    /* 0xc5 */ 0xe5,/* e */
    /* 0xc6 */ 0xf4,/* f */
    /* 0xc7 */ 0xe3,/* g */
    /* 0xc8 */ 0xf5,/* kh */
    /* 0xc9 */ 0xe8,/* i */
    /* 0xca */ 0xe9,/* y */
    /* 0xcb */ 0xea,/* k */
    /* 0xcc */ 0xeb,/* l */
    /* 0xcd */ 0xec,/* m */
    /* 0xce */ 0xed,/* n */
    /* 0xcf */ 0xee,/* o */
    /* 0xd0 */ 0xef,/* p */
    /* 0xd1 */ 0xff,/* ya */
    /* 0xd2 */ 0xf0,/* r */
    /* 0xd3 */ 0xf1,/* s */
    /* 0xd4 */ 0xf2,/* t */
    /* 0xd5 */ 0xf3,/* u */
    /* 0xd6 */ 0xe6,/* zh */
    /* 0xd7 */ 0xe2,/* v */
    /* 0xd8 */ 0xfc,/* ' */
    /* 0xd9 */ 0xfb,/* y */
    /* 0xda */ 0xe7,/* z */
    /* 0xdb */ 0xf8,/* sh */
    /* 0xdc */ 0xfd,/* e */
    /* 0xdd */ 0xf9,/* sch */
    /* 0xde */ 0xf7,/* ch */
    /* 0xdf */ 0xfa,/* ` */
    /* 0xe0 */ 0xde,/* Yu */
    /* 0xe1 */ 0xc0,/* A */
    /* 0xe2 */ 0xc1,/* B */
    /* 0xe3 */ 0xd6,/* Cz */
    /* 0xe4 */ 0xc4,/* D */
    /* 0xe5 */ 0xc5,/* E */
    /* 0xe6 */ 0xd4,/* F */
    /* 0xe7 */ 0xc3,/* G */
    /* 0xe8 */ 0xd5,/* Kh */
    /* 0xe9 */ 0xc8,/* I */
    /* 0xea */ 0xc9,/* Y */
    /* 0xeb */ 0xca,/* K */
    /* 0xec */ 0xcb,/* L */
    /* 0xed */ 0xcc,/* M */
    /* 0xee */ 0xcd,/* N */
    /* 0xef */ 0xce,/* O */
    /* 0xf0 */ 0xcf,/* P */
    /* 0xf1 */ 0xdf,/* Ya */
    /* 0xf2 */ 0xd0,/* R */
    /* 0xf3 */ 0xd1,/* S */
    /* 0xf4 */ 0xd2,/* T */
    /* 0xf5 */ 0xd3,/* U */
    /* 0xf6 */ 0xc6,/* Zh */
    /* 0xf7 */ 0xc2,/* V */
    /* 0xf8 */ 0xdc,/* ' */
    /* 0xf9 */ 0xdb,/* Y */
    /* 0xfa */ 0xc7,/* Z */
    /* 0xfb */ 0xd8,/* Sh */
    /* 0xfc */ 0xdd,/* E */
    /* 0xfd */ 0xd9,/* Sch */
    /* 0xfe */ 0xd7,/* Ch */
    /* 0xff */ 0xda,/* ` */
};

static char tab_koi_alt[256] =
{
   /* ######################################################################## */
   /* # koi-dos.tab */
   /* # KOI8-R -> cp866 recoding table for Russian Apache */
   /* # by Dmitry A. Pashko (dap@stack.net) */
   /* ######################################################################## */
               0x00,
    /* 0x01 */ 0x01,/* # ? - const */
    /* 0x02 */ 0x02,/* # ? - const */
    /* 0x03 */ 0x03,/* # ? - const */
    /* 0x04 */ 0x04,/* # ? - const */
    /* 0x05 */ 0x05,/* # ? - const */
    /* 0x06 */ 0x06,/* # ? - const */
    /* 0x07 */ 0x07,/* # ? - const */
    /* 0x08 */ 0x08,/* # ? - const */
    /* 0x09 */ 0x09,/* # ? - const */
    /* 0x0a */ 0x0a,/* # ? - const */
    /* 0x0b */ 0x0b,/* # ? - const */
    /* 0x0c */ 0x0c,/* # ? - const */
    /* 0x0d */ 0x0d,/* # ? - const */
    /* 0x0e */ 0x0e,/* # ? - const */
    /* 0x0f */ 0x0f,/* # ? - const */
    /* 0x10 */ 0x10,/* # ? - const */
    /* 0x11 */ 0x11,/* # ? - const */
    /* 0x12 */ 0x12,/* # ? - const */
    /* 0x13 */ 0x13,/* # ? - const */
    /* 0x14 */ 0x14,/* # ? - const */
    /* 0x15 */ 0x15,/* # ? - const */
    /* 0x16 */ 0x16,/* # ? - const */
    /* 0x17 */ 0x17,/* # ? - const */
    /* 0x18 */ 0x18,/* # ? - const */
    /* 0x19 */ 0x19,/* # ? - const */
    /* 0x1a */ 0x1a,/* # ? - const */
    /* 0x1b */ 0x1b,/* # ? - const */
    /* 0x1c */ 0x1c,/* # ? - const */
    /* 0x1d */ 0x1d,/* # ? - const */
    /* 0x1e */ 0x1e,/* # ? - const */
    /* 0x1f */ 0x1f,/* # ? - const */
    /* 0x20 */ 0x20,/* #   - const */
    /* 0x21 */ 0x21,/* # ! - const */
    /* 0x22 */ 0x22,/* # " - const */
    /* 0x23 */ 0x23,/* # # - const */
    /* 0x24 */ 0x24,/* # $ - const */
    /* 0x25 */ 0x25,/* # % - const */
    /* 0x26 */ 0x26,/* # & - const */
    /* 0x27 */ 0x27,/* # ' - const */
    /* 0x28 */ 0x28,/* # ( - const */
    /* 0x29 */ 0x29,/* # ) - const */
    /* 0x2a */ 0x2a,/* # * - const */
    /* 0x2b */ 0x2b,/* # + - const */
    /* 0x2c */ 0x2c,/* # , - const */
    /* 0x2d */ 0x2d,/* # - - const */
    /* 0x2e */ 0x2e,/* # . - const */
    /* 0x2f */ 0x2f,/* # / - const */
    /* 0x30 */ 0x30,/* # 0 - const */
    /* 0x31 */ 0x31,/* # 1 - const */
    /* 0x32 */ 0x32,/* # 2 - const */
    /* 0x33 */ 0x33,/* # 3 - const */
    /* 0x34 */ 0x34,/* # 4 - const */
    /* 0x35 */ 0x35,/* # 5 - const */
    /* 0x36 */ 0x36,/* # 6 - const */
    /* 0x37 */ 0x37,/* # 7 - const */
    /* 0x38 */ 0x38,/* # 8 - const */
    /* 0x39 */ 0x39,/* # 9 - const */
    /* 0x3a */ 0x3a,/* # : - const */
    /* 0x3b */ 0x3b,/* # ; - const */
    /* 0x3c */ 0x3c,/* # < - const */
    /* 0x3d */ 0x3d,/* # = - const */
    /* 0x3e */ 0x3e,/* # > - const */
    /* 0x3f */ 0x3f,/* # ? - const */
    /* 0x40 */ 0x40,/* # @ - const */
    /* 0x41 */ 0x41,/* # A - const */
    /* 0x42 */ 0x42,/* # B - const */
    /* 0x43 */ 0x43,/* # C - const */
    /* 0x44 */ 0x44,/* # D - const */
    /* 0x45 */ 0x45,/* # E - const */
    /* 0x46 */ 0x46,/* # F - const */
    /* 0x47 */ 0x47,/* # G - const */
    /* 0x48 */ 0x48,/* # H - const */
    /* 0x49 */ 0x49,/* # I - const */
    /* 0x4a */ 0x4a,/* # J - const */
    /* 0x4b */ 0x4b,/* # K - const */
    /* 0x4c */ 0x4c,/* # L - const */
    /* 0x4d */ 0x4d,/* # M - const */
    /* 0x4e */ 0x4e,/* # N - const */
    /* 0x4f */ 0x4f,/* # O - const */
    /* 0x50 */ 0x50,/* # P - const */
    /* 0x51 */ 0x51,/* # Q - const */
    /* 0x52 */ 0x52,/* # R - const */
    /* 0x53 */ 0x53,/* # S - const */
    /* 0x54 */ 0x54,/* # T - const */
    /* 0x55 */ 0x55,/* # U - const */
    /* 0x56 */ 0x56,/* # V - const */
    /* 0x57 */ 0x57,/* # W - const */
    /* 0x58 */ 0x58,/* # X - const */
    /* 0x59 */ 0x59,/* # Y - const */
    /* 0x5a */ 0x5a,/* # Z - const */
    /* 0x5b */ 0x5b,/* # [ - const */
    /* 0x5c */ 0x5c,/* # \ - const */
    /* 0x5d */ 0x5d,/* # ] - const */
    /* 0x5e */ 0x5e,/* # ^ - const */
    /* 0x5f */ 0x5f,/* # _ - const */
    /* 0x60 */ 0x60,/* # ` - const */
    /* 0x61 */ 0x61,/* # a - const */
    /* 0x62 */ 0x62,/* # b - const */
    /* 0x63 */ 0x63,/* # c - const */
    /* 0x64 */ 0x64,/* # d - const */
    /* 0x65 */ 0x65,/* # e - const */
    /* 0x66 */ 0x66,/* # f - const */
    /* 0x67 */ 0x67,/* # g - const */
    /* 0x68 */ 0x68,/* # h - const */
    /* 0x69 */ 0x69,/* # i - const */
    /* 0x6a */ 0x6a,/* # j - const */
    /* 0x6b */ 0x6b,/* # k - const */
    /* 0x6c */ 0x6c,/* # l - const */
    /* 0x6d */ 0x6d,/* # m - const */
    /* 0x6e */ 0x6e,/* # n - const */
    /* 0x6f */ 0x6f,/* # o - const */
    /* 0x70 */ 0x70,/* # p - const */
    /* 0x71 */ 0x71,/* # q - const */
    /* 0x72 */ 0x72,/* # r - const */
    /* 0x73 */ 0x73,/* # s - const */
    /* 0x74 */ 0x74,/* # t - const */
    /* 0x75 */ 0x75,/* # u - const */
    /* 0x76 */ 0x76,/* # v - const */
    /* 0x77 */ 0x77,/* # w - const */
    /* 0x78 */ 0x78,/* # x - const */
    /* 0x79 */ 0x79,/* # y - const */
    /* 0x7a */ 0x7a,/* # z - const */
    /* 0x7b */ 0x7b,/* # { - const */
    /* 0x7c */ 0x7c,/* # | - const */
    /* 0x7d */ 0x7d,/* # } - const */
    /* 0x7e */ 0x7e,/* # ~ - const */
    /* 0x7f */ 0x7f,/* # ? - const */
    /* 0x80 */ 0xc4,/* # ? */
    /* 0x81 */ 0xb3,/* # ? */
    /* 0x82 */ 0xda,/* # ? */
    /* 0x83 */ 0xbf,/* # ? */
    /* 0x84 */ 0xc0,/* # ? */
    /* 0x85 */ 0xd9,/* # ? */
    /* 0x86 */ 0xc3,/* # ? */
    /* 0x87 */ 0xb4,/* # ? */
    /* 0x88 */ 0xc2,/* # ? */
    /* 0x89 */ 0xc1,/* # ? */
    /* 0x8a */ 0xc5,/* # ? */
    /* 0x8b */ 0xdf,/* # ? */
    /* 0x8c */ 0xdc,/* # ? */
    /* 0x8d */ 0xdb,/* # ? */
    /* 0x8e */ 0xdd,/* # ? */
    /* 0x8f */ 0xde,/* # ? */
    /* 0x90 */ 0xb0,/* # ? */
    /* 0x91 */ 0xb1,/* # ? */
    /* 0x92 */ 0xb2,/* # ? */
    /* 0x93 */ 0x3f,/* # ? */
    /* 0x94 */ 0xfe,/* # ? */
    /* 0x95 */ 0xf9,/* # ? */
    /* 0x96 */ 0xfb,/* # ? */
    /* 0x97 */ 0x3f,/* # ? */
    /* 0x98 */ 0x3f,/* # ? */
    /* 0x99 */ 0x3f,/* # ? */
    /* 0x9a */ 0xff,/* # */
    /* 0x9b */ 0x3f,/* # ? */
    /* 0x9c */ 0xf8,/* # circ */
    /* 0x9d */ 0x3f,/* # ^2 */
    /* 0x9e */ 0xfa,/* # . */
    /* 0x9f */ 0x3f,/* # / */
    /* 0xa0 */ 0xcd,/* # ? */
    /* 0xa1 */ 0xba,/* # ? */
    /* 0xa2 */ 0xd5,/* # ? */
    /* 0xa3 */ 0xf1,/* # e */
    /* 0xa4 */ 0xd6,/* # ? */
    /* 0xa5 */ 0xc9,/* # ? */
    /* 0xa6 */ 0xb8,/* # ? */
    /* 0xa7 */ 0xb7,/* # ? */
    /* 0xa8 */ 0xbb,/* # ? */
    /* 0xa9 */ 0xd4,/* # ? */
    /* 0xaa */ 0xd3,/* # ? */
    /* 0xab */ 0xc8,/* # ? */
    /* 0xac */ 0xbe,/* # ? */
    /* 0xad */ 0xbd,/* # ? */
    /* 0xae */ 0xbc,/* # ? */
    /* 0xaf */ 0xc6,/* # ? */
    /* 0xb0 */ 0xc7,/* # ? */
    /* 0xb1 */ 0xcc,/* # ? */
    /* 0xb2 */ 0xb5,/* # ? */
    /* 0xb3 */ 0xf0,/* # E */
    /* 0xb4 */ 0xb6,/* # ? */
    /* 0xb5 */ 0xb9,/* # ? */
    /* 0xb6 */ 0xd1,/* # ? */
    /* 0xb7 */ 0xd2,/* # ? */
    /* 0xb8 */ 0xcb,/* # ? */
    /* 0xb9 */ 0xcf,/* # ? */
    /* 0xba */ 0xd0,/* # ? */
    /* 0xbb */ 0xca,/* # ? */
    /* 0xbc */ 0xd8,/* # ? */
    /* 0xbd */ 0xd7,/* # ? */
    /* 0xbe */ 0xce,/* # ? */
    /* 0xbf */ 0x63,/* # (C) */
    /* 0xc0 */ 0xee,/* # yu */
    /* 0xc1 */ 0xa0,/* # a */
    /* 0xc2 */ 0xa1,/* # b */
    /* 0xc3 */ 0xe6,/* # cz */
    /* 0xc4 */ 0xa4,/* # d */
    /* 0xc5 */ 0xa5,/* # e */
    /* 0xc6 */ 0xe4,/* # f */
    /* 0xc7 */ 0xa3,/* # g */
    /* 0xc8 */ 0xe5,/* # kh */
    /* 0xc9 */ 0xa8,/* # i */
    /* 0xca */ 0xa9,/* # y */
    /* 0xcb */ 0xaa,/* # k */
    /* 0xcc */ 0xab,/* # l */
    /* 0xcd */ 0xac,/* # m */
    /* 0xce */ 0xad,/* # n */
    /* 0xcf */ 0xae,/* # o */
    /* 0xd0 */ 0xaf,/* # p */
    /* 0xd1 */ 0xef,/* # ya */
    /* 0xd2 */ 0xe0,/* # r */
    /* 0xd3 */ 0xe1,/* # s */
    /* 0xd4 */ 0xe2,/* # t */
    /* 0xd5 */ 0xe3,/* # u */
    /* 0xd6 */ 0xa6,/* # zh */
    /* 0xd7 */ 0xa2,/* # v */
    /* 0xd8 */ 0xec,/* # ' */
    /* 0xd9 */ 0xeb,/* # y */
    /* 0xda */ 0xa7,/* # z */
    /* 0xdb */ 0xe8,/* # sh */
    /* 0xdc */ 0xed,/* # e */
    /* 0xdd */ 0xe9,/* # sch */
    /* 0xde */ 0xe7,/* # ch */
    /* 0xdf */ 0xea,/* # ` */
    /* 0xe0 */ 0x9e,/* # Yu */
    /* 0xe1 */ 0x80,/* # A */
    /* 0xe2 */ 0x81,/* # B */
    /* 0xe3 */ 0x96,/* # Cz */
    /* 0xe4 */ 0x84,/* # D */
    /* 0xe5 */ 0x85,/* # E */
    /* 0xe6 */ 0x94,/* # F */
    /* 0xe7 */ 0x83,/* # G */
    /* 0xe8 */ 0x95,/* # Kh */
    /* 0xe9 */ 0x88,/* # I */
    /* 0xea */ 0x89,/* # Y */
    /* 0xeb */ 0x8a,/* # K */
    /* 0xec */ 0x8b,/* # L */
    /* 0xed */ 0x8c,/* # M */
    /* 0xee */ 0x8d,/* # N */
    /* 0xef */ 0x8e,/* # O */
    /* 0xf0 */ 0x8f,/* # P */
    /* 0xf1 */ 0x9f,/* # Ya */
    /* 0xf2 */ 0x90,/* # R */
    /* 0xf3 */ 0x91,/* # S */
    /* 0xf4 */ 0x92,/* # T */
    /* 0xf5 */ 0x93,/* # U */
    /* 0xf6 */ 0x86,/* # Zh */
    /* 0xf7 */ 0x82,/* # V */
    /* 0xf8 */ 0x9c,/* # ' */
    /* 0xf9 */ 0x9b,/* # Y */
    /* 0xfa */ 0x87,/* # Z */
    /* 0xfb */ 0x98,/* # Sh */
    /* 0xfc */ 0x9d,/* # E */
    /* 0xfd */ 0x99,/* # Sch */
    /* 0xfe */ 0x97,/* # Ch */
    /* 0xff */ 0x9a,/* # ` */
};

static char tab_koi_mac[256] =
{
   /* ######################################################################## */
   /* # koi-mac.tab */
   /* # KOI8-R -> Mac Cyrillic recoding table for Russian Apache */
   /* # by Dmitry A. Pashko (dap@stack.net) */
   /* ######################################################################## */
                0x00,
    /* 0x01 */ 0x01,/* # ? - const */
    /* 0x02 */ 0x02,/* # ? - const */
    /* 0x03 */ 0x03,/* # ? - const */
    /* 0x04 */ 0x04,/* # ? - const */
    /* 0x05 */ 0x05,/* # ? - const */
    /* 0x06 */ 0x06,/* # ? - const */
    /* 0x07 */ 0x07,/* # ? - const */
    /* 0x08 */ 0x08,/* # ? - const */
    /* 0x09 */ 0x09,/* # ? - const */
    /* 0x0a */ 0x0a,/* # ? - const */
    /* 0x0b */ 0x0b,/* # ? - const */
    /* 0x0c */ 0x0c,/* # ? - const */
    /* 0x0d */ 0x0d,/* # ? - const */
    /* 0x0e */ 0x0e,/* # ? - const */
    /* 0x0f */ 0x0f,/* # ? - const */
    /* 0x10 */ 0x10,/* # ? - const */
    /* 0x11 */ 0x11,/* # ? - const */
    /* 0x12 */ 0x12,/* # ? - const */
    /* 0x13 */ 0x13,/* # ? - const */
    /* 0x14 */ 0x14,/* # ? - const */
    /* 0x15 */ 0x15,/* # ? - const */
    /* 0x16 */ 0x16,/* # ? - const */
    /* 0x17 */ 0x17,/* # ? - const */
    /* 0x18 */ 0x18,/* # ? - const */
    /* 0x19 */ 0x19,/* # ? - const */
    /* 0x1a */ 0x1a,/* # ? - const */
    /* 0x1b */ 0x1b,/* # ? - const */
    /* 0x1c */ 0x1c,/* # ? - const */
    /* 0x1d */ 0x1d,/* # ? - const */
    /* 0x1e */ 0x1e,/* # ? - const */
    /* 0x1f */ 0x1f,/* # ? - const */
    /* 0x20 */ 0x20,/* #   - const */
    /* 0x21 */ 0x21,/* # ! - const */
    /* 0x22 */ 0x22,/* # " - const */
    /* 0x23 */ 0x23,/* # # - const */
    /* 0x24 */ 0x24,/* # $ - const */
    /* 0x25 */ 0x25,/* # % - const */
    /* 0x26 */ 0x26,/* # & - const */
    /* 0x27 */ 0x27,/* # ' - const */
    /* 0x28 */ 0x28,/* # ( - const */
    /* 0x29 */ 0x29,/* # ) - const */
    /* 0x2a */ 0x2a,/* # * - const */
    /* 0x2b */ 0x2b,/* # + - const */
    /* 0x2c */ 0x2c,/* # , - const */
    /* 0x2d */ 0x2d,/* # - - const */
    /* 0x2e */ 0x2e,/* # . - const */
    /* 0x2f */ 0x2f,/* # / - const */
    /* 0x30 */ 0x30,/* # 0 - const */
    /* 0x31 */ 0x31,/* # 1 - const */
    /* 0x32 */ 0x32,/* # 2 - const */
    /* 0x33 */ 0x33,/* # 3 - const */
    /* 0x34 */ 0x34,/* # 4 - const */
    /* 0x35 */ 0x35,/* # 5 - const */
    /* 0x36 */ 0x36,/* # 6 - const */
    /* 0x37 */ 0x37,/* # 7 - const */
    /* 0x38 */ 0x38,/* # 8 - const */
    /* 0x39 */ 0x39,/* # 9 - const */
    /* 0x3a */ 0x3a,/* # : - const */
    /* 0x3b */ 0x3b,/* # ; - const */
    /* 0x3c */ 0x3c,/* # < - const */
    /* 0x3d */ 0x3d,/* # = - const */
    /* 0x3e */ 0x3e,/* # > - const */
    /* 0x3f */ 0x3f,/* # ? - const */
    /* 0x40 */ 0x40,/* # @ - const */
    /* 0x41 */ 0x41,/* # A - const */
    /* 0x42 */ 0x42,/* # B - const */
    /* 0x43 */ 0x43,/* # C - const */
    /* 0x44 */ 0x44,/* # D - const */
    /* 0x45 */ 0x45,/* # E - const */
    /* 0x46 */ 0x46,/* # F - const */
    /* 0x47 */ 0x47,/* # G - const */
    /* 0x48 */ 0x48,/* # H - const */
    /* 0x49 */ 0x49,/* # I - const */
    /* 0x4a */ 0x4a,/* # J - const */
    /* 0x4b */ 0x4b,/* # K - const */
    /* 0x4c */ 0x4c,/* # L - const */
    /* 0x4d */ 0x4d,/* # M - const */
    /* 0x4e */ 0x4e,/* # N - const */
    /* 0x4f */ 0x4f,/* # O - const */
    /* 0x50 */ 0x50,/* # P - const */
    /* 0x51 */ 0x51,/* # Q - const */
    /* 0x52 */ 0x52,/* # R - const */
    /* 0x53 */ 0x53,/* # S - const */
    /* 0x54 */ 0x54,/* # T - const */
    /* 0x55 */ 0x55,/* # U - const */
    /* 0x56 */ 0x56,/* # V - const */
    /* 0x57 */ 0x57,/* # W - const */
    /* 0x58 */ 0x58,/* # X - const */
    /* 0x59 */ 0x59,/* # Y - const */
    /* 0x5a */ 0x5a,/* # Z - const */
    /* 0x5b */ 0x5b,/* # [ - const */
    /* 0x5c */ 0x5c,/* # \ - const */
    /* 0x5d */ 0x5d,/* # ] - const */
    /* 0x5e */ 0x5e,/* # ^ - const */
    /* 0x5f */ 0x5f,/* # _ - const */
    /* 0x60 */ 0x60,/* # ` - const */
    /* 0x61 */ 0x61,/* # a - const */
    /* 0x62 */ 0x62,/* # b - const */
    /* 0x63 */ 0x63,/* # c - const */
    /* 0x64 */ 0x64,/* # d - const */
    /* 0x65 */ 0x65,/* # e - const */
    /* 0x66 */ 0x66,/* # f - const */
    /* 0x67 */ 0x67,/* # g - const */
    /* 0x68 */ 0x68,/* # h - const */
    /* 0x69 */ 0x69,/* # i - const */
    /* 0x6a */ 0x6a,/* # j - const */
    /* 0x6b */ 0x6b,/* # k - const */
    /* 0x6c */ 0x6c,/* # l - const */
    /* 0x6d */ 0x6d,/* # m - const */
    /* 0x6e */ 0x6e,/* # n - const */
    /* 0x6f */ 0x6f,/* # o - const */
    /* 0x70 */ 0x70,/* # p - const */
    /* 0x71 */ 0x71,/* # q - const */
    /* 0x72 */ 0x72,/* # r - const */
    /* 0x73 */ 0x73,/* # s - const */
    /* 0x74 */ 0x74,/* # t - const */
    /* 0x75 */ 0x75,/* # u - const */
    /* 0x76 */ 0x76,/* # v - const */
    /* 0x77 */ 0x77,/* # w - const */
    /* 0x78 */ 0x78,/* # x - const */
    /* 0x79 */ 0x79,/* # y - const */
    /* 0x7a */ 0x7a,/* # z - const */
    /* 0x7b */ 0x7b,/* # { - const */
    /* 0x7c */ 0x7c,/* # | - const */
    /* 0x7d */ 0x7d,/* # } - const */
    /* 0x7e */ 0x7e,/* # ~ - const */
    /* 0x7f */ 0x7f,/* # ? - const */
    /* 0x80 */ 0x3f,/* # ? */
    /* 0x81 */ 0x3f,/* # ? */
    /* 0x82 */ 0x3f,/* # ? */
    /* 0x83 */ 0x3f,/* # ? */
    /* 0x84 */ 0x3f,/* # ? */
    /* 0x85 */ 0x3f,/* # ? */
    /* 0x86 */ 0x3f,/* # ? */
    /* 0x87 */ 0x3f,/* # ? */
    /* 0x88 */ 0x3f,/* # ? */
    /* 0x89 */ 0x3f,/* # ? */
    /* 0x8a */ 0x3f,/* # ? */
    /* 0x8b */ 0x3f,/* # ? */
    /* 0x8c */ 0x3f,/* # ? */
    /* 0x8d */ 0x3f,/* # ? */
    /* 0x8e */ 0x3f,/* # ? */
    /* 0x8f */ 0x3f,/* # ? */
    /* 0x90 */ 0x3f,/* # ? */
    /* 0x91 */ 0x3f,/* # ? */
    /* 0x92 */ 0x3f,/* # ? */
    /* 0x93 */ 0x3f,/* # ? */
    /* 0x94 */ 0x3f,/* # ? */
    /* 0x95 */ 0x3f,/* # ? */
    /* 0x96 */ 0xc3,/* # ? */
    /* 0x97 */ 0xc5,/* # ? */
    /* 0x98 */ 0xb2,/* # ? */
    /* 0x99 */ 0xb3,/* # ? */
    /* 0x9a */ 0xca,/* # */
    /* 0x9b */ 0x3f,/* # ? */
    /* 0x9c */ 0xa1,/* # circ */
    /* 0x9d */ 0x3f,/* # ^2 */
    /* 0x9e */ 0x3f,/* # . */
    /* 0x9f */ 0xd6,/* # / */
    /* 0xa0 */ 0x3f,/* # ? */
    /* 0xa1 */ 0x3f,/* # ? */
    /* 0xa2 */ 0x3f,/* # ? */
    /* 0xa3 */ 0xde,/* # e */
    /* 0xa4 */ 0x3f,/* # ? */
    /* 0xa5 */ 0x3f,/* # ? */
    /* 0xa6 */ 0x3f,/* # ? */
    /* 0xa7 */ 0x3f,/* # ? */
    /* 0xa8 */ 0x3f,/* # ? */
    /* 0xa9 */ 0x3f,/* # ? */
    /* 0xaa */ 0x3f,/* # ? */
    /* 0xab */ 0x3f,/* # ? */
    /* 0xac */ 0x3f,/* # ? */
    /* 0xad */ 0x3f,/* # ? */
    /* 0xae */ 0x3f,/* # ? */
    /* 0xaf */ 0x3f,/* # ? */
    /* 0xb0 */ 0x3f,/* # ? */
    /* 0xb1 */ 0x3f,/* # ? */
    /* 0xb2 */ 0x3f,/* # ? */
    /* 0xb3 */ 0xdd,/* # E */
    /* 0xb4 */ 0x3f,/* # ? */
    /* 0xb5 */ 0x3f,/* # ? */
    /* 0xb6 */ 0x3f,/* # ? */
    /* 0xb7 */ 0x3f,/* # ? */
    /* 0xb8 */ 0x3f,/* # ? */
    /* 0xb9 */ 0x3f,/* # ? */
    /* 0xba */ 0x3f,/* # ? */
    /* 0xbb */ 0x3f,/* # ? */
    /* 0xbc */ 0x3f,/* # ? */
    /* 0xbd */ 0x3f,/* # ? */
    /* 0xbe */ 0x3f,/* # ? */
    /* 0xbf */ 0xa9,/* # (C) */
    /* 0xc0 */ 0xfe,/* # yu */
    /* 0xc1 */ 0xe0,/* # a */
    /* 0xc2 */ 0xe1,/* # b */
    /* 0xc3 */ 0xf6,/* # cz */
    /* 0xc4 */ 0xe4,/* # d */
    /* 0xc5 */ 0xe5,/* # e */
    /* 0xc6 */ 0xf4,/* # f */
    /* 0xc7 */ 0xe3,/* # g */
    /* 0xc8 */ 0xf5,/* # kh */
    /* 0xc9 */ 0xe8,/* # i */
    /* 0xca */ 0xe9,/* # y */
    /* 0xcb */ 0xea,/* # k */
    /* 0xcc */ 0xeb,/* # l */
    /* 0xcd */ 0xec,/* # m */
    /* 0xce */ 0xed,/* # n */
    /* 0xcf */ 0xee,/* # o */
    /* 0xd0 */ 0xef,/* # p */
    /* 0xd1 */ 0xdf,/* # ya */
    /* 0xd2 */ 0xf0,/* # r */
    /* 0xd3 */ 0xf1,/* # s */
    /* 0xd4 */ 0xf2,/* # t */
    /* 0xd5 */ 0xf3,/* # u */
    /* 0xd6 */ 0xe6,/* # zh */
    /* 0xd7 */ 0xe2,/* # v */
    /* 0xd8 */ 0xfc,/* # ' */
    /* 0xd9 */ 0xfb,/* # y */
    /* 0xda */ 0xe7,/* # z */
    /* 0xdb */ 0xf8,/* # sh */
    /* 0xdc */ 0xfd,/* # e */
    /* 0xdd */ 0xf9,/* # sch */
    /* 0xde */ 0xf7,/* # ch */
    /* 0xdf */ 0xfa,/* # ` */
    /* 0xe0 */ 0x9e,/* # Yu */
    /* 0xe1 */ 0x80,/* # A */
    /* 0xe2 */ 0x81,/* # B */
    /* 0xe3 */ 0x96,/* # Cz */
    /* 0xe4 */ 0x84,/* # D */
    /* 0xe5 */ 0x85,/* # E */
    /* 0xe6 */ 0x94,/* # F */
    /* 0xe7 */ 0x83,/* # G */
    /* 0xe8 */ 0x95,/* # Kh */
    /* 0xe9 */ 0x88,/* # I */
    /* 0xea */ 0x89,/* # Y */
    /* 0xeb */ 0x8a,/* # K */
    /* 0xec */ 0x8b,/* # L */
    /* 0xed */ 0x8c,/* # M */
    /* 0xee */ 0x8d,/* # N */
    /* 0xef */ 0x8e,/* # O */
    /* 0xf0 */ 0x8f,/* # P */
    /* 0xf1 */ 0x9f,/* # Ya */
    /* 0xf2 */ 0x90,/* # R */
    /* 0xf3 */ 0x91,/* # S */
    /* 0xf4 */ 0x92,/* # T */
    /* 0xf5 */ 0x93,/* # U */
    /* 0xf6 */ 0x86,/* # Zh */
    /* 0xf7 */ 0x82,/* # V */
    /* 0xf8 */ 0x9c,/* # ' */
    /* 0xf9 */ 0x9b,/* # Y */
    /* 0xfa */ 0x87,/* # Z */
    /* 0xfb */ 0x98,/* # Sh */
    /* 0xfc */ 0x9d,/* # E */
    /* 0xfd */ 0x99,/* # Sch */
    /* 0xfe */ 0x97,/* # Ch */
    /* 0xff */ 0x9a,/* # ` */
};

static char tab_koi_iso[256] =
{
   /* ######################################################################## */
   /* # koi-iso.tab */
   /* # KOI8-R -> ISO-8859-5 recoding table for Russian Apache */
   /* # by Dmitry A. Pashko (dap@stack.net) */
   /* ######################################################################## */
               0x00,
    /* 0x01 */ 0x01,/* # ? - const */
    /* 0x02 */ 0x02,/* # ? - const */
    /* 0x03 */ 0x03,/* # ? - const */
    /* 0x04 */ 0x04,/* # ? - const */
    /* 0x05 */ 0x05,/* # ? - const */
    /* 0x06 */ 0x06,/* # ? - const */
    /* 0x07 */ 0x07,/* # ? - const */
    /* 0x08 */ 0x08,/* # ? - const */
    /* 0x09 */ 0x09,/* # ? - const */
    /* 0x0a */ 0x0a,/* # ? - const */
    /* 0x0b */ 0x0b,/* # ? - const */
    /* 0x0c */ 0x0c,/* # ? - const */
    /* 0x0d */ 0x0d,/* # ? - const */
    /* 0x0e */ 0x0e,/* # ? - const */
    /* 0x0f */ 0x0f,/* # ? - const */
    /* 0x10 */ 0x10,/* # ? - const */
    /* 0x11 */ 0x11,/* # ? - const */
    /* 0x12 */ 0x12,/* # ? - const */
    /* 0x13 */ 0x13,/* # ? - const */
    /* 0x14 */ 0x14,/* # ? - const */
    /* 0x15 */ 0x15,/* # ? - const */
    /* 0x16 */ 0x16,/* # ? - const */
    /* 0x17 */ 0x17,/* # ? - const */
    /* 0x18 */ 0x18,/* # ? - const */
    /* 0x19 */ 0x19,/* # ? - const */
    /* 0x1a */ 0x1a,/* # ? - const */
    /* 0x1b */ 0x1b,/* # ? - const */
    /* 0x1c */ 0x1c,/* # ? - const */
    /* 0x1d */ 0x1d,/* # ? - const */
    /* 0x1e */ 0x1e,/* # ? - const */
    /* 0x1f */ 0x1f,/* # ? - const */
    /* 0x20 */ 0x20,/* #   - const */
    /* 0x21 */ 0x21,/* # ! - const */
    /* 0x22 */ 0x22,/* # " - const */
    /* 0x23 */ 0x23,/* # # - const */
    /* 0x24 */ 0x24,/* # $ - const */
    /* 0x25 */ 0x25,/* # % - const */
    /* 0x26 */ 0x26,/* # & - const */
    /* 0x27 */ 0x27,/* # ' - const */
    /* 0x28 */ 0x28,/* # ( - const */
    /* 0x29 */ 0x29,/* # ) - const */
    /* 0x2a */ 0x2a,/* # * - const */
    /* 0x2b */ 0x2b,/* # + - const */
    /* 0x2c */ 0x2c,/* # , - const */
    /* 0x2d */ 0x2d,/* # - - const */
    /* 0x2e */ 0x2e,/* # . - const */
    /* 0x2f */ 0x2f,/* # / - const */
    /* 0x30 */ 0x30,/* # 0 - const */
    /* 0x31 */ 0x31,/* # 1 - const */
    /* 0x32 */ 0x32,/* # 2 - const */
    /* 0x33 */ 0x33,/* # 3 - const */
    /* 0x34 */ 0x34,/* # 4 - const */
    /* 0x35 */ 0x35,/* # 5 - const */
    /* 0x36 */ 0x36,/* # 6 - const */
    /* 0x37 */ 0x37,/* # 7 - const */
    /* 0x38 */ 0x38,/* # 8 - const */
    /* 0x39 */ 0x39,/* # 9 - const */
    /* 0x3a */ 0x3a,/* # : - const */
    /* 0x3b */ 0x3b,/* # ; - const */
    /* 0x3c */ 0x3c,/* # < - const */
    /* 0x3d */ 0x3d,/* # = - const */
    /* 0x3e */ 0x3e,/* # > - const */
    /* 0x3f */ 0x3f,/* # ? - const */
    /* 0x40 */ 0x40,/* # @ - const */
    /* 0x41 */ 0x41,/* # A - const */
    /* 0x42 */ 0x42,/* # B - const */
    /* 0x43 */ 0x43,/* # C - const */
    /* 0x44 */ 0x44,/* # D - const */
    /* 0x45 */ 0x45,/* # E - const */
    /* 0x46 */ 0x46,/* # F - const */
    /* 0x47 */ 0x47,/* # G - const */
    /* 0x48 */ 0x48,/* # H - const */
    /* 0x49 */ 0x49,/* # I - const */
    /* 0x4a */ 0x4a,/* # J - const */
    /* 0x4b */ 0x4b,/* # K - const */
    /* 0x4c */ 0x4c,/* # L - const */
    /* 0x4d */ 0x4d,/* # M - const */
    /* 0x4e */ 0x4e,/* # N - const */
    /* 0x4f */ 0x4f,/* # O - const */
    /* 0x50 */ 0x50,/* # P - const */
    /* 0x51 */ 0x51,/* # Q - const */
    /* 0x52 */ 0x52,/* # R - const */
    /* 0x53 */ 0x53,/* # S - const */
    /* 0x54 */ 0x54,/* # T - const */
    /* 0x55 */ 0x55,/* # U - const */
    /* 0x56 */ 0x56,/* # V - const */
    /* 0x57 */ 0x57,/* # W - const */
    /* 0x58 */ 0x58,/* # X - const */
    /* 0x59 */ 0x59,/* # Y - const */
    /* 0x5a */ 0x5a,/* # Z - const */
    /* 0x5b */ 0x5b,/* # [ - const */
    /* 0x5c */ 0x5c,/* # \ - const */
    /* 0x5d */ 0x5d,/* # ] - const */
    /* 0x5e */ 0x5e,/* # ^ - const */
    /* 0x5f */ 0x5f,/* # _ - const */
    /* 0x60 */ 0x60,/* # ` - const */
    /* 0x61 */ 0x61,/* # a - const */
    /* 0x62 */ 0x62,/* # b - const */
    /* 0x63 */ 0x63,/* # c - const */
    /* 0x64 */ 0x64,/* # d - const */
    /* 0x65 */ 0x65,/* # e - const */
    /* 0x66 */ 0x66,/* # f - const */
    /* 0x67 */ 0x67,/* # g - const */
    /* 0x68 */ 0x68,/* # h - const */
    /* 0x69 */ 0x69,/* # i - const */
    /* 0x6a */ 0x6a,/* # j - const */
    /* 0x6b */ 0x6b,/* # k - const */
    /* 0x6c */ 0x6c,/* # l - const */
    /* 0x6d */ 0x6d,/* # m - const */
    /* 0x6e */ 0x6e,/* # n - const */
    /* 0x6f */ 0x6f,/* # o - const */
    /* 0x70 */ 0x70,/* # p - const */
    /* 0x71 */ 0x71,/* # q - const */
    /* 0x72 */ 0x72,/* # r - const */
    /* 0x73 */ 0x73,/* # s - const */
    /* 0x74 */ 0x74,/* # t - const */
    /* 0x75 */ 0x75,/* # u - const */
    /* 0x76 */ 0x76,/* # v - const */
    /* 0x77 */ 0x77,/* # w - const */
    /* 0x78 */ 0x78,/* # x - const */
    /* 0x79 */ 0x79,/* # y - const */
    /* 0x7a */ 0x7a,/* # z - const */
    /* 0x7b */ 0x7b,/* # { - const */
    /* 0x7c */ 0x7c,/* # | - const */
    /* 0x7d */ 0x7d,/* # } - const */
    /* 0x7e */ 0x7e,/* # ~ - const */
    /* 0x7f */ 0x7f,/* # ? - const */
    /* 0x80 */ 0x3f,/* # ? */
    /* 0x81 */ 0x3f,/* # ? */
    /* 0x82 */ 0x3f,/* # ? */
    /* 0x83 */ 0x3f,/* # ? */
    /* 0x84 */ 0x3f,/* # ? */
    /* 0x85 */ 0x3f,/* # ? */
    /* 0x86 */ 0x3f,/* # ? */
    /* 0x87 */ 0x3f,/* # ? */
    /* 0x88 */ 0x3f,/* # ? */
    /* 0x89 */ 0x3f,/* # ? */
    /* 0x8a */ 0x3f,/* # ? */
    /* 0x8b */ 0x3f,/* # ? */
    /* 0x8c */ 0x3f,/* # ? */
    /* 0x8d */ 0x3f,/* # ? */
    /* 0x8e */ 0x3f,/* # ? */
    /* 0x8f */ 0x3f,/* # ? */
    /* 0x90 */ 0x3f,/* # ? */
    /* 0x91 */ 0x3f,/* # ? */
    /* 0x92 */ 0x3f,/* # ? */
    /* 0x93 */ 0x3f,/* # ? */
    /* 0x94 */ 0x3f,/* # ? */
    /* 0x95 */ 0x3f,/* # ? */
    /* 0x96 */ 0x3f,/* # ? */
    /* 0x97 */ 0x3f,/* # ? */
    /* 0x98 */ 0x3f,/* # ? */
    /* 0x99 */ 0x3f,/* # ? */
    /* 0x9a */ 0xa0,/* # */
    /* 0x9b */ 0x3f,/* # ? */
    /* 0x9c */ 0x3f,/* # circ */
    /* 0x9d */ 0x32,/* # ^2 */
    /* 0x9e */ 0x2e,/* # . */
    /* 0x9f */ 0x3f,/* # / */
    /* 0xa0 */ 0x3f,/* # ? */
    /* 0xa1 */ 0x3f,/* # ? */
    /* 0xa2 */ 0x3f,/* # ? */
    /* 0xa3 */ 0xf1,/* # e */
    /* 0xa4 */ 0x3f,/* # ? */
    /* 0xa5 */ 0x3f,/* # ? */
    /* 0xa6 */ 0x3f,/* # ? */
    /* 0xa7 */ 0x3f,/* # ? */
    /* 0xa8 */ 0x3f,/* # ? */
    /* 0xa9 */ 0x3f,/* # ? */
    /* 0xaa */ 0x3f,/* # ? */
    /* 0xab */ 0x3f,/* # ? */
    /* 0xac */ 0x3f,/* # ? */
    /* 0xad */ 0x3f,/* # ? */
    /* 0xae */ 0x3f,/* # ? */
    /* 0xaf */ 0x3f,/* # ? */
    /* 0xb0 */ 0x3f,/* # ? */
    /* 0xb1 */ 0x3f,/* # ? */
    /* 0xb2 */ 0x3f,/* # ? */
    /* 0xb3 */ 0xa1,/* # E */
    /* 0xb4 */ 0x3f,/* # ? */
    /* 0xb5 */ 0x3f,/* # ? */
    /* 0xb6 */ 0x3f,/* # ? */
    /* 0xb7 */ 0x3f,/* # ? */
    /* 0xb8 */ 0x3f,/* # ? */
    /* 0xb9 */ 0x3f,/* # ? */
    /* 0xba */ 0x3f,/* # ? */
    /* 0xbb */ 0x3f,/* # ? */
    /* 0xbc */ 0x3f,/* # ? */
    /* 0xbd */ 0x3f,/* # ? */
    /* 0xbe */ 0x3f,/* # ? */
    /* 0xbf */ 0x43,/* # (C) */
    /* 0xc0 */ 0xee,/* # yu */
    /* 0xc1 */ 0xd0,/* # a */
    /* 0xc2 */ 0xd1,/* # b */
    /* 0xc3 */ 0xe6,/* # cz */
    /* 0xc4 */ 0xd4,/* # d */
    /* 0xc5 */ 0xd5,/* # e */
    /* 0xc6 */ 0xe4,/* # f */
    /* 0xc7 */ 0xd3,/* # g */
    /* 0xc8 */ 0xe5,/* # kh */
    /* 0xc9 */ 0xd8,/* # i */
    /* 0xca */ 0xd9,/* # y */
    /* 0xcb */ 0xda,/* # k */
    /* 0xcc */ 0xdb,/* # l */
    /* 0xcd */ 0xdc,/* # m */
    /* 0xce */ 0xdd,/* # n */
    /* 0xcf */ 0xde,/* # o */
    /* 0xd0 */ 0xdf,/* # p */
    /* 0xd1 */ 0xef,/* # ya */
    /* 0xd2 */ 0xe0,/* # r */
    /* 0xd3 */ 0xe1,/* # s */
    /* 0xd4 */ 0xe2,/* # t */
    /* 0xd5 */ 0xe3,/* # u */
    /* 0xd6 */ 0xd6,/* # zh - const */
    /* 0xd7 */ 0xd2,/* # v */
    /* 0xd8 */ 0xec,/* # ' */
    /* 0xd9 */ 0xeb,/* # y */
    /* 0xda */ 0xd7,/* # z */
    /* 0xdb */ 0xe8,/* # sh */
    /* 0xdc */ 0xed,/* # e */
    /* 0xdd */ 0xe9,/* # sch */
    /* 0xde */ 0xe7,/* # ch */
    /* 0xdf */ 0xea,/* # ` */
    /* 0xe0 */ 0xce,/* # Yu */
    /* 0xe1 */ 0xb0,/* # A */
    /* 0xe2 */ 0xb1,/* # B */
    /* 0xe3 */ 0xc6,/* # Cz */
    /* 0xe4 */ 0xb4,/* # D */
    /* 0xe5 */ 0xb5,/* # E */
    /* 0xe6 */ 0xc4,/* # F */
    /* 0xe7 */ 0xb3,/* # G */
    /* 0xe8 */ 0xc5,/* # Kh */
    /* 0xe9 */ 0xb8,/* # I */
    /* 0xea */ 0xb9,/* # Y */
    /* 0xeb */ 0xba,/* # K */
    /* 0xec */ 0xbb,/* # L */
    /* 0xed */ 0xbc,/* # M */
    /* 0xee */ 0xbd,/* # N */
    /* 0xef */ 0xbe,/* # O */
    /* 0xf0 */ 0xbf,/* # P */
    /* 0xf1 */ 0xcf,/* # Ya */
    /* 0xf2 */ 0xc0,/* # R */
    /* 0xf3 */ 0xc1,/* # S */
    /* 0xf4 */ 0xc2,/* # T */
    /* 0xf5 */ 0xc3,/* # U */
    /* 0xf6 */ 0xb6,/* # Zh */
    /* 0xf7 */ 0xb2,/* # V */
    /* 0xf8 */ 0xcc,/* # ' */
    /* 0xf9 */ 0xcb,/* # Y */
    /* 0xfa */ 0xb7,/* # Z */
    /* 0xfb */ 0xc8,/* # Sh */
    /* 0xfc */ 0xcd,/* # E */
    /* 0xfd */ 0xc9,/* # Sch */
    /* 0xfe */ 0xc7,/* # Ch */
    /* 0xff */ 0xca,/* # ` */
};

/* converts from Russian encoding 'from' to KOI8 using
 straight tables (high performance!), without converting
 to Unicode first. Valid values for 'from':
 EN_ALT, EN_MAC, EN_ISO, EN_WINDOWS, EN_UTF8. On error (unknown
 encoding), -1 is returned. */
int ru_convert (char *s, int from)
{
    char *table;
    unsigned char *p = (unsigned char *)s;

    switch (from)
    {
    case EN_ALT:     table = tab_alt; break;
    case EN_MAC:     table = tab_mac; break;
    case EN_ISO:     table = tab_iso; break;
    case EN_WINDOWS: table = tab_win; break;
    case EN_KOI8R:   return 0;

    case EN_UTF8:
        p = (unsigned char *)utf2cp (s, EN_KOI8R);
        strcpy (s, (char *)p);
        free (p);
        return 0;

    default:
        return -1;
    }

    while (*p)
    {
        *p = table[*p];
        ++p;
    }

    return 0;
}

/* converts to Russian encoding 'to' from KOI8 using
 straight tables (high performance!), without converting
 to Unicode first. Valid values for 'from':
 EN_ALT, EN_MAC, EN_ISO, EN_WINDOWS. On error (unknown
 encoding), -1 is returned. */
int ru_convert2 (char *s, int to)
{
    char *table;
    unsigned char *p = (unsigned char *)s;

    switch (to)
    {
    case EN_ALT:     table = tab_koi_alt; break;
    case EN_MAC:     table = tab_koi_mac; break;
    case EN_ISO:     table = tab_koi_iso; break;
    case EN_WINDOWS: table = tab_koi_win; break;
    case EN_KOI8R:   return 0;
    default:         return -1;
    }

    while (*p)
    {
        *p = table[*p];
        ++p;
    }

    return 0;
}

/* returns name of the codepage (statically allocated string) */
char *ru_cp_name (int cp)
{
    switch (cp)
    {
    case EN_ALT:     return "IBM-866";
    case EN_KOI8R:   return "koi8-r";
    case EN_MAC:     return "Mac-cyrillic";
    case EN_ISO:     return "ISO8859-5";
    case EN_WINDOWS: return "Windows-1251";
    case EN_UTF8:    return "UTF-8";
    default:         return "?";
    }
}

/* convert string in 1251 to lowercase */
void strlwr_1251 (char *s)
{
    unsigned char c;

    while (*s)
    {
        c = *s;
        if (c >= 'A' && c <= 'Z')   *s += 'a' - 'A';
        if (c >= 0xC0 && c <= 0xDF) *s += 0xE0 - 0xC0;
        if (c == 0xA8) *s = 0xB8;
        s++;
    }
}
