#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <asvtools.h>
#include "scl.h"

int main (int argc, char *argv[])
{
    int    bits, length, rc, v, rc1, rc2;
    double t1, t2;
    char   *s, *p, *pub_key, *sec_key, *p1, *sig;

    s = "the sample string of arbitrary contents. what a waste of computing time! "
        "the sample string of arbitrary contents. what a waste of computing time! "
        "the sample string of arbitrary contents. what a waste of computing time! "
        "the sample string of arbitrary contents. what a waste of computing time! "
        "the sample string of arbitrary contents. what a waste of computing time! "
        "the sample string of arbitrary contents. what a waste of computing time! "
        "the sample string of arbitrary contents. what a waste of computing time! "
        "the sample string of arbitrary contents. what a waste of computing time! "
        "the sample string of arbitrary contents. what a waste of computing time! "
        "the sample string of arbitrary contents. what a waste of computing time! "
        "the sample string of arbitrary contents. what a waste of computing time! "
        "the sample string of arbitrary contents. what a waste of computing time! "
        "the sample string of arbitrary contents. what a waste of computing time! "
        ;
        
    s = "v2\n"
        "N1\n"
        "tpl\n"
        "i20010216\n"
        "oSergey Ayukov";

    s = "the sample string of arbitrary contents";
    
    if (argc != 2 && argc != 3) error1 ("usage: rsatest <bits>\n");
    
    bits = atoi (argv[1]);
    if (argc == 3)
    {
        if (load_file (argv[2], &s) <= 0) error1 ("failed to load file %s", argv[2]);
    }

    if (bits != 0)
    {
        fprintf (stderr, "generating key set (%d bits)\n", bits);
        t1 = clock1 ();
        rc = rsa_keypair (bits, 65537, &pub_key, &sec_key);
        t2 = clock1 ();
        if (rc) error1 ("key generation failed\n");
        printf ("key generation took %f seconds\n", t2-t1);

        printf ("secret: %s\n", sec_key);
        printf ("public: %s\n", pub_key);
    }
    else
    {
        /* generated by openssl */
        sec_key = "CD6462B548DFBB6D961898ACF5A3E320DD8C3444669D5ED9F1C2D562CA91C873A5009C2DB1C7853FA3D884A601847042A17B25ADF5A471B44DD004836C6D731E68D2FD05F56F5377C1DDF66FB50FF3A974214EBB3B6C5B4991E3E23599052788EF11E2F34D739661DDCB7590CD23DA39F48DD092A9DB19F6DA99A927CF30196D:598F595F553C81BCE2432D67D5E0B5AC620EBDC7C9BAFB5E2B865A87AE6EED2A481BC0FE47D4096D5BA3910BD6038AF3F2F800D11F18AAA005821C45B664EF59DDED8D3988C5C2FC5BE1CF6808E2E2839AB084F80EE2968D32340A64C539E21FE31ABD6E3537AC502E5AAAB2542803D9FD723E8D0E70A8CBF3215364F19FE4C1";
        pub_key = "CD6462B548DFBB6D961898ACF5A3E320DD8C3444669D5ED9F1C2D562CA91C873A5009C2DB1C7853FA3D884A601847042A17B25ADF5A471B44DD004836C6D731E68D2FD05F56F5377C1DDF66FB50FF3A974214EBB3B6C5B4991E3E23599052788EF11E2F34D739661DDCB7590CD23DA39F48DD092A9DB19F6DA99A927CF30196D:10001";

        /* recently generated by libscl */
        //sec_key = "C87FB9A45005645C9A9C47CD5679E7170157931981739E5D9FA785C15F1C4ED73C9B87B2CAEB1C2ABBC58CB81DFA50BDD1A8E44DC1D86B471E3A410F61E2F18FEC1DD572A3D59E00C9F77E3241A9D5B7ACFAFAF2ACE5764DFFA88B4F26A16756F1C556226C9630EB408E53AD312A323046BB59251F4102879564D646125693C9:12B07D4088C907E2EDF2956AD99DC161CE9938380F6E149C0B8ED5140266A41EC2228952AC41A03D878551A9B3F9AA5F175513FAFF8FC9E836341DEE6E247679D6B888A3E60C5F75CD220E14EBD6F4EDBF0A47FD8806E986763A6017326A43D00779184BE7DE8DFEB97CE769428C383EAB67E6488D07E39C47B4A59C96B14AC5C87FB9A45005645C9A9C47CD5679E7170157931981739E5D9FA785C15F1C4ED73C9B87B2CAEB1C2ABBC58CB81DFA50BDD1A8E44DC1D86B471E3A410F61E2F18FEC1DD572A3D59E00C9F77E3241A9D5B7ACFAFAF2ACE5764DFFA88B4F26A16756F1C556226C9630EB408E53AD312A323046BB59251F4102879564D646125693C9:12B07D4088C907E2EDF2956AD99DC161CE9938380F6E149C0B8ED5140266A41EC2228952AC41A03D878551A9B3F9AA5F175513FAFF8FC9E836341DEE6E247679D6B888A3E60C5F75CD220E14EBD6F4EDBF0A47FD8806E986763A6017326A43D00779184BE7DE8DFEB97CE769428C383EAB67E6488D07E39C47B4A59C96B14AC5";
        //pub_key = "C87FB9A45005645C9A9C47CD5679E7170157931981739E5D9FA785C15F1C4ED73C9B87B2CAEB1C2ABBC58CB81DFA50BDD1A8E44DC1D86B471E3A410F61E2F18FEC1DD572A3D59E00C9F77E3241A9D5B7ACFAFAF2ACE5764DFFA88B4F26A16756F1C556226C9630EB408E53AD312A323046BB59251F4102879564D646125693C9:010001";
    }

    fprintf (stderr, "encoding....\n");
    t1 = clock1 ();
    p = rsa_encode (s, strlen (s), sec_key);
    t2 = clock1 ();
    printf ("encoded: [%s]\n", p);
    printf ("encoding took %f seconds\n", t2-t1);

    fprintf (stderr, "decoding....\n");
    t1 = clock1 ();
    length = rsa_decode (p, pub_key, &p1);
    t2 = clock1 ();
    if (length < 0) error1 ("%d from rsa_decode()\n", length);
    rc1 = strcmp (s, p1);
    printf ("compare result: %d\n", rc1);
    if (rc1)
    {
        printf ("original: [%s]\ndecoded: [%s]\n", s, p1);
    }
    printf ("decoding took %f seconds\n", t2-t1);

    // signature compute test
    fprintf (stderr, "signing....\n");
    t1 = clock1 ();
    sig = rsa_sign (s, strlen (s), sec_key);
    t2 = clock1 ();
    printf ("signature: [%s]\n", sig);
    printf ("signing took %f seconds\n", t2-t1);

    // signature verification test
    fprintf (stderr, "verifying signature....\n");
    t1 = clock1 ();
    rc2 = rsa_verify (s, strlen (s), sig, pub_key);
    t2 = clock1 ();
    printf ("verification result: %d\n", rc2);
    printf ("verification took %f seconds\n", t2-t1);
    rc2 = !rc2;

    printf ("Results:\n");
    if (rc1) printf ("decoding test FAILED\n");
    else     printf ("decoding test PASSED\n");
    if (rc2) printf ("signing test  FAILED\n");
    else     printf ("signing test  PASSED\n");

    return 0;
}

