/****************************************************************/
/*                                                              */
/*               Script to shut down FtpServer                  */
/*                                                              */
/*   Although this script can be used to shutdown an instance   */
/*   of FtpServer running on the local host, its main use is    */
/*   for shutting down FtpServer remotely.  For the case where  */
/*   the server is your own workstation, the script called      */
/*   ShutFtpd.CMD is a more direct and efficient solution.      */
/*                                                              */
/*   Programmer:      P. Moylan                                 */
/*   Last modified:   15 June 2003                              */
/*                                                              */
/*   Usage:    CloseServer hostname user password option        */
/*      where                                                   */
/*         hostname  is the name of the machine running the     */
/*                   server                                     */
/*         user      is the username for a 'manager' account    */
/*         password  is the password for that account           */
/*         option    is G for gradual shutdown, or Q for fast   */
/*                   shutdown.                                  */
/*   Example:  CloseServer mymachine.net boss secret G          */
/*                                                              */
/****************************************************************/

call RxFuncAdd 'FtpLoadFuncs', 'rxFtp', 'FtpLoadFuncs'
call FtpLoadFuncs '> nul'

parse arg hostname user password option
IF option = '' THEN DO
     SAY 'Usage: CloseServer hostname user password option'
     exit 1
END

option = TRANSLATE(option)
IF option = 'G' THEN command = 'MNGR GXIT'
ELSE IF option = 'Q' THEN command = 'MNGR EXIT'
ELSE DO
    SAY 'Unknown option 'option
    exit 1
END

rc = FtpSetUser(hostname, user, password)
IF rc = 0 THEN
    SAY 'Login failed'
ELSE DO
    IF FtpSite(command) \= 0 THEN
        SAY 'Operation failed, error code 'FTPERRNO
END
call FtpLogoff
exit

