/****************************************************************/
/*          Signals a global event semaphore to tell            */
/*                  FtpServer to shut down.                     */
/*                                                              */
/*       Programmer:      P. Moylan                             */
/*       Last modified:   24 February 2019                      */
/*                         (to wait until shutdown complete)    */
/*                                                              */
/* Prerequisite: for this to work you must have RXU.DLL in      */
/* your LIBPATH.  RXU, a Rexx library written by Dave Boll, is  */
/* available from Hobbes with the name rxu1a.zip.               */
/****************************************************************/

call rxfuncadd 'rxuinit','rxu','rxuinit'
call rxuinit
SemName = "\SEM32\FTPSERVER\SHUTDOWN"
if RxOpenEventSem(hev, SemName) \= 0 then
    rc = RxCreateEventSem( hev ,'Shared', SemName, 'Reset')
call RxPostEventSem hev
call RxResetEventSem hev
call RxCloseEventSem hev
say "Waiting for FtpServer to finish shutting down"
SemName = "\SEM32\FTPSERVER\FINISHED"
if RxOpenEventSem(hev, SemName) \= 0 then
    rc = RxCreateEventSem( hev ,'Shared', SemName, 'Reset')
call RxWaitEventSem hev
call RxResetEventSem hev
call RxCloseEventSem hev
say "Shutdown complete"

exit

