/****************************************************************/
/*                    MLoadini for FtpServer                    */
/*                                                              */
/*   This script invokes the generic LoadINI to translate       */
/*   from FTPD.TNI to FTPD.INI.  Then, if multiple TNI files    */
/*   are present, it also translates each FTPD????.TNI          */
/*   to the corresponding FTPD????.INI.                         */
/*                                                              */
/*      Author:       Peter Moylan (peter@pmoylan.org)          */
/*      Last revised: 8 September 2016                          */
/*                                                              */
/*  Usage:                                                      */
/*         mloadini                                             */
/*                                                              */
/*     (There are no arguments.)                                */
/*                                                              */
/*  Installation:                                               */
/*     Put this in the directory containing the TNI file(s)     */
/*     Also ensure that LOADINI.EXE is either in this           */
/*        directory or on the PATH                              */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

CALL SysFileTree 'FTPD????.TNI', 'files', 'FO'
DO k = 1 TO files.0
    SAY "Processing file "files.k
    '@LOADINI.EXE 'files.k' >Nul'
END
SAY "Converted "files.0" TNI files"

EXIT 0

/****************************************************************/

