#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#ifdef HAVE_STRINGS_H   /* SysV */
#include <strings.h>
#endif
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <limits.h>  /* for UINT_MAX -> OSF does not accept inet_addr() == -1 */
#include "log.h"

/* include the autoheader file config.h */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef SA_RESTART
#define SA_RESTART 0
#endif

#ifdef __EMX__
#define PACKAGE "jftpgw"
#define JFTPGW_VERSION "0.0.11"
#define strcasecmp(x,y) stricmp((x),(y))
#define strncasecmp(x,y,z) strnicmp(x,y,z)
#ifndef CONFFILE
#define CONFFILE "etc/jftpgw.conf"
#endif
#endif


#define MAX_VAL(a,b) ((a)>(b)?(a):(b))

#define DEFAULTCONFFILE		CONFFILE
#define DEFAULTBINDPORT		2370
#define DEFAULTBINDADDRESS	"0.0.0.0:2370"
#define DEFAULTSERVERPORT	21
#define DEFAULTACCESSFILE	"etc/jftpgw.access"
#define DEFAULTLOGFILE		"log/jftpgw.log"

#define BROADCAST		"255.255.255.255"

#define RETR			1
#define STOR			2

#define PASSIVE			1
#define ACTIVE			2
#define ASCLIENT		3
#define SECURE_SFTP		4

#define SERVERADDR		1
#define CLIENTADDR		2

#define UID			1
#define EUID			2

#define CMD_HANDLED		0
#define CMD_PASS		1
#define CMD_QUIT		2

#define WHITESPACES		" \t"

#define CONV_NOTCONVERT		0
#define CONV_TOASCII		1
#define CONV_FRMASCII		2

#define MAX_LINE_SIZE		4096


extern FILE* logfile;
struct allowed_lst;

struct clientinfo {
	int clientsocket;
	int* boundsocket_list;
	int boundsocket_niface;  /* number of ifaces we bound to */
	int serversocket;
	int dataserversock;
	int dataclientsock;
	int *waitforconnect;
	int mode;
	int servermode;
	int clientmode;
	unsigned long int serveraddr;
	unsigned long int clientaddr;
	int dataport;
	int havetoconvert;
	char* destination;
	char* user;
	char* pass;
	int destinationport;
	float throughput;
};

struct configstruct {
	int syslog;
	int debuglevel;
	char* logf_name;
	FILE* logf;
	struct cmdlogent_t {
		char* logf_name;
		int logf_size;  /* not used for files but for dirs */
		char* specs;
		FILE* logf;
		struct cmdlogent_t* next;
	} cmdlogfiles, cmdlogdirs;
};

struct loginstruct {
	char* fwlogin;  /* fwlogin is joe@foo,21 */
	char* fwuser;   /* user is joe */
	char* fwpass;   /* nv: the password the user must supply for the
			   the forward. May be "*"    */
	char* login;	/* nv: the login name that is used on dest */
	char* pass;     /* nv: the password that is used on dest */
};

struct message {
	char* fullmsg;
	/* lastmsg points to an address somewhere in fullmsg, so you don't
	 * have to free() both */
	char* lastmsg;
};

struct ip_t {
	unsigned long int ip;
	unsigned long int netmask;
};

struct uidstruct {
	char* username;
	uid_t uid;
};

struct connliststruct {
	pid_t pid;
	struct connliststruct* next;
};

struct limitstruct {
	struct ip_t ip;
	char* hostname;
	unsigned int connmax;
	unsigned int connected;
	struct connliststruct* connlist;
	struct limitstruct* next;
};

/* signal handling functions */
void read_default_conf(int);
void childterm(int);
void reap_chld_info (int);
void terminate (int);

/* functions that handle flags set by the signal handlers */
int get_chld_pid(void);
int reread_config(void);

/* at exit functions */
void sayterminating(void);
void closedescriptors(void);
void conf_delete_config(void);
void removepidfile(void);


int pasvclient(struct clientinfo*);
int pasvserver(struct clientinfo*);

int activeclient(char*, struct clientinfo*);
int activeserver(char**, struct clientinfo*);

int parsesock(char*, struct sockaddr_in*, int mode);
int login(struct clientinfo*);
int sftp_open(char**, int);

int checkdigits(const char*, const int);
char* get_ip(int);
unsigned long int get_showaddr(int);
int waitclient(const char*, struct clientinfo*);
int handlecmds(const char*, struct clientinfo*);
int say(int, const char*);
int passcmd(char*, struct clientinfo*);
int openownport(struct sockaddr_in *, struct clientinfo *, int);
int openportiaddr(unsigned long, unsigned int,
		  unsigned int, struct clientinfo *);
int openportaddr(char*, unsigned int,
		 unsigned int, struct clientinfo *);
int openportname(char*, unsigned int,
		 unsigned int, struct clientinfo *);
int openport(struct sockaddr_in,
	     unsigned int /*, struct clientinfo * */);
unsigned long int get_our_addr_to(unsigned long int, unsigned int);

int transmitfile(struct clientinfo *);
int initiate_transfer(struct clientinfo *);

char* ftp_readline(int);
struct message readall(int);
int ftp_getrc(int, char**);
char* passall(int, int);

int checkbegin(const char*, const char*);
int getcode(const char*);
void closedescriptors(void);
int daemonize(void);
void clean_allowedlist(void);
void enough_mem(const void*);
unsigned long int setlastbits(int);
int cmp_domains(const char* name, const char* pattern);
void err_time_readline(int fd);
void err_readline(int fd);
int changeid(const char*, int);
char* extract_username(const char*);
char* extract_userhost(const char*);
void toupstr(char*);
char* trim(char *const s);
void char_squeeze(char *const, int);
int respcode(const char*);
int init_logdirs(const char*);
char* to_ascii(char *, int *);
char* from_ascii(char *, int *);


/*  from access.c */
int read_access(const char*);
struct allowed_lst* is_ip_allowed(const char*, struct allowed_lst*);
int is_ip_target(const char*, const char*, const char*, const char*);
char *getpeer_ip(int);
unsigned int get_usesport(int);
char* gethostentip(char* iplist);

/* from config.c */
int config_read_options(FILE*);
const char* get_option(const char* key);
char* quotstrtok(const char*, const char*, int*);
int add_to_options(char*);
FILE* open_file(const char*);
FILE* open_logfile(const char*);
int read_config(const char*);
float get_rate(const char*, const char*, unsigned long int,
		const char*, unsigned long int, const char*);
const char* get_sshpasswd(unsigned long int, const char*);
const char* get_sshoptions(unsigned long int, const char*);
int is_below_limit(unsigned long int, struct limitstruct**);
int register_pid(struct limitstruct*, pid_t);
int unregister_pid(pid_t);
struct showaddr;
int getservermode(void);
unsigned int getserverport(void);
const char* getlisten(void);

int add_showaddr(char*, struct showaddr**);
int get_forward(const char*, struct loginstruct*);
int checkfwpass(struct clientinfo*);

void encrypt_password(void);
int cryptcmp(const char*, const char*);
struct ip_t parse_ip(const char*);
int gethostaddr(const char*, struct in_addr*);

struct limitstruct;
void free_limitst(struct limitstruct*);

int os2_select(int nfds, fd_set *readfds, fd_set *writefds,
             fd_set *exceptfds, struct timeval *timeout);
