/* $Id: log.c,v 1.5 2000/07/29 12:46:36 joe Exp $
 *
 *  ----- from tinyproxy for jftpgw
 *  
 * Logs the various messages which tinyproxy produces to either a log file or
 * the syslog daemon. Not much to it...
 *
 * Copyright (C) 1998  Steven Young
 * Copyright (C) 1999  Robert James Kaes (rjkaes@flarenet.com)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * log.c - For the manipulation of log files.
 */
#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#ifndef __EMX__
#include <syslog.h>
#endif
#include <stdlib.h>
#include <unistd.h>

#include "jftpgw.h"
#include "log.h"

#define LENGTH 64

extern struct configstruct config;

/*
 * This routine logs messages to either the log file or the syslog function.
 */
void log(int level, char *fmt, ...)
{
	va_list args;
	time_t nowtime;
	FILE *cf;
	
#if !defined(HAVE_VSYSLOG) && defined(HAVE_SYSLOG)
	static char str[800];
#endif				/* !HAVE_VSYSLOG && HAVE_SYSLOG*/
	static char time_string[LENGTH];

	if (level > config.debuglevel) {
		return;
	}
	
	va_start(args, fmt);
#ifdef HAVE_SYSLOG
	if (config.syslog == FALSE) {
#endif				/* HAVE_SYSLOG */
		nowtime = time(NULL);
		/* Format is month day hour:minute:second (24 time) */
		strftime(time_string, LENGTH, "%b %d %H:%M:%S", localtime(&nowtime));
		if (!(cf = config.logf))
			cf = stderr;

		fprintf(cf, "%s [%ld]: ", time_string, (long int) getpid());
		vfprintf(cf, fmt, args);
		fprintf(cf, "\n");
		fflush(cf);
#ifdef HAVE_SYSLOG
	} else {
#ifdef HAVE_VSYSLOG
		vsyslog(LOG_INFO, fmt, args);
#else
		vsnprintf(str, 800, fmt, args);
		syslog(LOG_INFO, str);
#endif				/* HAVE_VSYSLOG */
	}
#endif				/* HAVE_SYSLOG */

	va_end(args);
}

void log_cmd_ent(struct cmdlogent_t* lent, const struct loginfo* li) {

	char commandpattern[1024];
	static char time_string[LENGTH];
	time_t nowtime;
	char* ws;
	
	if (strlen(li->cmd) > 1020) {
		return;
	}

	commandpattern[0] = ' ';
	if ((ws = strpbrk(li->cmd, " \t")) == NULL) {
		/* Command consisting of a single word */
		strcpy(&commandpattern[1], li->cmd);
		strcat(commandpattern, " ");
	} else {
		strncpy(&commandpattern[1], li->cmd, ws - li->cmd);
		commandpattern[ws-li->cmd+1] = ' ';
		commandpattern[ws-li->cmd+2] = '\0';
	}
	toupstr(commandpattern);
		
	if (strstr(lent->specs, commandpattern)) {
		/* found, log it */
		nowtime = time(NULL);

#ifdef __EMX__
		strftime(time_string, LENGTH,
			"[%d/%b/%Y.%H.%M.%S %Z]", localtime(&nowtime));
#else
		strftime(time_string, LENGTH,
			"[%d/%b/%Y:%H:%M:%S %Z]", localtime(&nowtime));
#endif
		fprintf(lent->logf, "%s UNKNOWN %s %s ",
			li->host, li->user, time_string);
		if (checkbegin(li->cmd, "PASS")) {
			fprintf(lent->logf, "\"PASS *\"");
		} else {
			fprintf(lent->logf, "\"%s\"", li->cmd);
		}
		fprintf(lent->logf, " %d %ld\n", li->respcode, li->transferred);
		fflush(lent->logf);
	}
}

	

void log_cmd(const struct loginfo* li) {
	
	/* go through the specifications of the logfiles and write
	 * them if they match */

	int i;
	struct cmdlogent_t* files = &config.cmdlogfiles;
	struct cmdlogent_t* dirs  = &config.cmdlogdirs;
	
	i = 0;
	while (files && files->logf_name) {	
		i++;
		log_cmd_ent(files, li);
		files = files->next;
	}

	i = 0;
	while (dirs && dirs->logf_name) {
		i++;
		log_cmd_ent(dirs, li);
		dirs = dirs->next;
	}
}

