#include <sys/types.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

main(int argc, char *argv[] ) {
  int s; /* socket descriptor */
  struct sockaddr_in sa;
  int i;
  FILE *flog;

#ifdef DEBUG
  flog = fopen("c:\\so_close.log", "w");
  if(flog) {
    fprintf(flog, "so_close log started\n");
    fflush(flog);
  } else {
    perror("Cannot open c:\\so_close.log");
  }
#endif
  
    
  if( argc < 2 ) {
    fprintf(stderr,"Usage:\n%s socket1 socket2 ...\n\n\
Where:\n\tsocketN -\tnumber of unclosed socket\n\
For example:\n\
%s 787 1025\n", argv[0], argv[0]);
#ifdef DEBUG
  if( flog ) {
    int i;
    fprintf(flog,"Usage:\n%s socket1 socket2 ...\n\n\
Where:\n\tsocketN -\tnumber of unclosed socket\n\
For example:\n\
%s 787 1025\n", argv[0], argv[0]);
    for( i=0; i < argc; i++) fprintf(flog,"%s ",argv[i]);
    fflush(flog);
  }
#endif
    exit(200);
  }
  
#ifdef DEBUG
  if( flog ) {
    fprintf(flog,"Initing socks\n");
    fflush(flog);
  }
#endif
  if( sock_init() ) {
    fprintf(stderr,"Can't initialize sockets\n");
#ifdef DEBUG
  if( flog ) {
    fprintf(flog,"Can't initialize sockets\n");
    fflush(flog);
  }
#endif
    exit(200);
  }

#ifdef DEBUG
  if( flog ) {
    fprintf(flog,"Getting socket numbers\n");
    fflush(flog);
  }
#endif
  for( i=1; i < argc; i++) {
    sscanf(argv[i],"%d", &s);
#ifdef DEBUG
    if( flog ) {
      fprintf(flog,"Socket %d\n", s);
    fflush(flog);
  }
#endif
    soclose(s);
  }
    
  return 0;
}