/**********************************************************************/
/* ZipDirs - zips a directory and its subdirectories                  */
/**********************************************************************/
/* (c) 2002 Marcus C. de Geus - <marcus@degeus.com>                   */
/**********************************************************************/

signal on Halt  /* handles halt condition */

if (\LoadRexxUtil()) then  /* if we cannot load the REXX utilities library */
do
 call Halt  /* quit */
end

parse arg DirName  /* get the parameters */

DirName = strip(DirName,'B','"')  /* remove any quotation marks */

if (DirName = '') then  /* if we have none */
do
 call Usage  /* tell 'em what to do */
end

call sysfiletree DirName||'\*','Dirs','DOS'  /* get the names of all subdirectories of DirName */

if (Dirs.0 = 0) then  /* if we find no match */
do
 call Usage  /* tell 'em what to do */
end

CurDir = directory()  /* get the current directory name */

BlockZip = '!'  /* any directory with a name starting with this blocking string will not be included */

do DirCount = 1 to Dirs.0  /* take each subdirectory in turn */
 DirName = filespec('N',Dirs.DirCount)  /* get the name bit of the directory path */
 if (substr(DirName,1,length(BlockZip)) >< BlockZip) then  /* if the dir name does not start with the blocking string */
 do
  if (directory(Dirs.DirCount) >< '') then  /* if we can switch to the directory to be processed */
  do
   ZIPName = filespec('N',Dirs.DirCount)||'.ZIP'  /* the ZIP file name and extension */
   ZIPFile = Dirs.DirCount||'\'||ZIPName  /* the full ZIP file spec */
   say 'Archiving '||Dirs.DirCount  /* report */
   address cmd 'zip.exe -j -m -q -9 "'||ZIPFile||'" "*" -x "'||ZIPName||'"'  /* use ZIP.EXE to compress it and wipe the source files, excluding the ZIP file itself [EXTERNAL] */
   call directory CurDir  /* switch back to the original directory */
  end
 end
end

call Halt  /* that's all, folks! */

/**********************************************************************/
LoadRexxUtil: procedure expose Global.  /* try to load the REXX utilities library */
/**********************************************************************/

Result = 1  /* start with a good result */

if rxfuncquery('SysLoadFuncs') then  /* if it is not already loaded */
do
 if (rxfuncadd('SysLoadFuncs','RexxUtil','SysLoadFuncs') >< 0) then  /* if we cannot add it */
 do
  Result = 0  /* bad result */
 end
 else  /* if we can add it */
 do
  if (SysLoadFuncs() = 0) then  /* if we cannot load it */
  do
   Result = 0  /* bad result */
  end
 end
end

return Result  /* end of LoadRexxUtil */

/**********************************************************************/
Usage: procedure  /* tells 'em what to do */
/**********************************************************************/

say 'This program uses the InfoZip zip.exe program (which must be on the default'  /* report */
say 'search path) to move the contents of a directory and its subdirectories into'  /* report */
say 'separate ZIP files in each directory. The ZIP files will be named after the'  /*report */
say 'directories in which they are created/updated, with an added ".ZIP" extension.'  /* report */
say ''  /* empty line */
say 'Directories with names starting with an exclamation mark (!) will be excluded.'  /* report */
say ''  /* empty line */
say 'Usage : ZipDirs <path>'  /* report */

call Halt  /* and quit */

/**********************************************************************/
Halt:  /* handles halt condition */
/**********************************************************************/

exit  /* just quit */
