/*
 * Bogofilter IPS rexx hook.
 *
 * (C) 2003-04 Yuri Dario <mc6530@mclink.it>
 *
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* bogofilter install directory */
BOGOFILTER_DIR = "d:/bin/bogofilter"

/* start of script */
PARSE ARG Session Arguments;

/* get IPS variables */
messagename = ipsVAR( Session, "%(messagename)");
messagepath = ipsVAR( Session, "%(messagepath)");
ident = ipsVAR( Session, "%(ident)");

/*
ipsLOG( Session, "onData logging");
ipsLog( Session, "onData messagename:" || messagename);
ipsLog( Session, "onData messagepath:" || messagepath);
ipsLog( Session, "onData ident:" || ident);
*/

SELECT 
   WHEN ident = "spam" then opt="-Sn" 		/* unregister from spam, register as good */
   WHEN ident = "nonspam" then opt="-Ns"	/* unregister from good, register as spam */
   WHEN ident = "register-spam" then opt="-s"		/* register as spam */
   WHEN ident = "register-nonspam" then opt="-n"	/* register as good */
   OTHERWISE
      opt = "-p -e"				/* passthrough, exit code always 0 */
END

/* change enviroment: save db in bogofilter install directory */
rc = VALUE( 'BOGOFILTER_DIR', BOGOFILTER_DIR, 'OS2ENVIRONMENT');

/* process message */
'' BOGOFILTER_DIR || '/bin/bogofilter.exe ' || opt || ' -I ' || messagepath || ' -O ' || messagepath || '.bogo'
bogo_rc = rc;

/* get output file lenght */
call SysFileTree messagepath || '.bogo', 'stat', 'F'
stat_size = word( stat.1, 3);

/* bogo returned 0 (no-error) and file is not zero-lenght */
if bogo_rc = 0 & stat_size > 0 then do
   /* delete original file */
   rc = SysFileDelete( messagepath);
   /* rename filtered output */
   /* say 'rename ' || messagepath || '.bogo ' || messagepath */
   'rename ' || messagepath || '.bogo *.msg'
end
else do
   /* bogofilter failed or output file is truncated */
   /* delete output file */
   say 'bogofilter failed or output file is truncated'
   rc = SysFileDelete( messagepath || '.bogo');
end

/* return 0 to keep message */
RETURN 0;
