/* rexx */
/*
 * Author: Paul Hethmon <phethmon@hethmon.com>
 *   Date: 13 September 1999
 */
/* 
 * This rexx script will resend the mail message it receives to the
 * addresses listed in this file.
 *
 * You must modify the From and ToAddrs variables below.
 *
 * To use this script, copy it to a new name and then modify
 * the variables. It is suggested you use a name the same as
 * the username which will have this script as it's local
 * process delivery option. So if your username is "curly", then
 * copy the file to "curly.cmd".
 *
 */

/* The from address listed here is used as the sender of the email. */
/* This should be a valid address in your domain */
From = 'postmaster@example.com'
/* The addresses is this list will receive the email. You may add */
/* as many as you like. Put one space between addresses on a line */
/* and put a comma on the end of a line to continue it to the next */
/* line. The addresses should be full addresses. */
ToAddrs = 'manager@example.com' 'sales@example.com',
          'support@example.com'

/* ----- End of user modifications ------------------------------- */

Mailer = 'hmailer.exe'
Env = 'OS2ENVIRONMENT'
/* The external functions we need */
call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'

/* Find the temporary directory to use */
TmpDir = value('STEWARD_TMP',,Env)
if TmpDir = '' then do
  TmpDir = value('TMP',,Env)
  if TmpDir = '' then do
    TmpDir = '.'
    end
  end

parse arg ToName MsgFile

say 'ToName =' ToName
say 'MsgFile =' MsgFile

/* Temporary file for group names */
NameFile = SysTempFileName(TmpDir'\?????.tmp', '?')
rc = stream(NameFile, 'C', 'OPEN WRITE')  /* open the file for writing */

/* Copy the addresses to the namefile */
do i = 1 to words(ToAddrs)
  rc = lineout(NameFile, word(ToAddrs, i), )
  say 'ToAddrs = ' word(ToAddrs, i)
  end
rc = stream(NameFile, 'C', 'CLOSE')  /* close the file */

/* Mail it */
Mailer From NameFile MsgFile

exit


