/* Steward Version 1.9 */
/* Errors Module */
/*
 * A mailing list processor in Rexx by Paul Hethmon
 *
 */

/* variable declarations */

Steward = 'Steward'
StewardVersion = 'Version 1.12'
StewardDate = '13 September 1999'
uppercase = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
lowercase = 'abcdefghijklmnopqrstuvwxyz'
Env = 'OS2ENVIRONMENT'
FALSE = 0
TRUE = 1

/* Set to 1 to enable debug output */
Debug = TRUE
/* Set to 1 to enable logging */
Log = TRUE
LogFile = ''
ETime1 = 0
ETime2 = 0
Author = ''
AdminFile = ''
AdminSubject = ''
AdminTo = ''

/* Variables normally read from the configuration file */
/* These values are provided as defaults only */
HomeDir = 'c:'
LogDir = 'c:'
ListDir = 'c:'
Mailer = 'hmailer'
WhereAmI = 'example.com'
WhoAmI = Steward
WhoAmIOwner = 'postmaster@'WhereAmI
MasterPassword = 'steward'
DeleteDelay = FALSE

/* The following are set on a per list basis */
AdminPassword = 'steward-list'
Administrivia = 0
ListOwner = WhoAmIOwner
Advertise = '*'
ApprovePassword = 'steward-pass'
DoArchive = 0
Moderated = 0
NoList = 0
Precedence = 1
ListHeader = 1
DoDigest = 0
DigestVolume = 0
DigestIssue = 0
DigestName = ''
DigestRmHeader = 1
DigestFronter = ''
DigestFooter = ''
DigestSubs = TRUE
SubscribePolicy = 'open'
ReplyTo = ''
SubjectPrefix = 'Steward-List: '
OpenPosting = FALSE
WelcomeFile = ''
CaseInsensitive = FALSE
DeleteDelay = FALSE

/* Some other global variables */
HeadFrom = ''
HeadTo = ''
HeadReplyTo = ''
HeadSubject = ''
HeadDate = ''
HeadCc = ''
HeadSender = ''
HeadEmail = ''
Email = ''
Approved = FALSE
PassWord = ''

/* Delay subject notifications */
DelaySubjs.0 = 2
/* From Inet.Mail */
DelaySubjs.1 = 'Delayed Mail Notification'
/* From sendmail */
DelaySubjs.2 = 'Warning: could not send message for past 4 hours'

/* The external functions we need */
call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'

/* Find the temporary directory to use */
TmpDir = value('STEWARD_TMP',,Env)
if TmpDir = '' then
  do
  TmpDir = value('TMP',,Env)
  end

/* start main function */
/* The first arg is who the message was sent to.
 * The second is the filename. We're responsible
 * for cleaning up the file if needed.
 */
parse arg ListName MsgFile

if Debug = TRUE then say 'ListName =' ListName 'MsgFile =' MsgFile

call on error name ErrHandler

say 'Reading Master Configuration File Now.'

/* Read the master configuration file now */
rc = ReadMasterCf()
if rc = FALSE then
  do
  say 'Unable to read master configuration file. Failing.'
  ErrFile = SysTempFileName('?????.err', '?')
  rc = stream(ErrFile, 'C', 'OPEN WRITE')
  rc = lineout(ErrFile, 'Steward Error File', )
  rc = lineout(ErrFile, 'You must rerun Steward with the recipient name and', )
  rc = lineout(ErrFile, 'message file name listed below in order to process', )
  rc = lineout(ErrFile, 'this message.', )
  rc = lineout(ErrFile, 'ListName =' ListName, )
  rc = lineout(ErrFile, 'MsgFile =', MsgFile, )
  rc = stream(ErrFile, 'C', 'CLOSE')
  exit
  end

/* change to the Steward Home Directory */
Junk = directory(HomeDir)

if Translate(ListName) == Translate(WhoAmI) then 
  ListOwner = WhoAmIOwner 
else 
  call ReadListCf(ListName)
 
say 'ListOwner =' ListOwner

if Debug = TRUE then
  do
  say 'LogDir =' LogDir
  say 'HomeDir = ' HomeDir
  say 'ListDir =' ListDir
  say 'Junk =' Junk
  end

if Log = TRUE then do
  ETime1 = time('E')
  call StartLog
  call WriteLog('ListName =' ListName)
  call WriteLog('MsgFile =' MsgFile)
  end

call DoErrors

/* Make sure the tmp file is deleted */
rc = SysFileDelete(MsgFile)

if Log = TRUE then do
  ETime2 = time('E')
  call StopLog
  end

exit

/* ------------------------------------------------------------------ */

DoErrors:

/* First check and see if this is a delay notification from Inet.Mail */
if DeleteDelay = TRUE then do
  say 'DeleteDelay is true'
  rc = stream(MsgFile, 'C', 'OPEN READ')  /* open the file for reading */
  if rc <> 'READY:' then do
    call WriteLog('Cannot open message file.')
    return
    end
  call ParseHeaders  /* first get the header info */

  do i = 1 to DelaySubjs.0
    if HeadSubject = DelaySubjs.i then do
      call WriteLog('Deleting delay notification message.')
      say 'Deleting delay notification message'
      rc = stream(MsgFile, 'C', 'CLOSE')   /* close the file */
      return
      end
    end
  rc = stream(MsgFile, 'C', 'CLOSE')   /* close the file */
  end

rc = stream(MsgFile, 'C', 'OPEN READ')  /* open the file for reading */
if rc <> 'READY:' then do
  call WriteLog('Cannot open message file.')
  return
  end

/* create a temp file for the outgoing message */
OutFile = SysTempFileName(TmpDir'\f?????.tmp', '?');
rc = stream(OutFile, 'C', 'OPEN WRITE')  /* open the file for writing */
if rc <> 'READY:' then do
  call WriteLog('Cannot create temp file for outgoing message.')
  return
  end

/* write the headers first */
AdminSubject = 'Error message from' WhoAmI
AdminTo = ListOwner
AdminFile = OutFile
call WriteAdminHeaders

rc = lineout(Outfile, WhoAmI 'has received the following error message:', )
rc = lineout(OutFile, '----- begin message ------------------------------', )

/* now copy the rest of the message */
do while lines(MsgFile) <> 0         /* until end of file */
  Line = linein(MsgFile)             /* get a line of the file */
  rc = lineout(OutFile, Line, )      /* write it to the outfile */
  end

rc = lineout(OutFile, '----- end message --------------------------------', )

rc = stream(MsgFile, 'C', 'CLOSE')   /* close both files */
rc = stream(OutFile, 'C', 'CLOSE')

EmailFile = SysTempFileName(TmpDir'\e?????.tmp', '?')
rc = stream(EmailFile, 'C', 'OPEN WRITE')  /* open the file for writing */
if rc <> 'READY:' then do
  call WriteLog('Cannot create email file.')
  rc = SysFileDelete(OutFile)
  return
  end
rc = lineout(EmailFile, ListOwner, )
rc = stream(EmailFile, 'C', 'CLOSE')

say 'Sending message to' ListOwner

/* now mail it to the moderator */
Mailer ListName'-owner@'WhereAmI EmailFile OutFile

return

/* ------------------------------------------------------------------ */
/*
 * Read the master configuration file
 *
 */

ReadMasterCf: procedure expose HomeDir LogDir ListDir Mailer WhereAmI WhoAmI ,
              WhoAmIOwner MasterPassword Env TRUE FALSE Debug TmpDir

if Debug = TRUE then say 'Reading Steward configuration file.'

/* Find out where the configuration file should be */
StewardCf = value('steward_cf',,Env)
/* StewardCf = value('steward_cf_test',,Env) */

/* If its not defined then assume wherever we are */
if StewardCf = '' then do
  StewardCf = '.'
  end

FileName = StewardCf'\steward.cf'

rc = LockOpen(FileName 'READ')  /* open the file locking it */
if rc = FALSE then
  return FALSE                   /* return FALSE if cannot open */

/* now read the configuration file */
do while lines(FileName) <> 0         /* until end of file */
  Line = linein(FileName)             /* get a line of the file */
  parse var Line Line '#' Comment     /* separate out any comments */
  if Line <> '' then do               /* if not null */
    parse var Line Key '=' Val        /* find the key and value */
    if Key <> '' then do
      Val = strip(Val, 'B', ' ')      /* remove any blanks */
      Key = strip(Key, 'B', ' ')
      select
        when Key = 'HomeDir' then
          HomeDir = Val
        when Key = 'LogDir' then
          LogDir = Val
        when Key = 'ListDir' then
          ListDir = Val
        when Key = 'Mailer' then
          Mailer = Val
        when Key = 'WhereAmI' then
          WhereAmI = Val
        when Key = 'WhoAmI' then
          WhoAmI = Val
        when Key = 'WhoAmIOwner' then
          WhoAmIOwner = Val
        when Key = 'MasterPassword' then
          MasterPassword = Val
        when Key = 'DeleteDelay' then
          DeleteDelay = Val
        otherwise nop
        end   /* select */
      end     /* if Key <> '' */
    end       /* if Line <> '' */

  Key = ''

end /* end do while */

rc = LockClose(FileName)

if Debug = TRUE then say 'Steward.cf file read.'

return TRUE

/* ------------------------------------------------------------------ */

ErrHandler:

SIGerrCode = RC
StewardErrLog = 'Steward.err'

if Debug = TRUE then say 'Identified error while executing line #'Sigl'   RC = ['SIGerrCode']'
if Debug = TRUE then say '['SourceLine(Sigl)']'
rc = lineout( StewardErrLog, '     -----', )
rc = lineout( StewardErrLog, 'Error ['SIGerrCode'] while executing line #'Sigl, )
rc = lineout( StewardErrLog, '['SourceLine(Sigl)']')

return


/* ------------------------------------------------------------------ */
/*
 * Read the per list configuration file
 *
 */

ReadListCf: procedure expose ListDir AdminPassword ListOwner Administrivia,
            Advertise ApprovePassword DoArchive Moderated NoList Precedence,
            ListHeader SubscribePolicy ReplyTo SubjectPrefix TRUE FALSE,
            DoDigest DigestRmHeader DigestVolume DigestIssue DigestFronter,
            DigestFooter DigestName Debug Log LogFile OpenPosting WelcomeFile,
            DigestSubs CaseInsensitive TmpDir DeleteDelay

parse arg ListName

if Debug = TRUE then say 'Reading list configuration file for' ListName

/* First check to see if this is a digest request */
parse var ListName List '-' Digest
Digest = translate(Digest, lowercase, uppercase)
if Digest = 'digest' then
  FileName = ListDir'\'List'\'List'.cf'
else  
  FileName = ListDir'\'ListName'\'ListName'.cf'

if Debug = TRUE then say 'Reading filename "'FileName'"'

rc = LockOpen(FileName 'READ')  /* open the file locking it */
if rc = FALSE then
  return FALSE                   /* return FALSE if cannot open */

/* now read the configuration file */
do while lines(FileName) <> 0         /* until end of file */
  Line = linein(FileName)             /* get a line of the file */
  parse var Line Line '#' Comment     /* separate out any comments */
  if Line <> '' then do               /* if not null */
    parse var Line Key '=' Val        /* find the key and value */
    if Key <> '' then do
      Val = strip(Val, 'B', ' ')      /* remove any blanks */
      Key = strip(Key, 'B', ' ')
/*      say Key '=' Val */
      select
        when Key = 'AdminPassword' then
          AdminPassword = Val
        when Key = 'ListOwner' then
          ListOwner = Val
        when Key = 'Administrivia' then
          Administrivia = Val
        when Key = 'Advertise' then
          Advertise = Val
        when Key = 'ApprovePassword' then
          ApprovePassword = Val
        when Key = 'DoArchive' then
          DoArchive = Val
        when Key = 'Moderated' then
          Moderated = Val
        when Key = 'NoList' then
          NoList = Val
        when Key = 'Precedence' then
          Precedence = Val
        when Key = 'ListHeader' then
          ListHeader = Val
        when Key = 'SubscribePolicy' then
          SubscribePolicy = Val
        when Key = 'ReplyTo' then
          ReplyTo = Val
        when Key = 'SubjectPrefix' then
          SubjectPrefix = Val
        when Key = 'DoDigest' then
          DoDigest = Val
        when Key = 'DigestRmHeader' then
          DigestRmHeader = Val
        when Key = 'DigestVolume' then
          DigestVolume = Val
        when Key = 'DigestIssue' then
          DigestIssue = Val
        when Key = 'DigestName' then
          DigestName = Val
        when Key = 'DigestFronter' then
          DigestFronter = Val
        when Key = 'DigestFooter' then
          DigestFooter = Val
        when Key = 'OpenPosting' then
          OpenPosting = Val
        when Key = 'WelcomeFile' then
          WelcomeFile = Val
        when Key = 'DigestSubs' then
          DigestSubs = Val
        when Key = 'CaseInsensitive' then
          CaseInsensitive = Val
        when Key = 'DeleteDelay' then
          DeleteDelay = Val
        otherwise nop
        end   /* select */
      end     /* if Key <> '' */
    end       /* if Line <> '' */

  Key = ''

end /* end do while */

rc = LockClose(FileName)

return TRUE

/* ------------------------------------------------------------------ */

StartLog: procedure expose LogDir LogFile ETime1 ETime2 Debug FALSE TRUE

FileName = LogDir'\?????.log'
LogFile = SysTempFileName(FileName, '?')

if LogFile = '' then
  do
  say 'Cannot create temporary file.'
  say 'Setting logfile to NUL'
  LogFile = 'NUL'
  Log = FALSE
  return
  end

if Debug = TRUE then say 'LogFile =' LogFile

rc = stream(LogFile, 'C', 'OPEN WRITE')

TmpTime = time('N')
TmpDate = date('N')

rc = lineout(LogFile, 'Date:' TmpDate, )
rc = lineout(LogFile, 'Time:' TmpTime, )

return

/* ------------------------------------------------------------------ */

StopLog: procedure expose LogFile LogDir ETime1 ETime2 Debug FALSE TRUE

ETime = ETime2 - Etime1

if Debug= TRUE then say 'Elapsed Time =' ETime

call WriteLog('Elapsed Time:' ETime)
call WriteLog('')
call WriteLog('=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=')
call WriteLog('')

rc = stream(LogFile, 'C', 'CLOSE')

PermLog = LogDir'\steward.log'

call AppeLock(LogFile PermLog)

rc = SysFileDelete(LogFile)

return

/* ------------------------------------------------------------------ */

WriteLog: procedure expose LogFile

parse arg String

rc = lineout(LogFile, String, )

return
  
/* ------------------------------------------------------------------ */
/*
 * Write out our standard headers for an admin message
 *
 */

WriteAdminHeaders: procedure expose AdminTo WhoAmI WhereAmI AdminSubject AdminFile,
                   Env

TimeZone = value( 'TZ', , Env)
TmpTime = time('N')
DayOfWeek = date('W')
DayOfWeek = left(DayOfWeek, 3)
TmpDate = date('N')
rc = lineout(AdminFile, 'Date:' DayOfWeek',' TmpDate TmpTime TimeZone, )
rc = lineout(AdminFile, 'Sender:' WhoAmI'-owner <'WhoAmI'-owner@'WhereAmI'>', )
rc = lineout(AdminFile, 'From:' WhoAmI'-owner <'WhoAmI'-owner@'WhereAmI'>', )
rc = lineout(AdminFile, 'Reply-To:' WhoAmI '<'WhoAmI'@'WhereAmI'>', )
rc = lineout(AdminFile, 'To:' AdminTo, )
rc = lineout(AdminFile, 'Subject:' AdminSubject, )
rc = lineout(AdminFile, '', )

return

/* ------------------------------------------------------------------ */
/*
 * Parse RFC822 headers
 *
 */

ParseHeaders: procedure expose HeadTo HeadFrom HeadReplyTo MsgFile HeadSubject ,
              lowercase uppercase HeadDate HeadCc HeadSender Log FALSE TRUE LogFile,
              TmpDir

say 'ParseHeaders starting'

Line = linein(MsgFile)                /* get a line of the file */
do while Line <> ''                   /* until end of headers */
  parse var Line Key ':' Val          /* separate out the components */
  Key = translate(Key, lowercase, uppercase)
  Val = strip(Val, 'B', ' ')
  select
    when Key = 'to' then
      HeadTo = Val
    when Key = 'reply-to' then
      HeadReplyTo = Val
    when Key = 'from' then
      HeadFrom = Val
    when Key = 'subject' then
      HeadSubject = Val
    when Key = 'date' then
      HeadDate = Val
    when Key = 'cc' then
      HeadCc = Val
    when Key = 'sender' then
      HeadSender = Val
    otherwise nop
    end   /* select */
  Line = linein(MsgFile)
end       /* do while */

if Log = TRUE then
  do
  say 'Writing headers info to log file'
  call WriteLog('ParseHeaders Info:')
  call WriteLog(' To:' HeadTo)
  call WriteLog(' From:' HeadFrom)
  call WriteLog(' Reply-to:' HeadReplyTo)
  call WriteLog(' Subject:' HeadSubject)
  end

return

/* ------------------------------------------------------------------ */

IsOREXX: PROCEDURE                               /*wfs 7-Aug-1997*/
  PARSE VERSION rx ver dt
  RETURN rx = 'OBJREXX'

/* ------------------------------------------------------------------ */
/* ------------------------------------------------------------------ */
/* ------------------------------------------------------------------ */
/* ------------------------------------------------------------------ */




