/* SendDigest
 *
 * This script will send out digests once per day at the time
 * you set.
 *
 * It must be started from the Steward directory where the
 * digest.cmd file is.
 *
 * Original written by Paul Hethmon
 *
 * Rewritten 13-Dec-1998 by Bill Schindler
 *   All variable information is loaded from DIGEST.CF
 */

SendDigestVersion = 'Version 1.12'
SendDigestDate = '13 September 1999'

SIGNAL ON Halt

CALL RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'

/* Some useful variables */
TRUE  = 1
FALSE = 0
upper = XRange('A', 'Z')
lower = XRange('a', 'z')
env   = 'OS2ENVIRONMENT'

debug = FALSE

/*
 * Variables normally read from the configuration file.
 * These values are provided as defaults only.
 */
masterCf. = ''
masterCf.homeDir        = 'C:'
masterCf.logDir         = 'C:'
masterCf.listDir        = 'C:'
masterCf.mailer         = 'hmailer'
masterCf.whereAmI       = 'example.com'
masterCf.whoAmI         = Steward
masterCf.whoAmIOwner    = 'postmaster@' || masterCf.whereAmI
masterCf.masterPassword = 'steward'

/*
 * Variables normally read from the digest configuration file.
 */
digestCf. = ''
digestCf.sendAtHour     = '1'

/*
 * Read the configuration file
 */
IF \ ReadMasterCf() THEN
 DO
  SAY 'Error: Could not read Steward master configuration file!'
  RETURN
 END

lists.  = ''
lists.0 = 0
waitUntil = 1 /* default to 1:00am */

CALL GetConfiguration

/*
 * Main process loop - runs until Ctrl+Break received
 */
DO FOREVER
  SAY Date() Time() '- Sleeping until' Right(waitUntil, 2, '0') || ':00...'
  CALL SleepUntilHour(waitUntil)

  CALL GetConfiguration
  SAY Date() Time() '- Sending digests:'

  /* Process each list's digest */
  DO i = 1 TO lists.0
    SAY '   >' Date() Time() '-' lists.i
    CALL digest lists.i
  END
END

RETURN

/***************************************************************************
 * Get the configuration and distribute to variables
 */
GetConfiguration: PROCEDURE EXPOSE digestCf. lists. waitUntil ,
                                   masterCf. TRUE FALSE
  IF \ ReadDigestCf() THEN
   DO
    SAY 'Error: Could not read Digest configuration file!'
   END
  ELSE
   DO  
    /*
     * Build the list of lists
     *   Append '-digest' to each name
     */
    ll = digestCf.digestLists
    DO n = 1 WHILE ll >< ''
      PARSE VALUE Strip(ll, 'B') WITH lname ll
      lists.n = lname || '-digest'
      lists.0 = n
    END
    waitUntil = digestCf.sendAtHour
   END
  RETURN

/***************************************************************************
 * Sleep until a given hour of the day
 */
SleepUntilHour: PROCEDURE
  PARSE ARG hr
  hr = hr * 60
  seconds = ((24 * 60) - Time('M') + hr) * 60
  CALL SysSleep seconds
  RETURN

/***************************************************************************
 * Read the digest configuration file
 */
ReadDigestCf: PROCEDURE EXPOSE masterCf. digestCf. TRUE FALSE
  fileName = masterCf.homeDir || '\digest.cf'
  rc = LockOpen(fileName 'READ')  /* open the file locking it */
  IF rc = FALSE THEN
    RETURN FALSE                  /* return FALSE if cannot open */
  
  /* now read the configuration file */
  DO WHILE lines(fileName) <> 0         /* until end of file */
    line = LineIn(fileName)             /* get a line of the file */
    PARSE VAR line line '#' comment     /* separate out any comments */
    IF Line <> '' THEN
     DO                                 /* if not null */
      PARSE VAR Line Key '=' Val        /* find the key and value */
      IF key <> '' THEN
       DO
        val = Strip(val, 'B')           /* remove any blanks */
        key = Translate(Strip(key, 'B'))
        digestCf.key = val
       END     /* if key <> ''  */
     END       /* if Line <> '' */

    key = ''
  END /* end do while */

  rc = LockClose(fileName)
  RETURN TRUE

/***************************************************************************
 * Read the master configuration file
 */
ReadMasterCf: PROCEDURE EXPOSE masterCf. env TRUE FALSE debug

  IF debug THEN SAY 'Reading Steward configuration file.'

  /* Find out where the configuration file should be */
  stewardCf = value('steward_cf',,env)
  
  /* If its not defined then assume wherever we are */
  IF stewardCf = '' THEN
   DO
    stewardCf = '.'
   END
  
  fileName = StewardCf'\steward.cf'
  
  rc = LockOpen(fileName 'READ')  /* open the file locking it */
  IF rc = FALSE THEN
    RETURN FALSE                  /* return FALSE if cannot open */
  
  /* now read the configuration file */
  DO WHILE lines(fileName) <> 0         /* until end of file */
    line = LineIn(fileName)             /* get a line of the file */
    PARSE VAR line line '#' comment     /* separate out any comments */
    IF Line <> '' THEN
     DO                                 /* if not null */
      PARSE VAR Line Key '=' Val        /* find the key and value */
      IF key <> '' THEN
       DO
        val = Strip(val, 'B')           /* remove any blanks */
        key = Translate(Strip(key, 'B'))
        masterCf.key = val
       END     /* if key <> ''  */
     END       /* if Line <> '' */

    key = ''
  END /* end do while */
  
  rc = LockClose(fileName)
  
  IF debug THEN SAY 'Steward.cf file read.'
  
  RETURN TRUE

/***************************************************************************
 * Ctrl+Break processing
 */
Halt:
  SAY Date() Time() '- SendDigest halted'
  EXIT

