/*
 * Webarchive.cmd 1.1
 *
 * Written by: Paul Hethmon <phethmon@hethmon.com>
 * Date: 17 February 1998
 *
 * This REXX script will take a file pattern to match
 * such as *.msg and then put all messages which match
 * into the list archives. This script is designed to
 * work on the messages the version 2 List2Web script
 * generated.
 *
 * So you have a directory full of text email messages
 * that you want to put into the new html format. Firs
 * run "order.cmd" in that directory to rename the files
 * in chronological order. Now run this script to read
 * those files in chronological order and echo them
 * to the web pages. If you don't put them in 
 * chronological order, then the messages will not be
 * in order within a particular day since the filenames
 * are random.
 *
 */

/* Do not modify this section */
hi = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
lo = 'abcdefghijklmnopqrstuvwxyz'
Env = 'OS2ENVIRONMENT'
FALSE = 0
TRUE = 1
Copy = 'copy'
Mkdir = 'mkdir'
HeadFrom = ''
HeadTo = ''
HeadReplyTo = ''
HeadSubject = ''
HeadDate = ''
HeadCc = ''
HeadSender = ''
HeadContentType = ''
HeadMimeVersion = ''
TmpDir = ''
/* End of section to not modify */

/* Set L2wLocation to a value to override the environment
 * variable or to not use it.
 */
L2wLocation = 'd:\inetmail\l2w\Ver3'
/* Set to 1 to enable logging */
Log = TRUE
LogDir = ''
LogFile = ''

/* The external functions we need */
call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

/* Find the temporary directory to use */
TmpDir = value('STEWARD_TMP',,Env)
if TmpDir = '' then do
  TmpDir = value('TMP',,Env)
  end

/* start main function */
/* The first arg is who the message was sent to.
 * The second is the filename. We're responsible
 * for cleaning up the file if needed.
 */
parse arg UserName Pattern

if Log = TRUE then do
  call StartLog
  call WriteLog('UserName =' UserName)
  call WriteLog('Pattern  =' Pattern)
  end

call on error name ErrHandler

/* Read the per username configuration file */
rc = ReadMasterCf()
if rc = FALSE then do
  say 'Unable to open configuration file for' UserName
  say 'Using List2Web main directory of' L2wCf
  exit
  end

rc = SysFileTree(Pattern, s., 'FO')

if rc = 0 then do iii = 1 to s.0

  Tmpfile1 = s.iii
  /* now call the basic stuff to add it to the website */
  HeadFrom = ''
  HeadTo = ''
  HeadReplyTo = ''
  HeadSubject = ''
  HeadDate = ''
  HeadCc = ''
  HeadSender = ''
  HeadContentType = ''
  HeadMimeVersion = ''
  call Basic(Tmpfile1)

  end

if Log = TRUE then do
  call StopLog
  end

exit

/* -------------------------------------------------------- */

Basic:

parse arg MsgFile

rc = stream(MsgFile, 'c', 'open read')
call ParseHeaders

/* Change all '<' to '&lt' for the html output */
x = pos('<', HeadFrom, 1)
do while x <> 0
  HeadFrom = overlay(' ', HeadFrom, x)
  HeadFrom = insert('&lt;', HeadFrom, x)
  x = pos('<', HeadFrom, 1)
  end
/* Change all '>' to '&gt' for the html output */
x = pos('>', HeadFrom, 1)
do while x <> 0
  HeadFrom = overlay(' ', HeadFrom, x)
  HeadFrom = insert('&gt;', HeadFrom, x)
  x = pos('>', HeadFrom, 1)
  end
/* Change all '<' to '&lt' for the html output */
x = pos('<', HeadTo, 1)
do while x <> 0
  HeadTo = overlay(' ', HeadTo, x)
  HeadTo = insert('&lt;', HeadTo, x)
  x = pos('<', HeadTo, 1)
  end
/* Change all '>' to '&gt' for the html output */
x = pos('>', HeadTo, 1)
do while x <> 0
  HeadTo = overlay(' ', HeadTo, x)
  HeadTo = insert('&gt;', HeadTo, x)
  x = pos('>', HeadTo, 1)
  end
/* Change all '<' to '&lt' for the html output */
x = pos('<', HeadReplyTo, 1)
do while x <> 0
  HeadReplyTo = overlay(' ', HeadReplyTo, x)
  HeadReplyTo = insert('&lt;', HeadReplyTo, x)
  x = pos('<', HeadReplyTo, 1)
  end
/* Change all '>' to '&gt' for the html output */
x = pos('>', HeadReplyTo, 1)
do while x <> 0
  HeadReplyTo = overlay(' ', HeadReplyTo, x)
  HeadReplyTo = insert('&gt;', HeadReplyTo, x)
  x = pos('>', HeadReplyTo, 1)
  end

if UseMsgDate = TRUE then do
  /* Now we must determine the date of the message by the message header */
  /* Date: Mon, 1 Dec 1997 09:54:23 -0500 */
  if lastpos(',', HeadDate) = 0 then
    parse var HeadDate Day Month Year Hour ':' Minute ':' Second Tz
  else
    parse var HeadDate twkday Day Month Year Hour ':' Minute ':' Second Tz
  select
    when Month = 'Jan' then
      FullMonth = 'January'
    when Month = 'Feb' then
      FullMonth = 'February'
    when Month = 'Mar' then
      FullMonth = 'March'
    when Month = 'Apr' then
      FullMonth = 'April'
    when Month = 'May' then
      FullMonth = 'May'
    when Month = 'Jun' then
      FullMonth = 'June'
    when Month = 'Jul' then
      FullMonth = 'July'
    when Month = 'Aug' then
      FullMonth = 'August'
    when Month = 'Sep' then
      FullMonth = 'September'
    when Month = 'Oct' then
      FullMonth = 'October'
    when Month = 'Nov' then
      FullMonth = 'November'
    when Month = 'Dec' then
      FullMonth = 'December'
    otherwise
      FullMonth = Month
  end  /* select */
  end  /* if */
else do
  TmpDate = date('N')
  parse var TmpDate Day Month Year
  FullMonth = date('M')
  end  /* else */

/* Check for single digit days and adjust */
if length(Day) < 2 then do
  Day = '0'||Day
  Day = right(Day, 2)
  end

/* check for 2 digit years */
if length(Year) = 2 then do
  Year = '19'||Year
  Year = left(Year, 4)
  end

say 'MsgFile  =' MsgFile
say 'HeadDate =' HeadDate
say 'Year     =' Year
say 'Month    =' Month
say 'Day      =' Day
say 'Webstem  =' Webstem

/* Check for Year directory existence */
MsgArchive = Webstem'\'Year
rc = SysFileTree(MsgArchive, d., 'DO')
if d.0 = 0 then do  /* directory doesn't exist, create it */
  say 'Year directory not found =' MsgArchive
  call NewYear
  end

/* Check for Month directory existence */
MsgArchive = Webstem'\'Year'\'Month
rc = SysFileTree(MsgArchive, d., 'DO')
if d.0 = 0 then do  /* directory doesn't exist, create it */
  say 'Month directory not found =' MsgArchive
  call NewMonth
  end

/* Open the webpage locking out other updaters */
Webpage1 = Webstem'\'Year'\'Month'\Day'Day'.html'
rc = Lock(Webpage1)
say 'locking webpage =' Webpage1

MsgArchive = Webstem'\'Year'\'Month'\Msgs\l2w?????.html'
Webfile = SysTempFileName(MsgArchive, '?')
x = lastpos('\', Webfile)           /* pull off the filename alone */
FileName = substr(Webfile, x + 1)
FileName = 'Msgs/'FileName  /* href location */

if ( Log = TRUE ) then do 
  call WriteLog('MsgFile =' MsgFile 'Tmpfile1 =' Tmpfile1)
  end

/* Temporary file for the updated webpage */
Tmpfile1 = SysTempFileName(TmpDir'\l2w?????.html', '?')
rc = stream(Tmpfile1, 'c', 'open write')

/* Now open the main web page */
rc = stream(Webpage1, 'c', 'query exists')
if rc = '' then do  /* file doesn't exist, create it */
  say 'Daily webpage not found =' Webpage1
  call NewDaily
  end

rc = stream(Webpage1, 'c', 'open read')

if HeadFrom = '' then HeadFrom = 'Unknown Sender'
if HeadSubject = '' then HeadSubject = 'Unknown Subject'
if HeadDate = '' then HeadDate = 'Unknown Date'

do while lines(Webpage1) <> 0         /* until end of file */
  Line = linein(Webpage1)             /* get a line of the file */
  if Line <> Marker then do
    rc = lineout(Tmpfile1, Line)
    LastLine = Line
    end
  else do  /* found marker, insert new record */
    rc = charout(Tmpfile1, '<tr><td>' HeadFrom '</td>')
    rc = charout(Tmpfile1, '<td><a href="'FileName'">'HeadSubject'</a></td>')
    rc = lineout(Tmpfile1, '<td>'HeadDate'</td></tr>')
    rc = lineout(Tmpfile1, Marker)
    parse var LastLine First '<a href="' PrevName '">' Last
    end
end

/* Copy the message file to the archive location */
call NewMsg(MsgFile Webfile)

rc = stream(Webpage1, 'c', 'close')
rc = stream(Tmpfile1, 'c', 'close')
copy Tmpfile1 Webpage1
rc = SysFileDelete(Tmpfile1)
rc = SysFileDelete(MsgFile)

/* Unlock the update now */
rc = UnLock(Webpage1)

return

/* ------------------------------------------------------------------ */
/*
 * Take the incoming message file and convert it to html.
 */

NewMsg:

/* the msg file is still open at this point and the headers are parsed */

rc = stream(Webfile, 'c', 'open write')
TmpTemplate = SysTempFileName(TmpDir'\msg?????.l2w', '?')
Copy MsgTemplate TmpTemplate
rc = stream(TmpTemplate, 'c', 'open read')

/* first look for the title marker */
do while pos(TitleMarker, Line) = 0
  Line = linein(TmpTemplate)
  i = pos(TitleMarker, Line)
  if i = 0 then do
    rc = lineout(Webfile, Line)
    end
  else do  /* found marker, insert title */
    rc = lineout(Webfile, '<title>'HeadSubject'</title>',)
    end
  end

/* Now look for the body marker */
Line = linein(TmpTemplate)
do while pos(BodyMarker, Line) = 0
  rc = lineout(Webfile, Line)
  Line = linein(TmpTemplate)
  end

/* found body marker, so insert the body of the message */
rc = lineout(Webfile, 'Return to [ <a href="../Day'Day'.html">'Day'</a> | ',)
rc = lineout(Webfile, '<a href="../index.html">'FullMonth'</a> | ',)
rc = lineout(Webfile, '<a href="../../index.html">'Year'</a> ]<p>',)

/* Now the prev/next message stuff */
if PrevName <> '' then do
  parse var PrevName 'Msgs/' PrevLink
  rc = lineout(Webfile, '&lt;&lt; <a href="'PrevLink'">Previous Message</a> &lt;&lt; ',)
  rc = lineout(Webfile, NextMarker,)
  rc = lineout(Webfile, '<hr size=4><p>',)
  call UpdatePrevLink
  end
else do
  rc = lineout(Webfile, NextMarker,)
  rc = lineout(Webfile, '<hr size=4><p>',)
  end

rc = lineout(Webfile, '<table rows=5 cols=2 cellspacing=5 cellpadding=0>',)
rc = lineout(Webfile, '<tr><td align=right>Date:</td><td>' HeadDate '</td></tr>',)
TmpFrom = EmailConvert(HeadFrom)
rc = lineout(Webfile, '<tr><td align=right>From:</td><td>' TmpFrom '</td></tr>',)
TmpReplyTo = EmailConvert(HeadReplyTo)
rc = lineout(Webfile, '<tr><td align=right>Reply-To:</td><td>' TmpReplyTo '</td></tr>',)
TmpTo = EmailConvert(HeadTo)
rc = lineout(Webfile, '<tr><td align=right>To:</td><td>' TmpTo '</td></tr>',)
rc = lineout(Webfile, '<tr><td align=right>Subject:</td><td><b>' HeadSubject '</b></td></tr>',)
rc = lineout(Webfile, '</table>',)
rc = lineout(Webfile, '<p>',)

/* Try to determine if this is a MIME message and if so */
/* separate the binary body parts out */
if HeadContentType <> '' then do
  /* determine the mime type */
  /* Content-Type: multipart/mixed; boundary="pIo0sNt1rNo2aOd3mVa4iAl5eLr" */
  parse var HeadContentType Type '/' SubType ';'  'oundary=' Boundary
  /* now remove any quoting on the Boundary */
  if left(Boundary, 1) = '"' then do
    Boundary = overlay(' ', Boundary, 1)
    end
  if right(Boundary, 1) = '"' then do
    i = length(Boundary)
    Boundary = overlay(' ', Boundary, i)
    end
  Boundary = strip(Boundary)

  /* Hack so that TextType doesn't stop at first blank line */
  if Boundary = '' then
    Boundary = 'qwertyuiopasdfghjklzxcvbnm!@#$%^&*()_+|1234567890'
  
  Type = translate(Type, lo, hi)
  SubType = translate(SubType, lo, hi)

  if Type = 'multipart' then do  /* we've found one to break apart */
    /* the boundary lines */
    EndBoundary = '--'Boundary'--'
    Boundary = '--'Boundary

    /* first find the beginning boundary marker */
    MsgLine = linein(MsgFile)
    Preamble.0 = 0
    idx = 1;
    do while MsgLine <> Boundary & lines(MsgFile) <> 0
      if MsgLine <> '' then do
        Preamble.idx = MsgLine
        Preamble.0 = idx
        idx = idx + 1
        end
      MsgLine = linein(MsgFile)
      end
    /* determine if any preamble material was found and display if necessary */
    if Preamble.0 > 0 then do
      rc = lineout(Webfile, '<hr size=4>',)
      do i = 0 to Preamble.0 by 1
        rc = lineout(Webfile, Preamble.i '<br>',)
        end
      end /* end if */

    /* we now have the beginning boundary marker found */
    /* we must go through the various parts now */
    do while lines(MsgFile) <> 0  /* until the end of the file */
      rc = lineout(Webfile, '<hr size=4>',)
      MsgLine = linein(MsgFile)   /* should be content type line */
      if MsgLine <> '' then do
        parse var MsgLine Header ':' Type '/' SubType ';' Params
        Type = translate(Type, lo, hi)
        SubType = translate(SubType, lo, hi)
        end
      else do
        Type = 'text'
        Subtype = 'plain'
        end
      select
        when Type = 'text' then do
          rc = lineout(Webfile, '<font size=-1>Content Type: <b>text/'SubType'</b></font><p>',)
          call TextType
          end
        when Type = '' then do
          rc = lineout(Webfile, '<font size=-1>Content Type: <b>text/plain</b></font><p>',)
          call TextType
          end
        when Type = 'application' then do
          rc = lineout(Webfile, '<font size=-1>Content Type: <b>application/'SubType'</b></font><p>',)
          call AppType
          end
        when Type = 'image' then do
          rc = lineout(Webfile, '<font size=-1>Content Type: <b>image/'SubType'</b></font><p>',)
          call AppType
          end
        when Type = 'audio' then do
          rc = lineout(Webfile, '<font size=-1>Content Type: <b>audio/'SubType'</b></font><p>',)
          call AppType
          end
        when Type = 'video' then do
          rc = lineout(Webfile, '<font size=-1>Content Type: <b>video/'SubType'</b></font><p>',)
          call AppType
          end
        when Type = 'message' then do
          rc = lineout(Webfile, '<font size=-1>Content Type: <b>message/'SubType'</b></font><p>',)
          call MsgType
          end
        otherwise do
          rc = lineout(Webfile, '<font size=-1>Content Type: <b>'Type'/'SubType'</b></font><p>',)
          call TextType
          end
        end  /* end select */
        if MsgLine = EndBoundary then leave
      end /* end while */
    end
  else do /* any other main type we just output */
    /* This covers: text, message, etc */
    rc = lineout(Webfile, '<font size=-1>Content Type: <b>'Type'/'SubType'</b></font><p>',)
    call TextType
    end

  end
else do /* no content-type header, so just output the message */
  call TextType
  end

/* Now the prev/next message stuff */
if PrevName <> '' then do
  parse var PrevName 'Msgs/' PrevLink
  rc = lineout(Webfile, '<hr size=4>',)
  rc = lineout(Webfile, '&lt;&lt; <a href="'PrevLink'">Previous Message</a> &lt;&lt; ',)
  rc = lineout(Webfile, NextMarker,)
  rc = lineout(Webfile, '<p>',)
  end
else do
  rc = lineout(Webfile, '<hr size=4>',)
  rc = lineout(Webfile, NextMarker,)
  rc = lineout(Webfile, '<p>',)
  end

rc = lineout(Webfile, 'Return to [ <a href="../Day'Day'.html">'Day'</a> | ',)
rc = lineout(Webfile, '<a href="../index.html">'FullMonth'</a> | ',)
rc = lineout(Webfile, '<a href="../../index.html">'Year'</a> ]<p>',)
rc = lineout(Webfile, '<hr size=4>',)

/* now go through the template file */
do while lines(TmpTemplate) <> 0
  Line = linein(TmpTemplate)
  rc = lineout(Webfile, Line,)
  end

rc = stream(TmpTemplate, 'c', 'close')
rc = SysFileDelete(TmpTemplate)
rc = stream(Webfile, 'c', 'close')
rc = stream(MsgFile, 'c', 'close')

return

/* ------------------------------------------------------------------ */

UpdatePrevLink: procedure expose Webstem Year Month PrevLink TmpDir FileName,
                NextMarker Copy

PrevFile = Webstem'\'Year'\'Month'\Msgs\'PrevLink
PrevTmp = SysTempFileName(TmpDir'\pl?????.tmp', '?')

rc = stream(PrevFile, 'c', 'open read')
rc = stream(PrevTmp, 'c', 'open write')

parse var FileName 'Msgs/' ThisLink

do while lines(PrevFile) <> 0         /* until end of file */
  PLine = linein(PrevFile)             /* get a line of the file */
  if PLine <> NextMarker then do
    rc = lineout(PrevTmp, PLine)
    end
  else do  /* found marker, insert new record */
    rc = lineout(PrevTmp, ' &gt;&gt; <a href="'ThisLink'">Next Message</a> &gt;&gt;',) 
    end
end

rc = stream(PrevFile, 'c', 'close')
rc = stream(PrevTmp, 'c', 'close')
Copy PrevTmp PrevFile
rc = SysFileDelete(PrevTmp);

return

/* ------------------------------------------------------------------ */

TextType:

if SubType <> 'html' then do
  MsgLine = linein(MsgFile)
  do while MsgLine <> Boundary & MsgLine <> EndBoundary & lines(MsgFile) <> 0
    if MsgLine = '' then do
      rc = lineout(Webfile, '<p>',)
      end
    else do
      MsgLine = UrlConvert(MsgLine)
      rc = lineout(Webfile, MsgLine '<br>',)
      end
    MsgLine = linein(MsgFile)
    end
  end
else do  /* html, don't do any additional markup */
  MsgLine = linein(MsgFile)
  do while MsgLine <> Boundary & MsgLine <> EndBoundary & lines(MsgFile) <> 0
    if MsgLine = '' then do
      rc = lineout(Webfile, '',)
      end
    else do
      rc = lineout(Webfile, MsgLine,)
      end
    MsgLine = linein(MsgFile)
    end
  end

/* Check for last line, special case */
if lines(MsgFile) = 0 then do
  if MsgLine <> '' then do
    rc = lineout(WebFile, MsgLine,)
    end
  end

return

/* ------------------------------------------------------------------ */

AppType:


/*  Ok. We've now found a content-type of application / *. It's likely   */
/*  that the next few lines will tell us what to do with it. We search */
/*  for information until we find the blank line. The blank line is    */
/*  the delimiter between the boundary and the message content and is  */
/*  not considered part of the message itself.                         */

Encoding = ''
Description = ''
ViewType = ''
MimeName = ''

MsgLine = linein(MsgFile)  /* grab a line to start */
do while MsgLine <> ''
  parse var MsgLine Header ':' Field
  Header = translate(Header, lo, hi)
  select
    when Header = 'content-transfer-encoding' then do
/*      rc = lineout(Webfile, 'Content-Transfer-Encoding is' Field '<br>')*/
      Encoding = Field
      end
    when Header = 'content-disposition' then do
/*      rc = lineout(Webfile, 'Content-Disposition is' Field '<br>')*/
      parse var Field ViewType ';' 'filename=' MimeName
      /* now remove any quoting on the MimeName */
      if left(MimeName, 1) = '"' then do
        MimeName = overlay(' ', MimeName, 1)
        end
      if right(MimeName, 1) = '"' then do
        i = length(MimeName)
        MimeName = overlay(' ', MimeName, i)
        end
      MimeName = strip(MimeName)
/*      rc = lineout(Webfile, 'ViewType =' ViewType '; MimeName =' MimeName '<br>')*/
      end
    when Header = 'content-description' then do
/*      rc = lineout(Webfile, 'Content-Description is' Field '<br>')*/
      Description = Field
      end
    otherwise do
      rc = lineout(Webfile, 'Unknown header:' Header ':' Field '<br>')
      end
    end
  MsgLine = linein(MsgFile)
  end

 /* We must check and see if we received a filename in the Content-Disposition */
 /* header. If not, look and see if the params for Content-Type included a     */
 /* name or not. */
 if MimeName = '' then do
   if Params <> '' then do
     parse var Params Other 'name=' MimeName
     /* now remove any quoting on the MimeName */
     if left(MimeName, 1) = '"' then do
       MimeName = overlay(' ', MimeName, 1)
       end
     if right(MimeName, 1) = '"' then do
       i = length(MimeName)
       MimeName = overlay(' ', MimeName, i)
       end
     MimeName = strip(MimeName)
     end
   /* Check and make sure we have some type of name now */
   if MimeName = '' then do
     MimeName = 'unknown'
     end
   end

 /* Ok. Now we need to determine what to do next. We have the possibility */
 /* of having 7bit, quoted printable, base64, 8bit, or binary CTE. For    */
 /* 7bit and quoted printable, we'll punt and just display it as it is    */
 /* now. For base64, we'll decode and provide a link. For 8bit and binary */
 /* we'll provide a link */

Encoding = translate(Encoding, lo, hi)
if Encoding = 'base64' then do
  TempFile = TmpDir'\mime????.tmp'
  TempFile = SysTempFileName(TempFile, '?')
  rc = stream(TempFile, 'c', 'open write')
  /* write the base64 encoding to a temporary file, stop at marker */
  MsgLine = ''
  do while MsgLine <> Boundary & MsgLine <> EndBoundary & lines(MsgFile) <> 0
    if MsgLine <> '' then do
      rc = lineout(TempFile, MsgLine,)
      end
    MsgLine = linein(MsgFile)
    end
  rc = stream(TempFile, 'c', 'close')
  /* now we must decode it */
  MimeName = GetStoredName(MimeName)
  say 'Decoding base64 attachment ...'
  call debase64(TempFile MimeName)
  rc = SysFileDelete(TempFile)
  i = lastpos('\', MimeName)
  LinkName = substr(MimeName, i+1)
  rc = lineout(Webfile, 'File attachment: ')
  rc = lineout(Webfile, '<a href="Files/'LinkName'">'LinkName'</a><p>')

  return  /* done with this part */
  end

if Encoding = '8bit' | Encoding = 'binary' then do
  MimeName = GetStoredName(MimeName)
  rc = stream(MimeName, 'c', 'open write')
  /* write the binary information to a temporary file, stop at marker */
  do while MsgLine <> Boundary & MsgLine <> EndBoundary & lines(MsgFile) <> 0
    MsgLine = linein(MsgFile)
    if MsgLine <> '' then do
      rc = lineout(MimeName, MsgLine,)
      end
    end
  rc = stream(MimeName, 'c', 'close')
  /* now we must decode it */
  i = lastpos('\', MimeName)
  LinkName = substr(MimeName, i+1)
  rc = lineout(Webfile, 'File attachment: ')
  rc = lineout(Webfile, '<a href="Files/'LinkName'">'LinkName'</a><p>')

  return  /* done with this part */
  end

/* default encoding is 7bit or quoted printable */
do while MsgLine <> Boundary & MsgLine <> EndBoundary & lines(MsgFile) <> 0
  MsgLine = linein(MsgFile)
  if MsgLine = '' then do
    rc = lineout(Webfile, '<p>',)
    end
  else do
    rc = lineout(Webfile, MsgLine '<br>',)
    end
  end

return

/* ------------------------------------------------------------------ */

MsgType:

MsgLine = linein(MsgFile)
do while MsgLine <> Boundary & MsgLine <> EndBoundary & lines(MsgFile) <> 0
  if MsgLine = '' then do
    rc = lineout(Webfile, '<p>',)
    end
  else do
    rc = lineout(Webfile, MsgLine '<br>',)
    end
  MsgLine = linein(MsgFile)
  end

return

/* ------------------------------------------------------------------ */
/* This function creates a filename for storing the attachment based  */
/* on the MimeName extracted from the message. It creates the file in */
/* the "Files" directory underneath the "Msgs" directory.             */

GetStoredName: procedure expose Webstem Month Year MkDir

parse arg MimeName

/* First, only a filename allowed, no path */
i = lastpos('\', MimeName)
if i <> 0 then do
  MimeName = right(MimeName, i+1)
  end
i = lastpos(MimeName, '/')
if i <> 0 then do
  MimeName = right(MimeName, i+1)
  end

/* now make sure the Files directory exists */
FilesDir = Webstem'\'Year'\'Month'\Msgs\Files'
rc = SysFileTree(FilesDir, d., 'DO')
if d.0 = 0 then do  /* directory doesn't exist, create it */
  say 'Files directory not found =' FilesDir
  MkDir FilesDir
  end

/* Now try for the base filename */
TempFile = FilesDir'\'MimeName
rc = stream(TempFile, 'c', 'query exists')
if rc = '' then do
  rc = stream(TempFile, 'c', 'open write')
  rc = lineout(TempFile, 'attachment file')
  rc = stream(TempFile, 'c', 'close')
  return TempFile
  end

/* if we're here, then we the name was already taken */
TempFile = FilesDir'\???'MimeName
TempFile = SysTempFileName(TempFile, '?')
rc = stream(TempFile, 'c', 'open write')
rc = stream(TempFile, 'c', 'close')
return TempFile

/* ------------------------------------------------------------------ */
/* Look for email addresses and convert to links if found */

EmailConvert: procedure expose lo hi

parse arg EmailLine

i = pos('@', EmailLine)
if i <> 0 then do
  if pos('&lt;', EmailLine) > 0 then do
    parse var EmailLine Part1 '&lt;' Part2 '&gt;' Part3
    if pos('@', Part1) > 0 then
      EmailLine = '<a href="mailto:'Part1'">&lt;'Part1'</a>&gt;' Part2 '>' Part3
    else if pos('@', Part2) > 0 then
      EmailLine = Part1 '&lt;<a href="mailto:'Part2'">'Part2'</a>&gt;' Part3
    else if pos('@', Part3) > 0 then
      EmailLine = Part1 '&lt;'Part2'&gt; <a href="mailto:'Part3'">'Part3'</a>'
    end
  else
    EmailLine = '<a href="mailto:'EmailLine'">'EmailLine'</a>'
  end

return EmailLine

/* ------------------------------------------------------------------ */
/* Look for urls and convert the line to links if found */

UrlConvert: procedure expose lo hi

parse arg MsgLine

/* first look for http links */
TmpLine = translate(MsgLine, lo, hi)

loop = 0
j = 1
i = 1
do while i <> 0
  loop = loop + 1
  i = pos('http://', TmpLine, j)
  if i <> 0 then do
    j = pos(' ', MsgLine, i)  /* find end of url string by locating first space */
    if j = 0 then j = length(MsgLine)  /* default to end of line */
    Link = substr(MsgLine, i, j-i+1)
    MsgLine = insert('</a>', MsgLine, j)  /* insert the ending html code */
    MsgLine = insert('<a href="'Link'">', MsgLine, i-1)  /* beginning html */
    TmpLine = translate(MsgLine, lo, hi)
    j = j + length(Link) + 10
    end
  if loop > 10 then leave  /* sanity check */
  end /* while */

TmpLine = translate(MsgLine, lo, hi)
loop = 0
j = 1
i = 1
do while i <> 0
  loop = loop + 1
  i = pos('ftp://', TmpLine, j)
  if i <> 0 then do
    j = pos(' ', MsgLine, i)  /* find end of url string by locating first space */
    if j = 0 then j = length(MsgLine)  /* default to end of line */
    Link = substr(MsgLine, i, j-i+1)
    MsgLine = insert('</a>', MsgLine, j)  /* insert the ending html code */
    MsgLine = insert('<a href="'Link'">', MsgLine, i-1)  /* beginning html */
    TmpLine = translate(MsgLine, lo, hi)
    j = j + length(Link) + 10
    end
  if loop > 10 then leave  /* sanity check */
  end /* while */

TmpLine = translate(MsgLine, lo, hi)
loop = 0
j = 1
i = 1
do while i <> 0
  loop = loop + 1
  i = pos('news://', TmpLine, j)
  if i <> 0 then do
    j = pos(' ', MsgLine, i)  /* find end of url string by locating first space */
    if j = 0 then j = length(MsgLine)  /* default to end of line */
    Link = substr(MsgLine, i, j-i+1)
    MsgLine = insert('</a>', MsgLine, j)  /* insert the ending html code */
    MsgLine = insert('<a href="'Link'">', MsgLine, i-1)  /* beginning html */
    TmpLine = translate(MsgLine, lo, hi)
    j = j + length(Link) + 10
    end
  if loop > 10 then leave  /* sanity check */
  end /* while */

TmpLine = translate(MsgLine, lo, hi)
loop = 0
j = 1
i = 1
do while i <> 0
  loop = loop + 1
  i = pos('mailto:', TmpLine, j)
  if i <> 0 then do
    j = pos(' ', MsgLine, i)  /* find end of url string by locating first space */
    if j = 0 then j = length(MsgLine)  /* default to end of line */
    Link = substr(MsgLine, i, j-i+1)
    MsgLine = insert('</a>', MsgLine, j)  /* insert the ending html code */
    MsgLine = insert('<a href="'Link'">', MsgLine, i-1)  /* beginning html */
    TmpLine = translate(MsgLine, lo, hi)
    j = j + length(Link) + 10
    end
  if loop > 10 then leave  /* sanity check */
  end /* while */

return MsgLine

/* ------------------------------------------------------------------ */
/*
 * Parse RFC822 headers
 *
 */

ParseHeaders: 

say 'ParseHeaders starting'

idx = 1

Line = linein(MsgFile)                /* get a line of the file */

do while Line <> ''                   /* until end of headers */
  FirstChar = left(Line, 1, '-')
  if FirstChar = ' ' then             /* continuation line */
    do
    Key = LastKey                     /* field name is same */
    Val = Line                        /* value is entire line */
    end
  else
    do
    parse var Line Key ':' Val          /* separate out the components */
    end

  Key = translate(Key, lo, hi)

  select
    when Key = 'to' then
      do
      HeadTo = HeadTo' 'Val
      LastKey = 'to'
      end
    when Key = 'reply-to' then
      do
      HeadReplyTo = HeadReplyTo' 'Val
      LastKey = 'reply-to'
      end
    when Key = 'from' then
      do
      HeadFrom = HeadFrom' 'Val
      LastKey = 'from'
      end
    when Key = 'subject' then
      do
      HeadSubject = HeadSubject' 'Val
      LastKey = 'subject'
      end
    when Key = 'date' then
      do
      HeadDate = HeadDate' 'Val
      LastKey = 'date'
      end
    when Key = 'cc' then
      do
      HeadCc = HeadCc' 'Val
      LastKey = 'cc'
      end
    when Key = 'sender' then
      do
      HeadSender = HeadSender' 'Val
      LastKey = 'sender'
      end
    when Key = 'content-type' then
      do
      HeadContentType = HeadContentType' 'Val
      LastKey = 'content-type'
      end
    when Key = 'mime-version' then
      do
      HeadMimeVersion = HeadMimeVersion' 'Val
      LastKey = 'mime-version'
      end
    when Key = 'return-receipt-to' then  /* no return receipts to the list please */
      do
      LastKey = 'return-receipt-to'
      end
    when Key = 'acknowledge-to' then
      do
      LastKey = 'acknowledge-to'
      end
    when Key = 'disposition-notification-to' then
      do
      LastKey = 'disposition-notification-to'
      end
    when Key = 'x-listname' then /* don't repeat the listname */
      do
      LastKey = 'x-listname'
      end
    when Key = 'status' then /* don't repeat the status */
      do
      LastKey = 'status'
      end
    when Key = 'priority' then /* don't repeat the priority */
      do
      LastKey = 'priority'
      end
    when Key = 'x-olddate' then /* don't repeat the x-olddate */
      do
      LastKey = 'x-olddate'
      end
    when Key = 'return-path' then /* don't repeat the return-path */
      do
      LastKey = 'return-path'
      end
    when Key = 'bcc' then /* don't save these if present */
      do
      LastKey = 'bcc'
      end
    otherwise do
      HeadOther.idx = Line
      idx = idx + 1
      LastKey = Key
      end
    end   /* select */
  Line = linein(MsgFile)
end       /* do while */

HeadOther.0 = idx - 1  /* save the number of extra header lines */

if Log = TRUE then
  do
  say 'Writing headers info to log file'
  call WriteLog('ParseHeaders Info:')
  call WriteLog('To:' HeadTo)
  call WriteLog('From:' HeadFrom)
  call WriteLog('Reply-to:' HeadReplyTo)
  call WriteLog('Subject:' HeadSubject)
  end

/* Make sure there is a subject specified */
HeadSubject = strip(HeadSubject, 'B', )
if HeadSubject = '' then do
  HeadSubject = '[Subject not specified]'
  end

return

/* ------------------------------------------------------------------ */
/*
 * Make the daily html page
 *
 */

NewDaily:

/* Open the new web page */
rc = stream(DayTemplate, 'c', 'open read')
WebPage2 = Webstem'\'Year'\'Month'\Day'Day'.html'
rc = stream(WebPage2, 'c', 'open write')

do while lines(DayTemplate) <> 0         /* until end of file */
  Line = linein(DayTemplate)             /* get a line of the file */
  i = pos(DateMarker, Line)
  if i = 0 then do
    rc = lineout(WebPage2, Line)
    end
  else do  /* found marker, insert current date */
    l = length(Line)
    before = left(Line, i - 1)
    k = length(DateMarker) + length(before)
    after = right(Line, l - k)

    rc = lineout(WebPage2, before Day FullMonth Year after,)
    end
end

rc = stream(WebPage2, 'c', 'close')
rc = stream(DayTemplate, 'c', 'close')

/* Now update the monthly page with the new day */
MonthPage = Webstem'\'Year'\'Month'\index.html'

/* Temporary file for the updated webpage */
Tmpfile2 = SysTempFileName(TmpDir'\l2w2????.tmp', '?')
rc = stream(Tmpfile2, 'c', 'open write')

/* Open the webpage locking out other updaters */
rc = Lock(MonthPage)
rc = stream(MonthPage, 'c', 'open read')

WebPage2 = 'Day'Day'.html'

do while lines(MonthPage) <> 0         /* until end of file */
  Line = linein(MonthPage)             /* get a line of the file */
  if Line <> Marker then do
    rc = lineout(Tmpfile2, Line)
    end
  else do  /* found marker, insert new record */
    rc = lineout(Tmpfile2, '<li><a href="'WebPage2'">'Day FullMonth Year'</a>')
    rc = lineout(Tmpfile2, Marker)
    end
end

rc = stream(MonthPage, 'c', 'close')
rc = stream(Tmpfile2, 'c', 'close')
copy Tmpfile2 MonthPage
rc = UnLock(MonthPage)
rc = SysFileDelete(Tmpfile2)


return


/* ------------------------------------------------------------------ */
/*
 * Make the msg archive directory for a new month.
 *
 */

NewMonth:

NewMonthDir = Webstem'\'Year'\'Month
Mkdir NewMonthDir  /* create the directory for this month */

NewMsgDir = NewMonthDir'\Msgs'
Mkdir NewMsgDir    /* create the messages directory */

/* Now create the monthly web page */
Webpage3 = Webstem'\'Year'\'Month'\index.html'

/* Open the new web page */
rc = stream(MonthTemplate, 'c', 'open read')
rc = stream(WebPage3, 'c', 'open write')

do while lines(MonthTemplate) <> 0         /* until end of file */
  Line = linein(MonthTemplate)             /* get a line of the file */
  i = pos(DateMarker, Line)
  if i = 0 then do
    rc = lineout(WebPage3, Line)
    end
  else do  /* found marker, insert current date */
    l = length(Line)
    before = left(Line, i - 1)
    k = length(DateMarker) + length(before)
    after = right(Line, l - k)

    rc = lineout(WebPage3, before FullMonth Year after,)
    end
end

rc = stream(WebPage3, 'c', 'close')
rc = stream(MonthTemplate, 'c', 'close')

/* Now update the yearly page with the new month */
YearPage = Webstem'\'Year'\index.html'

rc = stream(YearPage, 'c', 'query exists')
if rc = '' then do  /* file doesn't exist, create it */
  if Log = TRUE then call WriteLog('Year page does not exist:' YearPage)
  end

/* Temporary file for the updated webpage */
Tmpfile3 = SysTempFileName(TmpDir'\l2w3????.tmp', '?')
rc = stream(Tmpfile3, 'c', 'open write')

/* Open the webpage locking out other updaters */
rc = Lock(YearPage)
rc = stream(YearPage, 'c', 'open read')

WebPage3 = Month'/index.html'

do while lines(YearPage) <> 0         /* until end of file */
  Line = linein(YearPage)             /* get a line of the file */
  if Line <> Marker then do
    rc = lineout(Tmpfile3, Line)
    end
  else do  /* found marker, insert new record */
    rc = lineout(Tmpfile3, '<li><a href="'WebPage3'">'FullMonth Year'</a>')
    rc = lineout(Tmpfile3, Marker)
    end
end

rc = stream(YearPage, 'c', 'close')
rc = stream(Tmpfile3, 'c', 'close')
copy Tmpfile3 YearPage
rc = UnLock(YearPage)
rc = SysFileDelete(Tmpfile3)


return


/* ------------------------------------------------------------------ */
/*
 * Make the new year html page
 *
 */

NewYear:

/* Now create the yearly web page */

/* create the directory first */
WebPage4 = Webstem'\'Year
Mkdir WebPage4

/* Now the webpage itself */
WebPage4 = Webstem'\'Year'\index.html'

/* Open the new web page */
rc = stream(YearTemplate, 'c', 'open read')
rc = stream(WebPage4, 'c', 'open write')

do while lines(YearTemplate) <> 0         /* until end of file */
  Line = linein(YearTemplate)             /* get a line of the file */
  i = pos(DateMarker, Line)
  if i = 0 then do
    rc = lineout(WebPage4, Line)
    end
  else do  /* found marker, insert current date */
    l = length(Line)
    before = left(Line, i - 1)
    k = length(DateMarker) + length(before)
    after = right(Line, l - k)

    rc = lineout(WebPage4, before Year after,)
    end
end

rc = stream(WebPage4, 'c', 'close')
rc = stream(YearTemplate, 'c', 'close')

return

/* ------------------------------------------------------------------ */
/*
 * Read the master configuration file
 *
 */

ReadMasterCf:

/* Find out where the configuration file should be */
L2wCf = value('l2w_cf',,Env)

/* If its not defined then assume wherever we are */
if L2wCf = '' then do
  L2wCf = '.'
  end

if L2wLocation <> '' then do
  L2wCf = L2wLocation
  end

/* read the configuration file for this list.
 * It's name is something like "user@domain.com.cf"
 * where "user@domain.com" is your local username
 * fully qualified so that you can handle multiple
 * domains.
 */
FileName = L2wCf'\'UserName'.cf'

rc = stream(FileName, 'c', 'query exists')
if rc = '' then
  return FALSE

rc = LockOpen(FileName 'READ')  /* open the file locking it */
if rc = FALSE then
  return FALSE                   /* return FALSE if cannot open */

/* now read the configuration file */
do while lines(FileName) <> 0         /* until end of file */
  Line = linein(FileName)             /* get a line of the file */
  parse var Line Line '#' Comment     /* separate out any comments */
  if Line <> '' then do               /* if not null */
    parse var Line Key '=' Val        /* find the key and value */
    if Key <> '' then do
      Val = strip(Val, 'B', ' ')      /* remove any blanks */
      Key = strip(Key, 'B', ' ')
      Key = translate(Key, lo, hi)
      select
        when Key = 'usemsgdate' then do
          if Val = 'TRUE' then UseMsgDate = TRUE
          else UseMsgDate = FALSE
          end
        when Key = 'marker' then
          Marker = Val
        when Key = 'datemarker' then
          DateMarker = Val
        when Key = 'titlemarker' then
          TitleMarker = Val
        when Key = 'bodymarker' then
          BodyMarker = Val
        when Key = 'prevmarker' then
          PrevMarker = Val
        when Key = 'nextmarker' then
          NextMarker = Val
        when Key = 'webstem' then
          Webstem = Val
        when Key = 'logdir' then
          LogDir = Val
        when Key = 'daytemplate' then
          daytemplate = Val
        when Key = 'monthtemplate' then
          monthtemplate = Val
        when Key = 'yeartemplate' then
          YearTemplate = Val
        when Key = 'msgtemplate' then
          MsgTemplate = Val
        otherwise nop
        end   /* select */
      end     /* if Key <> '' */
    end       /* if Line <> '' */

  Key = ''

end /* end do while */

rc = LockClose(FileName)

return TRUE

/* ------------------------------------------------------------------ */

ErrHandler:

SIGerrCode = RC
L2wErrLog = 'l2w.err'

if Debug = TRUE then say 'Identified error while executing line #'Sigl'   RC = ['SIGerrCode']'
if Debug = TRUE then say '['SourceLine(Sigl)']'
rc = lineout( L2wErrLog, '     -----', )
rc = lineout( L2wErrLog, 'Error ['SIGerrCode'] while executing line #'Sigl, )
rc = lineout( L2wErrLog, '['SourceLine(Sigl)']')

return


/* ------------------------------------------------------------------ */

StartLog: procedure expose LogDir LogFile FALSE TRUE

FileName = LogDir'\?????.log'

LogFile = SysTempFileName(FileName, '?')

if LogFile = '' then
  do
  say 'Cannot create temporary file.'
  say 'Setting logfile to NUL'
  LogFile = 'NUL'
  Log = FALSE
  return
  end

rc = stream(LogFile, 'C', 'OPEN WRITE')

TmpTime = time('N')
TmpDate = date('N')

rc = lineout(LogFile, 'Date:' TmpDate, )
rc = lineout(LogFile, 'Time:' TmpTime, )

return

/* ------------------------------------------------------------------ */

StopLog: procedure expose LogFile LogDir FALSE TRUE


call WriteLog('')
call WriteLog('=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=')
call WriteLog('')

rc = stream(LogFile, 'C', 'CLOSE')

PermLog = LogDir'\l2w.log'

call AppeLock(LogFile PermLog)

rc = SysFileDelete(LogFile)

return

/* ------------------------------------------------------------------ */

WriteLog: procedure expose LogFile

parse arg String

rc = lineout(LogFile, String, )

return
  

/* -------------------------------------------------------- */
/* -------------------------------------------------------- */
/* -------------------------------------------------------- */