;;; prefix/suffix for mud commands
;; usage:
;; /pfxrand			- randomize *fixes
;; /pfxon [-w<world>]		- enable *fixes	on <world>
;; /pfxoff [-w<world>]		- disable *fixes on <world>
;; /pcmd [-w<world>] <cmd>	- execute *fixed <cmd> on <world>

;; Programmer's note: the /send commands here deliberately do not have a
;; leading "-", because we want the -w<world> option to be interpreted.

/~loaded pcmd.tf

/def -i pfxrand = \
    /set outputprefix=<pre:$[rand()]>%;\
    /set outputsuffix=<suf:$[rand()]>

/pfxrand

/def -i pfxon = \
    /send %* - OUTPUTPREFIX %{outputprefix}%;\
    /send %* - OUTPUTSUFFIX %{outputsuffix}

/def -i pfxoff = \
    /send %* - OUTPUTPREFIX%;\
    /send %* - OUTPUTSUFFIX

/def -i pcmd = \
    /let opts=%; \
    /while ( {1} =/ "-[^- ]*" ) \
        /let opts=%opts %1%; \
        /shift%; \
    /done%; \
    /pfxon %{opts}%; \
    /send %{opts} %*%; \
    /pfxoff %{opts}%; \
    /pfxrand

