/*
 * This file is (C) Chris Wohlgemuth 1999-2002
 * 
 * It's part of the Audio/Data-CD-Creator distribution
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define INCL_DOSERRORS
#define INCL_DOSQUEUES
#include "audiofolder.hh"
#include "audiofolderhelp.h"
#include <stdio.h>
#include <stdlib.h>
#include <wpshadow.hh>
#include <string.h>



extern PVOID pvAudioSharedMem;
extern HMODULE hAudioResource;

extern GLOBALDATA globalData;

extern char chrCDRecord[CCHMAXPATH];/* Path to cdrecord */
extern char chrMpg123Path[CCHMAXPATH];
extern BOOL bMpg123SwabBytes;
extern ATOM atomUpdateStatusbar;
extern char chrInstallDir[];

extern char chrCDRecord[CCHMAXPATH];/* Path to cdrecord */
extern char chrAudioCDROptions[CCHMAXPATH];
extern LONG lCDROptions;
extern char chrInstallDir[CCHMAXPATH];
extern int iBus;
extern int iTarget;
extern int iLun;
extern int iSpeed;
extern int iFifo;
extern char chrCdrdaoPath[CCHMAXPATH];
extern char chrCdrdaoDriver[100];
extern char chrCdrdaoOptions[CCHMAXPATH];
extern char chrMpg123Path[];
extern int iMp3Decoder; /* Which decoder to use */
extern char chrGrabberPath[];
extern char chrGrabberOptions[];
extern int bTrackNumbers;
extern char chosenCD[];

extern HMTX hmtxFileName;

//int iExt=0;

typedef struct
{
  USHORT cb;
  CWAudioFolder* thisPtr;
}WCNTRLDATA;

ULONG messageBox( char* text, ULONG ulTextID , LONG lSizeText,
                  char* title, ULONG ulTitleID, LONG lSizeTitle,
                  HMODULE hResource, HWND hwnd, ULONG ulFlags);
void getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
ULONG launchWrapper(PSZ parameter, PSZ folderPath,HWND hwnd,PSZ wrapperExe, PSZ pszTitle);
PSZ buildAudioWriteParam(CWAudioFolder* thisPtr, PSZ trackname, int iSpeedLocal);
void changeBackslash(char* text);
ULONG cwRequestMutex(HMTX  hmtxBMP, ULONG ulTimeOut);
ULONG cwReleaseMutex(HMTX  hmtxBMP);
SOMClass* queryMMAudioClass(void);
SOMClass* queryCWAudioClass(void);
void writeLog(char* logFile, char* logText);

/* Local */
HMODULE queryModuleHandle(void);

void CWAudioFolder::cwWriteAudioTracks(HWND hwnd, char* trackName, char* folderName)
{
  return;
}

/******************************************************/
/* This function checks if the object is a wave file. */
/* It only checks the extension because cdrecord      */
/* doesn't know types and needs the extension to      */
/* distinguish between wavefiles and raw data files.  */
/******************************************************/
BOOL CWAudioFolder::cwIsWaveFile(WPObject* wpObject)
{
  char objectName[CCHMAXPATH];
  ULONG ulNameSize;
  char* chrExtension;

  if(!somIsObj(wpObject))
    return FALSE;

  if(!somResolveByName(wpObject,"wpQueryRealName"))
    /* It's not a file system object */
    return FALSE;

  /* Check if it's folder */
  if(somResolveByName(wpObject,"wpQueryContent"))
    /* It's a folder */
    return FALSE;

  /* Check the extension */
  ulNameSize=sizeof(objectName);
  ((WPFileSystem*)wpObject)->wpQueryRealName(objectName,&ulNameSize,FALSE);
  chrExtension=strrchr(objectName,'.');
  if(!chrExtension)
    return FALSE; /* No extension */

  chrExtension=strstr(strlwr(chrExtension),".wav");
  if(chrExtension)
    if(*(chrExtension+4)==0)return TRUE;//It's a wavefile
  
  return FALSE;
}

/******************************************************/
/* This function checks if the object is a mp3 file.  */
/* It only checks the extension.                      */
/******************************************************/
BOOL CWAudioFolder::cwIsMp3File(WPObject* wpObject)
{
  char objectName[CCHMAXPATH];
  ULONG ulNameSize;
  char* chrExtension;

  if(!somIsObj(wpObject))
    return FALSE;

  if(!somResolveByName(wpObject,"wpQueryRealName"))
    /* It's not a file system object */
    return FALSE;

  /* Check if it's folder */
  if(somResolveByName(wpObject,"wpQueryContent"))
    /* It's a folder */
    return FALSE;

  /* Check the extension */
  ulNameSize=sizeof(objectName);
  ((WPFileSystem*)wpObject)->wpQueryRealName(objectName,&ulNameSize,FALSE); /* Get real name */
  chrExtension=strrchr(objectName,'.');
  if(!chrExtension)
    return FALSE; /* No extension */

  chrExtension=strstr(strlwr(chrExtension),".mp3");
  if(chrExtension)
    if(*(chrExtension+4)==0)return TRUE;//It's a mp3file
  
  return FALSE;
}


/******************************************************/
/* This function checks if the object is an audio     */
/* file. (Instance of MMAudio or CWAudio)                        */
/******************************************************/
BOOL CWAudioFolder::cwIsAudioFile(WPObject* wpObject)
{
  SOMClass *clsAudio;
  SOMClass *clsCWAudio;

  if(!somIsObj(wpObject))
    return FALSE;

  if(!somResolveByName(wpObject,"wpQueryRealName"))
    /* It's not a file system object */
    return FALSE;

  /* Check if it's folder */
  if(somResolveByName(wpObject,"wpQueryContent"))
    /* It's a folder */
    return FALSE;

  /* Check the class */
  clsAudio=queryMMAudioClass();
  clsCWAudio=queryCWAudioClass();
  if(!somIsObj(clsAudio) && !somIsObj(clsCWAudio))
    return FALSE;

  if(wpObject->somIsA(clsAudio))
    return TRUE;
  if(wpObject->somIsA(clsCWAudio))
    return TRUE;

  return FALSE;
}

void CWAudioFolder::cwSetStatusTime(ULONG ulTrackSize)
{
  char text[200];
  ULONG ulSize;
    
  ulSize=ulTrackSize;
  ulSize/=(2*2*44100);/* Calculate seconds */
  sprintf(text,"Total time: %d min %02d sec",ulSize/60 , (ulSize % 60));
  WinSetWindowText(WinWindowFromID(hwndStatusFrameCtl,IDST_STATUSTOTALTIME),text);    
}

ULONG CWAudioFolder::cwQueryWriteFlags()
{
  return ulWriteFlags;
}

ULONG CWAudioFolder::cwSetWriteFlags(ULONG ulNewWriteFlags,ULONG ulMask)
{
  ULONG rc;

  rc=cwQueryWriteFlags();
  ulWriteFlags=((ulNewWriteFlags&ulMask) | (~ulMask & ulWriteFlags));

  return rc;/* return previous flags */
}

void CWAudioFolder::cwEnableGrab(BOOL bEnable)
{
  bGrabEnabled=bEnable;
}

BOOL CWAudioFolder::cwQueryGrabEnabled(void)
{   
  return bGrabEnabled;    
}

void CWAudioFolder::cwEnableWrite(BOOL bEnable)
{
  bWriteEnabled=bEnable;
}

BOOL CWAudioFolder::cwQueryWriteEnabled(void)
{   
  return bWriteEnabled;    
}

void CWAudioFolder::cwEnableGrabControls(BOOL bEnable)
{
  if(!hwndGrab)
    return;
  WinEnableWindow(WinWindowFromID(hwndGrab,IDPB_SELECTALL) ,bEnable);
  WinEnableWindow(WinWindowFromID(hwndGrab,IDLB_GRABTRACKS) ,bEnable);
  WinEnableWindow(WinWindowFromID(hwndGrab,IDPB_GRAB) ,bEnable);
  WinEnableWindow(WinWindowFromID(hwndGrab,IDPB_REFRESH) ,bEnable);
    
}

void CWAudioFolder::cwEnableSelectControls(BOOL bEnable)
{
  if(!hwndSelect)
    return;
  WinEnableWindow(WinWindowFromID(hwndSelect,IDRB_WRITE) ,bEnable);
  WinEnableWindow(WinWindowFromID(hwndSelect,IDRB_GRAB) ,bEnable);
}

void CWAudioFolder::cwForceStatusUpdate(void)
{
  //  wpRefresh(OPEN_CONTENTS|OPEN_DETAILS, NULL);
  if(atomUpdateStatusbar)
     WinPostMsg(hwndStatusFrameCtl,atomUpdateStatusbar,0,MPFROMP(this));     
}

void CWAudioFolder::cwEnableWriteControls(BOOL bEnable)
{
  if(!hwndWrite)
    return;

  WinEnableWindow(WinWindowFromID(hwndWrite,IDCB_NOFIX) ,bEnable);
  WinEnableWindow(WinWindowFromID(hwndWrite,IDCB_PREEMP) ,bEnable);
  WinEnableWindow(WinWindowFromID(hwndWrite,IDCB_DUMMY) ,bEnable);
  WinEnableWindow(WinWindowFromID(hwndWrite,IDCB_DAO) ,bEnable);
  WinEnableWindow(WinWindowFromID(hwndWrite,IDPB_BURN) ,bEnable);
}

void CWAudioFolder::cwSetStatusText(char * text)
{ 
  WinSetWindowText(WinWindowFromID(hwndStatusFrameCtl,IDST_STATUSTOTALTIME),text);    
}

/*********************************************************************/
/*                                                                   */
/* This procedure fills the given listbox with all the tracks of the */
/* given folder. If no listbox is given only the size of all waves   */
/* is returned. Mp3 are currently ignored while calculating!         */
/*                                                                   */
/* Parameters:                                                       */
/*              hwndFrame:   frame handle of wpFolder window         */
/*              hwndListBox: handle of listbox where to insert the   */
/*                           wavefile names                          */
/*                                                                   */
/* Returns: Size of all wave tracks in byte                          */
/*                                                                   */
/*********************************************************************/
ULONG CWAudioFolder::cwFillTrackList(HWND hwndFrame, HWND hwndListBox)
{
  HWND hwndCnr;
  PMINIRECORDCORE mrc;   
  WPObject * contentObject;
  char name[CCHMAXPATH];
  ULONG ulNameSize;
  ULONG ulSize;
  BOOL bIsMp3;

  ulSize=0;
  /* Get hwnd of folder container */ 
  hwndCnr=WinWindowFromID(hwndFrame,FID_CLIENT);
  if(hwndCnr){ /* Catch error */
    /* Get first container item of our folder */
    mrc=(PMINIRECORDCORE)WinSendMsg(hwndCnr,CM_QUERYRECORD,NULL,
                                    MPFROM2SHORT(CMA_FIRST,CMA_ITEMORDER));
    if(mrc){ 
      while(mrc) {
        /* Get wps-object-ptr. from container item */
        contentObject=(WPObject*)OBJECT_FROM_PREC(mrc);//Get object
        if(somIsObj(contentObject))
          /* Get file system object or NULL */
          contentObject=cwGetFileSystemObject(contentObject);
        if(somIsObj(contentObject)){
          /* It's a file system object */
          /* Check, if it's a wave file or a mp3file */
          bIsMp3=cwIsMp3File(contentObject);
          //  if(cwIsWaveFile(contentObject)|| (bIsMp3 && strlen(chrMpg123Path) && !(ulWriteFlags & IDWF_DAO))){
          if(cwIsWaveFile(contentObject)|| (bIsMp3 && strlen(chrMpg123Path))  || 
             (cwIsAudioFile(contentObject) && iMp3Decoder==IDKEY_USEMMIOMP3) ){
            /* Yes, query the full path */
            ulNameSize=sizeof(name);
            ((WPFileSystem*)contentObject)->wpQueryRealName(name,&ulNameSize,TRUE);
            /* Add tracksize of wavefile to totalsize */ 
            if(!bIsMp3)          
              ulSize+=((WPFileSystem*)contentObject)->wpQueryFileSize()-44;
            else {
              /* Add playtime of mp3file to totalsize */ 
            }
            /* Add 2 seconds for pause between tracks */
            //ulSize+=8*44100;
            /* insert the name into the listbox */ 
            if(hwndListBox)
              WinInsertLboxItem(hwndListBox,LIT_END,
                                name);
          }           
        }/* end of if(contentObject) */           
        /* Get next container item */
        mrc=(PMINIRECORDCORE)WinSendMsg(hwndCnr,CM_QUERYRECORD,MPFROMP(mrc),
                                        MPFROM2SHORT(CMA_NEXT,CMA_ITEMORDER));
      }// end of while(mrc)
    }// end of if(mrc)
  }
  return ulSize;  
}

/* This thread waits 120 sec and removes the contents file */
void _Optlink _contentsFileDeleteThread (void *arg)
{
  char * memPtr;

  memPtr=(char*)arg;

  /* Wait 120 sec */
  DosSleep(120000);
  remove(memPtr);
  free(arg);
}

void addSettingsToContentsFile(CWAudioFolder * thisPtr,   FILE *fHandle)
{
  ULONG  ulWriteFlagsLocal;

  /* Put config data into file */
  ulWriteFlagsLocal=thisPtr->cwQueryWriteFlags();
  fprintf(fHandle,"[CONFIG]\n");
  fprintf(fHandle,"[INSTALLDIR]%s\n", chrInstallDir);
  fprintf(fHandle,"[INIFILE]%s\\cdrecord.ini\n", chrInstallDir);
  fprintf(fHandle,"[FIFO]%d\n",iFifo);
  fprintf(fHandle,"[SPEED]%d\n",iSpeed);
  fprintf(fHandle,"[DEVICE]%d,%d,%d\n",iBus, iTarget, iLun);
  if(!(lCDROptions & IDCDR_BURNPROOF))
    fprintf(fHandle,"[BURNSAVE]YES\n");
  else
    fprintf(fHandle,"[BURNSAVE]NO\n");
  /* Cdrdao settings */
  fprintf(fHandle,"[CDRDAOPATH]%s\n", chrCdrdaoPath);
  fprintf(fHandle,"[CDRDAODRIVER]%s\n", chrCdrdaoDriver);
  fprintf(fHandle,"[CDRDAOOPTIONS]%s\n", chrCdrdaoOptions);
  fprintf(fHandle,"[CDRDAOPATH2]%s\n", globalData.chrCdrdaoPath2);
  fprintf(fHandle,"[CDRDAODRIVER2]%s\n", globalData.chrCdrdaoDriver2);
  fprintf(fHandle,"[CDRDAOOPTIONS2]%s\n", globalData.chrCdrdaoOptions2);
  fprintf(fHandle,"[CDRDAODEVICE2]%s\n", globalData.chrDeviceName2);
  fprintf(fHandle,"[CDRDAOPATH3]%s\n", globalData.chrCdrdaoPath3);
  fprintf(fHandle,"[CDRDAODRIVER3]%s\n", globalData.chrCdrdaoDriver3);
  fprintf(fHandle,"[CDRDAOOPTIONS3]%s\n", globalData.chrCdrdaoOptions3);
  fprintf(fHandle,"[CDRDAODEVICE3]%s\n", globalData.chrDeviceName3);

  /* Cdrecord */
  fprintf(fHandle,"[CDRECORDPATH]%s\n", chrCDRecord);
  fprintf(fHandle,"[CDRECORDOPTIONS]%s\n", chrAudioCDROptions);
  /* MP3 settings */
  fprintf(fHandle,"[MP3DECODERPATH]%s\n", chrMpg123Path);
  fprintf(fHandle,"[MP3DECODER]%d\n", iMp3Decoder);
  if(bMpg123SwabBytes)
    fprintf(fHandle,"[MP3SWAPBYTES]YES\n");
  else
    fprintf(fHandle,"[MP3SWAPBYTES]NO\n");

  /* Grabber settings */
  fprintf(fHandle,"[GRABBERPATH]%s\n", chrGrabberPath);
  fprintf(fHandle,"[GRABBEROPTIONS]%s\n", chrGrabberOptions);
  if(bTrackNumbers)
    fprintf(fHandle,"[GRABBERADDNUMBERS]YES\n");
  else
    fprintf(fHandle,"[GRABBERADDNUMBERS]NO\n");
  fprintf(fHandle,"[GRABBERCDDRIVE]%s\n", chosenCD );
  /* Folder options */
  if(ulWriteFlagsLocal & IDWF_DUMMY)
    fprintf(fHandle,"[TESTONLY]YES\n");
  else
    fprintf(fHandle,"[TESTONLY]NO\n");
  if(!(lCDROptions & IDCDR_NOEJECT))
    fprintf(fHandle,"[EJECT]YES\n");
  else
    fprintf(fHandle,"[EJECT]NO\n");
  if(ulWriteFlagsLocal & IDWF_PREEMP)
    fprintf(fHandle,"[PREEMPHASIS]YES\n");
  else
    fprintf(fHandle,"[PREEMPHASIS]NO\n");
  if(ulWriteFlagsLocal & IDWF_NOFIX)
    fprintf(fHandle,"[NOFIX]YES\n");
  else
    fprintf(fHandle,"[NOFIX]NO\n");

}

BOOL  CWAudioFolder::cwCreateContentsFile(char * fileName, HWND hwndFrame)
{
  FILE *fHandle;
  char name[CCHMAXPATH];
  ULONG ulNameSize;
  HWND hwndCnr;
  PMINIRECORDCORE mrc;   
  WPObject * contentObject;
  WPObject * tempObject;
  BOOL bIsShadow;
  void * memPtr;
  ULONG  ulWriteFlagsLocal;
  /* Extension counter */
  static int iExt=0;
  int iExtPriv;

  /* Build full path */
  if(cwRequestMutex(hmtxFileName, 100000)==ERROR_TIMEOUT)
    return FALSE;  
  iExt++;
  if(iExt==1000)
    iExt=1;
  /* The extension of our filelist file */
  iExtPriv=iExt;
  cwReleaseMutex(hmtxFileName);
  
  sprintf(fileName,"%s\\temp\\%s%03d",chrInstallDir,"contents.",iExtPriv);      
  remove(fileName);
  fHandle=fopen(fileName,"a");
  if(fHandle) {
    ulNameSize=sizeof(name);
    /* Query the full path */
    this->wpQueryRealName(name,&ulNameSize,TRUE);
    /* Insert the folder name */
    fprintf(fHandle,name);
    fprintf(fHandle,"\n[CONTENTS]\n");
    /* Get hwnd of folder container */ 
    hwndCnr=WinWindowFromID(hwndFrame,FID_CLIENT);
    if(hwndCnr){ /* Catch error */
      /* Get first container item of our folder */
      mrc=(PMINIRECORDCORE)WinSendMsg(hwndCnr,CM_QUERYRECORD,NULL,
                                      MPFROM2SHORT(CMA_FIRST,CMA_ITEMORDER));

      if(mrc){ 
        while(mrc) {
          bIsShadow=FALSE;
          /* Get wps-object-ptr. from container item */
          contentObject=(WPObject*)OBJECT_FROM_PREC(mrc);//Get object
          if(somIsObj(contentObject)) {
            tempObject=contentObject;
            /* Get file system object or NULL */
            contentObject=cwGetFileSystemObject(contentObject);
            if(tempObject!=contentObject)
              bIsShadow=TRUE;
          }
          if(somIsObj(contentObject)){
            /* It's a file system object */
            /* Check, if it's a wave file or a mp3file or an audio file if MMIOMP3 is selected */
            //  if(cwIsWaveFile(contentObject)|| cwIsMp3File(contentObject)){
            if(cwIsWaveFile(contentObject) /*|| cwIsMp3File(contentObject)*/ ||
               (cwIsAudioFile(contentObject) && iMp3Decoder==IDKEY_USEMMIOMP3) ) {
              /* Yes, query the full path */
              ulNameSize=sizeof(name);
              ((WPFileSystem*)contentObject)->wpQueryRealName(name,&ulNameSize,TRUE);
              if(bIsShadow)
                fprintf(fHandle,"[SHADOW;");
              else
                fprintf(fHandle,"[FILE;");
              if(mrc->flRecordAttr&CRA_SELECTED)
                fprintf(fHandle,"SELECTED]");
              else
                fprintf(fHandle,"UNSELECTED]");
              fprintf(fHandle,name);
              fprintf(fHandle,"\n");
            }
          }/* end of if(contentObject) */           
          /* Get next container item */
          mrc=(PMINIRECORDCORE)WinSendMsg(hwndCnr,CM_QUERYRECORD,MPFROMP(mrc),
                                          MPFROM2SHORT(CMA_NEXT,CMA_ITEMORDER));
        }// end of while(mrc)
      }// end of if(mrc)      
    }

    addSettingsToContentsFile(this,   fHandle);

    fclose(fHandle);
    if((memPtr=malloc(sizeof(name)))!=NULL) {
      strncpy((char*)memPtr, fileName, sizeof(name));
      /* This thread deletes the contents file after a few minutes to clean the temp dir */
      _beginthread(_contentsFileDeleteThread,NULL,8192*2, memPtr); //Fehlerbehandlung fehlt    
    }
    return TRUE;    
  }
  return FALSE;
}

/* Create a contents file for mp3-decoding */
BOOL  CWAudioFolder::cwCreateContentsFileForDec(char * fileName, HWND hwndFrame)
{
  FILE *fHandle;
  char name[CCHMAXPATH];
  ULONG ulNameSize;
  HWND hwndCnr;
  PMINIRECORDCORE mrc;   
  WPObject * contentObject;
  WPObject * tempObject;
  BOOL bIsShadow;
  void * memPtr;
  ULONG  ulWriteFlagsLocal;
  /* Extension counter */
  static int iExt=0;
  int iExtPriv;

  /* Build full path */
  if(cwRequestMutex(hmtxFileName, 100000)==ERROR_TIMEOUT)
    return FALSE;  
  iExt++;
  if(iExt==1000)
    iExt=1;
  /* The extension of our filelist file */
  iExtPriv=iExt;
  cwReleaseMutex(hmtxFileName);
  
  sprintf(fileName,"%s\\temp\\%s%03d",chrInstallDir,"contents.",iExtPriv);      
  remove(fileName);
  fHandle=fopen(fileName,"a");
  if(fHandle) {
    ulNameSize=sizeof(name);
    /* Query the full path */
    this->wpQueryRealName(name,&ulNameSize,TRUE);
    /* Insert the folder name */
    fprintf(fHandle,name);
    fprintf(fHandle,"\n[CONTENTS]\n");
    /* Get hwnd of folder container */ 
    hwndCnr=WinWindowFromID(hwndFrame,FID_CLIENT);
    if(hwndCnr){ /* Catch error */
      /* Get first container item of our folder */
      mrc=(PMINIRECORDCORE)WinSendMsg(hwndCnr,CM_QUERYRECORD,NULL,
                                      MPFROM2SHORT(CMA_FIRST,CMA_ITEMORDER));

      if(mrc){ 
        while(mrc) {
          bIsShadow=FALSE;
          /* Get wps-object-ptr. from container item */
          contentObject=(WPObject*)OBJECT_FROM_PREC(mrc);//Get object
          if(somIsObj(contentObject)) {
            tempObject=contentObject;
            /* Get file system object or NULL */
            contentObject=cwGetFileSystemObject(contentObject);
            if(tempObject!=contentObject)
              bIsShadow=TRUE;
          }
          if(somIsObj(contentObject)){
            /* It's a file system object */
            /* Check, if it's a wave file or a mp3file or an audio file if MMIOMP3 is selected */
            //  if(cwIsWaveFile(contentObject)|| cwIsMp3File(contentObject)){
            if(iMp3Decoder==IDKEY_USEMMIOMP3) {
              if( cwIsMp3File(contentObject) ||
                  cwIsAudioFile(contentObject)
                                ) {
                /* Yes, query the full path */
                ulNameSize=sizeof(name);
                ((WPFileSystem*)contentObject)->wpQueryRealName(name,&ulNameSize,TRUE);
                if(bIsShadow)
                  fprintf(fHandle,"[SHADOW;");
                else
                  fprintf(fHandle,"[FILE;");
                if(mrc->flRecordAttr&CRA_SELECTED)
                  fprintf(fHandle,"SELECTED]");
                else
                  fprintf(fHandle,"UNSELECTED]");
                fprintf(fHandle,name);
                fprintf(fHandle,"\n");
              }
            }/* iMp3Decoder==IDKEY_USEMMIOMP3 */
              else if(cwIsMp3File(contentObject) ) {
                /* Yes, query the full path */
                ulNameSize=sizeof(name);
                ((WPFileSystem*)contentObject)->wpQueryRealName(name,&ulNameSize,TRUE);
                if(bIsShadow)
                  fprintf(fHandle,"[SHADOW;");
                else
                  fprintf(fHandle,"[FILE;");
                if(mrc->flRecordAttr&CRA_SELECTED)
                  fprintf(fHandle,"SELECTED]");
                else
                  fprintf(fHandle,"UNSELECTED]");
                fprintf(fHandle,name);
                fprintf(fHandle,"\n");
              }
          }/* end of if(contentObject) */           
          /* Get next container item */
          mrc=(PMINIRECORDCORE)WinSendMsg(hwndCnr,CM_QUERYRECORD,MPFROMP(mrc),
                                          MPFROM2SHORT(CMA_NEXT,CMA_ITEMORDER));
        }// end of while(mrc)
      }// end of if(mrc)      
    }

    addSettingsToContentsFile(this,   fHandle);

    fclose(fHandle);
    if((memPtr=malloc(sizeof(name)))!=NULL) {
      strncpy((char*)memPtr, fileName, sizeof(name));
      /* This thread deletes the contents file after a few minutes to clean the temp dir */
      _beginthread(_contentsFileDeleteThread,NULL,8192*2, memPtr); //Fehlerbehandlung fehlt    
    }
    return TRUE;    
  }
  return FALSE;
}


/*********************************************************************/
/*             hwndListBox: handle of listbox holding the tracknames */
/*********************************************************************/
BOOL buildTocFile( CWAudioFolder *thisPtr, HWND hwndListBox)
{
  char name[CCHMAXPATH];
  ULONG ulNameSize;
  ULONG ulSize;
  int b;
  LONG a;
  FILE *fStream;
  ULONG ulFlags;
  BOOL bFirstTrack;

  /* Query the full path of our folder*/
  ulNameSize=sizeof(name);
  thisPtr->wpQueryRealName(name,&ulNameSize,TRUE);
  strcat(name,"\\default.toc");
  fStream=fopen(name,"w");
  if(!fStream)
    return FALSE;

  bFirstTrack=TRUE;
  ulFlags=thisPtr->cwQueryWriteFlags();
  /* Build toc file */
  fprintf(fStream,"CD_DA\n\n");
  a=SHORT1FROMMR(WinSendMsg(hwndListBox,LM_QUERYITEMCOUNT, NULL, NULL));
  for(b=0;b<a;b++) {
    if(SHORT1FROMMR(WinSendMsg(hwndListBox,LM_QUERYITEMTEXT,MPFROM2SHORT((SHORT)b,(SHORT)CCHMAXPATH),&name))) {
      changeBackslash(name);        
      fprintf(fStream,"//Track %d\n",b+1);
      fprintf(fStream,"TRACK AUDIO\n");
      if(ulFlags & IDWF_PREEMP)
        fprintf(fStream,"PRE_EMPHASIS\n");
      /* Pregap */
      /*      if(bFirstTrack) {
              fprintf(fStream,"PREGAP 0:2:0\n");
              bFirstTrack=FALSE;
              }*/
      fprintf(fStream,"FILE \"%s\" 0\n\n", name);
    }
  }
  fclose(fStream);
  return TRUE;
}

























