/*
 * This file is (C) Chris Wohlgemuth 1999
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define INCL_WIN

#include <os2.h>
#include <stdio.h>
#include <string.h>

#define DEBUG

void errorResource2(char * chrTitle);

void errorResource()
{

  errorResource2("Problem with Audio/Data-CD-Creator installation");

}

void errorResource2(char * chrTitle)
{

  WinMessageBox(HWND_DESKTOP,0,
                "The resource DLL which contains all the dialogs, graphics and messages cannot be loaded. \
Please check your installation. There must be a file CDFLDxxx.DLL in the installation directory of the \
CD-Creator package. xxx is the country code of your system e.g. 049 for Germany. If there is no \
support for your language there must be at least the file CDFLD001.DLL. The CD creation features \
are not available!",
                chrTitle,12345,
                MB_OK|MB_MOVEABLE|MB_ERROR);

}

ULONG messageBox( char* text, ULONG ulTextID , LONG lSizeText,
                  char* title, ULONG ulTitleID, LONG lSizeTitle,
                  HMODULE hResource, HWND hwnd, ULONG ulFlags)
{

  if(!WinLoadString(WinQueryAnchorBlock(hwnd),hResource,ulTextID,lSizeText,text)) {
    errorResource();
    return MBID_ERROR;
  }
  if(!WinLoadString(WinQueryAnchorBlock(hwnd),hResource,ulTitleID,lSizeTitle,title)) {
    errorResource();
    return MBID_ERROR;
  }
  return WinMessageBox(  HWND_DESKTOP, hwnd, text, title, 0UL, ulFlags );
}

/* Show a messagebox with the text ulIDText and title ulIDTitle loaded from
   the resource DLL */
ULONG showMsgBox2(ULONG ulIDTitle, ULONG ulIDText, HMODULE hModule, ULONG ulFlag)
{
  char text[256];
  char title[100];
  
  return messageBox(  text, ulIDText , sizeof(text),
               title, ulIDTitle, sizeof(title),
               hModule, HWND_DESKTOP, ulFlag);
};

void getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd)
{
  if(!WinLoadString(WinQueryAnchorBlock(hwnd),hResource,ulID,lSizeText,text)) {
    sprintf(text,"");
  }
}

#ifdef DEBUG
void writeDebugLog(char * text)
{
  FILE *file;

  file=fopen("creator.log","a");
  if(file) {
    fwrite(text,sizeof(char),strlen(text),file);
    fclose(file);
  }
}
#endif


