/*
 * This file is (C) Chris Wohlgemuth 1999-2003
 * It is part of the Audio/Date-CD-Creator package
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#define INCL_GPIBITMAPS

#include "audiofolder.hh"
#include "audiofolderhelp.h"
#include <stdio.h>
#include <stdlib.h>
#include "cddb.h"

PVOID pvScanbusSharedMem;

extern GLOBALDATA globalData;

extern BOOL GrabberSetupDone;
extern char chrConfigDir[CCHMAXPATH];
extern int iMp3Decoder;

extern int iNumCD;
extern char cFirstCD;
extern char chosenCD[3];

extern char chrInstallDir[CCHMAXPATH];
extern char chrCDRecord[CCHMAXPATH];/* Path to cdrecord */
extern char chrDataCDROptions[CCHMAXPATH];
extern char chrAudioCDROptions[CCHMAXPATH];
extern LONG lCDROptions;
extern char chosenWriter[3];

extern char chrCdrdaoPath[CCHMAXPATH];
extern char chrCdrdaoDriver[100];
extern char chrDeviceName[CCHMAXPATH];
extern char chrWriterName[CCHMAXPATH];
extern char chrCdrdaoOptions[CCHMAXPATH];

extern char chrMkisofs[CCHMAXPATH];/* Path to mkisofs */
extern char chrMkisofsOptions[CCHMAXPATH];
extern LONG lMKOptions;
extern BOOL MkisofsSetupDone;
extern int iCodePage;
extern BOOL bDisableCp;

extern char chrMP3EncoderPath[CCHMAXPATH];
extern char chrMP3EncoderOptions[CCHMAXPATH];
extern ULONG ulMP3Bitrate;
extern ULONG ulMP3Quality;

extern int iBus;
extern int iTarget;
extern int iLun;
extern int iSpeed;
extern int iFifo;

extern char chrCDDBServer[100];
extern char chrCDDBUser[100];
extern char chrCDDBUserHost[100];
extern BOOL bUseCDDB;
extern char cddbServer[MAXSERVERS][100];
extern int NUMSERVERS;

extern BOOL setupDone;
extern HMODULE hSettingsResource;

extern char chrTBFlyFontName[CCHMAXPATH];/* Font for toolbar fly over help */
extern RGB rgbTBFlyForeground;
extern RGB rgbTBFlyBackground;
extern BOOL bTBFlyOverEnabled;
extern int iTBFlyOverDelay;

extern BOOL bHintEnabled;
extern BOOL bUseCustomPainting;

/* MP3 encoder page 2 strings */
extern char g_chrMP3Names[NUM_MP3NAMES][MP3NAME_LEN];
extern char g_cChosenMP3Name[NUM_MP3NAMEPARTS];
extern char g_chrMP3NameExample[NUM_MP3NAMES][MP3NAME_LEN];
extern char g_chrMP3NameFillStrings[NUM_MP3NAME_FILLSTRINGS][MP3NAME_FILLSTRING_LEN];

/* Extern */
extern void sendConfig();
extern ULONG cwQueryOSRelease();
extern ULONG messageBox( char* text, ULONG ulTextID , LONG lSizeText,
                  char* title, ULONG ulTitleID, LONG lSizeTitle,
                  HMODULE hResource, HWND hwnd, ULONG ulFlags);
extern void getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
extern ULONG launchWrapper(PSZ parameter, PSZ folderPath,HWND hwnd, PSZ wrapperExe, PSZ title="CDRecord/2");
extern BOOL checkFileExists(char* chrFileName);
extern BOOL cwMoveNotebookButtonsWarp4(HWND hwndDlg, USHORT usID, USHORT usDelta);
extern void startScanbusHelper(HWND hwnd);

/* Local */
MRESULT EXPENTRY settingsCdrecordOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) ;
MRESULT EXPENTRY settingsGeneralOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) ;
MRESULT EXPENTRY settingsToolbarOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) ;
MRESULT EXPENTRY settingsHintOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY settingsGrabberOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) ;
MRESULT EXPENTRY settingsCdrdaoOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2); 
MRESULT EXPENTRY settingsMpg123OptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) ;
MRESULT EXPENTRY settingsMP3EncoderOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

#if 0
static BOOL _queryExecutableFromProgramObject(WPObject* thisPtr, char * chrIDorPath, char *chrExecutablePath, int iSize)
{
  M_WPObject *m_wpObject;
  WPProgram *wpObject;
  ULONG        ulSize;
  HOBJECT hObject;
  BOOL rc=FALSE;

  if(!somIsObj(thisPtr))
    return FALSE;

  hObject=WinQueryObject(chrIDorPath);
  if(hObject) {
    m_wpObject=(M_WPObject*)thisPtr->somGetClass();
    if(somIsObj(m_wpObject)) {
      wpObject=(WPProgram*)m_wpObject->wpclsQueryObject(hObject);
      if(somIsObj(wpObject)) {
        PPROGDETAILS pProgDetails;
        // Get information about a program object //
        if ((wpObject->wpQueryProgDetails ( (PPROGDETAILS)NULL, &ulSize))){
          if ((pProgDetails = (PPROGDETAILS) wpObject->wpAllocMem(ulSize, NULL)) != NULL){
            /* We have memory */
            if ((wpObject->wpQueryProgDetails ( pProgDetails, &ulSize))){
              strncpy(chrExecutablePath, pProgDetails->pszExecutable, iSize-1);
              wpObject->wpFreeMem((PBYTE)pProgDetails);
              rc=TRUE;
            }/* wpQueryProgDetails() */
          }/* wpAllocMem() */
        }
        wpObject->wpUnlockObject();
      }/* if(somIsObj(wpObject)) */
    }
  }
  return rc;
}
#endif

#if 0
MRESULT EXPENTRY settingsIsoFSOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CWCreatorSettings* thisPtr;
  M_WPObject *m_wpObject;
  WPProgram *wpObject;
  ULONG        ulSize;

  switch(msg) {
  case WM_INITDLG :
    WinSetWindowULong(WinWindowFromID(hwnd,IDPB_ISOFSHELP),
                      QWL_USER,(ULONG)PVOIDFROMMP(mp2));//Save object ptr.

    WinSendMsg(WinWindowFromID(hwnd,IDEF_MNTISOFS),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)CCHMAXPATH),0);
    WinSendMsg(WinWindowFromID(hwnd,IDEF_UMNTISO),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)CCHMAXPATH),0);
    /* Try to find programs on our own */
    if(strlen(chrMntIsoFSPath)<3){/* Use 3 so it works even if the user put a space or something into the EF */
      thisPtr=(CWCreatorSettings*)PVOIDFROMMP(mp2);
      _queryExecutableFromProgramObject(thisPtr, ID_ISOFS_MOUNT, chrMntIsoFSPath, sizeof(chrMntIsoFSPath));
    }
    if(strlen(chrUmntIsoPath)<3){/* Use 3 so it works even if the user put a space or something into the EF */
      thisPtr=(CWCreatorSettings*)PVOIDFROMMP(mp2);
      _queryExecutableFromProgramObject(thisPtr, ID_ISOFS_UNMOUNT, chrUmntIsoPath, sizeof(chrUmntIsoPath));
    }
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_MNTISOFS),chrMntIsoFSPath);
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_UMNTISO),chrUmntIsoPath);
    
    /* Move default buttons on Warp 4 */
    winhAssertWarp4Notebook(hwnd,
                            IDPB_ISOFSHELP,    // in: ID threshold
                            20);       // in: dialog units or 0
    
    return (MRESULT) TRUE;
  case WM_DESTROY:
    {
      /* The notebook closes and gets destroyed */
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_MNTISOFS),sizeof(chrMntIsoFSPath),chrMntIsoFSPath);
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_UMNTISO),sizeof(chrUmntIsoPath),chrUmntIsoPath);
      /* Let the WPS save the new data */
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_ISOFSHELP),QWL_USER);
      if(somIsObj(thisPtr))
        thisPtr->wpSaveImmediate();
      break;
    }
  case WM_COMMAND:    
    switch(SHORT1FROMMP(mp1))
      {
      case IDPB_MNTISOFSBROWSE:
        {
          FILEDLG fd = { 0 };
          char text[100];

          /* User pressed the browse button */
          fd.cbSize = sizeof( fd );
          /* It's an centered 'Open'-dialog */
          fd.fl = FDS_OPEN_DIALOG|FDS_CENTER;
          /* Title: "Search mntisofs.exe" */
          getMessage(text,IDSTR_FDLGSEARCHMNTISOFSTITLE,sizeof(text), hSettingsResource,hwnd);
          /* Set the title of the file dialog */
          fd.pszTitle = text;
          /* Only show *.exe files */
          sprintf(fd.szFullFile,"%s","*.exe");

          if( WinFileDlg( HWND_DESKTOP, hwnd, &fd ) == NULLHANDLE )
            {
              /* WinFileDlg failed */
              break;
            }
          if( fd.lReturn == DID_OK )
            {
              WinSetWindowText( WinWindowFromID(hwnd,IDEF_MNTISOFS), fd.szFullFile );
            }
        }
        break;
      case IDPB_UMNTISOBROWSE:
        {
          FILEDLG fd = { 0 };
          char text[100];
          /* User pressed the browse button */
          fd.cbSize = sizeof( fd );
          /* It's an centered 'Open'-dialog */
          fd.fl = FDS_OPEN_DIALOG|FDS_CENTER;
          /* Title: "Search mntisofs.exe" */
          getMessage(text,IDSTR_FDLGSEARCHUMNTISOTITLE,sizeof(text), hSettingsResource,hwnd);
          /* Set the title of the file dialog */
          fd.pszTitle = text;
          /* Only show *.exe files */
          sprintf(fd.szFullFile,"%s","*.exe");

          if( WinFileDlg( HWND_DESKTOP, hwnd, &fd ) == NULLHANDLE )
            {
              /* WinFileDlg failed */
              break;
            }
          if( fd.lReturn == DID_OK )
            {
              WinSetWindowText( WinWindowFromID(hwnd,IDEF_UMNTISO), fd.szFullFile );
            }
        }
        break;
      default:
        break;
      }
    return (MRESULT) TRUE;
  default:
    break;
  }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}
#endif

/*************************************************************/
/* This dialog procedure handles the toolbar page            */
/*************************************************************/			
MRESULT EXPENTRY settingsToolbarOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) {
  HINI hini;
  HOBJECT  hObject;
  ULONG  attrFound;
  ULONG  len;
  char text[250];
  char title[250];
  CWCreatorSettings* thisPtr;
  
  switch(msg) {
  case WM_INITDLG :	
       
    WinSetWindowULong(hwnd,QWL_USER,LONGFROMMP(mp2));
    
    /* We have to initialize the dialog controls with the approbiate values */
    // Set the focus on the demo area
    WinSetFocus(HWND_DESKTOP, WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD));

    // Set the background colour of the demo area
    WinSetPresParam(WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD),
		    PP_BACKGROUNDCOLOR,(ULONG)sizeof(rgbTBFlyBackground), &rgbTBFlyBackground );
    // Set the foreground colour of the demo area
    WinSetPresParam(WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD),
		    PP_FOREGROUNDCOLOR,(ULONG)sizeof(rgbTBFlyForeground), &rgbTBFlyForeground );

    // Set the font of the demo area
    WinSetPresParam(WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD),
		    PP_FONTNAMESIZE,(ULONG)sizeof(chrTBFlyFontName),
		    chrTBFlyFontName );

    if(bTBFlyOverEnabled) {
      WinCheckButton(hwnd, IDCB_ENABLETBFLYOVER, 1);
      WinEnableWindow(WinWindowFromID(hwnd, IDSB_TBFLYOVERDELAY),TRUE);
    }
    else {
      WinCheckButton(hwnd, IDCB_ENABLETBFLYOVER, 0);
      WinEnableWindow(WinWindowFromID(hwnd, IDSB_TBFLYOVERDELAY),FALSE);
    }

    // Set the linits for the delay spin button
    WinSendMsg(WinWindowFromID(hwnd, IDSB_TBFLYOVERDELAY),
	       SPBM_SETLIMITS,(MPARAM)MAXDELAY,(MPARAM)0);
    // Set the current value for delay
    WinSendMsg(WinWindowFromID(hwnd, IDSB_TBFLYOVERDELAY),
	       SPBM_SETCURRENTVALUE,
	       (MPARAM)iTBFlyOverDelay,
	       (MPARAM)NULL);

    /* Move default buttons on Warp 4 */
    cwMoveNotebookButtonsWarp4(hwnd, IDPB_COLORHELP, 20);
    return (MRESULT) TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }

#if 0
  case WM_WINDOWPOSCHANGED:
    {
      /* This prevents switching the notebook page behind the open folder */
      if(!(WinQueryWindowUShort(WinQueryWindow(hwnd, QW_PARENT), QWS_FLAGS) & FF_ACTIVE) ) {
        PSWP pswp=(PSWP)PVOIDFROMMP(mp1);
        if(pswp->fl & SWP_ZORDER)
          mp2=MPFROMLONG(0x80000);
      }
      break;
    }
#endif
  case WM_DESTROY:
    /* The notebook closes and gets destroyed */
    /* Set focus to desktop to prevent PM freeze */
    WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

    // Query the current background colour
    len=WinQueryPresParam(WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD),
			  PP_BACKGROUNDCOLOR,0,&attrFound,sizeof(rgbTBFlyBackground),
			  &rgbTBFlyBackground,QPF_NOINHERIT);
    // Query the current font
    len=WinQueryPresParam(WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD),
                          PP_FONTNAMESIZE,0,&attrFound,sizeof(chrTBFlyFontName),
                          chrTBFlyFontName,QPF_NOINHERIT);
    // Query the current foreground colour
    len=WinQueryPresParam(WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD),
                          PP_FOREGROUNDCOLOR,0,&attrFound,sizeof(rgbTBFlyForeground),
                          &rgbTBFlyForeground,QPF_NOINHERIT);
    // Query the enable state
    if(WinQueryButtonCheckstate(hwnd,IDCB_ENABLETBFLYOVER) & 1)
      bTBFlyOverEnabled=1;
    else
      bTBFlyOverEnabled=0;

    // Query delay value
    WinSendMsg(WinWindowFromID(hwnd, IDSB_TBFLYOVERDELAY),
               SPBM_QUERYVALUE,(MPARAM)&iTBFlyOverDelay,
               MPFROM2SHORT(0,SPBQ_ALWAYSUPDATE));				
    
    // Save data
    thisPtr=(CWCreatorSettings*) WinQueryWindowULong(hwnd , QWL_USER);

    if(somIsObj(thisPtr))
      thisPtr->wpSaveImmediate();
    
    break;
  case WM_CONTROL:
    /* The window controls send WM_CONTROL messages */
    switch(SHORT1FROMMP(mp1))
      {
      case IDCB_ENABLETBFLYOVER:
        if(WinQueryButtonCheckstate(hwnd,IDCB_ENABLETBFLYOVER) & 1)
          WinEnableWindow(WinWindowFromID(hwnd, IDSB_TBFLYOVERDELAY),1);
        else
          WinEnableWindow(WinWindowFromID(hwnd, IDSB_TBFLYOVERDELAY),0);
        break;
      default:
        break;
      } // end switch(SHORT1FROMMP(mp1))
    break;
			
  case WM_COMMAND :
    switch (SHORT1FROMMP(mp1)) {
      // Process commands here //
      //    case IDPB_COLORHELP:
#if 0
    case WM_HELP:
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(hwnd , QWL_USER);
      
      if(somIsObj(thisPtr)) {
        DosBeep(5000,1000);
        thisPtr->wpDisplayHelp(2000,AFHELPLIBRARY);

      }
      break;
#endif
    case IDPB_COLORUNDO:
      /* The undo button was clicked */
      // Set the background colour of the demo area
      WinSetPresParam(WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD),
                      PP_BACKGROUNDCOLOR,(ULONG)sizeof(rgbTBFlyBackground), &rgbTBFlyBackground );
      // Set the foreground colour of the demo area
      WinSetPresParam(WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD),
                      PP_FOREGROUNDCOLOR,(ULONG)sizeof(rgbTBFlyForeground), &rgbTBFlyForeground );
      
      // Set the font of the demo area
      WinSetPresParam(WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD),
                      PP_FONTNAMESIZE,(ULONG)sizeof(chrTBFlyFontName),
                      chrTBFlyFontName );
      
      if(bTBFlyOverEnabled) {
        WinCheckButton(hwnd, IDCB_ENABLETBFLYOVER, 1);
        WinEnableWindow(WinWindowFromID(hwnd, IDSB_TBFLYOVERDELAY),TRUE);
      }
      else {
        WinCheckButton(hwnd, IDCB_ENABLETBFLYOVER, 0);
        WinEnableWindow(WinWindowFromID(hwnd, IDSB_TBFLYOVERDELAY),FALSE);
      }
      
      // Set the current value for delay
      WinSendMsg(WinWindowFromID(hwnd, IDSB_TBFLYOVERDELAY),
                 SPBM_SETCURRENTVALUE,
                 (MPARAM)iTBFlyOverDelay,
                 (MPARAM)NULL);
      break;
    case IDPB_COLORSTANDARD:
      /* The default button was clicked */
      rgbTBFlyBackground.bBlue=180;  // Set the default colours
      rgbTBFlyBackground.bGreen=255; 
      rgbTBFlyBackground.bRed=255;
      rgbTBFlyForeground.bBlue=0;
      rgbTBFlyForeground.bGreen=0;			
      rgbTBFlyForeground.bRed=0;
      // Set the default font
      if(cwQueryOSRelease()>=40)
        strcpy(chrTBFlyFontName,DEFAULT_DIALOG_FONT);
      else
        strcpy(chrTBFlyFontName,DEFAULT_DIALOG_FONT_WARP3);

      // Set the background colour of the demo area
      WinSetPresParam(WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD),
                      PP_BACKGROUNDCOLOR,(ULONG)sizeof(rgbTBFlyBackground), &rgbTBFlyBackground );
      // Set the foreground colour of the demo area
      WinSetPresParam(WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD),
                      PP_FOREGROUNDCOLOR,(ULONG)sizeof(rgbTBFlyForeground), &rgbTBFlyForeground );
      // Set the font of the demo area
      WinSetPresParam(WinWindowFromID(hwnd, IDST_TEXTDEMOFIELD),
                      PP_FONTNAMESIZE,(ULONG)sizeof(chrTBFlyFontName),
                      chrTBFlyFontName );

      WinCheckButton(hwnd, IDCB_ENABLETBFLYOVER, 1);
      WinEnableWindow(WinWindowFromID(hwnd, IDSB_TBFLYOVERDELAY),TRUE);
      
      // Set the value for delay
      WinSendMsg(WinWindowFromID(hwnd, IDSB_TBFLYOVERDELAY),
                 SPBM_SETCURRENTVALUE,
                 (MPARAM)DEFAULTDELAY,
                 (MPARAM)NULL);

      break;
    case IDPB_COLORPALETTE:
      /* Colour... button was clicked */
      // Open the colorpalette 
      if((hObject=WinQueryObject("<WP_HIRESCLRPAL>"))!=NULL) {
        WinOpenObject(hObject,OPEN_DEFAULT,TRUE);
      }
      else {//Error, can't open the palette
        /*  Show an error msg.						   */
        /*
          Text:   "Can't open the color palette. It may have lost it's ID. Check your INI files."
          Title: "CD-Creator settings"                       
          */             
        messageBox( text, IDSTRS_NOCOLORPALETTE , sizeof(text),
                    title, IDSTRS_CREATORSETTINGS , sizeof(title),
                    hSettingsResource, hwnd, MB_OK | MB_ICONEXCLAMATION | MB_MOVEABLE);    
      }
      break;
    case IDPB_FONTPALETTE:
      /* Font... button was clicked */
      // Open the fontpalette 
      if((hObject=WinQueryObject("<WP_FNTPAL>"))!=NULL) {
        WinOpenObject(hObject,OPEN_DEFAULT,TRUE);
      }
      else {//Error, can't open the palette
        /*  Show an error msg.						   */
        /*
          Text:   "Can't open the font palette. It may have lost it's ID. Check your INI files."
          Title: "CD-Creator settings"                       
          */             
        messageBox( text, IDSTRS_NOFONTPALETTE , sizeof(text),
                    title, IDSTRS_CREATORSETTINGS , sizeof(title),
                    hSettingsResource, hwnd, MB_OK | MB_ICONEXCLAMATION | MB_MOVEABLE);
      }
      break;
    }
    /* Don't call WinDefDlgProc here, or the dialog gets closed */
    return (MRESULT) TRUE;
  default:
    break;
  }
  // The WinDefDlgProc() handles the rest of the messages
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/*************************************************************/
/* This dialog procedure handles the hint options page       */
/*************************************************************/
MRESULT EXPENTRY settingsHintOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CWCreatorSettings* thisPtr;
  
  switch(msg) {
  case WM_INITDLG :	
    WinSetWindowULong(hwnd,QWL_USER,LONGFROMMP(mp2));
    
    /* We have to initialize the dialog controls with the approbiate values */
    if(bHintEnabled)
      WinCheckButton(hwnd, IDCB_ENABLEHINTS, 1);
    else
      WinCheckButton(hwnd, IDCB_ENABLEHINTS, 0);
    
    if(bUseCustomPainting)
      WinCheckButton(hwnd, IDCB_USEOS2LOOK, 0);
    else
      WinCheckButton(hwnd, IDCB_USEOS2LOOK, 1);

    if(globalData.bTipsEnabled)
      WinCheckButton(hwnd, IDCB_ENABLETIPS, 1);
    else
      WinCheckButton(hwnd, IDCB_ENABLETIPS, 0);

    /* Move default buttons on Warp 4 */
    cwMoveNotebookButtonsWarp4(hwnd, IDPB_HINTHELP, 20);
    return (MRESULT) TRUE;

      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
#if 0
  case WM_WINDOWPOSCHANGED:
    {
      /* This prevents switching the notebook page behind the open folder */
      if(!(WinQueryWindowUShort(WinQueryWindow(hwnd, QW_PARENT), QWS_FLAGS) & FF_ACTIVE) ) {
        PSWP pswp=(PSWP)PVOIDFROMMP(mp1);
        if(pswp->fl & SWP_ZORDER)
          mp2=MPFROMLONG(0x80000);
      }
      break;
    }
#endif
  case WM_DESTROY:
    /* The notebook closes and gets destroyed */
    /* Set focus to desktop to prevent PM freeze */
    WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

    // Query the enable state
    if(WinQueryButtonCheckstate(hwnd,IDCB_ENABLEHINTS) & 1)
      bHintEnabled=1;
    else
      bHintEnabled=0;

    if(WinQueryButtonCheckstate(hwnd, IDCB_USEOS2LOOK) & 1)
      bUseCustomPainting=FALSE;
    else
      bUseCustomPainting=TRUE;

    if(WinQueryButtonCheckstate(hwnd, IDCB_ENABLETIPS) & 1)
      globalData.bTipsEnabled=TRUE;
    else
      globalData.bTipsEnabled=FALSE;

    // Save data
    thisPtr=(CWCreatorSettings*) WinQueryWindowULong(hwnd , QWL_USER);
    if(somIsObj(thisPtr))
      thisPtr->wpSaveImmediate();
    break;
  case WM_CONTROL:
    /* The window controls send WM_CONTROL messages */
    switch(SHORT1FROMMP(mp1))
      {
        case IDCB_USEOS2LOOK:
          if(WinQueryButtonCheckstate(hwnd, IDCB_USEOS2LOOK) & 1)
            bUseCustomPainting=FALSE;
          else
            bUseCustomPainting=TRUE;
          WinInvalidateRect(HWND_DESKTOP, NULL, TRUE);
          return (MRESULT) FALSE;
      default:
        break;
      } // end switch(SHORT1FROMMP(mp1))
    break;			
  case WM_COMMAND :
    switch (SHORT1FROMMP(mp1)) {
      // Process commands here //
    case IDPB_HINTHELP:
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(hwnd , QWL_USER);
      
      if(somIsObj(thisPtr))
        thisPtr->wpDisplayHelp(2010,AFHELPLIBRARY); 
      break;
    case IDPB_HINTUNDO:
      /* The undo button was clicked */
      if(bHintEnabled)
        WinCheckButton(hwnd, IDCB_ENABLEHINTS, 1);
      else 
        WinCheckButton(hwnd, IDCB_ENABLEHINTS, 0);
      
      if(bUseCustomPainting)
        WinCheckButton(hwnd, IDCB_USEOS2LOOK, 0);
      else
        WinCheckButton(hwnd, IDCB_USEOS2LOOK, 1);

      if(globalData.bTipsEnabled)
        WinCheckButton(hwnd, IDCB_ENABLETIPS, 1);
      else
        WinCheckButton(hwnd, IDCB_ENABLETIPS, 0);

      break;
    case IDPB_HINTSTANDARD:
      /* The default button was clicked */
      WinCheckButton(hwnd, IDCB_ENABLEHINTS, 1);
      break;
    }
    /* Don't call WinDefDlgProc here, or the dialog gets closed */
    return (MRESULT) TRUE;
  default:
    break;
  }
  // The WinDefDlgProc() handles the rest of the messages
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/***********************************************************************/
/*                                                                     */
/* This procedure handles the cdrecord settings page for audio folders */
/* The only difference to the data folder is the option entryfield.    */
/* It is possible to specify different options for data and audio      */
/* since version 0.34                                                  */
/*                                                                     */
/***********************************************************************/
MRESULT EXPENTRY settingsCdrecordOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  FILEDLG fd = { 0 };
  CWCreatorSettings* thisPtr;
  ULONG ulFlags;
  int a;
  char chrCD[4];
  char driveID[40];
  char text[CCHMAXPATH];

  HOBJECT  hObject;

  switch(msg)
    {
    case WM_INITDLG :   
      WinSetWindowULong(WinWindowFromID(hwnd,IDPB_CDRECORDBROWSE),
                        QWL_USER,(ULONG)PVOIDFROMMP(mp2));//Save object ptr.

      WinSendMsg(WinWindowFromID(hwnd,IDEF_CDRECORDPATH),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)CCHMAXPATH),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRECORDPATH),chrCDRecord);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_CDRECORDOPTIONS),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(chrAudioCDROptions)),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRECORDOPTIONS),chrAudioCDROptions);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_CDRECORDDATAOPTIONS),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(chrDataCDROptions)),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRECORDDATAOPTIONS),chrDataCDROptions);
      for( a=0; a<iNumCD ;a++) {
        chrCD[0]=cFirstCD+a;
        chrCD[1]=':';
        chrCD[2]=0;
        WinSendMsg(WinWindowFromID(hwnd,IDLB_WRITERLETTER),LM_INSERTITEM,MPFROMSHORT(LIT_END),(MPARAM)chrCD);
        if(!a){
          if(!setupDone)
            WinSetWindowText(WinWindowFromID(hwnd,IDLB_WRITERLETTER),chrCD);
          else
            WinSetWindowText(WinWindowFromID(hwnd,IDLB_WRITERLETTER),chosenWriter);
        }
      }
      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_CDRECORDHELP, 20);
      return (MRESULT) TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }

#if 0
    case WM_WINDOWPOSCHANGED:
      {
        /* This prevents switching the notebook page behind the open folder */
        if(!(WinQueryWindowUShort(WinQueryWindow(hwnd, QW_PARENT), QWS_FLAGS) & FF_ACTIVE) ) {
          PSWP pswp=(PSWP)PVOIDFROMMP(mp1);
          if(pswp->fl & SWP_ZORDER)
            mp2=MPFROMLONG(0x80000);
        }
        break;
      }
#endif
    case WM_HELP:
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_CDRECORDBROWSE),QWL_USER);
      if(!somIsObj(thisPtr))
        break;
      switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
        {
        case IDEF_CDRECORDOPTIONS:
          return (MRESULT)thisPtr->wpDisplayHelp(IDEF_CDRECORDOPTIONS,AFHELPLIBRARY);
        case IDEF_CDRECORDDATAOPTIONS:
          return (MRESULT)thisPtr->wpDisplayHelp(IDEF_CDRECORDOPTIONS,AFHELPLIBRARY);
        case IDPB_WIDERRUFEN:
          return (MRESULT)thisPtr->wpDisplayHelp(IDPB_WIDERRUFEN,AFHELPLIBRARY);
        case IDPB_CDRECORDBROWSE:
          return (MRESULT)thisPtr->wpDisplayHelp(IDPB_CDRECORDBROWSE,AFHELPLIBRARY);
        case IDEF_CDRECORDPATH:
          return (MRESULT)thisPtr->wpDisplayHelp(IDEF_CDRECORDPATH,AFHELPLIBRARY);
        default:
          break;
        }
      return (MRESULT)thisPtr->wpDisplayHelp(IDDLG_CDRECORDSETUP,AFHELPLIBRARY);
      break;
    case WM_DESTROY:
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

      /* The notebook closes and gets destroyed */
      /* Query the cdrecord path from the entryfield */
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_CDRECORDPATH),sizeof(chrCDRecord),chrCDRecord);
      /* Query the cdrecord options from the entryfield for audio folders */     
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_CDRECORDOPTIONS),sizeof(chrAudioCDROptions),chrAudioCDROptions);
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_CDRECORDDATAOPTIONS),sizeof(chrDataCDROptions),chrDataCDROptions);
      sendConfig();

      /* Query the cd-drive */
      WinQueryWindowText( WinWindowFromID(hwnd,IDLB_WRITERLETTER),sizeof(chosenWriter),chosenWriter);

      /* Let the WPS save the new data */
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_CDRECORDBROWSE),QWL_USER);
      if(somIsObj(thisPtr))
        thisPtr->wpSaveImmediate();
      /* Setup is done */
      setupDone=TRUE;
      return (MRESULT) TRUE;
    case WM_COMMAND:    
      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_CDRECORDBROWSE:
          /* User pressed the browse button */
          fd.cbSize = sizeof( fd );
          /* It's an centered 'Open'-dialog */
          fd.fl = FDS_OPEN_DIALOG|FDS_CENTER;
          /* Title: "Search CDRecord/2" */
          getMessage(text,IDSTR_FDLGSEARCHCDR2TITLE,sizeof(text), hSettingsResource,hwnd);
          /* Set the title of the file dialog */
          fd.pszTitle = text;
          /* Only show *.exe files */
          sprintf(fd.szFullFile,"%s","*.exe");

          if( WinFileDlg( HWND_DESKTOP, hwnd, &fd ) == NULLHANDLE )
            {
              /* WinFileDlg failed */
              break;
            }
          if( fd.lReturn == DID_OK )
            {
              WinSetWindowText( WinWindowFromID(hwnd,IDEF_CDRECORDPATH), fd.szFullFile );
            }
          break;
        case IDPB_WIDERRUFEN:
          /* User pressed the UNDO button */
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRECORDPATH),chrCDRecord);
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRECORDOPTIONS),chrAudioCDROptions);
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRECORDDATAOPTIONS),chrDataCDROptions);
          break;
        default:
          break;
        }
      return (MRESULT) TRUE;
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

writeLog(char* logFile, char* logText);

/***************************************************************************/
/*                                                                         */
/* This procedure handles the general settings page of the settings object */
/*                                                                         */
/***************************************************************************/
MRESULT EXPENTRY settingsGeneralOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  CWCreatorSettings* thisPtr;
  ULONG ulFlags;
  char text[CCHMAXPATH];
  char title[CCHMAXPATH];
  char *lbEntry;
  static  BOOL bFirst;

  switch(msg)
    {
    case WM_INITDLG :   
      WinSetWindowULong(WinWindowFromID(hwnd,IDPB_SCAN),
                        QWL_USER,(ULONG)PVOIDFROMMP(mp2));//Save object ptr.
      WinSetWindowText(WinWindowFromID(hwnd,IDDD_DEVICESELECTION),chrDeviceName);
      /* Speed spin button */
      WinSendMsg(WinWindowFromID(hwnd,IDSB_SPEED),SPBM_SETLIMITS,MPFROMLONG(64),MPFROMLONG(1));
      WinSendMsg(WinWindowFromID(hwnd,IDSB_SPEED),SPBM_SETCURRENTVALUE,(MPARAM)iSpeed,MPFROMLONG(0));
      /* FIFO spin button */
      WinSendMsg(WinWindowFromID(hwnd,IDSB_FIFO),SPBM_SETLIMITS,MPFROMLONG(64),MPFROMLONG(0));
      WinSendMsg(WinWindowFromID(hwnd,IDSB_FIFO),SPBM_SETCURRENTVALUE,(MPARAM)iFifo,MPFROMLONG(0));

      if(lCDROptions&IDCDR_HIDEWINDOW)
        WinCheckButton(hwnd,IDCB_CDRSTARTHIDDEN,1);
      else
        WinCheckButton(hwnd,IDCB_CDRSTARTHIDDEN,0);
      if(lCDROptions&IDCDR_CLOSEWINDOW)
        WinCheckButton(hwnd,IDCB_CDRCLOSEWINDOW,1);
      else
        WinCheckButton(hwnd,IDCB_CDRCLOSEWINDOW,0);
      if(lCDROptions&IDCDR_CREATESHADOWS)
        WinCheckButton(hwnd,IDCB_CREATESHADOWS,1);
      else
        WinCheckButton(hwnd,IDCB_CREATESHADOWS,0);
      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_GENERALHELP, 20);
      return (MRESULT) TRUE;

      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }

#if 0
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;
        PSWP pswp;
        pswp=(PSWP)PVOIDFROMMP(mp1);
        if(pswp->fl & SWP_ACTIVATE) {
          //   pswp->hwndInsertBehind=HWND_TOP;
        }
        /* This prevents switching the notebook page behind the open folder */
        // if(!(WinQueryWindowUShort(WinQueryWindow(hwnd, QW_PARENT), QWS_FLAGS) & FF_ACTIVE))
        //if((WinQueryWindowUShort(hwnd, QWS_FLAGS) & FF_ACTIVE))
        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          DosBeep(5000, 100);
          //          WinSetFocus(HWND_DESKTOP, WinWindowFromID(hwnd, IDPB_SCAN));
          return mr;  
        }
        break;
      }

      //case WM_ADJUSTWINDOWPOS:
      //    case WM_ADJUSTFRAMEPOS:
      //    case WM_ACTIVATE:
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          char text[200];
          sprintf(text, "hwndFocus: %x, hwnd: %x, parent: %x, parent-2: %x, parent-3: %x, fchange: %x\n",
                  HWNDFROMMP(mp1), 
                  hwnd,
                  WinQueryWindow(hwnd, QW_PARENT),
                  WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT),
                  WinQueryWindow(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), QW_PARENT),
                  SHORT2FROMMP(mp2));
          writeLog( "focus.log", text);
          DosBeep(1000, 100);
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            DosBeep(100, 500);
            sprintf(text, "hwnd==hwndFocus: hwndFocus: %x, hwnd: %x, parent: %x, parent-2: %x, parent-3: %x fchange: %x\n",
                    HWNDFROMMP(mp1), 
                    hwnd,
                    WinQueryWindow(hwnd, QW_PARENT),
                    WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT),
                    WinQueryWindow(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), QW_PARENT),
                    SHORT2FROMMP(mp2));
            writeLog( "focus.log", text);
            //mp2=MPFROM2SHORT(SHORT1FROMMP(mp2),SHORT2FROMMP(mp2)|FC_NOSETFOCUS);
            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            //            WinSetFocus(HWND_DESKTOP, WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT));
            return mr;
            //
            //            mp1=MPFROMHWND(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT));
          }
          if(HWNDFROMMP(mp1)==WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT))
            DosBeep(500, 100);

        }
        //        return (MRESULT) 0x80000;
        break;
      }
#endif
#if 0
    case WM_ADJUSTFRAMEPOS:
      {
        PSWP pswp;
        pswp=(PSWP)PVOIDFROMMP(mp1);
        if(pswp->fl & SWP_ZORDER) {
          DosBeep(1000, 100);
          pswp->hwndInsertBehind=HWND_TOP;
        }
        if(pswp->fl & SWP_DEACTIVATE)
          DosBeep(5000, 100);
        break;
      }
    case WM_ADJUSTWINDOWPOS:
      {
        PSWP pswp;
        pswp=(PSWP)PVOIDFROMMP(mp1);
        pswp->hwndInsertBehind=HWND_TOP;
        pswp->fl=pswp->fl&~SWP_ZORDER;
       DosBeep(5000, 1000);
        break;
      }
    case WM_SHOW:
      {
        DosBeep(1000, 1000);
        break;
      }
#endif
#if 0        
    case WM_WINDOWPOSCHANGED:
      {
        DosBeep(500, 1000);
        /* This prevents switching the notebook page behind the open folder */
        if(!(WinQueryWindowUShort(WinQueryWindow(hwnd, QW_PARENT), QWS_FLAGS) & FF_ACTIVE))
          WinSetWindowULong(hwnd,QWL_HWNDFOCUSSAVE, WinWindowFromID(hwnd, IDPB_SCAN));
        WinSetWindowULong(HWND_DESKTOP,
                          QWL_HWNDFOCUSSAVE, WinQueryWindow(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), QW_PARENT));
        //   WinSetWindowUShort(hwnd,QWS_FLAGS, WinQueryWindowUShort(hwnd, QWS_FLAGS) | FF_SELECTED);
        // mp2=MPFROMLONG(0x80000);
        break;
      }
#endif
    case WM_HELP:
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_SCAN),QWL_USER);
      if(!somIsObj(thisPtr))
        break;
      /* Switch the right help panel for the control with the focus to the front */
      switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
        {
          /* Start hidden */
        case IDCB_CDRSTARTHIDDEN:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_CDRSTARTHIDDEN, AFHELPLIBRARY);
          /*  Close helper window */
        case IDCB_CDRCLOSEWINDOW:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_CDRCLOSEWINDOW, AFHELPLIBRARY);
          /* Create shadows as default */
        case IDCB_CREATESHADOWS:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_CREATESHADOWS, AFHELPLIBRARY);
        default:
          break;
        }
      /* General page help */
      return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_GENERALPAGE, AFHELPLIBRARY);
    case WM_APPTERMINATENOTIFY:
      switch(LONGFROMMP(mp1)) {
      case ACKEY_SCANBUS:
        /* Free shared mem if not already done */
        if(pvScanbusSharedMem) {
          DosFreeMem(pvScanbusSharedMem);
          pvScanbusSharedMem=NULL;
        }
        break;
      case ACKEY_LISTBOX:
        if(LONGFROMMP(mp2)==0) {
          /* Delete entries in listbox */
          WinSetWindowText(WinWindowFromID(hwnd,IDDD_DEVICESELECTION),"");
          WinSendMsg(WinWindowFromID(hwnd, IDDD_DEVICESELECTION),LM_DELETEALL,MPFROMLONG(0),MPFROMLONG(0));
          bFirst=TRUE;
        }
        else
          {
            WinSendMsg(WinWindowFromID(hwnd,IDDD_DEVICESELECTION),LM_INSERTITEM,MPFROMSHORT(LIT_END),
                       mp2);
            if(bFirst) {
              WinSetWindowText(WinWindowFromID(hwnd,IDDD_DEVICESELECTION),(PCSZ)PVOIDFROMMP(mp2));
              bFirst=FALSE;
            }
          }
        break;
      default:
        break;
      }/* switch */
      break; 
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

#if 0
      char text[200];
      sprintf(text, "hwndFocus: %x, hwnd: %x, parent: %x, parent-2: %x, parent-3: %x\n",
              WinQueryFocus(HWND_DESKTOP), 
              hwnd,
              WinQueryWindow(hwnd, QW_PARENT),
              WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT),
              WinQueryWindow(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), QW_PARENT));
      writeLog( "focus.log", text);
#endif

      WinQueryWindowText( WinWindowFromID(hwnd,IDDD_DEVICESELECTION),sizeof(chrDeviceName),chrDeviceName);
      sscanf(chrDeviceName,"%d,%d,%d ",&iBus,&iTarget,&iLun);
      WinSendMsg(WinWindowFromID(hwnd,IDSB_SPEED),SPBM_QUERYVALUE,MPFROMP(&ulFlags),
                 MPFROM2SHORT(0,SPBQ_ALWAYSUPDATE));
      iSpeed=(int)ulFlags;
      
      WinSendMsg(WinWindowFromID(hwnd,IDSB_FIFO),SPBM_QUERYVALUE,MPFROMP(&ulFlags),
                 MPFROM2SHORT(0,SPBQ_ALWAYSUPDATE));
      iFifo=(int)ulFlags;
      
      ulFlags=lCDROptions;
      if(WinQueryButtonCheckstate(hwnd,IDCB_CDRSTARTHIDDEN)&1)
        ulFlags|=IDCDR_HIDEWINDOW;
      else
        ulFlags&=~IDCDR_HIDEWINDOW;

      if(WinQueryButtonCheckstate(hwnd,IDCB_CDRCLOSEWINDOW)&1)
        ulFlags|=IDCDR_CLOSEWINDOW;
      else
        ulFlags&=~IDCDR_CLOSEWINDOW;

      if(WinQueryButtonCheckstate(hwnd,IDCB_CREATESHADOWS)&1)
        ulFlags|=IDCDR_CREATESHADOWS;
      else
        ulFlags&=~IDCDR_CREATESHADOWS;

      lCDROptions=ulFlags;
      /* Let the WPS save the new data */
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_SCAN),QWL_USER);
      if(somIsObj(thisPtr))
        thisPtr->wpSaveImmediate();      
      /* Free shared mem if not already done */
      if(pvScanbusSharedMem) {
        DosFreeMem(pvScanbusSharedMem);
        pvScanbusSharedMem=NULL;
      }
      /* Setup is done */
      return (MRESULT) TRUE;
    case WM_COMMAND:    
      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_GENERALUNDO:
          /* User pressed the UNDO button */
          WinSendMsg(WinWindowFromID(hwnd,IDSB_SPEED),SPBM_SETCURRENTVALUE,MPFROMLONG((LONG)iSpeed),
                     MPFROMLONG(0));
          WinSendMsg(WinWindowFromID(hwnd,IDSB_FIFO),SPBM_SETCURRENTVALUE,MPFROMLONG((LONG)iFifo),
                     MPFROMLONG(0));
          WinSetWindowText(WinWindowFromID(hwnd,IDDD_DEVICESELECTION),chrDeviceName);

          if(lCDROptions&IDCDR_HIDEWINDOW)
            WinCheckButton(hwnd,IDCB_CDRSTARTHIDDEN,1);
          else
            WinCheckButton(hwnd,IDCB_CDRSTARTHIDDEN,0);
          if(lCDROptions&IDCDR_CLOSEWINDOW)
            WinCheckButton(hwnd,IDCB_CDRCLOSEWINDOW,1);
          else
            WinCheckButton(hwnd,IDCB_CDRCLOSEWINDOW,0);
          if(lCDROptions&IDCDR_CREATESHADOWS)
            WinCheckButton(hwnd,IDCB_CREATESHADOWS,1);
          else
            WinCheckButton(hwnd,IDCB_CREATESHADOWS,0);

          break;
        case IDPB_SCAN:
          if(checkFileExists(chrCDRecord)) {
            /* Allocate shared mem for communication between helper and settings notebook */
            if(!pvScanbusSharedMem) {
              if(DosAllocSharedMem(&pvScanbusSharedMem,SCANBUSSHAREDMEM_NAME, SCANBUSSHAREDMEM_SIZE,
                                   PAG_READ|PAG_WRITE|PAG_COMMIT)) {
                /*
                  Text:   "Can't allocate shared memory. There's probably already a creation process running."
                  Title: "Audio-CD-Creator"                       
                  */             
                messageBox( text, IDSTR_ALLOCSHAREDMEMERROR , sizeof(text),
                            title, IDSTR_AUDIOCDCREATOR , sizeof(title),
                            hSettingsResource, hwnd, MB_OK | MB_ICONEXCLAMATION | MB_MOVEABLE);
                break;
              }
            }
            else
              {
                /* The shared mem is already allocated. There's another write process running. */
                /*
                  Text:   "Can't allocate shared memory. There's probably already a creation process running."
                  Title: "Audio-CD-Creator"                       
                  */             
                messageBox( text, IDSTR_ALLOCSHAREDMEMERROR , sizeof(text),
                            title, IDSTR_AUDIOCDCREATOR , sizeof(title),
                            hSettingsResource, hwnd, MB_OK | MB_ICONEXCLAMATION | MB_MOVEABLE);
                break;
              }
            if(launchWrapper(chrInstallDir,"",hwnd,"scanbus.exe","Scanning SCSI bus...")) {
              if(pvScanbusSharedMem) {
                DosFreeMem(pvScanbusSharedMem);
                pvScanbusSharedMem=NULL;
              }
            }
          }
          else {
            /* The path to CDRecord/2 isn't valid */
            /* title: "...%s..." */
            getMessage(title, IDSTR_NOVALIDPATH,sizeof(title), hSettingsResource, hwnd);            
            sprintf(text, title, "CDRecord/2");
            /* title: "Audio-CD-Creator" */
            getMessage(title, IDSTR_AUDIOCDCREATOR,sizeof(title), hSettingsResource, hwnd);                     
            WinMessageBox(  HWND_DESKTOP, hwnd,
                            text,
                            title,
                            0UL, MB_OK | MB_ERROR |MB_MOVEABLE);
          }
          break;
        default:
          break;
        }
      return (MRESULT) TRUE;
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/******************************************************/
/*                                                    */
/* This procedure handles the general settings page 2 */
/* of the settings object                             */
/*                                                    */
/******************************************************/
MRESULT EXPENTRY settingsGeneralOption2DlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  CWCreatorSettings* thisPtr;

  switch(msg)
    {
    case WM_INITDLG :   
      WinSetWindowULong(WinWindowFromID(hwnd,IDCB_EJECT),
                        QWL_USER,(ULONG)PVOIDFROMMP(mp2));//Save object ptr.

      /* Eject */
      if(lCDROptions & IDCDR_NOEJECT)
        WinCheckButton(hwnd,IDCB_EJECT, 0);
      else
        WinCheckButton(hwnd,IDCB_EJECT,1);
      /* Sony multisession fix */
      if(lCDROptions & IDCDR_SONYMULTISESSION)
        WinCheckButton(hwnd, IDCB_SONYMULTISESSION, 1);
      else
        WinCheckButton(hwnd, IDCB_SONYMULTISESSION, 0);
      /* BURN-Proof checkbox */
      if(lCDROptions & IDCDR_BURNPROOF)
        WinCheckButton(hwnd, IDCB_BURNPROOF, 1);
      else
        WinCheckButton(hwnd, IDCB_BURNPROOF, 0);
      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_GENERAL2HELP, 20);
      return (MRESULT) TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
#if 0
    case WM_WINDOWPOSCHANGED:
      {
        /* This prevents switching the notebook page behind the open folder */
        if(!(WinQueryWindowUShort(WinQueryWindow(hwnd, QW_PARENT), QWS_FLAGS) & FF_ACTIVE))
          mp2=MPFROMLONG(0x80000);
        break;
      }
#endif
    case WM_HELP:
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDCB_EJECT),QWL_USER);
      if(!somIsObj(thisPtr))
        break;
      /* Switch the right help panel for the control with the focus to the front */
      switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
        {
          /*  */
        case IDCB_EJECT:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_EJECT, AFHELPLIBRARY);
          /* */
        case IDCB_SONYMULTISESSION:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_SONYMULTISESSION, AFHELPLIBRARY);
          /* */
        case IDCB_BURNPROOF:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_BURNPROOF, AFHELPLIBRARY);
        default:
          break;
        }
      /* General page 2 help */
      return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_GENERAL2PAGE, AFHELPLIBRARY);
      break;
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDCB_EJECT),QWL_USER);
      if(somIsObj(thisPtr)) {
        /* Eject */
        if(WinQueryButtonCheckstate(hwnd,IDCB_EJECT) & 1)
          lCDROptions&=~IDCDR_NOEJECT;
        else
          lCDROptions|=IDCDR_NOEJECT;
        /* Sony multisession fix */
        if(WinQueryButtonCheckstate(hwnd, IDCB_SONYMULTISESSION) & 1)
          lCDROptions|=IDCDR_SONYMULTISESSION;
        else
          lCDROptions&=~IDCDR_SONYMULTISESSION;
        /* BURN-Proof */
        if(WinQueryButtonCheckstate(hwnd, IDCB_BURNPROOF) & 1)
          lCDROptions|=IDCDR_BURNPROOF;
        else
          lCDROptions&=~IDCDR_BURNPROOF;

        /* Let the WPS save the new data */
        thisPtr->wpSaveImmediate();
      }      
      /* Setup is done */
      return (MRESULT) TRUE;
    case WM_COMMAND:    
      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_GENERAL2UNDO:
          thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDCB_EJECT),QWL_USER);
          if(somIsObj(thisPtr)) {
            /* User pressed the UNDO button */
            /* Eject */
            if(lCDROptions & IDCDR_NOEJECT)
              WinCheckButton(hwnd,IDCB_EJECT, 0);
            else
              WinCheckButton(hwnd,IDCB_EJECT,1);
            /* Sony multisession fix */
            if(lCDROptions & IDCDR_SONYMULTISESSION)
              WinCheckButton(hwnd, IDCB_SONYMULTISESSION, 1);
            else
              WinCheckButton(hwnd, IDCB_SONYMULTISESSION, 0);
            /* BURN-Proof */
            if(lCDROptions & IDCDR_BURNPROOF)
              WinCheckButton(hwnd, IDCB_BURNPROOF, 1);
            else
              WinCheckButton(hwnd, IDCB_BURNPROOF, 0);
          }
          break;
        default:
          break;
        }
      return (MRESULT) TRUE;
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


/***********************************************************************/
/*                                                                     */
/* This procedure handles the cdrdao settings page for audio folders   */
/*                                                                     */
/***********************************************************************/
MRESULT EXPENTRY settingsCdrdaoOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  FILEDLG fd = { 0 };
  CWCreatorSettings* thisPtr;
  ULONG ulFlags;
  int a;
  char chrCD[4];
  char driveID[40];
  char text[CCHMAXPATH];

  char *ptr;
  HINI hini;
  ULONG ulSize;
  char *pBuffer;
 
  switch(msg)
    {
    case WM_INITDLG :   
      WinSetWindowULong(WinWindowFromID(hwnd,IDPB_CDRDAOBROWSE),
                        QWL_USER,(ULONG)PVOIDFROMMP(mp2));//Save object ptr.
      WinSendMsg(WinWindowFromID(hwnd,IDEF_CDRDAOPATH),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)CCHMAXPATH),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRDAOPATH),chrCdrdaoPath);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_CDRDAOOPTIONS),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)CCHMAXPATH),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRDAOOPTIONS),chrCdrdaoOptions);
      /* Set the writer name (not the driver) */
      WinSetWindowText(WinWindowFromID(hwnd,IDLB_CDRDAODRIVER), chrWriterName);
      /* Open database with drivers */
      sprintf(text,"%s\\cfgdata.ini", chrConfigDir);
      hini=PrfOpenProfile(WinQueryAnchorBlock(HWND_DESKTOP),text);
      if(hini)
        {
          if(PrfQueryProfileSize(hini, NULL,NULL,&ulSize)) { /* Get data size */
            pBuffer=(char*)malloc(ulSize);
            if(pBuffer) {
              if(PrfQueryProfileData(hini, NULL,NULL, pBuffer, &ulSize))
                {
                  BOOL bFirst;

                  ptr=pBuffer;
                  if(strlen(chrWriterName)==0)
                    bFirst=TRUE;/* If we have no writer name, use the first one */
                  else
                    bFirst=FALSE;
                  do {
                    /* Get first entry with a driver information (grabbers don't have this info) */
                    PrfQueryProfileString(hini,ptr,"driver","",text,sizeof(text));
                    if(strlen(text)!=0) {
                      /* Insert the writer name */
                      WinSendMsg(WinWindowFromID(hwnd,IDLB_CDRDAODRIVER),LM_INSERTITEM,MPFROMSHORT(LIT_SORTASCENDING),
                                 (MPARAM)ptr);
                      if(bFirst) {
                        bFirst=FALSE;
                        WinSetWindowText(WinWindowFromID(hwnd,IDLB_CDRDAODRIVER),ptr);
                      }
                    }
                    ptr=strchr(ptr,0);
                    if(!ptr)
                      break;
                    ptr++; /* Next database entry */
                  }while(*ptr!=0);
                }
              free(pBuffer);
            }
          }
          PrfCloseProfile(hini);
        }
      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_CDRDAOHELP, 20);
      return (MRESULT) TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
#if 0
    case WM_WINDOWPOSCHANGED:
      {
        /* This prevents switching the notebook page behind the open folder */
        if(!(WinQueryWindowUShort(WinQueryWindow(hwnd, QW_PARENT), QWS_FLAGS) & FF_ACTIVE))
          mp2=MPFROMLONG(0x80000);
        break;
      }
#endif
    case WM_HELP:
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_CDRECORDBROWSE),QWL_USER);
      if(!somIsObj(thisPtr))
        break;
      /* Switch the right help panel for the control with the focus to the front */
      switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
        {
          /*  */
        case IDEF_CDRDAOOPTIONS:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_CDRDAOOPTIONS, AFHELPLIBRARY);
          /* */
        default:
          break;
        }
      /* General page 2 help */
      return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_CDRDAOSETUP, AFHELPLIBRARY);
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

      /* Query the cdrdao path from the entryfield */     
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_CDRDAOPATH),sizeof(chrCdrdaoPath),chrCdrdaoPath);
      /* Query the options. */
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_CDRDAOOPTIONS),sizeof(chrCdrdaoOptions),chrCdrdaoOptions);
      /* Query the cdrdao writer (not driver) from the entryfield for audio folders */     
      WinQueryWindowText( WinWindowFromID(hwnd,IDLB_CDRDAODRIVER ),sizeof(chrWriterName),chrWriterName);
      sprintf(text,"%s\\cfgdata.ini", chrConfigDir);
      hini=PrfOpenProfile(WinQueryAnchorBlock(HWND_DESKTOP),text);
      if(hini)
        {
          /* Get the associated driver */
          PrfQueryProfileString(hini,chrWriterName,"driver","",chrCdrdaoDriver,sizeof(chrCdrdaoDriver));
          PrfCloseProfile(hini);
        }          
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_CDRECORDBROWSE),QWL_USER);
      if(somIsObj(thisPtr))
        thisPtr->wpSaveImmediate();      
      /* Setup is done */
      return (MRESULT) TRUE;
    case WM_COMMAND:    
      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_CDRDAOBROWSE:
          /* User pressed the browse button */
          fd.cbSize = sizeof( fd );
          /* It's an centered 'Open'-dialog */
          fd.fl = FDS_OPEN_DIALOG|FDS_CENTER;
          /* Title: "Search CDRecord/2" */
          getMessage(text,IDSTR_FDLGSEARCHCDRDAOTITLE,sizeof(text), hSettingsResource,hwnd);
          /* Set the title of the file dialog */
          fd.pszTitle = text;
          /* Only show *.exe files */
          sprintf(fd.szFullFile,"%s","*.exe");

          if( WinFileDlg( HWND_DESKTOP, hwnd, &fd ) == NULLHANDLE )
            {
              /* WinFileDlg failed */
              break;
            }
          if( fd.lReturn == DID_OK )
            {
              WinSetWindowText( WinWindowFromID(hwnd,IDEF_CDRDAOPATH), fd.szFullFile );
            }
          break;
        case IDPB_CDRDAOUNDO:
          /* User pressed the UNDO button */
          WinSetWindowText(WinWindowFromID(hwnd,IDLB_CDRDAODRIVER),chrWriterName);
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRDAOPATH),chrCdrdaoPath);
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRDAOOPTIONS),chrCdrdaoOptions);
          break;
        default:
          break;
        }
      return (MRESULT) TRUE;
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/***********************************************************************/
/*                                                                     */
/* This procedure handles the cdrdao settings page for 1:1 copy source */
/*                                                                     */
/***********************************************************************/
MRESULT EXPENTRY settingsCdrdaoOptionDlgProc2(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  FILEDLG fd = { 0 };
  CWCreatorSettings* thisPtr;
  ULONG ulFlags;
  int a;
  char chrCD[4];
  char driveID[40];
  char text[CCHMAXPATH];

  char *ptr;
  HINI hini;
  ULONG ulSize;
  char *pBuffer;
  static BOOL bFirst;
 

  switch(msg)
    {
    case WM_INITDLG :   
      WinSetWindowULong(WinWindowFromID(hwnd,IDPB_CDRDAOBROWSE),
                        QWL_USER,(ULONG)PVOIDFROMMP(mp2));//Save object ptr.
      WinSendMsg(WinWindowFromID(hwnd,IDEF_CDRDAOPATH),EM_SETTEXTLIMIT,
                 MPFROMSHORT((SHORT)sizeof(globalData.chrCdrdaoPath2)),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRDAOPATH),globalData.chrCdrdaoPath2);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_CDRDAOOPTIONS),EM_SETTEXTLIMIT,
                 MPFROMSHORT((SHORT)sizeof(globalData.chrCdrdaoOptions2)),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRDAOOPTIONS),globalData.chrCdrdaoOptions2);
      /* Set the writer name (not the driver) */
      WinSetWindowText(WinWindowFromID(hwnd,IDLB_CDRDAODRIVER), globalData.chrWriterName2);
      WinSetWindowText( WinWindowFromID(hwnd,IDDD_CDRDAODEVICE), globalData.chrDeviceName2);
      /* Open database with drivers */
      sprintf(text,"%s\\cfgdata.ini", chrConfigDir);
      hini=PrfOpenProfile(WinQueryAnchorBlock(HWND_DESKTOP),text);
      if(hini)
        {
          if(PrfQueryProfileSize(hini, NULL,NULL,&ulSize)) { /* Get data size */
            pBuffer=(char*)malloc(ulSize);
            if(pBuffer) {
              if(PrfQueryProfileData(hini, NULL,NULL, pBuffer, &ulSize))
                {
                  BOOL bFirst;

                  ptr=pBuffer;
                  if(strlen(globalData.chrWriterName2)==0)
                    bFirst=TRUE;/* If we have no writer name, use the first one */
                  else
                    bFirst=FALSE;
                  do {
                    /* Get first entry with a driver information (grabbers don't have this info) */
                    PrfQueryProfileString(hini,ptr,"driver","",text,sizeof(text));
                    if(strlen(text)!=0) {
                      /* Insert the writer name */
                      WinSendMsg(WinWindowFromID(hwnd,IDLB_CDRDAODRIVER),LM_INSERTITEM,
                                 MPFROMSHORT(LIT_SORTASCENDING),
                                 (MPARAM)ptr);
                      if(bFirst) {
                        bFirst=FALSE;
                        WinSetWindowText(WinWindowFromID(hwnd,IDLB_CDRDAODRIVER),ptr);
                      }
                    }
                    ptr=strchr(ptr,0);
                    if(!ptr)
                      break;
                    ptr++; /* Next database entry */
                  }while(*ptr!=0);
                }
              free(pBuffer);
            }
          }
          PrfCloseProfile(hini);
        }
      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_CDRDAOHELP, 20);
      return (MRESULT) TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_HELP:
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_CDRECORDBROWSE),
                                                       QWL_USER);
      if(!somIsObj(thisPtr))
        break;
      /* Switch the right help panel for the control with the focus to the front */
      switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
        {
          /*  */
        case IDEF_CDRDAOOPTIONS:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_CDRDAOOPTIONS, AFHELPLIBRARY);
          /* */
        default:
          break;
        }
      /* General page 2 help */
      return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_CDRDAOSETUP, AFHELPLIBRARY);
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

      /* Query the cdrdao path from the entryfield */     
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_CDRDAOPATH),sizeof(globalData.chrCdrdaoPath2),
                          globalData.chrCdrdaoPath2);
      /* Query the options. */
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_CDRDAOOPTIONS),
                          sizeof(globalData.chrCdrdaoOptions2), globalData.chrCdrdaoOptions2);
      /* Query the cdrdao writer (not driver) from the entryfield for audio folders */     
      WinQueryWindowText( WinWindowFromID(hwnd,IDLB_CDRDAODRIVER ),
                          sizeof(globalData.chrWriterName2), globalData.chrWriterName2);
      WinQueryWindowText( WinWindowFromID(hwnd,IDDD_CDRDAODEVICE ),
                          sizeof(globalData.chrDeviceName2), globalData.chrDeviceName2);

      sprintf(text,"%s\\cfgdata.ini", chrConfigDir);
      hini=PrfOpenProfile(WinQueryAnchorBlock(HWND_DESKTOP),text);
      if(hini)
        {
          /* Get the associated driver */
          PrfQueryProfileString(hini, globalData.chrWriterName2 ,"driver","",globalData.chrCdrdaoDriver2,
                                sizeof(globalData.chrCdrdaoDriver2));
          PrfCloseProfile(hini);
        }          
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_CDRECORDBROWSE),QWL_USER);
      if(somIsObj(thisPtr))
        thisPtr->wpSaveImmediate();      
      /* Setup is done */
      return (MRESULT) TRUE;
    case WM_COMMAND:    
      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_CDRDAOBROWSE:
          /* User pressed the browse button */
          fd.cbSize = sizeof( fd );
          /* It's an centered 'Open'-dialog */
          fd.fl = FDS_OPEN_DIALOG|FDS_CENTER;
          /* Title: "Search CDRecord/2" */
          getMessage(text,IDSTR_FDLGSEARCHCDRDAOTITLE,sizeof(text), hSettingsResource,hwnd);
          /* Set the title of the file dialog */
          fd.pszTitle = text;
          /* Only show *.exe files */
          sprintf(fd.szFullFile,"%s","*.exe");

          if( WinFileDlg( HWND_DESKTOP, hwnd, &fd ) == NULLHANDLE )
            {
              /* WinFileDlg failed */
              break;
            }
          if( fd.lReturn == DID_OK )
            {
              WinSetWindowText( WinWindowFromID(hwnd,IDEF_CDRDAOPATH), fd.szFullFile );
            }
          break;
        case IDPB_CDRDAOSCAN:
          startScanbusHelper(hwnd);
          break;
        case IDPB_CDRDAOUNDO:
          /* User pressed the UNDO button */
          WinSetWindowText(WinWindowFromID(hwnd,IDLB_CDRDAODRIVER),globalData.chrWriterName2);
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRDAOPATH),globalData.chrCdrdaoPath2);
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRDAOOPTIONS),globalData.chrCdrdaoOptions2);
          WinSetWindowText(WinWindowFromID(hwnd,IDDD_CDRDAODEVICE), globalData.chrDeviceName2);
          break;
        default:
          break;
        }
      return (MRESULT) TRUE;
    case WM_APPTERMINATENOTIFY:
      switch(LONGFROMMP(mp1)) {
      case ACKEY_SCANBUS:
        /* Free shared mem if not already done */
        if(pvScanbusSharedMem) {
          DosFreeMem(pvScanbusSharedMem);
          pvScanbusSharedMem=NULL;
        }
        break;
      case ACKEY_LISTBOX:
        if(LONGFROMMP(mp2)==0) {
          /* Delete entries in listbox */
          WinSetWindowText(WinWindowFromID(hwnd,IDDD_CDRDAODEVICE),"");
          WinSendMsg(WinWindowFromID(hwnd, IDDD_CDRDAODEVICE),LM_DELETEALL,MPFROMLONG(0),MPFROMLONG(0));
          bFirst=TRUE;
        }
        else
          {
            WinSendMsg(WinWindowFromID(hwnd,IDDD_CDRDAODEVICE),LM_INSERTITEM,MPFROMSHORT(LIT_END),
                       mp2);
            if(bFirst) {
              WinSetWindowText(WinWindowFromID(hwnd,IDDD_CDRDAODEVICE),(PCSZ)PVOIDFROMMP(mp2));
              bFirst=FALSE;
            }
          }
        break;
      default:
        break;
      }/* switch */
      break; 
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}
/***********************************************************************/
/*                                                                     */
/* This procedure handles the cdrdao settings page for 1:1 copy target */
/*                                                                     */
/***********************************************************************/
MRESULT EXPENTRY settingsCdrdaoOptionDlgProc3(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  FILEDLG fd = { 0 };
  CWCreatorSettings* thisPtr;
  ULONG ulFlags;
  int a;
  char chrCD[4];
  char driveID[40];
  char text[CCHMAXPATH];

  char *ptr;
  HINI hini;
  ULONG ulSize;
  char *pBuffer;
  static BOOL bFirst;
 

  switch(msg)
    {
    case WM_INITDLG :   
      WinSetWindowULong(WinWindowFromID(hwnd,IDPB_CDRDAOBROWSE),
                        QWL_USER,(ULONG)PVOIDFROMMP(mp2));//Save object ptr.
      WinSendMsg(WinWindowFromID(hwnd,IDEF_CDRDAOPATH),EM_SETTEXTLIMIT,
                 MPFROMSHORT((SHORT)sizeof(globalData.chrCdrdaoPath3)),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRDAOPATH),globalData.chrCdrdaoPath3);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_CDRDAOOPTIONS),EM_SETTEXTLIMIT,
                 MPFROMSHORT((SHORT)sizeof(globalData.chrCdrdaoOptions3)),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRDAOOPTIONS),globalData.chrCdrdaoOptions3);
      /* Set the writer name (not the driver) */
      WinSetWindowText(WinWindowFromID(hwnd,IDLB_CDRDAODRIVER), globalData.chrWriterName3);
      WinSetWindowText( WinWindowFromID(hwnd,IDDD_CDRDAODEVICE), globalData.chrDeviceName3);
      /* Open database with drivers */
      sprintf(text,"%s\\cfgdata.ini", chrConfigDir);
      hini=PrfOpenProfile(WinQueryAnchorBlock(HWND_DESKTOP),text);
      if(hini)
        {
          if(PrfQueryProfileSize(hini, NULL,NULL,&ulSize)) { /* Get data size */
            pBuffer=(char*)malloc(ulSize);
            if(pBuffer) {
              if(PrfQueryProfileData(hini, NULL,NULL, pBuffer, &ulSize))
                {
                  BOOL bFirst;

                  ptr=pBuffer;
                  if(strlen(globalData.chrWriterName3)==0)
                    bFirst=TRUE;/* If we have no writer name, use the first one */
                  else
                    bFirst=FALSE;
                  do {
                    /* Get first entry with a driver information (grabbers don't have this info) */
                    PrfQueryProfileString(hini,ptr,"driver","",text,sizeof(text));
                    if(strlen(text)!=0) {
                      /* Insert the writer name */
                      WinSendMsg(WinWindowFromID(hwnd,IDLB_CDRDAODRIVER),LM_INSERTITEM,
                                 MPFROMSHORT(LIT_SORTASCENDING),
                                 (MPARAM)ptr);
                      if(bFirst) {
                        bFirst=FALSE;
                        WinSetWindowText(WinWindowFromID(hwnd,IDLB_CDRDAODRIVER),ptr);
                      }
                    }
                    ptr=strchr(ptr,0);
                    if(!ptr)
                      break;
                    ptr++; /* Next database entry */
                  }while(*ptr!=0);
                }
              free(pBuffer);
            }
          }
          PrfCloseProfile(hini);
        }
      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_CDRDAOHELP, 20);
      return (MRESULT) TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_HELP:
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_CDRECORDBROWSE),
                                                       QWL_USER);
      if(!somIsObj(thisPtr))
        break;
      /* Switch the right help panel for the control with the focus to the front */
      switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
        {
          /*  */
        case IDEF_CDRDAOOPTIONS:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_CDRDAOOPTIONS, AFHELPLIBRARY);
          /* */
        default:
          break;
        }
      /* General page 2 help */
      return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_CDRDAOSETUP, AFHELPLIBRARY);
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

      /* Query the cdrdao path from the entryfield */     
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_CDRDAOPATH),sizeof(globalData.chrCdrdaoPath3),
                          globalData.chrCdrdaoPath3);
      /* Query the options. */
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_CDRDAOOPTIONS),
                          sizeof(globalData.chrCdrdaoOptions3), globalData.chrCdrdaoOptions3);
      /* Query the cdrdao writer (not driver) from the entryfield for audio folders */
      WinQueryWindowText( WinWindowFromID(hwnd,IDLB_CDRDAODRIVER ),
                          sizeof(globalData.chrWriterName3), globalData.chrWriterName3);
      WinQueryWindowText( WinWindowFromID(hwnd,IDDD_CDRDAODEVICE ),
                          sizeof(globalData.chrDeviceName3), globalData.chrDeviceName3);

      sprintf(text,"%s\\cfgdata.ini", chrConfigDir);
      hini=PrfOpenProfile(WinQueryAnchorBlock(HWND_DESKTOP),text);
      if(hini)
        {
          /* Get the associated driver */
          PrfQueryProfileString(hini, globalData.chrWriterName3 ,"driver","",globalData.chrCdrdaoDriver3,
                                sizeof(globalData.chrCdrdaoDriver3));
          PrfCloseProfile(hini);
        }          
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_CDRECORDBROWSE),QWL_USER);
      if(somIsObj(thisPtr))
        thisPtr->wpSaveImmediate();      
      /* Setup is done */
      return (MRESULT) TRUE;
    case WM_COMMAND:    
      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_CDRDAOBROWSE:
          /* User pressed the browse button */
          fd.cbSize = sizeof( fd );
          /* It's an centered 'Open'-dialog */
          fd.fl = FDS_OPEN_DIALOG|FDS_CENTER;
          /* Title: "Search CDRecord/2" */
          getMessage(text,IDSTR_FDLGSEARCHCDRDAOTITLE,sizeof(text), hSettingsResource,hwnd);
          /* Set the title of the file dialog */
          fd.pszTitle = text;
          /* Only show *.exe files */
          sprintf(fd.szFullFile,"%s","*.exe");

          if( WinFileDlg( HWND_DESKTOP, hwnd, &fd ) == NULLHANDLE )
            {
              /* WinFileDlg failed */
              break;
            }
          if( fd.lReturn == DID_OK )
            {
              WinSetWindowText( WinWindowFromID(hwnd,IDEF_CDRDAOPATH), fd.szFullFile );
            }
          break;
        case IDPB_CDRDAOSCAN:
          startScanbusHelper(hwnd);
          break;
        case IDPB_CDRDAOUNDO:
          /* User pressed the UNDO button */
          WinSetWindowText(WinWindowFromID(hwnd,IDLB_CDRDAODRIVER),globalData.chrWriterName3);
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRDAOPATH),globalData.chrCdrdaoPath3);
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDRDAOOPTIONS),globalData.chrCdrdaoOptions3);
          WinSetWindowText(WinWindowFromID(hwnd,IDDD_CDRDAODEVICE), globalData.chrDeviceName3);
          break;
        default:
          break;
        }
      return (MRESULT) TRUE;
    case WM_APPTERMINATENOTIFY:
      switch(LONGFROMMP(mp1)) {
      case ACKEY_SCANBUS:
        /* Free shared mem if not already done */
        if(pvScanbusSharedMem) {
          DosFreeMem(pvScanbusSharedMem);
          pvScanbusSharedMem=NULL;
        }
        break;
      case ACKEY_LISTBOX:
        if(LONGFROMMP(mp2)==0) {
          /* Delete entries in listbox */
          WinSetWindowText(WinWindowFromID(hwnd,IDDD_CDRDAODEVICE),"");
          WinSendMsg(WinWindowFromID(hwnd, IDDD_CDRDAODEVICE),LM_DELETEALL,MPFROMLONG(0),MPFROMLONG(0));
          bFirst=TRUE;
        }
        else
          {
            WinSendMsg(WinWindowFromID(hwnd,IDDD_CDRDAODEVICE),LM_INSERTITEM,MPFROMSHORT(LIT_END),
                       mp2);
            if(bFirst) {
              WinSetWindowText(WinWindowFromID(hwnd,IDDD_CDRDAODEVICE),(PCSZ)PVOIDFROMMP(mp2));
              bFirst=FALSE;
            }
          }
        break;
      default:
        break;
      }/* switch */
      break; 
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


/****************************************************/
/*                                                  */ 
/* This procedure handles the grabber settings page */
/* in the settings notebook                         */
/*                                                  */
/****************************************************/
MRESULT EXPENTRY settingsGrabberOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  FILEDLG fd = { 0 };
  CWCreatorSettings* thisPtr;
  int a;
  char chrCD[4];
  char text[CCHMAXPATH]; 
  char text2[100]; 
  static BOOL bInit; 
  SHORT  sCount;

  char *ptr;
  HINI hini;
  ULONG ulSize;
  char *pBuffer;
  BOOL bFirst;
 
  switch(msg)
    {
    case WM_INITDLG:	
      bInit=FALSE;
      WinSetWindowULong(WinWindowFromID(hwnd,IDPB_GRABBERBROWSE),
                        QWL_USER,(ULONG)PVOIDFROMMP(mp2));//Save object ptr.
      thisPtr=(CWCreatorSettings*)PVOIDFROMMP(mp2);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_GRABBERPATH),EM_SETTEXTLIMIT,
                 MPFROMSHORT((SHORT)sizeof(globalData.chrGrabberPath)),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_GRABBERPATH),globalData.chrGrabberPath);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_GRABBEROPTIONS),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)CCHMAXPATH),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDDD_GRABBERNAME),globalData.chrGrabberName);
      WinCheckButton(hwnd,IDCB_TRACKNUMBERS,globalData.bTrackNumbers);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_GRABBEROPTIONS),globalData.chrGrabberOptions);
      for( a=0; a<iNumCD ;a++) {
        chrCD[0]=cFirstCD+a;
        chrCD[1]=':';
        chrCD[2]=0;
        WinSendMsg(WinWindowFromID(hwnd,IDLB_DROPDOWN),LM_INSERTITEM,MPFROMSHORT(LIT_END),(MPARAM)chrCD);
        if(!a){
          if(!GrabberSetupDone)
            WinSetWindowText(WinWindowFromID(hwnd,IDLB_DROPDOWN),chrCD);
          else
            WinSetWindowText(WinWindowFromID(hwnd,IDLB_DROPDOWN),chosenCD);
        }
      }
      /* Fill the listbox with known grabbers from comfig file */
      sprintf(text,"%s\\cfgdata.ini", chrConfigDir);
      hini=PrfOpenProfile(WinQueryAnchorBlock(HWND_DESKTOP),text);
      if(hini)
        {
          if(PrfQueryProfileSize(hini, NULL,NULL,&ulSize)) {// Query size of profile data
            pBuffer=(char*)malloc(ulSize);
            if(pBuffer) {
              if(PrfQueryProfileData(hini, NULL,NULL, pBuffer, &ulSize))// Get the whole data
                {
                  ptr=pBuffer;
                  if(strlen(globalData.chrGrabberName)==0)
                    bFirst=TRUE;
                  else
                    bFirst=FALSE;
                  do {
                    /* Only use entries with options key */
                    PrfQueryProfileString(hini,ptr,"options","",text,sizeof(text));
                    if(strlen(text)!=0) {
                      WinSendMsg(WinWindowFromID(hwnd,IDDD_GRABBERNAME),LM_INSERTITEM,MPFROMSHORT(LIT_SORTASCENDING),
                                 (MPARAM)ptr);
                      /* Insert the first match into the text field */
                      if(bFirst) {
                        bFirst=FALSE;
                        WinSetWindowText(WinWindowFromID(hwnd,IDDD_GRABBERNAME),ptr);
                      }
                    }
                    ptr=strchr(ptr,0);
                    if(!ptr)
                      break;
                    ptr++;
                  }while(*ptr!=0);
                  /* We have all grabber entries in the drop down box */

                  /* Add an user defined entry */
                  /* text: "User defined" */
                  getMessage(text, IDSTRS_DEFAULTUSERGRABBERNAME, sizeof(text), hSettingsResource, hwnd);
                  WinSendMsg(WinWindowFromID(hwnd,IDDD_GRABBERNAME),LM_INSERTITEM,MPFROMSHORT(LIT_SORTASCENDING),
                             (MPARAM)text);
                  if(strlen(globalData.chrGrabberName)==0)
                    {
                      /* This is an upgrade installation or the user defined grabber. 
                         There're entries for the grabber options. */
                      /* Set the default user defined name into the text field */
                      WinSetWindowText(WinWindowFromID(hwnd,IDDD_GRABBERNAME),text);
                    }
                  else {
                    /* Predefined grabber. The user can't change the options. */
                    /* The name is set into the field at the top */
                  }
                }
              free(pBuffer);
            } /* end of if(pBuffer) */
          } /* end of if(PrfQueryProfileSize(hini, NULL,NULL,&ulSize)) */
          PrfCloseProfile(hini);
        }
      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_GRABBERHELP, 20);
      bInit=TRUE;
      return (MRESULT) TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_CONTROL:
      switch(SHORT1FROMMP(mp1))
        {
        case IDDD_GRABBERNAME:
          if(SHORT2FROMMP(mp1)==LN_SELECT && bInit) {
            /* text: "User defined" */
            getMessage(text, IDSTRS_DEFAULTUSERGRABBERNAME, sizeof(text), hSettingsResource, hwnd);
            /* Get the selected grabber name */
            WinQueryWindowText(WinWindowFromID(hwnd,IDDD_GRABBERNAME),sizeof(text2), text2);
            if(strcmpi(text,text2)) {
              /* Predefined grabber */
              sprintf(text,"%s\\cfgdata.ini", chrConfigDir);
              hini=PrfOpenProfile(WinQueryAnchorBlock(HWND_DESKTOP),text);
              if(hini)
                {
                  /* Get the selected grabber name */
                  WinQueryWindowText(WinWindowFromID(hwnd,IDDD_GRABBERNAME),sizeof(text), text);
                  if(PrfQueryProfileString(hini,text,"options","", text2,sizeof(text2))){               
                    WinSetWindowText(WinWindowFromID(hwnd,IDEF_GRABBEROPTIONS),text2);                
                    WinCheckButton(hwnd,IDCB_TRACKNUMBERS,PrfQueryProfileInt(hini,text,"addnumbers",0));
                  }
                  PrfCloseProfile(hini);
                }
            }
            else {
              /* User defined grabber */
             
            }
          }
          break;
        default:
          break;
        }
      break;
    case WM_HELP:	
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_GRABBERBROWSE),QWL_USER);
      if(!somIsObj(thisPtr))
        break;
      switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
        {
        case IDEF_GRABBEROPTIONS:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_GRABBEROPTIONS,AFHELPLIBRARY);
        case IDPB_GRABBERUNDO:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_GRABBERUNDO,AFHELPLIBRARY);
        case IDPB_GRABBERBROWSE:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_GRABBERBROWSE,AFHELPLIBRARY);
        case IDEF_GRABBERPATH:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_GRABBERPATH,AFHELPLIBRARY);
        case IDCB_TRACKNUMBERS:
          return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_TRACKNUMBERS,AFHELPLIBRARY);
          
        default:
          break;
        }
      return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_GRABBERSETUP,AFHELPLIBRARY);
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

      /* Query the grabber path from the entryfield */     
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_GRABBERPATH),
                          sizeof(globalData.chrGrabberPath), globalData.chrGrabberPath);
      /* Query the grabber options from the entryfield */     
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_GRABBEROPTIONS),
                          sizeof(globalData.chrGrabberOptions), globalData.chrGrabberOptions);
      /* Query the cd-drive */
      WinQueryWindowText( WinWindowFromID(hwnd,IDLB_DROPDOWN),sizeof(chosenCD),chosenCD);
      /* Get the choosen grabber */
      /* text: "User defined" */
      getMessage(text, IDSTRS_DEFAULTUSERGRABBERNAME, sizeof(text), hSettingsResource, hwnd);
      /* Get the choosen grabber name */
      WinQueryWindowText(WinWindowFromID(hwnd,IDDD_GRABBERNAME),sizeof(text2), text2);
      if(strcmpi(text,text2)) {
        /* Predefined grabber. Get the name and save it. */
        WinQueryWindowText(WinWindowFromID(hwnd,IDDD_GRABBERNAME),
                           sizeof(globalData.chrGrabberName), globalData.chrGrabberName);
        /* Get the grabber ID and save it */
        sprintf(text,"%s\\cfgdata.ini", chrConfigDir);
        hini=PrfOpenProfile(WinQueryAnchorBlock(HWND_DESKTOP),text);
        if(hini)
          {
            globalData.iGrabberID=PrfQueryProfileInt(hini, globalData.chrGrabberName, "ID", IDGRABBER_UNKNOWN);
            PrfCloseProfile(hini);
          }
      }
      else {
        strcpy(globalData.chrGrabberName,"");/* unknown grabber */
        globalData.iGrabberID=IDGRABBER_UNKNOWN;
      }
      /* Let the WPS save the new instance data */
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_GRABBERBROWSE),QWL_USER);
      globalData.bTrackNumbers=WinQueryButtonCheckstate(hwnd,IDCB_TRACKNUMBERS);
      if(somIsObj(thisPtr)) {
        thisPtr->wpSaveDeferred();
      }
      /* Setup is done */
      GrabberSetupDone=TRUE;
      bInit=FALSE;
      return (MRESULT) TRUE;
    case WM_COMMAND:	
      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_GRABBERBROWSE:
          /* User pressed the browse button */
          fd.cbSize = sizeof( fd );
          /* It's an centered 'Open'-dialog */
          fd.fl = FDS_OPEN_DIALOG|FDS_CENTER;
          /* Set the title of the file dialog */
          /* Title: "Search Audio-Grabber" */
          getMessage(text,IDSTR_FDLGSEARCHGRABBERTITLE,sizeof(text), hSettingsResource,hwnd);
          fd.pszTitle = text;
          /* Only show *.exe files */
          sprintf(fd.szFullFile,"%s","*.exe");
          
          if( WinFileDlg( HWND_DESKTOP, hwnd, &fd ) == NULLHANDLE )
            {
              /* WinFileDlg failed */
              break;
            }
          if( fd.lReturn == DID_OK )
            {
              /* The user chose a grabber */
              WinSetWindowText( WinWindowFromID(hwnd,IDEF_GRABBERPATH), fd.szFullFile );
              /* Try to get the predefined grabber from choosen executable */
              if((ptr=strrchr(fd.szFullFile,'\\'))!=NULL) {
                ptr++;/* Executable name */
                strcpy(text2,ptr);
                if((ptr=strrchr(text2, '.'))==NULL)
                  break;
                *ptr=0;// Remove Extension
                /* Get count of listbox entries */
                sCount=SHORT1FROMMR(WinSendMsg(WinWindowFromID(hwnd,IDDD_GRABBERNAME), LM_QUERYITEMCOUNT, NULL, NULL));
                for(a=0;a<sCount;a++) {
                  if(SHORT1FROMMR(WinSendMsg(WinWindowFromID(hwnd,IDDD_GRABBERNAME), LM_QUERYITEMTEXT,
                                             MPFROM2SHORT((SHORT)a,(SHORT) sizeof(text)), &text))) {
                    if(!strcmpi(text2,text)) {
                      //WinSendMsg(WinWindowFromID(hwnd,IDDD_GRABBERNAME), LM_SELECTITEM, (MPARAM)a, MPFROMSHORT(TRUE));// Select item
                      WinSetWindowText(WinWindowFromID(hwnd,IDDD_GRABBERNAME),text);
                      return (MRESULT) FALSE;
                    }
                  }
                }/* for() */
                /* No predefined grabber found. Set to user defined */
                /* text: "User defined" */
                getMessage(text, IDSTRS_DEFAULTUSERGRABBERNAME, sizeof(text), hSettingsResource, hwnd);
                WinSetWindowText(WinWindowFromID(hwnd,IDDD_GRABBERNAME),text);
              }
            }
          break;
        case IDPB_GRABBERUNDO:
          /* User pressed the UNDO button */
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_GRABBERPATH), globalData.chrGrabberPath);
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_GRABBEROPTIONS), globalData.chrGrabberOptions);
          WinSetWindowText(WinWindowFromID(hwnd,IDLB_DROPDOWN),chosenCD);
          if(strlen(globalData.chrGrabberName)==0) {
            /* text: "User defined" */
            getMessage(text, IDSTRS_DEFAULTUSERGRABBERNAME, sizeof(text), hSettingsResource, hwnd);
            WinSetWindowText(WinWindowFromID(hwnd,IDDD_GRABBERNAME),text);
          }
          else
            WinSetWindowText(WinWindowFromID(hwnd,IDDD_GRABBERNAME), globalData.chrGrabberName);

          break;
        default:
          break;
        }
      return (MRESULT) FALSE;
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/****************************************************/
/*                                                  */ 
/* This procedure handles the mp3 settings page     */
/* in the settings notebook                         */
/*                                                  */
/****************************************************/
MRESULT EXPENTRY settingsMpg123OptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  FILEDLG fd = { 0 };
  CWCreatorSettings* thisPtr;
  int a;
  char chrCD[4];
  char text[CCHMAXPATH]; 
 
  switch(msg)
    {
    case WM_INITDLG :	
      WinSetWindowULong(WinWindowFromID(hwnd,IDPB_MPG123BROWSE),
                        QWL_USER,(ULONG)PVOIDFROMMP(mp2));//Save object ptr.
      thisPtr=(CWCreatorSettings*)PVOIDFROMMP(mp2);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_MPG123PATH),EM_SETTEXTLIMIT,
                 MPFROMSHORT((SHORT)sizeof(globalData.chrMpg123Path)),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_MPG123PATH), globalData.chrMpg123Path);
      if(globalData.bMpg123SwabBytes)
        WinCheckButton(hwnd,IDCB_MPG123SWABBYTES,1);
      else
        WinCheckButton(hwnd,IDCB_MPG123SWABBYTES,0);
      /* Which decoder do we use */
      if(iMp3Decoder==IDKEY_USEMPG123) {
        WinCheckButton(hwnd,IDRB_MPG123,1);
        WinEnableWindow(WinWindowFromID(hwnd,IDCB_MPG123SWABBYTES),TRUE);
      }
      else {
        WinCheckButton(hwnd,IDRB_MPG123,0);
        WinEnableWindow(WinWindowFromID(hwnd,IDCB_MPG123SWABBYTES),FALSE);
      }
      if(iMp3Decoder==IDKEY_USEMMIOMP3) {
        WinCheckButton(hwnd,IDRB_MMIOMP3,1);
        WinEnableWindow(WinWindowFromID(hwnd,IDCB_MPG123SWABBYTES),TRUE);
      }
      else {
        WinCheckButton(hwnd,IDRB_MMIOMP3,0);
        WinEnableWindow(WinWindowFromID(hwnd,IDCB_MPG123SWABBYTES),FALSE);
      }
      if(iMp3Decoder==IDKEY_USEZ)
        WinCheckButton(hwnd,IDRB_Z,1);
      else
        WinCheckButton(hwnd,IDRB_Z,0);

      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_MPG123HELP, 20);
      return (MRESULT) TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), 
                       WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_HELP:	
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_GRABBERBROWSE),QWL_USER);
      if(!somIsObj(thisPtr))
        break;
      switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
        {
          /*        case IDPB_MPG123UNDO:
                    return (MRESULT)thisPtr->wpDisplayHelp(IDPB_GRABBERUNDO,AFHELPLIBRARY);
                    case IDPB_MPG123BROWSE:
                    return (MRESULT)thisPtr->wpDisplayHelp(IDPB_GRABBERBROWSE,AFHELPLIBRARY);
                    case IDEF_MPG123PATH:
                    return (MRESULT)thisPtr->wpDisplayHelp(IDEF_GRABBERPATH,AFHELPLIBRARY);*/
        default:
          break;
        }
      break;
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

      /* Query the mpg123 path from the entryfield */     
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_MPG123PATH),sizeof(globalData.chrMpg123Path),
                          globalData.chrMpg123Path);
      if(WinQueryButtonCheckstate(hwnd,IDCB_MPG123SWABBYTES)&1)
        globalData.bMpg123SwabBytes=TRUE;
      else
        globalData.bMpg123SwabBytes=FALSE;

      if(WinQueryButtonCheckstate(hwnd,IDRB_MPG123)&1)
        iMp3Decoder=IDKEY_USEMPG123;
      else if(WinQueryButtonCheckstate(hwnd,IDRB_Z)&1)
        iMp3Decoder=IDKEY_USEZ;
      else
        if(WinQueryButtonCheckstate(hwnd,IDRB_MMIOMP3)&1)
          iMp3Decoder=IDKEY_USEMMIOMP3;

      /* Let the WPS save the new instance data */
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_MPG123BROWSE),QWL_USER);
      if(somIsObj(thisPtr)) {
        thisPtr->wpSaveImmediate();
      }
      /* Setup is done */
      return (MRESULT) TRUE;
    case WM_CONTROL:
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_MPG123BROWSE),QWL_USER);
      if(!somIsObj(thisPtr)) return (MRESULT) TRUE;
      switch(SHORT1FROMMP(mp1))
        {
        case IDRB_MMIOMP3:
        case IDRB_MPG123:
          WinEnableWindow(WinWindowFromID(hwnd,IDCB_MPG123SWABBYTES),TRUE);
          break;
        case IDRB_Z:
          WinEnableWindow(WinWindowFromID(hwnd,IDCB_MPG123SWABBYTES),FALSE);
          break;

        default:
          break;
        }
      break;

    case WM_COMMAND:	
      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_MPG123BROWSE:
          /* User pressed the browse button */
          fd.cbSize = sizeof( fd );
          /* It's an centered 'Open'-dialog */
          fd.fl = FDS_OPEN_DIALOG|FDS_CENTER;
          /* Set the title of the file dialog */
          /* Title: "Search Audio-Grabber" */
          getMessage(text, IDSTR_FDLGSEARCHMPG123TITLE, sizeof(text), hSettingsResource,hwnd);
          fd.pszTitle = text;
          /* Only show *.exe files */
          sprintf(fd.szFullFile,"%s","*.exe");
          
          if( WinFileDlg( HWND_DESKTOP, hwnd, &fd ) == NULLHANDLE )
            {
              /* WinFileDlg failed */
              break;
            }
          if( fd.lReturn == DID_OK )
            {
              WinSetWindowText( WinWindowFromID(hwnd,IDEF_MPG123PATH), fd.szFullFile );
            }
          break;
        case IDPB_MPG123UNDO:
          /* User pressed the UNDO button */
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_MPG123PATH), globalData.chrMpg123Path);
          if(globalData.bMpg123SwabBytes)
            WinCheckButton(hwnd,IDCB_MPG123SWABBYTES,1);
          else
            WinCheckButton(hwnd,IDCB_MPG123SWABBYTES,0);
          break;
        default:
          break;
        }
      return (MRESULT) TRUE;
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/* This procedure handles the mkisofs settings page */ 
MRESULT EXPENTRY settingsMkisofsOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  FILEDLG fd = { 0 };
  CWCreatorSettings* thisPtr;
  ULONG ulFlags;
  char text[CCHMAXPATH];
  char text2[CCHMAXPATH];

  switch(msg)
    {
    case WM_INITDLG :	
      WinSetWindowULong(WinWindowFromID(hwnd,IDPB_MKISOFSBROWSE),
			QWL_USER,(ULONG)PVOIDFROMMP(mp2));//Save object ptr.
      WinSendMsg(WinWindowFromID(hwnd,IDEF_MKISOFSPATH),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)CCHMAXPATH),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_MKISOFSPATH),chrMkisofs);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_MKISOFSOPTIONS),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)CCHMAXPATH),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_MKISOFSOPTIONS),chrMkisofsOptions);
      /* Codepage disabled? */
      if(bDisableCp)
        WinCheckButton(hwnd,IDCB_DISABLECODEPAGE,1);
      else
        WinCheckButton(hwnd,IDCB_DISABLECODEPAGE,0);

      /* Text: " Codepage for Joliet name creation: %d" */
      getMessage(text,IDSTRD_CODEPAGETEXT, sizeof(text), hSettingsResource,hwnd);

      sprintf(text2,text,iCodePage);
      WinSetWindowText(WinWindowFromID(hwnd,IDST_CODEPAGETEXT),text2);
      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_MKISOFSHELP, 20);
      return (MRESULT) TRUE;
      /*    case WM_HELP:
			thisPtr=(CWAudioFolder*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_CDRECORDBROWSE),QWL_USER);
			if(!thisPtr)
            break;
			switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
            {
            case IDEF_CDRECORDOPTIONS:
            return (MRESULT)thisPtr->wpDisplayHelp(IDEF_CDRECORDOPTIONS,AFHELPLIBRARY);
            case IDPB_WIDERRUFEN:
            return (MRESULT)thisPtr->wpDisplayHelp(IDPB_WIDERRUFEN,AFHELPLIBRARY);
            case IDPB_CDRECORDBROWSE:
            return (MRESULT)thisPtr->wpDisplayHelp(IDPB_CDRECORDBROWSE,AFHELPLIBRARY);
            case IDEF_CDRECORDPATH:
            return (MRESULT)thisPtr->wpDisplayHelp(IDEF_CDRECORDPATH,AFHELPLIBRARY);
            default:
            break;
            }
			return (MRESULT)thisPtr->wpDisplayHelp(IDDLG_CDRECORDSETUP,AFHELPLIBRARY);
			break;*/
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }

#if 0
    case WM_WINDOWPOSCHANGED:
      {
        /* This prevents switching the notebook page behind the open folder */
        if(!(WinQueryWindowUShort(WinQueryWindow(hwnd, QW_PARENT), QWS_FLAGS) & FF_ACTIVE))
          mp2=MPFROMLONG(0x80000);
        break;
      }
#endif
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

      /* Query the cdrecord path from the entryfield */     
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_MKISOFSPATH),sizeof(chrMkisofs),chrMkisofs);
      /* Query the cdrecord options from the entryfield */     
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_MKISOFSOPTIONS),sizeof(chrMkisofsOptions),chrMkisofsOptions);
      ulFlags=0;
      lMKOptions=ulFlags;
      if(WinQueryButtonCheckstate(hwnd,IDCB_DISABLECODEPAGE)&1)
        bDisableCp=TRUE;
      else
        bDisableCp=FALSE;
      /* Let the WPS save the new instance data */
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_MKISOFSBROWSE),QWL_USER);
      if(somIsObj(thisPtr)) {
        /*if(WinQueryButtonCheckstate(hwnd,IDCB_LOGFILE)&1)
           thisPtr->cwSetMkisofsFlags(IDMK_LOGFILE,IDMK_LOGFILE);
           else
           thisPtr->cwSetMkisofsFlags(0,IDMK_LOGFILE); */
        thisPtr->wpSaveDeferred();
      }
      /* Setup is done */
      MkisofsSetupDone=TRUE;
      return (MRESULT) TRUE;
    case WM_COMMAND:	
    switch(SHORT1FROMMP(mp1))
      {
      case IDPB_MKISOFSBROWSE:
	/* User pressed the browse button */
	fd.cbSize = sizeof( fd );
	/* It's an centered 'Open'-dialog */
	fd.fl = FDS_OPEN_DIALOG|FDS_CENTER;
	/* Set the title of the file dialog */
    /* Text: "Search mkisofs" */
    getMessage(text,IDSTRD_FDLGSEARCHMKISOFS, sizeof(text), hSettingsResource,hwnd);
	fd.pszTitle = text;
	/* Only show *.exe files */
	sprintf(fd.szFullFile,"%s","*.exe");

	if( WinFileDlg( HWND_DESKTOP, hwnd, &fd ) == NULLHANDLE )
	  {
	    /* WinFileDlg failed */
	    break;
	  }
	if( fd.lReturn == DID_OK )
	  {
	    WinSetWindowText( WinWindowFromID(hwnd,IDEF_MKISOFSPATH), fd.szFullFile );
	  }
	break;
      case IDPB_MKISOFSUNDO:
	/* User pressed the UNDO button */

 	WinSetWindowText(WinWindowFromID(hwnd,IDEF_MKISOFSPATH),chrMkisofs);
	WinSetWindowText(WinWindowFromID(hwnd,IDEF_MKISOFSOPTIONS),chrMkisofsOptions);
    /*  
          thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_MKISOFSBROWSE),QWL_USER);
          if(thisPtr) {
          if(thisPtr->cwQueryMkisofsFlags()&IDMK_LOGFILE)
          WinCheckButton(hwnd,IDCB_LOGFILE,1);
          else
          WinCheckButton(hwnd,IDCB_LOGFILE,0);
          } */
	break;
      default:
	break;
      }
      return (MRESULT) TRUE;
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


/****************************************************/
/*                                                  */ 
/* This procedure handles the CDDB settings page    */
/* in the settings notebook                         */
/*                                                  */
/****************************************************/
MRESULT EXPENTRY settingsCDDBOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  FILEDLG fd = { 0 };
  CWCreatorSettings* thisPtr;
  int a;
  char chrCD[4];
  char text[CCHMAXPATH]; 
 
  switch(msg)
    {
    case WM_INITDLG :	
      //      WinSetWindowULong(WinWindowFromID(hwnd,IDPB_CDDBUNDO),
      //                QWL_USER,(ULONG)PVOIDFROMMP(mp2));
      WinSetWindowULong(hwnd,QWL_USER,LONGFROMMP(mp2));//Save object ptr.
      
      WinSendMsg(WinWindowFromID(hwnd,IDEF_CDDBUSER),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(chrCDDBUser)),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDDBUSER),chrCDDBUser);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_USERHOST),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(chrCDDBUserHost)),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_USERHOST),chrCDDBUserHost);

      if(bUseCDDB)
        WinCheckButton(hwnd,IDCB_USECDDB,1);
      else
        WinCheckButton(hwnd,IDCB_USECDDB,0);

      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_CDDBHELP, 20);
      return (MRESULT) TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
#if 0
    case WM_WINDOWPOSCHANGED:
      {
        /* This prevents switching the notebook page behind the open folder */
        if(!(WinQueryWindowUShort(WinQueryWindow(hwnd, QW_PARENT), QWS_FLAGS) & FF_ACTIVE))
          mp2=MPFROMLONG(0x80000);
        break;
      }
#endif
    case WM_HELP:
      //thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_CDDBUNDO),QWL_USER);
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(hwnd,QWL_USER);
      if(!somIsObj(thisPtr))
        break;
      switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
        {
        case IDPB_CDDBUNDO:
          return (MRESULT)thisPtr->wpDisplayHelp(1301,AFHELPLIBRARY);
        case IDCB_USECDDB:
          return (MRESULT)thisPtr->wpDisplayHelp(1302,AFHELPLIBRARY);
        case IDEF_CDDBUSER:
          return (MRESULT)thisPtr->wpDisplayHelp(1303,AFHELPLIBRARY);
        case IDEF_USERHOST:
          return (MRESULT)thisPtr->wpDisplayHelp(1306,AFHELPLIBRARY);
        default:
          break;
        }
      return (MRESULT)thisPtr->wpDisplayHelp(1300,AFHELPLIBRARY);
      break;
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_CDDBUSER),sizeof(chrCDDBUser),chrCDDBUser);
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_USERHOST),sizeof(chrCDDBUserHost),chrCDDBUserHost);
      if(WinQueryButtonCheckstate(hwnd,IDCB_USECDDB)&1)
        bUseCDDB=TRUE;
      else
        bUseCDDB=FALSE;
      /* Let the WPS save the new instance data */
      //thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd, IDPB_CDDBUNDO),QWL_USER);
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(hwnd,QWL_USER);
      if(somIsObj(thisPtr)) {
        thisPtr->wpSaveImmediate();
      }
      /* Setup is done */
      return (MRESULT) TRUE;
    case WM_COMMAND:	
      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_CDDBUNDO:
          /* User pressed the UNDO button */
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_CDDBUSER),chrCDDBUser);
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_USERHOST),chrCDDBUserHost);
          if(bUseCDDB)
            WinCheckButton(hwnd,IDCB_USECDDB,1);
          else
            WinCheckButton(hwnd,IDCB_USECDDB,0);
          break;
        case IDPB_CDDBHELP:
          //thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd, IDPB_CDDBUNDO),QWL_USER);
          thisPtr=(CWCreatorSettings*) WinQueryWindowULong(hwnd,QWL_USER);
          if(!somIsObj(thisPtr))
            break;
          return (MRESULT)thisPtr->wpDisplayHelp(1300,AFHELPLIBRARY);
          break;
        default:
          break;
        }
      return (MRESULT) TRUE;
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/****************************************************/
/*                                                  */ 
/* This procedure handles the CDDB settings page 2  */
/* in the settings notebook                         */
/*                                                  */
/****************************************************/
MRESULT EXPENTRY settingsCDDBOptionDlgProc2(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  FILEDLG fd = { 0 };
  CWCreatorSettings* thisPtr;
  int a;
  char chrCD[4];
  char text[CCHMAXPATH]; 
 
  switch(msg)
    {
    case WM_INITDLG :	
      //  WinSetWindowULong(WinWindowFromID(hwnd,IDPB_WIDERRUFEN),
      //                QWL_USER,(ULONG)PVOIDFROMMP(mp2));
      WinSetWindowULong(hwnd,QWL_USER,LONGFROMMP(mp2));//Save object ptr.

      for(a=0;a<NUMSERVERS;a++) {
        WinInsertLboxItem(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LIT_END,
                          cddbServer[a]);
      }
      /* Preselect the first item */
      WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_SELECTITEM,MPFROMSHORT(0),MPFROMSHORT(TRUE));
      WinSendMsg(WinWindowFromID(hwnd,IDEF_NEWSERVER),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(cddbServer[0])),0);
      if(MAXSERVERS==NUMSERVERS)
        WinEnableWindow(WinWindowFromID(hwnd,IDPB_SERVERADD),FALSE);
      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_CDDB2HELP, 20);
      return (MRESULT) TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
#if 0
    case WM_WINDOWPOSCHANGED:
      {
        /* This prevents switching the notebook page behind the open folder */
        if(!(WinQueryWindowUShort(WinQueryWindow(hwnd, QW_PARENT), QWS_FLAGS) & FF_ACTIVE))
          mp2=MPFROMLONG(0x80000);
        break;
      }
#endif
    case WM_HELP:	
      //      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_WIDERRUFEN),QWL_USER);
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(hwnd,QWL_USER);
      if(!somIsObj(thisPtr))
        break;
      switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
        {

        default:
          break;
        }
      return (MRESULT)thisPtr->wpDisplayHelp(1307,AFHELPLIBRARY);
      break;
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

      NUMSERVERS=(int)LONGFROMMR(WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS), LM_QUERYITEMCOUNT,0,0));
      for(a=0;a<NUMSERVERS;a++) {
        strcpy(text,cddbServer[a]);
        WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_QUERYITEMTEXT,
                   MPFROM2SHORT(a,sizeof(cddbServer[0])),cddbServer[a]);
      }
      
      /* Let the WPS save the new instance data */
      //      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_WIDERRUFEN),QWL_USER);
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(hwnd,QWL_USER);
      if(somIsObj(thisPtr)) {
        thisPtr->wpSaveImmediate();
      }
      /* Setup is done */
      return (MRESULT) TRUE;
    case WM_COMMAND:	
      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_CDDB2UNDO:
          /* User pressed the UNDO button */
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_NEWSERVER),"");
          /* Server listbox */
          WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_DELETEALL,
                     0,0);
          for(a=0;a<NUMSERVERS;a++) {
            WinInsertLboxItem(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LIT_END,
                              cddbServer[a]);
          }
          /* Preselect the first item */
          WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_SELECTITEM,MPFROMSHORT(0),MPFROMSHORT(TRUE));
          if(MAXSERVERS==NUMSERVERS)
            WinEnableWindow(WinWindowFromID(hwnd,IDPB_SERVERADD),FALSE);
          break;
        case IDPB_SERVERDELETE:
          a=SHORT1FROMMR(WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_QUERYSELECTION,MPFROMSHORT(LIT_FIRST),0));
          WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_DELETEITEM,MPFROMSHORT(a),0);
          if(MAXSERVERS==NUMSERVERS)
            WinEnableWindow(WinWindowFromID(hwnd,IDPB_SERVERADD),TRUE);      
          break;
        case IDPB_SERVERADD:
          WinQueryWindowText( WinWindowFromID(hwnd,IDEF_NEWSERVER),sizeof(text),text);
          if(!strchr(text,':'))
            break;
          WinInsertLboxItem(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LIT_END,
                            text);
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_NEWSERVER),"");
          if(MAXSERVERS==(int)LONGFROMMR(WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS), LM_QUERYITEMCOUNT,0,0)))
            WinEnableWindow(WinWindowFromID(hwnd,IDPB_SERVERADD),FALSE);
          break;
        case IDPB_SERVERUP:
          /* Get pos of selection */
          a=SHORT1FROMMR(WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_QUERYSELECTION,MPFROMSHORT(LIT_FIRST),0));
          if(a==0)
            break;
          /* Query item text */
          WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_QUERYITEMTEXT,
                     MPFROM2SHORT(a,sizeof(text)), text);
          /* Delete at current position */
          WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_DELETEITEM,MPFROMSHORT(a),0);
          /* Insert at new position */
          WinInsertLboxItem(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),a-1,
                            text);
          WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_SELECTITEM,MPFROMSHORT(a-1),MPFROMSHORT(TRUE));
          break;
        case IDPB_SERVERDOWN:
          /* Get pos of selection */
          a=SHORT1FROMMR(WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_QUERYSELECTION,MPFROMSHORT(LIT_FIRST),0));
          if(a==(int)(LONGFROMMR(WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS), LM_QUERYITEMCOUNT,0,0))-1))
            break; 
         /* Query item text */
          WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_QUERYITEMTEXT,
                     MPFROM2SHORT(a,sizeof(text)), text);
          /* Delete at current position */
          WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_DELETEITEM,MPFROMSHORT(a),0);
          /* Insert at new position */
          WinInsertLboxItem(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),a+1,
                            text);
          WinSendMsg(WinWindowFromID(hwnd,IDLB_CDDBSERVERS),LM_SELECTITEM,MPFROMSHORT(a+1),MPFROMSHORT(TRUE));
          break;
        case IDPB_CDDB2HELP:
          //thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_WIDERRUFEN),QWL_USER);
          thisPtr=(CWCreatorSettings*) WinQueryWindowULong(hwnd,QWL_USER);
          if(!somIsObj(thisPtr))
            break;
          return (MRESULT)thisPtr->wpDisplayHelp(1307,AFHELPLIBRARY);
        default:
          break;
        }
      return (MRESULT) TRUE;
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/****************************************************/
MRESULT EXPENTRY settingsMP3EncoderOptionDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  FILEDLG fd = { 0 };
  CWCreatorSettings* thisPtr;
  int a;
  char chrCD[4];
  char text[CCHMAXPATH]; 
 
  switch(msg)
    {
    case WM_INITDLG :	
      WinSetWindowULong(WinWindowFromID(hwnd,IDPB_MP3ENCODERBROWSE),
                        QWL_USER,(ULONG)PVOIDFROMMP(mp2));//Save object ptr.
      thisPtr=(CWCreatorSettings*)PVOIDFROMMP(mp2);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_MP3ENCODERPATH),EM_SETTEXTLIMIT,
                 MPFROMSHORT((SHORT)sizeof(chrMP3EncoderPath)),0);
      WinSetWindowText(WinWindowFromID(hwnd,IDEF_MP3ENCODERPATH),chrMP3EncoderPath);
      WinSendMsg(WinWindowFromID(hwnd, IDEF_MP3ENCODEROPTIONS),EM_SETTEXTLIMIT,
                 MPFROMSHORT((SHORT) sizeof(chrMP3EncoderOptions)),0);
      WinSetWindowText(WinWindowFromID(hwnd, IDEF_MP3ENCODEROPTIONS),chrMP3EncoderOptions);

      /* Bitrate spin button */
      WinSendMsg(WinWindowFromID(hwnd,IDSB_BITRATE),SPBM_SETLIMITS,MPFROMLONG(320),MPFROMLONG(4));
      WinSendMsg(WinWindowFromID(hwnd,IDSB_BITRATE),SPBM_SETCURRENTVALUE,(MPARAM) ulMP3Bitrate, MPFROMLONG(0));

      WinEnableWindow(WinWindowFromID(hwnd, IDSB_BITRATE), FALSE);
      switch(ulMP3Quality)
        {
        case IDQUALITY_VBRSTANDARD:
          WinCheckButton(hwnd, IDRB_VBRSTANDARD, 1);
          break;
        case IDQUALITY_VBREXTREME:
          WinCheckButton(hwnd, IDRB_VBREXTREME, 1);
          break;
        case IDQUALITY_AVERAGE:
          WinCheckButton(hwnd, IDRB_AVERAGE, 1);
          WinEnableWindow(WinWindowFromID(hwnd, IDSB_BITRATE), TRUE);
          break;
        case IDQUALITY_USERDEFINED:
          WinCheckButton(hwnd, IDRB_USERDEFINED, 1);
          break;
        default:
          break;
        }
      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_MP3ENCODERHELP, 15);
      return (MRESULT) TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), 
                       WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_HELP:	
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_MP3ENCODERBROWSE),QWL_USER);
      if(!somIsObj(thisPtr))
        break;
      switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
        {
          /*        case IDPB_MPG123UNDO:
                    return (MRESULT)thisPtr->wpDisplayHelp(IDPB_GRABBERUNDO,AFHELPLIBRARY);
                    case IDPB_MPG123BROWSE:
                    return (MRESULT)thisPtr->wpDisplayHelp(IDPB_GRABBERBROWSE,AFHELPLIBRARY);
                    case IDEF_MPG123PATH:
                    return (MRESULT)thisPtr->wpDisplayHelp(IDEF_GRABBERPATH,AFHELPLIBRARY);*/
        default:
          break;
        }
      return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_MP3ENCODERSETUP, AFHELPLIBRARY);
      break;
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

      /* Query the mp3 encoder path from the entryfield */     
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_MP3ENCODERPATH), sizeof(chrMP3EncoderPath),chrMP3EncoderPath);
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_MP3ENCODEROPTIONS), sizeof(chrMP3EncoderOptions),chrMP3EncoderOptions);

      WinSendMsg(WinWindowFromID(hwnd,IDSB_BITRATE), SPBM_QUERYVALUE,MPFROMP(&ulMP3Bitrate),
                 MPFROM2SHORT(0,SPBQ_ALWAYSUPDATE));
      
      if(WinQueryButtonCheckstate(hwnd,IDRB_VBRSTANDARD)&1)
        ulMP3Quality=IDQUALITY_VBRSTANDARD;
      else  if(WinQueryButtonCheckstate(hwnd,IDRB_VBREXTREME)&1)
        ulMP3Quality=IDQUALITY_VBREXTREME;
      else if(WinQueryButtonCheckstate(hwnd,IDRB_AVERAGE)&1)
        ulMP3Quality=IDQUALITY_AVERAGE;
      else if(WinQueryButtonCheckstate(hwnd,IDRB_USERDEFINED)&1)
        ulMP3Quality=IDQUALITY_USERDEFINED;
      
      /* Let the WPS save the new instance data */
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDPB_MP3ENCODERBROWSE),QWL_USER);
      if(somIsObj(thisPtr)) {
        thisPtr->wpSaveImmediate();
      }
      /* Setup is done */
      return (MRESULT) TRUE;
    case WM_CONTROL:
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd, IDPB_MP3ENCODERBROWSE),QWL_USER);
      if(!somIsObj(thisPtr)) return (MRESULT) TRUE;
      switch(SHORT1FROMMP(mp1))
        {
        case IDRB_VBRSTANDARD:
        case IDRB_VBREXTREME:
        case IDRB_MP3ENCUSERDEFINED:
          WinEnableWindow(WinWindowFromID(hwnd, IDSB_BITRATE), FALSE);
          break;
        case IDRB_AVERAGE:
          WinEnableWindow(WinWindowFromID(hwnd, IDSB_BITRATE), TRUE);
          break;
        default:
          break;
        }
      break;

    case WM_COMMAND:	
      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_MP3ENCODERBROWSE:
          /* User pressed the browse button */
          fd.cbSize = sizeof( fd );
          /* It's an centered 'Open'-dialog */
          fd.fl = FDS_OPEN_DIALOG|FDS_CENTER;
          /* Set the title of the file dialog */
          /* Title: "Search Audio-Grabber" */
          getMessage(text, IDSTR_FDLGSEARCHMPG123TITLE, sizeof(text), hSettingsResource,hwnd);
          fd.pszTitle = text;
          /* Only show *.exe files */
          sprintf(fd.szFullFile,"%s","*.exe");
          
          if( WinFileDlg( HWND_DESKTOP, hwnd, &fd ) == NULLHANDLE )
            {
              /* WinFileDlg failed */
              break;
            }
          if( fd.lReturn == DID_OK )
            {
              WinSetWindowText( WinWindowFromID(hwnd,IDEF_MP3ENCODERPATH), fd.szFullFile );
            }
          break;
        case IDPB_MP3ENCODERUNDO:
          /* User pressed the UNDO button */
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_MP3ENCODERPATH),chrMP3EncoderPath);
          WinSetWindowText(WinWindowFromID(hwnd, IDEF_MP3ENCODEROPTIONS),chrMP3EncoderOptions);
          /* Bitrate spin button */
          WinSendMsg(WinWindowFromID(hwnd,IDSB_BITRATE),SPBM_SETCURRENTVALUE,(MPARAM) ulMP3Bitrate, MPFROMLONG(0));
          WinEnableWindow(WinWindowFromID(hwnd, IDSB_BITRATE), FALSE);
          switch(ulMP3Quality)
            {
            case IDQUALITY_VBRSTANDARD:
              WinCheckButton(hwnd, IDRB_VBRSTANDARD, 1);
              break;
            case IDQUALITY_VBREXTREME:
              WinCheckButton(hwnd, IDRB_VBREXTREME, 1);
              break;
            case IDQUALITY_AVERAGE:
              WinCheckButton(hwnd, IDRB_AVERAGE, 1);
              WinEnableWindow(WinWindowFromID(hwnd, IDSB_BITRATE), TRUE);
              break;
            case IDQUALITY_USERDEFINED:
              WinCheckButton(hwnd, IDRB_USERDEFINED, 1);
              break;
            default:
              break;
            }
          break;
        default:
          break;
        }
      return (MRESULT) TRUE;
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

static void _fillMP3NameDropDown(HWND hwnd, int iWhichNamePart)
{
  WinSendMsg(hwnd, LM_INSERTITEM, MPFROMSHORT(0), (MPARAM)g_chrMP3Names[IDMP3NAMING_NONE]);
  WinSendMsg(hwnd, LM_INSERTITEM, MPFROMSHORT(LIT_SORTASCENDING), (MPARAM)g_chrMP3Names[IDMP3NAMING_ALBUM]);
  WinSendMsg(hwnd, LM_INSERTITEM, MPFROMSHORT(LIT_SORTASCENDING), (MPARAM)g_chrMP3Names[IDMP3NAMING_ARTIST]);
  WinSendMsg(hwnd, LM_INSERTITEM, MPFROMSHORT(LIT_SORTASCENDING), (MPARAM)g_chrMP3Names[IDMP3NAMING_TITLE]);
  WinSendMsg(hwnd, LM_INSERTITEM, MPFROMSHORT(LIT_SORTASCENDING), (MPARAM)g_chrMP3Names[IDMP3NAMING_TRACK]);
  WinSetWindowText(hwnd, g_chrMP3Names[g_cChosenMP3Name[iWhichNamePart]]);
} 

static void _fillMP3NameFillStringFields(HWND hwndDlg)
{
  WinSetWindowText(WinWindowFromID(hwndDlg, IDEF_MP3NAME1), g_chrMP3NameFillStrings[0]);
  WinSetWindowText(WinWindowFromID(hwndDlg, IDEF_MP3NAME2), g_chrMP3NameFillStrings[1]);
  WinSetWindowText(WinWindowFromID(hwndDlg, IDEF_MP3NAME3), g_chrMP3NameFillStrings[2]);
}

static int _idMP3NamingFromDropDown(HWND hwnd)
{
  int a;
  char chrText[50];

  WinQueryWindowText(hwnd, sizeof(chrText), 
                     chrText);
  for(a=0;a<NUM_MP3NAMES;a++)
    {
      if(!stricmp(chrText, g_chrMP3Names[a]))
        return a;
    }
  return IDMP3NAMING_NONE;
}


static void _buildMP3NameExample(HWND hwndDlg)
{
  char chrExample[200]={0};
  char chrText[10];

  /* First drop down box */
  strncat(chrExample,g_chrMP3NameExample[_idMP3NamingFromDropDown(WinWindowFromID(hwndDlg, IDDD_MP3NAME1))],
          sizeof(chrExample)-strlen(chrExample)-1);
  /* First entry field */
  WinQueryWindowText(WinWindowFromID(hwndDlg, IDEF_MP3NAME1), sizeof(chrText), 
                     chrText);
  strncat(chrExample, chrText,
          sizeof(chrExample)-strlen(chrExample)-1);

  /* Second drop down box */
  strncat(chrExample,g_chrMP3NameExample[_idMP3NamingFromDropDown(WinWindowFromID(hwndDlg, IDDD_MP3NAME2))],
          sizeof(chrExample)-strlen(chrExample)-1);
  WinQueryWindowText(WinWindowFromID(hwndDlg, IDEF_MP3NAME2), sizeof(chrText), 
                     chrText);
  strncat(chrExample, chrText,
          sizeof(chrExample)-strlen(chrExample)-1);

  strncat(chrExample,g_chrMP3NameExample[_idMP3NamingFromDropDown(WinWindowFromID(hwndDlg, IDDD_MP3NAME3))],
          sizeof(chrExample)-strlen(chrExample)-1);
  WinQueryWindowText(WinWindowFromID(hwndDlg, IDEF_MP3NAME3), sizeof(chrText), 
                     chrText);
  strncat(chrExample, chrText,
          sizeof(chrExample)-strlen(chrExample)-1);

  strncat(chrExample,g_chrMP3NameExample[_idMP3NamingFromDropDown(WinWindowFromID(hwndDlg, IDDD_MP3NAME4))],
          sizeof(chrExample)-strlen(chrExample)-1);

  strncat(chrExample, ".mp3",
          sizeof(chrExample)-strlen(chrExample)-1);

  WinSetWindowText(WinWindowFromID(hwndDlg, IDST_MP3NAMEEXAMPLE), chrExample);
}


MRESULT EXPENTRY dirDialogProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  switch(msg)
    {
    case WM_COMMAND:
      {
        if(SHORT1FROMMP(mp1)==DID_OK)
          {
            FILEDLG *fd;
            fd=(FILEDLG*)WinQueryWindowULong(hwnd, QWL_USER);
            fd->szFullFile[strlen(fd->szFullFile)-1]=0;
            //            WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, fd->szFullFile, "", 123, MB_MOVEABLE|MB_OK);
            fd->lReturn=DID_OK;
            WinDismissDlg(hwnd, DID_OK);
            return (MRESULT)FALSE;
          }
        break;
      }
    case WM_CONTROL:
      {
        if(SHORT2FROMMP(mp1)==CBN_EFCHANGE) {
          FILEDLG *fd;
          char text[CCHMAXPATH];

          fd=(FILEDLG*)WinQueryWindowULong(hwnd, QWL_USER);
          strncpy(text, fd->szFullFile,CCHMAXPATH);
          text[CCHMAXPATH-1]=0;
          text[strlen(text)-1]=0;
          WinSetWindowText(WinWindowFromID(hwnd, 4096), text);
        }
        break;
      }
    case WM_INITDLG:
      {
        MRESULT mr;
#if 0
        FILEDLG *fd;
        
        fd=(FILEDLG*)WinQueryWindowULong(hwnd, QWL_USER);
        if(fd->szFullFile[0]!=0)
          {
            WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, fd->szFullFile, "", 123, MB_MOVEABLE|MB_OK);
            if(fd->szFullFile[strlen(fd->szFullFile)]!='\\') {
              strcat(fd->szFullFile, "\\*.*");
         WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, fd->szFullFile, "", 123, MB_MOVEABLE|MB_OK);
              
            }
          }
#endif
        mr=WinDefFileDlgProc(hwnd, msg, mp1, mp2);
        WinSetWindowText(WinWindowFromID(hwnd, 258),"");
        WinEnableWindow(WinWindowFromID(hwnd, DID_OK), TRUE);
        return mr;
      }
    default:
      break;
    }
  return WinDefFileDlgProc(hwnd, msg, mp1, mp2);
}

/****************************************************/
MRESULT EXPENTRY settingsMP3EncoderOptionDlgProc2(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) 
{
  FILEDLG fd = { 0 };
  CWCreatorSettings* thisPtr;
  int a;
  char chrCD[4];
  char text[CCHMAXPATH]; 
 
  switch(msg)
    {
    case WM_INITDLG :	
      WinSetWindowULong(WinWindowFromID(hwnd,IDEF_MP3NAME1),
                        QWL_USER,(ULONG)PVOIDFROMMP(mp2));//Save object ptr.
      thisPtr=(CWCreatorSettings*)PVOIDFROMMP(mp2);

      _fillMP3NameDropDown(WinWindowFromID(hwnd, IDDD_MP3NAME1), 0);
      _fillMP3NameDropDown(WinWindowFromID(hwnd, IDDD_MP3NAME2), 1);
      _fillMP3NameDropDown(WinWindowFromID(hwnd, IDDD_MP3NAME3), 2);
      _fillMP3NameDropDown(WinWindowFromID(hwnd, IDDD_MP3NAME4), 3);

      _fillMP3NameFillStringFields(hwnd);
      WinSetWindowText(WinWindowFromID(hwnd, IDEF_MP3LIBRARY), globalData.chrMP3LibraryPath);

      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_MP3ENCODERHELP, 15);
      return (MRESULT) TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), 
                       WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_HELP:	
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDEF_MP3NAME1),QWL_USER);
      if(!somIsObj(thisPtr))
        break;
      switch(WinQueryWindowUShort(WinQueryFocus(HWND_DESKTOP),QWS_ID))
        {
          /*        case IDPB_MPG123UNDO:
                    return (MRESULT)thisPtr->wpDisplayHelp(IDPB_GRABBERUNDO,AFHELPLIBRARY);
                    case IDPB_MPG123BROWSE:
                    return (MRESULT)thisPtr->wpDisplayHelp(IDPB_GRABBERBROWSE,AFHELPLIBRARY);
                    case IDEF_MPG123PATH:
                    return (MRESULT)thisPtr->wpDisplayHelp(IDEF_GRABBERPATH,AFHELPLIBRARY);*/
        default:
          break;
        }
      return (MRESULT)thisPtr->wpDisplayHelp(IDHLP_MP3ENCODER2SETUP, AFHELPLIBRARY);
      break;
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);

      /* Query the entryfield strings */
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_MP3NAME1), sizeof(g_chrMP3NameFillStrings[0]),
                          g_chrMP3NameFillStrings[0]);
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_MP3NAME2), sizeof(g_chrMP3NameFillStrings[0]),
                          g_chrMP3NameFillStrings[1]);
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_MP3NAME3), sizeof(g_chrMP3NameFillStrings[0]),
                          g_chrMP3NameFillStrings[2]);
      WinQueryWindowText( WinWindowFromID(hwnd,IDEF_MP3LIBRARY), sizeof(globalData.chrMP3LibraryPath),
                          globalData.chrMP3LibraryPath);


      g_cChosenMP3Name[0]=_idMP3NamingFromDropDown(WinWindowFromID(hwnd, IDDD_MP3NAME1));
      g_cChosenMP3Name[1]=_idMP3NamingFromDropDown(WinWindowFromID(hwnd, IDDD_MP3NAME2));
      g_cChosenMP3Name[2]=_idMP3NamingFromDropDown(WinWindowFromID(hwnd, IDDD_MP3NAME3));
      g_cChosenMP3Name[3]=_idMP3NamingFromDropDown(WinWindowFromID(hwnd, IDDD_MP3NAME4));
      /* Let the WPS save the new instance data */
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd,IDEF_MP3NAME1),QWL_USER);
      if(somIsObj(thisPtr)) {
        thisPtr->wpSaveImmediate();
      }
      /* Setup is done */
      return (MRESULT) TRUE;
    case WM_CONTROL:
      thisPtr=(CWCreatorSettings*) WinQueryWindowULong(WinWindowFromID(hwnd, IDEF_MP3NAME1),QWL_USER);
      if(!somIsObj(thisPtr)) return (MRESULT) TRUE;

      //      if(SHORT2FROMMP(mp1)==CBN_EFCHANGE)
      //     DosBeep(5000, 200);
      if(SHORT2FROMMP(mp1)==CBN_EFCHANGE) {
        switch(SHORT1FROMMP(mp1))
          {
          case IDDD_MP3NAME1:
          case IDDD_MP3NAME2:
          case IDDD_MP3NAME3:
          case IDDD_MP3NAME4:
            _buildMP3NameExample(hwnd);
          default:
            break;
          }
      }

      if(SHORT2FROMMP(mp1)==EN_CHANGE) {
        switch(SHORT1FROMMP(mp1))
          {
          case IDEF_MP3NAME1:
          case IDEF_MP3NAME2:
          case IDEF_MP3NAME3:
            _buildMP3NameExample(hwnd);
          default:
            break;
          }
      }
      break;
    case WM_COMMAND:	
      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_MP3LIBRARYBROWSE:
          /* User pressed the browse button */
          fd.cbSize = sizeof( fd );
          /* It's an centered 'Open'-dialog */
          fd.fl = FDS_CUSTOM|FDS_OPEN_DIALOG|FDS_CENTER;
          fd.pfnDlgProc=dirDialogProc;
          fd.usDlgId=IDDLG_DIRECTORY;
          fd.hMod=hSettingsResource;
          /* Set the title of the file dialog */
          /* Title: "Search Audio-Grabber" */
          //   getMessage(text, IDSTR_FDLGSEARCHMPG123TITLE, sizeof(text), hSettingsResource,hwnd);
          //   fd.pszTitle = text;
          /* Only show *.exe files */
          strncpy(fd.szFullFile, globalData.chrMP3LibraryPath, CCHMAXPATH);
          strcat(fd.szFullFile, "\\");
          fd.szFullFile[CCHMAXPATH-1]=0;
          if( WinFileDlg( HWND_DESKTOP, hwnd, &fd ) == NULLHANDLE )
            {
              /* WinFileDlg failed */
              break;
            }
          if( fd.lReturn == DID_OK )
            {
              WinSetWindowText( WinWindowFromID(hwnd,IDEF_MP3LIBRARY), fd.szFullFile );
            }
          break;
        case IDPB_MP3ENCODERUNDO:
          /* User pressed the UNDO button */
          _fillMP3NameDropDown(WinWindowFromID(hwnd, IDDD_MP3NAME1), 0);
          _fillMP3NameDropDown(WinWindowFromID(hwnd, IDDD_MP3NAME2), 1);
          _fillMP3NameDropDown(WinWindowFromID(hwnd, IDDD_MP3NAME3), 2);
          _fillMP3NameDropDown(WinWindowFromID(hwnd, IDDD_MP3NAME4), 3);
          _fillMP3NameFillStringFields(hwnd);
          WinSetWindowText(WinWindowFromID(hwnd, IDEF_MP3LIBRARY), globalData.chrMP3LibraryPath);

          break;
        default:
          break;
        }
      return (MRESULT) TRUE;
    default:
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

