/*
 * cdsize.exe (C) Chris Wohlgemuth 1999-2001
 *
 * This helper calculates the free space on a CDR and sends it
 * to the creator folder class
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#define  INCL_DOS
#define INCL_DOSQUEUES   /* Queue values */
#define INCL_PM
 
#include <os2.h>
#include <process.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "audiofolder.h"
#include "audiofolderres.h"

#define LOGFILE_NAME "scanbus.log"

char chrInstallDir[CCHMAXPATH];

/* This function removes the file 'logFile'
   from the creator inatallation directory
   */
void removeLog(char* logFile)
{
  char logNameLocal[CCHMAXPATH];

  sprintf(logNameLocal,"%s\\Logfiles\\%s",chrInstallDir,logFile);
  remove(logNameLocal);
}

/* This function appends the text 'logText'
   to the file 'logFile' in the creator installation
   directory.
   */
void writeLog(char* logFile, char* logText)
{
  char logNameLocal[CCHMAXPATH];
  FILE *fHandle;

  sprintf(logNameLocal,"%s\\Logfiles\\%s",chrInstallDir,logFile);
  fHandle=fopen(logNameLocal,"a");
  if(fHandle) {
    fprintf(fHandle,logText);
    fclose(fHandle);
  }
}

void message()
{
  printf("This program is (C) Chris Wohlgemuth 2000\n");
  printf("See the file COPYING for the license.\n\n");
  printf("This program should only be called by the CD-Creater WPS classes.\n");
}


int main(int argc, char * argv[])
{
  int rc;
  HWND hwndNotify;
  char *text;
  CHAR szName[CCHMAXPATH];
  PVOID pvSharedMem;

  FILE *fStream;
  ULONG count;
  char *buf;
  char achBuf[CCHMAXPATH];
  BOOL bBus=FALSE;
  BOOL bFirst=TRUE;
  int bus,target,lun;
  char vendor[CCHMAXPATH];
  char type[CCHMAXPATH];
  int a;
  HAB hab;

  rc=-1;

  if(argc<4) {
    message();
    exit(-1);
  }  

  hwndNotify=atol(argv[1]);

  /* Save installdir */
  strcpy(chrInstallDir,argv[3]);

  /* Logfile entfernen */
  removeLog(LOGFILE_NAME);  

  sprintf(szName, "argc:%d\n",argc);
  writeLog(LOGFILE_NAME, szName);  
  printf(szName);
  for(a=0;a<argc;a++)
    {
      sprintf(szName, "%d: %s\n",a,argv[a]);
      writeLog(LOGFILE_NAME, szName);  
      printf(szName);
    }



  sprintf(szName,"%s -scanbus",argv[2]);
  printf("Command is: %s\n",szName);
  writeLog(LOGFILE_NAME, "\nCommand is: ");  
  writeLog(LOGFILE_NAME, szName);
  writeLog(LOGFILE_NAME, "\n\n");  


  /* Get the shared mem for communication */
  if(!DosGetNamedSharedMem(&pvSharedMem, SCANBUSSHAREDMEM_NAME, PAG_READ|PAG_WRITE))
    {
      text=pvSharedMem;
      /* start scanning */
      WinPostMsg(hwndNotify,WM_APPTERMINATENOTIFY,MPFROMLONG(ACKEY_LISTBOX),MPFROMLONG(0));
      writeLog(LOGFILE_NAME,"Drop down listbox cleared.\n");
      
      fStream=popen(szName,"r");
      if(fStream) {
        do {
          buf=fgets(achBuf,sizeof(achBuf),fStream);
          if(buf) {
            if(!strchr(achBuf,'*')) {
              if(bBus && !strstr(achBuf,"scsibus")) {
                writeLog(LOGFILE_NAME,"Found device entry: ");
                writeLog(LOGFILE_NAME, achBuf);
                count=sscanf(achBuf," %d,%d,%d %*[^']'%[^']' '%[^']",&bus,&target,&lun,&vendor,&type);
                if(count==5) {
                  sprintf(achBuf,"%d,%d,%d : %s %s",bus,target,lun,vendor,type);
                  strcpy(text,achBuf);
                  writeLog(LOGFILE_NAME,"Inserting following entry into listbox: ");
                  writeLog(LOGFILE_NAME,text);
                  writeLog(LOGFILE_NAME,"\n");
                  WinPostMsg(hwndNotify,WM_APPTERMINATENOTIFY,MPFROMLONG(ACKEY_LISTBOX),MPFROMP(text));
                  text=strchr(text,0);
                  if(bFirst) {
                    /* Put an entry into the entry field */
                    bFirst=FALSE;
                  }/* if(bFirst) */
                }/* if(count==5) */ 
              }/* if(bBus && !strstr(exeName,"scsibus")) */
              if(strstr(achBuf,"scsibus"))
                bBus=TRUE;
            }/* if(!strchr(exeName,'*')) */
          }
        }while(buf);
        fclose(fStream);
      }
      writeLog(LOGFILE_NAME,"Scanbus done. Ending program...\n");
      DosFreeMem(pvSharedMem);
    }/* DoaAllocSharedMem() */
  else
    {
      writeLog(LOGFILE_NAME,"Can't allocate shared mem!\n");
    }
  WinPostMsg(hwndNotify,WM_APPTERMINATENOTIFY,MPFROMLONG(ACKEY_SCANBUS),MPFROMLONG(0));
  return;
}










