/* ------------------------------------------------------------------- *
 *    This program is to erase all reference to customized CDRWSel     *
 *    fonts and colors. At next CDRWSel start, default font and        *
 *    colors are assumed                                               *
 * ------------------------------------------------------------------- *
 * Remy DODIN : V1.0 from 25/10/2003   - Ok with CDRWSel 2.12.3        *
 * ------------------------------------------------------------------- */      
/* [Load of Rexx functions] */
 
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* [Check where CDRWSel INI file is] */
 
Env = 'OS2ENVIRONMENT'

Sys_ini=Strip(value('user_ini',,Env))    /* Find user_ini in variables */
Lp=LastPos('\',Sys_ini)                  /* Extract path from          */ 
Sys_ini=substr(Sys_ini,1,Lp)             /* Sys_ini = path to CDRWSel  */
If Sys_ini='' then;                      /* Sys_ini = full path        */
 readini=path_pgm'CDRWSEL.INI'
              Else;
 readini=Sys_ini'CDRWSEL.INI'

/* [Remove keys added by user customization] */
   
result=SysIni(readini, "CDRWSEL", "Appl_V1", "DELETE:")
result=SysIni(readini, "CDRWSEL", "Appl_Txt", "DELETE:") 
result=SysIni(readini, "CDRWSEL", "Appl_Btm", "DELETE:") 

/* [exit part] */

say "CDRWSel.ini should be clean and default fonts / colors restored"
return 4                                 /* rc=4 => result not checked */ 
