/***********************************************************************\
 *                               XComp/2                               *
 *              Copyright (C) by Stangl Roman, 1999, 2001              *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * UExcp.cpp    Generic exception handler.                             *
 *                                                                     *
\***********************************************************************/

#pragma strings(readonly)

#include    <iostream.h>
#include    <iomanip.h>

#include    <UExcp.hpp>

            EXCP::EXCP(int iError, char *pcMsg, int iLine)
{
                                        /* Clear streambuffer, as writing the stream
                                           does not write a terminating \0 */
    memset(acError, '\0', sizeof(acError));
    pstreambufError=new streambuf((char *)acError, sizeof(acError));
    piostreamError=new iostream(pstreambufError);
    *piostreamError << pcMsg;
    this->iError=iError+EXCP_ERROR;
    this->iLine=iLine;
    delete pstreambufError;
}

            EXCP::~EXCP(void)
{
    delete piostreamError;
}

    EXCP&   EXCP::operator<<(char *pcMsg)
{
    *piostreamError << pcMsg;
    return(*this);
}

    EXCP&   EXCP::operator<<(int iMsg)
{
    *piostreamError << iMsg;
    return(*this);
}

    EXCP&   EXCP::print(void)
{
    if(iError>99)
        cout << "XCOMP" << iError << ": ";
    else if(iError>9)
        cout << "XCOMP0" << iError << ": ";
    else
        cout << "XCOMP00" << iError << ": ";
                                        /* Unfortunately I don't know how to let
                                           cout consume from the streambuffer directly */
    cout << acError;
    if(iLine!=0)
        cout << " at Line " << iLine;
    cout << "." << endl;
    return(*this);
}

    int     EXCP::getError(void)
{
    return(iError);
}

