/***********************************************************************\
 *                          Digital Camera/2                           *
 *              Copyright (C) by Stangl Roman, 1996, 2001              *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * UProfiling.cpp Generic profiling code using OS/2's interface to the *
 *              PC architecture hardware timer running at 1.19Mhz.     *
 *                                                                     *
\***********************************************************************/

#pragma strings(readonly)

#define     INCL_DOSPROFILE
#include    <os2.h>

#include    <stdio.h>
#include    <memory.h>

#include    "UProfiling.hpp"

/****************************************************************************************\
 * Class: UProfiling                                                                    *
\****************************************************************************************/

/*--------------------------------------------------------------------------------------*\
 * UProfiling : Constructor(s)                                                          *
\*--------------------------------------------------------------------------------------*/
UProfiling::UProfiling(void)
{
    ulTimeMicroSec=0;
    memset(&hrTimer, 0, sizeof(hrTimer));
    memset(acElapsedTime, '\0', sizeof(acElapsedTime));
}

/*--------------------------------------------------------------------------------------*\
 * UProfiling : Destructor                                                              *
\*--------------------------------------------------------------------------------------*/
UProfiling::~UProfiling(void)
{
}

/*--------------------------------------------------------------------------------------*\
 * UProfiling : start                                                                   *
 *              Start the profiling                                                     *
\*--------------------------------------------------------------------------------------*/
UProfiling             &UProfiling::start(void)
{
    ulTimeMicroSec=0;
    memset(&hrTimer, 0, sizeof(hrTimer));
                                        /* Get start time */
    DosTmrQueryTime(&hrTimer.qwTimerStart);
    return(*this);
}

/*--------------------------------------------------------------------------------------*\
 * UProfiling : stop                                                                    *
 *              Stop the profiling                                                      *
\*--------------------------------------------------------------------------------------*/
UProfiling             &UProfiling::stop(void)
{
    double  dTimeStart=0;
    double  dTimeStop=0;
                                        /* Timer ticks/second */
    ULONG   ulTimerFrequency=0;

                                        /* Get stop time */
    DosTmrQueryTime(&hrTimer.qwTimerStop);
                                        /* Get timer resolution */
    DosTmrQueryFreq(&ulTimerFrequency);
                                        /* Calculate elapsed time */
    dTimeStart=((double)hrTimer.qwTimerStart.ulHi)*(1<<32);
    dTimeStart+=(double)hrTimer.qwTimerStart.ulLo;
    dTimeStop=((double)hrTimer.qwTimerStop.ulHi)*(1<<32);
    dTimeStop+=(double)hrTimer.qwTimerStop.ulLo;
    ulTimeMicroSec=(ULONG)(((dTimeStop-dTimeStart)/(double)ulTimerFrequency)*1000000);
    return(*this);
}

/*--------------------------------------------------------------------------------------*\
 * UProfiling : printTime                                                               *
 *              Output the profiling result                                             *
\*--------------------------------------------------------------------------------------*/
UProfiling             &UProfiling::printTime(void)
{
    printf("UProfiling: Elapsed time %d us\n", ulTimeMicroSec);
    return(*this);
}

/*--------------------------------------------------------------------------------------*\
 * UProfiling : elapsedMicroSec                                                         *
 *              Return the elapsed time in microseconds                                 *
\*--------------------------------------------------------------------------------------*/
ULONG                   UProfiling::elapsedMicroSec(void)
{
    return(ulTimeMicroSec);
}

/*--------------------------------------------------------------------------------------*\
 * UProfiling : elapsedMilliSec                                                         *
 *              Return the elapsed time in milliseconds                                 *
\*--------------------------------------------------------------------------------------*/
ULONG                   UProfiling::elapsedMilliSec(void)
{
    return(ulTimeMicroSec/1000);
}

/*--------------------------------------------------------------------------------------*\
 * UProfiling : elapsed                                                                 *
 *              Return the elapsed time in microseconds as a string                     *
\*--------------------------------------------------------------------------------------*/
char                   *UProfiling::elapsed(void)
{
    sprintf(acElapsedTime, "%d s", ulTimeMicroSec);
    return(acElapsedTime);
}

