#ifndef _XCOMP_HPP_
#define _XCOMP_HPP_

/***********************************************************************\
 *                               XComp/2                               *
 *              Copyright (C) by Stangl Roman, 1999, 2001              *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * XComp.hpp    XComp/2 main header.                                   *
 *                                                                     *
\***********************************************************************/

#define     INCL_DOSFILEMGR
#define     INCL_DOSERRORS
#define     INCL_DOSMISC
#define     INCL_DOSPROCESS
#define     INCL_DOSSEMAPHORES
#define     INCL_DOSMODULEMGR
#include    <os2.h>

#include    <stream.h>
#include    <string.h>
#include    <memory.h>
#include    <time.h>
#include    <stdlib.h>
#include    <conio.h>

#include    <UExcp.hpp>
#include    <UProfiling.hpp>

                                        /* Message numbers */
#define     ERR_PIB                            0
#define     ERR_ARGUMENTS                      1
#define     ERR_SOURCEPATH                     2
#define     ERR_TARGETPATH                     3
#define     ERR_LOGFILEOPEN                    4
#define     ERR_DOSQUERYSOURCEPATH             5
#define     ERR_UNCSOURCEPATH                  6
#define     ERR_CURRENTDISK                    7
#define     ERR_SOURCEDRIVE                    8
#define     ERR_CURRENTDIR                     9
#define     ERR_CURRENTDIR1                    10
#define     ERR_CURRENTDIR2                    11
#define     ERR_UNCTARGETPATH                  12
#define     ERR_UNCTARGETPATH1                 13
#define     ERR_TARGETDRIVE                    14
#define     ERR_CURRENTDIR4                    15
#define     ERR_TARGETPATHINVALID              16
#define     MSG_DOSFINDFIRSTSOURCE      "XCOMP017"
#define     ERR_DOSFINDFIRSTSOURCE             17
#define     MSG_DOSFINDNEXTSOURCE       "XCOMP018"
#define     ERR_DOSFINDNEXTSOURCE              18
#define     ERR_DOSFINDCLOSESOURCE             19
#define     MSG_DOSFINDFIRSTDIR         "XCOMP020"
#define     ERR_DOSFINDFIRSTDIR                20
#define     ERR_DOSFINDMEXTSOURCE              21
#define     MSG_DOSFINDNEXTDIR          "XCOMP022"
#define     ERR_DOSFINDNEXTDIR                 22
#define     ERR_DOSFINDCLOSETARGET             23
#define     MSG_DOSOPENSOURCE           "XCOMP024"
#define     MSG_DOSOPENTARGET           "XCOMP025"
#define     ERR_DOSFILEPTRSOURCE               26
#define     ERR_DOSFILEPTRTARGET               27
#define     MSG_INTERNALERROR           "XCOMP028"
#define     MSG_READSOURCE              "XCOMP029"
#define     MSG_READTARGET              "XCOMP030"
#define     MSG_RETRYCOUNT              "XCOMP031"
#define     MSG_COMPARESTATS            "XCOMP032"
#define     MSG_RETRYEXCEEDED           "XCOMP033"
#define     MSG_DIFFERENCE              "XCOMP034"
#define     MSG_DOSCLOSESOURCE          "XCOMP035"
#define     MSG_DOSCLOSETARGET          "XCOMP036"

#define     MSG_THROUGHPUT              "XCOMP001"
#define     MSG_PROBLEMOPEN             "XCOMP002"
#define     MSG_PROBLEMCOMPARE          "XCOMP003"
#define     MSG_PROBLEMFINDFILES        "XCOMP005"
#define     MSG_PROBLEMFINDDIRS         "XCOMP005"
#define     MSG_COMPARETOTAL            "XCOMP006"

#define     XCOMPDATASIZE               (1<<18)
#define     RETRY_COUNT                 3

                                        /* Verbose flags */
#define     XCOMP_STATUS_VERBOSE        0x00000001
#define     XCOMP_STATUS_VERBOSE2       0x00000002
#define     XCOMP_STATUS_LINENUMBER     0x00000004
                                        /* Multithreaded flag */
#define     XCOMP_STATUS_MP             0x00000010
                                        /* Logfile flag */
#define     XCOMP_STATUS_LOG            0x00000020
                                        /* No pause flag (for miscompares and
                                           file not found errors) */
#define     XCOMP_STATUS_NOPAUSEERRCOMP 0x00000100
#define     XCOMP_STATUS_NOPAUSEERRFIND 0x00000200
                                        /* Use small buffer flag */
#define     XCOMP_STATUS_SMALLBUFFER    0x00001000
                                        /* XComp/2 shutdown status flag */
#define     XCOMP_STATUS_SHUTDOWN       0x10000000

class       XCOMP
{
friend void    _Optlink xcompThread(XCOMP *pXCOMP);
public:
            XCOMP(int argc, char *argv[]);
           ~XCOMP(void);
    void    process(void);
    void    usage(void);
    int     getProblemFindFilesCount();
    int     getProblemFindDirsCount();
    int     getProblemOpenCount();
    int     getProblemCompareCount();
private:
    void    verifySourcePath(void);
    void    verifyTargetPath(void);
    void    searchFiles(char *pcSourcePath, char *pcSourceFiles, char *pcTargetPath);
    int     compareFiles(char *pcSourcePath, char *pcSourceFile, char *pcTargetPath);
    APIRET  readSourceFile(void);
    APIRET  readTargetFile(void);
    void    processThread(void);

                                        /* File definitions */
    char    acExecutableFile[CCHMAXPATH];
    char    acLogFile[CCHMAXPATH];
    int     iCompareBufferSize;
    char    acSourcePath[CCHMAXPATH];
    int     iSourcePathRootLen;
    char    acSourceFiles[CCHMAXPATH];
    char    acTargetPath[CCHMAXPATH];
    int     iTargetPathRootLen;
    HFILE   hfileSourceFile;
    HFILE   hfileTargetFile;
    ofstream
            ofstreamLogFile;
    ULONG   ulBytesReadSourceFile;
    ULONG   ulBytesReadTargetFile;
                                        /* Buffers */
    BYTE   *pbSourceData;
    BYTE   *pbTargetData;
                                        /* Problem counters */
    int     iCountProblemNone;
    int     iCountProblemFindFiles;     /* Find files in a directory access errors */
    int     iCountProblemFindDirs;      /* Find directories in a directory access errors */
    int     iCountProblemOpen;          /* File open errors */
    int     iCountProblemCompare;       /* File miscompare errors */
                                        /* Throughput calculations */
    int     iSourceTotalRead;
    int     iTargetTotalRead;
    int     iSourceTotalMS;
    int     iTargetTotalMS;
    int     iTotalMS;
    UProfiling
           *puProfilingSource;
    UProfiling
           *puProfilingTarget;
    UProfiling
           *puProfilingTotal;
                                        /* Return codes */
    APIRET  apiretRcSource;
    APIRET  apiretRcTarget;
                                        /* Semaphore */
    HMTX    hmtxThread1;
    HMTX    hmtxThread2;
    HMTX    hmtxThread3;
                                        /* XCOMP_STATUS_* flags */
    int     iStatusFlag;
};

extern "C"
{
    void    _Optlink xcompThread(XCOMP *pXCOMP);
}

#endif  /* _COMP_HPP_ */
