/* REXX: Register */

  Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
  Call SysLoadFuncs;

curdir=directory()
newdir=directory("install")
l=length(newdir)
if (newdir = curdir) | (l<7) | (substr(newdir,l-6,7) <> "install") then 
do
  say ""
  say "************************************************"
  say "Can't chdir to 'install' directory..."
  say "Please rerun 'install.cmd' from root of package!"
  say "************************************************"
  '@pause'
  exit 1
end

'@check_FOURCC.exe -c'
if (rc = 1)
then
do
  say ""
  say "*****************************************************"
  say "It's seems that you system lack the required library."
  say "If it's a case (consult messages above) and required "
  say "library is libc061.dll, you can get it from "
  say "netlabs.org, at location (latest at the moment):"
  say ""
  say "ftp://ftp.netlabs.org/pub/libc/libc-0_6_3-csd3.exe"
  say ""
  say "*****************************************************"
  say ""
  say "Install should fail without them..."
  say "Continue anyway? (y/N)"
  parse pull answer
  IF \( (answer="y") | (answer="Y") | (answer="yes") | (answer="Yes") | (answer="YES") )
  then
  do
     say "exiting..."
     exit 1
  end
  say 'proceed...'
end

'@minstall'
say 'minstall return code:'rc
'@check_FOURCC.exe -c'
if rc <> 0 
then
do
  say "    ******************************************"
  say "    Warning: IOProc installation seems failed!"
  say "Trying to fix..."
  '@check_FOURCC.exe -i'
  if rc = 0 
  then
     say "    ... ok!"
  else
     say "    ... failed!"
end

'@listobj MMAPE MMMAC MMAPL'
if rc <> 0
then
do
  say "    *********************************************"
  say "    No one of Monkey's extensions is associated!"
  say "    Either you use new CLI minstall.exe, or some "
  say "    other thing is wrong..."
  say ""

  say "Do you want to install the .APE association (y/N)?"
  pull answer
  iF (answer="y") | (answer="Y") | (answer="yes") | (answer="Yes") | (answer="YES") 
  then 
  do
      rc=SysRegisterObjectClass('MMAPE','mmioAPE');
      if rc <> 1
      then 
  	say "MMAPE: could not register, rc="rc ".";
      else
        say "MMAPE: installed ok!";
  end
  else
      say "skipped..."

  say "Do you want to install the .MAC association (y/N)?"
  pull answer
  iF (answer="y") | (answer="Y") | (answer="yes") | (answer="Yes") | (answer="YES") 
  then 
  do
      rc=SysRegisterObjectClass('MMMAC','mmioAPE');
      if rc <> 1
      then 
  	say "MMMAC: could not register, rc="rc ".";
      else
        say "MMMAC: installed ok!";
  end
  else
      say "skipped..."

  say "Do you want to install the .APL association (y/N)?"
  pull answer
  iF (answer="y") | (answer="Y") | (answer="yes") | (answer="Yes") | (answer="YES") 
  then 
  do
      rc=SysRegisterObjectClass('MMAPL','mmioAPE');
      if rc <> 1
      then 
  	say "MMAPL: could not register, rc="rc ".";
      else
        say "MMAPL: installed ok!";
  end
  else
      say "skipped..."

end

Say "Restart system for any changes to take effect"

'@pause'
