/* Installation von Nota Musica Sequencer */

/* Funktionen laden */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Copyright ausgeben */
say "Nota Musica Sequencer Installation"
say "Installation von Nota Musica Sequencer"
say "(c) Copyright 19997 by Johannes Martin Software-Entwicklung"
say ""

/* Sprache erfragen */
say "Language/Sprache (E)nglish/(D)eutsch [E]:"
pull sprache

/* Verzeichnis erfragen */
verzeichnis = "c:\notaseq"

if sprache = "D" then
  say "Installationsverzeichnis ["verzeichnis"]:"
else
  say "Installation directory ["verzeichnis"]:"
pull eingabe
if length(eingabe) = 0 then  nop
else verzeichnis = eingabe

/* Verzeichnis anlegen und Dateien entpacken */
if sprache = "D" then
  say "Dateien werden ausgepackt!"
else
  say "Files are being decompressed!"
md verzeichnis
par = notaseq.zip '-d' verzeichnis
unzip.exe par

/* Ini Schreiben */
if sprache = "D" then
  par = '-d'verzeichnis'\notaseq.ini "-aResource Library" -kDateiName -snmsresde'
else
  par = '-d'verzeichnis'\notaseq.ini "-aResource Library" -kDateiName -snmsresuk'
writeini.exe par
par = '-d'verzeichnis'\notaseq.ini -aVerzeichisse -kMIDI -s'verzeichnis
writeini.exe par
par = '-d'verzeichnis'\notaseq.ini -aVerzeichisse -kWAV -s'verzeichnis
writeini.exe par

/* Gruppe anlegen */
if sprache = "D" then
  say "Objekte werden angelegt."
else
  say "Creating objects."
folderid = '<NOTA_MUSICA_FOLDER>'

if \SysCreateObject('WPFolder', 'Nota Musica', '<WP_DESKTOP>', ,
                    'ICONFILE='verzeichnis'\NOTA.ICO;OBJECTID='||folderid, 'update') then do
  if sprache = "D" then
    say 'Kann Nota Musica Ordner nicht erzeugen.'
  else
    say "Cannot create Nota Musica folder."
  exit 1
end

if \SysCreateObject('WPProgram', 'Nota Musica Sequencer', folderid, ,
                    'PROGTYPE=PM;EXENAME='verzeichnis'\NOTASEQ.EXE;ASSOCFILTER=*.mid;STARTUPDIR='verzeichnis, ,
                    'update') then do
  if sprache = "D" then
    say 'Kann Nota Musica Sequencer Programmobjekt nicht erzeugen.'
  else
    say "Cannot create Nota Musica Sequencer program object."
  exit 1
end

if \SysCreateObject('WPUrl', 'Nota Musica Homepage', folderid, ,
                    'LOCATOR=http://www.teamos2.de/software/notamusica', ,
                    'update') then do
  if sprache = "D" then
    say 'Kann Nota Musica Homepage nicht erzeugen.'
  else
    say "Cannot create Nota Musica home page."
end

if sprache = "D" then
  do
    if \SysCreateObject('WPProgram', 'Nota Musica Sequencer Handbuch', folderid, ,
                       'PROGTYPE=PM;EXENAME=VIEW.EXE;STARTUPDIR='verzeichnis';PARAMETERS=handbuch.inf', ,
                       'update') then do
      say 'Kann Nota Muscia Sequencer Handbuch nicht erzeugen.'
      exit 1
    end
  end
else
  if \SysCreateObject('WPProgram', 'Nota Musica Sequencer Manual', folderid, ,
                      'PROGTYPE=PM;EXENAME=VIEW.EXE;STARTUPDIR='verzeichnis';PARAMETERS=manual.inf', ,
                      'update') then do
    say 'Cannot create Nota Musica Sequencer Manual'
    exit 1
  end


if sprache = "D" then
  say 'Nota Musica Sequencer erfolgreich installiert!'
else
  say "Nota Nusica Sequencer installed sucessfully!"
