<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
	Log
-->

<xsl:template match="ui/log">
  <xsl:apply-templates select="debug"/>

  <div class="part-title"><xsl:value-of select="$lang/labels/filter"/></div>
  <xsl:apply-templates select="log-events"/>

  <div class="part-title"><xsl:value-of select="$lang/labels/records"/></div>
  <div class="part-content">
    <span class="control-title">
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/refresh"/>
        <xsl:with-param name="hint" select="$lang/buttons/refresh/@hint"/>
        <xsl:with-param name="link">/ui/log</xsl:with-param>
      </xsl:call-template>
    </span>
  </div>

  <xsl:call-template name="page-list">
    <xsl:with-param name="selected"><xsl:value-of select="@page"/></xsl:with-param>
    <xsl:with-param name="total"><xsl:value-of select="@pages"/></xsl:with-param>
    <xsl:with-param name="get-arg">mask=<xsl:value-of select="@mask"/></xsl:with-param>
  </xsl:call-template>

  <table cellpadding="0" cellspacing="0" border="0" class="obj-list">
    <xsl:apply-templates select="record"/>
  </table>
</xsl:template>

<xsl:template match="ui/log/debug">
  <div>
    Allocated memory space: <xsl:value-of select="memused"/> bytes.
    Sockets pool threads: <xsl:value-of select="sockpool-idle-threads"/>
    (idle: <xsl:value-of select="sockpool-idle-threads"/>).
  </div>
</xsl:template>

<xsl:template match="ui/log/record">
  <tr>
    <td class="btn" style="padding-bottom: 0.3em; width: 2em; color: #02163E;">
      <xsl:value-of select="@n"/>.
    </td>
    <td>
      <xsl:call-template name="time-format">
        <xsl:with-param name="time" select="@time"/>
      </xsl:call-template>
    </td>
    <td style="color: #02163E;">
      <xsl:if test="@module">
        <xsl:value-of select="@module"/>
      </xsl:if>
    </td>
    <td>
      <xsl:value-of select="."/>
    </td>
  </tr>
</xsl:template>

</xsl:stylesheet>
