/************************************************************************/
/***                                                                  ***/
/*** NAME              : DATT.h                                       ***/
/***                                                                  ***/
/*** PART OF           : C-Scout                                      ***/
/***                                                                  ***/
/*** SHORT DESCRIPTION : Include file for C-Scout toolkit             ***/
/***                                                                  ***/
/*** AUTHOR            : RH                                           ***/
/***                                                                  ***/
/*** COPYRIGHT         : (C) 1995 apriori computer solutions GmbH     ***/
/***                                                                  ***/
/************************************************************************/
#ifndef DATT_H
#define DATT_H

/*----------------------------------------------*/
/*  include files required for errno, _doserrno */
/*----------------------------------------------*/
#include <stdlib.h>
#include <string.h>

/*----------------------------------------*/
/*  default trace level for the TX macro  */
/*----------------------------------------*/
#ifndef DATT_TM_LEVEL
  #define DATT_TM_LEVEL 0
#endif

/*---------------------------------------------------*/
/*  default trace level for the FncEntry/Exit macros */
/*---------------------------------------------------*/
#ifndef DATT_BASE_LEVEL
  #define DATT_BASE_LEVEL 1000
#endif

#define DATT_INT_TL        DATT_BASE_LEVEL
#define DATT_INT_TL_ENTRY  DATT_INT_TL
#define DATT_INT_TL_EXIT   DATT_INT_TL

/*----------------------------------------------------------------------*/
/* macros                                                               */
/*----------------------------------------------------------------------*/

#if ( !defined __IBMC__ && !defined __IBMCPP__ )
#define __FUNCTION__  "N/A"
#endif

#ifdef DATT_OFF
   #define TX( exp )      exp
   #define FncEntry()
   #define FncExit(rc)    return (rc)
   #define FncExitVoid()  return

#else
/*------------------------*/
/*  FncEntry/Exit macros  */
/*------------------------*/
   #define FncEntry() \
           Tracef( DATT_INT_TL_ENTRY, "%s(%d), FNC ENTRY : %s", \
                     __FILE__, __LINE__, __FUNCTION__ )

   #define FncExit(rc) \
           Tracef( DATT_INT_TL_EXIT,  "%s(%d), FNC EXIT  : %s - RC : rc %ld", \
                   __FILE__, __LINE__, __FUNCTION__ , rc); \
           return (rc)

   #define FncExitVoid() \
           Tracef( DATT_INT_TL_EXIT,  "%s(%d), FNC EXIT  : %s", \
                  __FILE__, __LINE__, __FUNCTION__ ); \
           return

/*------------------------*/
/*  TX macro              */
/*------------------------*/
   #define TX( exp ) \
   { \
      ULONG    ulOrd = 0;   \
      APIRET   _apirc_ = 0;   \
      ulOrd = DATT_Ser ( __FUNCTION__, __FILE__, __LINE__, DATT_TM_LEVEL ); \
      _apirc_ = (APIRET)(exp); \
      if (_apirc_) { \
         DATT_Check( ulOrd, __FUNCTION__, __FILE__, __LINE__, DATT_TM_LEVEL, \
                     #exp, _apirc_, errno, strerror(errno), _doserrno ); \
         errno = 0; _doserrno = 0; } \
      else  \
         DATT_Check( ulOrd, __FUNCTION__, __FILE__, __LINE__, DATT_TM_LEVEL, \
                     #exp, _apirc_, 0, NULL, 0 ); \
   }
#endif

/*----------------------------------------------------------------------*/
/* typedefs                                                             */
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* TX - test expression macro information.                              */
/* The structure below describes the TX macro Information package       */
/* which will be given to a registered critical error handler if the    */
/* TX macro expression is TRUE.                                         */
/*----------------------------------------------------------------------*/

/*----------------------------*/
/* defines for the structure  */
/*----------------------------*/
#define  FN_SIZE 121                /* max size of function name */
#define  SL_SIZE 256                /* max size of source line   */
#define  EM_SIZE 128                /* max size of error message */

typedef struct __TXmacroInfo
    {
    UCHAR      szFunction[FN_SIZE];       /* function name                    */
    UCHAR      szModuleName[CCHMAXPATH];  /* name of module                   */
    ULONG      ulLineNo;                  /* current line number              */
    UCHAR      szSourceLine[SL_SIZE];     /* current source line              */
    APIRET     apiretRc;                  /* result of expression in TX macro */
    INT        iErrNo;                    /* c runtime errno                  */
    INT        iDosErrNo;                 /* c runtime dos error code         */
    UCHAR      szErrBuff1 [EM_SIZE];      /* PM return code text              */
    UCHAR      szErrBuff2 [EM_SIZE];      /* Kernel return code text          */
    UCHAR      szErrBuff3 [EM_SIZE];      /* CRT return code text             */
    TID        tid;                       /* TID                              */
    PID        pid;                       /* PID                              */
    }    _TXmacroInfo;

typedef _TXmacroInfo * PTXMI;

/*--------------------------------------------------*/
/* typydef for the critical error handler routine   */
/*--------------------------------------------------*/
typedef BOOL   APIENTRY FNCONHANDLER( PTXMI  ptxBuffer );
typedef FNCONHANDLER * PFNCH;

/*----------------------------------------------------------------------*/
/* declarations                                                         */
/*----------------------------------------------------------------------*/
VOID APIENTRY HexTrace( const  ULONG  ulLevel,
                        const  PVOID  pvData,
                        const  ULONG  ulDataLen );

VOID APIENTRY Tracef( const  ULONG  ulLevel,
                      const  PSZ    pszFormat,
                      ...);

VOID APIENTRY SetErrorInfo ( const PFNCH  pfnConditionHandler );

/*----------------------------------------------------------------------*/
/* Functions called by the macros                                       */
/*----------------------------------------------------------------------*/
ULONG APIENTRY DATT_Ser ( const PSZ    pszFunction,
                          const PSZ    pszFile,
                          const ULONG  ulLine,
                          const ULONG  ulLevel );

APIRET APIENTRY DATT_Check ( const   ULONG   ulOrdinal,
                             const   PSZ     pszFunction,
                             const   PSZ     pszFile,
                             const   ULONG   ulLine,
                             const   ULONG   ulLevel,
                             const   PSZ     pszSourceLine,
                             const   APIRET  apiretRc,
                             const   int     iErrNo,
                             const   PSZ     pszErrInfo,
                             const   int     iDosErrNo );

#endif

/************************************************************************/
/*** EOF DATT.h                                                       ***/
/************************************************************************/
