.*----------------------------------------------------------------------------*
.*       Converted by HTML2IPF from guide.html at 28 Aug 1997, 11:58pm        *
.*----------------------------------------------------------------------------*
:userdoc.
:docprof toc=12345.
:title.LCLint User's Guide
.* Source filename: guide.html
:h1 res=1.LCLint User's Guide
:font facename=default size=0x0.
:p.

.br
:font facename='Helv' size=32x20.
.br
:lines align=center.
LCLint User's Guide
.br
:elines.
:font facename=default size=0x0.
.br
.br
:p.
.br
:font facename='Helv' size=20x12.
.br
:lines align=center.
Version 2&per.3
.br
August 1997
.br
:elines.
:font facename=default size=0x0.
.br
.br
:p.
.br
:font facename='Tms Rmn' size=16x8.
.br
:lines align=center.:link reftype=hd res=2.David Evans:elink.
.br
:link reftype=hd res=3.Systematic Program Development Group:elink.
.br
:link reftype=hd res=4.MIT Laboratory for Computer Science:elink.
.br
Converted from guide&per.html using HTML2IIPF by Herbert at 28 Aug 1997, 01&colon.10am
.br
:elines.
:font facename=default size=0x0.
.br
.br
:p.

LCLint is a tool for statically checking C programs&per.  With minimal effort,
LCLint can be used as a better lint&per.:link reftype=hd res=5.[1]:elink.  If
additional effort is invested adding annotations to programs, LCLint can
perform stronger checks than can be done by any standard lint&per.
:p.
:p.
Some problems detected by LCLint include&colon.
:p.
:ul compact.
:li.Violations of information hiding&per.  A user-defined type can be declared
as :hp1.abstract:ehp1., and a message is reported where code inappropriately
depends on the representation of the type&per.  (:link reftype=hd res=6.Section 3:elink.) 
:p.
:li.Inconsistent modification of caller-visible state&per.  Functions can be
annotated with information on what caller-visible state may be modified by the
function, and an error is reported if the modifications produced by the
function contradict its declaration&per.  (:link reftype=hd res=7.Section 4&per.1:elink.)
:p.
:li.Inconsistent use of global variables&per.  Information on what global and
file scope variables a function may use can be added to function declarations,
and a message is reported if the implementation of the function uses other
global variables or does not uses every global variable listed in its
declaration&per.  (:link reftype=hd res=7.Section 4&per.2:elink.)
:p.
:li.Memory management errors&per.  Instances where storage that has been
deallocated is used, or where storage is not deallocated (memory leaks)&per.
(:link reftype=hd res=8.Section 5:elink.)
:p.
:li.Dangerous data sharing or unexpected aliasing&per.  Parameters to a function
share storage in a way that may lead to undefined or undesired behavior, or a
reference to storage within the representation of an abstract type is created&per.
(:link reftype=hd res=9.Section 6:elink.)
:p.
:li.Using possibly undefined storage or returning storage that is not
completely defined (except as documented)&per.  (:link reftype=hd res=10.Section 7&per.1:elink.)
:p.
:li.Dereferencing a possibly null pointer&per.  (:link reftype=hd res=10.Section 7&per.2:elink.)
:p.
:li.Dangerous macro implementations or invocations&per. (:link reftype=hd res=11.Section 8:elink.)
:p.
:li.Violations of customizable naming conventions&per. (:link reftype=hd res=12.Section 9:elink.)
:p.
:li.Program behavior that is undefined because it depends on order of
evaluation, likely infinite loops, fall-through cases, incomplete logic,
statements with no effect, ignored return values, unused declarations, and
exceeding certain standard limits&per.  (:link reftype=hd res=13.Section 10:elink.)
:p.
:eul.

:p.
LCLint checking can be customized to select what classes of errors are reported
using command line flags and stylized comments in the code&per.
:p.
:p.
This document is a guide to using LCLint&per.  :link reftype=hd res=14.Section 1:elink. is a brief overview of the
design goals of LCLint&per. :link reftype=hd res=15.Section 2:elink. explains how to run LCLint, interpret
messages produce, and control checking&per. Sections 3-10 describe particular
checks done by LCLint&per.

.br
:font facename='Helv' size=32x20.
.br

Contents
.br

:font facename=default size=0x0.
.br
.br
:p.
:ol compact.
:li.:link reftype=hd res=14.Overview:elink.
:li.:link reftype=hd res=15.Operation:elink.
:ul compact.
:li.:link reftype=hd res=15.Messages:elink.
:li.:link reftype=hd res=15.Flags:elink.
:li.:link reftype=hd res=15.Stylized Comments:elink.
:ul compact.
:li.:link reftype=hd res=15.Annotations:elink.
:li.:link reftype=hd res=15.Control Comments:elink.
:eul.
:eul.

:li.:link reftype=hd res=6.Abstract Types:elink.
:ul compact.
:li.:link reftype=hd res=6.Access:elink.
:li.:link reftype=hd res=6.Mutability:elink.
:li.:link reftype=hd res=6.Boulean Types:elink.
:li.:link reftype=hd res=6.Primitive C Types:elink.
:ul compact.
:li.:link reftype=hd res=6.Characters:elink.
:li.:link reftype=hd res=6.Enumerators:elink.
:li.:link reftype=hd res=6.Numeric Types:elink.
:li.:link reftype=hd res=6.Arbitrary Integral Types:elink.
:eul.
:eul.

:li.:link reftype=hd res=7.Function Interfaces:elink.
:ul compact.
:li.:link reftype=hd res=7.Modifications:elink.
:ul compact.
:li.:link reftype=hd res=7.Special Modifications:elink.
:li.:link reftype=hd res=7.Missing Modifies Clauses:elink.
:li.:link reftype=hd res=7.Limitations:elink.
:eul.

:li.:link reftype=hd res=7.Global Variables:elink.
:ul compact.
:li.:link reftype=hd res=7.Controlling Globals Checking:elink.
:eul.

:li.:link reftype=hd res=7.Declaration Consistency:elink.
:eul.

:li.:link reftype=hd res=8.Memory Management:elink.
:ul compact.
:li.:link reftype=hd res=8.Storage Model:elink.
:li.:link reftype=hd res=8.Deallocation Errors:elink.
:ul compact.
:li.:link reftype=hd res=8.Unshared References:elink.
:li.:link reftype=hd res=8.Temporary Parameters:elink.
:li.:link reftype=hd res=8.Owned and Dependent References:elink.
:li.:link reftype=hd res=8.Kept Parameters:elink.
:li.:link reftype=hd res=8.
:li.:elink.:link reftype=hd res=8.Stack References:elink.
:li.:link reftype=hd res=8.Inner Storage:elink.
:eul.

:li.:link reftype=hd res=8.Implicit Memory Annotations:elink.
:li.:link reftype=hd res=8.Reference Counting:elink.
:eul.

:li.:link reftype=hd res=9.Sharing:elink.
:ul compact.
:li.:link reftype=hd res=9.Aliasing:elink.
:ul compact.
:li.:link reftype=hd res=9.Unique Parameters:elink.
:li.:link reftype=hd res=9.Returned Parameters:elink.
:eul.

:li.:link reftype=hd res=9.Exposure:elink.
:ul compact.
:li.:link reftype=hd res=9.Read-Only Storage:elink.
:li.:link reftype=hd res=9.Exposed Storage:elink.
:eul.
:eul.

:li.:link reftype=hd res=10.Value Constraints:elink.
:ul compact.
:li.:link reftype=hd res=10.Use Before Definition:elink.
:ul compact.
:li.:link reftype=hd res=10.Undefined Parameters:elink.
:li.:link reftype=hd res=10.Relaxing Checking:elink.
:li.:link reftype=hd res=10.Partially Defined Structures:elink.
:li.:link reftype=hd res=10.Global Variables:elink.
:eul.

:li.:link reftype=hd res=10.Null Pointers:elink.
:ul compact.
:li.:link reftype=hd res=10.Predicate Functions:elink.
:li.:link reftype=hd res=10.Overriding Null Types:elink.
:li.:link reftype=hd res=10.Relaxing Null Checking:elink.
:eul.

:li.:link reftype=hd res=10.Execution:elink.
:li.:link reftype=hd res=10.Special Clauses:elink.
:eul.

:li.:link reftype=hd res=11.Macros:elink.
:ul compact.
:li.:link reftype=hd res=11.Constant Macros:elink.
:li.:link reftype=hd res=11.Function-like Macros:elink.
:ul compact.
:li.:link reftype=hd res=11.Side-Effect Free Parameters:elink.
:li.:link reftype=hd res=11.Polymorphism:elink.
:eul.

:li.:link reftype=hd res=11.Controlling Macro Checking:elink.
:li.:link reftype=hd res=11.Iterators:elink.
:eul.

:li.:link reftype=hd res=12.Naming Conventions:elink.
:ul compact.
:li.:link reftype=hd res=12.Type-Based Naming Conventions:elink.
:ul compact.
:li.:link reftype=hd res=12.Czech Names:elink.
:li.:link reftype=hd res=12.Slovak Names:elink.
:li.:link reftype=hd res=12.Czechoslovak Names:elink.
:eul.

:li.:link reftype=hd res=12.Namespace Prefixes:elink.
:li.:link reftype=hd res=12.Naming Restrictions:elink.
:ul compact.
:li.:link reftype=hd res=12.Reserved Names:elink.
:li.:link reftype=hd res=12.Distinct Identifiers:elink.
:eul.
:eul.

:li.:link reftype=hd res=13.Other Checks:elink.
:ul compact.
:li.:link reftype=hd res=13.Undefined Evaluation Order:elink.
:li.:link reftype=hd res=13.Problematic Control Structures:elink.
:ul compact.
:li.:link reftype=hd res=13.Likely Infinite Loops:elink.
:li.:link reftype=hd res=13.Switches:elink.
:li.:link reftype=hd res=13.Deep Breaks:elink.
:li.:link reftype=hd res=13.Loop and If Bodies:elink.
:li.:link reftype=hd res=13.Complete if-else Logic:elink.
:eul.

:li.:link reftype=hd res=13.Suspicious Statements:elink.
:ul compact.
:li.:link reftype=hd res=13.Statements with No Effects:elink.
:li.:link reftype=hd res=13.Ignored Return Values:elink.
:eul.

:li.:link reftype=hd res=13.Unused Declarations:elink.
:li.:link reftype=hd res=13.Complete Programs:elink.
:ul compact.
:li.:link reftype=hd res=13.Unnecessary External Names:elink.
:li.:link reftype=hd res=13.Declarations Missing from Headers:elink.
:eul.

:li.:link reftype=hd res=13.Compiler Limits:elink.
:ul compact.
:ul compact.
:ul compact.
:eul.
:eul.
:eul.
:eul.
:eol.


.br
:font facename='Tms Rmn' size=18x10.
.br
Appendices
:font facename=default size=0x0.
.br
.br
:p.
:link reftype=hd res=16.Appendix A&per.  Availability:elink.
.br
:link reftype=hd res=17.Appendix B&per.  Communication:elink.
.br
:link reftype=hd res=18.Appendix C&per.  Flags:elink.
.br
:link reftype=hd res=19.Appendix D&per.  Annotations:elink.
.br
:link reftype=hd res=20.Appendix E&per.  Control Comments:elink.
.br
:link reftype=hd res=21.Appendix F&per.  Libraries:elink.
.br
:link reftype=hd res=22.Appendix G&per.  Specifications:elink.
.br
:link reftype=hd res=23.Appendix H&per.  Emacs:elink.
.br

:p.
.br
:font facename='Helv' size=20x12.
.br
:link reftype=hd res=24.Figures:elink.
.br
:font facename=default size=0x0.
.br
.br
:p.
:link reftype=hd res=25.References:elink.
.br
:link reftype=hd res=26.Acknowledgements:elink.
.br
:p.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=14.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=14.:eartlink.:link reftype=hd res=14.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: sec1.html
:h2 res=14.LCLint User's Guide - 1&per. Overview
:font facename=default size=0x0.
:p.


.br
:font facename='Helv' size=32x20.
.br
1&per. Overview
:font facename=default size=0x0.
.br
.br
The main goals for LCLint are to&colon.
:p.
:ul compact.
:li.Detect a large number of bugs in typical C programs, without producing
an unacceptable number of spurious messages&per.  We are willing to accept the
possibility that a few spurious messages are produced as long as it enables
significantly more powerful checking and the spurious messages can be
suppressed easily&per.
:p.
:li.Support a programming methodology involving abstract types and clean,
documented interfaces in standard C programs&per.
:p.
:li.Provide a gradual transition for programmers&per.  LCLint can be used like a
better standard lint with minimal effort&per.  Adding a few annotations to programs
enables significantly better checking&per.  As more effort is put into annotating
programs, better checking results&per. A representational effort/benefit curve for
using LCLint is shown in Figure 1 (not available in HTML format)&per.  As
different checks are turned on and more information is given in code
annotations the number of bugs that can be detected increases dramatically&per. 
:p.
:li.Provide enough flexibility so that LCLint can be used effectively with a
wide range of coding styles&per.  Especially important is making it easy to use
LCLint effectively to maintain and modify legacy code&per.
:p.
:li.Check programs quickly and with no user interaction&per.  LCLint
runs faster than most compilers&per.  Libraries can be used to enable fast
checking of a few modules in a large program&per.
:eul.

:p.

LCLint does many of the traditional lint checks including unused declarations,
type inconsistencies, use-before-definition, unreachable code, ignored return
values, execution paths with no return, likely infinite loops, and fall-through
cases&per.  This document focuses on more powerful checks that are made
possible by additional information given in source code annotations&per. [2]  Annotations are stylized comments that
document certain assumptions about functions, variables, parameters, and types&per.
They may be used to indicate where the representation of a user-defined type is
hidden, to limit where a global variable may be used or modified, to constrain
what a function implementation may do to its parameters, and to express checked
assumptions about variables, types, structure fields, function parameters, and
function results&per.  In addition to the checks specifically enabled by
annotations, many of the traditional lint checks are improved by exploiting
this additional information&per.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=15.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=15.:eartlink.:link reftype=hd res=15.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.

.* Source filename: sec2.html
:h2 res=15.LCLint User's Guide - 2&per. Operation
:font facename=default size=0x0.
:p.

.br
:font facename='Helv' size=32x20.
.br

2&per. Operation
:font facename=default size=0x0.
.br
.br
LCLint is invoked by listing files to be checked&per.  Initialization files,
command line flags, and stylized comments may be used to customize checking
globally and locally&per.
:p.
:p.
The best way to learn to use LCLint, of course, is to actually use it (if you
don't already have LCLint installed on your system, download it)&per.  Before you
read much further in this document, I recommend finding a small C program&per.
Then, try running&colon.
:p.
:font facename='System VIO' size=14x8.lclint *&per.c:font facename=default size=0x0.
:p.
For the most C programs, this will produce a large number of messages&per.  To turn
off reporting for some of the messages, try&colon.
:p.
:font facename='System VIO' size=14x8.lclint -weak *&per.c:font facename=default size=0x0.
:p.
The :link reftype=hd res=18.:font facename='System VIO' size=14x8.-weak:font facename=default size=0x0.:elink. flag is a mode
flag that sets many checking parameters to select weaker checking than
is done in the default mode&per.  Other LCLint flags will be introduced in the following sections;  a complete list is given in :link reftype=hd res=18.Appendix C:elink.&per.
.br
:font facename='Helv' size=20x12.
.br
2&per.1 Messages
:font facename=default size=0x0.
.br
.br
The format and content of messages printed by LCLint can be customized by the
user&per. A typical message is&colon.
:p.
:p.
:cgraphic.
sample&per.c&colon. (in function faucet)
sample&per.c&colon.11,12&colon. Fresh storage x not released before return
  A memory leak has been detected&per.  Newly-allocated or only-qualified storage
  is not released before the last reference to is it lost&per.  Use -mustfree to
  suppress message&per.
   sample&per.c&colon.5,47&colon. Fresh storage x allocated
:ecgraphic.

The first line gives the name of the function in which the error is found&per.
This is printed before the first message reported for a function&per.  (The
function context is not printed if :font facename='System VIO' size=14x8.-showfunc:font facename=default size=0x0. is used&per.) 
:p. 
:p.
The second line is the text of the message&per.  This message reports a memory leak
- storage allocated in a function is not deallocated before the function
returns&per. The text is preceded by the file name, line and column number where
the error is located&per.  The column numbers are used by the emacs mode (see
:link reftype=hd res=23.Appendix H:elink.) to jump to the
appropriate line and column location&per.  (Column numbers are not printed
if :link reftype=hd res=18.:font facename='System VIO' size=14x8.-showcolumn:font facename=default size=0x0.:elink. is used&per.)  
:p.
:p.
The next line is a hint giving more information about the suspected error&per.
Most hints also include information on how the message may be suppressed&per.   For
this message, setting the :font facename='System VIO' size=14x8.-mustfree:font facename=default size=0x0. flag would
prevent the message from being reported&per.  Hints may be turned off by
using :link reftype=hd res=18.:font facename='System VIO' size=14x8.-hints:font facename=default size=0x0.:elink.&per.  Normally, a hint is given only the first time a class of error is reported&per.
To have LCLint print a hint for every message regardless, use :link reftype=hd res=18.:font facename='System VIO' size=14x8.+forcehints:font facename=default size=0x0.:elink.&per.
:p.
:p.
The final line of the message gives additional location information&per.  For this
message, it tells where the leaking storage is allocated&per.
:p.
:p.
The generic message format is (parts enclosed in square brackets are
optional)&colon.
:p.
:cgraphic.
  [<file>&colon.<line> (in <context>)]
  <file>&colon.<line>[,<column>]&colon. :hp1.message:ehp1.
     [:hp1.hint:ehp1.]
      <file>&colon.<line>,<column>&colon. :hp1.extra location information, if appopriate:ehp1.
:p.
:ecgraphic.
The text of messages and hints may be longer than one line&per.  They are split
into lines of length less than the value set using :link reftype=hd res=18.:font facename='System VIO' size=14x8.-linelen:font facename=default size=0x0.:elink.
:hp1.<number>:ehp1.&per.  The default line length is 80 characters&per.  LCLint
attempts to split lines in a sensible place as near to the line length limit as
possible&per.  

.br
:font facename='Helv' size=20x12.
.br

2&per.2 Flags
:font facename=default size=0x0.
.br
.br
So that many programming styles can be supported, LCLint provides over 300
flags for controlling checking and message reporting&per.  Some of the flags are
introduced in the body of this document&per.  :link reftype=hd res=18.Apppendix C:elink. describes every flag&per.
Modes and shortcut flags are provided for setting many flags at once&per.
Individual flags can override the mode settings&per.
:p.
:p.
Flags are preceded by + or -&per.  When a flag is preceded by + we say it is
:hp1.on:ehp1.; when it is preceded by - it is :hp1.off:ehp1.&per. The precise meaning of on
and off depends on the type of flag&per.  
:p.
:p.
The +/- flag settings are used for consistency and clarity, but contradict
standard UNIX usage and is easy to accidentally use the wrong one&per.  To reduce
the likelihood of using the wrong flag, LCLint issues warnings when a flag is
set in an unusual way&per.  Warnings are issued when a flag is redundantly set to
the value it already had (these errors are not reported if the flag is set
using a stylized comment), if a mode flag or special flag is set after a more
specific flag that will be set by the general flag was already set, if value
flags are given unreasonable values, of if flags are set in an inconsistent
way&per.  The :link reftype=hd res=18.:font facename='System VIO' size=14x8.-warnflags:font facename=default size=0x0.:elink. flag suppresses these warnings&per.
:p.
:p.
Default flag settings will be read from :font facename='System VIO' size=14x8.~/&per.lclintrc:font facename=default size=0x0. if it is readable&per.  If
there is a :font facename='System VIO' size=14x8.&per.lclintrc:font facename=default size=0x0. file in the working directory, settings in this file will
be read next and its settings will override those in :font facename='System VIO' size=14x8.~/&per.lclintrc:font facename=default size=0x0.&per.  Command-line
flags override settings in either file&per.  The syntax of the :font facename='System VIO' size=14x8.&per.lclintrc:font facename=default size=0x0. file is
the same as that of command-line flags, except that flags may be on separate
lines and the :font facename='System VIO' size=14x8.#:font facename=default size=0x0. character may be used to indicate that the remainder of the
line is a comment&per. The :link reftype=hd res=18.:font facename='System VIO' size=14x8.-nof:font facename=default size=0x0.:elink.
flag prevents the  :font facename='System VIO' size=14x8.~/&per.lclintrc:font facename=default size=0x0. file from being
loaded&per.  The :link reftype=hd res=18.:font facename='System VIO' size=14x8.-f:font facename=default size=0x0.:elink. :hp1.<filename>:ehp1. flag loads options from :hp1.filename:ehp1.&per.

.br
:font facename='Helv' size=20x12.
.br

2&per.3 Stylized Comments
:font facename=default size=0x0.
.br
.br
Stylized comments are used to provide extra information about a type, variable
or function interface to improve checking, or to control flag settings
locally&per.
:p.
:p.
All stylized comments begin with :font facename='System VIO' size=14x8./*@:font facename=default size=0x0. and are closed by the end of the comment&per.
The role of the :font facename='System VIO' size=14x8.@:font facename=default size=0x0. may be played by any printable character&per.  Use :link reftype=hd res=18.:font facename='System VIO' size=14x8.-commentchar:font facename=default size=0x0.:elink.
:hp1.<char>:ehp1. to select a different stylized comment marker&per.
.br
:font facename='Tms Rmn' size=18x10.
.br
2&per.3&per.1 Annotations
:font facename=default size=0x0.
.br
.br
Annotations are stylized comments that follow a definite syntax&per.  Although they
are comments, they may only be used in fixed grammatical contexts (e&per.g&per., like a
type qualifier)&per.
:p.
:p.
Syntactic comments for function interfaces are described in Section 4; comments for declaring constants
in :link reftype=hd res=11.Section 8&per.1&per.:elink. and comments for
declaring iterators in :link reftype=hd res=11.Section 8&per.4&per.:elink.
Sections 3-8 include descriptions of annotations for expressing
assumptions about variables, parameters, return values, structure fields
and type definitions&per.  A summary of annotations is found in Apppendix D&per.  

.br
:font facename='Tms Rmn' size=18x10.
.br
2&per.3&per.2 Control Comments
:font facename=default size=0x0.
.br
.br
Unlike annotations, control comments may appear between any two tokens in a C
program&per.:link reftype=hd res=5.[3]:elink.  Syntactically, they are no
different from standard comments&per.  Control comments are used to provide
source-level control of LCLint checking&per.  They may be used to suppress spurious
messages, set flags, and control checking locally in other ways&per.  A complete
description of control comments is found in :link reftype=hd res=20.Apppendix E:elink.&per.
:p.
:p.
Most flags (all except those characterized as "global" in :link reftype=hd res=18.Apppendix C:elink.) can be
set locally using control comments&per.  A control comment can set flags locally to
override the command line settings&per.  The original flag settings are restored
before processing the next file&per. The syntax for setting flags in control
comments is the same as that of the command line, except that flags may also be
preceded by = to restore their setting to the original command-line value&per.  For
instance,
:cgraphic.
/*@+boolint -modifies =showfunc@*/
:ecgraphic.
sets :link reftype=hd res=18.:font facename='System VIO' size=14x8.boolint:font facename=default size=0x0.:elink. on (this
makes bool and int indistinguishable types), 
sets :link reftype=hd res=18.:font facename='System VIO' size=14x8.modifies:font facename=default size=0x0.:elink. off (this prevents reporting of modification errors), and sets 
showfunc to its original setting (this controls  whether or not the name of a function is
displayed before a message)&per. 

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=6.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=6.:eartlink.:link reftype=hd res=6.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: sec3.html
:h2 res=6.LCLint User's Guide - 3&per. Abstract Types
:font facename=default size=0x0.
:p.

.br
:font facename='Helv' size=32x20.
.br

3&per. Abstract Types
:font facename=default size=0x0.
.br
.br
:p.
:hp3.
Traditionally, programming books wax mathematical when they arrive at the topic
of abstract data types Such books make it seem as if you'd never actually
use an abstract data type except as a sleep aid&per. :ehp3.
:p.
- Steve McConnell

:p.
Information hiding is a technique for handling complexity&per.  By hiding
implementation details, programs can be understood and developed in distinct
modules and the effects of a change can be localized&per.  One technique for
information hiding is data abstraction&per.  An abstract type is used to represent
some natural program abstraction&per.  It provides functions for manipulating
instances of the type&per.  The module that implements these functions is called
the :hp1.implementation:ehp1. module&per.  We call the functions that are part of the
implementation of an abstract type the :hp1.operations:ehp1. of the type&per.  Other
modules that use the abstract type are called :hp1.clients:ehp1.&per.
:p.
:p.
Clients may use the type name and operations, but should not manipulate or rely
on the actual representation of the type&per.  Only the implementation module may
manipulate the representation of an abstract type&per.  This hides information,
since implementers and maintainers of client modules should not need to know
anything about how the abstract type is implemented&per. It provides modularity,
since the representation of an abstract type can be changed without having to
change any client code&per.
:p.
:p.
LCLint supports abstract types by detecting places where client code depends on
the concrete representation of an abstract type&per.  
:p.
To declare an abstract type, the abstract annotation is added to a typedef&per.
For example (in :font facename='System VIO' size=14x8.mstring&per.h:font facename=default size=0x0.),
:cgraphic.
typedef /*@abstract@*/ char *mstring;
:ecgraphic.
declares :font facename='System VIO' size=14x8.mstring:font facename=default size=0x0. as an abstract type&per.  It is implemented using a :font facename='System VIO' size=14x8.char *:font facename=default size=0x0., but
clients of the type should not depend on or need to be aware of this&per.  If it
later becomes apparent that a better representation such as a string table
should be used, we should be able to change the implementation of mstring
without having to change or inspect any client code&per.
:p.
:p.
In a client module, abstract types are checked by name, not structure&per.  LCLint
reports an error if an instance of mstring is passed as a char * (for instance,
as an argument to strlen), since the correctness of this call depends on the
representation of the abstract type&per.  LCLint also reports errors if any C
operator except assignment (=) or sizeof is used on an abstract type&per.  The
assignment operator is allowed since its semantics do not depend on the
representation of the type&per.:link reftype=hd res=5.[4]:elink.

The use of :font facename='System VIO' size=14x8.sizeof:font facename=default size=0x0. is also permitted, since this is the only way for clients
to allocate pointers to the abstract type&per.  Type casting objects to or from
abstract types in a client module is an abstraction violation and will generate
a warning message&per.
:p.
:p.
Normally, LCLint will assume a type definition is not abstract unless the
:font facename='System VIO' size=14x8./*@abstract@*/:font facename=default size=0x0. qualifier is used&per.  If instead you want all user-defined types
to be abstract types unless they are marked as concrete, the :link reftype=hd res=18.:font facename='System VIO' size=14x8.+impabstract:font facename=default size=0x0.:elink. flag
can be used&per.  This adds an implicit abstract annotation to any typedef that is
not marked with :font facename='System VIO' size=14x8./*@concrete@*/:font facename=default size=0x0.&per.
:p.
:p.
Some examples of abstraction violations detected by LCLint are shown in
:link reftype=hd res=44.Figure 2:elink.&per.
:p.

.br
:font facename='Helv' size=20x12.
.br

3&per.1 Access
:font facename=default size=0x0.
.br
.br
Where code may manipulate the representation of an abstract type, we say the
code has :hp1.access:ehp1. to that type&per.  If code has access to an abstract type,
the representation of the type and the abstract type are indistinguishable&per.
Usually, an abstract type is implemented by a single program module that is the
only code that has access to the type representation&per.  Sometimes, more
complicated access control is desired if the implementation of an abstract type
is split across program files, or particular client code needs to access the
representation&per.
:p.
:p.
There are a several ways of selecting what code has access the representation
of an abstract type&colon.
:p.
:ul compact.
:li.Modules&per.  An abstract type defined in :hp1.M:ehp1.&per.h is accessible in
:hp1.M:ehp1.&per.c&per.  Controlled by the accessmodule flag&per.  This means when accessmodule
is on, as it is by default, the module access rule is in effect&per.  If
accessmodule is off (when :link reftype=hd res=18.:font facename='System VIO' size=14x8.-accessmodule:font facename=default size=0x0.:elink. is used), the module access rule is not
in effect and an abstract type defined in :hp1.M:ehp1.&per.h is not necessarily
accessible in :hp1.M:ehp1.&per.c
:p.
:li.File names&per.  An abstract type named :hp1.type:ehp1. is accessible in files
named :hp1.type:ehp1.&per.:hp1.<extenstion>:ehp1.&per.  For example, the representation
of mstring is be accessible in mstring&per.h and mstring&per.c&per.  Controlled by the
:link reftype=hd res=18.:font facename='System VIO' size=14x8.accessfile:font facename=default size=0x0.:elink. flag&per.
:p.
:li.Function names&per.  An abstract type named :hp1.type:ehp1. may be accessible in
a function named :hp1.type:ehp1._:hp1.name:ehp1. or :hp1.typeName:ehp1.&per.  For example,
mstring_length and mstringLength would have access to the mstring abstract
type&per.  Controlled by the naming convention (see Section 9)&per.
:p.
:li.Access control comments&per. The syntax /*@access :hp1.type:ehp1.,+@*/[6] allows the following code to access the
representation of :hp1.type:ehp1.&per.  Similarly, /*@noaccess :hp1.type:ehp1.,+@*/
restricts access to the representation of :hp1.type:ehp1.&per.  The type in a noaccess
comment must have been declared as an abstract type&per.

:eul.

.br
:font facename='Helv' size=20x12.
.br

3&per.2 Mutability
:font facename=default size=0x0.
.br
.br
We can view types as being :hp1.mutable:ehp1. or :hp1.immutable:ehp1.&per.  A type is
mutable if the value of an instance of the type can be changed by passing it as
a parameter to a function call&per.:link reftype=hd res=5.[7]:elink.  For example, the
primitive type :font facename='System VIO' size=14x8.int:font facename=default size=0x0. is immutable&per.  If i is a local variable of type int and
no variables point to the location where i is stored, the value of i must be
the same before and after the call f(i)&per.  Structure and union types are also
immutable, since they are copied when they are passed as arguments&per.  On the
other hand, pointer types are mutable&per.  If x is a local variable of type int *,
the value of *x (and hence, the value of the object x) can be changed by the
function call g(x)&per.  
:p.
:p.
The mutability of a concrete type is determined by its type definition&per. For
abstract types, mutability does not depend on the type representation but on
what operations the type provides&per. If an abstract type has operations that may
change the value of instances of the type, the type is mutable&per.  If not, it is
immutable&per.  The value of an instance of an immutable type never changes&per.  Since
object sharing is noticeable only for mutable types, they are checked
differently from immutable types&per.
:p.
The :font facename='System VIO' size=14x8./*@mutable@*/:font facename=default size=0x0. and :font facename='System VIO' size=14x8./*@immutable@*/:font facename=default size=0x0. annotations are used to declare an
abstract type as mutable or immutable&per.  (If neither is used, the abstract type
is assumed to be mutable&per.)  For example,
:p.
:font facename='System VIO' size=14x8.
   typedef /*@abstract@*/ /*@mutable@*/ char *mstring;
   typedef /*@abstract@*/ /*@immutable@*/ int weekDay;
:font facename=default size=0x0.
declares mstring as a mutable abstract type and weekDay as  an immutable
abstract type&per.
:p.
:p.
Clients of  a mutable abstract type need to know the semantics of assignment&per.
After the assignment expression s = t, do s and t refer to the same object
(that is, will changes to the value of s also change the value of t)?
:p.
:p.
LCLint prescribes that all abstract types have sharing semantics, so s and t
would indeed be the same object&per.  LCLint will report an error if a mutable type
is implemented with a representation (e&per.g&per., a struct) that does not provide
sharing semantics (controlled by mutrep flag)&per.  
:p.
:p.
The mutability of an abstract type is not necessarily the same as the
mutability of its representation&per. We could use the immutable concrete type int
to represent mutable strings using an index into a string table, or declare
mstring as immutable as long as no operations are provided that modify the
value of an mstring&per.

.br
:font facename='Helv' size=20x12.
.br

3&per.3 Boolean Types
:font facename=default size=0x0.
.br
.br
Standard C has no boolean representation - the result of a comparison operator
is an integer, and no type checking is done for test expressions&per.  Many common
errors can be detected by introducing a distinct boolean type and stronger type
checking&per.
:p.
:p.
By convention, the bool type is used to represent boolean values&per.[8]  Relations,
comparisons and certain standard library functions are declared to return bool
types&per.
:p.

LCLint checks that the test expression in an if, while, or for statement
or an operand to &amp.&amp., || or ! is a boolean&per.  If the type of a test
expression is not a boolean, LCLint will report an error depending on the type
of the test expression and flag settings&per.  If the test expression has pointer
type, LCLint reports an error if predboolptr is on (this can be used to prevent
messages for the idiom of  testing if a pointer is not null without a
comparison)&per.  If it is type int, an error is reported if predboolint is on&per.
For all other types, LCLint reports an error if predboolothers is on&per.
:p.
:p.
Since using = instead of == is such a common bug, reporting of test expressions
that are assignments is controlled by the separate predassign flag&per.  The
message can be suppressed by adding extra parentheses around the test
expression&per.
:p.
:p.
:link reftype=hd res=18.Apppendix C:elink. (page 
50)
describes other flags for controlling boolean checking&per.

:p.
:link reftype=hd res=45.Figure 3&per.  Boolean Checking:elink.
.br
:font facename='Helv' size=20x12.
.br

3&per.4 Primitive C Types
:font facename=default size=0x0.
.br
.br
:p.
:hp3.Two types have :hp1.compatible type:ehp1. if their types are the same&per.:ehp3.
.br
- ANSI C, 3&per.1&per.2&per.6&per.
.br
:p.
:hp3.Two types need not be identical to be compatible&per.:ehp3.
.br
- ANSI C, footnote to 3&per.1&per.2&per.6&per.

LCLint supports stricter checking of primitive C types&per.  The char and enum
types can be checked as distinct types, and the different numeric types can be
type-checked strictly&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

3&per.4&per.1 Characters
:font facename=default size=0x0.
.br
.br
The primitive char type can be type-checked as a distinct type&per.  If char is
used as a distinct type, common errors involving assigning ints to chars are
detected&per.
:p.
:p.
The :link reftype=hd res=18.:font facename='System VIO' size=14x8.+charint:font facename=default size=0x0.:elink. flag can be used for checking legacy programs where char and int
are used interchangeably&per.  If charint is on, char types indistinguishable from
ints&per.  To keep char and int as distinct types, but allow chars to be used to
index arrays, use :link reftype=hd res=18.:font facename='System VIO' size=14x8.+charindex:font facename=default size=0x0.:elink.&per.

.br
:font facename='Tms Rmn' size=18x10.
.br
3&per.4&per.2 Enumerators
:font facename=default size=0x0.
.br
.br
Standard C treats user-declared enum types just like integers&per.  An arbitrary
integral value may be assigned to an enum type, whether or not it was listed as
an enumerator member&per.  LCLint checks each user-defined enum type as distinct
type&per.  An error is reported if a value that is not an enumerator member is
assigned to the enum type, or if an enum type is used as an operand to an
arithmetic operator&per.
:p.
:p.
If the enumint flag is on, enum and int types may be used interchangeably&per.
Like charindex, if  the enumindex flag is on, enum types may be used to index
arrays&per.
.br
:font facename='Tms Rmn' size=18x10.
.br
3&per.4&per.3 Numeric Types
:font facename=default size=0x0.
.br
.br
LCLint reports where numeric types are used in dangerous or inconsistent ways&per.
With the strictest checking, LCLint will report an error anytime numeric types
do not match exactly&per.  If the relaxquals flag is on, only those
inconsistencies which may corrupt values are reported&per.  For example, if an int
is assigned to a variable of type long (or passed as a long formal parameter),
LCLint will not report an error if relaxquals is on since a long must have
at least enough bits to store an int without data loss&per.  On the other hand, an
error would be reported if the long were assigned to an int, since the int type
may not have enough bits to store the long value&per.
:p.
:p.
Similarly, if a signed value is assigned to an unsigned, LCLint will report an
error since an unsigned type cannot represent all signed values correctly&per.  If
the ignoresigns flag is on, checking is relaxed to ignore all sign qualifiers
in type comparisons (this is not recommended, since it will suppress reporting
of real bugs, but may be necessary for quickly checking certain legacy code)&per.  

.br
:font facename='Tms Rmn' size=18x10.
.br
3&per.4&per.4 Arbitrary Integral Types
:font facename=default size=0x0.
.br
.br

LCLint supports three different kinds of arbitrary integral types&colon.
:p.
:p.
:font facename='System VIO' size=14x8./*@integraltype@*/:font facename=default size=0x0.
:p.
An arbitrary integral type&per.  The actual type may be any one of
:font facename='System VIO' size=14x8.short:font facename=default size=0x0., :font facename='System VIO' size=14x8.int:font facename=default size=0x0., :font facename='System VIO' size=14x8.long:font facename=default size=0x0., 
:font facename='System VIO' size=14x8.unsigned short:font facename=default size=0x0., :font facename='System VIO' size=14x8.unsigned:font facename=default size=0x0., or :font facename='System VIO' size=14x8.unsigned long:font facename=default size=0x0.
&per. 

:p.
:font facename='System VIO' size=14x8./*@unsignedintegraltype@*/:font facename=default size=0x0.
:p.
An arbitrary unsigned integral type&per.  The actual type may be any one of
:font facename='System VIO' size=14x8.unsigned short:font facename=default size=0x0., :font facename='System VIO' size=14x8.unsigned:font facename=default size=0x0., or :font facename='System VIO' size=14x8.unsigned long:font facename=default size=0x0.
&per.


:p.
:font facename='System VIO' size=14x8./*@signedintegraltype@*/:font facename=default size=0x0.
:p.
An arbitrary signed integral type&per.  The actual type may be any one of
:font facename='System VIO' size=14x8.short:font facename=default size=0x0., :font facename='System VIO' size=14x8.int:font facename=default size=0x0., or :font facename='System VIO' size=14x8.long:font facename=default size=0x0.&per. 


:p.
LCLint reports an error if the code depends on the actual representation
of a type declared as an arbitrary integral&per.  The :font facename='System VIO' size=14x8.match-any-integral:font facename=default size=0x0.
flag relaxes checking and allows an arbitrary integral type is allowed
to match any integral type&per. 

:p.

Other flags set the arbitrary integral types to a concrete type&per.  These
should only be used if portability to platforms that may use different
representations is not important&per.  The :font facename='System VIO' size=14x8.long-integral:font facename=default size=0x0. and
:font facename='System VIO' size=14x8.long-unsigned-integral:font facename=default size=0x0. flags set the type corresponding to
:font facename='System VIO' size=14x8./*@integraltype@*/:font facename=default size=0x0. to be :font facename='System VIO' size=14x8.unsigned long:font facename=default size=0x0. and
:font facename='System VIO' size=14x8.long:font facename=default size=0x0. respectively&per. The :font facename='System VIO' size=14x8.long-unsigned-unsigned-integral:font facename=default size=0x0.
flag sets the type corresponding to :font facename='System VIO' size=14x8./*@unsignedintegraltype@*/:font facename=default size=0x0.
to be :font facename='System VIO' size=14x8.unsigned long:font facename=default size=0x0.&per. The :font facename='System VIO' size=14x8.long-signed-integral:font facename=default size=0x0.
flag sets the type corresponding to :font facename='System VIO' size=14x8./*@signedintegraltype@*/:font facename=default size=0x0. to
be :font facename='System VIO' size=14x8.long:font facename=default size=0x0.&per.

:p.
:cgraphic.:ecgraphic.
.br
:link reftype=hd res=7.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=7.:eartlink.:link reftype=hd res=7.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: sec4.html
:h2 res=7.LCLint User's Guide - 4&per. Function Interfaces
:font facename=default size=0x0.
:p.

.br
:font facename='Helv' size=32x20.
.br

4&per. Function Interfaces
:font facename=default size=0x0.
.br
.br
Functions communicate with their calling environment through an interface&per.  The
caller communicates the values of actual parameters and global variables to the
function, and the function communicates to the caller through the return value,
global variables and storage reachable from the actual parameters&per.  By keeping
interfaces narrow (i&per.e&per., restricting the amount of information visible across a
function interface), we can understand and implement functions independently&per.
:p.
:p.
A function prototype documents the interface to a function&per.  It serves as a
contract between the function and its caller&per.  In early versions of C, the
function "prototype" was very limited&per.  It described the type returned by the
function but nothing about its parameters&per.  The main improvement provided by
ANSI C was the ability to add information on the number and types of parameter
to a function&per.  LCLint provides the means to express much more about a function
interface&colon. what global variable the function may use, what values visible to
the caller it may modify, if a pointer parameter may be a null pointer or point
to undefined storage, if storage pointed to by a parameter is deallocated
before the function returns, if the function may create new aliases to a
parameter, can the caller modify or deallocate the return value, etc&per.  
:p.
:p.
The extra interface information places constraints on both how the function may
be called and how it may be implemented&per.  LCLint reports places where these
constrains are not satisfied&per.  Typically, these indicate bugs in the code or
errors in the interface documentation&per.
:p.
:p.
This section describes syntactic comments may be added to a function
declaration to document what global variables the function implementation may
use and what values visible to its caller it may modify&per.  Sections 5-7 describe
annotations may be added to parameters to constrain valid arguments to a
function and how these arguments may be used after the call and to the return
value to constrain results&per. 

.br
:font facename='Helv' size=20x12.
.br

4&per.1 Modifications
:font facename=default size=0x0.
.br
.br
The modifies clause lists what values visible to the caller may be modified by
a function&per.  Modifies clauses limit what values a function may modify, but they
do not require that listed values are always modified&per.  The declaration,
:cgraphic.
int f (int *p, int *q) /*@modifies *p@*/;
:ecgraphic.
declares a function f that may modify the value pointed to by its first
argument but may not modify the value of its second argument or any global
state&per.
:p.
:p.
LCLint checks that a function does not modify any caller-visible value not
encompassed by its  modifies clause and does modify all values listed in its
modifies clause on some possible execution of the function&per.  Figure 4 shows an
example of modifies checking done by LCLint&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

4&per.1&per.1 Special Modifications
:font facename=default size=0x0.
.br
.br
A few special names are provided for describing function modifications&colon.
:p.
:font facename='System VIO' size=14x8.internalState:font facename=default size=0x0.
:p.
The function modifies some internal state (that is, the value of a static
variable)&per.  Even though a client cannot access the internal state directly, it
is important to know that something may be modified by the function call
both for clear documentation and for checking undefined order of
evaluation (:link reftype=hd res=13.Section 10&per.1:elink.) and
side-effect free parameters (Section 8&per.2&per.1)&per.
:p. 

:font facename='System VIO' size=14x8.fileSystem:font facename=default size=0x0.
:p.
The function modifies the file system&per.  Any modification that may change
the system state is considered a file system modification&per.  All
functions that modify an object of type pointer to :font facename='System VIO' size=14x8.FILE:font facename=default size=0x0. also
modify the file system&per.  In addition, functions that do not modify a
:font facename='System VIO' size=14x8.FILE:font facename=default size=0x0. pointer but modify some state that is visible outside this
process also modify the file system (e&per.g&per., :font facename='System VIO' size=14x8.rename:font facename=default size=0x0.)&per.  The flag
:link reftype=hd res=18.:font facename='System VIO' size=14x8.mod-file-system:font facename=default size=0x0.:elink.
controls reporting of undocumented file system modifications&per.


:font facename='System VIO' size=14x8.nothing:font facename=default size=0x0.
:p.
The function modifies nothing (i&per.e&per., it is side-effect free)&per. 

:p.
The syntactic comment, :font facename='System VIO' size=14x8./*@*/:font facename=default size=0x0. in a function declaration or definition (after the
parameter list, before the semi-colon or function body) denotes a function that
modifies nothing and does not use any global variables (see :link reftype=hd res=7.Section 4&per.2:elink.)&per.

:p.
:link reftype=hd res=46.Figure 4&per.  Modifies checking&per.:elink.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br

4&per.1&per.2 Missing Modifies Clauses
:font facename=default size=0x0.
.br
.br
LCLint is designed so programs with many functions that are declared without
modifies clauses can be checked effectively&per.  Unless modnomods is in on, no
modification errors are reported checking a function declared with no modifies
clause&per.  
:p.
:p.
A function with no modifies clause is an :hp1.unconstrained:ehp1. function since
there are no documented constraints on what it may modify&per.  When an
unconstrained function is called, it is checked differently from a function
declared with a modifies clause&per.  To prevent spurious errors, no modification
error is reported at the call site unless the moduncon flag is on&per.  Flags
control whether errors involving unconstrained functions are reported for other
checks that depend on modifications (side-effect free macro parameters
(:link reftype=hd res=11.Section 8&per.2&per.1:elink.), undefined evaluation order (:link reftype=hd res=13.Section 10&per.1:elink.), and likely infinite loops
(:link reftype=hd res=13.Section 10&per.2&per.1:elink.)&per.)

.br
:font facename='Tms Rmn' size=18x10.
.br

4&per.1&per.3 Limitations
:font facename=default size=0x0.
.br
.br
Determining whether a function modifies a particular parameter or global is in
general an undecidable:link reftype=hd res=5.[9]:elink. problem&per.  To enable useful
checking, certain simplifying assumptions are necessary&per.  LCLint assumes an
object is modified when it appears on the left hand side of an assignment or it
is passed to a function as a parameter which may be modified by that function
(according to the called function's modifies clause)&per. Hence, LCLint will report
spurious modification errors for assignments that do not change the value
of an object or modifications that are always reversed before a procedure
returns&per.  The :font facename='System VIO' size=14x8./*@-mods@*/:font facename=default size=0x0. and :font facename='System VIO' size=14x8./*@=mods@*/:font facename=default size=0x0. control comments can be used around
these modifications to suppress the message&per. 

.br
:font facename='Helv' size=20x12.
.br

4&per.2 Global Variables
:font facename=default size=0x0.
.br
.br
Another aspect of a function's interface, is the global variables it uses&per.  A
globals list in a function declaration lists external variables that may be
used in the function body&per. LCLint checks that global variables used in a
procedure match those listed in its globals list&per. A global is used in a
function if it appears in the body directly, or it is in the globals list of a
function called in the body&per. LCLint reports if a global that is used in a
procedure is not listed in its globals list, and if a listed global is not used
in the function implementation&per.  
:p.

:link reftype=hd res=47.Figure 5:elink. shows an example function definition with a globals list and associated checking done by LCLint&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

4&per.2&per.1 Controlling Globals Checking
:font facename=default size=0x0.
.br
.br
Whether on not an error is reported for a use of a global variable in a given
function depends on the scope of the variable (file static or external), the
checking annotation used in the variable declaration or the implicit annotation
if no checking annotation is used, whether or not the function is declared with
a globals list, and flag settings&per. 
:p.
:p.
A global or file static variable declaration may be preceded by an annotation
to indicate how the variable should be checked&per.  In order of decreasing checks,
the annotations are&colon.
:p.
:font facename='System VIO' size=14x8./*@checkedstrict@*/:font facename=default size=0x0.
:p.
Strictest checking&per.  Undocumented uses and modifications of the variable are
reported in all functions whether or not they have a globals list (unless
:link reftype=hd res=18.:font facename='System VIO' size=14x8.checkstrictglobs:font facename=default size=0x0.:elink. is off)&per.

:font facename='System VIO' size=14x8./*@checked@*/:font facename=default size=0x0.
:p.
Undocumented use of the variable is reported in a function with a globals list,
but not in a function declared with no globals (unless :link reftype=hd res=18.:font facename='System VIO' size=14x8.globnoglobs:font facename=default size=0x0.:elink. is on)&per.
:p.

:font facename='System VIO' size=14x8./*@checkmod@*/:font facename=default size=0x0.
:p.
Undocumented uses of the variable are not reported, but undocumented
modifications are reported&per.   (If :link reftype=hd res=18.:font facename='System VIO' size=14x8.modglobsnomods:font facename=default size=0x0.:elink. is on, errors are reported even
in functions declared with no modifies clause or globals list&per.)

:font facename='System VIO' size=14x8./*@unchecked@*/:font facename=default size=0x0.
:p.
No messages are reported for undocumented use or modification of this global
variable&per.  If a variable has none of these annotations, an implicit
annotation is determined by the flag settings&per.  

:p.
Different flags control the implicit annotation for variables declared with
global scope and variables declared with file scope (i&per.e&per., using the static
storage qualifier)&per. To set the implicit annotation for global variables
declared in :hp1.context:ehp1. (globs for external variables or statics for file
static variable) to be :hp1.annotation:ehp1. (:font facename='System VIO' size=14x8.checked:font facename=default size=0x0., :font facename='System VIO' size=14x8.checkmod:font facename=default size=0x0., :font facename='System VIO' size=14x8.checkedstrict
:font facename=default size=0x0.) use
imp:hp1.<annotation><context>:ehp1.&per.  For example,
:link reftype=hd res=18.:font facename='System VIO' size=14x8.+impcheckedstrictstatics:font facename=default size=0x0.:elink. makes the implicit checking on unqualified file static
variables checkedstrict&per.  (See :link reftype=hd res=18.Apppendix C:elink., page 51, for a complete list of
globals checking flags&per.)

.br
:font facename='Helv' size=20x12.
.br

4&per.3 Declaration Consistency
:font facename=default size=0x0.
.br
.br
LCLint checks that function declarations and definitions are consistent&per.  The
general rule is that the :hp1.first:ehp1. declaration of a function imply all later
declarations and definitions&per.  If a function is declared in a header file, the
first declaration processed is its first declaration (if it is declared in more
than one header file an error is reported if redecl is set)&per.  Otherwise, the
first declaration in the file defining the function is its first declaration&per.
:p.
:p.
Later declarations may not include variables in the globals list that were not
included in the first declaration&per.  The exception to this is when the first
declaration is in a header file and the later declaration or definition
includes file static variables&per.  Since these are not visible in the header
file, they can not be included in the header file declaration&per.  Similarly, the
modifies clause of a later declaration may not include objects that are not
modifiable in the first declaration&per.  The later declaration may be more
specific&per.  For example, if the header declaration is&colon.
:cgraphic.
extern void setName (employee e, char *s) /*@modifies e@*/;
:ecgraphic.
the later declaration could be,
:cgraphic.
   void setName (employee e, char *) /*@modifies e->name@*/;
:ecgraphic.
If employee is an abstract type, the declaration in the header should not refer
to a particular implementation (i&per.e&per., it shouldn't rely on there being a name
field), but the implementation declaration can be more specific&per.  
:p.
:p.
This rule also applies to file static variables&per.  The header declaration for a
function that modifies a file static variable should use modifies internalState
since file static variables are not visible to clients&per.  The implementation
declaration should list the actual file static variables that may be modified&per.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=8.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=8.:eartlink.:link reftype=hd res=8.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: sec5.html
:h2 res=8.LCLint User's Guide - 5&per. Memory Management
:font facename=default size=0x0.
:p.

.br
:font facename='Helv' size=32x20.
.br

5&per. Memory Management
:font facename=default size=0x0.
.br
.br
About half the bugs in typical C programs can be attributed to memory
management problems&per.  Memory management bugs are notoriously difficult to
detect through traditional techniques&per.  Often, the symptom of the bug is far
removed from its actual source&per.  Memory management bug often only appear
sporadically and some bugs may only be apparent when compiler optimizations are
turned on or the code is compiled on a different platform&per.  Run-time tools
offer some help, but are cumbersome to use and limited to detecting errors that
occur when test cases are run&per.  By detecting these errors statically, we can be
confident that certain types of errors will never occur and provide verified
documentation on the memory management behavior of a program&per.  
:p.
:p.
LCLint can detect many memory management errors at compile time including&colon.
:p.
:ul compact.
:li.using storage that may have been freed (:link reftype=hd res=8.Section 5&per.2:elink.)
:p.
:li.failing to deallocate memory (:link reftype=hd res=8.Section 5&per.2:elink.)
:p.
:li.returning a pointer to stack-allocated storage (:link reftype=hd res=8.Section 5&per.2&per.6:elink.)
:p.
:li.undocumented or dangerous aliasing or storage sharing (:link reftype=hd res=9.Section 6:elink.)
:p.
:li.passing or returning storage that is not completely defined (Section 7&per.1)
:p.
:li.dereferencing a null pointers (:link reftype=hd res=10.Section 7&per.2:elink.)
:p.
:eul.


Most of these checks rely heavily on annotations added to programs to document
assumptions related to memory management and pointer values&per.  By documenting
these assumptions for function interfaces, variables, type definitions and
structure fields, memory management bugs can be detected at their source --
where an assumption is violated&per.  In addition, precise documentation about
memory management decisions makes its easier to change code&per.

.br
:font facename='Helv' size=20x12.
.br

5&per.1 Storage Model:link reftype=hd res=5.[10]:elink.
:font facename=default size=0x0.
.br
.br
:p.
:hp3. Yea, from the table of my memory I'll wipe away all trivial fond records, all
saws of books, all forms, all pressures past, that youth and observation copied
there&per.:ehp3.
.br
- Hamlet prefers garbage collection (Shakespeare, Hamlet&per. Act I, Scene
v)


This section describes execution-time concepts for describing the state of
storage more precisely than can be done using standard C terminology&per.  Certain
uses of storage are likely to indicate program bugs, and are reported as
anomalies&per.
:p.
:p.
LCL assumes a CLU-like object storage model&per.[11]  An :hp1.object:ehp1. is a typed region
of storage&per.  Some objects use a fixed amount of storage that is allocated and deallocated automatically by the
compiler&per.
:p.
Other objects use dynamic storage that must be managed by the program&per.
:p.
:p.
Storage is :hp1.undefined:ehp1. if it has not been assigned a value, and
:hp1.defined:ehp1. after it has been assigned a value&per.  An object is :hp1.completely
defined:ehp1. if all storage that may be reached from it is defined&per.  What
storage is reachable from an object depends on the type and value of the
object&per.  For example, if p is a pointer to a structure, p is completely defined
if the value of p is NULL, or if every field of the structure p points to is
completely defined&per.
:p.
:p.
When an expression is used as the left side of an assignment expression we say
it is :hp1.used as an lvalue:ehp1.&per.  Its location in memory is used, but not its
value&per.  Undefined storage may be used as an lvalue since only its location is
needed&per.  When storage is used in any other way, such as on the right side of an
assignment, as an operand to a primitive operator (including the indirection
operator, *),:link reftype=hd res=5.[12]:elink. or as a
:p.
function parameter, we say it is :hp1.used as an rvalue:ehp1.&per.  It is an
anomaly to use undefined storage as an rvalue&per.
:p.
:p.
A :hp1.pointer:ehp1. is a typed memory address&per.  A pointer is either :hp1.live:ehp1. or
:hp1.dead:ehp1.&per.  A live pointer is either NULL or an address within allocated
storage&per.  A pointer that points to an object is an :hp1.object:ehp1. pointer&per.  A
pointer that points inside an object (e&per.g&per., to the third element of an
allocated block) is an :hp1.offset:ehp1. pointer&per.  A pointer that points to
allocated storage that is not defined is an :hp1.allocated:ehp1. pointer&per.  The
result of dereferencing an allocated pointer is undefined storage&per.  Hence, it
is an anomaly to use it as an rvalue&per.  A dead (or "dangling") pointer does not
point to allocated storage&per.  A pointer becomes dead if the storage it points to
is deallocated (e&per.g&per., the pointer is passed to the free library function&per.)  It
is an anomaly to use a dead pointer as an rvalue&per.
:p.
:p.
There is a special object :hp1.null:ehp1. corresponding to the NULL pointer in a C
program&per.  A pointer that may have the value NULL is a :hp1.possibly-null:ehp1.
pointer&per.  It is an anomaly to use a possibly-null pointer where a non-null
pointer is expected (e&per.g&per., certain function arguments or the indirection
operator)&per.

.br
:font facename='Helv' size=20x12.
.br

5&per.2 Deallocation Errors
:font facename=default size=0x0.
.br
.br
There are two kinds of deallocation errors with which we are concerned&colon.
deallocating storage when there are other live references to the same storage,
or failing to deallocate storage before the last  reference to it is lost&per.  To
handle these deallocation errors, we introduce a concept of an obligation to
release storage&per.  Every time storage is allocated, it creates an obligation to
release the storage&per.  This obligation is attached to the reference to which the
storage is assigned&per.:link reftype=hd res=5.[13]:elink.  Before the scope of the
reference is exited or it is assigned to a new value, the storage to which it
points must be released&per.  Annotations can be used to indicate that this
obligation is transferred through a return value, function parameter or
assignment to an external reference&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

5&per.2&per.1 Unshared References
:font facename=default size=0x0.
.br
.br

:p.
:hp3.`Tis in my memory lock'd, and you yourself shall keep the key of it&per.:ehp3.
.br
- Ophelia prefers explicit deallocation (Hamlet&per.  Act I, Scene iii)


The only annotation is used to indicate a reference is the only pointer to the
object it points to&per.  We can view the reference as having an obligation to
release this storage&per.  This obligation is satisfied by transferring it to some other reference in one of three ways&colon.
:p.
:ul compact.
:li.pass it as an actual parameter corresponding to a formal parameter
declared with an only annotation               
:li.assign it to an external reference declared with an only annotation
:li.return it as a result declared with an only annotation
:eul.


After the release obligation is transferred, the original reference is a dead
pointer and the storage it points to may not be used&per. 
:p.

:p.
All obligations to release storage stem from primitive allocation routines
(e&per.g&per., malloc), and are ultimately satisfied by calls to free&per.  The standard
library declared the primitive allocation and deallocation routines&per.
:p.
The basic memory allocator, malloc, is declared&colon.[14]
:p.
:cgraphic.
/*@only@*/ void *malloc (size_t size);
:ecgraphic.
It returns an object that is referenced only by the function return value&per.  
:p.
:p.
The deallocator, free, is declared&colon.:link reftype=hd res=5.[15]:elink.
:p.
:cgraphic.
void free (/*@only@*/ void *ptr);
:ecgraphic.
:p.
The parameter to free must reference an unshared object&per.  Since the parameter
is declared using only, the caller may not use the referenced object after the
call, and may not pass in a reference to a shared object&per.  There is nothing
special about malloc and free -- their behavior can be described entirely in
terms of the provided annotations&per.

:p.
:link reftype=hd res=48.Figure 6&per.  Deallocation errors&per.:elink.
:p.
.br
:font facename='Tms Rmn' size=18x10.
.br

5&per.2&per.2 Temporary Parameters
:font facename=default size=0x0.
.br
.br
The temp annotation is used to declare a function parameter that is used
temporarily by the function&per.  An error is reported if the function releases the
storage associated with a temp formal parameter or creates new aliases it that
are visible after the function returns&per.  Any storage may be passed as a temp
parameter, and it satisfies its original memory constraints after the function
returns&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

5&per.2&per.3 Owned and Dependent References
:font facename=default size=0x0.
.br
.br
In real programs it is sometimes necessary to have storage that is shared
between several possibly references&per.  The owned and dependent annotations
provide a more flexible way of managing storage, at the cost of less checking&per.
The owned annotation denotes a reference with an obligation to release storage&per.
Unlike only, however, other external references marked with dependent
annotations may share this object&per.  It is up to the programmer to ensure that
the lifetime of a dependent reference is contained within the lifetime of the
corresponding owned reference&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

5&per.2&per.4 Kept Parameters
:font facename=default size=0x0.
.br
.br
The keep annotation is similar to only, except the caller may use the reference
after the call&per.  The called function must assign the keep parameter to an only
reference, or pass it as a keep parameter to another function&per.  It is up to the
programmer to make sure that the calling function does not use this reference
after it is released&per.  The keep annotation is useful for adding an object to a
collection (e&per.g&per., a symbol table), where it is known that it will not be
deallocated until the collection is&per. 

.br
:font facename='Tms Rmn' size=18x10.
.br

5&per.2&per.5 Shared References
:font facename=default size=0x0.
.br
.br
If LCLint is used to check a program designed to be used in a garbage-collected
environment, there may be storage that is shared by one or more references and
never explicitly released&per.  The shared annotation declares storage that may be
shared arbitrarily, but never released&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

5&per.2&per.6 Stack References
:font facename=default size=0x0.
.br
.br
Local variables that are not allocated dynamically are store on a call stack&per.
When a function returns, its stack frame is deallocated, destroying the storage
associated with the function's local variables&per.  A memory error occurs if a
pointer into this storage is live after the function returns&per.  LCLint detects
errors involving stack references exported from a function through return
values or assignments to references reachable from global variables or actual
parameters&per.  No annotations are needed to detect stack reference errors, since
it is clear from a declaration if storage is allocated on the function stack&per.
:p.
:link reftype=hd res=49.Figure 7&per.  Stack references&per.:elink.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br

5&per.2&per.7 Inner Storage
:font facename=default size=0x0.
.br
.br
An annotation always applies to the outermost level of storage&per.  For example,
:cgraphic.
/*@only@*/ int **x;
:ecgraphic.
declares x as an unshared pointer to a pointer to an int&per.  The only annotation
applies to x, but not to *x&per.  To apply annotations to inner storage a type
definition may be used&colon.
:cgraphic.
  typedef /*@only@*/ int *oip;
  /*@only@*/ oip *x;
:ecgraphic.
Now, x is an only pointer to an oip, which is an only pointer to an int&per.
:p.
:p.
When annotations are use in type definitions, they may be overridden in
instance declarations&per.  For example,
:cgraphic.
/*@dependent@*/ oip x;
:ecgraphic.
makes x a dependent pointer to an int&per.

.br
:font facename='Helv' size=20x12.
.br

5&per.3 Implicit Memory Annotations
:font facename=default size=0x0.
.br
.br
Since it is important that LCLint can check unannotated programs effectively,
the meaning of declarations with no memory annotations is chosen to minimize
the number of annotations needed to get useful checking on an unannotated
program&per. 
:p.
:p.
An implicit memory management annotation may be assumed for declarations with
no explicit memory management annotation&per.  Implicit annotations are checked
identically to the corresponding explicit annotation, except error messages
indicate that they result from an implicit annotation&per.
:p.
:p.
Unannotated function parameters are assumed to be temp&per.  This means if memory
checking is turned on for an unannotated program, all functions that release
storage referenced by a parameter or assign a global variable to alias the
storage will produce error messages&per.  (Controlled by paramimptemp&per.)
:p.
:p.
Unannotated return values, structure fields and global variables are assumed to
be only&per.  With implicit annotations (on by default), turning on memory checking
for an unannotated program will produce errors for any function that does not
return unshared storage or assignment of shared storage to a global variable or
structure field&per.:link reftype=hd res=5.[16]:elink.  (Controlled by
:link reftype=hd res=18.:font facename='System VIO' size=14x8.retimponly:font facename=default size=0x0.:elink., :font facename='System VIO' size=14x8.structimponly:font facename=default size=0x0. and :font facename='System VIO' size=14x8.globimponly
:font facename=default size=0x0.&per.  The :font facename='System VIO' size=14x8.codeimponly:font facename=default size=0x0. flag sets all of the implicit only flags&per.)   
:p.
:link reftype=hd res=50.Figure 8&per.  Implicit annotations:elink.
:p.
.br
:font facename='Helv' size=20x12.
.br

5&per.4 Reference Counting
:font facename=default size=0x0.
.br
.br
Another approach to memory management is to add a field to a type to explicitly
keep track of the number of references to that storage&per.  Every time a reference
is added or lost the reference count is adjusted accordingly;  if it would
become zero, the storage is released&per.  Reference counting it difficult to do
without automatic checking since it is easy to forget to increment or decrement
the reference count, and exceedingly difficult to track down these errors&per.
:p.
:p.
LCLint supports reference counting by using annotations to constrain the use of
reference counted storage in a manner similar to other memory management
annotations&per.
:p.
:p.
A reference counted type is declared using the refcounted annotation&per.  Only
pointer to struct types may be declared as reference counted, since reference
counted storage must have a field to count the references&per.  One field in the
structure (or integral type) is preceded by the refs annotation to indicate
that the value of this field is the number of live references to the structure&per.
:p.
 
:p.
For example (in :font facename='System VIO' size=14x8.rstring&per.h:font facename=default size=0x0.),
:cgraphic.
     typedef /*@abstract@*/ /*@refcounted@*/ struct {
          /*@refs@*/ int refs;
        char *contents;
      } *rstring;
:ecgraphic.
declares rstring as an abstract, reference-counted type&per.  The refs field counts
the number of references and the contents field holds the contents of a
string&per.
:p.
:p.
All functions that return refcounted storage must increase the reference count
before returning&per.  LCLint cannot determine if the reference count was
increased, so any function that directly returns a reference to refcounted
storage will produce an error&per.  This is avoided, by using a function to return
a new reference (e&per.g&per., rstring_ref in Figure 9)&per.
:p.
:p.
A reference counted type may be passed as a temp or dependent parameter&per.  It
may not be passed as an only parameter&per.  Instead, the killref annotation is
used to denote a parameter whose reference is eliminated by the function call&per.
Like only parameters, an actual parameter corresponding to a killref formal
parameter may not be used in the calling function after the call&per.  LCLint
checks that the implementation of a function releases all killref parameters,
either by passing them as killref parameters, or assigning or returning them
without increasing the reference count&per.
:p.

:p.
:link reftype=hd res=51.Figure 9&per.  Reference counting&per.:elink.



:cgraphic.:ecgraphic.
.br
:link reftype=hd res=9.
:elink.:artwork name='right-arrow.bmp' align=left.:artlink.:link reftype=hd res=9.:eartlink.:link reftype=hd res=9.:elink.
:link reftype=hd res=1.
:elink.:artwork name='up-arrow.bmp' align=left.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: sec6.html
:h2 res=9.LCLint User's Guide - 6&per. Sharing
:font facename=default size=0x0.
:p.

.br
:font facename='Helv' size=32x20.
.br

6&per. Sharing
:font facename=default size=0x0.
.br
.br

Errors involving unexpected sharing of storage can cause serious problems&per.
Undocumented sharing may lead to unpredictable modifications, and some library
calls (e&per.g&per., strcpy) have undefined behavior if parameters share storage&per.
Another class of sharing errors occurs when clients of an abstract type may
obtain a reference to mutable storage that is part of the abstract
representation&per.  This exposes the representation of the abstract type, since
clients may modify an instance of the abstract type indirectly through this
shared storage&per.
:p.

.br
:font facename='Helv' size=20x12.
.br

6&per.1 Aliasing
:font facename=default size=0x0.
.br
.br
LCLint detects errors involving dangerous aliasing of parameters&per.  Some of
these errors are already detected through the standard memory annotations
(e&per.g&per., only parameters may not be aliases&per.)   Two additional annotations are
provided for constraining aliasing of parameters and return values&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

6&per.1&per.1 Unique Parameters
:font facename=default size=0x0.
.br
.br
The unique annotation denotes a parameter that may not be aliased by any other
storage reachable from the function implementation -- that is, any storage
reachable through the other parameters or global variables used by the
function&per.  The unique annotation places similar constraints on function
parameters as the only annotation, but it does not transfer the obligation to
release storage&per.
:p.
LCLint will report an error if a unique parameter may be aliased by another
parameter or global variable&per.
:p.

:link reftype=hd res=52.Figure 10&per.  Unique parameters&per.:elink.

.br
:font facename='Tms Rmn' size=18x10.
.br

6&per.1&per.2 Returned Parameters
:font facename=default size=0x0.
.br
.br
LCLint reports an error if a function returns a reference to storage reachable
from one of its parameters (if retalias is on) since this may introduce
unexpected aliases in the body of the calling function when the result is
assigned&per.
:p.
:p.
The returned annotation denotes a parameter that may be aliased by the return
value&per.  LCLint checks the call assuming the result may be an alias to the
returned parameter&per. :link reftype=hd res=53.Figure 11:elink. shows an example use of a returned annotation&per.

.br
:font facename='Helv' size=20x12.
.br

6&per.2 Exposure
:font facename=default size=0x0.
.br
.br
LCLint detects places where the representation of an abstract type is exposed&per.
This occurs if a client has a pointer to storage that is part of the
representation of an instance of the abstract type&per.  The client can then modify
or examine the storage this points to, and manipulate the value of the abstract
type instance without using its operations&per.
:p.
:hp2.:ehp2.There are three ways a representation may be exposed&colon.
:ol compact.
:li.Returning (or assigning to a global variable) an object that includes a
pointer to a mutable component of an abstract type representation&per.  (Controlled
by :link reftype=hd res=18.:font facename='System VIO' size=14x8.retexpose:font facename=default size=0x0.:elink.)&per.
:li.Assigning a mutable component of an abstract object to storage reachable
from an actual parameter or a global variable that may be used after the call&per.
This means the client may manipulate the abstract object using the actual
parameter after the call&per.  Note that if the corresponding formal parameter is
declared only, the caller may not use the actual parameter after the call so
the representation is not exposed&per.  (Controlled by :link reftype=hd res=18.:font facename='System VIO' size=14x8.assignexpose:font facename=default size=0x0.:elink.)&per.
:li.Casting mutable storage to or from an abstract type&per.  (Controlled by
:link reftype=hd res=18.:font facename='System VIO' size=14x8.castexpose:font facename=default size=0x0.:elink.)&per.
:eol.


Annotations may be used to allow exposed storage to be returned safely by
restricting how the caller may use the returned storage&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

6&per.2&per.1 Read-Only Storage
:font facename=default size=0x0.
.br
.br
It is often useful for a function to return a pointer to internal storage (or a
instance of a mutable abstract type) that is intended only as an
:hp1.observer:ehp1.&per.  The caller may use the result, but should not modify the
storage it points to&per.  For example, consider an nave implementation of
the employee_getName operation for the abstract employee type&colon.
:cgraphic.
   typedef /*@abstract@*/ struct {
      char *name;
      int id;
   } *employee;
   &per.&per.&per.
   char *employee_getName (employee e) { return e->name; }
:ecgraphic.
LCLint produces a message to indicate that the return value exposes the
representation&per.  One solution would be to return a fresh copy of e->name&per.
This is expensive, though, especially if we expect employee_getName is used
mainly just to get a string for searching or printing&per.  Instead, we could
change the declaration of employee_getName to&colon.
:cgraphic.
extern /*@observer@*/ char *employee_getName (employee e);
:ecgraphic.
Now, the original implementation is correct&per.  The declaration indicates that
the result may not be modified by the caller, so it is acceptable to return
shared storage&per.:link reftype=hd res=5.[17]:elink.  LCLint checks that the
return value is not modified by the caller&per.  An error is reported if observer
storage is modified directly, passed as a function parameter that may be
modified, assigned to a global variable or reference derivable from a global
variable that is not declared with an observer annotation, or returned as a
function result or a reference derivable from the function result that is not
annotation with an observer annotation&per.

.br
:font facename='Tms Rmn' size=16x8.
.br
String
Literals
:font facename=default size=0x0.
.br
.br
A program that attempts to modify a string literal has undefined behavior
[ANSI, Section 3&per.1&per.4]&per. This is not enforced by most C compilers, and can lead
to particularly pernicious bugs that only appear when optimizations are turned
on and the compiler attempts to minimize storage for string literals&per.  LCLint
can be used to check that string literals are not modified, by treating them as
observer storage&per.  If readonlystrings is on (default in standard mode), LCLint
will report an error if a string literal is modified&per. 

.br
:font facename='Tms Rmn' size=18x10.
.br

6&per.2&per.2 Exposed Storage
:font facename=default size=0x0.
.br
.br
Sometimes it is necessary to expose the representation of an abstract type&per.
This may be evidence of a design flaw, but in some cases is justified for
efficiency reasons&per.  The exposed annotation denotes storage that is exposed&per.
It may be used on a return value for results that reference storage internal to
an abstract representation, on a parameter value to indicate a parameter that
may be assigned directly to part of an abstract representation,[18] or on a field of an abstract representation
to indicate that external references to the storage may exist&per.  
An
error is reported if exposed storage is released, but unlike an observer, no
error is reported if it is modified&per.
:p.
:p.
:link reftype=hd res=54.Figure 12:elink. shows examples of exposure problems detected by LCLint&per.


:cgraphic.:ecgraphic.
.br
:link reftype=hd res=10.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=10.:eartlink.:link reftype=hd res=10.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: sec7.html
:h2 res=10.LCLint User's Guide - 7&per. Value Constraints
:font facename=default size=0x0.
:p.

.br
:font facename='Helv' size=32x20.
.br

7&per. Value Constraints
:font facename=default size=0x0.
.br
.br
LCLint can be used to constrain values of parameters, function results, global
variables, and derived storage such as structure fields&per.  These constraints are
checked at :hp1.interface points:ehp1. -- where a function is called or returns&per.
:link reftype=hd res=10.Section 7&per.1:elink. describes how to constrain parameters, return values and structures
to detect use before definition errors&per.  A similar approach is used for
restricting the use of possibly null pointers in Section 7&per.2&per.  To do both well, and avoid spurious errors, information about when and if a function returns if
useful&per.  Annotations for documenting execution control are described in
:link reftype=hd res=10.Section 7&per.3:elink.&per.
:p.
:p.

.br
:font facename='Helv' size=20x12.
.br

7&per.1 Use Before Definition
:font facename=default size=0x0.
.br
.br
Like many static checkers, LCLint detects instances where the value of a
location is used before it is defined&per.  This analysis is done at the procedural
level&per.  If there is a path through the procedure that  
:p.
uses a local variable before it is defined, a use before definition error is
reported&per.  Use before definition checking is controlled by the :link reftype=hd res=18.:font facename='System VIO' size=14x8.usedef:font facename=default size=0x0.:elink. flag&per.
:p.
:p.
LCLint can do more checking than standard checkers though, because the
annotations can be used to describe what storage must be defined and what
storage may be undefined at interface points&per. Unannotated references are
expected to be completely defined at interface points&per.  This means all storage
reachable from a global variable, parameter to a function, or function return
value is defined before and after a function call&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

7&per.1&per.1 Undefined Parameters
:font facename=default size=0x0.
.br
.br
Sometimes, function parameters or return values are expected to reference
undefined or partially defined storage&per.  For example, a pointer parameter may
be intended only as an address to store a result, or a memory allocator may
return allocated but undefined storage&per.  The :font facename='System VIO' size=14x8.out:font facename=default size=0x0. annotation denotes a pointer
to storage that may be undefined&per.
:p.
:p.
LCLint does not report an error when a pointer to allocated but undefined
storage is passed as an :font facename='System VIO' size=14x8.out:font facename=default size=0x0. parameter&per.  Within the body of a function, LCLint
will assume an :font facename='System VIO' size=14x8.out:font facename=default size=0x0. parameter is allocated but not necessarily bound to a value,
so an error is reported if its value is used before it is defined&per.  
:p.
:p.
LCLint reports an error if storage reachable by the caller after the call is
not defined when the function returns&per.  This can be suppressed by :link reftype=hd res=18.:font facename='System VIO' size=14x8.-mustdefine:font facename=default size=0x0.:elink.&per.
When checking a call, an actual parameter corresponding to an :font facename='System VIO' size=14x8.out:font facename=default size=0x0. parameter is
assumed to be completely defined after the call returns&per.
:p.
:p.
When checking unannotated programs, many spurious use before definition errors
may be reported   If :link reftype=hd res=18.:font facename='System VIO' size=14x8.impouts:font facename=default size=0x0.:elink. is on, no error is reported when an
incompletely-defined parameter is passed to a formal parameter with no
definition annotation, and the actual parameter is assumed to be defined after
the call&per.  The :font facename='System VIO' size=14x8./*@in@*/:font facename=default size=0x0. annotation can be used to denote a parameter that must
be completely defined, even if impouts is on&per.  If impouts is off, there is an
implicit in annotation on every parameter with no definition annotation&per.


:p.
:link reftype=hd res=55.Figure 13&per.  Use before definition&per.:elink.


.br
:font facename='Tms Rmn' size=18x10.
.br

7&per.1&per.2 Relaxing Checking
:font facename=default size=0x0.
.br
.br
The reldef annotation relaxes definition checking for a particular declaration&per.
Storage declared with a reldef annotation is assumed to be defined when it is
used, but no error is reported if it is not defined before it is returned or
passed as a parameter&per.
:p.
:p.
It is up to the programmer to check reldef fields are used correctly&per.   They
should be avoided in most cases, but may be useful for fields of structures
that may or may not be defined depending on other constraints&per.  

.br
:font facename='Tms Rmn' size=18x10.
.br

7&per.1&per.3 Partially Defined Structures
:font facename=default size=0x0.
.br
.br
The partial annotated can be used to relax checking of structure fields&per.  A
structure with undefined fields may be passed as a partial parameter or
returned as a partial result&per.  Inside a function body, no error is reported
when the field of a partial structure is used&per.  After a call, all fields of a
structure that is passed as a partial parameter are assumed to be completely
defined&per.
:p.



.br
:font facename='Tms Rmn' size=18x10.
.br

7&per.1&per.4 Global Variables
:font facename=default size=0x0.
.br
.br
Special annotations can be used in the globals list of a function declaration
(:link reftype=hd res=7.Section 4&per.2:elink.) to describe the states of global variables before and after the
call&per.
:p.
:p.
If a global is preceded by undef, it is assumed to be undefined before the
call&per. Thus, no error is reported if the global is not defined when the function
is called, but an error is reported if the global is used in the function body
before it is defined&per.
:p.
:p.
The killed annotation denotes a global variable that may be undefined when the
call returns&per.  For globals that contain dynamically allocated storage, a killed
global variable is similar to an only parameter (:link reftype=hd res=8.Section 5&per.2:elink.)&per.  An error is
reported if it contains the only reference to storage that is not released
before the call returns&per.
:p.
:p.
:link reftype=hd res=56.Figure 14&per.  Annotated globals lists&per.:elink.
:p.

.br
:font facename='Helv' size=20x12.
.br

7&per.2 Null Pointers
:font facename=default size=0x0.
.br
.br
A common cause of program failures is when a null pointer is dereferenced&per.
LCLint detects these errors by distinguishing possibly NULL pointers at
interface boundaries&per.
:p.
:p.
The null annotation is used to indicate that a pointer value may be NULL&per.  A
pointer declared with no null annotation, may not be NULL&per.  If null checking is
turned on (controlled by null), LCLint will report an error when a possibly
null pointer is passed as a parameter, returned as a result, or assigned to an
external reference with no null qualifier&per.
:p.
:p.
If a pointer is declared with the null annotation, the code must check that it
is not NULL on all paths leading to the a dereference of the pointer (or the
pointer being returned or passed as a value with no null annotation)&per.
Dereferences of possibly null pointers may be protected by conditional
statements or assertions (to see how assert is declared see :link reftype=hd res=10.Section 7&per.3:elink.) that
check the pointer is not NULL&per.
:p.
:p.
Consider two implementations of firstChar in :link reftype=hd res=57.Figure 15:elink.&per. For firstChar1, LCLint
reports an error since the pointer that is dereferenced is declared with a null
annotation&per.  For firstChar2, no error is reported since the true branch of the
s == NULL if statement returns, so the dereference of s is only reached if s is
not NULL&per.
:p.
.br
:font facename='Tms Rmn' size=18x10.
.br

7&per.2&per.1 Predicate Functions
:font facename=default size=0x0.
.br
.br
Another way to protect null dereference, is to declare a function using
falsenull or truenull and call the function in a conditional statement before
the null-annotated pointer is dereferenced&per.  The falsenull and truenull
annotations may only be used on return values for functions that return a
boolean:link reftype=hd res=5.[19]:elink. result and whose first argument is
a possibly null pointer&per.
:p.
:p.
A function is annotated with :font facename='System VIO' size=14x8.truenull:font facename=default size=0x0. is assumed to return TRUE if its first
parameter is NULL and FALSE otherwise&per. For example, if isNull is declared as,
:cgraphic.
   /*@truenull@*/ bool isNull (/*@null@*/ char *x);
:ecgraphic.
we could write firstChar2&colon.
:cgraphic.
   char firstChar2 (/*@null@*/ char *s)
   {
      if (isNull (s)) return '\0';
      return *s;
   }
:ecgraphic.
No error is reported since the dereference of s is only reached if isNull(s) is
false, and since isNull is declared with the truenull annotation this means s
must not be null&per.
:p.
:p.
The :font facename='System VIO' size=14x8.falsenull:font facename=default size=0x0. annotation is not quite the opposite of truenull&per.  If a function
declared with falsenull returns TRUE, it means its parameter is not NULL&per.  If
it returns FALSE, the parameter may or may not be NULL&per.
:p.
:p.
For example, we could define isNonEmpty to return TRUE if its parameter is not
NULL and has least one character before the NUL terminator&colon.
:cgraphic.
   /*@falsenull@*/ bool isNonEmpty (/*@null@*/ char *x)
   {
     return (x != NULL &amp.&amp. *x != `\0');
   }
:ecgraphic.
LCLint does not check that the implementation of a function declared with
falsenull or truenull is consistent with its annotation, but assumes the
annotation is correct when code that calls the function is checked&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

7&per.2&per.2 Overriding Null Types
:font facename=default size=0x0.
.br
.br
The null annotation may be used in a type definition to indicate that all
instances of the type may be NULL&per.  For declarations of a type declared using
null, the null annotation in the type definition may be overridden with
notnull&per. This is particularly useful for parameters to hidden static operations
of abstract types where the null test has already been done before the function
is called, or function results of the type which are never NULL&per.  For an
abstract type, notnull may not be used for parameters to external functions,
since clients should not be aware of when the concrete representation may by
NULL&per.  Parameters to static functions in the implementation module, however,
may be declared using notnull, since they may only be called from places where
the representation is accessible&per.  Return values for static or external
functions may be declared using notnull&per. 
:p.
:p.
:link reftype=hd res=58.Figure 16&per.  Using notnull&per.:elink.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br

7&per.2&per.3 Relaxing Null Checking
:font facename=default size=0x0.
.br
.br
An additional annotation, relnull may be used to relax null checking (relnull
is analogous to reldef for definition checking)&per.  No error is reported when a
relnull value is dereferenced, or when a possibly null value is assigned to an
identifier declared using relnull&per. 
:p.
:p.
This is generally used for structure fields that may or may not be null
depending on some other constraint&per.  LCLint does not report and error when NULL
is assigned to a relnull reference, or when a relnull reference is
dereferenced&per.  It is up to the programmer to ensure that this constraint is
satisfied before the pointer is dereferenced&per.

.br
:font facename='Helv' size=20x12.
.br

7&per.3 Execution
:font facename=default size=0x0.
.br
.br
To detect certain errors and avoid spurious errors, it is important to know
something about the control flow behavior of called functions&per. Without
additional information, LCLint assumes that all functions eventually return and
execution continues normally at the call site&per.  
:p.
:p.
The exits annotation is used to denote a function that never returns&per.  For
example,
:cgraphic.
extern /*@exits@*/ void fatalerror (/*@observer@*/ char *s);
:ecgraphic.
declares fatalerror to never return&per.  This allows LCLint to correctly analyze
code like,
:cgraphic.
   if (x == NULL) fatalerror ("Yikes!");
   *x = 3;
:ecgraphic.
Other functions may exit, but sometimes (or usually) return normally&per.  The
mayexit annotation denotes a function that may or may not return&per.  This doesn't
help checking much, since LCLint must assume that a function declared with
mayexit returns normally when checking the code&per.
:p.
:p.
To be more precise, the trueexit and falseexit annotations may be used
Similar to truenull and falsenull (see :link reftype=hd res=10.Section 7&per.2&per.1:elink.), trueexit and falseexit
mean that a function always exits if the value of its first argument is TRUE or
FALSE respectively&per.  They may be used only on functions whose first argument
has a boolean type&per.  
:p.
:p.
A function declared with trueexit must exit if the value of its argument is
TRUE, and a function declared with falseexit must exit if the value of its
argument is FALSE&per.  For example, the standard library declares assert as[20]&colon.
:p.
:cgraphic.
/*@falseexit@*/ void assert (/*@sef@*/ bool /*@alt int@*/ pred);
:ecgraphic.
This way, code like,
:cgraphic.
   assert (x != NULL);
:p.
   *x = 3;
:ecgraphic.
is checked correctly, since the falseexit annotation on assert means the
deference of x is not reached is x != NULL is false&per.

.br
:font facename='Helv' size=20x12.
.br
7&per.4 Special Clauses
:font facename=default size=0x0.
.br
.br

Sometimes it is necessary to specify function interfaces at a lower
level than is possible with the standard annotations&per.  For example, if a
function defines some fields of a returned structure but does not define
all the fields&per.  The :font facename='System VIO' size=14x8./*@special@*/:font facename=default size=0x0. annotation is used to mark a
parameter, global variable, or return value that is described using
special clauses&per.  The usual implicit definition rules do not apply to a
special declaration&per.
:p.
Special clauses may be used to constrain the state of a parameter or
return value before or after a call&per.  One or more special clauses may
appear in a function declaration, before the modifies or globals
clauses&per.  Special clauses may be listed in any order, but the same
special clause should not be used more than once&per.  Parameters used in
special clauses must be annotated with :font facename='System VIO' size=14x8./*@special@*/:font facename=default size=0x0. in the function
header&per.  In a special clause list, result is used to refer to the return
value of the function&per.  If result appears in a special clause, the
function return value must be annotated with :font facename='System VIO' size=14x8./*@special@*/:font facename=default size=0x0.&per.
:p.
The following special clauses are used to describe the definition state
or parameters before and after the function is called and the return
value after the function returns&colon.
:p.

:font facename='System VIO' size=14x8./*@uses :font facename=default size=0x0.:hp3.references:ehp3.:font facename='System VIO' size=14x8.@*/:font facename=default size=0x0. 
:p.
References in the uses clause must be completely defined before the
function is called&per.  They are assumed to be defined at function entrance
when the function is checked&per.


:font facename='System VIO' size=14x8./*@sets :font facename=default size=0x0.:hp3.references:ehp3.:font facename='System VIO' size=14x8.@*/:font facename=default size=0x0.
:p.
References in the sets clause must be allocated before the function is
called&per.  They are completely defined after the function returns&per. When
the function is checked, they are assumed to be allocated at function
entrance and an error is reported if there is a path on which they are
not defined before the function returns&per.


:font facename='System VIO' size=14x8./*@defines :font facename=default size=0x0.:hp3.references:ehp3.:font facename='System VIO' size=14x8.@*/:font facename=default size=0x0.
:p.
References in the defines clause must not refer to unshared, allocated
storage before the function is called&per.  They are completely defined
after the function returns&per. When the function is checked, they are
assumed to be undefined at function entrance and an error is reported if
there is a path on which they are not defined before the function
returns&per.


:font facename='System VIO' size=14x8./*@allocates :font facename=default size=0x0.:hp3.references:ehp3.:font facename='System VIO' size=14x8.@*/:font facename=default size=0x0.
:p.
References in the allocates clause must not refer to unshared, allocated
storage before the function is called&per.  They are allocated but not
necessarily defined after the function returns&per. When the function is
checked, they are assumed to be undefined at function entrance and an
error is reported if there is a path on which they are not allocated
before the function returns&per.


:font facename='System VIO' size=14x8./*@releases :font facename=default size=0x0.:hp3.references:ehp3.:font facename='System VIO' size=14x8.@*/:font facename=default size=0x0.
:p.
References in the releases clause are deallocated by the function&per.  They
must correspond to storage which could be passed as an only parameter
before the function is called, and are dead pointers after the function
returns&per.  When the function is checked, they are assumed to be allocated
at function entrance and an error is reported if they refer to live,
allocated storage at any return point&per.

:p.

Additional generic special clauses can be used to describe other aspects
of the state of inner storage before or after a call&per.  Generic special
clauses have the form :hp3.state:ehp3.:font facename='System VIO' size=14x8.&colon.:font facename=default size=0x0.:hp3.constraint:ehp3.&per.  The
state is either :font facename='System VIO' size=14x8.pre:font facename=default size=0x0. (before the function is called), or
:font facename='System VIO' size=14x8.post:font facename=default size=0x0. (after the function is called)&per.  The constraint is similar
to an annotation&per.  The following constraints are supported&colon.

:p.
.br
:font facename='Tms Rmn' size=16x8.
.br
Aliasing Annotations:font facename=default size=0x0.
.br
.br

:font facename='System VIO' size=14x8.pre&colon.only:font facename=default size=0x0., :font facename='System VIO' size=14x8.post&colon.only:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.pre&colon.shared:font facename=default size=0x0., :font facename='System VIO' size=14x8.post&colon.shared:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.pre&colon.owned:font facename=default size=0x0., :font facename='System VIO' size=14x8.post&colon.owned:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.pre&colon.dependent:font facename=default size=0x0., :font facename='System VIO' size=14x8.post&colon.dependent:font facename=default size=0x0.
.br
:p.
References refer to :font facename='System VIO' size=14x8.only:font facename=default size=0x0., :font facename='System VIO' size=14x8.shared:font facename=default size=0x0., :font facename='System VIO' size=14x8.owned:font facename=default size=0x0. or
:font facename='System VIO' size=14x8.dependent:font facename=default size=0x0. storage before (:font facename='System VIO' size=14x8.pre:font facename=default size=0x0.) or after
(:font facename='System VIO' size=14x8.post:font facename=default size=0x0.) the call&per.


.br
:font facename='Tms Rmn' size=16x8.
.br
Exposure Annotations:font facename=default size=0x0.
.br
.br

:font facename='System VIO' size=14x8.pre&colon.observer:font facename=default size=0x0., :font facename='System VIO' size=14x8.post&colon.observer:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.pre&colon.exposed:font facename=default size=0x0., :font facename='System VIO' size=14x8.post&colon.exposed:font facename=default size=0x0.
.br
:p.

References refer to :font facename='System VIO' size=14x8.observer:font facename=default size=0x0. or :font facename='System VIO' size=14x8.exposed:font facename=default size=0x0. storage before
(:font facename='System VIO' size=14x8.pre:font facename=default size=0x0.) or after (:font facename='System VIO' size=14x8.post:font facename=default size=0x0.) the call&per.



.br
:font facename='Tms Rmn' size=16x8.
.br
Null State Annotations:font facename=default size=0x0.
.br
.br

:font facename='System VIO' size=14x8.pre&colon.isnull:font facename=default size=0x0., :font facename='System VIO' size=14x8.post&colon.isnull:font facename=default size=0x0.
:p.
References have the value :font facename='System VIO' size=14x8.NULL:font facename=default size=0x0. before (:font facename='System VIO' size=14x8.pre:font facename=default size=0x0.) or after
(:font facename='System VIO' size=14x8.post:font facename=default size=0x0.) the call&per. Note, this is not the same name or meaning as
the null annotation (which means the value may be :font facename='System VIO' size=14x8.NULL:font facename=default size=0x0.&per.)  

:font facename='System VIO' size=14x8.pre&colon.notnull:font facename=default size=0x0., :font facename='System VIO' size=14x8.post&colon.notnull:font facename=default size=0x0.
:p.
References do not have the value :font facename='System VIO' size=14x8.NULL:font facename=default size=0x0. before (:font facename='System VIO' size=14x8.pre:font facename=default size=0x0.) or
after (:font facename='System VIO' size=14x8.post:font facename=default size=0x0.) the call&per. 



Some examples of special clauses are shown in Figure 17&per. The defines clause for
:font facename='System VIO' size=14x8.record_new:font facename=default size=0x0. indicates that the :font facename='System VIO' size=14x8.id:font facename=default size=0x0. field of the
structure pointed to by the result is defined, but the :font facename='System VIO' size=14x8.name:font facename=default size=0x0.
field is not&per.  So, :font facename='System VIO' size=14x8.record_create:font facename=default size=0x0. needs to call
:font facename='System VIO' size=14x8.record_setName:font facename=default size=0x0. to define the :font facename='System VIO' size=14x8.name:font facename=default size=0x0. field&per.  Similarly,
the releases clause for :font facename='System VIO' size=14x8.record_clearName:font facename=default size=0x0. indicates that no
storage is associated with the :font facename='System VIO' size=14x8.name:font facename=default size=0x0. field of its parameter
after the return, so no failure to deallocate storage message is
produced for the call to :font facename='System VIO' size=14x8.free:font facename=default size=0x0. in :font facename='System VIO' size=14x8.record_free:font facename=default size=0x0.&per.


:cgraphic.:ecgraphic.
.br
:link reftype=hd res=11.
:elink.:artwork name='right-arrow.bmp' align=left.:artlink.:link reftype=hd res=11.:eartlink.:link reftype=hd res=11.:elink.
:link reftype=hd res=1.
:elink.:artwork name='up-arrow.bmp' align=left.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: sec8.html
:h2 res=11.LCLint User's Guide - 8&per. Macros
:font facename=default size=0x0.
:p.

.br
:font facename='Helv' size=32x20.
.br

8&per. Macros
:font facename=default size=0x0.
.br
.br
Macros are commonly used in C programs to implement constants or to mimic
functions without the overhead of a function call&per.  Macros that are used to
implement functions are a persistent source of bugs in C programs, since they
may not behave like the intended function when they are invoked with certain
parameters or used in certain syntactic contexts&per.  
:p.
:p.
LCLint eliminates most of the potential problems by detecting macros with
dangerous implementations and dangerous macro invocations&per.  Whether or not a
macro definition is checked or expanded normally depends on flag settings and
control comments (see :link reftype=hd res=11.Section 8&per.3:elink.)&per.  Stylized macros can also be used to define
control structures for iterating through many values (see :link reftype=hd res=11.Section 8&per.4:elink.)&per.

.br
:font facename='Helv' size=20x12.
.br

8&per.1 Constant Macros
:font facename=default size=0x0.
.br
.br
Macros may be used to implement constants&per.  To get type-checking for constant
macros, use the  constant syntactic comment&colon.
:cgraphic.
/*@constant null char *mstring_undefined@*/
:ecgraphic.
Declared constants are not expanded and are checked according to the
declaration&per.  A constant with a null annotation may be used as only storage&per.

.br
:font facename='Helv' size=20x12.
.br

8&per.2 Function-like Macros
:font facename=default size=0x0.
.br
.br
Using macros to imitate functions is notoriously dangerous&per.  Consider this
broken macro for squaring a number&colon.
:p.
:cgraphic.
# define square(x) x * x
:ecgraphic.
This works fine for a simple invocation like square(i)&per.  It behaves
unexpectedly, though, if it is invoked with a parameter that has a side
effect&per.
:p.
:p.
For example, :font facename='System VIO' size=14x8.square(i++):font facename=default size=0x0. expands to :font facename='System VIO' size=14x8.i++ * i++:font facename=default size=0x0.&per.  Not
only does this give the incorrect result, it has undefined behavior
since the order in which the operands are evaluated is not defined&per.  (See :link reftype=hd res=13.Section 10&per.1:elink. for more information
on how expressions exhibiting undefined evaluation order behavior are detected
by LCLint&per.)  To correct the problem we either need to rewrite the macro so that
its parameter is evaluated exactly once, or prevent clients from invoking the
macro with a parameter that has a side-effect&per.  
:p.
:p.
Another possible problem with macros is that they may produce unexpected
results because of operator precedence rules&per.  The invocation, :font facename='System VIO' size=14x8.square(i+1):font facename=default size=0x0.
expands to :font facename='System VIO' size=14x8.i+1*i+1:font facename=default size=0x0., which evaluates to :font facename='System VIO' size=14x8.i+i+1:font facename=default size=0x0. instead
of the square of :font facename='System VIO' size=14x8.i+1:font facename=default size=0x0.&per.  To
ensure the expected behavior, the macro parameter should be enclosed in
parentheses where it is used in the macro body&per.
:p.
:p.
Macros may also behave unexpectedly if they are not syntactically equivalent to
an expression&per.  Consider the macro definition,
:cgraphic.
# define incCounts()  ntotal++; ncurrent++;
:ecgraphic.
This works fine, unless it is used as a statement&per.  For example,
:cgraphic.
if (x < 3) incCounts();
:ecgraphic.
increments ntotal if :font facename='System VIO' size=14x8.x < 3:font facename=default size=0x0. but always increments ncurrent&per.
:p.
:p.
One solution is to use the comma operator to define the macro&colon.
:cgraphic.
# define incCounts()  (ntotal++, ncurrent++)
:ecgraphic.
More complicated macros can be written using a do  while construction&colon.
:p.
:cgraphic.
  # define incCounts() \
     do { ntotal++; ncurrent++; } while (FALSE)
:ecgraphic.
LCLint detects these pitfalls in macro definitions, and checks that a macro
behaves as much like a function as possible&per.  A client should only be able to
tell that a function was implemented by a macro if it attempts to use the macro
as a pointer to a function&per.
:p.
:p.
These checks are done by LCLint on a macro definition corresponding to a
function&colon.
:p.
:ul compact.
:li.Each parameter to a macro (except those declared to be side-effect free,
see :link reftype=hd res=11.Section 8&per.2&per.1:elink.) must be used exactly once in all possible executions of the
macro, so  side-effecting arguments behave as expected&per.[21]  (Controlled by :link reftype=hd res=18.:font facename='System VIO' size=14x8.macroparams:font facename=default size=0x0.:elink.&per.)
:li.A parameter to a macro may not be used as the left hand side of an
assignment expression or as the operand of an increment or decrement operator
in the macro text, since this produces non-functional behavior&per.  (Controlled by
:link reftype=hd res=18.:font facename='System VIO' size=14x8.macroassign:font facename=default size=0x0.:elink.&per.)
:li.Macro parameters must be enclosed in parentheses when they are used in
potentially dangerous contexts&per.  (Controlled by :link reftype=hd res=18.:font facename='System VIO' size=14x8.macroparens:font facename=default size=0x0.:elink.&per.)
:li.A macro definition must be syntactically equivalent to a statement when
it is invoked followed by a semicolon&per. (Controlled by :link reftype=hd res=18.:font facename='System VIO' size=14x8.macrostmt:font facename=default size=0x0.:elink.&per.)
:li.The type of the macro body must match the return type of the
corresponding function&per.  If the macro is declared with type void, its body may
have any type but the macro value may not be used&per.
:li.All variables declared in the body of a macro definition must be in the
macro variable namespace, so they do not conflict with variables in the scope
where the macro is invoked (which may be used in the macro parameters)&per.  By
default, the macro namespace is all names prefixed by m_&per.  (See :link reftype=hd res=12.Section 9&per.2:elink. for
information on controlling namespaces&per.)
:eul.
       
At the call site, a macro is checked like any other function call&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

8&per.2&per.1 Side-Effect Free Parameters
:font facename=default size=0x0.
.br
.br
Suppose we really do want to implement square as a macro, but want do so in a
safe way&per.  One way to do this is to require that it is never invoked with a
parameter that has a side-effect&per.  LCLint will check that this constraint
holds, if the parameter is annotated to be :hp1.side-effect free:ehp1.&per.  That is,
the expression corresponding to this parameter must not modify any state, so it
does not matter how many times it is evaluated&per.  The sef annotation is used to
denote a parameter that may not have any side-effects&colon.
:cgraphic.
   extern int square (/*@sef@*/ int x);
   # define square(x) ((x) *(x))
:ecgraphic.
Now, LCLint will not report an error checking the definition of square even
though x is used more than once&per.
:p.
:p.
A message will be reported, however, if square is invoked with a parameter that
has a side-effect&per.
:p.
For the code fragment,
:cgraphic.
square (i++)
:ecgraphic.
LCLint produces the message&colon.
:cgraphic.
   Parameter 1 to square is declared sef, but the argument may modify i&colon. i++
:ecgraphic.
It is also an error to pass a non-sef macro parameter as a sef macro parameter
in the body of a macro definition&per.  For example,
:cgraphic.
   extern int sumsquares (int x, int y);
   # define sumsquares(x,y) (square(x) + square(y))
:ecgraphic.
Although x only appears once in the definition of sumsquares it will be
evaluated twice since square is expanded&per. LCLint reports an error when a
non-sef macro parameter is passed as a sef parameter&per.
:p.
:p.
A parameter may be passed as a sef parameter without an error being reported,
if LCLint can determine that evaluating the parameter has no side-effects&per.  For
function calls, the modifies clause is used to determine if a side-effect is
possible&per.:link reftype=hd res=5.[22]:elink.   To prevent many spurious
errors, if the called function has no modifies clause, LCLint will report an
error only if sefuncon is on&per.  Justifiably paranoid programmers will insist on
setting sefuncon on, and will add modifies clauses to unconstrained functions
that are used in sef macro arguments&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

8&per.2&per.2 Polymorphism
:font facename=default size=0x0.
.br
.br
One problem with our new definition of square is that while the original macro
would work for parameters of any numeric type, LCLint will now report an error
is the new version is used with a non-integer parameter&per.
:p.
:p.
We can use the :font facename='System VIO' size=14x8./*@alt :font facename=default size=0x0.:hp3.type:ehp3.:font facename='System VIO' size=14x8.;,:font facename=default size=0x0.+:font facename='System VIO' size=14x8.@>:font facename=default size=0x0.
syntax to indicate that an alternate type may be used&per.  For example,
:cgraphic.
  extern int /*@alt float@*/ square (/*@sef@*/ int /*@alt float@*/ x);
  # define square(x) ((x) *(x))
:ecgraphic.
declares square for both ints and floats&per. 
:p.
Alternate types are also useful for declaring functions for which the return
value may be safely ignored (see :link reftype=hd res=13.Section 10&per.3&per.2:elink.)&per.

.br
:font facename='Helv' size=20x12.
.br

8&per.3 Controlling Macro Checking
:font facename=default size=0x0.
.br
.br
By default, LCLint expands macros normally and checks the resulting code after
macros have been expanded&per.  Flags and control comments may be used to control
which macros are expanded and which are checked as functions or constants&per.
:p.
:p.
If  the fcnmacros flag is on, LCLint assumes all macros defined with parameter
lists implement functions and checks them accordingly&per.  Parameterized macros
are not expanded and are checked as functions with unknown result and parameter
types (or using the types in the prototype, if one is given)&per.  The analogous
flag for macros that define constants is constmacros&per.  If it is on, macros with
no parameter lists are assumed to be constants, and checked accordingly&per.  The
allmacros flag sets both fcnmacros and constmacros&per.  If the macrofcndecl flag
is set, a message reports parameterized macros with no corresponding function
prototype&per.  If the macroconstdecl flag is set, a similar message reports macros
with no parameters with no corresponding constant declaration&per.
:p.
:p.
The macro checks described in the previous sections make sense only for macros
that are intended to replace functions or constants&per.  When fcnmacros or
constmacros is on, more general macros need to be marked so they will not be
checked as functions or constants, and will be expanded normally&per.  Macros which
are not meant to behave like functions should be preceded by the
:font facename='System VIO' size=14x8./*@notfunction@*/:font facename=default size=0x0. comment&per.  For example,
:cgraphic.
   /*@notfunction@*/
   # define forever for(;;)
:ecgraphic.
Macros preceded by notfunction are expanded normally before regular checking is
done&per.  If a macro that is not syntactically equivalent to a statement without a
semi-colon (e&per.g&per., a macro which enters a new scope) is not preceded by
notfunction, parse errors may result when fcnmacros or constmacros is on&per.

.br
:font facename='Helv' size=20x12.
.br

8&per.4 Iterators
:font facename=default size=0x0.
.br
.br
It is often useful to be able to execute the same code for many different
values&per.  For example, we may want to sum all elements in an intSet that
represents a set of integers&per.  If intSet is an abstract type, there is no easy
way of doing this in a client module without depending on the concrete
representation of the type&per.  Instead, we could provide such a mechanism as part
of the type's implementation&per.  We call a mechanism for looping through many
values an :hp1.iterator:ehp1.&per.
:p.
 
:p.
The C language provides no mechanism for creating user-defined iterators&per.
LCLint supports a stylized form of iterators declared using syntactic comments
and defined using macros&per.
:p.
:p.
Iterator declarations are similar to function declarations except instead of
returning a value, they assign values to their yield parameters in each
iteration&per.  For example, we could add this iterator declaration to
:font facename='System VIO' size=14x8.intSet&per.h:font facename=default size=0x0.&colon.
:cgraphic.
/*@iter intSet_elements (intSet s, yield int el);@*/
:ecgraphic.
The yield annotation means that the variable passed as the second actual
argument is declared as a local variable of type int and assigned a value in
each loop iteration&per.
.br
:font facename='Tms Rmn' size=16x8.
.br
Defining
Iterators
:font facename=default size=0x0.
.br
.br
An iterator is defined using a macro&per.  Here's one (not particularly efficient)
way of defining intSet_elements&colon.
:cgraphic.
   typedef /*@abstract@*/ struct {
      int nelements;
      int *elements;
   } intSet;
   &per.&per.&per.
   # define intSet_elements(s,m_el) \
     { int m_i; \ 
       for (m_i = (0); m_i <= ((s)->nelements); m_i++) { \
           int m_el = (s)->elements[(m_i)];

   # define end_intSet_elements }}
:ecgraphic.
Each time through the loop, the yield parameter m_el is assigned to the next
value&per.  After all values have been assigned to m_el for one iteration, the loop
terminates&per.  Variables declared by the iterator macro (including the yield
parameter) are preceded by the macro variable namespace prefix m_ (see Section
8&per.2) to avoid conflicts with variables defined in the scope where the iterator
is used&per.
.br
:font facename='Tms Rmn' size=16x8.
.br
Using
Iterators
:font facename=default size=0x0.
.br
.br
The general structure for using an iterator is,
:p.
:hp1.iter:ehp1. (:hp1.<params>:ehp1.) stmt; end_:hp1.iter:ehp1.
:p.
For example, a client could use intSet_elements to sum the elements of an
intSet&colon.
:cgraphic.
   intSet s;
   int sum = 0;
   &per.&per.&per.
   intSet_elements (s, el) { 
      sum += el; 
   } end_intSet_elements;
:ecgraphic.
The actual parameter corresponding to a yield parameter, el, is not declared in
the function scope&per.  Instead, it is declared by the iterator and assigned to an
appropriate value for each iteration&per.
:p.
:p.
LCLint will do the following checks for uses of stylized iterators&colon.
:p.
:ul compact.
:li.An invocation of the iterator :hp1.iter:ehp1. must be balanced by a
corresponding end, named end_:hp1.iter:ehp1.&per.
:li.All actual parameters must be defined, except those corresponding to
yield parameters&per.
:li.Yield parameters must be new identifiers, not declared in the current
scope or any enclosing scope&per.
:eul.

Iterators are a bit awkward to implement, but they enable compact, easily
understood client code&per.  For abstract collection types, an iterator can be used
to enable clients to operate on elements of the collection without breaking
data abstraction&per.


:cgraphic.:ecgraphic.
.br
:link reftype=hd res=12.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=12.:eartlink.:link reftype=hd res=12.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: sec9.html
:h2 res=12.LCLint User's Guide - 9&per. Naming Conventions
:font facename=default size=0x0.
:p.

.br
:font facename='Helv' size=32x20.
.br

9&per.  Naming Conventions
:font facename=default size=0x0.
.br
.br
Naming conventions tend to be a religious issue&per. Generally, it doesn't matter
too much what naming convention is followed as long as one is chosen and
followed religiously&per.  There are two kinds of naming conventions supported by
LCLint&per.  Type-based naming conventions (:link reftype=hd res=12.Section 9&per.1:elink.) constrain identifier names
according to the abstract types that are accessible where the identifier is
defined&per.  Prefix naming conventions (:link reftype=hd res=12.Section 9&per.2:elink.) constrain the initial
characters of identifier names according to what is being declared and its
scope&per.  Naming conventions may be combined or different conventions may be
selected for different kinds of identifiers&per.  In addition, LCLint supports
checking that names do not conflict with names reserved for the standard
library or implementation (:link reftype=hd res=12.Section 9&per.3:elink.) and that names are sufficiently
distinguishable from other names&per. 

.br
:font facename='Helv' size=20x12.
.br
9&per.1 Type-Based Naming Conventions
:font facename=default size=0x0.
.br
.br
Generic naming conventions constrain valid names of identifiers&per.  By limiting
valid names, namespaces may be preserved and programs may be more easily
understood since the name gives clues as to how and where the name is defined
and how it should be used&per.
:p.
:p.
Names may be constrained by the scope of the name (external, file static,
internal), the file in which the identifier is defined, the type of the
identifier, and global constraints&per.
.br
:font facename='Tms Rmn' size=18x10.
.br
9&per.1&per.1 Czech Names
:font facename=default size=0x0.
.br
.br
:p.
:hp3.Of course, this is a complete jumble to the uninitiated, and that's the joke&per.:ehp3.
.br
- Charles Simonyi, on the Hungarian naming convention

:p.
Czech:link reftype=hd res=5.[23]:elink. names denote operations and variables
of abstract types by preceding the names by :hp1.<type:ehp1.:hp1.>:ehp1._&per.  The
remainder of the name should begin with a lowercase character, but may use any
other character besides the underscore&per.  Types may be named using any
non-underscore characters&per.   
:p.
:p.
The Czech naming convention is selected by the czech flag&per.  If accessczech is
on, a function, variable, constant or iterator named
:hp1.<type>:ehp1._:hp1.<name:ehp1.:hp1.>:ehp1. has access to the abstract type
:hp1.<type>:ehp1.&per.
:p.
:p.
Reporting of violations of the Czech naming convention is controlled by
different flags depending on what is being declared&colon.
:p.
:font facename='System VIO' size=14x8.czechfcns:font facename=default size=0x0.
:p.
Functions and iterators&per.  An error is reported for a function name of the form
:hp1.<prefix>_<name>:ehp1. where :hp1.<prefix>:ehp1. is not the name
of an accessible type&per.  Note that if accessczech is on, a type named
:hp1.<prefix>:ehp1. would be accessible in a function beginning with
:hp1.<prefix>_:ehp1.&per.  If accessczech is off, an error is reported instead&per.
An error is reported for a function name that does not have an underscore if
any abstract types are accessible where the function is defined&per.

:font facename='System VIO' size=14x8.czechvars:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.czechconstants:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.czechmacros:font facename=default size=0x0.
.br
:p.
Variables, constants and expanded macros&per.  An error is reported if the
identifier name starts with :hp1.<prefix>:ehp1._ and :hp1.prefix:ehp1. is not the
name of an accessible abstract type, or if an abstract type is accessible and
the identifier name does not begin with :hp1.<type>_:ehp1. where type is the
name of an accessible abstract type&per.  If accessczech is on, the representation
of the type is visible in the constant or variable definition&per.

:font facename='System VIO' size=14x8.czechtypes:font facename=default size=0x0.
:p.
User-defined types&per.  An error is reported if a type name includes an underscore
character&per.

.br
:font facename='Tms Rmn' size=18x10.
.br
9&per.1&per.2 Slovak Names
:font facename=default size=0x0.
.br
.br
Slovak names are similar to Czech names, except they are spelled differently&per.
A Slovak name is of the form :hp1.<type><Name>:ehp1.&per.  The type prefix
may not use uppercase characters&per.  The remainder of the name starts with the
first uppercase character&per.
:p.
:p.
The slovak flag selects the Slovak naming convention&per.  Like Czech names, it may
be used with accessslovak to control access to abstract representations&per. The
slovakfcns, slovakvars, slovakconstants, and slovakmacros flags are analogous
to the similar Czech flags&per.  If slovaktype is on, an error is reported if a
type name includes an uppercase letter&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

9&per.1&per.3 Czechoslovak Names
:font facename=default size=0x0.
.br
.br
Czechoslovak names are a combination of Czech names and Slovak names&per.
Operations may be named either :hp1.<type:ehp1.:hp1.>:ehp1._ followed by any
sequence of non-underscore characters, or :hp1.<type>:ehp1. followed by an
uppercase letter and any sequence of characters&per.  Czechoslovak names have been
out of favor since 1993, but may be necessary for checking legacy code&per. The
czechoslovakfcns, czechoslovakvars, czechoslovakmacros, and
czechoslovakconstants flags are analogous to the similar Czech flags&per.  If
czechoslovaktype is on, an error is reported if a type name contains either an
uppercase letter or an underscore character&per.

.br
:font facename='Helv' size=20x12.
.br

9&per.2 Namespace Prefixes
:font facename=default size=0x0.
.br
.br
Another way to restrict names is to constrain the leading character sequences
of various kinds of identifiers&per.  For example, a the names of all user-defined
types might begin with "T" followed by an uppercase letter and all file static
names begin with an uppercase letter&per.  This may be useful for enforcing a
namespace (e&per.g&per., all names exported by the X-windows library should begin with
"X") or just making programs easier to understand by establishing an enforced
convention&per.  LCLint can be used to constrain identifiers in this way to detect
identifiers inconsistent with prefixes&per.
:p.
:p.
All namespace flags are of the form, -:hp1.<context>:ehp1.prefix
:hp1.<string>:ehp1.&per.  For example, the macro variable namespace restricting
identifiers declared in macro bodies to be preceded by "m_" would be selected
by -macrovarprefix "m_"&per.  The string may contain regular characters that may
appear in a C identifier&per.  These must match the initial characters of the
identifier name&per.  In addition, special characters (shown in Table 1) can be
used to denoted a class of characters&per.:link reftype=hd res=5.[24]:elink.  The
* character may be used at the end of a prefix string to specify the
rest of the identifier is zero or more characters matching the character
immediately before the *&per. For example, the prefix string "T&amp.*"
matches "T" or "TWINDOW" but not "Twin"&per.
:p.

:cgraphic.
^    Any uppercase letter, A-Z                                                 
&amp.    Any lowercase letter, a-z                                                 
%    Any character that is not an uppercase letter (allows lowercase           
     letters, digits and underscore)                                           
~    Any character that is not a lowercase letter (allows uppercase letters,   
     digits and underscore)                                                    
$    Any letter (a-z, A-Z)                                                     
/    Any letter or digit (A-Z, a-z, 0-9)                                       
?    Any character valid in a C identifier                                     
#    Any digit, 0-9                                                            

:ecgraphic.
:hp2.Table
1&per.  Prefix character codes&per.:ehp2.
:p.

Different prefixes can be selected for the following identifier
contexts&colon.
.br
:p. 
:font facename='System VIO' size=14x8.macrovarprefix:font facename=default size=0x0.
:p. Any variable declared inside a macro body 

:font facename='System VIO' size=14x8.uncheckedmacroprefix:font facename=default size=0x0.
:p. Any macro that is not checked as a function or constant
(see :link reftype=hd res=11.Section 8&per.4:elink.)                 

:font facename='System VIO' size=14x8.tagprefix:font facename=default size=0x0.
:p.Tags for struct, union and enum declarations  

:font facename='System VIO' size=14x8.enumprefix:font facename=default size=0x0.
:p.Members of enum types                         

:font facename='System VIO' size=14x8.typeprefix:font facename=default size=0x0.
:p.
Name of a user-defined type               

:font facename='System VIO' size=14x8.filestaticprefix:font facename=default size=0x0.
:p.Any identifier with file static scope

:font facename='System VIO' size=14x8.globvarprefix:font facename=default size=0x0.
:p.
Any variable (not of function type) with global variables scope 
      
:font facename='System VIO' size=14x8.externalprefix:font facename=default size=0x0.
:p.
Any exported identifier                       

:p.
If an identifier is in more than one of the namespace contexts, the most specific
defined namespace prefix is used (e&per.g&per., a global variable is also an exported
identifier, so if globalvarprefix is set, it is checked against the variable
name; if not, the identifier is checked against the externalprefix&per.)
:p.
:p.
For each prefix flag, a corresponding flag named
:hp1.<prefixname>:ehp1.exclude controls  whether errors are reported if
identifiers in a different namespace match the namespace prefix&per.  For example,
if macrovarprefixexclude is on, LCLint checks that no identifier that is not a
variable declared inside a macro body uses the macro variable prefix&per. 
:p.
:p.
Here is a (somewhat draconian) sample naming convention&colon.
:p.
:link reftype=hd res=18.:font facename='System VIO' size=14x8.-uncheckedmacroprefix "~*":font facename=default size=0x0.:elink.
.br
       unchecked macros have no lowercase letters 
.br
 :font facename='System VIO' size=14x8.-typeprefix
"T^&amp.*":font facename=default size=0x0.
.br
 all type typenames begin with T followed by an
uppercase letter&per.  The rest of the name is all lowercase letters&per.  
.br
:font facename='System VIO' size=14x8.+typeprefixexclude:font facename=default size=0x0.
.br
no identifier that does not name a user-defined type may begin with the
type name prefix (set above) 
.br
 :font facename='System VIO' size=14x8.-filestaticprefix"^&amp.&amp.&amp.":font facename=default size=0x0.
.br
 file static scope variables begin with an uppercase letter and
three lowercase letters
.br
 :font facename='System VIO' size=14x8.-globvarprefix "G":font facename=default size=0x0.
.br
 all global variables variables start with G 
.br
 :font facename='System VIO' size=14x8.+globvarprefixexclude:font facename=default size=0x0.
.br
no identifier that is not a global variable starts with G 
:p.  
.br
:font facename='Helv' size=20x12.
.br
  9&per.3
Naming Restrictions :font facename=default size=0x0.
.br
.br
 Additional naming
restrictions can be used to check that names do no conflict with names
reserved for the standard library, and that identifier are sufficiently
distinct (either for the compiler and linker, or for the programmer&per.)
Restrictions may be different for names that are needed by the linker
(:hp1.external:ehp1. names) and names that are only needed during
compilations (:hp1.internal:ehp1. names)&per.  Names of non-static functions and
global variables are external; all other names are internal&per.   
.br
:font facename='Tms Rmn' size=18x10.
.br
  9&per.3&per.1
Reserved Names :font facename=default size=0x0.
.br
.br
 Many names are reserved for the
implementation and standard library&per.  A complete list of reserved names
can
be
found in [:link reftype=hd res=25.vdL:elink., p&per. 126-128] or [:link reftype=hd res=1.ANSI:elink., Section 4]&per.  Some name prefixes such as str
followed by a lowercase character are reserved for future library
extensions&per.  Most C compilers do not detect naming conflicts, and they
can lead to unpredictable program behavior&per.  If ansireserved is on,
LCLint reports errors for external names that conflict with reserved
names&per.  If ansireservedinternal is on, errors are also reported for
internal names&per.   
.br
:font facename='Tms Rmn' size=18x10.
.br
  9&per.3&per.2 Distinct Identifiers :font facename=default size=0x0.
.br
.br
:p. :hp3.The decision to retain the old six-character
case-insensitive restriction on significance was most painful&per.:ehp3.
.br
- ANSI C Rationale 
 
:p. LCLint can check that identifiers
differ within a given number of characters, optionally ignoring
alphabetic case and differences between characters that look similar&per.
The number of significant characters may be different for external and
internal names&per.  
:p. 
:p. Using :font facename='System VIO' size=14x8.+distinctexternalnames:font facename=default size=0x0.
sets the number of significant characters for external names to six and
makes alphabetical case insignificant for external names&per.  This is the
minimum significance acceptable in an ANSI-conforming compiler&per.  Most
modern compilers exceed these minimums (which are particularly hard to
follow if one uses the Czech or Slovak naming convention)&per.  The number
of significant characters can be changed using the externalnamelength
:hp1.<number>:ehp1. flag&per.  If externalnamecaseinsensitive is on,
alphabetical case is ignored in comparing external names&per. LCLint reports
identifiers that differ only in alphabetic case&per. 
:p. 
:p. For internal
identifiers, a conforming compiler must recognize at least 31 characters
and treat alphabetical cases distinctly&per.  Nevertheless, it may still be
useful to check that internal names are more distinct then required by
the compiler to minimize the likelihood that identifiers are confused in
the program&per.  Analogously to external names, the internalnamelength
:hp1.<number>:ehp1. flag sets the number of significant characters in
an internal name and internalnamecaseinsensitive sets the case
sensitivity&per.  The internalnamelookalike flag further restricts
distinctions between identifiers&per.  When set, similar-looking characters
match -- the lowercase letter "l" matches the uppercase letter "I" and
the number "1"; the letter "O" or "o" matches the number "0"; "5"
matches "S"; and "2" matches "Z"&per.  Identifiers that are not distinct
except for look-alike characters will produce an error message&per.
External names are also internal names, so they must satisfy both the
external and internal distinct identifier checks&per.
:p. 
:p. Figure 18 illustrates some of the name checking
done by LCLint&per.
:p. 
:p. 

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=13.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=13.:eartlink.:link reftype=hd res=13.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: sec10.html
:h2 res=13.LCLint User's Guide - 10&per. Other Checks
:font facename=default size=0x0.
:p.


.br
:font facename='Helv' size=32x20.
.br
  10&per. Other Checks :font facename=default size=0x0.
.br
.br
 

The section describes other errors detected by LCLint that are not
directly related to extra information provided in annotations&per.  Many of
the checks are significantly improved, however, because of the extra
information that is known about the program&per.

.br
:font facename='Helv' size=20x12.
.br
 
10&per.1 Undefined Evaluation Order
:font facename=default size=0x0.
.br
.br
 

The order in which side effects take place in a C program is
not entirely defined by the code&per.  Certain execution points are known as
:hp1.sequence points:ehp1. -- a function call (after the arguments have been
evaluated), the end of a full expression (an initializer, expression in
an expression statement, the control expression of an if, switch, while
or do statement, each expression of a for statement, and the expression
in a return statement), and after the first operand or a &amp.&amp., ||,
? or , operand&per.
:p. 
:p. All side effects before a sequence point must be
complete before the sequence point, and no evaluations after the
sequence
point shall have taken place [:link reftype=hd res=25.ANSI:elink., Section 2&per.1&per.2&per.3]&per.  Between sequence
points, side effects and evaluations may take place in any order&per.
Hence, the order in which expressions or arguments are evaluated is not
specified&per.  Compilers are free to evaluate function arguments and parts
of expressions (that do not contain sequence points) in any order&per.  The
behavior of code that uses a value that is modified by another
expression that is not required to be evaluated before or after the
other use is undefined&per.
:p. 
:p. LCLint detects instances where
undetermined order of evaluation produces undefined behavior&per.  If
modifies clauses and globals lists are used, this checking is enabled in
expressions involving function calls&per. Evaluation order checking is
controlled by the evalorder flag&per.
:p. 
:p. When checking systems without
modifies and globals information, evaluation order checking may report
errors when unconstrained functions are called in procedure arguments&per.
Since LCLint has no annotations to constrain what these functions may
modify, it cannot be guaranteed that the evaluation order is defined if
another argument calls an unconstrained function or uses a global
variable or storage reachable from a parameter to the unconstrained
function&per.  Its best to add modifies and globals clauses to constrain the
unconstrained functions in ways that eliminate the possibility of
undefined behavior&per.  For large legacy systems, this may require too much
effort&per.  Instead, the :font facename='System VIO' size=14x8.-evalorderuncon:font facename=default size=0x0. flag
may be used to prevent reporting of undefined behavior due to the order
of evaluation of unconstrained functions&per. 
:p.
:p.
:link reftype=hd res=61.Figure 19&per.  Evaluation order:elink.
:p.

.br
:font facename='Helv' size=20x12.
.br
10&per.2 Problematic Control Structures
:font facename=default size=0x0.
.br
.br

A number of control structures that are syntactically legal may indicate
likely bugs in programs&per.  LCLint can detect errors involving likely
infinite loops (:link reftype=hd res=13.Section 10&per.2&per.1:elink.),
fall through cases and missing cases in switch statements (Section 10&per.2&per.2), break statements
within deeply nested loops or switches (Section 10&per.2&per.3), clauses of if, while
or for statements that are empty statements or unblocked single
statements (:link reftype=hd res=13.Section 10&per.2&per.4:elink.) and
incomplete if-else logic (:link reftype=hd res=13.Section
10&per.2&per.5:elink.)&per.  Although any of these may appear in a correct program,
depending on the programming style used they may indicate likely bugs or
style violations that should be detected and eliminated&per.

.br
:font facename='Tms Rmn' size=18x10.
.br
10&per.2&per.1 Likely Infinite Loops

:font facename=default size=0x0.
.br
.br

LCLint reports an error if it detects a loop that appears to be
infinite&per.  An error is reported for a loop which does not modify any
value used in its condition test inside the body of the loop or in the
condition test itself&per.  This checking is enhanced by modifies clauses
and globals lists since they provide more information about what global
variable may be used in the condition test and what values may be
modified by function calls in the loop body&per.
:p. 
:p.

:link reftype=hd res=62.Figure 20:elink. shows examples of infinite loops
detected by LCLint&per. An error is reported for the loop in line 14, since
neither of the values used in the loop condition (x directly and glob1
through the call to f) is modified by the body of the loop&per.  If the
declaration of g is changed to include glob1 in the modifies clause no
error is reported&per.  (In this example, if we assume the annotations are
correct, then the programmer has probably called the wrong function in
the loop body&per.  This isn't surprising, given the horrible choices of
function and variable names!)
:p.

:p.
If an unconstrained function is called within the loop body, LCLint will assume
that it modifies a value used in the condition test and not report an infinite
loop error, unless infloopsuncon is on&per.  If infloopsuncon is on, LCLint will
report infinite loop errors for loops where there is no explicit modification
of a value used in the condition test, but where they may be an undetected
modification through a call to an unconstrained function (e&per.g&per., line 15 in
:link reftype=hd res=62.Figure 20:elink.)&per.  
:p.
.br
:font facename='Tms Rmn' size=18x10.
.br
10&per.2&per.2 Switches
:font facename=default size=0x0.
.br
.br
The automatic fall-through of C switch statements is almost never the intended
behavior&per.:link reftype=hd res=5.[25]:elink.  LCLint detects case statements
with code that may fall through to the next case&per.  The casebreak flag controls
reporting of fall through cases&per.  A single fall through case may be marked by
preceding the case keyword with :font facename='System VIO' size=14x8./*@fallthrough@*/:font facename=default size=0x0. to indicate explicitly that
execution falls through to this case&per.
:p.
:p.
For switches on enum types, LCLint reports an error if a member of the
enumerator does not appear as a case in the switch body (and there is no
default case)&per.  (Controlled by :link reftype=hd res=18.:font facename='System VIO' size=14x8.misscase:font facename=default size=0x0.:elink.&per.)
:p.
:p.
An example of switch checking is shown in :link reftype=hd res=63.Figure 21:elink.&per.
.br
:font facename='Tms Rmn' size=18x10.
.br
10&per.2&per.3 Deep Breaks
:font facename=default size=0x0.
.br
.br
There is no syntax provided by C (other than goto) for breaking out of a nested
loop&per.  All break and continue statements act only on the innermost surrounding
loop or switch&per.  This often leads to serious problems[26] when a programmer intends to break the outer loop
or switch instead&per.  LCLint optionally reports errors for break and
continue statements in nested contexts&per.
:p.
:ul compact.
:li.break inside a loop (while or for) that is inside a loop&per.  Controlled by
looploopbreak&per.  To indicate that a break is inside an inner loop, precede the
break by :font facename='System VIO' size=14x8./*@innerbreak@*/:font facename=default size=0x0.&per.
:li.break inside a loop that is inside a switch statement&per.  Controlled by
switchloopbreak&per.  To mark the break as a loop break, precede the break by
:font facename='System VIO' size=14x8./*@loopbreak@*/:font facename=default size=0x0.&per.
:li.break inside a switch statement that is inside a loop&per.  Controlled by
loopswitchbreak&per.  To mark the break as a switch break, precede the break by
:font facename='System VIO' size=14x8./*@switchbreak@*/:font facename=default size=0x0.&per.
:li.break inside a switch inside another switch&per.  Controlled by
switchswitchbreak&per.  To indicate that the break is for the inner switch, use
:font facename='System VIO' size=14x8./*@innerbreak@*/:font facename=default size=0x0.&per.
:eul.


Since continue only makes sense within loops, errors are only reported for
continue statements within nested loops&per.  (Controlled by :link reftype=hd res=18.:font facename='System VIO' size=14x8.looploopcontinue:font facename=default size=0x0.:elink.&per.)  A
safe inner continue may be precede by :font facename='System VIO' size=14x8./*@innercontinue@*/:font facename=default size=0x0. to suppress error
messages locally&per. The deepbreak flag sets all nested break and continue
checking flags&per.
:p.
:p.
LCLint reports an error if the marker preceding a break is not consistent with
its effect&per.  An error is reported if innerbreak precedes a break that is not
breaking an inner loop, switchbreak precedes a break that is not breaking a
switch, or loopbreak precedes a break that is not breaking a loop&per.
.br
:font facename='Tms Rmn' size=18x10.
.br
10&per.2&per.4 Loop and If Bodies
:font facename=default size=0x0.
.br
.br
An empty statement after an if, while or for often indicates a potential bug&per.
A single statement (i&per.e&per., not a compound block) after an if, while or for is
not likely to indicate a bug, but make the code harder to read and edit&per.
LCLint can report errors for if or loop statements with empty bodies or bodies
that are not compound statements&per.  Separate flags control checking for
statements following an  if, while or for&colon.
:p.
:ul compact.
:li.[:font facename='System VIO' size=14x8.if:font facename=default size=0x0., :font facename='System VIO' size=14x8.while:font facename=default size=0x0., :font facename='System VIO' size=14x8.for:font facename=default size=0x0.]
:font facename='System VIO' size=14x8.empty:font facename=default size=0x0. --
report errors for empty bodies (e&per.g&per., :font facename='System VIO' size=14x8.if (x > 3) ;:font facename=default size=0x0.)
:li.[:font facename='System VIO' size=14x8.if:font facename=default size=0x0., :font facename='System VIO' size=14x8.while:font facename=default size=0x0., :font facename='System VIO' size=14x8.for:font facename=default size=0x0.]
:font facename='System VIO' size=14x8.block:font facename=default size=0x0. --
report errors for non-block bodies (e&per.g&per., :font facename='System VIO' size=14x8.if (x > 3) x++;:font facename=default size=0x0.)
:eul.


The if statement checks also apply to the body of the else clause&per.  An ifblock
error is not reported if the body of the else clause is an if statement, to
allow else if chains&per.  
.br
:font facename='Tms Rmn' size=18x10.
.br
10&per.2&per.5 Complete if-else Logic
:font facename=default size=0x0.
.br
.br
Although it may be perfectly reasonable in many contexts, an if-else chain with
no final else may indicate missing logic or forgetting to check error cases&per.
If :link reftype=hd res=18.:font facename='System VIO' size=14x8.elseifcomplete:font facename=default size=0x0.:elink.
is on, LCLint reports errors when an if statement that is the body of an
else clause does not have a matching else clause&per.  For example, the code,
:cgraphic.
   if (x == 0) { return "nil"; }
   else if (x == 1) { return "many"; }
:ecgraphic.
produces an error message since the second if has no matching else branch&per.
.br
:font facename='Helv' size=20x12.
.br
10&per.3 Suspicious Statements
:font facename=default size=0x0.
.br
.br

LCLint detects errors involving statements with no apparent effects (Section 10&per.3&per.1) and statements that
ignore the result of a called function (Section 10&per.3&per.2)&per.

.br
:font facename='Tms Rmn' size=18x10.
.br
10&per.3&per.1 Statements with No Effects
:font facename=default size=0x0.
.br
.br

LCLint can report errors for statements that have no effect&per.  (Controlled by
noeffect&per.)   Because of modifies clauses, LCLint can detect more errors than
traditional checkers&per.  Unless the noeffectuncon flag is on, errors are not
reported for statements that involve calls to unconstrained functions since the
unconstrained function may cause a modification&per.
:p.
:p.
:link reftype=hd res=64.Figure 22&per.  Statements with no effect&per.:elink.
:p.
.br
:font facename='Tms Rmn' size=18x10.
.br

10&per.3&per.2 Ignored Return Values
:font facename=default size=0x0.
.br
.br
LCLint reports an error when a return value is ignored&per.  Checking may be
controlled based on the type of the return value&colon. retvalint controls reporting
of ignored return values of type int, and retvalbool for return values of type
bool, and retvalothers for all other types&per.  A function statement may be cast
to void to prevent this error from being reported&per. 
:p.
:p.
Alternate types (:link reftype=hd res=11.Section 8&per.2&per.2:elink.) can be used to declare functions that return
values that may safely be ignored by declaring the result type to alternately
by void&per.  Several functions in the standard library are specified to
alternately return void to prevent ignored return value errors for standard
library functions (e&per.g&per., strcpy) where the result may be safely ignored (see
:link reftype=hd res=21.Apppendix F:elink.)&per.  
:p.
:p.
:link reftype=hd res=65.Figure 23:elink. shows example of ignored return value
errors reported by LCLint&per.
:p.

.br
:font facename='Helv' size=20x12.
.br
10&per.4 Unused Declarations
:font facename=default size=0x0.
.br
.br
LCLint detects constants, functions, parameters, variables, types, enumerator
members, and structure or union fields that are declared but never used&per.  The
flags 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.constuse:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.fcnuse:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.paramuse:font facename=default size=0x0.:elink.,
:link reftype=hd res=18.:font facename='System VIO' size=14x8.varuse:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.typeuse:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.enummemuse:font facename=default size=0x0.:elink. and
:link reftype=hd res=18.:font facename='System VIO' size=14x8.fielduse:font facename=default size=0x0.:elink. control whether
unused declaration errors are reported for each kind of declaration&per.
Errors for exported declarations are reported only if 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.topuse:font facename=default size=0x0.:elink. is on (see Section 10&per.5)&per.
:p. 
:p.
The :font facename='System VIO' size=14x8./*@unused@*/:font facename=default size=0x0. annotation can be used before a declaration to indicate that
the item declared need not be used&per.  Unused declaration errors are not reported
for identifiers declared with unused&per.

.br
:font facename='Helv' size=20x12.
.br

10&per.5 Complete Programs
:font facename=default size=0x0.
.br
.br
LCLint can be used on both complete and partial programs&per.  When checking
complete programs, additional checks can be done to ensure that every
identifier declared by the program is defined and used, and that functions that
do not need to be exported are declared static&per.
:p.
:p.
LCLint checks that all declared variables and functions are defined (controlled
by :link reftype=hd res=18.:font facename='System VIO' size=14x8.compdef:font facename=default size=0x0.:elink.)&per.
Declarations of functions and variables that are defined in an external
library, may be preceded by :font facename='System VIO' size=14x8./*@external@*/:font facename=default size=0x0. to suppress
undefined declaration errors&per.
:p. 
:p.
LCLint reports external declarations which are unused (Controlled by :link reftype=hd res=18.:font facename='System VIO' size=14x8.topuse:font facename=default size=0x0.:elink.)&per.
Which declarations are reported also depends on the declaration use flags (see
:link reftype=hd res=13.Section 10&per.4:elink.)&per.  
:p.
:p.
The :link reftype=hd res=18.:font facename='System VIO' size=14x8.partial:font facename=default size=0x0.:elink. flag sets
flags for checking a partial system&per.  Top-level unused declarations,
undefined declarations, and unnecessary external names are not reported
if :font facename='System VIO' size=14x8.partial:font facename=default size=0x0. is set&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

10&per.5&per.1 Unnecessary External Names
:font facename=default size=0x0.
.br
.br
LCLint can report variables and functions that are declared with global scope
(i&per.e&per., without using static), that are not used outside the file in which they
are defined&per.  In a stand-alone system, these identifiers should usually be
declared using static to limit their scope&per.  If the exportstatic flag is on,
LCLint will report declarations that could have file scope&per.  It should only be
used when all relevant source files are listed on the LCLint command line;
otherwise, variables and functions may be incorrectly identified as only used
in the file scope since LCLint did not process the other file in which they are
used&per.

.br
:font facename='Tms Rmn' size=18x10.
.br

10&per.5&per.2 Declarations Missing from Headers
:font facename=default size=0x0.
.br
.br
A common practice in C programming styles, is that every function or variable
exported by :hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.c:font facename=default size=0x0. is declared in :hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.h:font facename=default size=0x0.&per.  If
the :link reftype=hd res=18.:font facename='System VIO' size=14x8.exportheader:font facename=default size=0x0.:elink. flag is on, LCLint will report exported declarations in :hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.c
:font facename=default size=0x0. that are not declared in :hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.h:font facename=default size=0x0.&per.
:p.

.br
:font facename='Helv' size=20x12.
.br

10&per.6 Compiler Limits
:font facename=default size=0x0.
.br
.br
The ANSI Standard includes limits on minimum numbers that a conforming compiler
must support&per.  Whether of not a particular compiler exceeds these limits, it is
worth checking that a program does not exceed them so that it may be safely
compiled by other compilers&per.  In addition, exceeding a limit may indicate a
problem in the code (e&per.g&per., it is too complex if the control nest depth limit is
exceeded) that should be fixed regardless of the compiler&per.  The following
limits are checked by LCLint&per.  For each  limit, the maximum value may be set
from the command line (or locally using a stylized comment)&per.  If the 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.ansilimits:font facename=default size=0x0.:elink.
flag is on, all limits are checked with the minimum values of a conforming
compiler&per.
:p.
:link reftype=hd res=18.:font facename='System VIO' size=14x8.includenest:font facename=default size=0x0.:elink.
:p.
Maximum nesting depth of file inclusion (#include)&per.  (ANSI minimum is 8)

:link reftype=hd res=18.:font facename='System VIO' size=14x8.controlnestdepth:font facename=default size=0x0.:elink.
:p.
Maximum nesting of compound statements, control structures&per.  (ANSI
minimum is 15)  

:link reftype=hd res=18.:font facename='System VIO' size=14x8.numenummembers:font facename=default size=0x0.:elink.
:p.
Number of members in an enum declaration&per. (ANSI minimum is 127)

:link reftype=hd res=18.:font facename='System VIO' size=14x8.numstructfields:font facename=default size=0x0.:elink.
:p.
Number of fields in a struct or union declaration&per. (ANSI minimum is 127)

:cgraphic.






:ecgraphic.
:p.
:hp3.
Since human beings themselves are not fully debugged yet, there will be bugs in
your code no matter what you do&per.:ehp3.
.br
- Chris Mason, Zero-defects  memo (:hp1.Microsoft Secrets:ehp1., Cusumano
and Selby)


:cgraphic.:ecgraphic.
.br
:link reftype=hd res=16.
:elink.:artwork name='right-arrow.bmp' align=left.:artlink.:link reftype=hd res=16.:eartlink.:link reftype=hd res=16.:elink.
:link reftype=hd res=1.
:elink.:artwork name='up-arrow.bmp' align=left.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.

.* Source filename: appA.html
:h2 res=16.LCLint User's Guide - Appendix A  Availability
:font facename=default size=0x0.
:p.

.br
:font facename='Helv' size=20x12.
.br
Appendix A  Availability
:p.
:font facename=default size=0x0.
.br
.br
:hp2.:ehp2.The web home page for LCLint is :font facename='System VIO' size=14x8.http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/larch/lclint/index&per.html:font facename=default size=0x0.&per.
It includes this guide in postscript format, samples demonstrating LCLint, and links to related web sites&per.
:p.
:p.
LCLint can be downloaded from :font facename='System VIO' size=14x8.http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/larch/lclint/download&per.html:font facename=default size=0x0.
or obtained via anonymous ftp from :font facename='System VIO' size=14x8.ftp&colon.//larch&per.lcs&per.mit&per.edu/pub/Larch/lclint/:font facename=default size=0x0.
:p.
Several UNIX platforms are supported and source code is provided for other platforms&per.

:p.
LCLint can also be run remotely using a form at :link reftype=hd res=39.:font facename='System VIO' size=14x8.http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/larch/lclint/run&per.html:font facename=default size=0x0.:elink.
:p.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=17.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=17.:eartlink.:link reftype=hd res=17.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: appB.html
:h2 res=17.LCLint User's Guide - Appendix B  Communication
:font facename=default size=0x0.
:p.


.br
:font facename='Helv' size=20x12.
.br
Appendix B  Communication
:font facename=default size=0x0.
.br
.br

:p.
:hp2.:ehp2.LCLint development is largely driven by suggestions and comments from
users&per.  We are also very interested in hearing about your experiences using
LCLint in developing or maintaining programs, enforcing coding standards, or
teaching courses&per.  For general information, suggestions, and questions on
LCLint send mail to :link reftype=hd res=40.:font facename='System VIO' size=14x8.lclint@larch&per.lcs&per.mit&per.edu:font facename=default size=0x0.:elink.&per.
:p.
:p.
To report a bug in LCLint send a message to :link reftype=hd res=41.:font facename='System VIO' size=14x8.lclint-bug@larch&per.lcs&per.mit&per.edu:font facename=default size=0x0.:elink.&per.
:p.
:p.
There are two mailing lists associated with LCLint&colon.
:p.
:font facename='System VIO' size=14x8.lclint-announce@larch&per.lcs&per.mit&per.edu:font facename=default size=0x0.
:p.
Reserved for announcements of new releases and bug fixes&per.  (Everyone who sends
mail regarding LCLint is added to this list&per.)

:font facename='System VIO' size=14x8.lclint-interest@larch&per.lcs&per.mit&per.edu:font facename=default size=0x0.
:p.
Informal discussions on the use and development of LCLint&per.  To subscribe, send
a (human-readable) message to :font facename='System VIO' size=14x8.lclint-request@larch&per.lcs&per.mit&per.edu:font facename=default size=0x0.,
or use a form&per.
:p.

:p.
LCLint discussions relating to checks enabled by specifications or annotations
are welcome in the :link reftype=hd res=43.:font facename='System VIO' size=14x8.comp&per.specification&per.larch:font facename=default size=0x0.:elink.

usenet group&per.  Messages more focused on C-specific checking would be more
appropriate for the lclint-interest list of one of the C language groups&per.


:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: appC.html
:h2 res=18.LCLint User's Guide - Appendix C  Flags
:font facename=default size=0x0.
:p.


.br
:font facename='Helv' size=20x12.
.br
Appendix C  Flags:font facename=default size=0x0.
.br
.br
:p.

:hp2.:ehp2.Flags can be grouped into four major categories&colon. 
:p.
:ul compact.
:li.Global flags for controlling initializations and global behavior
:li.Message format flags for controlling how messages are displayed
:li.Mode selectors for coarse control of LCLint checking
:li.Checking flags that control checking and what classes of
        messages are reported
:eul.

Global flags can be used in initialization files and at the command line; all
other flags may also be used in control comments&per.


:cgraphic.:ecgraphic.
.br
:link reftype=hd res=19.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=19.:eartlink.:link reftype=hd res=19.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.




:h3 res=1801.Global Flags
:p.
:hp2.Global Flags:ehp2.
:p.
:hp2.:ehp2.Global flags can be set at the command line or in an options file, but
cannot be set locally using stylized comments&per.  These flags control on-line
help, initialization files, pre-processor flags, libraries and output&per. 
:p.

:hp2.:hp1.Help:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.On-line help provides documentation on LCLint operation and
flags&per.  When a help flag is used, no checking is done by LCLint&per.  Help flags
may be preceded by :font facename='System VIO' size=14x8.-:font facename=default size=0x0. or :font facename='System VIO' size=14x8.+:font facename=default size=0x0.&per.
:p.
:font facename='System VIO' size=14x8.help:font facename=default size=0x0.
:p.
Display general help overview, including list of additional help topics&per.

:font facename='System VIO' size=14x8.help:font facename=default size=0x0. <:hp3.topic:ehp3.>
:p.
Display help on :hp1.<topic>:ehp1.&per. Available topics&colon.
:p.
:table cols='38 38'.
:row.
:c.annotations:c.describe annotations
:row.
:c.comments:c.describe control comments
:row.
:c.flags:c.summarize flag categories
:row.
:c.flags <:hp3.category:ehp3.>:c.all flags pertaining to
<:hp3.category:ehp3.> (one of the categories listed by lclint -help
flags)         
:row.
:c.flags alpha:c.all flags in alphabetical order
:row.
:c.flags full:c.print a full description of all flags
:row.
:c.mail:c.print information on mailing lists
:row.
:c.modes:c.flags settings in modes
:row.
:c.prefixcodes:c.character codes for setting namespace prefixes
:row.
:c.references:c.print references to relevant papers and web sites
:row.
:c.vars:c.describe environment variables
:row.
:c.version:c.print maintainer and version information
:etable.


:font facename='System VIO' size=14x8.help:font facename=default size=0x0. <:hp3.flag:ehp3.>
:p.
Describe flag :hp1.<flag>:ehp1.&per.  (May list several flags&per.)

:font facename='System VIO' size=14x8.warnflags:font facename=default size=0x0.
:p.
Display a warning when a flag is set in a surprising way&per.  An error is reported
if an obsolete (LCLint Version 1&per.4 or earlier) flag is set, a flag is set to
its current value (i&per.e&per., the + or - may be wrong), or a mode selector flag is
set after mode checking flags that will be reset by the mode were set&per.  By
default, warnflags is on&per.  To suppress flag warnings, use :font facename='System VIO' size=14x8.-warnflags:font facename=default size=0x0.&per.

:p.
:hp2.:hp1.Initialization:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.These flags control directories and files used by LCLint&per.  They
may be used from the command line or in an options file, but may not be used as
control comments in the source code&per.  Except where noted&per. they have the same
meaning preceded by - or +&per.  
:p.

:font facename='System VIO' size=14x8.tmpdir:font facename=default size=0x0. :hp1.<directory>:ehp1.
:p.
:p.
Set directory for writing temp files&per.  Default is :font facename='System VIO' size=14x8./tmp/:font facename=default size=0x0.&per.


:font facename='System VIO' size=14x8.I:font facename=default size=0x0.:hp1.<directory>:ehp1.
:p.
Add directory to path searched for C include files&per.  Note there is no space
after the I, to be consistent with C preprocessor flags&per.


:font facename='System VIO' size=14x8.S:font facename=default size=0x0.:hp1.<directory>:ehp1.
:p.
Add directory to path search for &per.lcl specification files&per.

:p.
:p.

:font facename='System VIO' size=14x8.f :font facename=default size=0x0.:hp1.<file>:ehp1.
:p.
:p.
Load options file :hp1.<file>:ehp1.&per.  If this flag is used from the command
line, the default :font facename='System VIO' size=14x8.~/&per.lclintrc:font facename=default size=0x0. file is not loaded&per.  This flag may be used in an
options file to load in another options file&per.


:font facename='System VIO' size=14x8.nof:font facename=default size=0x0.
:p.
Prevents the default options files (:font facename='System VIO' size=14x8.&per./&per.lclintrc:font facename=default size=0x0. and
:font facename='System VIO' size=14x8.~/&per.lclintrc:font facename=default size=0x0.) from being loaded&per.  (Setting :font facename='System VIO' size=14x8.-nof:font facename=default size=0x0.
overrides :font facename='System VIO' size=14x8.+nof:font facename=default size=0x0., causing the options files to be loaded normally&per.)

:font facename='System VIO' size=14x8.systemdirs:font facename=default size=0x0.
:p.
Set directories for system files (default is ":font facename='System VIO' size=14x8./usr/include:font facename=default size=0x0.")&per.  Separate
directories with colons (e&per.g&per., ":font facename='System VIO' size=14x8./usr/include&colon./usr/local/lib:font facename=default size=0x0.")&per.  Flag settings
propagate to files in a system directory&per.  If :font facename='System VIO' size=14x8.-systemdirerrors:font facename=default size=0x0. is set, no
errors are reported for files in system directories&per.

:p.
:hp2.:hp1.Pre-processor:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.These flags are used to define or undefine pre-processor
constants&per.  The -I:hp1.<directory>:ehp1. flag is also passed to the C
pre-processor&per.
:p.

:font facename='System VIO' size=14x8.D:font facename=default size=0x0.<:hp3.initializer:ehp3.>
:p.
Passed to the C pre-processor&per.


:font facename='System VIO' size=14x8.U:font facename=default size=0x0.<:hp3.initializer:ehp3.>
:p.
Passed to the C pre-processor

:p.
:hp2.:hp1.Libraries:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.These flags control the creation and use of libraries&per.
:p.
:font facename='System VIO' size=14x8.dump :font facename=default size=0x0.:hp1.<file>:ehp1.
:p.
Save state in :hp1.<file>:ehp1. for loading&per.  The default extension &per.lcd is
added if :hp1.<file>:ehp1. has no extension&per.

:font facename='System VIO' size=14x8.load :font facename=default size=0x0.:hp1.<file>:ehp1.
:p.
Load state from :hp1.<file>:ehp1. (created by :font facename='System VIO' size=14x8.-dump:font facename=default size=0x0.)&per.  The default extension
:font facename='System VIO' size=14x8.&per.lcd:font facename=default size=0x0. is added if :hp1.<file>:ehp1. has no extension&per.  Only one library file
may be loaded&per.

:p.
By default, the standard library is loaded if the -load flag is not used to
load a user library&per.  If no user library is loaded, one of the following flags
may be used to select a different standard library&per.  Precede the flag by + to
load the described library (or prevent a library from being loaded using
nolib)&per.  See :link reftype=hd res=21.Apppendix F:elink. for information on the
provided libraries&per.

:p.
:font facename='System VIO' size=14x8.nolib:font facename=default size=0x0.
:p.
Do not load any library&per.  This prevents the standard library from being loaded&per.

:font facename='System VIO' size=14x8.ansi-lib:font facename=default size=0x0.
:p.
Use the ANSI standard library (selected by default)&per. 


:font facename='System VIO' size=14x8.strict-lib:font facename=default size=0x0.
:p.
Use strict version of the ANSI standard library&per.


:font facename='System VIO' size=14x8.posix-lib:font facename=default size=0x0.
:p.
Use the POSIX standard library&per.


:font facename='System VIO' size=14x8.posix-strict-lib:font facename=default size=0x0.
:p.
Use the strict version of the POSIX standard library&per.


:font facename='System VIO' size=14x8.unix-lib:font facename=default size=0x0.
:p.
Use UNIX version of standard library&per.


:font facename='System VIO' size=14x8.unix-strict-lib:font facename=default size=0x0.
:p.
Use the strict version of the UNIX standard library&per. 


:p.
:hp2.:hp1.Output:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.These flags control what additional information is printed by
LCLint&per.  Setting +:hp1.<flag>:ehp1. causes the described information to be
printed;  setting -:hp1.<flag>:ehp1. prevents it&per.  By default, all these
flags are off&per.
:p.
:font facename='System VIO' size=14x8.usestderr:font facename=default size=0x0.
:p.
Send error messages to standard error (instead of standard out)&per.

:font facename='System VIO' size=14x8.showsummary:font facename=default size=0x0.
:p.
Show a summary of all errors reported and suppressed&per.  Counts of suppressed
errors are not necessarily correct since turning a flag off may prevent some
checking from being done to save computation, and errors that are not
reported may propagate differently from when they are reported&per.

:font facename='System VIO' size=14x8.showscan:font facename=default size=0x0.
:p.
Show file names are they are processed&per.

:font facename='System VIO' size=14x8.showalluses:font facename=default size=0x0.
:p.
Show list of uses of all external identifiers sorted by number of uses&per.

:font facename='System VIO' size=14x8.stats:font facename=default size=0x0.
:p.
Display number of lines processed and checking time&per.

:font facename='System VIO' size=14x8.timedist:font facename=default size=0x0.
:p.
Display distribution of where checking time is spent&per.

:font facename='System VIO' size=14x8.quiet:font facename=default size=0x0.
:p.
Suppress herald and error count&per.  (If quiet is not set, LCLint prints out a
herald with version  information before checking begins, and a line summarizing
the total number of errors reported&per.)

:font facename='System VIO' size=14x8.whichlib:font facename=default size=0x0.
:p.
Print out the standard library filename and creation information&per.


:font facename='System VIO' size=14x8.limit :font facename=default size=0x0.:hp1.<number>:ehp1.
:p.
At most :hp1.<number>:ehp1. similar errors are reported consecutively&per.
Further errors are suppressed, and a message showing the number of suppressed
messages is printed&per.

:p.
:hp2.:hp1.Expected Errors:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.Normally, LCLint will expect to report no errors&per.  The exit
status will be success (0) if no errors are reported, and failure if any errors
are reported&per.  Flags can be used to set the expected number of reported errors&per.
Because of the provided error suppression mechanisms, these options should
probably not be used for final checking real programs but may be useful in
developing programs using make&per.
:p.
:font facename='System VIO' size=14x8.expect :font facename=default size=0x0.:hp1.<number>:ehp1.
:p.
Exactly :hp1.<number>:ehp1. code errors are expected&per.  LCLint will exit with
failure exit status unless :hp1.<number>:ehp1. code errors are
detected&per. 


:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.




:h3 res=1802.Message Format
:p.
:hp2.Message Format:ehp2.
:p.
:hp2.:ehp2.These flags control how messages are printed&per.  They may be set at the
command line, in options files, or locally in syntactic comments&per.  The linelen
and limit flags may be preceded by + or - with the same meaning; for the other
flags, + turns on the describe printing and - turns it off&per.  The box to the
left of each flag gives its default value&per.
:p.

:font facename='System VIO' size=14x8.showcolumn:font facename=default size=0x0.
:p.
Show column number where error is found&per.  Default&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.

:font facename='System VIO' size=14x8.showfunc:font facename=default size=0x0.
:p.
Show name of function (or macro) definition containing error&per.  The function
name is printed once before the first message detected in that function&per.
Default&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
:p.

:font facename='System VIO' size=14x8.showallconjs:font facename=default size=0x0.
:p.
Show all possible alternate types (see Section 8&per.2&per.2)&per.  Default&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.

:font facename='System VIO' size=14x8.hints:font facename=default size=0x0.
:p.
Provide hints describing an error and how a message may be suppressed for the
first error reported in each error class&per. Default&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.

:font facename='System VIO' size=14x8.forcehints:font facename=default size=0x0.
:p.
Provide hints for all errors reported, even if the hint has already been
displayed for the same error class&per.  Default&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.


:font facename='System VIO' size=14x8.linelen:font facename=default size=0x0. :hp1.<number>:ehp1.
:p.
Set length of maximum message line to :hp1.<number>:ehp1. characters&per.  LCLint
will split messages longer than :hp1.<number>:ehp1. characters long into
multiple lines&per.  Default&colon. :font facename='System VIO' size=14x8.80:font facename=default size=0x0.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.



:h3 res=1803.Mode Selector Flags
:p.
:hp2.Mode Selector Flags:ehp2.
:p.
:hp2.:ehp2.Mode selects flags set the mode checking flags to predefined values&per.
They provide a quick coarse-grain way of controlling what classes of errors are
reported&per. Specific checking flags may be set after a mode flag to override the
mode settings&per.  Mode flags may be used locally, however the mode settings will
override specific command line flag settings&per.  A warning is produced if a mode
flag is used after a mode checking flag has been set&per. 
:p.
:p.
These are brief descriptions to give a general idea of what each mode does&per.  To
see the complete flag settings in each mode, use lclint -help modes&per. A mode
flag has the same effect when used with either + or -&per.
:p.
:font facename='System VIO' size=14x8.weak:font facename=default size=0x0.
:p.
Weak checking, intended for typical unannotated C code&per.  No modifies checking,
macro checking, rep exposure, or clean interface checking is done&per.  Return
values of type int may be ignored&per.  The types bool, int, char and user-defined
enum types are all equivalent&per.  Old style declarations are unreported&per. 

:font facename='System VIO' size=14x8.standard:font facename=default size=0x0.
:p.
The default mode&per.  All checking done by weak, plus modifies checking, global
alias checking, use all parameters, using released storage, ignored return
values or any type, macro checking, unreachable code, infinite loops, and
fall-through cases&per.  The types bool, int and char are distinct&per.  Old style
declarations are reported&per.

 :font facename='System VIO' size=14x8.checks:font facename=default size=0x0.
:p.
Moderately strict checking&per.  All checking done by standard, plus must
modification checking, rep exposure, return alias, memory management and
complete interfaces&per.

:font facename='System VIO' size=14x8.strict:font facename=default size=0x0.
:p.
Absurdly strict checking&per.  All checking done by checks, plus modifications and
global variables used in unspecified functions, strict standard library, and
strict typing of C operators&per. A special reward will be presented to the first
person to produce a real program that produces no errors with strict checking&per.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.



:h3 res=1804.Checking Flags
:p.
:hp2.Checking Flags:ehp2.
:p.
:hp2.:ehp2.These flags control checking done by LCLint&per.  They may be set locally
using syntactic comments, from the command line, or in an options file&per.  Some
flags directly control whether a certain class of message is reported&per.
Preceding the flag by + turns reporting on, and preceding the flag by - turns
reporting off&per.  Other flags control checking less directly by determining
default values (what annotations are implicit), making types equivalent (to
prevent certain type errors), controlling representation access, etc&per.  For
these flags, the effect of + is described, and the effect of - is the opposite
(or explicitly explained if there is no clear opposite)&per.  The organization of
this section mirrors Sections 3-10&per.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.



:h4.Key
:p.
:hp2.:hp1.Key:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.Under each flag name is a flag descriptor encoding the
what kind of flag it is and its default value&per.  The descriptions are&colon.
:p.

plain&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
:p.
A plain flag&per.  The value after the colon gives the default setting
(e&per.g&per., this flag is off&per.)  


m&colon. :font facename='System VIO' size=14x8.--++:font facename=default size=0x0. 
:p.
A mode checking flag&per.  The value of the flag is set by the mode selector&per.  The
four signs give the setting in the weak, standard, checks and strict modes&per.
(e&per.g&per., this flag is off in the weak and standard modes, and on in the checks
and strict modes&per.) 


shortcut
:p.
A shortcut flag&per.  This flag sets other flags, so it has no default value&per.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.



:h4.Types
:p.
:hp2.:hp1.Types:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.Abstract Types:ehp2.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impabstract:font facename=default size=0x0.
:p.
Implicit abstract annotation for type declarations that do not use concrete&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.mutrep:font facename=default size=0x0.
:p.
Representation of mutable type has sharing semantics&per.
:p.
:hp2.Access :ehp2.(:link reftype=hd res=6.Section 3&per.1:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.accessmodule:font facename=default size=0x0.
:p.
An abstract type defined in :hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.h:font facename=default size=0x0. (or specified in :hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.lcl:font facename=default size=0x0.) is
accessible in :hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.c:font facename=default size=0x0.&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.accessfile:font facename=default size=0x0.
:p.
An abstract type named :hp1.type:ehp1. is accessible in files named
:hp1.type:ehp1.&per.:hp1.<extenstion>:ehp1.&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.accessczech:font facename=default size=0x0.
:p.
An abstract type named :hp1.type:ehp1. may be accessible in a function named
:hp1.type:ehp1._:hp1.name:ehp1.&per. (see :link reftype=hd res=12.Section 9&per.1&per.1:elink.)
:p.:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.accessslovak:font facename=default size=0x0.
:p.
An abstract type named :hp1.type:ehp1. may be accessible in a function named
:hp1.typeName:ehp1.&per.  (see :link reftype=hd res=12.Section&per.9&per.1&per.2:elink.)
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.accessczechoslovak:font facename=default size=0x0.
:p.
An abstract type named :hp1.type:ehp1. may be accessible in a function named
:hp1.type:ehp1._:hp1.name:ehp1. or :hp1.typeName:ehp1.&per.  (see :link reftype=hd res=12.Section 9&per.1&per.3:elink.)
:p.
:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.accessall:font facename=default size=0x0.
:p.
Sets accessmodule, accessfile and accessczech&per.
:p.
:hp2.Boolean Types :ehp2.(:link reftype=hd res=6.Section 3&per.3:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.These flags control the type name used to represent booleans, and
whether the boolean type is abstract&per.
:p.

:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.bool:font facename=default size=0x0.
:p.
Boolean type is an abstract type&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.bool:font facename=default size=0x0.
.br

booltype :hp1.<name:ehp1.:hp1.>:ehp1. 
:p.
Set name of boolean type to :hp1.<name>:ehp1.&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.FALSE:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.boolfalse :font facename=default size=0x0.:hp1.<name:ehp1.:hp1.>:ehp1.
:p.
Set name of boolean false to :hp1.<name>:ehp1.&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.TRUE:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.booltrue :font facename=default size=0x0.:hp1.<name:ehp1.:hp1.>:ehp1.
:p.
Set name of boolean true to :hp1.<name>:ehp1.&per.
:p.
:hp2.Predicates:ehp2.
:p.
:hp2.:ehp2.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.predboolptr:font facename=default size=0x0.
:p.
Type of condition test is a pointer&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.predboolint:font facename=default size=0x0.
:p.
Type of condition test is an integral type&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.predboolothers:font facename=default size=0x0.
:p.
Type of condition test is not a boolean, pointer or integral type&per.
:p.
:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.predbool:font facename=default size=0x0.
:p.
Sets predboolint, predboolptr and preboolothers&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.predassign:font facename=default size=0x0.
:p.
The condition test is an assignment expression&per. If an assignment is intended,
add an extra      parentheses nesting (e&per.g&per., :font facename='System VIO' size=14x8.if ((a = b)) &per.&per.&per.:font facename=default size=0x0.)&per.
:p.
:hp2.Primitive Operations:ehp2.
:p.
:hp2.:ehp2.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.ptrarith:font facename=default size=0x0.
:p.
Arithmetic involving pointer and integer&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++--:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.ptrnegate:font facename=default size=0x0.
:p.
Allow the operand of the ! operator to be a pointer&per.
:p.

:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.bitwisesigned:font facename=default size=0x0.
:p.
An operand to a bitwise operator is not an unsigned values&per.  This may
have unexpected results depending on the signed representations&per.
:p.

:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.shiftsigned:font facename=default size=0x0.
:p.
An operand to a shift operator is not unsigned values&per.  This may have
unexpected results depending on the signed representations&per.
:p.

:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.strictops:font facename=default size=0x0.
:p.
Primitive operation does not type check strictly&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.sizeoftype:font facename=default size=0x0.
:p.
Operand of sizeof operator is a type&per.  (Safer to use expression, int *x =
sizeof (*x); instead of sizeof (int)&per.)
:p.
:p.
:hp2.Format Codes:ehp2.
:p.
:hp2.:ehp2.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.formatcode:font facename=default size=0x0.
:p.
Invalid format code in format string for printflike or scanflike function&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.formattype:font facename=default size=0x0.
:p.
Type-mismatch in parameter corresponding to format code in a printflike or
scanflike function&per.
:p.
:hp2.Main:ehp2.
:p.
:hp2.:ehp2.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.maintype:font facename=default size=0x0.
:p.
Type of main does not match expected type (function returning an int, taking no
parameters or two parameters of type int and char **&per.)
:p.
:hp2.Comparisons:ehp2.
:p.

:hp2.:ehp2.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.boolcompare:font facename=default size=0x0.
:p.
Comparison between boolean values&per.  This is dangerous since there may be
multiple TRUE values if any non-zero value is interpreted at TRUE&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.realcompare:font facename=default size=0x0.
:p.
Comparison involving float or double values&per.  This is dangerous since it may
produce unexpected results because floating point representations are
inexact&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.ptrcompare:font facename=default size=0x0.
:p.
Comparison between pointer and number&per.
:p.
:hp2.Type Equivalence
:ehp2.
:p.
:hp2.:ehp2.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.+---:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.voidabstract:font facename=default size=0x0.
:p.
Allow :font facename='System VIO' size=14x8.void *:font facename=default size=0x0. to match pointers to abstract types&per.  (Casting a pointer to an
abstract type to a pointer to :font facename='System VIO' size=14x8.void:font facename=default size=0x0. is okay if :link reftype=hd res=18.:font facename='System VIO' size=14x8.+voidabstract:font facename=default size=0x0.:elink. is set&per.)
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.castfcnptr:font facename=default size=0x0.
:p.
 A pointer to a function is cast to (or used as) a pointer to void (or
vice versa)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.+---:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.forwarddecl:font facename=default size=0x0.
:p.
Forward declarations of pointers to abstract representation match abstract
type&per.
:p.

:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.imptype:font facename=default size=0x0.
:p.
A variable declaration has no explicit type&per.  The type is
implicitly int&per.
:p.

:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.incompletetype:font facename=default size=0x0.
:p.
A formal parameter is declared with an incomplete type (e&per.g&per.,
:font facename='System VIO' size=14x8.int[][]:font facename=default size=0x0.)&per.
:p.

:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.+---:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.charindex:font facename=default size=0x0.
:p.
Allow char to index arrays&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.enumindex:font facename=default size=0x0.
:p.
Allow members of enum type  to index arrays&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.+---:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.boolint:font facename=default size=0x0.
:p.
Make bool and int types equivalent&per.  (No type errors are reported when a boolean
is used where an integral type is expected and vice versa&per.) 
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.+---:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.charint:font facename=default size=0x0.
:p.
Make :font facename='System VIO' size=14x8.char:font facename=default size=0x0. and :font facename='System VIO' size=14x8.int:font facename=default size=0x0. types equivalent&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++--:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.enumint:font facename=default size=0x0.
:p.
Make :font facename='System VIO' size=14x8.enum:font facename=default size=0x0. and :font facename='System VIO' size=14x8.int:font facename=default size=0x0. types equivalent&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.+---:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.floatdouble:font facename=default size=0x0.
:p.
Make :font facename='System VIO' size=14x8.float:font facename=default size=0x0. and :font facename='System VIO' size=14x8.double:font facename=default size=0x0. types equivalent&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.ignorequals:font facename=default size=0x0.
:p.
Ignore type qualifiers (:font facename='System VIO' size=14x8.long:font facename=default size=0x0., :font facename='System VIO' size=14x8.short:font facename=default size=0x0., :font facename='System VIO' size=14x8.unsigned:font facename=default size=0x0.
)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++--:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.relaxquals:font facename=default size=0x0.
:p.
Report qualifier mismatches only if dangerous (information may be lost since a
larger type is assigned to (or passed as) a smaller one or a comparison uses
signed and unsigned values&per.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.ignoresigns:font facename=default size=0x0.
:p.
Ignore signs in type comparisons (:font facename='System VIO' size=14x8.unsigned:font facename=default size=0x0. matches :font facename='System VIO' size=14x8.signed:font facename=default size=0x0.)&per.
:p.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.longintegral:font facename=default size=0x0.
:p.
Allow :font facename='System VIO' size=14x8.long:font facename=default size=0x0. type to match an arbitrary integral type (e&per.g&per., :font facename='System VIO' size=14x8.size_t:font facename=default size=0x0.)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.+---:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.longunsignedintegral:font facename=default size=0x0.
:p.
Allow :font facename='System VIO' size=14x8.long unsigned:font facename=default size=0x0. type to match an arbitrary integral type (e&per.g&per.,
:font facename='System VIO' size=14x8.dev_t:font facename=default size=0x0.)&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.matchanyintegral:font facename=default size=0x0.
:p.
Allow any integral type to match an arbitrary integral type (e&per.g&per.,
:font facename='System VIO' size=14x8.dev_t:font facename=default size=0x0.)&per.
:p.
:p.

:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.+---:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.long-unsigned-unsigned-integral:font facename=default size=0x0.
:p.
Allow unsigned long type to match an arbitrary unsigned integral type
(e&per.g&per., :font facename='System VIO' size=14x8.size_t:font facename=default size=0x0.)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.+---:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.long-signed-integral:font facename=default size=0x0.
:p.
Allow long type to match an arbitrary signed integral type (e&per.g&per.,
:font facename='System VIO' size=14x8.ssize_t:font facename=default size=0x0.)&per.

:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.num-literal:font facename=default size=0x0.
:p.
Integer literals can be used as floats&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.char-int-literal:font facename=default size=0x0.
:p.A character constant may be used as an :font facename='System VIO' size=14x8.int:font facename=default size=0x0.&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.zeroptr:font facename=default size=0x0.
:p.
Literal :font facename='System VIO' size=14x8.0:font facename=default size=0x0. may be used as a pointer&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.relaxtypes:font facename=default size=0x0.
:p.
Allow all numeric types to match&per.
:p.
:p.
:link reftype=hd res=18.plain&colon. :elink.:font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.fullinitblock:font facename=default size=0x0.
:p.
Initializer does not set every field in the structure&per.
:p.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


:h4.Function Interfaces
:p.
:hp2.:hp1.Function Interfaces:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.Modification :ehp2.(:link reftype=hd res=7.Section 4&per.1:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.modifies:font facename=default size=0x0.
:p.
Undocumented modification of caller-visible state&per.  Without :link reftype=hd res=18.:font facename='System VIO' size=14x8.+moduncon:font facename=default size=0x0.:elink.,
modification errors are only reported in the definitions of functions declared
with a modifies clause (or specified)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.mustmod:font facename=default size=0x0.
:p.
Documented modification is not detected&per.  An object listed in the modifies
clause for a function, is not modified by the implementation&per.
:p.
:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.mod-uncon:font facename=default size=0x0.
:p.
Report modification errors in functions declared without a modifies
clause&per.(Sets :link reftype=hd res=18.:font facename='System VIO' size=14x8.modnomods:font facename=default size=0x0.:elink., :link reftype=hd res=18.:font facename='System VIO' size=14x8.mod-globs-nomods:font facename=default size=0x0.:elink. and 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.mod-strict-globs-nomods:font facename=default size=0x0.:elink.&per.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.mod-nomods:font facename=default size=0x0.
:p.
Report modification errors (not involving global variables) in functions
declared without a modifies clause&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.mod-uncon-nomods:font facename=default size=0x0.
:p.
An unconstrained function is called in a function body where  modifications are
checked&per.  Since the unconstrained function may modify anything, there may be
undetected modifications in the checked function&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.mod-internal-strict:font facename=default size=0x0.
:p.
A function that modifies :font facename='System VIO' size=14x8.internalState:font facename=default size=0x0. is called from a function that does not
list :font facename='System VIO' size=14x8.internalState:font facename=default size=0x0. in its modifies clause&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.mod-file-sys:font facename=default size=0x0.
:p.

A function modifies the file system but does not list fileSystem in its
modifies clause&per.  
:p.

:hp2.Global Variables:hp1. :ehp1.:ehp2.(:link reftype=hd res=7.Section 4&per.2:elink.):hp1.
:ehp1.
:p.
:hp1.:ehp1.Errors involving the use and modification of global and file static
variables are reported depending on flag settings, annotations where the global
variable is declared, and whether or not the function where the global is used
was declared with a globals clause&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.globs:font facename=default size=0x0.
:p.
Undocumented use of a checked global variable in a function with a globals
list&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.globuse:font facename=default size=0x0.
:p.
A global listed in the globals list is not used in the implementation&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.globnoglobs:font facename=default size=0x0.
:p.
Use of a checked global in a function with no globals list&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.internalglobs:font facename=default size=0x0.
:p.
Undocumented use of internal state (should have :font facename='System VIO' size=14x8.globals internalState:font facename=default size=0x0.)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.internalglobsnoglobs:font facename=default size=0x0.
:p.
        Use of internal state in function with no globals list&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.globstate:font facename=default size=0x0.
:p.
A function returns with global in inconsistent state (null or undefined)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.allglobs:font facename=default size=0x0.
:p.
Report use and modification errors for globals not annotated with unchecked&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.checkstrictglobs:font facename=default size=0x0.
:p.
Report use and modification errors for checkedstrict globals&per.
:p.
:hp1.Modification of Global Variables:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.modglobs:font facename=default size=0x0.
:p.
Undocumented modification of a checked global variable&per. 
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.modglobsunchecked:font facename=default size=0x0.
:p.
Undocumented modification of an unchecked global variable&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.modglobsnomods:font facename=default size=0x0.
:p.
Undocumented modification of a checked global variable in a function with no
modifies clause&per. 
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.modstrictglobsnomods:font facename=default size=0x0.
:p.
Undocumented modification of a checkedstrict global variable in a function
declared with no modifies clause&per.
:p.
:hp1.Globals Lists and Modifies Clauses:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.warnmissingglobs:font facename=default size=0x0.
:p.
Global variable used in modifies clause is not listed in globals list&per.  (The
global is added to the globals list&per.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.warnmissingglobsnoglobs:font facename=default size=0x0.
:p.
Global variable used in modifies clause of a function with no globals list&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.globsimpmodsnothing:font facename=default size=0x0.
:p.
A function declared with a globals list but no modifies clause is assumed to
modify nothing&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.modsimpnoglobs:font facename=default size=0x0.
:p.
A function declared with a modifies clause but no globals list is assumed to
use no globals&per.
:p.
:hp1.Implicit Checking Qualifiers:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impcheckedglobs:font facename=default size=0x0.
:p.
Implicit checked qualifier on global variables with no checking annotation&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impcheckedstatics:font facename=default size=0x0.
:p.
Implicit checked qualifier file static scope variables with no checking
annotation&per. 
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impcheckmodglobs:font facename=default size=0x0.
:p.
Implicit checkmod qualifier on global variables with no checking annotation&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impcheckmodstatics:font facename=default size=0x0.
:p.
Implicit checkmod qualifier file static scope variables with no checking
annotation&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impcheckedstrictglobs:font facename=default size=0x0.
:p.
Implicit checked qualifier on global variables with no checking annotation&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impcheckedstrictstatics:font facename=default size=0x0.
:p.
Implicit checked qualifier file static scope variables with no checking
annotation&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impcheckmodinternals:font facename=default size=0x0.
:p.
Implicit checkmod qualifier on function scope static variables with no checking
annotation&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impglobsweak:font facename=default size=0x0.
:p.
:hp1.Global Aliasing:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.globalias:font facename=default size=0x0.
:p.
Function returns with global aliasing external state (sets
:link reftype=hd res=18.:font facename='System VIO' size=14x8.checkstrictglobalias:font facename=default size=0x0.:elink., :link reftype=hd res=18.:font facename='System VIO' size=14x8.checkedglobalias:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.checkmodglobalias:font facename=default size=0x0.:elink. and
:link reftype=hd res=18.:font facename='System VIO' size=14x8.uncheckedglobalias:font facename=default size=0x0.:elink.)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.checkstrictglobalias:font facename=default size=0x0.
:p.
Function returns with a checkstrict global aliasing external state&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.checkedglobalias:font facename=default size=0x0.
:p.
Function returns with a checked global aliasing external state&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.checkmodglobalias:font facename=default size=0x0.
:p.
Function returns with a checkmod global aliasing external state&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.uncheckedglobalias:font facename=default size=0x0.
:p.
Function returns with an unchecked global aliasing external state&per.
:p.
:hp2.Declaration Consistency :ehp2.:hp1.(:link reftype=hd res=7.Section 4&per.3:elink.):ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.incondefs:font facename=default size=0x0.
:p.
Identifier redeclared or redefined with inconsistent type&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.incondefslib:font facename=default size=0x0.
:p.
Identifier defined in a library is redefined with inconsistent :font facename='System VIO' size=14x8.type:font facename=default size=0x0.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.overload:font facename=default size=0x0.
:p.
Standard library function overloaded&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.matchfields:font facename=default size=0x0.
:p.
A struct or enum type is redefined with inconsistent fields or members&per.
:p.
:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


:h4.Memory Management
:p.
:hp2.:hp1.Memory Management:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.Reporting of memory management errors is controlled by flags
setting checking and implicit annotations and code annotations&per.  
:p.
:hp2.Deallocation Errors :ehp2.(:link reftype=hd res=8.Section 5&per.2:elink.):hp2.:hp1.:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.usereleased:font facename=default size=0x0.
:p.
Storage used after it may have been released&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.strictusereleased:font facename=default size=0x0.
:p.
An array element used after it may have been released&per.
:p.
:hp2.Inconsistent Branches:ehp2.
:p.
:hp2.:ehp2.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.branchstate:font facename=default size=0x0.
:p.
Storage has inconsistent states of alternate paths through a branch (e&per.g&per., it
is released in the true branch of an if-statement, but there is no else
branch&per.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.strictbranchstate:font facename=default size=0x0.
:p.
Storage through array fetch has inconsistent states of alternate paths through
a branch&per.  Since array elements are not checked accurately, this may lead to
spurious errors&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.deparrays:font facename=default size=0x0.
:p.
Treat array elements as dependent storage&per.  Checking of array elements cannot
be done accurately by LCLint&per.  If deparrays is not set, array elements are
assumed to be independent, so code that releases the same element more than
once will produce no error&per.  If deparrays is set, array elements are assumed to
be dependent, so code that releases the same element more that once will
produce an error, but so will code that releases different elements correctly
will produce a spurious error&per.
:p.
:hp2.Memory Leaks:ehp2.
:p.
:hp2.:ehp2.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.mustfree:font facename=default size=0x0.
:p.
Allocated storage was not released before return or scope exit  Errors are
reported for only, fresh or owned storage&per.
:p.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.compdestroy:font facename=default size=0x0.
:p.
All only references derivable from out only parameter of type void * must be
released&per.  (This is the type of the parameter to free, but may also be used for
user-defined deallocation functions&per.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.strictdestroy:font facename=default size=0x0.
:p.
Report complete destruction errors for array elements that may have been
released&per.  (If strictdestroy is not set, LCLint will assume that if any array
element was released, the entire array was correctly released&per.)
:p.
:p.
:hp2.Transfer Errors :ehp2.
:p.
:hp2.:ehp2.A transfer error is reported when storage is transferred (by an
assignment, passing a parameter, or returning) in a way that is inconsistent&per.
:p.
:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.memtrans:font facename=default size=0x0.
:p.
Sets all memory transfer errors flags&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.onlytrans:font facename=default size=0x0.
:p.
Only storage transferred to non-only reference (memory leak)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.ownedtrans:font facename=default size=0x0.
:p.
Owned storage transferred to non-owned reference (memory leak)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.freshtrans:font facename=default size=0x0.
:p.
Newly-allocated storage transferred to non-only reference (memory leak)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.sharedtrans:font facename=default size=0x0.
:p.
Shared storage transferred to non-shared reference&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.dependenttrans:font facename=default size=0x0.
:p.
Inconsistent dependent transfer&per. Dependent storage is transferred to a
non-dependent reference&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.temptrans:font facename=default size=0x0.
:p.
Temporary storage (associated with a temp formal parameter) is transferred to a
non-temporary reference&per.  The storage may be released or new aliases created&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.kepttrans:font facename=default size=0x0.
:p.
Kept storage transferred to non-temporary reference&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.keeptrans:font facename=default size=0x0.
:p.
Keep storage is transferred in a way that may add a new alias to it, or release
it&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.refcounttrans:font facename=default size=0x0.
:p.
Reference counted storage is transferred in an inconsistent way&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.newreftrans:font facename=default size=0x0.
:p.
A new reference transferred to a reference counted reference (reference count
is not set correctly)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.immediatetrans:font facename=default size=0x0.
:p.
An immediate address (result of &amp.) is transferred inconsistently&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.statictrans:font facename=default size=0x0.
:p.
Static storage is transferred in an inconsistent way&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.exposetrans:font facename=default size=0x0.
:p.
Inconsistent exposure transfer&per. Exposed storage is transferred to a
non-exposed, non-observer reference&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.observertrans:font facename=default size=0x0.
:p.
Inconsistent observer transfer&per. Observer storage is transferred to a
non-observer reference&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.unqualifiedtrans:font facename=default size=0x0.
:p.
Unqualified storage is transferred in an inconsistent way&per.
:p.

:hp1.Initializers:ehp1.
:p.
:link reftype=hd res=18.m&colon.:elink. :font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.onlyunqglobaltrans:font facename=default size=0x0.
:p.

Only storage transferred to an unqualified global or static reference&per.
This may lead to a memory leak, since the new reference is not
necessarily released&per.
:p.
:link reftype=hd res=18.m&colon.:elink. :font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.staticinittrans:font facename=default size=0x0.
:p.
Static storage is used as an initial value in an inconsistent way&per.
:p.
:link reftype=hd res=18.m&colon.:elink. :font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.unqualifiedinittrans:font facename=default size=0x0.
:p.
Unqualified storage is used as an initial value in an inconsistent way&per.
:p.

:hp1.Derived Storage:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.compmempass:font facename=default size=0x0.
:p.
Storage derivable from a parameter does not match the alias kind expected for
the formal parameter&per.
:p.
:hp1.Stack References:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.stackref:font facename=default size=0x0.
:p.
A stack reference is pointed to by an external reference when the function
returns&per.  Since the call frame will be destroyed when the function returns the
return value will point to dead storage&per. (:link reftype=hd res=8.Section 5&per.2&per.6:elink.)
:p.
:hp2.Implicit Memory Annotations :ehp2.(:link reftype=hd res=8.Section 5&per.3:elink.):hp1.:ehp1.
:p.
:hp1.:ehp1.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.globimponly:font facename=default size=0x0.
:p.
Assume unannotated global storage is only&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.paramimptemp:font facename=default size=0x0.
:p.
Assume unannotated parameter is temp&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.retimponly:font facename=default size=0x0.
:p.
Assume unannotated returned storage is only&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.structimponly:font facename=default size=0x0.
:p.
Assume unannotated structure or union field is only&per.
:p.
:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.codeimponly:font facename=default size=0x0.
:p.
Sets globimponly, retimponly and structimponly&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.memimp:font facename=default size=0x0.
:p.
Report memory errors for unqualified storage&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.passunknown:font facename=default size=0x0.
:p.
Passing a value as an unannotated parameter clears its annotation&per.  This will
prevent many spurious errors from being report for unannotated programs, but
eliminates the possibility of detecting many errors&per.
:p.
:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.

:h4.Sharing
:p.
:hp2.:hp1.Sharing:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.Aliasing :ehp2.(:link reftype=hd res=9.Section 6:elink.):hp1.:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.aliasunique:font facename=default size=0x0.
:p.
A actual parameter that is passed as a unique formal parameter is aliased by
another parameter or global variable&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.mayaliasunique:font facename=default size=0x0.
:p.
A actual parameter that is passed as a unique formal parameter may be aliased
by another parameter or global variable&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.mustnotalias:font facename=default size=0x0.
:p.
An alias has been added to a temp-qualifier parameter or global that is visible
externally when the function returns&per.  
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.retalias:font facename=default size=0x0.
:p.
A function returns an alias to parameter or global&per.
:p.
:hp2.Exposure :ehp2.(:link reftype=hd res=9.Section 6&per.2:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.repexpose:font facename=default size=0x0.
:p.
The internal representation of an abstract type is visible to the caller&per.  This
means clients may have access to a pointer into the abstract representation&per.
(Sets assignexpose, retexpose, and castexpose&per.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.assignexpose:font facename=default size=0x0.
:p.
Abstract representation is exposed by an assignment or passed parameter&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.castexpose:font facename=default size=0x0.
:p.
Abstract representation is exposed through a cast&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.retexpose:font facename=default size=0x0.
:p.
Abstract representation is exposed by a return value&per.
:p.
:hp1.Observer Modifications:ehp1.
:p.
:hp1.:ehp1.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.modobserver:font facename=default size=0x0.
:p.
Possible modification of observer storage&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.modobserveruncon:font facename=default size=0x0.
:p.
Storage declared with observer may be modified through a call to an
unconstrained function&per.
:p.
:hp1.String Literals  :ehp1.(:link reftype=hd res=9.Section 6&per.2&per.1:elink.):hp1. :ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.readonlytrans:font facename=default size=0x0.
:p.
Report memory transfer errors for initializations to read-only string literals
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.readonlystrings:font facename=default size=0x0.
:p.
String literals are read-only (ANSI semantics)&per.  An error is reported if a
string literal may be modified or released&per.
:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.

:h4.Use Before Definition
:p.
:hp2.:hp1.Use Before Definition :ehp1.:ehp2.(:link reftype=hd res=10.Section 7&per.1:elink.):hp1.:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.usedef:font facename=default size=0x0.
:p.
The value of a location that may not be initialized on some execution path is
used&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impouts:font facename=default size=0x0.
:p.
Allow unannotated pointer parameters to functions to be implicit out
parameters&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.compdef:font facename=default size=0x0.
:p.
Storage derivable from a parameter, return value or global variable is not
completely defined&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.uniondef:font facename=default size=0x0.
:p.
No field of a union is defined&per.  (No error is reported if at least one union
field is defined&per.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.mustdefine:font facename=default size=0x0.
:p.
Parameter declared with out is not defined before return or scope exit&per.
:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


:h4.Null Pointers
:p.
:hp2.:hp1.Null Pointers :ehp1.:ehp2.(:link reftype=hd res=10.Section 7&per.2:elink.):hp2.:hp1.:ehp1.:ehp2.
:p.

:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.nullderef:font facename=default size=0x0.
:p.
A possibly null pointer may be dereferenced&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.nullpass:font facename=default size=0x0.
:p.
A possibly null pointer is passed as a parameter not annotated with :font facename='System VIO' size=14x8.null:font facename=default size=0x0.&per.

:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.nullret:font facename=default size=0x0.
:p.
A possibly null pointer is return as a result not annotated with
:font facename='System VIO' size=14x8.null:font facename=default size=0x0.&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.nullstate:font facename=default size=0x0.
:p.
Possibly null pointer reachable from a reference with no null
annotation&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.nullassign:font facename=default size=0x0.
:p.
:p.
Inconsistent assignment or initialization involving null pointer&per.
:p.
:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.null:font facename=default size=0x0.
:p.
Sets all null checking flags&per.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.

:h4.Macros
:p.
:hp2.:hp1.Macros :ehp1.:ehp2.(:link reftype=hd res=11.Section 8:elink.):hp2.:hp1.:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.These flags control expansion and checking of macro definitions
and invocations&per.
:p.
:hp2.Macro Expansion:ehp2.
:p.
:hp2.:ehp2.These flags control which macros are checked as functions or constants,
and which are expanded in the pre-processing phase&per.  Macros preceded by
:font facename='System VIO' size=14x8./*@notfunction@*/:font facename=default size=0x0. are never expanded regardless of these flag settings&per.  These
flags may be used in source-file control comments&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.fcnmacros:font facename=default size=0x0.
:p.
Macros defined with parameter lists are not expanded and are checked as
functions&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.constmacros:font facename=default size=0x0.
:p.
Macros defined without parameter lists are not expanded and are checked as
constants&per.
:p.
:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.allmacros:font facename=default size=0x0.
:p.
Sets allfcnmacros and allconstmacros&per.
:p.
:p.

:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.libmacros:font facename=default size=0x0.
:p.
Macros defining identifiers declared in a loaded library are not expanded and
are checked according to the library information&per.       
:p.
:hp2.Macro Definitions:ehp2.
:p.
:hp2.:ehp2.These flags control what errors are reported in macro definitions&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.macrostmt:font facename=default size=0x0.
:p.
Macro definition is not syntactically equivalent to function&per.  This means if
the macro is used as a statement (e&per.g&per., :font facename='System VIO' size=14x8.if (test) macro();:font facename=default size=0x0.) unexpected behavior
may result&per.  One fix is to surround the macro body with :font facename='System VIO' size=14x8.do { &per.&per.&per.; } while
(FALSE):font facename=default size=0x0.&per. 
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.macroparams:font facename=default size=0x0.
:p.
A macro parameter is not used exactly once in all possible invocations of the
macro&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.macroassign:font facename=default size=0x0.
:p.
A macro parameter is used as the left side of an assignment expression&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.macroparens:font facename=default size=0x0.
:p.
A macro parameter is used without parentheses (in potentially dangerous
context)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.macroempty:font facename=default size=0x0.
:p.
Macro definition of a function is empty&per.   
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.macroredef:font facename=default size=0x0.
:p.
Macro is redefined&per.  There is another macro defined with the same name&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
macrounrecog 
:p.
An unrecognized identifier appears in a macro definition&per.  Since the identifier
may be defined where the macro is used, this could be okay, but LCLint will not
be able to check the unrecognized identifier appropriately&per.
:p.
:hp1.Corresponding Declarations:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.macromatchname:font facename=default size=0x0.
:p.
A iter or constant macro is defined using a different name from the one used in
the previous syntactic comment&per.
:p.
:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.macrodecl:font facename=default size=0x0.
:p.
A macro definition has no corresponding declaration&per.  (Sets macrofcndecl and
macroconstdecl&per.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.macrofcndecl:font facename=default size=0x0.
:p.
Macro definition with parameter list has no corresponding function prototype&per.
Without a prototype, the types of the macro result and parameters is unknown&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.macroconstdecl:font facename=default size=0x0.
:p.
A macro definition without parameter list has no corresponding constant
declaration&per.    
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.nextlinemacros:font facename=default size=0x0.
:p.
A constant or iter declaration is not immediately followed by a macro
definition&per.
:p.
:hp2.Side-Effect Free Parameters :ehp2.(:link reftype=hd res=11.Section 8&per.2&per.1:elink.):hp1.:ehp1.
:p.
:hp1.:ehp1.These flags control error reporting for parameters with inconsistent
side-effects in invocations of checked function macros and function calls&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.sefparams:font facename=default size=0x0.
:p.
An actual parameter with side-effects is passed as a formal parameter declared
with :font facename='System VIO' size=14x8.sef:font facename=default size=0x0.&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.sefuncon:font facename=default size=0x0.
:p.
An actual parameter involving a call to an unconstrained function (declared
without modifies clause) that may modify anything is passed as a :font facename='System VIO' size=14x8.sef:font facename=default size=0x0. parameter&per.
:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.

:h4.Iterators
:p.
:hp2.:hp1.Iterators:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.hasyield:font facename=default size=0x0.
:p.
An iterator has been declared with no parameters annotated with yield&per.
:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.

:h4.Naming Conventions
:p.
:hp2.:hp1.Naming Conventions:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.namechecks:font facename=default size=0x0.
:p.
 Turns all name checking on or off without changing other settings&per.
:p.
:hp2.Type-Based Naming Conventions :ehp2.(:link reftype=hd res=12.Section 9&per.1:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.:hp1.Czech Naming Convention:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.czech:font facename=default size=0x0.
:p.
Selects complete Czech naming convention (sets 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.accessczech:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.czechfcns:font facename=default size=0x0.:elink.,
:link reftype=hd res=18.:font facename='System VIO' size=14x8.czechvars:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.czechconsts:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.czechmacros:font facename=default size=0x0.:elink., and 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.czechtypes:font facename=default size=0x0.:elink.)&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.accessczech:font facename=default size=0x0.
:p.
Allow access to abstract types following Czech naming convention&per.  The
representation of an abstract type named :hp1.t:ehp1. is accessible in the
definition of a function or constant named :hp1.t_name:ehp1.&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.czechfcns:font facename=default size=0x0.
:p.
Function or iterator name is not consistent with Czech naming convention&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.czechvars:font facename=default size=0x0.
:p.
 Variable name is not consistent with Czech naming convention&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.czechmacros:font facename=default size=0x0.
:p.
 Expanded macro name is not consistent with Czech naming convention&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.czechconsts:font facename=default size=0x0.
:p.
Constant name is not consistent with Czech naming convention&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.czechtypes:font facename=default size=0x0.
:p.
 Type name is not consistent with Czech naming convention&per.  Czech type names
must not use the underscore character&per.
:p.
:hp1.Slovak Naming Convention:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.slovak:font facename=default size=0x0.
:p.
Selects complete Slovak naming convention (sets 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.accessslovak:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.slovakfcns:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.slovakvars:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.slovakconsts:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.slovakmacros:font facename=default size=0x0.:elink.,  and 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.slovaktypes:font facename=default size=0x0.:elink.)&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.accessslovak:font facename=default size=0x0.
:p.
Allow access to abstract types following Slovak naming convention&per. The
representation of an abstract type named :hp1.t:ehp1. is accessible in the
definition of a function or constant named :hp1.tName:ehp1.&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.slovakfcns:font facename=default size=0x0.
:p.
Function or iterator name is not consistent with Slovak naming convention&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.slovakmacros:font facename=default size=0x0.
:p.
Expanded macro name is not consistent with Slovak naming convention&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.slovakvars:font facename=default size=0x0.
:p.
 Variable name is not consistent with Slovak naming convention&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.slovakconsts:font facename=default size=0x0.
:p.
 Constant name is not consistent with Slovak naming convention&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.slovaktypes:font facename=default size=0x0.
:p.
Type name is not consistent with Slovak naming convention&per.  Slovak type names
may not include uppercase letters&per.
:p.
:p.
:p.
:p.
:hp1.Czechoslovak Naming Convention:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.czechoslovak:font facename=default size=0x0.
:p.
Selects complete Czechoslovak naming convention (sets 
:font facename='System VIO' size=14x8.accessczechoslovak:font facename=default size=0x0.,
:link reftype=hd res=18.:font facename='System VIO' size=14x8.czechoslovakfcns:font facename=default size=0x0.:elink.,
:link reftype=hd res=18.:font facename='System VIO' size=14x8.czechoslovakvars:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.czechoslovakconsts:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.czechoslovakmacros:font facename=default size=0x0.:elink., and
:link reftype=hd res=18.:font facename='System VIO' size=14x8.czechoslovaktypes:font facename=default size=0x0.:elink.)&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.accessczechoslovak:font facename=default size=0x0.
:p.
Allow access to abstract types by Czechoslovak naming convention&per. The
representation of an abstract type named :hp1.t:ehp1. is accessible in the
definition of a function or constant named :hp1.t_name:ehp1. or :hp1.tName:ehp1.&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.czechoslovakfcns:font facename=default size=0x0.
:p.
 Function name is not consistent with Czechoslovak naming convention&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.czechoslovakmacros:font facename=default size=0x0.
:p.
Expanded macro name is not consistent with Czechoslovak naming convention&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.czechoslovakvars:font facename=default size=0x0.
:p.
 Variable name is not consistent with Czechoslovak naming convention&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.czechoslovakconsts:font facename=default size=0x0.
:p.
 Constant name is not consistent with Czechoslovak naming convention&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.czechoslovaktypes:font facename=default size=0x0.
:p.
 Type name is not consistent with Czechoslovak naming convention&per. Czechoslovak
type names may not include uppercase letters or the underscore character&per.
:p.
:hp2.Namespace Prefixes  :ehp2.(:link reftype=hd res=12.Section
9&per.2:elink.)
:p.

:font facename='System VIO' size=14x8.macrovarprefix :font facename=default size=0x0.:hp1.<prefix string>:ehp1.
:p.
Set namespace prefix for variables declared in a macro body&per.  (Default is
m_&per.)
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.macrovarprefixexclude:font facename=default size=0x0.
:p.
A variable declared outside a macro body starts with the macrovarprefix&per.
:p.

:font facename='System VIO' size=14x8.tagprefix :font facename=default size=0x0.:hp1.<prefix string>:ehp1.
:p.
Set namespace prefix of struct, union or enum tag identifiers&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.tagprefixexclude:font facename=default size=0x0.
:p.
 An identifier that is not a tag starts with the tagprefix&per.
:p.

:font facename='System VIO' size=14x8.enumprefix :font facename=default size=0x0.:hp1.<prefix string>:ehp1.
:p.
Set namespace prefix for enum members&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.enumprefixexclude:font facename=default size=0x0.
:p.
 An identifier that is not an enum member starts with the enumprefix&per.
:p.

:font facename='System VIO' size=14x8.filestaticprefix :font facename=default size=0x0.:hp1.<prefix string>:ehp1.
:p.
Set namespace prefix for file static declarations&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.filestaticprefixexclude:font facename=default size=0x0.
:p.
An identifier that is not file static starts with the filestaticprefix&per.
:p.

:font facename='System VIO' size=14x8.globalprefix :font facename=default size=0x0.:hp1.<prefix string>:ehp1.
:p.
Set namespace prefix for global variables&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.globalprefixexclude:font facename=default size=0x0.
:p.
An identifier that is not a global variable starts with the globalprefix&per.
:p.

:font facename='System VIO' size=14x8.typeprefix :font facename=default size=0x0.:hp1.<prefix string>:ehp1.
:p.
Set namespace prefix for user-defined types&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.typeprefixexclude:font facename=default size=0x0.
:p.
An identifier that is not a type name starts with the typeprefix&per.
:p.

:font facename='System VIO' size=14x8.externalprefix :font facename=default size=0x0.:hp1.<prefix string>:ehp1.
:p.
Set namespace prefix for external identifiers&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.externalprefixexclude:font facename=default size=0x0.
:p.
An identifier that is not external starts with the externalprefix&per.
:p.

:font facename='System VIO' size=14x8.localprefix :font facename=default size=0x0.:hp1.<prefix string>:ehp1.
:p.
Set namespace prefix for local variables&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.localprefixexclude:font facename=default size=0x0.
:p.
 An identifier that is not a local variable starts with the localprefix&per.
:p.

:font facename='System VIO' size=14x8.uncheckedmacroprefix :font facename=default size=0x0.:hp1.<prefix string>:ehp1.
:p.
:hp1.:ehp1.Set namespace prefix for unchecked macros&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.uncheckedmacroprefixexclude:font facename=default size=0x0.
:p.
An identifier that is not the name of an unchecked macro starts with the
uncheckedmacroprefix&per.
:p.

:font facename='System VIO' size=14x8.constprefix :font facename=default size=0x0.:hp1.<prefix string>:ehp1.
:p.
Set namespace prefix for constants&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.constprefixexclude:font facename=default size=0x0.
:p.
An identifier that is not a constant starts with the constantprefix&per.
:p.

:font facename='System VIO' size=14x8.iterprefix :font facename=default size=0x0.:hp1.<prefix string>:ehp1.
:p.
Set namespace prefix for iterators&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.iterprefixexclude:font facename=default size=0x0.
:p.
An identifier that is not a iter starts with the iterprefix&per.
:p.


:font facename='System VIO' size=14x8.proto-param-prefix :font facename=default size=0x0.:hp1.<prefix string>:ehp1.
:p.
Set namespace prefix for parameters in function prototypes&per.
:p.

:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.proto-param-prefix-exclude:font facename=default size=0x0.
:p.
An identifier that is not a parameter in a function prototype starts with the 
protoprarmprefix&per. 
:p.

:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.proto-param-name:font facename=default size=0x0.
:p.
A parameter in a function prototype has a name (can interfere with macro
definitions)&per. 
:p.

:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.proto-param-match:font facename=default size=0x0.
:p.

The name of a parameter in a function definition does not match the
corresponding name of the parameter in a function prototype (after
removing the protoparamprefix)&per.
:p.

:hp2.Naming Restrictions  :ehp2.(:link reftype=hd res=12.Section 9&per.3:elink.):hp1.:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.shadow:font facename=default size=0x0.
:p.
Declaration reuses name visible in outer scope&per.
:p.
:hp1.Reserved Names:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.ansi-reserved:font facename=default size=0x0.
:p.
External name conflicts with name reserved for the compiler or standard
library&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.ansi-reserved-internal:font facename=default size=0x0.
:p.
 Internal name conflicts with name reserved for the compiler or standard
library&per.
:p.

:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.cpp-names:font facename=default size=0x0.
:p.
Internal or external name conflicts with a C++ reserved word&per.  (Will
cause problems if program is compiled with a C++ compiler&per.)
:p.

:hp1.Distinct External Names:ehp1.
:p.
:hp1.:ehp1.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.distinct-external-names:font facename=default size=0x0.
:p.
An external name is not distinguishable from another external name using
externalnamelen significant characters&per.
:p.

:font facename='System VIO' size=14x8.external-name-len:font facename=default size=0x0.:hp1.<number>:ehp1.
:p.
Sets the number of significant characters in an external name (ANSI default
minimum is 6)&per.  Sets :link reftype=hd res=18.:font facename='System VIO' size=14x8.+distinctexternalnames:font facename=default size=0x0.:elink.&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.external-name-case-insensitive:font facename=default size=0x0.
:p.
Make alphabetic case insignificant in external names&per.  According to ANSI
standard, case need not be significant in an external name&per.  If
:link reftype=hd res=18.:font facename='System VIO' size=14x8.+distinctexternalnames:font facename=default size=0x0.:elink. is not set, sets :link reftype=hd res=18.:font facename='System VIO' size=14x8.+distinctexternalnames
:font facename=default size=0x0.:elink. with unlimited
external name length&per.
:p.
:hp1.Distinct Internal Names:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.distinct-internal-names:font facename=default size=0x0.
:p.
An internal name is not distinguishable from another internal name using
internalnamelen significant characters&per.   (Also effected by
internalnamecaseinsensitive and internalnamelookalike&per.)
:p.

:font facename='System VIO' size=14x8.internal-name-len :font facename=default size=0x0.:hp1.<number>:ehp1.
:p.
Set the number of significant characters in an internal name&per. Sets
:link reftype=hd res=18.:font facename='System VIO' size=14x8.+distinctinternalnames:font facename=default size=0x0.:elink.&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.internal-name-case-insensitive:font facename=default size=0x0.
:p.
Set whether case is significant an internal names (-internalnamecaseinsensitive
means case is significant)&per.  If :link reftype=hd res=18.:font facename='System VIO' size=14x8.+distinctinternalnames:font facename=default size=0x0.:elink. is not set, sets
:link reftype=hd res=18.:font facename='System VIO' size=14x8.+distinct-internal-names:font facename=default size=0x0.:elink. with unlimited internal name length&per.
:p.

:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.internalnamelookalike:font facename=default size=0x0.
:p.
 Set whether similar looking characters (e&per.g&per., "1" and "l") match in internal
names&per.
:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.

:h4.Other Checks
:p.
:hp2.:hp1.Other Checks:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.Undefined Evaluation Order  :ehp2.(:link reftype=hd res=13.Section 10&per.1:elink.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
evalorder 
:p.
Behavior of an expression is undefined because sub-expressions contain
interfering side effects that may be evaluated in any order&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.evalorderuncon:font facename=default size=0x0.
:p.
An expression may be undefined because a sub-expression contains a call to an
unconstrained function (no modifies clause) that may modify something that may
be modified or used by another sub-expression&per.
:p.
:hp2.Problematic Control Structures :ehp2.(:link reftype=hd res=13.Section 10&per.2:elink.):hp1.:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.infloops:font facename=default size=0x0.
:p.
Likely infinite loop is detected (:link reftype=hd res=13.Section 10&per.2&per.1:elink.)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.infloopsuncon:font facename=default size=0x0.
:p.
Likely infinite loop is detected&per.  Loop test or body calls an unconstrained
function, that may produce an undetected modification&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.elseifcomplete:font facename=default size=0x0.
:p.
There is no final else following an else if construct (:link reftype=hd res=13.Section 10&per.2&per.5:elink.)&per.
:hp2.:hp1.:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.casebreak:font facename=default size=0x0.
:p.
These is a non-empty case in a switch not followed by a break (Section
10&per.2&per.2)&per.:hp1.:ehp1.
:p.
:hp1.:ehp1.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.misscase:font facename=default size=0x0.
:p.
A switch on an enum type is missing a case for a member of the enumerator&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.loopexec:font facename=default size=0x0.
:p.
Assume all loops execute at least once&per.  This effects use-before-definition and
memory checking&per.  It should probably not be used globally, but may be used
surrounding a particular loop that is known to always execute to prevent
spurious messages&per.
:p.
:hp2.Deep Break  :ehp2.(:link reftype=hd res=13.Section 10&per.2&per.3:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.deepbreak:font facename=default size=0x0.
:p.
Report errors for break statements inside a nested while, for or switch&per.  (Sets
all nested break and continue flags&per.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.looploopbreak:font facename=default size=0x0.
:p.
There is a break inside a while, for or iterator loop that is inside a while,
for or iterator loop&per. Mark with :font facename='System VIO' size=14x8./*@innerbreak@*/:font facename=default size=0x0. to suppress the message&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.switchloopbreak:font facename=default size=0x0.
:p.
There is a break inside a while, for or iterator loop that is inside a switch
statement&per.  Mark with :font facename='System VIO' size=14x8./*@loopbreak@*/:font facename=default size=0x0.&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.loopswitchbreak:font facename=default size=0x0.
:p.
There is a break inside a switch statement that is inside a while, for or
iterator loop&per.  Mark with :font facename='System VIO' size=14x8./*@switchbreak@*/:font facename=default size=0x0.&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.switchswitchbreak:font facename=default size=0x0.
:p.
There is a break inside a switch statement that is inside another switch
statement&per.  Mark with  :font facename='System VIO' size=14x8./*@innerbreak@*/:font facename=default size=0x0.&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.looploopcontinue:font facename=default size=0x0.
:p.
There is a continue inside a while, for or iterator loop that is inside a
while, for or iterator loop&per.  Mark with :font facename='System VIO' size=14x8./*@innercontinue@*/:font facename=default size=0x0.&per.
:p.
:hp2.Loop and if Bodies  :ehp2.(:link reftype=hd res=13.Section 10&per.2&per.4:elink.):hp2.:hp1.:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.allempty:font facename=default size=0x0.
:p.
An if, while or for statement has no body (sets 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.ifempty:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.whileempty:font facename=default size=0x0.:elink. and
:link reftype=hd res=18.:font facename='System VIO' size=14x8.forempty:font facename=default size=0x0.:elink.&per.)
:p.
:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.allblock:font facename=default size=0x0.
:p.
The body of an if, while or for statement is not a block (sets ifblock,
whileblock and forblock&per.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.whileempty:font facename=default size=0x0.
:p.
A while statement has no body&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.whileblock:font facename=default size=0x0.
:p.
 The body of a while statement is not a :font facename='System VIO' size=14x8.block:font facename=default size=0x0.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.forempty:font facename=default size=0x0.
:p.
A for statement has no body&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.forblock:font facename=default size=0x0.
:p.
The body of a for statement is not a block&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.ifempty:font facename=default size=0x0.
:p.
An if statement has no body&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.ifblock:font facename=default size=0x0.
:p.
The body of an if statement is not a block&per.
:p.
:hp2.Suspicious Statements  :ehp2.(:link reftype=hd res=13.Section 10&per.3:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.unreachable:font facename=default size=0x0.
:p.
Code is not reached on any possible execution&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.noeffect:font facename=default size=0x0.
:p.
Statement has no effect&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.noeffectuncon:font facename=default size=0x0.
:p.
Statement involving call to unconstrained function may have no effect&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.noret:font facename=default size=0x0.
:p.
There is a path with no return in a function declared to return a non-void
value&per.
:p.
:hp2.Ignored Return Values  :ehp2.(:link reftype=hd res=13.Section 10&per.3&per.2:elink.):hp1.:ehp1.
:p.
:hp1.:ehp1.These flags control when errors are reported for function calls that do
not use the return value&per.  Casting the function call to void or declaring the
called function to return :font facename='System VIO' size=14x8./*@alt void@*/:font facename=default size=0x0.&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.retvalbool:font facename=default size=0x0.
:p.
Return value of type bool ignored&per. 
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.retvalint:font facename=default size=0x0.
:p.
Return value of type int ignored&per. 
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.retvalother:font facename=default size=0x0.
:p.
Return value of type other than bool or int ignored&per.
:p.
:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.retval:font facename=default size=0x0.
:p.
Return value ignored  (Sets retvalbool, retvalint, retvalother&per.)
:p.
:hp2.Unused Declarations  :ehp2.(:link reftype=hd res=13.Section 10&per.4:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.These flags control when errors are reported for declarations that are
never used&per.  The unused annotation can be used to prevent unused errors from
being report for a particular declaration&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.topuse:font facename=default size=0x0.
:p.
A external declaration is not used in any file&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.constuse:font facename=default size=0x0.
:p.
Constant never used&per. 
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.enummemuse:font facename=default size=0x0.
:p.
Member of enumerator never used&per. 
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.varuse:font facename=default size=0x0.
:p.
Variable never used&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.paramuse:font facename=default size=0x0.
:p.
Function parameter never used&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.fcnuse:font facename=default size=0x0.
:p.
Function is never used&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.++++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.typeuse:font facename=default size=0x0.
:p.
Defined type never used&per. 
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.fielduse:font facename=default size=0x0.
:p.
Field of structure or union type is never used&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.unusedspecial:font facename=default size=0x0.
:p.
Declaration in a special file (corresponding to :font facename='System VIO' size=14x8.&per.l:font facename=default size=0x0. or
:font facename='System VIO' size=14x8.&per.y:font facename=default size=0x0. file) is unused&per.
:p. 
:hp2.Complete Programs  :ehp2.(:link reftype=hd res=13.Section 10&per.5:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.declundef:font facename=default size=0x0.
:p.
Function, variable, iterator or constant declared but never defined&per.
:p.
:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.partial:font facename=default size=0x0.
:p.
Check as partial system (sets 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.-declundef:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.-exportlocal:font facename=default size=0x0.:elink. and prevents checking of
macros in headers without corresponding :font facename='System VIO' size=14x8.&per.c:font facename=default size=0x0. files&per.)
:p.
:hp2.Exports:ehp2.
:p.
:hp2.:ehp2.:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.export-local:font facename=default size=0x0.
:p.
A declaration is exported but not used outside this module&per.  (Declaration can
use the static qualifier&per.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.export-header:font facename=default size=0x0.
:p.
A declaration (other than a variable) is exported but does not appear in a
header file&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.export-header-var:font facename=default size=0x0.
:p.
A variable declaration is exported but does not appear in a header file&per.
:p.
:hp2.Unrecognized Identifiers:ehp2.
:p.
:hp2.:ehp2.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.unrecog:font facename=default size=0x0.
:p.
An unrecognized identifier is used&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.sys-unrecog:font facename=default size=0x0.
:p.
Report unrecognized identifiers that start with the system prefix, :font facename='System VIO' size=14x8.__:font facename=default size=0x0. (two
underscores)&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.repeat-unrecog:font facename=default size=0x0.
:p.
Report multiple messages for unrecognized identifiers&per.  If repeatunrecog is not
set, an error is reported only the first time a particular unrecognized
identifier appears in the file&per.
:p.
:hp2.Multiple Definition and Declarations:ehp2.
:p.
:hp2.:ehp2.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.redef:font facename=default size=0x0.
:p.
A function or variable is defined more than once&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.redecl:font facename=default size=0x0.
:p.
An identifier is declared more than once&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.nested-extern:font facename=default size=0x0.
:p.
An extern declaration is used inside a function body&per.
:p.

:hp2.ANSI C Conformance:ehp2.
:p.



:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.noparams:font facename=default size=0x0.
:p.
A function is declared without a parameter list prototype&per. 
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.oldstyle:font facename=default size=0x0.
:p.
Function definition is in old style syntax&per.  Standard prototype syntax is
preferred&per.
:p.
:p.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.exitarg:font facename=default size=0x0.
:p.
Argument to exit has implementation defined behavior&per.  The only valid arguments
to exit are EXIT_SUCCESS, EXIT_FAILURE and 0&per.  An error is reported if LCLint
can detect statically that the argument to exit is not one of these&per.
:p.
:hp2.Limits :ehp2.(:link reftype=hd res=13.Section 10&per.6:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.ansilimits:font facename=default size=0x0.
:p.
Check for violations of standard limits (Sets 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.controlnestdepth:font facename=default size=0x0.:elink.,
:font facename='System VIO' size=14x8.stringliterallen:font facename=default size=0x0., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.includenest:font facename=default size=0x0.:elink., 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.numstructfields:font facename=default size=0x0.:elink.,
and 
:link reftype=hd res=18.:font facename='System VIO' size=14x8.numenummembers:font facename=default size=0x0.:elink.)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:p.

:font facename='System VIO' size=14x8.controlnestdepth :font facename=default size=0x0.:hp1.<number>:ehp1.
:p.
Set maximum nesting depth of compound statements, iteration control structures,
and selection control structures (ANSI minimum is 15)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.stringliterallen :font facename=default size=0x0.:hp1.<number>:ehp1.
:p.
Set maximum length of string literals (ANSI minimum is 509)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.numstructfields :font facename=default size=0x0.:hp1.<number>:ehp1.
:p.
Set maximum number of fields in a struct or union (ANSI minimum is 127)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.numenummembers :font facename=default size=0x0.:hp1.<number>:ehp1.
:p.
Set maximum number of members of an enum type (ANSI minimum is 127)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.--++:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.includenest :font facename=default size=0x0.:hp1.<number>:ehp1.
:p.
Set maximum number of nested #include files (ANSI minimum is 8)&per.
:p.
:hp2.Header Inclusion :ehp2.(:link reftype=hd res=21.Apppendix F:elink.):hp1.:ehp1.
:p.

:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.skip-ansi-headers:font facename=default size=0x0.
:p.

Prevent inclusion of header files in a system directory with names that
match standard ANSI headers&per. The symbolic information in the standard
library is used instead&per.  In effect only if a library that includes the
ANSI library is used&per.  The ANSI headers are&colon. :font facename='System VIO' size=14x8.assert:font facename=default size=0x0.,
:font facename='System VIO' size=14x8.ctype:font facename=default size=0x0., :font facename='System VIO' size=14x8.errno:font facename=default size=0x0., :font facename='System VIO' size=14x8.float:font facename=default size=0x0., 
:font facename='System VIO' size=14x8.limits:font facename=default size=0x0.,
:font facename='System VIO' size=14x8.locale:font facename=default size=0x0., :font facename='System VIO' size=14x8.math:font facename=default size=0x0., :font facename='System VIO' size=14x8.setjmp:font facename=default size=0x0., 
:font facename='System VIO' size=14x8.signal:font facename=default size=0x0.,
:font facename='System VIO' size=14x8.stdarg:font facename=default size=0x0., :font facename='System VIO' size=14x8.stddef:font facename=default size=0x0., :font facename='System VIO' size=14x8.stdio:font facename=default size=0x0., 
:font facename='System VIO' size=14x8.stdlib:font facename=default size=0x0.,
:font facename='System VIO' size=14x8.strings:font facename=default size=0x0., :font facename='System VIO' size=14x8.string:font facename=default size=0x0., :font facename='System VIO' size=14x8.time:font facename=default size=0x0., and 
:font facename='System VIO' size=14x8.wchar:font facename=default size=0x0.&per.
:p.

:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.skip-posix-headers:font facename=default size=0x0.
:p.

Prevent inclusion of header files in a system directory with names that
match standard POSIX headers&per. The symbolic information in the standard
library is used instead&per.  In effect only if a library that includes the
POSIX library is used&per.  The POSIX headers are&colon. :font facename='System VIO' size=14x8.dirent:font facename=default size=0x0.,
:font facename='System VIO' size=14x8.fcntl:font facename=default size=0x0., :font facename='System VIO' size=14x8.grp:font facename=default size=0x0., :font facename='System VIO' size=14x8.pwd:font facename=default size=0x0., 
:font facename='System VIO' size=14x8.termios:font facename=default size=0x0.,
:font facename='System VIO' size=14x8.sys/stat:font facename=default size=0x0., :font facename='System VIO' size=14x8.sys/times:font facename=default size=0x0., :font facename='System VIO' size=14x8.sys/types:font facename=default size=0x0.,
:font facename='System VIO' size=14x8.sys/utsname:font facename=default size=0x0., :font facename='System VIO' size=14x8.sys/wait:font facename=default size=0x0., :font facename='System VIO' size=14x8.unistd:font facename=default size=0x0., and
:font facename='System VIO' size=14x8.utime:font facename=default size=0x0.&per.

:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.warn-posix-headers:font facename=default size=0x0.
:p.
Report use of a POSIX header when checking a program with a non-POSIX
library&per.
:p.
:font facename='System VIO' size=14x8.skipsysheaders:font facename=default size=0x0.
:p.
Do not include header files in system directories (as set by :font facename='System VIO' size=14x8.-sysdirs:font facename=default size=0x0.)
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.sys-dir-expand-macros:font facename=default size=0x0.
:p.
Expand macros in system directories regardless of other settings, except
for macros corresponding to names defined in a load library&per. 
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.sys-dir-errors:font facename=default size=0x0.
:p.
Report errors in files in system directories (set by -systemdirs)&per.   
:p.

:font facename='System VIO' size=14x8.single-include:font facename=default size=0x0.
:p.
Optimize header inclusion to only include each header file once&per.
:p.
:font facename='System VIO' size=14x8.never-include:font facename=default size=0x0.
:p.
Use library information instead of including header files&per. 
:p.

:hp2.Comments:ehp2.
:p.
:hp2.:ehp2.These flags control how syntactic comments are interpreted (see
:link reftype=hd res=20.Apppendix E:elink.)&per.
:p.

:font facename='System VIO' size=14x8.commentchar :font facename=default size=0x0.:hp1.<char>:ehp1.
:p.
Set the marker character for syntactic comments&per.  Comments beginning with
/*:hp1.<char>:ehp1. are interpreted by LCLint&per.  Default&colon. :font facename='System VIO' size=14x8.@:font facename=default size=0x0.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.noaccess:font facename=default size=0x0.
:p.
Ignore access comments&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.nocomments:font facename=default size=0x0.
:p.
Ignore all stylized comments&per. 
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.supcounts:font facename=default size=0x0.
:p.
Actual number of errors does not match number in :font facename='System VIO' size=14x8./*@i:font facename=default size=0x0.:hp1.<n>:ehp1.:font facename='System VIO' size=14x8.@*/:font facename=default size=0x0.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.lintcomments:font facename=default size=0x0.
:p.
Interpret traditional lint comments (:font facename='System VIO' size=14x8./*FALLTHROUGH*/:font facename=default size=0x0., :font facename='System VIO' size=14x8./*NOTREACHED*/:font facename=default size=0x0.,
:font facename='System VIO' size=14x8./*PRINTLIKE*/:font facename=default size=0x0.)&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.warnlintcomments:font facename=default size=0x0.
:p.
Print a warning and suggest an alternative when a traditional lint comment is
used&per.   
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.unrecogcomments:font facename=default size=0x0.
:p.
Stylized comment is unrecognized&per.
:p.
:hp2.Parsing:ehp2.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.continue-comment:font facename=default size=0x0.
:p.
A line continuation marker (:font facename='System VIO' size=14x8.\:font facename=default size=0x0.) appears inside a comment on the
same line as the comment close&per. Preprocessors should handle this correctly, but it causes problems for some preprocessors&per.

:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.nest-comment:font facename=default size=0x0.
:p.
A comment open sequence (:font facename='System VIO' size=14x8./*:font facename=default size=0x0.) appears inside a comment&per.  This usually
indicates that an earlier comment was not closed&per.
:p.


:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.duplicate-quals:font facename=default size=0x0.
:p.

Report duplicate type qualifiers (e&per.g&per., :font facename='System VIO' size=14x8.long long:font facename=default size=0x0.)&per.  Duplicate type
qualifiers not supported by ANSI, but some compilers (e&per.g&per., :font facename='System VIO' size=14x8.gcc:font facename=default size=0x0.) do
support duplicate qualifiers&per.

:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br

:font facename='System VIO' size=14x8.gnu-extensions:font facename=default size=0x0.
:p.
Support some GNU (gcc) language extensions&per.
:p.

:hp2.Array Formal Parameters:ehp2.
:p.

These flags control reporting of common errors caused by confusion about
the semantics of array formal parameters&per.
:p.

:hp2.General Checks:ehp2.
:p.

:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.sizeof-formal-array:font facename=default size=0x0.
:p.
The sizeof operator is used on a parameter declared as an array&per.  (In
many instances this has unexpected behavior, since the result is the
size of a pointer to the element type, not the number of elements in the
array&per.)
:p.

:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.fixed-formal-array:font facename=default size=0x0.
:p.

An array formal parameter is declared with a fixed size (e&per.g&per., :font facename='System VIO' size=14x8.int
x[20]:font facename=default size=0x0.)&per.  This is likely to be confusing, since the size is ignored&per.

:p.

:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.formal-array:font facename=default size=0x0.
:p.
A formal parameter is declared as an array&per.  This is probably not a
problem, but can be confusing since it is treated as a pointer&per.
:p.

:hp2.:ehp2.These flags should probably not be set globally since the turn off
general checks that should always be done&per.  They may be used locally to
suppress spurious errors&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.abstract:font facename=default size=0x0.
:p.
A data abstraction barrier is violated&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.control:font facename=default size=0x0.
:p.
A control flow error is detected&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.syntax:font facename=default size=0x0.
:p.
Parse error&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.trytorecover:font facename=default size=0x0.
:p.
Try to recover from a parse error&per.  If trytorecover is not set, LCLint will
abort checking after a parse error is detected&per.  If it is set, LCLint will
attempt to recover, but LCLint does performs only minimal error recovery&per. 
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.type:font facename=default size=0x0.
:p.
Type mismatch&per.
:p.
:cgraphic.:ecgraphic.
.br
:link reftype=hd res=18.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=18.:eartlink.:link reftype=hd res=18.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


:h3 res=1805.Flag Name Abbreviations
:p.
:hp2.Flag Name Abbreviations:ehp2.
:p.
:hp2.:ehp2.Within a flag name, abbreviations may be used&per. Table 2 shows the flag
name abbreviations&per.  The expanded and short forms are interchangeable in flag
names&per.  
:p.
For example, globsimpmodsnothing and globalsimpliesmodifiesnothing denote the
same flag&per.  Abbreviations in flag names allow pronounceable, descriptive names
to be used without making flag names excessively long (although one must admit
even globsimpmodsnothing is a bit of a mouthful&per.)
:p.

:table cols='38 38'.
:row.
:c.:hp2.Expanded Form:ehp2.:c.:hp2.Short Form:ehp2.

:row.
:c.constant :c.                       const        
:row.
:c.declaration  :c.                   decl               
:row.
:c.function                   :c.     fcn                
:row.
:c.global:c.                              glob               
:row.
:c.implicit, implied       :c.        imp                
:row.
:c.iterator                 :c.       iter      
:row.
:c.length                       :c.   len                
:row.
:c.modifies                :c.        mods           
:row.
:c.modify                    :c.      mod                
:row.
:c.memory                       :c.   mem                
:row.
:c.parameter                   :c.    param              
:row.
:c.pointer                     :c.    ptr                
:row.
:c.return                      :c.    ret                
:row.
:c.variable                     :c.   var                
:row.
:c.unconstrained, unconst      :c.    uncon              
:etable.



:hp2.Table 2&per.  Flag name abbreviations&per.:ehp2.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=19.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=19.:eartlink.:link reftype=hd res=19.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: appD.html
:h2 res=19.LCLint User's Guide - Appendix D  Annotations
:font facename=default size=0x0.
:p.


.br
:font facename='Helv' size=20x12.
.br
Appendix D  Annotations:font facename=default size=0x0.
.br
.br
:p.
The
grammar below is the C syntax from [:link reftype=hd res=25.K&amp.R:elink.,A13] modified to show
the syntax of syntactic comments&per.  Only productions effected by LCLint
annotations are shown&per.  In the annotations, the :font facename='System VIO' size=14x8.@:font facename=default size=0x0. represents the comment marker
char, set by :font facename='System VIO' size=14x8.-commentchar:font facename=default size=0x0. (default is :font facename='System VIO' size=14x8.@:font facename=default size=0x0.)&per.
:p.
:hp2.:hp1.Functions:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.:hp1.direct-declarator&colon.:ehp1.
:p.
:cgraphic.
          direct-declarator (parameter-type-list_opt) globals_opt modifies_opt
        | direct-declarator (identifier-list_opt) globals_opt modifies_opt
:ecgraphic.
:hp1.:ehp1.
:p.
:hp1.globals:ehp1.:hp1.&colon. :ehp1.(:link reftype=hd res=7.Section
4&per.2:elink.):hp1.:ehp1.
:p.
:cgraphic.
          /*@globals globitem,+ ;_opt @*/
        | /*@globals declaration-list_opt ;_opt @*/
:ecgraphic.
:hp1.globitem&colon. :ehp1.
:p.
:cgraphic.
           globannot* identifier
        |  internalState
        |  systemState
:ecgraphic.
:hp1.:ehp1.
:p.
:hp1.globannot&colon. :ehp1.:font facename='System VIO' size=14x8.undef | killed:font facename=default size=0x0.
:p.
:hp1.:ehp1.
:p.
:hp1.modifies&colon. :ehp1.(:link reftype=hd res=7.Section 4&per.1:elink.):hp1.:ehp1.
:p.
:cgraphic.
           /*@modifies moditem,+;_opt @*/       
         | /*@modifies nothing ;_opt @*/
         | /*@*/  (Abbreviation for no globals and modifies nothing&per.)
:ecgraphic.
:hp1.:ehp1.
:p.
:hp1.moditem&colon. :ehp1.
:p.
:cgraphic.
           expression   
         | internalState
         | systemState
:ecgraphic.
:p.
:hp2.:hp1.Iterators :ehp1.:ehp2.(:link reftype=hd res=11.Section 8&per.4:elink.):hp2.:hp1.:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.The globals and modifies clauses for an iterator are the same as
those for a function, except they are not enclosed by a comment, since the
iterator is already a comment&per.:hp1.:ehp1.
:p.
:hp1.direct-declarator&colon. :ehp1.
:p.
:cgraphic.
       /*@iter identifier (parameter-type-list_opt) globals_opt
modifies_opt @*/
:ecgraphic.
:p.
:hp2.:hp1.Constants :ehp1.:ehp2.(:link reftype=hd res=11.Section 8&per.1:elink.):hp2.:hp1.:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.:hp1.external-declaration&colon.:ehp1.
:p.
:cgraphic.
       /*@constant declaration ;_opt @*/
:ecgraphic.

:p.
:hp1.:hp2.Alternate Types :ehp2.:ehp1.(:link reftype=hd res=11.Section 8&per.2&per.2:elink.):hp1.:ehp1.
:p.
:hp1.:ehp1.Alternate types may be used in the type specification of parameters and
return values&per.
:p.
:hp1.extended-type:ehp1.:hp1.&colon. :ehp1.
:p.
:cgraphic.
        type-specifier alt-type_opt
:ecgraphic.
:hp1.:ehp1.
:p.
:hp1.alt-type:ehp1.:hp1.&colon. :ehp1.
:p.
:cgraphic.
        /*@alt basic-type,+ @*/
:ecgraphic.
:p.
:hp2.:hp1.Declarator Annotations:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.General annotations appear after :hp1.storage-class-specifier:ehp1.s
and before :hp1.type:ehp1.:hp1.-specifier:ehp1.s&per.  Multiple annotations may be used in
any order&per.  Here, annotations are without the surrounding comment&per.  In a
declaration, the annotation would be surrounded by :font facename='System VIO' size=14x8./*@:font facename=default size=0x0. and
:font facename='System VIO' size=14x8.@*/:font facename=default size=0x0.&per.  In a globals or modifies clause or iterator or constant
declaration, no surrounding comment would be used since they are within
a comment&per.
:p.
:hp2.Type Definitions  :ehp2.(:link reftype=hd res=6.Section 3:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.A type definition may use any either abstract or concrete, either
mutable or immutable, and refcounted&per.  Only a pointer to a struct may be
declared with refcounted&per.  Mutability annotations may not be used with concrete
types since concrete types inherit their mutability from the actual type&per.
:p.
:font facename='System VIO' size=14x8.abstract:font facename=default size=0x0.
:p.
Type is abstract (representation is hidden from clients)&per.
:p.
:font facename='System VIO' size=14x8.concrete:font facename=default size=0x0.
:p.
Type is concrete (representation is visible to clients)&per.
:p.
:font facename='System VIO' size=14x8.immutable:font facename=default size=0x0.
:p.
Instances of the type cannot change value&per.  (:link reftype=hd res=6.Section 3&per.2:elink.)
:p.
:font facename='System VIO' size=14x8.mutable:font facename=default size=0x0.
:p.
Instances of the type can change value&per.  (:link reftype=hd res=6.Section 3&per.2:elink.)
:p.
:font facename='System VIO' size=14x8.refcounted:font facename=default size=0x0.
:p.
Reference counted type&per.  (:link reftype=hd res=8.Section 5&per.4:elink.)
:p.
:hp2.Global Variables  :ehp2.(:link reftype=hd res=7.Section 4&per.2&per.1:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.One check annotation may be used on a global or file-static variable
declaration&per.
:p.
:font facename='System VIO' size=14x8.unchecked:font facename=default size=0x0.
:p.
Weakest checking for global use&per.
:p.
:font facename='System VIO' size=14x8.checkmod:font facename=default size=0x0.
:p.
Check modification by not use of global&per. 
:p.
:font facename='System VIO' size=14x8.checked:font facename=default size=0x0.
:p.
Check use and modification of global&per. 
:p.
:font facename='System VIO' size=14x8.checkedstrict:font facename=default size=0x0.
:p.
Check use of global, even in functions with no global list&per. 
:p.
:hp2.Memory Management  :ehp2.(:link reftype=hd res=8.Section 5:elink.):hp1.:ehp1.
:p.
:hp1.:ehp1.:font facename='System VIO' size=14x8.dependent:font facename=default size=0x0.
:p.
A reference to externally-owned storage&per.  (:link reftype=hd res=8.Section 5&per.2&per.2:elink.)
:p.
:font facename='System VIO' size=14x8.keep:font facename=default size=0x0.
:p.
A parameter that is kept by the called function&per.  The caller may use the
storage after the call, but the called function is responsible for making sure
it is deallocated&per.  (:link reftype=hd res=8.Section 5&per.2&per.4:elink.)
:p.
:font facename='System VIO' size=14x8.killref:font facename=default size=0x0.
:p.
A refcounted parameter&per.  This reference is killed by the call&per. (:link reftype=hd res=8.Section 5&per.4:elink.)
:p.
:font facename='System VIO' size=14x8.only:font facename=default size=0x0.
:p.
A unshared reference&per.  Associated memory must be released before reference is
lost&per.  (:link reftype=hd res=8.Section 5&per.2:elink.)
:p.
:font facename='System VIO' size=14x8.owned:font facename=default size=0x0.
:p.
Storage may be shared by dependent references, but associated memory must be
released before this reference is lost&per.  (:link reftype=hd res=8.Section 5&per.2&per.2:elink.)
:p.
:font facename='System VIO' size=14x8.shared:font facename=default size=0x0.
:p.
Shared reference that is never deallocated&per.  (:link reftype=hd res=8.Section 5&per.2&per.5:elink.)
:p.
:font facename='System VIO' size=14x8.temp:font facename=default size=0x0.
:p.
A temporary parameter&per.  May not be released, and new aliases to it may not be
created&per.  (:link reftype=hd res=8.Section 5&per.2&per.2:elink.)
:p.
:hp2.Aliasing  :ehp2.(:link reftype=hd res=9.Section 6:elink.):hp2.:hp1.:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.Both alias annotations may be used on a parameter
declaration&per.:hp1.:ehp1.
:p.
:hp1.:ehp1.:font facename='System VIO' size=14x8.unique:font facename=default size=0x0.
:p.
Parameter that may not be aliased by any other reference visible to the
function&per. (Section 6&per.1&per.1)
:p.
:font facename='System VIO' size=14x8.returned:font facename=default size=0x0.
:p.
Parameter that may be aliased by the return value&per.  (:link reftype=hd res=9.Section 6&per.1&per.2:elink.)
:p.
:hp2.Exposure  :ehp2.(:link reftype=hd res=9.Section 6&per.2:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.:font facename='System VIO' size=14x8.observer:font facename=default size=0x0.
:p.
Reference that cannot be modified&per.  (:link reftype=hd res=9.Section 6&per.2&per.1:elink.)
:p.
:font facename='System VIO' size=14x8.exposed:font facename=default size=0x0.
:p.
Exposed reference to storage in another object&per. (:link reftype=hd res=9.Section 6&per.2&per.1:elink.)
:p.
:hp2.Definition State  :ehp2.(:link reftype=hd res=10.Section 7&per.1:elink.)
:p.
:font facename='System VIO' size=14x8.out:font facename=default size=0x0.
:p.
Storage reachable from reference need not be defined&per.
:p.
:font facename='System VIO' size=14x8.in:font facename=default size=0x0.
:p.
All storage reachable from reference must be defined&per.
:p.
:font facename='System VIO' size=14x8.partial:font facename=default size=0x0.
:p.
Partially defined&per.  A structure may have undefined fields&per.  No errors reported
when fields are used&per.
:p.
:font facename='System VIO' size=14x8.reldef:font facename=default size=0x0.
:p.
Relax definition checking&per.  No errors when reference is not defined, or when it
is used&per.
:p.
:hp2.Global State  :ehp2.(:link reftype=hd res=10.Section 7&per.1&per.4:elink.):hp1.:ehp1.
:p.
:hp1.:ehp1.These annotations may only be used in globals lists&per.  Both annotations
may be used for the same variable, to mean the variable is undefined before and
after the call&per.
:p.
:p.
:font facename='System VIO' size=14x8.undef:font facename=default size=0x0.
:p.
Variable is undefined before the call&per.
:p.
:font facename='System VIO' size=14x8.killed:font facename=default size=0x0.
:p.
Variable is undefined after the call&per.
:p.
:hp2.Null State  :ehp2.(:link reftype=hd res=10.Section 7&per.2:elink.):hp1.:ehp1.
:p.
:hp1.:ehp1.:font facename='System VIO' size=14x8.null:font facename=default size=0x0.
:p.
Possibly null pointer&per.
:p.
notnull 
:p.
Non-null pointer&per.
:p.
:font facename='System VIO' size=14x8.relnull:font facename=default size=0x0.
:p.
Relax null checking&per.  No errors when NULL is assigned to it, or when it is used
as a non-null pointer&per.
:p.
:hp2.Null Predicates  :ehp2.(:link reftype=hd res=10.Section 7&per.2&per.1:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.A null predicate annotation may be used of the return value of a
function returning a boolean type, taking a possibly-null pointer for its first
argument&per.
:p.
:font facename='System VIO' size=14x8.truenull:font facename=default size=0x0.
:p.
If result is TRUE, first parameter is NULL&per.
:p.
:font facename='System VIO' size=14x8.falsenull:font facename=default size=0x0.
:p.
If result is TRUE, first parameter is not NULL&per.
:p.
:hp2.Execution  :ehp2.(:link reftype=hd res=10.Section 7&per.3:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.The :font facename='System VIO' size=14x8.exits:font facename=default size=0x0., :font facename='System VIO' size=14x8.mayexit:font facename=default size=0x0. and :font facename='System VIO' size=14x8.neverexits:font facename=default size=0x0.
annotations may be used on any function&per.  The :font facename='System VIO' size=14x8.trueexit:font facename=default size=0x0. and
:font facename='System VIO' size=14x8.falseexit:font facename=default size=0x0. annotations may only be used on functions whose first
argument is a boolean&per.  
:p. 
:font facename='System VIO' size=14x8.exits:font facename=default size=0x0.           
:p.
Function never returns&per.
:p.
:font facename='System VIO' size=14x8.mayexit:font facename=default size=0x0.         
:p.
Function may or may not return&per.
:p.
:font facename='System VIO' size=14x8.trueexit:font facename=default size=0x0.        
:p.
Function does not return if first parameter is TRUE&per.
:p.
:font facename='System VIO' size=14x8.falseexit:font facename=default size=0x0.       
:p.
Function does not return if first parameter if FALSE&per.
:p.
:font facename='System VIO' size=14x8.neverexit:font facename=default size=0x0.
:p.
Function always returns&per.
:p.
:hp2.Side-Effects  :ehp2.(:link reftype=hd res=11.Section 8&per.2&per.1:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.:font facename='System VIO' size=14x8.sef:font facename=default size=0x0.
:p.
Corresponding actual parameter has no side effects&per.
:p.
:hp2.Declaration:ehp2.
:p.
:hp2.:ehp2.These annotations can be used on a declaration to control unused or
undefined error reporting&per.:hp1.:ehp1.
:p.
:hp1.:ehp1.:font facename='System VIO' size=14x8.unused:font facename=default size=0x0.
:p.
Identifier need not be used (no unused errors reported&per.)  (:link reftype=hd res=13.Section 10&per.4:elink.)
:p.
:font facename='System VIO' size=14x8.external:font facename=default size=0x0.
:p.
Identifier is defined externally (no undefined error reported&per.) (:link reftype=hd res=13.Section 10&per.5:elink.)
:p.
:hp2.Case:ehp2.
:p.
:hp2.:ehp2.:font facename='System VIO' size=14x8.fallthrough:font facename=default size=0x0.
:p.
Fall-through case&per.  No message is reported if the previous case may
fall-through into the one immediately after the fallthrough&per.
:p.
:hp2.Break  :ehp2.(:link reftype=hd res=13.Section 10&per.2&per.3:elink.):hp2.:ehp2.
:p.
:hp2.:ehp2.These annotations are used before a break or continue statement&per.
:p.
:font facename='System VIO' size=14x8.innerbreak:font facename=default size=0x0.
:p.
Break is breaking an inner loop or switch&per.
:p.
:font facename='System VIO' size=14x8.loopbreak:font facename=default size=0x0.
:p.
Break is breaking a loop&per.
:p.
:font facename='System VIO' size=14x8.switchbreak:font facename=default size=0x0.
:p.
Break is breaking a switch&per.
:p.
:font facename='System VIO' size=14x8.innercontinue:font facename=default size=0x0.
:p.
:hp1.:ehp1.Continue is continuing an inner loop&per.
:p.
:hp2.Unreachable Code:ehp2.
:p.
:hp2.:ehp2.This annotation is used before a statement to prevent unreachable code
errors&per.
:p.
:font facename='System VIO' size=14x8.notreached:font facename=default size=0x0.
:p.
Statement may be unreachable&per.
:p.
:hp2.Special Functions :ehp2.(:link reftype=hd res=20.Apppendix E:elink.)
:p.
These annotations are used immediately before a function declaration&per.
:p.
:font facename='System VIO' size=14x8.printflike:font facename=default size=0x0.
:p.
Check variable arguments like printf library function&per.   
:p.
:font facename='System VIO' size=14x8.scanflike:font facename=default size=0x0.
:p.
Check variable arguments like scanf library function&per.



:cgraphic.:ecgraphic.
.br
:link reftype=hd res=20.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=20.:eartlink.:link reftype=hd res=20.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: appE.html
:h2 res=20.LCLint User's Guide - Appendix E  Control Comments
:font facename=default size=0x0.
:p.


.br
:font facename='Helv' size=20x12.
.br
Appendix E  Control Comments:font facename=default size=0x0.
.br
.br


:p.
:hp2.:hp1.Error Suppression:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.Several comments are provided for suppressing messages&per.  In
general, it is usually better to use specific flags to suppress a particular
error permanently, but the general error suppression flags may be more
convenient for quickly suppressing messages for code that will be corrected or
documented later&per.
:p.
:font facename='System VIO' size=14x8.ignore:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.end:font facename=default size=0x0.
:p.
No errors will be reported in code regions between :font facename='System VIO' size=14x8./*@ignore@*/:font facename=default size=0x0.
and :font facename='System VIO' size=14x8./*@end@*/:font facename=default size=0x0.&per. These comments can be used to easily suppress an
unlimited number of messages, but are dangerous since if real errors are
introduced in the :font facename='System VIO' size=14x8.ignore &per.&per.&per. end:font facename=default size=0x0. region they will not be
reported&per. The ignore and end comments must be matched - a warning is
printed if the file ends in an ignore region or if ignore is used inside
ignore region&per.

:font facename='System VIO' size=14x8.i:font facename=default size=0x0.
.br
:p.
No errors will be reported from an :font facename='System VIO' size=14x8./*@i@*/:font facename=default size=0x0. comment to the end of the line&per.
:p.

:font facename='System VIO' size=14x8.i:font facename=default size=0x0.:hp1.<n>:ehp1.
.br
:p.
 No errors will be reported from an /*@i:hp1.<n>:ehp1.@*/ (e&per.g&per.,
:font facename='System VIO' size=14x8./*@i3@*/:font facename=default size=0x0.) comment to the end of the line&per. If there are not
exactly :hp1.n :ehp1.errors suppressed from the comment point to the end of
the line, LCLint will report an error&per.  This is more robust than i or
ignore since a message is generated if the expected number errors is not
present&per.  Since errors are not necessarily detected until after this
file is processed (for example, and unused variable error), suppress
count errors are reported after all files have been processed&per. The :font facename='System VIO' size=14x8.-supcounts:font facename=default size=0x0. flag may be
used to suppress these errors&per.  This is useful when a system if being
rechecked with different flag settings&per.  

:font facename='System VIO' size=14x8.t:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.t:font facename=default size=0x0.:hp1.<n>:ehp1.
.br
:p.
Like :font facename='System VIO' size=14x8.i:font facename=default size=0x0. and :font facename='System VIO' size=14x8.i:font facename=default size=0x0.:hp1.<n>:ehp1., except controlled by
:font facename='System VIO' size=14x8.+tmpcomments:font facename=default size=0x0. flag&per.  These can be used to temporarily suppress
certain errors&per.  Then, :font facename='System VIO' size=14x8.-tmpcomments:font facename=default size=0x0. can be set to find them
again&per.

:p.
:hp2.:hp1.Type Access:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.Control comments may also be used to override type access
settings&per. The syntax :font facename='System VIO' size=14x8./*@access :font facename=default size=0x0.:hp1.<type>:ehp1.,+:font facename='System VIO' size=14x8.@*/:font facename=default size=0x0. allows the following code to
access the representation of :hp1.<type>:ehp1.&per.  Similarly,
:font facename='System VIO' size=14x8./*@noaccess :font facename=default size=0x0.:hp1.<type>:ehp1.,+:font facename='System VIO' size=14x8.@*/:font facename=default size=0x0. restricts access
to the representation of :hp1.<type>:ehp1.&per.  The type in a noaccess
comment must have been declared as an abstract type&per.  Type access
applies from the point of the comment to the end of the file or the next
access control comment for this type&per. 
:p.
:hp2.:hp1.Macro Expansion:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.The :font facename='System VIO' size=14x8./*@notfunction@*/:font facename=default size=0x0.indicates that the next macro definition is
not intended to be a function, and should be expanded in line instead of
checked as a macro function definition&per.
:p.
:hp2.:hp1.Traditional Lint Comments:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.Some of the control comments supported by most standard UNIX
lints are supported by LCLint so legacy systems can be checked more easily&per.
These comments are not lexically consistent with LCLint comments, and their
meanings are less precise (and may vary between different lint programs), so we
recommend that LCLint comments are used instead except for checking legacy
systems already containing standard lint comments&per.
:p.
:p.
These standard lint comments supported by LCLint&colon.
:p.
:font facename='System VIO' size=14x8./*FALLTHROUGH*/:font facename=default size=0x0. (alternate misspelling, :font facename='System VIO' size=14x8./*FALLTHRU*/:font facename=default size=0x0.)
:p.
Prevents errors for fall-through cases&per.  Same meaning as :font facename='System VIO' size=14x8./*@fallthrough@*/:font facename=default size=0x0.&per.

:font facename='System VIO' size=14x8./*NOTREACHED*/:font facename=default size=0x0.
:p.
Prevents errors about unreachable code (until the end of the function)&per.  Same
meaning as :font facename='System VIO' size=14x8./*@notreached@*/:font facename=default size=0x0.&per.  

:font facename='System VIO' size=14x8./*PRINTFLIKE*/:font facename=default size=0x0.
:p.
Arguments similar to the printf library function (there didn't seem to be much
of a consensus among standard lints as to exactly what this means)&per.  LCLint
supports&colon.
:p.
:font facename='System VIO' size=14x8./*@printflike@*/:font facename=default size=0x0.
:p.
Function takes zero or more arguments of any type, an unmodified char * format
string argument and zero of more arguments of type and number dictated by the
format string&per.  Format codes are interpreted identically to the printf standard
library function&per.  May return a result of any type&per.  (LCLint interprets
:font facename='System VIO' size=14x8./*PRINTFLIKE*/:font facename=default size=0x0. as :font facename='System VIO' size=14x8./*@printflike@*/:font facename=default size=0x0.&per.)
:p.

:font facename='System VIO' size=14x8./*@scanflike@*/:font facename=default size=0x0.
:p.
Like printflike, except format codes are interpreted as in the scanf library
function&per.


:font facename='System VIO' size=14x8./*ARGSUSED*/:font facename=default size=0x0.
:p.
Turns off unused parameter messages for this function&per.  The control
comment, :font facename='System VIO' size=14x8./*@-paramuse@*/:font facename=default size=0x0. can be used to the same effect, or
:font facename='System VIO' size=14x8./*@unused@*/:font facename=default size=0x0. can be used in individual parameter declarations&per.

:p.
LCLint will ignore standard lint comments if :font facename='System VIO' size=14x8.-lintcomments:font facename=default size=0x0. is used&per.
If :font facename='System VIO' size=14x8.+warnlintcomments:font facename=default size=0x0.
is used, LCLint generates a message for standard lint comments and suggest replacements,

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=21.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=21.:eartlink.:link reftype=hd res=21.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: appF.html
:h2 res=21.LCLint User's Guide - Appendix F  Libraries
:font facename=default size=0x0.
:p.


.br
:font facename='Helv' size=20x12.
.br
Appendix F  Libraries:font facename=default size=0x0.
.br
.br

:p.
:hp2.:ehp2.Libraries can be used to record interface information&per.  A library
containing information about the  Standard C Library is used to enable checking
of library calls&per.  Program libraries can be created to enable fast checking of
single modules in a large program&per.
:p.
:hp2.:hp1.Standard Libraries:ehp1.:ehp2.
:p.
In order to check calls to library functions, LCLint uses an
annotated standard library&per.  This contains more information about function
interfaces then is available in the system header files since it uses
annotations&per.  Further, it contains only those functions documented in the ANSI
Standard&per.  Many systems include extra functions in their system libraries;
programs that use these functions cannot be compiled on other systems that do
not provide them&per.  Certain types defined by the library are treated as abstract
types (e&per.g&per., a program should not rely on how the FILE type is implemented)&per.
When checking source code, LCLint does include system headers according to
include directive in the source code, but instead uses the library description
of the standard library&per.
:p.
:p.

The LCLint distribution includes several different standard libraries&colon.
the ANSI standard library, the POSIX standard library , and an ad hoc
UNIX library&per.  Each library comes in two versions&colon. the standard version
and the strict version&per.
:p.
:hp2.ANSI Library:ehp2.
:p.

The default behavior of LCLint is to use the ANSI standard library
(loaded from :font facename='System VIO' size=14x8.ansi&per.lcd:font facename=default size=0x0.)&per.  This library is based on the standard library
described in the ANSI C Standard&per.  It includes functions and types added
by Amendment 1 to the ANSI C Standard&per.
:p.

:hp2.POSIX Library:ehp2.
:p.

The POSIX library is selected by the :font facename='System VIO' size=14x8.+posixlib:font facename=default size=0x0. flag&per.  The POSIX library
is based on the IEEE Std 1003&per.1-1990&per.  
:p.

:hp2.UNIX Library:ehp2.
:p.

The UNIX library is selected by the :font facename='System VIO' size=14x8.+unixlib:font facename=default size=0x0. flag&per.  This
library is an ad hoc attempt to capture additional functionality
provided by many UNIX platforms&per. Unfortunately, UNIX systems vary widely
and very few are consistent with the ANSI Standard&per.
:p.
The differences between the UNIX library and the POSIX library are&colon.
:ul compact.
:li.In the UNIX library, :font facename='System VIO' size=14x8.free:font facename=default size=0x0. is declared with a non-null
parameter&per.  ANSI C specifies that :font facename='System VIO' size=14x8.free:font facename=default size=0x0. should handle the
argument :font facename='System VIO' size=14x8.NULL:font facename=default size=0x0., but several UNIX platforms crash if :font facename='System VIO' size=14x8.NULL:font facename=default size=0x0. is
passed to :font facename='System VIO' size=14x8.free:font facename=default size=0x0.&per. 
:li.Extra variables, constants and functions are included in the UNIX
library&per.  Some declarations are not  part of the POSIX library, but are
believed to be available on many UNIX systems&per.  See :font facename='System VIO' size=14x8.lib/unix&per.h:font facename=default size=0x0.
for a list of the UNIX-only declarations&per. 
:eul.

:p.
Code checked using the UNIX library can probably be ported to some UNIX
systems without difficulty&per.  To enhance the likelihood that a program is
portable, the POSIX library should be used instead&per.
:p.
:hp2.Strict Libraries:ehp2.
:p.
Stricter versions of the libraries are used if the
:font facename='System VIO' size=14x8.-ansi-strict:font facename=default size=0x0., :font facename='System VIO' size=14x8.posix-strict-lib:font facename=default size=0x0. or
:font facename='System VIO' size=14x8.unix-strct-lib:font facename=default size=0x0. flag is used&per. These libraries use a stricter
interpretation of the library&per.  They will detect more errors in some programs, but may to produce many spurious errors for typical code&per. 
:p.
The differences between the standard libraries and the strict libraries
are&colon.
:ul compact.
:li.The standard libraries declare the printing functions
(:font facename='System VIO' size=14x8.fprintf:font facename=default size=0x0., :font facename='System VIO' size=14x8.printf:font facename=default size=0x0., and :font facename='System VIO' size=14x8.sprintf:font facename=default size=0x0.) that may
return error codes to return :font facename='System VIO' size=14x8.int:font facename=default size=0x0. or :font facename='System VIO' size=14x8.void:font facename=default size=0x0.&per.  This prevents typical
programs from leading to deluge of ignored return value errors, but may
mean some relevant errors are not detected&per.  In the strict libraries, they
are declared to return :font facename='System VIO' size=14x8.int:font facename=default size=0x0., so ignored return value errors will
be reported (depending on other flag settings)&per.  Programs should check
that this return value is non-negative&per. 

:li.
The standard libraries declare some parameters and return values to be
alternate types (:font facename='System VIO' size=14x8.int:font facename=default size=0x0. or :font facename='System VIO' size=14x8.bool:font facename=default size=0x0., or :font facename='System VIO' size=14x8.int:font facename=default size=0x0. or
:font facename='System VIO' size=14x8.char:font facename=default size=0x0.)&per.  The ANSI standard specifies these types as int to be
compatible with older versions of the library, but logically they make
more sense as :font facename='System VIO' size=14x8.bool:font facename=default size=0x0. or :font facename='System VIO' size=14x8.char:font facename=default size=0x0.&per.  In the strict libraries,
the stronger type is used&per.  The parameter to :font facename='System VIO' size=14x8.assert:font facename=default size=0x0. is
:font facename='System VIO' size=14x8.int:font facename=default size=0x0. or :font facename='System VIO' size=14x8.bool:font facename=default size=0x0. in the standard library, and :font facename='System VIO' size=14x8.bool:font facename=default size=0x0.
in the strict library&per.  The parameter to the character functions
isalnum, isalpha, iscntrl, isdigit, isgraph, islower, isprint, ispunct,
isspace, isupper, isxdigit, tolower and toupper is char or int in the
standard library and char in the strict library&per.  The type of the return
value of the character classification functions (all of the previous
character functions except tolower and toupper) is bool or int in the
standard library and bool in the strict library&per.  The type of the first
parameter to ungetc is char or int in the standard library and char in
the strict library (EOF should not be passed to ungetc)&per.  The second
parameter to strchr and strrchr is char or int in the standard library
and char in the strict library&per.

:li.The global variables stdin, stdout and stderr are declared as
unchecked variables (see :link reftype=hd res=7.Section
4&per.2&per.1:elink.) in the standard libraries&per.  In the strict libraries, they are checked&per.  The global variable errno is declared unchecked in the standard
libraries, but declared checkedstrict in the strict libraries&per.
:eul.

:p.

:hp2.Generating the Standard Libraries:ehp2.
:p.

The standard libraries are generated from header files included in the
LCLint distribution&per.  Some libraries are generated from more than one
header file&per.  Since the POSIX library includes the ANSI library, the
headers for the ANSI and POSIX libraries are combined to produce the
POSIX library&per.  Similarly, the UNIX library is composed of the ANSI,
POSIX and UNIX headers&per.  The header files include some sections that are
conditionally selected by defining :font facename='System VIO' size=14x8.STRICT:font facename=default size=0x0.&per.
:p.
The commands to generate the standard libraries are&colon.
:p.
:cgraphic.
lclint -nolib ansi&per.h -dump ansi 
lclint -nolib -DSTRICT ansi&per.h -dump ansistrict
lclint -nolib ansi&per.h posix&per.h -dump posix
lclint -nolib -DSTRICT ansi&per.h posix&per.h -dump posixstrict
lclint -nolib ansi&per.h posix&per.h unix&per.h -dump unix
lclint -nolib -DSTRICT ansi&per.h posix&per.h unix&per.h -dump unixstrict
:ecgraphic.


:p.
:hp2.:hp1.User Libraries:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.To enable running LCLint on large systems, mechanisms are
provided for creating libraries containing necessary information&per.  This means
source files can be checked independently, after a library has been created&per.
The command line option -dump :hp1.library:ehp1. stores information in the file
:hp1.library:ehp1. (the default extension, :font facename='System VIO' size=14x8.&per.lcd:font facename=default size=0x0.:link reftype=hd res=5.[27]:elink., is
added)&per. Then, :font facename='System VIO' size=14x8.-load :font facename=default size=0x0.:hp1.library:ehp1. loads the library&per.  The library
contains interface information from the files checked when the library was
created&per.
:p.

:hp2.:hp1.
Header File Inclusion
:ehp1.:ehp2.
:p.
The standard behavior of LCLint on encountering 
:cgraphic.
   #include <X&per.h>
:ecgraphic.

is to search for a file named :font facename='System VIO' size=14x8.X&per.h:font facename=default size=0x0. on the include search path
(set using :font facename='System VIO' size=14x8.-I:font facename=default size=0x0.) and then the system base include path (usually
:font facename='System VIO' size=14x8./usr/include:font facename=default size=0x0., default is set when LCLint is compiled)&per.  If :font facename='System VIO' size=14x8.X&per.h:font facename=default size=0x0. is the name of a header file in a loaded
standard library (either
ANSI or POSIX) and :font facename='System VIO' size=14x8.X&per.h:font facename=default size=0x0. is found in a directory that is a system
directory (as set by the :font facename='System VIO' size=14x8.-sysdirs:font facename=default size=0x0. flag; the default is :font facename='System VIO' size=14x8./usr/include:font facename=default size=0x0.),
:font facename='System VIO' size=14x8.X&per.h:font facename=default size=0x0. will not be included if :font facename='System VIO' size=14x8.skip-ansi-headers:font facename=default size=0x0. or
:font facename='System VIO' size=14x8.skip-posix-headers:font facename=default size=0x0. (depending on whether :font facename='System VIO' size=14x8.X&per.h:font facename=default size=0x0. is an
ANSI or POSIX header file) is on (both are on by default)&per.  To force all
headers to be included normally, use :font facename='System VIO' size=14x8.-skip-ansi-headers:font facename=default size=0x0. and
:font facename='System VIO' size=14x8.-skip-posix-headers:font facename=default size=0x0.&per.
:p.

Sometimes headers in system directories contain non-standard syntax
which LCLint is unable to parse&per.  The :font facename='System VIO' size=14x8.+skip-sys-headers:font facename=default size=0x0. flag
may be used to prevent any include file in a system directory from being
included&per. 

:p.
LCLint is fast enough that it can be run on medium-size (10,000
line) programs without performance concerns&per.  It takes about one second to
process a thousand source lines on a DEC Alpha&per.  Libraries can be used to
enable efficient checking of small modules in large programs&per.  To further
improve performance, header file inclusion can be optimized&per.
:p.
:p.
When processing a complete system in which many files include the same headers,
a large fraction of processing time is wasted re-reading header files
unnecessarily&per.  If you are checking a 100-file program, and every file includes
:font facename='System VIO' size=14x8.utils&per.h:font facename=default size=0x0., LCLint will have to process utils&per.h 100 times (as would most C
compilers)&per.  If the :link reftype=hd res=18.:font facename='System VIO' size=14x8.+singleinclude:font facename=default size=0x0.:elink. flag is used, each header file is processed
only once&per.  Single header file processing produces a significant efficiency
improvement when checking large programs split into many files, but is only
safe if the same header file included in different contexts always has the same
meaning (i&per.e&per., it does not depend on preprocessor variable defined differently
at different inclusion sites)&per.
:p.
:p.
When processing a single file in a large system, a large fraction of the time
is spent processing included header files&per.  This can be avoided if the
information in the header files is stored in a library instead&per.  If
:link reftype=hd res=18.:font facename='System VIO' size=14x8.+neverinclude:font facename=default size=0x0.:elink. is set, inclusion of files ending in &per.h is prevented&per.  Files with
different suffixes are included normally&per.  To do this the header files must not
include any expanded macros&per. That is, the header file must be processed with
:link reftype=hd res=18.:font facename='System VIO' size=14x8.+allmacros:font facename=default size=0x0.:elink., and there must be no :font facename='System VIO' size=14x8./*@notfunction@*/:font facename=default size=0x0. control comments in the
header&per.  Then, the :link reftype=hd res=18.:font facename='System VIO' size=14x8.+neverinclude:font facename=default size=0x0.:elink. flag may be used to prevent inclusion of header
files&per.  Alternately, non-function macros can be moved to a different file with
a name that does not end in :font facename='System VIO' size=14x8.&per.h:font facename=default size=0x0.&per.  Remember, that this file must be included
directly from the :font facename='System VIO' size=14x8.&per.c:font facename=default size=0x0. file, since if it is included from a :font facename='System VIO' size=14x8.&per.h:font facename=default size=0x0. file indirectly,
that :font facename='System VIO' size=14x8.&per.h:font facename=default size=0x0. file is ignored so the other file is never included&per.
:p.
:p.
These options can be used for significant performance improvements on large
systems&per.  The performance depends on how the code is structured, but checking a
single module in a large program is several times faster if libraries and
:link reftype=hd res=18.:font facename='System VIO' size=14x8.+neverinclude:font facename=default size=0x0.:elink. are used&per.
:p.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=22.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=22.:eartlink.:link reftype=hd res=22.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: appG.html
:h2 res=22.LCLint User's Guide - Appendix G  Specifications
:font facename=default size=0x0.
:p.


.br
:font facename='Helv' size=20x12.
.br
Appendix G  Specifications:font facename=default size=0x0.
.br
.br

:p.
:hp2.:ehp2.Another way of providing more information about programs is to use
formal specifications&per.  Although this document has largely ignored
specifications, LCLint was originally designed to use the information in LCL
specifications instead of source-code annotations&per.  This document focuses on
annotations since it takes less effort to add annotations to source code than
to maintain an additional specification file&per.  Annotations can express
everything that can be expressed in LCL specifications that is relevant to
LCLint checking&per.  However, LCL specifications can provide more precise
documentation on program interfaces than is possible with LCLint annotations&per.
This
appendix (extracted from [:link reftype=hd res=25.Evans94:elink.]) is a very brief introduction to LCL
Specifications&per.
For more information, consult [:link reftype=hd res=25.GH93:elink.]&per.      
:p.
:p.
The Larch family of languages is a two-tiered approach to formal specification&per.
A specification is built using two languages -- the :hp1.Larch Shared
Language:ehp1. (LSL), which is independent of the implementation language, and a
:hp1.Larch Interface Language:ehp1. designed for the specific implementation
language&per.  An LSL specification defines :hp1.sorts:ehp1., analogous to abstract
types in a programming language, and :hp1.operators:ehp1., analogous to procedures&per.
It expresses the underlying semantics of an abstraction&per.
:p.
:p.
The interface language specifies an interface to an abstraction in a particular
programming language&per.  It captures the details of the interface needed by a
client using the abstraction and places constraints on both correct
implementations and uses of the module&per.  The semantics of the interface are
described using primitives and sorts and operators defined in LSL
specifications&per.  Interface languages have been designed for several
programming languages&per.
:p. 
:p.
LCL
[GH93, 
Tan94] is a Larch interface language for Standard C&per.  LCL uses a
C-like syntax&per.  Traditionally, a C module :hp1.M:ehp1. consists of a source file,
:hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.c:font facename=default size=0x0., and a header file, :hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.h:font facename=default size=0x0.&per.  The header
file contains prototype declarations for functions, variables and constants exported
by :hp1.M:ehp1., as well as those macro definitions that implement exported
functions or constants, and definitions of exported types&per. When using LCL, a
module includes two additional files - :hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.lcl:font facename=default size=0x0., a formal specification of
:hp1.M:ehp1., and  :hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.lh:font facename=default size=0x0., which is derived by LCLint (if the
:link reftype=hd res=22.:font facename='System VIO' size=14x8.lh:font facename=default size=0x0.:elink. flag is on) from
:hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.lcl:font facename=default size=0x0.&per.  Clients use :hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.lcl:font facename=default size=0x0. for documentation, and should
not need to look at any implementation file&per.  The derived file,
:hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.lh:font facename=default size=0x0., contains include directives (if :hp1.M:ehp1. depends on other specified modules), prototypes of functions and declarations of variables as specified in
:hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.lcl:font facename=default size=0x0.&per.  The file :hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.h:font facename=default size=0x0. should include
:hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.lh:font facename=default size=0x0. and retain the implementation aspects of the old
:hp1.M:ehp1.:font facename='System VIO' size=14x8.&per.h:font facename=default size=0x0., but is no longer used for client documentation&per.
:p.
:p.
The LCLint release package includes a grammar for LCL and examples of LCL
specifications&per.
:p.
:hp2.:hp1.Specification Flags:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.These flags are relevant only when LCLint is used with LCL
specifications&per. 
:p.
:hp2.Global Flags:ehp2.
:p.
:hp2.:ehp2.:font facename='System VIO' size=14x8.lcs:font facename=default size=0x0.
:p.
Generate :font facename='System VIO' size=14x8.&per.lcs:font facename=default size=0x0. files containing symbolic state of :font facename='System VIO' size=14x8.&per.lcl:font facename=default size=0x0. files (used for imports)&per.
By default :font facename='System VIO' size=14x8.&per.lcs:font facename=default size=0x0. files are generated for each :font facename='System VIO' size=14x8.&per.lcl:font facename=default size=0x0. file
processed&per.  Use :font facename='System VIO' size=14x8.-lcs:font facename=default size=0x0. to
prevent generation of :font facename='System VIO' size=14x8.&per.lcs:font facename=default size=0x0. files&per.
:p.
:font facename='System VIO' size=14x8.lh:font facename=default size=0x0.
:p.
Generate :font facename='System VIO' size=14x8.&per.lh:font facename=default size=0x0. files&per.  By default, :font facename='System VIO' size=14x8.-lh:font facename=default size=0x0. is set and no
:font facename='System VIO' size=14x8.&per.lh:font facename=default size=0x0. files are generated&per. Use :link reftype=hd res=22.:font facename='System VIO' size=14x8.+lh:font facename=default size=0x0.:elink. to enable &per.lh file generation&per.  
:p.

:font facename='System VIO' size=14x8.i :font facename=default size=0x0.<file>
:p.
Set LCL initialization file to :hp1.<file>:ehp1.&per.  The LCL initialization
file is read if any :font facename='System VIO' size=14x8.&per.lcl:font facename=default size=0x0. files are listed on the command line&per.  The default
file is :font facename='System VIO' size=14x8.lclinit&per.lci:font facename=default size=0x0., found on the :font facename='System VIO' size=14x8.LARCH_PATH:font facename=default size=0x0.&per.
:p.

:font facename='System VIO' size=14x8.lclexpect :font facename=default size=0x0.:hp1.<number>:ehp1.
:p.
Exactly :hp1.<number>:ehp1. specification errors are expected&per.  Specification
errors are errors detected when checking the specifications&per.  They do not
depend on the source code&per.
:p.
:hp2.Implicit Globals Checking Qualifiers:ehp2.
:p.


:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impcheckedspecglobs:font facename=default size=0x0.
.br
Implicit checked qualifier on global variables specified in an LCL file
with no checking annotation&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.----:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impcheckmodspecglobs:font facename=default size=0x0.
.br
Implicit checkmod qualifier on global variables specified in an LCL file with
no checking annotation&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.impcheckedstrictspecglobs:font facename=default size=0x0.
:p.
Implicit checked qualifier on global variables specified in an LCL file with no
checking annotation&per. 
:p.
:hp2.Implicit Annotations:ehp2.
:p.

:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.specglobimponly:font facename=default size=0x0.
:p.
Implicit only annotation on global variable declaration in an LCL file with no
allocation annotation&per.
:p.

:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.specretimponly:font facename=default size=0x0.
:p.
Implicit only annotation on return value declaration in an LCL file with no
allocation annotation&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.specstructimponly:font facename=default size=0x0.
:p.
Implicit only annotation on structure field declarations in an LCL file with no
allocation annotation&per.
:p.
:link reftype=hd res=18.shortcut:elink.
.br
:font facename='System VIO' size=14x8.specimponly:font facename=default size=0x0.
:p.
Sets :font facename='System VIO' size=14x8.specglobimponly:font facename=default size=0x0., 
:link reftype=hd res=22.:font facename='System VIO' size=14x8.specretimponly:font facename=default size=0x0.:elink. and
:link reftype=hd res=22.:font facename='System VIO' size=14x8.specstructimponly:font facename=default size=0x0.:elink.&per.
:p.
:p.
:hp2.Macro Expansion:ehp2.
:p.
:hp2.:ehp2.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.+:font facename=default size=0x0.
.br
             
:font facename='System VIO' size=14x8.specmacros:font facename=default size=0x0.
:p.
Macros defining specified identifiers are not expanded and are checked
according to the specification&per. 
:p.
:hp2.Complete Programs and Specifications:ehp2.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.-+++:font facename=default size=0x0.
.br
:hp2.:ehp2.:font facename='System VIO' size=14x8.specundef:font facename=default size=0x0.
:p.
Function, variable, iterator or constant specified but never defined&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
                   
:font facename='System VIO' size=14x8.specundecl:font facename=default size=0x0.
:p.
Function, variable, iterator or constant specified but never declared&per.
:p.
:link reftype=hd res=18.plain:elink.&colon. :font facename='System VIO' size=14x8.-:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.needspec:font facename=default size=0x0.
:p.
There is information in the specification that is not duplicated in syntactic
comments&per.  Normally, this is not an error, but it may be useful to detect it to
make sure checking incomplete systems without the specifications will still use
this information&per.
:p.
:link reftype=hd res=18.shortcut:elink.
.br
       
:font facename='System VIO' size=14x8.exportany:font facename=default size=0x0.
:p.
An error is reported for any identifier that is exported but not specified&per.
(Sets all export flags below&per.)
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.exportconst:font facename=default size=0x0.
:p.
Constant exported but not specified&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.exportvar:font facename=default size=0x0.
:p.
Variable exported but not specified&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.exportfcn:font facename=default size=0x0.
:p.
Function exported but not specified&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.exportiter:font facename=default size=0x0.
:p.
Iterator exported but not specified&per.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
            
:font facename='System VIO' size=14x8.exportmacro:font facename=default size=0x0.
:p.
An expanded macro exported but not :font facename='System VIO' size=14x8.specified:font facename=default size=0x0.
:p.
:link reftype=hd res=18.m&colon. :elink.:font facename='System VIO' size=14x8.---+:font facename=default size=0x0.
.br
:font facename='System VIO' size=14x8.exporttype:font facename=default size=0x0.
:p.            
Type definition exported but not specified 
:p.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=23.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=23.:eartlink.:link reftype=hd res=23.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: appH.html
:h2 res=23.LCLint User's Guide - Appendix H  Emacs
:font facename=default size=0x0.
:p.


.br
:font facename='Helv' size=20x12.
.br
Appendix H  Emacs:font facename=default size=0x0.
.br
.br
:p.
:hp2.:ehp2.LCLint can be used most productively with the emacs text editor&per.  The
release package includes emacs files for running LCLint and editing code with
annotations&per.
:p.
:hp2.:hp1.Running LCLint:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.LCLint release includes :font facename='System VIO' size=14x8.emacs/lclint&per.elc:font facename=default size=0x0. that defines an emacs
command, :font facename='System VIO' size=14x8.M-x lclint:font facename=default size=0x0., for running LCLint&per.  To load this file, add this line to
your :font facename='System VIO' size=14x8.&per.emacs:font facename=default size=0x0. file&colon.
:p.
:font facename='System VIO' size=14x8.(load-file ":font facename=default size=0x0.:hp1.<directory>:ehp1.:font facename='System VIO' size=14x8./lclint&per.elc"):font facename=default size=0x0.
:p.
The :font facename='System VIO' size=14x8.M-x lclint:font facename=default size=0x0. command is similar to :font facename='System VIO' size=14x8.M-x compile:font facename=default size=0x0.,
except it jumps to the exact column location of the error message,
instead of the beginning of the line&per. After typing :font facename='System VIO' size=14x8.M-x lclint:font facename=default size=0x0.,
you will be prompted for a compile command&per.  Enter the command
identically to the command that would be used to run LCLint from the
command line&per.  If errors are found, :font facename='System VIO' size=14x8.M-x next-lclint-error:font facename=default size=0x0. jumps
to the point where the next error was found&per.  (Note, this only works if
:link reftype=hd res=18.:font facename='System VIO' size=14x8.+showcolumn:font facename=default size=0x0.:elink.  is set to
make LCLint include column numbers in error messages&per.)
:p. 
:p.
The command can be bound to a key to enable rapid jumping through the error
messages&per.  For example, to set the key do :font facename='System VIO' size=14x8.CTRL:font facename=default size=0x0.-backslash add
this line to your :font facename='System VIO' size=14x8.&per.emacs:font facename=default size=0x0. file&colon. 
:p.
:cgraphic.
   (global-set-key "^\" 'next-lclint-error)
:ecgraphic.
:p.
:hp2.:hp1.Editing Abbreviations:ehp1.:ehp2.
:p.
:hp2.:hp1.:ehp1.:ehp2.An additional file, :font facename='System VIO' size=14x8.emacs/lclint-abbrevs:font facename=default size=0x0. contains abbreviations
for LCLint syntactic comments and annotations&per.  If it is loaded, the comment
surrounding an LCLint annotation will be added automatically&per.  For example,
typing ":font facename='System VIO' size=14x8.only:font facename=default size=0x0." and a space, will produce ":font facename='System VIO' size=14x8./*@only@*/:font facename=default size=0x0. "&per.
Abbreviations are provided for each LCLint syntactic comment&per.  The
abbreviation of  :font facename='System VIO' size=14x8./*@null@*/:font facename=default size=0x0. is :font facename='System VIO' size=14x8.nll:font facename=default size=0x0. (not null), since
it is often necessary to type NULL&per.  
:p. 
Abbreviations are loaded and used when a :font facename='System VIO' size=14x8.&per.c:font facename=default size=0x0. or :font facename='System VIO' size=14x8.&per.h:font facename=default size=0x0. file is edited by adding
these lines to your &per.emacs file&colon.
:p.
:font facename='System VIO' size=14x8.(quietly-read-abbrev-file ":font facename=default size=0x0.:hp1.<directory>:ehp1.:font facename='System VIO' size=14x8./lclint-abbrevs"):font facename=default size=0x0.
:p.
:font facename='System VIO' size=14x8.(setq c-mode-hook (function (lambda nil (abbrev-mode 1)))):font facename=default size=0x0.

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=25.
:elink.
:artwork name='right-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=25.:eartlink.:link reftype=hd res=25.:elink.
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:link reftype=hd res=28.:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.:elink.


.* Source filename: figures.html
:h2 res=24.Figures
:font facename=default size=0x0.
:p.
.br
:font facename='Helv' size=32x20.
.br
Figures
.br
:font facename=default size=0x0.
.br
.br
:p.
Figure 1&per.  Effort/benefit curve for LCLint&per.     (not available in HTML format)
.br
:link reftype=hd res=44.Figure 2:elink.&per.  Violations using abstract types&per.     
.br
:link reftype=hd res=45.Figure 3:elink.&per.  Boolean checking&per.    
.br
:link reftype=hd res=46.Figure 4:elink.&per.  Modifies checking&per.   
.br
:link reftype=hd res=47.Figure 5:elink.&per.  Globals checking&per.    
.br
:link reftype=hd res=48.Figure 6:elink.&per.  Deallocation errors&per. 
.br
:link reftype=hd res=49.Figure 7:elink.&per.  Stack references&per.    
.br
:link reftype=hd res=50.Figure 8:elink.&per.  Implicit annotations&per.        
.br
:link reftype=hd res=51.Figure 9:elink.&per.  Reference counting&per.  
.br
:link reftype=hd res=52.Figure 10:elink.&per.  Unique parameters&per.  
.br
:link reftype=hd res=53.Figure 11:elink.&per.  Returned parameters&per.        
.br
:link reftype=hd res=54.Figure 12:elink.&per.  Exposure checking&per.  
.br
:link reftype=hd res=55.Figure 13:elink.&per.  Use before definition&per.      
.br
:link reftype=hd res=56.Figure 14:elink.&per.  Annotated globals lists&per.    
.br
:link reftype=hd res=57.Figure 15:elink.&per.  Null checking&per.      
.br
:link reftype=hd res=58.Figure 16:elink.&per.  Using notnull&per.      
.br
:link reftype=hd res=59.Figure 17:elink.&per.  Special Clauses&per.    
.br
:link reftype=hd res=60.Figure 18:elink.&per.  Naming checks&per.      
.br
:link reftype=hd res=61.Figure 19:elink.&per.  Evaluation order    
.br
:link reftype=hd res=62.Figure 20:elink.&per.  Infinite loop checking      
.br
:link reftype=hd res=63.Figure 21:elink.&per.  Switch checking&per.    
.br
:link reftype=hd res=64.Figure 22:elink.&per.  Statements with no effect&per.  
.br
:link reftype=hd res=65.Figure 23:elink.&per.  Ignored return values&per.      
.br

:cgraphic.:ecgraphic.
.br
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.

.* Source filename: fig2.html
:h3 res=44.Figure 2&per.  Violations using abstract types&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
palindrome&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
#include ":link reftype=hd res=69.bool&per.h:elink."
#include ":link reftype=hd res=70.mstring&per.h:elink."
 
bool isPalindrome (mstring s)
{ 
   char *current = (char *) s;
   int i, len = (int) strlen (s);  
 
   for (i = 0; i &amp.lt= (len+1)/2; i++)    
     {
        if (current[i] != s[len-i-1])        
           return FALSE;   
     }  
   return TRUE;
}
 
bool callPal (void)
{
   return (isPalindrome ("bob"));
}
 
 
 
 
 
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

palindrome&per.c&colon. (in function isPalindrome)
palindrome&per.c&colon.6,29&colon. Cast from underlying abstract type
                      mstring&colon. (char *)s
  An abstraction barrier is broken&per. If necessary, use
  /*@access @*/ to allow access to an abstract
  type&per. (-abstract will suppress message)
palindrome&per.c&colon.7,31&colon. Function strlen expects arg 1 to be
                      char * gets mstring&colon. s
  Underlying types match, but mstring is an abstract
  type that is not accessible here&per.
palindrome&per.c&colon.11,27&colon. Array fetch from non-array
                       (mstring)&colon. s[len - i - 1]
  Types are incompatible&per. (-type will suppress
  message)
palindrome&per.c&colon. (in function callPal)
palindrome&per.c&colon.19,26&colon. Function isPalindrome expects arg
    1 to be mstring gets char *&colon. "bob"
  Underlying types match, but mstring is an abstract
  type that is not accessible here&per.

Finished LCLint checking --- 4 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: bool.h.html
:h4 res=69.bool&per.h
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
bool&per.h:font facename=default size=0x0.
.br
.br
:cgraphic.
#ifndef BOOL_H
#define BOOL_H
 
#ifndef FALSE
#define FALSE 0
#endif
 
#ifndef TRUE
#define TRUE (! FALSE)
#endif
 
typedef int bool;
 
# define bool_initMod()
# define bool_unparse(b) ((b) ? "true" &colon. "false" )
# define bool_not(b) ((b) ? FALSE &colon. TRUE)
# define bool_equal(a,b) ((a) ? (b) &colon. !(b))
 
# endif
 
 
 
 
 
 
 
 
:ecgraphic.

.* Source filename: mstring.h.html
:h4 res=70.mstring&per.h
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
mstring&per.h:font facename=default size=0x0.
.br
.br
:cgraphic.
typedef /*@abstract@*/ char *mstring; 
 
 
 
 
 
 
 
 
:ecgraphic.


.* Source filename: fig3.html
:h3 res=45.Figure 3&per.  Boolean checking&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
bool&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
#include ":link reftype=hd res=69.bool&per.h:elink."
 
int f (int i, char *s, 
       bool b1, bool b2)
{
  if (i = 3) 
    return b1;
  if (!i || s) 
    return i;
  if (s) 
    return 7;
  if (b1 == b2) 
    return 3;
  return 2;
}
      
 
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

bool&per.c&colon. (in function f)
bool&per.c&colon.7,12&colon. Return value type bool does not match
                declared type int&colon. b1
  To make bool and int types equivalent, use +boolint&per.
bool&per.c&colon.6,7&colon. Test expression for if is assignment
               expression&colon. i = 3
  The condition test is an assignment expression&per.
  Probably, you mean to use == instead of =&per. If an
  assignment is intended, add an extra parentheses
  nesting (e&per.g&per., if ((a = b)) &per.&per.&per.) to suppress this
  message&per. (-predassign will suppress message)
bool&per.c&colon.6,7&colon. Test expression for if not bool, type int&colon.
               i = 3
  Test expression type is not boolean or int&per.
  (-predboolint will suppress message)
bool&per.c&colon.8,8&colon. Operand of ! is non-boolean (int)&colon. !i
  The operand of a boolean operator is not a boolean&per.
  Use +ptrnegate to allow ! to be used on pointers&per.
  (-boolops will suppress message)
bool&per.c&colon.8,13&colon. Right operand of || is non-boolean (char
                *)&colon. !i || s
bool&per.c&colon.10,7&colon. Test expression for if not bool, type
                char *&colon. s
  Test expression type is not boolean&per. (-predboolptr
  will suppress message)
bool&per.c&colon.12,7&colon. Use of == with bool variables (risks
    inconsistency because of multiple true values)&colon.
    b1 == b2
  Two bool values are compared directly using a C
  primitive&per. This may produce unexpected results since
  all non-zero values are considered TRUE, so
  different TRUE values may not be equal&per. The file
  bool&per.h (included in lclint/lib) provides bool_equal
  for safe bool comparisons&per. (-boolcompare will
  suppress message)

Finished LCLint checking --- 7 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: fig4.html
:h3 res=46.Figure 4&per.  Modifies checking&per.
:font facename=default size=0x0.
:p.


.br
:font facename='Tms Rmn' size=18x10.
.br
modify&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
void setx (int *x, int *y)
  /*@modifies *x@*/
{
  *y = *x;
}
 
void sety (int *x, int *y)   
   /*@modifies *y@*/
{   
   setx (y, x); 
}
 
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

modify&per.c&colon. (in function setx)
modify&per.c&colon.4,3&colon. Undocumented modification of *y&colon. *y = *x
  An externally-visible object is modified by a
  function, but not listed in its modifies clause&per.
  (-mods will suppress message)
modify&per.c&colon.5,1&colon. Suspect object listed in modifies of
                 setx not modified&colon. *x
  An object listed in the modifies clause is not
  modified by the implementation of the function&per. The
  modification may not be detected if it is done
  through a call to an unspecified function&per. (-mustmod
  will suppress message)
   modify&per.c&colon.1,6&colon. Declaration of setx
modify&per.c&colon.1,6&colon. Function setx exported but not declared
                 in header file
  A declaration is exported, but does not appear in a
  header file&per. (-exportheader will suppress message)
   modify&per.c&colon.5,1&colon. Definition of setx
modify&per.c&colon.7,6&colon. Function sety exported but not declared
                 in header file
   modify&per.c&colon.11,1&colon. Definition of sety

Finished LCLint checking --- 4 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: fig5.html
:h3 res=47.Figure 5&per.  Globals checking&per.
:font facename=default size=0x0.
:p.


.br
:font facename='Tms Rmn' size=18x10.
.br
globals&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
int glob1, glob2;
 
int f (void) /*@globals glob1;@*/
{    
   return glob2; 
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

globals&per.c&colon. (in function f)
globals&per.c&colon.5,11&colon. Undocumented use of global glob2
  A checked global variable is used in the function,
  but not listed in its globals clause&per. By default,
  only globals specified in &per.lcl files are checked&per. To
  check all globals, use +allglobals&per. To check globals
  selectively use /*@checked@*/ in the global
  declaration&per. (-globs will suppress message)
globals&per.c&colon.3,5&colon. Global glob1 listed but not used
  A global variable listed in the function's globals
  list is not used in the body of the function&per.
  (-globuse will suppress message)
globals&per.c&colon.1,5&colon. Variable glob1 exported but not
                  declared in header file
  A variable declaration is exported, but does not
  appear in a header file&per. (Used with exportheader&per.)
  (-exportheadervar will suppress message)
globals&per.c&colon.1,12&colon. Variable glob2 exported but not
                   declared in header file
globals&per.c&colon.3,5&colon. Function f exported but not declared in
                  header file
  A declaration is exported, but does not appear in a
  header file&per. (-exportheader will suppress message)
   globals&per.c&colon.6,1&colon. Definition of f

Finished LCLint checking --- 5 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: fig6.html
:h3 res=48.Figure 6&per.  Deallocation errors&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
only&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
extern /*@only@*/ int *glob;
 
/*@only@*/ int *
  f (/*@only@*/ int *x, int *y,
     int *z)
  /*@globals int *glob;@*/
{
  int *m = (int *)
    malloc (sizeof (int));
  
  glob = y;
  free (x);
  *m = *x;
  return z;
}
 
:ecgraphic.

.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

only&per.c&colon. (in function f)
only&per.c&colon.11,3&colon. Only storage glob not released before
                assignment&colon. glob = y
  A memory leak has been detected&per. Newly-allocated or
  only-qualified storage is not released before the
  last reference to it is lost&per. (-mustfree will
  suppress message)
   only&per.c&colon.1,24&colon. Storage glob becomes only
only&per.c&colon.11,3&colon. Implicitly temp storage y assigned to
                only&colon. glob = y
  Temp storage (associated with a formal parameter) is
  transferred to a non-temporary reference&per. The
  storage may be released or new aliases created&per.
  (-temptrans will suppress message)
only&per.c&colon.13,4&colon. Dereference of possibly null pointer m&colon.
                *m
  A possibly null pointer is dereferenced&per.  Value is
  either the result of a function which may return
  null (in which case, code should check it is not
  null), or a global, parameter or structure field
  declared with the null qualifier&per. (-nullderef will
  suppress message)
   only&per.c&colon.8,12&colon. Storage m may become null
only&per.c&colon.13,9&colon. Variable x used after being released
  Memory is used after it has been released (either by
  passing as an only param or assigning to and only
  global&per. (-usereleased will suppress message)
   only&per.c&colon.12,9&colon. Storage x released
only&per.c&colon.14,10&colon. Implicitly temp storage z returned as
                 only&colon. z
only&per.c&colon.14,12&colon. Fresh storage m not released before
                 return
   only&per.c&colon.9,27&colon. Fresh storage m allocated

Finished LCLint checking --- 6 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: fig7.html
:h3 res=49.Figure 7&per.  Stack references&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
stack&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
int *glob;
 
/*@dependent@*/
int *f (int **x)
{
  int sa[2] = { 0, 1 };
  int loc = 3;
 
  glob = &amp.loc;
  *x = &amp.sa[0];
 
  return &amp.loc; 
}
 
:ecgraphic.

.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

stack&per.c&colon. (in function f)
stack&per.c&colon.12,10&colon. Stack-allocated storage &amp.loc reachable
                  from return value&colon. &amp.loc
  A stack reference is pointed to by an external
  reference when the function returns&per. The
  stack-allocated storage is destroyed after the call,
  leaving a dangling reference&per. (-stackref will
  suppress message)
;stack&per.c&colon.12,15&colon. Stack-allocated storage *x reachable
                  from parameter x
   stack&per.c&colon.10,3&colon. Storage *x becomes stack
stack&per.c&colon.12,15&colon. Stack-allocated storage glob reachable
                  from global glob
   stack&per.c&colon.9,3&colon. Storage glob becomes stack

Finished LCLint checking --- 3 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: fig8.html
:h3 res=50.Figure 8&per.  Implicit Annotations&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
implicit&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
typedef struct {
  /* only */ char *name;  /* implicit only annotation if :link reftype=hd res=18.+structimponly:elink. */
  int val;
} *rec;
 
extern /* only */ rec rec_last ; /* implicit only
annotation if :link reftype=hd res=18.+globimponly:elink. */
 
extern /* only */ rec   /* implicit if :link reftype=hd res=18.+retimponly:elink. */
  rec_create (/* temp */ char *name, /* implicit if :link reftype=hd res=18.+paramimptemp:elink. */ 
              int val);
:ecgraphic.

.* Source filename: fig9.html
:h3 res=51.Figure 9&per.  Reference counting&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
rstring&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
#include ":link reftype=hd res=71.rstring&per.h:elink."
 
static rstring rstring_ref (rstring r)
{  
  r-&amp.gtrefs++;
  return r;
}
 
rstring rstring_first (rstring r1, rstring r2)
{
  if (strcmp (r1-&amp.gtcontents, r2-&amp.gtcontents) &amp.lt 0)    
;    { 
      return r1;    
    }
  else 
    { 
      return rstring_ref (r2);    
    }
}
:ecgraphic.

.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

rstring&per.c&colon. (in function rstring_first)
rstring&per.c&colon.13,14&colon. Reference counted storage returned
    without modifying reference count&colon. r1
  Reference counted storage is transferred in a way
  that may not be consistent with the reference count&per.
  (-refcounttrans will suppress message)

Finished LCLint checking --- 1 code error found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: rstring.h.html
:h4 res=71.rstring&per.h
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
rstring&per.h:font facename=default size=0x0.
.br
.br
:cgraphic.
typedef /*@abstract@*/ /*@refcounted@*/ struct {
   /*@refs@*/ int refs;
   char *contents;
} *rstring;
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
:ecgraphic.




.* Source filename: fig10.html
:h3 res=52.Figure 10&per.  Unique parameters&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
unique&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
# include &amp.ltstring&per.h&amp.gt
; 
void  
capitalize (/*@out@*/ char *s,
            char *t)
{
  strcpy (s, t);
  *s = toupper (*s);
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

unique&per.c&colon. (in function capitalize)
unique&per.c&colon.7,11&colon. Parameter 1 (s) to function strcpy is
    declared unique but may be aliased externally by
    parameter 2 (t)
  A unique or only parameter may be aliased by some
  other parameter or visible global&per. (-mayaliasunique
  will suppress message)

Finished LCLint checking --- 1 code error found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: fig11.html
:h3 res=53.Figure 11&per.  Returned parameters&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
returned&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
#include ":link reftype=hd res=66.intSet&per.h:elink."
 
extern intSet intSet_insert  
   (/*@returned@*/ intSet s, int x);
 
/*
** with returned, no error is reported, since the same
** storage is returned from insert, and returned 
** from intSet_singleton as an implicit only result&per.
*/
 
intSet intSet_singleton (int x)
{
   return (intSet_insert (intSet_new (), x));
 }
 
/*
** without returned&colon.
*/
 
extern intSet intSet_insert2 (intSet s, int x);
 
intSet intSet_singleton2 (int x)
{
  return (intSet_insert2 (intSet_new (), x));
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

returned&per.c&colon. (in function intSet_singleton2)
returned&per.c&colon.25,27&colon. New fresh storage passed as
    implicitly temp (not released)&colon. intSet_new()
  A memory leak has been detected&per. Newly-allocated or
  only-qualified storage is not released before the
  last reference to it is lost&per. (-mustfree will
  suppress message)

Finished LCLint checking --- 1 code error found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: intSet.h.html
:h4 res=66.intSet&per.h
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
intSet&per.h:font facename=default size=0x0.
.br
.br
:cgraphic.
typedef /*@abstract@*/ struct
{
  int nelements;
  int *elements;
} *intSet ;
 
extern intSet intSet_new (void);
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
:ecgraphic.

.* Source filename: fig12.html
:h3 res=54.Figure 12&per.  Exposure checking&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
exposure&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
#include ":link reftype=hd res=67.employee&per.h:elink."
 
char *
employee_getName (employee e) 
{ 
  return e-&amp.gtname; 
}
 
/*@observer@*/ char *
employee_obsName (employee e) 
{ return e-&amp.gtname; }
 
/*@exposed@*/ char *
employee_exposeName (employee e)
{ return e-&amp.gtname; }
 
void 
employee_capName (employee e)
{
  char *name;
  
  name = employee_obsName (e);
  *name = toupper (*name);
}
 
 
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

exposure&per.c&colon. (in function employee_getName)
exposure&per.c&colon.6,10&colon. Function returns reference to
                    parameter e&colon. e->name
  The returned value shares storage with a parameter
  or global&per. If a parameter is to be returned, use the
  returned qualifier&per. If the result is not modified,
  use the observer qualifier on the result type&per.
  Otherwise, exposed can be used, but limited checking
  is done&per. (-retalias will suppress message)
exposure&per.c&colon.6,10&colon. Return value exposes rep of employee&colon.
                    e->name
  The return value shares storage with an instance of
  an abstract type&per. This means clients may have access
  to a pointer into the abstract representation&per. Use
  the observer qualifier to return exposed storage
  that may not be modified by the client&per. Use the
  exposed qualifier to return modifiable (but not
  deallocatable) exposed storage (dangerous)&per.
  (-retexpose will suppress message)
exposure&per.c&colon.6,18&colon. Released storage e->name reachable
                    from parameter at return point
  Memory is used after it has been released (either by
  passing as an only param or assigning to and only
  global&per. (-usereleased will suppress message)
   exposure&per.c&colon.6,10&colon. Storage e->name is released
exposure&per.c&colon. (in function employee_capName)
exposure&per.c&colon.23,3&colon. Suspect modification of observer
                    name&colon. *name = toupper(*name)
  Storage declared with observer is possibly modified&per.
  Observer storage may not be modified&per. (-modobserver
  will suppress message)
exposure&per.c&colon.4,1&colon. Function employee_getName exported but
                   not declared in header file
  A declaration is exported, but does not appear in a
  header file&per. (-exportheader will suppress message)
   exposure&per.c&colon.7,1&colon. Definition of employee_getName
exposure&per.c&colon.10,1&colon. Function employee_obsName exported
                    but not declared in header file
   exposure&per.c&colon.11,19&colon. Definition of employee_obsName
exposure&per.c&colon.14,1&colon. Function employee_exposeName exported
                    but not declared in header file
   exposure&per.c&colon.15,19&colon. Definition of employee_exposeName
exposure&per.c&colon.18,1&colon. Function employee_capName exported
                    but not declared in header file
   exposure&per.c&colon.24,1&colon. Definition of employee_capName

Finished LCLint checking --- 8 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: employee.h.html
:h4 res=67.employee&per.h
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
employee&per.h:font facename=default size=0x0.
.br
.br
:cgraphic.
typedef /*@abstract@*/ struct
{
  char *name;
  int *id;
} *employee;
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
:ecgraphic.

.* Source filename: fig13.html
:h3 res=55.Figure 13&per.  Use before definition&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
usedef&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
extern void 
  setVal (/*@out@*/ int *x);
extern int 
  getVal (/*@in@*/ int *x);
extern int mysteryVal (int *x);
 
int 
dumbfunc (/*@out@*/ int *x, int i)
{
  if (i &amp.gt 3) 
;    return *x;
  else if (i &amp.gt 1) 
;    return getVal (x);
  else if (i == 0) 
    return mysteryVal (x);
  else
    { 
      setVal (x);
      return *x;
    }     
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

usedef&per.c&colon. (in function dumbfunc)
usedef&per.c&colon.11,12&colon. Value *x used before definition
  An rvalue is used that may not be initialized to a
  value on some execution path&per. (-usedef will suppress
  message)
usedef&per.c&colon.13,20&colon. Passed storage x not completely
    defined (*x is undefined)&colon. getVal (x)
  Storage derivable from a parameter, return value or
  global is not defined&per. Use /*@out@*/ to denote
  passed or returned storage which need not be
  defined&per. (-compdef will suppress message)
usedef&per.c&colon.15,24&colon. Passed storage x not completely
    defined (*x is undefined)&colon. mysteryVal (x)

Finished LCLint checking --- 3 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: fig14.html
:h3 res=56.Figure 14&per.  Annotated Globals Lists&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
annotglobs&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
int globnum;
 
struct { 
  char *firstname;
  char *lastname;
  int id; 
} globname;
 
void 
initialize (/*@only@*/ char *name)
  /*@globals undef globnum,
             undef globname @*/
{
  globname&per.id = globnum;
  globname&per.lastname = name;
}
 
void finalize (void)
   /*@globals killed globname@*/
{
  free (globname&per.lastname);
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

annotglobs&per.c&colon. (in function initialize)
annotglobs&per.c&colon.14,17&colon. Undef global globnum used before
                       definition
  An rvalue is used that may not be initialized to a
  value on some execution path&per. (-usedef will suppress
  message)
annotglobs&per.c&colon.16,2&colon. Global storage globname contains 1
    undefined field when call returns&colon. firstname
  Storage derivable from a parameter, return value or
  global is not defined&per. Use /*@out@*/ to denote
  passed or returned storage which need not be
  defined&per. (-compdef will suppress message)
annotglobs&per.c&colon. (in function finalize)
annotglobs&per.c&colon.22,2&colon. Only storage globname&per.firstname
    (type char *) derived from killed global is not
    released (memory leak)
  A storage leak due to incomplete deallocation of a
  structure or deep pointer is suspected&per. Unshared
  storage that is reachable from a reference that is
  being deallocated has not yet been deallocated&per.
  LCLint assumes when an object is passed as an out
  only void pointer that the outer object will be
  deallocated, but the inner objects will not&per.
  (-compdestroy will suppress message)

Finished LCLint checking --- 3 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: fig15.html
:h3 res=57.Figure 15&per.  Null checking&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
null&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
char firstChar1 (/*@null@*/ char *s)
{
  return *s;
}
 
char firstChar2 (/*@null@*/ char *s)
{
  if (s == NULL) return '\0';
  return *s;
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

null&per.c&colon. (in function firstChar1)
null&per.c&colon.3,11&colon. Dereference of possibly null pointer s&colon.
                *s
  A possibly null pointer is dereferenced&per.  Value is
  either the result of a function which may return
  null (in which case, code should check it is not
  null), or a global, parameter or structure field
  declared with the null qualifier&per. (-nullderef will
  suppress message)
   null&per.c&colon.1,35&colon. Storage s may become null

Finished LCLint checking --- 1 code error found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.

.* Source filename: fig16.html
:h3 res=58.Figure 16&per.  Using notnull&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
mstringnn&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
typedef /*@abstract@*/ /*@null@*/ char *mstring;
 
static mstring mstring_createNew (int x) ;
 
mstring mstring_space1 (void)
{
  mstring m = mstring_createNew (1);
 
  /* error, since m could be NULL */
  *m = ' '; *(m + 1) = '\0';
  return m;
}
 
static /*@notnull@*/ mstring mstring_createNewNN (int x) ;
 
mstring mstring_space2 (void)
{
  mstring m = mstring_createNewNN (1);
 
  /* no error, because of notnull annotation */
  *m = ' '; *(m + 1) = '\0';
  return m;
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

mstringnn&per.c&colon. (in function mstring_space1)
mstringnn&per.c&colon.10,4&colon. Dereference of possibly null pointer
                     m&colon. *m
  A possibly null pointer is dereferenced&per.  Value is
  either the result of a function which may return
  null (in which case, code should check it is not
  null), or a global, parameter or structure field
  declared with the null qualifier&per. (-nullderef will
  suppress message)
   mstringnn&per.c&colon.7,15&colon. Storage m may become null

Finished LCLint checking --- 1 code error found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.



.* Source filename: fig17.html
:h3 res=59.Figure 17&per.  Special Clauses
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
special&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
typedef struct 
{
  int id;
  /*@only@*/ char *name;
} *record;
 
static /*@special@*/ record record_new (void)
  /*@defines result->id@*/
{
  record r = (record) malloc (sizeof (*r));
 
  assert (r != NULL);
  r->id = 3;
  return r;
}
 
static void record_setName (/*@special@*/ record r, /*@only@*/ char *name)
   /*@defines r->name@*/
{
  r->name = name;
}
 
record record_create (/*@only@*/ char *name)
{
  record r = record_new ();
  record_setName (r, name);
  return r;
}
 
void record_clearName (/*@special@*/ record r)
   /*@releases r->name@*/
   /*@post&colon.isnull r->name@*/
{
  free (r->name);
  r->name = NULL;
}
 
void record_free (/*@only@*/ record r)
{
  record_clearName (r);
  free (r);
}
 
 
 
 
 
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: fig18.html
:h3 res=60.Figure 18&per.  Naming Checks
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
names&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
char *stringreverse (char *s);
 
int f (int x)
{
  int lookalike = 1;
  int looka1ike = 2;
 
  if (x &amp.gt 3)
;    {
      int x = lookalike;
      x += looka1ike;
    }
 
  return x;
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

names&per.c&colon.1,7&colon. Name stringreverse is reserved for future
    ANSI library extensions&per.  Functions that begin
    with "str" and a lowercase letter may be added to
     or &per. (See ANSI, Section
    4&per.13&per.7)
  External name is reserved for system in ANSI
  standard&per. (-ansireserved will suppress message)
names&per.c&colon. (in function f)
names&per.c&colon.6,7&colon. Internal identifier looka1ike is not
    distinguishable from lookalike except by lookalike
    characters
  An internal name is not distinguishable from another
  internal name using the number of significant
  characters&per. According to ANSI Standard (3&per.1), an
  implementation may only consider the first 31
  characters significant&per. The +internalnamelen 
  flag changes the number of significant characters,
  -internalnamecaseinsensitive to makes alphabetical
  case significant, and +internalnamelookalike to make
  similar-looking characters non-distinct&per.
  (-distinctinternalnames will suppress message)
   names&per.c&colon.5,7&colon. Declaration of lookalike
names&per.c&colon.10,11&colon. Variable x shadows outer declaration
  An outer declaration is shadowed by the local
  declaration&per. (-shadow will suppress message)
   names&per.c&colon.3,12&colon. Previous declaration of x&colon. int

Finished LCLint checking --- 3 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: fig19.html
:h3 res=61.Figure 19&per.  Evaluation Order
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
order&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
extern int glob;
 
extern int mystery (void);
 
extern int modglob (void)
   /*@globals glob@*/
   /*@modifies glob@*/ ;
 
int f (int x, int y[])
{
  int i = x++ * x;
 
  y[i] = i++;
  i += modglob() * glob;
  i += mystery() * glob;
  return i;
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

order&per.c&colon. (in function f)
order&per.c&colon.11,17&colon. Expression has undefined behavior
    (value of right operand modified by left operand)&colon.
    x++ * x
  Code has unspecified behavior&per. Order of evaluation
  of function parameters or subexpressions is not
  defined, so if a value is used and modified in
  different places not separated by a sequence point
  constraining evaluation order, then the result of
  the expression is unspecified&per. (-evalorder will
  suppress message)
order&per.c&colon.13,11&colon. Expression has undefined behavior (left
    operand uses i, modified by right operand)&colon.
    y[i] = i++
order&per.c&colon.14,20&colon. Expression has undefined behavior
    (value of right operand modified by left operand)&colon.
    modglob() * glob
order&per.c&colon.15,20&colon. Expression has undefined behavior
    (unconstrained function mystery used in left
    operand may set global variable glob used in right
    operand)&colon. mystery() * glob
  Code involving a call to function with no modifies
  or globals clause may have undefined or
  implementation-dependent behavior (LCLint assumes
  the unconstrained call may modify any reachable
  state or use any global)&per. Add a specification for
  the function&per. (-evalorderuncon will suppress
  message)

Finished LCLint checking --- 4 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.



.* Source filename: fig20.html
:h3 res=62.Figure 20&per.  Infinite loop checking
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
loop&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
extern int glob1, glob2;
 
extern int f (void) 
  /*@globals glob1@*/ 
  /*@modifies nothing@*/ ;
 
extern void g (void) 
  /*@modifies glob2@*/ ;
 
extern void h (void) ; 
 
void upto (int x) 
{
  while (x &amp.gt f()) g();
  while (f() &amp.lt 3) h();
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

loop&per.c&colon. (in function upto)
loop&per.c&colon.14,10&colon. Suspected infinite loop&per.  No value used
    in loop test (x, glob1) is modified by test or
    loop body&per.
  This appears to be an infinite loop&per. Nothing in the
  body of the loop or the loop test modifies the value
  of the loop test&per. Perhaps the specification of a
  function called in the loop body is missing a
  modification&per. (-infloops will suppress message)

Finished LCLint checking --- 1 code error found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: fig21.html
:h3 res=63.Figure 21&per.  Switch checking&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
switch&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
typedef enum {
  YES, NO, DEFINITELY,
  PROBABLY, MAYBE } ynm;
 
void decide (ynm y)
{
  switch (y)
    {
    case PROBABLY&colon.
    case NO&colon. printf ("No!");
    case MAYBE&colon. printf ("Maybe");    
         /*@fallthrough@*/
    case YES&colon. printf ("Yes!");
    }
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

noeffect&per.c&colon. (in function noeffect)
noeffect&per.c&colon.6,3&colon. Statement has no effect&colon. y == *x
  Statement has no visible effect --- no values are
  modified&per. (-noeffect will suppress message)
noeffect&per.c&colon.7,3&colon. Statement has no effect&colon. nomodcall(x)
noeffect&per.c&colon.8,3&colon. Statement has no effect (possible
    undected modification through call to
    unconstrained function mysterycall)&colon.
    mysterycall(x)
  Statement has no visible effect --- no values are
  modified&per. It may modify something through a call to
  an unconstrained function&per. (-noeffectuncon will
  suppress message)

Finished LCLint checking --- 3 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


.* Source filename: fig22.html
:h3 res=64.Figure 22&per.  Statements with no effect&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
noeffect&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
extern void nomodcall (int *x) /*@*/;
extern void mysterycall (int *x);
 
int noeffect (int *x, int y)
{
  y == *x;
  nomodcall (x);  
  mysterycall (x); 
  return *x;
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.2 --- 25 Aug 96

noeffect&per.c&colon. (in function noeffect)
noeffect&per.c&colon.6,3&colon. Statement has no effect&colon. y == *x
  Statement has no visible effect --- no values are
  modified&per. (-noeffect will suppress message)
noeffect&per.c&colon.7,3&colon. Statement has no effect&colon. nomodcall(x)
noeffect&per.c&colon.8,3&colon. Statement has no effect (possible
    undected modification through call to
    unconstrained function mysterycall)&colon.
    mysterycall(x)
  Statement has no visible effect --- no values are
  modified&per. It may modify something through a call to
  an unconstrained function&per. (-noeffectuncon will
  suppress message)

Finished LCLint checking --- 3 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.


/html>

.* Source filename: fig23.html
:h3 res=65.Figure 23&per.  Ignored return values&per.
:font facename=default size=0x0.
:p.

.br
:font facename='Tms Rmn' size=18x10.
.br
ignore&per.c:font facename=default size=0x0.
.br
.br
:cgraphic.
extern int fi (void);
extern bool fb (void);
extern int /*@alt void@*/ 
  fv (void);
 
int ignore (void)
{
  fi ();                
  (void) fi ();
  fb ();
  fv ();
  return fv ();
}
:ecgraphic.
.br
:font facename='Tms Rmn' size=18x10.
.br
LCLint Output:font facename=default size=0x0.
.br
.br
:cgraphic.
LCLint 2&per.0 --- 28 Feb 96

ignore&per.c&colon. (in function ignore)
ignore&per.c&colon.8,3&colon. Return value (type int) ignored&colon. fi()
  Result returned by function call is not used&per.  If
  this is intended, can cast result to (void) to
  eliminate message&per.  Use -retvalint to suppress
  message&per.
ignore&per.c&colon.10,3&colon. Return value (type bool) ignored&colon. fb()
  Result returned by function call is not used&per.  If
  this is intended, can cast result to (void) to
  eliminate message&per.  Use -retvalbool to suppress
  message&per.

Finished LCLint checking --- 2 code errors found
:ecgraphic.
:link reftype=hd res=27.
:elink.:artwork name='lclint-home-small.bmp' align=left.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.
 
:link reftype=hd res=2.David Evans:elink. 
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.



.* Source filename: references.html
:h2 res=25.LCLint User's Guide - References
:font facename=default size=0x0.
:p.


.br
:font facename='Helv' size=20x12.
.br
References
:font facename=default size=0x0.
.br
.br
.br
:font facename='Tms Rmn' size=16x8.
.br
LCLint:font facename=default size=0x0.
.br
.br

[Evans94]
David Evans&per. :link reftype=hd res=73.:hp1.Using specifications to check source code:ehp1.:elink.&per.
MIT/LCS/TR 628, Laboratory for Computer Science, MIT, June 1994&per.
:p.
:p.
SM Thesis&per.  Describes research behind LCLint, focusing on how specifications
can be exploited to do lightweight checking&per.  Includes case studies using
LCLint&per.

:p.

[EGHT94]
David Evans, John Guttag, Jim Horning and Yang Meng Tan&per.  
:link reftype=hd res=72.:hp1.LCLint&colon. A
tool for using specifications to check code:ehp1.:elink.&per.  SIGSOFT Symposium on the
Foundations of Software Engineering, December 1994&per.
:p.
:p.
Introduction to LCLint&per.  Shows how LCLint is used to find errors in a sample
program&per.

:p.

[Evans96]
David Evans&per.  
:link reftype=hd res=68.
:hp1.Static Detection of Dynamic Memory Errors:ehp1.:elink.&per.  In SIGPLAN Conference on Programming Language Design and Implementation
(PLDI '96), Philadelphia, PA&per., May 1996&per.
:p.
:p.
Describes approach for exploiting annotations added to code to detect a wide
class of errors&per.  Focuses on checks described in Sections 5-7 of this guide&per.  

.br
:font facename='Tms Rmn' size=16x8.
.br
Larch:font facename=default size=0x0.
.br
.br

[GH93] Guttag, John V&per. and Horning, James J&per., with Stephen J&per. Garland, Kevin D&per.
Jones, Andrs Modet, and Jeannette M&per. Wing, :hp5.Larch&colon. Languages and
Tools for Formal Specification:ehp5., Springer-Verlag, Texts and Monographs in
Computer Science, 1993&per.
:p.
:p.
Overview of the Larch family of specification languages and related tools&per.
Includes a chapter on LCL, the Larch C interface language, on which LCLint is
based&per.

:p.

[Tan95] Tan, Yang Meng&per.  :hp5.Formal Specification Techniques for
Engineering Modular C:ehp5., Kluwer International Series in Software
Engineering, Volume 1, Kluwer Academic Publishers, Boston, 1995&per.
:p.
:p.
Modified and updated version of MIT Ph&per. D&per. dissertation, previously
published as MIT/LCS/TR-619, 1994&per.  Includes presentation of the
semantics of LCL and a case study using LCL&per.

.br
:font facename='Tms Rmn' size=16x8.
.br
C:font facename=default size=0x0.
.br
.br

[ANSI] American National Standard for Information Systems, Programming
Language, C&per.  ANSI X3&per.159-1989&per.  (Believed to be identical to ISO/IEC
9899&colon.1990)&per.  
:p.
Specification for C programming language&per.  LCLint aims to be consistent with
this
document&per.



[Hat95] Hatton, Les&per.  :hp5.Safer C&colon. Developing Software for High-integrity and
Safety-critical
Systems&per.:ehp5.
McGraw-Hill International Series in Software Engineering, 1995&per.
:p.
A broad work on all aspects of developing safety-critical software, focusing on
the C language&per.  Provides good justification for the use of C in
safety-critical systems, and the necessity of tool-supported programming
standards&per.  LCLint users will be interested to see how many of the errors
listed as only being dynamically detectable can be detected statically by
LCLint&per.



[KR88] Kernighan, Brian W&per. and Ritchie, Dennis M&per.  :hp5.The C Programming
Language:ehp5., second edition&per.  Prentice Hall, New Jersey, 1988&per.
:p.
Standard reference for ANSI C&per.  If you haven't heard of this one, you probably
didn't get this far (unless you started at the back)&per.


[vdL94] Van der Linden, Peter&per.  :hp5.Expert C Programming&colon.  Deep C Secrets:ehp5.&per.
SunSoft Press, Prentice Hall, New Jersey,  1994&per.
:p.
Filled with useful information on the darker corners of C, as well as lots of
industry anecdotes and humor&per.  LCLint's reserved name checking is loosely based
on the list of reserved names in this book&per.

.br
:font facename='Tms Rmn' size=16x8.
.br
Abstract
Types
:font facename=default size=0x0.
.br
.br

[LG86] Liskov, Barbara&per. and Guttag, John V&per.  :hp5.Abstraction and Specification
in
Program Development:ehp5., MIT Press, Cambridge, MA, 1986&per.
:p.
Describes a programming methodology using abstract types and specified
interfaces&per.  Much of the methodology upon which LCLint is based comes from this
book&per.
Uses the CLU programming language&per.




:p.
:cgraphic.:ecgraphic.
.br
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.

.* Source filename: acknowledgements.html
:h2 res=26.Acknowledgements
:font facename=default size=0x0.
:p.

.br
:font facename='Helv' size=32x20.
.br
Acknowledgements
.br
:font facename=default size=0x0.
.br
.br

:link reftype=hd res=29.John Guttag:elink. and
:link reftype=hd res=30.Jim
Horning:elink. had the original idea for LCLint, have provided valuable
advice on its functionality and design, and been instrumental in its
development&per.  This work has also benefited greatly from discussions with
Mike Burrows, Stephen Garland,
Colin Godfrey, Steve Harrison, Daniel Jackson, Angelika Leeb, Ulana Legedza, Raymie Stata, Yang Meng Tan, and
:link reftype=hd res=31.Mark Vandevoorde:elink.&per.
I especially thank Angelika Leeb for many constructive comments on
improving the User's Guide, Raymie Stata for help designing and setting
up the web site and Mark Vandevoorde for technical assistance&per.  
:p. Much
of LCLint's development has been driven by feedback from users in
academia and industry&per.  Many more people than I can mention here have
made contributions by suggesting improvements, reporting bugs, porting
early versions of LCLint to other platforms&per.  Particularly heroic
contributions have been made by Eric Bloodworth, Jutta Degener, Rick
Farnbach, Chris Flatters, Huver Hu, John Gerard Malecki, Thomas G&per.
McWilliams, Michael Meskes, Richard O'Keefe, Jens Schweikhardt, and
Albert L&per. Ting&per.  Martin "Herbert" Dietze and Mike Smith performed
valiantly in producing the Win32 and OS2 ports&per.


:p. LCLint incorporates the original LCL checker developed by Yang Meng
Tan&per.  This was built on the DECspec Project (Joe Wild, Gary Feldman,
Steve Garland, and Bill McKeeman)&per.  The LSL checker used by LCLint was
developed by Steve Garland&per.  The original C grammar for LCLint was
provided by Nate Osgood&per.

:p.

This research was supported by grants from ARPA (N0014-92-J-1795), NSF
(9115797-CCR) and DEC ERP&per.  David Evans is supported by an Intel
Foundation Fellowship&per.  LCLint is developed on DEC 3000/500 and
DECmips machines provided by :link reftype=hd res=32.Digital
Equipment Corporation:elink. and Pentium Pro (tm) machines donated by Intel Corporation&per.  This document was produced using
Pentium (tm) and Pentium Pro (tm) Computers donated by Intel Corporation and Microsoft
Office (tm) software donated by Microsoft&per. 

:p.
:hp3.If you are listed here, and want me to add a link to your homepage,
send :link reftype=hd res=28.me:elink. email&per.:ehp3.
:p.


:cgraphic.:ecgraphic.
.br
:link reftype=hd res=1.
:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.
:link reftype=hd res=27.
:elink.
.br
:link reftype=hd res=3.Systematic Program Development:elink.
.br
:hp3.evs@larch&per.lcs&per.mit&per.edu:ehp3.



.* Source filename: guide_fn.html
:h1 res=5.Footnotes
:font facename=default size=0x0.
:p.



.br
:font facename='Helv' size=20x12.
.br
Footnotes:font facename=default size=0x0.
.br
.br

1 Lint is a common programming tool for detecting anomalies in C
programs&per.  The original lint was developed by S&per. C&per. Johnson in the late
seventies, mainly because early versions of C did not support function prototypes&per.
:p.

2 Another way to provide extra information about code is to use formal
specifications (:link reftype=hd res=22.Appendix G:elink.)&per.
:p.

3 Unlike regular C comments, control comments should not be used within a
single token&per.  They may introduce new separators in the code during parsing&per.
:p.

4 For abstract types whose instances can change value, a client does need to
know if assignment has copy or sharing semantics (see Section 3&per.2)&per.
:p.

5 :hp3.Does not apply to HTML version&per.:ehp3.
:hp1.italics:ehp1.&per. 
:p.

6 The meta-notation, item,+ is used to denote a comma separated list of items&per.
For example, :font facename='System VIO' size=14x8./*@access mstring, intSet@*/:font facename=default size=0x0. provides access to
the representations of both :font facename='System VIO' size=14x8.mstring:font facename=default size=0x0. and :font facename='System VIO' size=14x8.intSet:font facename=default size=0x0.&per.)   
:p.

7 Through the parameter&per.  Modifications using some other variable that has a
pointer to the location of this parameter are not considered&per.
:p.

8 The flag :link reftype=hd res=18.:font facename='System VIO' size=14x8.-booltype:font facename=default size=0x0.:elink.
can be used to select a different name for the boolean type&per.  To change
the names of :font facename='System VIO' size=14x8.TRUE:font facename=default size=0x0. and :font facename='System VIO' size=14x8.FALSE:font facename=default size=0x0., use :font facename='System VIO' size=14x8.-booltrue:font facename=default size=0x0.
 and :link reftype=hd res=18.:font facename='System VIO' size=14x8.-boolfalse:font facename=default size=0x0.:elink.&per.  The
LCLint distribution includes an implementation of :font facename='System VIO' size=14x8.bool:font facename=default size=0x0., in :font facename='System VIO' size=14x8.lib/bool&per.h:font facename=default size=0x0.&per.
However, it isn't necessary to use this implementation to get the
benefits of boolean checking&per.
:p. 

9 This means that theoreticians can prove that no algorithm exists that solves
the problem correctly for all possible programs&per.
:p.

10 This section is largely based on [Evans96]&per.  It semi-formally defines
some of the terms needed to describe memory management checking;  if you are satisfied with an intuitive understanding of these terms, this section may be
skipped&per.
:p.

11 This is similar to the LISP storage model, except that objects are typed&per.
:p.

12 Except :font facename='System VIO' size=14x8.sizeof:font facename=default size=0x0., which does not need the value of its argument&per.
:p.

13 If the storage is not assigned to a reference, an internal reference
is created to track the storage&per.
:p.

14 The full declaration of :font facename='System VIO' size=14x8.malloc:font facename=default size=0x0. also includes a :font facename='System VIO' size=14x8.null:font facename=default size=0x0.
annotation (:link reftype=hd res=10.Section 7&per.2:elink.) to
indicate that the result may be :font facename='System VIO' size=14x8.NULL:font facename=default size=0x0. (as it is when the requested storage
cannot be allocated) and an :font facename='System VIO' size=14x8.out:font facename=default size=0x0. annotation (Section 7&per.1) to indicate that the result
points to undefined storage&per.
:p. 

15 The full declaration of :font facename='System VIO' size=14x8.free:font facename=default size=0x0. also has :font facename='System VIO' size=14x8.out:font facename=default size=0x0. and
:font facename='System VIO' size=14x8.null:font facename=default size=0x0. annotations on the parameter to indicate that the argument
may be :font facename='System VIO' size=14x8.NULL:font facename=default size=0x0. and need not point to defined storage&per.  According
to [:link reftype=hd res=1.ANSI:elink., 4&per.10&per.3&per.2], :font facename='System VIO' size=14x8.NULL:font facename=default size=0x0. may
be passed to :font facename='System VIO' size=14x8.free:font facename=default size=0x0. without an error&per.  On some UNIX platforms,
passing :font facename='System VIO' size=14x8.NULL:font facename=default size=0x0. to :font facename='System VIO' size=14x8.free:font facename=default size=0x0. causes a program crash so the
UNIX version of the standard library (Appendix F) specifies :font facename='System VIO' size=14x8.free:font facename=default size=0x0. without the
:font facename='System VIO' size=14x8.null:font facename=default size=0x0. annotation on its parameter&per. To check that allocated
objects are completely destroyed (e&per.g&per., all unshared objects inside a
structure are deallocated before the structure is deallocated), LCLint
checks that any parameter passed as an :font facename='System VIO' size=14x8.out only void *:font facename=default size=0x0. does not
contain references to live, unshared objects&per.  This makes sense, since
such a parameter could not be used sensibly in any way other than
deallocating its storage&per. 
:p.

16 If an exposure qualifier is used (see Section 6&per.2), the implied dependent
annotation is used instead of the more generally implied only
annotation&per.  
:p. 

17 Strictly, we should also check that the returned :font facename='System VIO' size=14x8.observer:font facename=default size=0x0. storage is not
used again after any other calls to the abstract type module using the same
parameter&per.  LCLint does not attempt to check this, and in practice it is not
usually a problem&per.
:p.

18 Note that if the parameter is annotated with :font facename='System VIO' size=14x8.only:font facename=default size=0x0., it is not an error to
assign it to part of an abstract representation, since the caller may not use
the storage after the call returns&per.
:p.

19 That is, the return type is :font facename='System VIO' size=14x8.bool:font facename=default size=0x0., or :font facename='System VIO' size=14x8.int:font facename=default size=0x0. if +boolint is used&per. 
:p. 

20 The sef annotation denotes a parameter as side-effect free (see Section 8&per.2&per.1)&per. 
By declaring the argument to assert to be side-effect free, LCLint will report
errors if the parameter to assert produces a side-effect&per.  This is especially
pertinent if assertions are turned off when the production version is compiled&per.
The :font facename='System VIO' size=14x8.bool /*@alt int@*/:font facename=default size=0x0. type specifier for the parameter means
the parameter type must match either :font facename='System VIO' size=14x8.bool:font facename=default size=0x0. or :font facename='System VIO' size=14x8.int:font facename=default size=0x0.&per.
Alternate types are described in :link reftype=hd res=11.Section
8&per.2&per.2:elink.&per.
:p. 

21 To be completely correct, all the macro parameters should be evaluated
before the macro has any side-effects&per.  Since checking this would require
extensive analysis for occasional modest gain, it was not considered worth
implementing&per.
:p.

22 Note that functions which do not produce to the same result each time they
are called with the same arguments should be declared to modify internalState
so they  will lead to errors if they are passed as sef parameters&per.
:p.

23 The most renown C naming convention is the Hungarian naming convention,
introduced by Charles Simonyi [Simonyi, Charles, and Martin Heller&per.  "The
Hungarian Revolution&per."  :hp1.BYTE:ehp1., August 1991, p&per. 131-38]&per.  The names for
LCLint naming conventions follow the tradition of using Central European
nationalities as mnemonics for naming conventions&per.  The LCLint conventions are
similar to the Hungarian naming convention in that they encode type information
in names, except that the LCLint conventions encode the names of accessible
abstract types instead of the type of the declaration of return value&per.
Prefixes used in the Hungarian naming convention are not supported by LCLint&per.
:p.

24 Namespace prefixes should probably be described by regular expressions&per.
LCLint uses a simpler, more limited means for describing names, which is
believed to be adequate for describing most useful naming conventions&per.  If
there is sufficient interest, regular expressions may be supported in a future
version of LCLint&per.
:p.

25 Peter van der Linden estimates that default fall through is the wrong
behavior 97% of the time&per.  [:link reftype=hd res=1.vdL95:elink., p&per. 37]
:p.

26 "Software Glitch Cripples AT&amp.T Network", Telephony, 22 January 1990&per.
:p.

27 In earlier versions of LCLint, the default extension :font facename='System VIO' size=14x8.&per.lldmp:font facename=default size=0x0. was used&per.  This
has been shortened to :font facename='System VIO' size=14x8.&per.lcd:font facename=default size=0x0.&per.
:cgraphic.:ecgraphic.
.br
:link reftype=hd res=1.:elink.
:artwork name='up-arrow.bmp' align=left runin.:artlink.:link reftype=hd res=1.:eartlink.:link reftype=hd res=1.:elink.:link reftype=hd res=27.:elink.
:artwork name='lclint-home-small.bmp' align=left runin.:artlink.:link reftype=hd res=27.:eartlink.:link reftype=hd res=27.:elink.:link reftype=hd res=2.:elink.
.br
:link reftype=hd res=3.:elink.
.br
:link reftype=hd res=28.:hp3.:ehp3.:elink.




:h1.External links
:font facename=default size=0x0.
:p.This chapter contains all external links referenced in this book -
either link is an Unified Resource Locator (URL) or simply to a
local file which is not a part of this book.
:h2 res=3.http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='http://larch-www.lcs.mit.edu:8001/'.
http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/
:elink.:elines.
:h2 res=27.http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/larch/lclint/index&per.html
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='http://larch-www.lcs.mit.edu:8001/larch/lclint/index.html'.
http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/larch/lclint/index&per.html
:elink.:elines.
:h2 res=28.mailto&colon.evs@larch&per.lcs&per.mit&per.edu
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='mailto:evs@larch.lcs.mit.edu'.
mailto&colon.evs@larch&per.lcs&per.mit&per.edu
:elink.:elines.
:h2 res=39.http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/larch/lclint/run&per.html
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='http://larch-www.lcs.mit.edu:8001/larch/lclint/run.html'.
http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/larch/lclint/run&per.html
:elink.:elines.
:h2 res=2.http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/~evs
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='http://larch-www.lcs.mit.edu:8001/~evs'.
http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/~evs
:elink.:elines.
:h2 res=68.http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/~evs/pldi96-abstract&per.html
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='http://larch-www.lcs.mit.edu:8001/~evs/pldi96-abstract.html'.
http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/~evs/pldi96-abstract&per.html
:elink.:elines.
:h2 res=72.http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/~evs/sigsoft94&per.html
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='http://larch-www.lcs.mit.edu:8001/~evs/sigsoft94.html'.
http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/~evs/sigsoft94&per.html
:elink.:elines.
:h2 res=73.http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/~evs/tr-628&per.html
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='http://larch-www.lcs.mit.edu:8001/~evs/tr-628.html'.
http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/~evs/tr-628&per.html
:elink.:elines.
:h2 res=29.http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/~guttag/
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='http://larch-www.lcs.mit.edu:8001/~guttag/'.
http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/~guttag/
:elink.:elines.
:h2 res=31.http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/~mtv
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='http://larch-www.lcs.mit.edu:8001/~mtv'.
http&colon.//larch-www&per.lcs&per.mit&per.edu&colon.8001/~mtv
:elink.:elines.
:h2 res=30.http&colon.//reality&per.sgi&per.com/employees/horning_mti/home&per.html
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='http://reality.sgi.com/employees/horning_mti/home.html'.
http&colon.//reality&per.sgi&per.com/employees/horning_mti/home&per.html
:elink.:elines.
:h2 res=32.http&colon.//www&per.digital&per.com/
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='http://www.digital.com/'.
http&colon.//www&per.digital&per.com/
:elink.:elines.
:h2 res=4.http&colon.//www&per.lcs&per.mit&per.edu/
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='http://www.lcs.mit.edu/'.
http&colon.//www&per.lcs&per.mit&per.edu/
:elink.:elines.
:h2 res=41.mailto&colon.lclint-bug@larch&per.lcs&per.mit&per.edu
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='mailto:lclint-bug@larch.lcs.mit.edu'.
mailto&colon.lclint-bug@larch&per.lcs&per.mit&per.edu
:elink.:elines.
:h2 res=40.mailto&colon.lclint@larch&per.lcs&per.mit&per.edu
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='mailto:lclint@larch.lcs.mit.edu'.
mailto&colon.lclint@larch&per.lcs&per.mit&per.edu
:elink.:elines.
:h2 res=43.news&colon.comp&per.specification&per.larch
:font facename=default size=0x0.
:p.:lines align=center.
The link you selected points to an external resource&per. Click the URL below to launch IBM Web Explorer
:font facename='System VIO' size=24x14.
:p.:link reftype=launch object='explore.exe ' data='news:comp.specification.larch'.
news&colon.comp&per.specification&per.larch
:elink.:elines.
:euserdoc.
