/* **********************************************************************
*  *               Installer for Build-o-Rama                                                *
*  *                       Copyright Three Cat Software 1995 All Rights Reserved         *
*  **********************************************************************
*
*/
 

   '@echo off'
   trace off

   /* Parse Call Path Info
   */
   Parse Source . . callPath

   /* Load in function library
   */
   Call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
   Call SysLoadFuncs

   Call SysCls

sayit = '* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *'
SAY sayit
SAY '            Build-o-Rama installation program                                  '
SAY sayit
SAY ' This program will ask you for an installation directory,'
SAY ' and for the drive letter where Visual C++ is installed.'
SAY ' The program will create a file called AUTOBILD.BAT in the '
SAY ' installation directory that contains a CALL to the'
SAY ' MSVCVARS.BAT file. If this file is not in the default'
SAY ' location, you may need to edit AUTOBILD.BAT to provide'
SAY ' the correct path. Also, if there are blank lines in your'
SAY ' current AUTOEXEC.BAT, the entire file may not be copied.'
SAY ' This will not affect Build-o-Rama unless there are entries'
SAY ' in the file that must be present for command-line builds.'
SAY ' The program will also create a file called OS2BILD.BAT,'
SAY ' which is necessary to run the builds, and copy BUILDER.EXE'
SAY ' (The WinOS/2 program), BILDRAMA.EXE (the OS/2 program),'
SAY ' FISH.DLL (a Windows *.DLL), SEMASEND.EXE (a short DOS program)'
SAY ' and BUILDER.HLP (The Windows help file),  REAME.TXT and LICENSE.TXT'
SAY ' You should read README and the help file for general information.'
SAY ' Thank you for using Build-o-Rama'


   /* Strip program name
   */
   rcp = REVERSE(callPath)
   callPathDir = REVERSE(substr(rcp,POS("\",rcp)+1))

   /* Create Queue to catch system error messages
   */
   rcode = RXQUEUE('delete', errq)
   errq = RXQUEUE('create')
   new = RXQUEUE('set', errq)

   /* Define stem of files to be copied
   */
   MaxCopyIndex = 7
   Files. = ""
   Files.0 = MaxCopyIndex
   Files.1 = "BUILDER.EXE"
   Files.2 = "BILDRAMA.EXE"
   Files.3 = "FISH.DLL"
   Files.4 = "BUILDER.HLP"
   Files.5 = "SEMASEND.EXE"
   Files.6 = "README.TXT"
   Files.7 = "LICENSE.TXT"
   CurDir = DIRECTORY()
   SrcDir = callPathDir
   if (SubStr(SrcDir,Length(SrcDir),1) \= "\") then
     SrcDir = SrcDir||"\"
     
   BootDrive = GetBootDrive()
   if (BootDrive == "") then
     do
      /* ;OS2 is a required somewhere in the path directory!
      */
      'helpmsg SYS0010 | RXQUEUE 'errq
       call DumpErrMsg
       call Done
     end
 
   /* Verify Source Files
   */
   do i = 1 to MaxCopyIndex
     rc = VerifySourcePath( SrcDir||Files.i )
     if ( rc == 1 ) then
       call Done
   end

  /* get target directory for install */
  SAY
  SAY "Enter the target directory for Build-o-Rama" 
  PARSE PULL NewDir
  /* strip the trailing \ if needed */
   rnp = REVERSE(NewDir)
   if substr(rnp,1,1) = '\' then
   do
     NewDir = REVERSE(substr(rnp,POS("\",rnp)+1))
   end
     /* now see if this directory already exists */
  call SysFileTree NewDir, 'exist', D
  if ( exist.0 > 0 ) then
  do
	SAY "That directory exists, I don't need to create it"
  end
  else do
  		rc = SysMkDir(NewDir)
  		if ( rc > 0 ) then
  			do
				SAY "Couldn't create directory. Error code was" rc
				call Done	
  			end  
  end
  do t = 1 to Files.0
         copystr = SrcDir||Files.t||' '||NewDir||'\'||Files.t
         'copy 'copystr
         if rc > 0 then
         SAY 'Error in copying file '|Files.t
         else
         SAY Files.t||' copied to '||NewDir       
  end
  /* CREATE the OS2BILD.BAT file */
  filepath = NewDir||'\'||'OS2BILD.BAT'
  firstline = 'NMAKE.EXE %1 %2 %3 > \pipe\pipe1'
  secondline = NewDir||'\SEMASEND.EXE VCDONE'

  CALL LINEOUT filepath,firstline,1
  CALL LINEOUT filepath,secondline
  CALL LINEOUT filepath
  
  /* find out where the msvc\bin directory is, so can copy MSVCVARS.BAT */
  SAY
  SAY "Enter the drive letter on which MSVC is installed. I need to copy the MSVCVARS.BAT"
  PARSE PULL VCDrive
  VCLetter = substr(VCDrive,1,1)
  VCBatPath = VCLetter||':'||'\MSVC\BIN\MSVCVARS.BAT'
  /* now get the existing autoexec */
  autoExec = BootDrive||'\AUTOEXEC.BAT'
  autoBildString =  NewDir||'\'||'AUTOBILD.BAT'
  CALL LINEIN autoCopyString,1,0 /* open the existing Autoexec.bat */
  DO UNTIL line = ''
	line = LINEIN(autoExec) 
        CALL LINEOUT autoBildString,line 
  END 
/* now add the call statement to MSVCVARS.BAT */
 callItString = 'CALL '||VCBatPath 
 CALL LINEOUT autoBildString,callItString
 CALL LINEOUT autoBildString  /* close the file */
 SAY
 SAY 'Installation of Build-o-Rama is complete. You should add BUILDER.EXE to your '
 SAY 'tools menu in Visual C++ for best results.'


Done:
   rc = RXQUEUE('delete', errq)
   OriginalDir = DIRECTORY(CurDir)
   exit

/* Procedures and Functions
*/

VerifySourcePath: Procedure Expose errq

   Parse Arg file;

   fExists = Stream(file,'c','query exists')
   if (fExists == "")
     then do
           'helpmsg SYS002 | RXQUEUE 'errq
            call DumpErrMsg
            return 1
          end

return 0

GetBootDrive: Procedure

   PathStr = VALUE("PATH",,"OS2ENVIRONMENT")
   InsPathPos = POS(":\OS2",TRANSLATE(PathStr))
   if (InsPathPos \= 0) then
     do
       bdrive = Substr(PathStr,InsPathPos-1,2)
     end
   else bdrive = ""

return bdrive


DumpErrMsg: Procedure

   do while(QUEUED() \= 0)
     parse pull line
     if (POS("SYS",line) \= 0) then
       fFound = 1
     if ((line == "") & (fFound = 1)) then
       do
         /* Empty out queue
         */
         do while(QUEUED() \= 0)
           parse pull line
         end
         leave
       end
     say line
   end

return

