#include "xmessage.h"


/*@
@class XMessage
@type overview
@symbol _
*/

/*@ XMessage::XMessage( const char* Filename )
@group Constructor/Destructor
@remarks Constructs a message object
@parameters const char* Filename        this is either a filename or a fully qualified filename
                                        of a message file generated by MKMSGF
*/


/*@ XMessage::GetMessage( XString* pstrMsg, ULONG msgNum, ULONG varNum = 0, const char** varTexts = NULL )
@group misc
@remarks Loads a message from a message file inserts the given variable texts (if there are any)
         and returns the message.
@parameters XString*     pstrMsg            Pointer to a string object where the message will be stored
            ULONG        msgNum             Message number to load
            ULONG        varNum             Number of variables to replace; there may be up to 9 variables
            const char** varTexts           Texts for the variables
@returns TRUE if the message was loaded, otherwise FALSE
*/
BOOL XMessage::GetMessage( XString* pstrMsg, ULONG msgNum, ULONG varNum, const char** varTexts )
{
        APIRET rc;
        ULONG  msgLen;

        pstrMsg->GetBuffer( 1024 );
        rc = DosGetMessage( (char**)varTexts, varNum,
                            (char*)*pstrMsg, pstrMsg->GetLength(),
                            msgNum, (PSZ) (char*)strFilename, &msgLen     );
        pstrMsg->ReleaseBuffer();

        return (rc == NO_ERROR);
}

