#include <iwindow.hpp>
#include <kdobmgr.hpp>
#include "kdobent.hpp"
#include "kwdobmgr.hpp"
#include <kdata.hpp>
#include <imap.h>
#include <istdops.h>
#include <ireslock.hpp>
#include <iexcept.hpp>

KDobManager KDobManager::global;

/*-------------------------------------------------------------------------
 * member functions for KDobWinMgrMap.
 *-----------------------------------------------------------------------*/
IWindow* const &key(KDobWinMgrPtr const &entry)
{
   return entry->window;
}

class KDobWinMgrMap : public IMap<KDobWinMgrPtr,IWindow*>
{
   public:
      KDobWinMgrMap() : IMap<KDobWinMgrPtr,IWindow*>() {}
      ~KDobWinMgrMap() {}
};

class KDobWinMgrCursor : public IMap<KDobWinMgrPtr,IWindow*>::Cursor
{
   public:
      KDobWinMgrCursor(KDobWinMgrMap const &map) : IMap<KDobWinMgrPtr,IWindow*>::Cursor(map) {}
};

static KDobWinMgrMap mgrWindowMap;

/*------------------------------------------------------------------------
 * member functions for KDobMap        
 *----------------------------------------------------------------------*/
IString const &key(KDobEntryPtr const &entry)
{
   return entry->factory->name();
}

class KDobMap : public IMap<KDobEntryPtr,IString>
{
   public:
      KDobMap() : IMap<KDobEntryPtr,IString>() {}
      ~KDobMap() {}
};

class KDobCursor : public IMap<KDobEntryPtr,IString>::Cursor
{
   public:
      KDobCursor(KDobMap const &map) : IMap<KDobEntryPtr,IString>::Cursor(map) {}
};


/*------------------------------------------------------------------------
 * member functions for KDobManager
 *----------------------------------------------------------------------*/
KDobManager::KDobManager(IWindow *window, IWindow *caller)
   : map(*new KDobMap)
   , _window(window)
   , _caller(caller)
{
}

KDobManager::~KDobManager()
{
   delete &map;
}


KDobEntry *KDobManager::findEntry(KDataFactory const &factory)
{
   KDobCursor cursor(map);
   KDobEntryPtr element;

   if (map.locateElementWithKey(factory.name(), cursor))
      element = map.elementAt(cursor);
   else
   {
      element = new KDobEntry(factory);
      map.add(element);
   }
   return element;
   
}


IPrivateResource &KDobManager::dataLock(KDataFactory const &factory)
{
   KDobEntry *entry = findEntry(factory);
   return entry->lock;
}


KData &KDobManager::dataObject(KDataFactory const &factory)
{
   KDobEntry *entry = findEntry(factory);
   IASSERT(entry->data != 0);
   return *entry->data;
}

KDobManager &KDobManager::globalManager()
{
   return global;
}

KDobManager *KDobManager::managerFor(IWindow *window, IWindow *caller)
{
   KDobWinMgrCursor cursor(mgrWindowMap);

   if (mgrWindowMap.locateElementWithKey(window, cursor))
      return mgrWindowMap.elementAt(cursor)->manager;
   else
      return 0;
}

KDobManager *KDobManager::associate(IWindow *window, IWindow *caller)
{
   KDobWinMgrPtr element;
   
   if (managerFor(window))
      return(managerFor(window));

   element = new KDobWinMgrEntry(window, caller);
   mgrWindowMap.add(element);
   return element->manager;
}

void KDobManager::detach(IWindow *window)
{
   KDobManager *manager = managerFor(window);
   delete manager;
}


