#include <kprchdr.hpp>

Boolean KProcessHandler::dispatchHandlerEvent(IEvent &event)
{
   Boolean filtered = true;
   switch(event.eventId())
   {
      case KW_NEXT_STEP:
         filtered = nextStep(event);
         break;

      case KW_CANCEL_PROCESS:
         filtered = cancelProcess(event);
         break;

      case KW_ACTION_COMPLETE:
         filtered = actionComplete(event);
         break;

      default:
         filtered = false;

   }
   return filtered;
}

KProcessHandler::KProcessHandler() 
  : _currentStep(0) 
{
}

int KProcessHandler::currentStep() 
{ 
   return _currentStep; 
}
      
void KProcessHandler::setCurrentStep(int step) 
{ 
   _currentStep = step; 
}

