#ifndef _KPRCHDR_
#define _KPRCHDR_

#define INCL_BASE
#define INCL_PM
#include <os2.h>

#ifndef KWCONSTANTS
  #include <kwconst.hpp>
#endif

#ifndef _IHANDLER_
  #include <ihandler.hpp>
#endif

/*-------------------------------------------------------------
 * Class: KProcessEvent
 *
 * Description: 
 *
 *   Event handler for all KASEWORKS process events, 
 *
------------------------------------------------------------*/ 
class _Export KProcessEvent : public IEvent
{
   public:
      KProcessEvent(const IEvent &event) : IEvent(event) {}
      unsigned long stepId() { return parameter1().asUnsignedLong(); }
};

/*-------------------------------------------------------------
 * Class: KProcessHandler
 *
 * Description: 
 *
 *   Event handler for all KASEWORKS process events, 
 *
------------------------------------------------------------*/ 
class _Export KProcessHandler : public IHandler
{
   public:
      KProcessHandler();
      int currentStep();
      void setCurrentStep(int step);

   protected:
      virtual Boolean dispatchHandlerEvent(IEvent &event);
      virtual Boolean nextStep(IEvent &event) = 0;
      virtual Boolean cancelProcess(IEvent &event) = 0;
      virtual Boolean actionComplete(IEvent &event) = 0;
   private: 
      int _currentStep;
};

#endif

