#define _OS2_
#define INCL_PM
#define INCL_BASE
#include <os2.h>
#include <kprogram.hpp>
#include <iexcept.hpp>
#include <ireslib.hpp>

KProgram::KProgram(char const *strName, char const *strTitle, 
                   char const *strInput, char const *strEnv)
  : name(strName)
  , title(strTitle)
  , input(strInput)
  , env(strEnv)
{
}

KProgram::KProgram(const IResourceId nameId, const IResourceId titleId, 
                   const IResourceId inputId, const IResourceId envId)
  : name(nameId.resourceLibrary().loadString(nameId))
  , title(titleId.resourceLibrary().loadString(titleId))
{
  if (inputId)
    input = inputId.resourceLibrary().loadString(inputId);
  if (envId)
    env = envId.resourceLibrary().loadString(envId);
}


unsigned long KProgram::run()
{
   STARTDATA sd;
   IString objectErrorBuffer(0, 255, ' ');

   sd.Length      = sizeof(sd);
   sd.Related     = SSF_RELATED_INDEPENDENT;
   sd.FgBg        = SSF_FGBG_FORE;
   sd.TraceOpt    = SSF_TRACEOPT_NONE;
   sd.PgmTitle    = title;
   sd.PgmName     = name;
   if (input.length())
      sd.PgmInputs   = input;
   else
      sd.PgmInputs   = 0;
   if (env.length())
      sd.Environment = env;
   else
      sd.Environment = 0;
   sd.TermQ       = 0;
   sd.InheritOpt  = SSF_INHERTOPT_SHELL;
   sd.SessionType = SSF_TYPE_DEFAULT;
   sd.IconFile    = 0;
   sd.PgmHandle   = 0;
   sd.PgmControl  = SSF_CONTROL_VISIBLE;
   sd.InitXPos    = 25;
   sd.InitYPos    = 25;
   sd.InitXPos    = 200;
   sd.InitXPos    = 150;
   sd.ObjectBuffer = objectErrorBuffer;
   sd.ObjectBuffLen = 255;

   ULONG ulSessionID;
   PID   pidProcessID;
   APIRET apiret = DosStartSession(&sd, &ulSessionID, &pidProcessID);
#if 0
   if (apiret != 0)
      ITHROWSYSTEMERROR(apiret, "DosStartSession", 
                        IErrorInfo::accessError,
                        IException::recoverable);
#endif
   return apiret;
}

