# kwclass.mak:
#
# Makefile for the kwclass application

# tools and command lines
CPP       = icc
LINK      = icc
RC        = rc
RLINK     = rc
IMPLIB    = implib

CPPDEBUG  = 
LINKDEBUG = 
BASEOPTS  = -Ge- -Gm+ 
CPPOPTS   = /Q $(BASEOPTS) -C+ -W3 $(CPPDEBUG)
LINKOPTS  = /e /noe /noi /nod /bat /align:16 $(LINKDEBUG)
RCOPTS    = -r
RLINKOPTS =

# targets
MAIN_TARGET = kwclass.dll
MAP_NAME = kwclass.map
OBJS = \
       klsthdr.obj  \
       kpthdr.obj   \
       kvalcurr.obj \
       kvaldate.obj \
       kenthdr.obj  \
       kcmbhdr.obj  \
       kwinhdr.obj  \
       kmlehdr.obj  \
       ksldhdr.obj  \
       kvalmask.obj \
       kentryfd.obj \
       kvalid.obj   \
       kprchdr.obj  \
       kdirlst.obj  \
       kdobmgr.obj  \
       kfillst.obj  \
       kprogram.obj \
       kstdhdr.obj  \
       kvalset.obj  \
       kvalhdr.obj  \
       kwclass.obj
 
#
# Library macros can be replaced when necessary by defining
# the appropriate environment variable.  For example, placing
# the following directive in your config.sys file:
#
#     set KWCLIB = mycrtl.lib
#
# replaces the standard C++ runtime library with the 
# 'mycrtl.lib'.  See the C Set ++ Programming Guide for
# instructions on creating your own runtime libraries.
#
KWOS2LIB = os2386.lib
KWCLIB   = dde4mbsi.lib
KWUILIB  = dde4muii.lib
KWCCLIB  = dde4cci.lib
# KWKWLIB  = kwclass.lib

LIBS = $(KWOS2LIB) \
       $(KWCLIB)   \
       $(KWUILIB)  \
       $(KWCCLIB)

.SUFFIXES : 

.SUFFIXES : .cpp .rc .obj .dll .ipf .hlp


#
# implicit rules
#
{.}.rc.res:
  $(RC) $(RCOPTS) .\$*.rc

{.}.cpp.obj:
  $(CPP) $(CPPOPTS) .\$*.cpp


#
# explicit rules
#

all : $(MAIN_TARGET) 

kwclass.obj : kwclass.cpp \
              kwclass.rch \
              kwclass.hpp

kwclass.res :     kwclass.rc kwclass.rch

$(MAIN_TARGET) : $(OBJS) kwclass.def kwclass.mak kwclass.res
    $(LINK) @<<
 /Q /Tdp /B"$(LINKOPTS)" $(BASEOPTS)
 /Fe"$(MAIN_TARGET)" /Fm"$(MAP_NAME)"
 $(OBJS) 
 $(LIBS) 
 kwclass.def
<<
    $(RLINK) $(RLINKOPTS) $*.res $*.dll
    cppfilt -b -p *.obj > temp.lst
    type $*.def temp.lst > temp.def
    $(IMPLIB) $*.lib temp.def

