#ifndef _STDWINDOW_H_
#define _STDWINDOW_H_

#ifndef _ACTIONWINDOW_H_
#include <pm/ActionWindow.h>
#endif

@interface StdWindow : ActionWindow
{
  HWND       frame;
  id         delegate;
}

- initWithId: (ULONG) anId;
- initWithId: (ULONG) anId andFlags: (ULONG) flags;
- free;

- setSize: (LONG) x : (LONG) y : (LONG) w : (LONG) h;
- setRect: (LONG) w : (LONG) h;

- (LONG) framexoffset; // horizontal offset of lower left corner
- (LONG) frameyoffset; // vertical offset of lower left corner
- (LONG) framewidth;   // width of window
- (LONG) frameheight;  // height of window

- (HWND) frame;
- delegate;
- setDelegate: aDelegate;

- setTitle: (char *) aTitle;

- makeKeyAndOrderFront: sender;
- performClose: sender;

- (MRESULT) handleMessage: (ULONG) msg
            withParams: (MPARAM) mp1 and: (MPARAM) mp2;

@end

#endif
