/* C code produced by gperf version 2.7 */
/* Command-line: ../src/gperf -p -D -k1,$ -s 2 -o ./adadefs.gperf  */

#define TOTAL_KEYWORDS 54
#define MIN_WORD_LENGTH 3
#define MAX_WORD_LENGTH 17
#define MIN_HASH_VALUE 5
#define MAX_HASH_VALUE 126
/* maximum key range = 122, duplicates = 1 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
hash (str, len)
     register const char *str;
     register unsigned int len;
{
  static unsigned char asso_values[] =
    {
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127,  65,  35,  35,
        0,   0,  50,   5,   0,  45, 127, 127,  20,  45,
       35, 127,  15, 127,  60,  10,   5, 127,  25,   0,
       40, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
      127, 127, 127, 127, 127, 127
    };
  return len + asso_values[(unsigned char)str[len - 1]] + asso_values[(unsigned char)str[0]];
}

#ifdef __GNUC__
__inline
#endif
const char *
in_word_set (str, len)
     register const char *str;
     register unsigned int len;
{
  static const char * wordlist[] =
    {
      "width",
      "true",
      "size",
      "terminated",
      "digits",
      "pred",
      "safe_large",
      "string",
      "storage_size",
      "positive",
      "large",
      "length",
      "pos",
      "last",
      "value",
      "lastbit",
      "small",
      "base",
      "safe_small",
      "epsilon",
      "callable",
      "emax",
      "count",
      "constrained",
      "val",
      "succ",
      "image",
      "fore",
      "false",
      "position",
      "safe_emax",
      "float",
      "first",
      "natural",
      "firstbit",
      "range",
      "machine_rounds",
      "delta",
      "machine_overflows",
      "aft",
      "boolean",
      "tasking_error",
      "address",
      "storage_error",
      "program_error",
      "machine_emin",
      "machine_emax",
      "machine_radix",
      "character",
      "numeric_error",
      "constraint_error",
      "integer",
      "mantissa",
      "machine_mantissa"
    };

  static short lookup[] =
    {
        -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,
        -1,    1,   -1,   -1,   -1,   -1,    2,    3,
         4,   -1,   -1,    5,    6,    7,    8,    9,
        -1,   10,   11,   -1,   12,   13,   14,   -1,
        15,   -1,   -1,   16,   -1,   -1,   -1,   17,
        18,   -1,   19,   20,   21,   22,   23,   -1,
        24,   25,   26,   -1,   -1,   -1,   27,   28,
        -1,   -1,   29,   30, -121,   -1,   33,   34,
        -1,   35,  -23,   -2,   -1,   36,   37,   -1,
        38,   39,   -1,   -1,   -1,   40,   41,   -1,
        -1,   -1,   42,   43,   -1,   -1,   -1,   -1,
        44,   -1,   -1,   -1,   45,   -1,   -1,   -1,
        -1,   46,   47,   -1,   -1,   -1,   -1,   -1,
        48,   -1,   -1,   -1,   49,   -1,   -1,   50,
        51,   -1,   -1,   -1,   -1,   -1,   52,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   53
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register int index = lookup[key];

          if (index >= 0)
            {
              register const char *s = wordlist[index];

              if (*str == *s && !strcmp (str + 1, s + 1))
                return s;
            }
          else if (index < -TOTAL_KEYWORDS)
            {
              register int offset = - 1 - TOTAL_KEYWORDS - index;
              register const char * *wordptr = &wordlist[TOTAL_KEYWORDS + lookup[offset]];
              register const char * *wordendptr = wordptr + -lookup[offset + 1];

              while (wordptr < wordendptr)
                {
                  register const char *s = *wordptr;

                  if (*str == *s && !strcmp (str + 1, s + 1))
                    return s;
                  wordptr++;
                }
            }
        }
    }
  return 0;
}
