//===============================================================
// vtextinc.xxx - TextIn Cmd - Windows
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#include <v/vos2.h>           // for OS/2 stuff
#include <v/vapp.h>
#include <v/vtextinc.h> // our definitions
#include <v/vcmdprnt.h> // a command parent

#define TextInFont SysVariableFont        // The font to use
//=====================>>> vTextInCmd::vTextInCmd <<<=======================
  vTextInCmd::vTextInCmd(vCmdParent* dp, CommandObject* co) :
    vCmd(dp, co)
  {
    initialize();
  }
//=====================>>> vTextInCmd::~vTextInCmd <<<=======================
  vTextInCmd::~vTextInCmd()
  {
    SysDebug(Destructor,"vTextInCmd::~vTextInCmd() destructor\n")
  }
//=====================>>> vTextInCmd::initialize <<<=======================
  void vTextInCmd::initialize(void)
  {
    // build a TextIn command for use in a parent window
    SysDebug(Constructor,"vTextInCmd::vTextInCmd() constructor\n")
    _msg[0] = 0;                        // no string yet

    CopyToLocal();                      // Make local copies of CmdObject

    int defLen = strlen(_title);        // length of supplied string
    if (defLen < 130)
      strcpy(_msg,_title);

    int defWidth = (dlgCmd->attrs & CA_Large) ? 35 : 20;

    if (dlgCmd->attrs & CA_Small)       // allow small, too.
	defWidth = 10;

    if (dlgCmd->size > 0)               // V:1.13
	defWidth = dlgCmd->size;

    if (defLen > defWidth)              // Some work space
	defWidth = defLen + 6;

    LONG style = ES_LEFT | ES_AUTOSCROLL | WS_GROUP | WS_TABSTOP;

    _efd.cb = sizeof(ENTRYFDATA);
    _efd.cchEditLimit = 130;
    _efd.ichMinSel = 0;
    _efd.ichMaxSel = 0;

    if (!(dlgCmd->attrs & CA_NoBorder))
	style |= ES_MARGIN;

    if (!(dlgCmd->attrs & CA_Hidden))   // Check for Hidden
	style |= WS_VISIBLE;

    _w = defWidth * 4 + 6;
    _h = 10;                            // default height

    _parentWin->SetPosition(_x, _y, _w, _h, dlgCmd->cFrame, dlgCmd->cRightOf,
	 dlgCmd->cBelow);

    // entrybox border extends 1/2 character beyond specified width so
    // need to compensate to keep alignment aesthetic
    if (!(dlgCmd->attrs & CA_NoBorder))
    {
      _x += 2; _y += 2;
      _w -= 4; _h -= 4;
    }

    _CtrlOffset = _parentWin->AddDlgControl(_x, _y , _w, _h, _cmdId,
	   style, WC_ENTRYFIELD, _title, 0, _efd.cb, &_efd);

  }
//=====================>>> vTextInCmd::GetTextIn <<<=======================
  int vTextInCmd::GetTextIn(ItemVal id, char* str, int maxlen)
  {
    // recover the data from a TextInCmd - return text + length
    int ix;
    for (ix = 0 ; _msg[ix] != 0 && ix < maxlen-1 ; ++ix)
       str[ix] = _msg[ix];
    str[ix] = 0;
    return strlen(str);
  }
//================>>> vTextInCmd::SetCmdVal <<<============================
  void vTextInCmd::SetCmdVal(ItemVal val, ItemSetType st)
  {
    SysDebug1(Misc,"vTextInCmd::SetCmdVal(val:%d)\n",val)
    HWND myHwnd = GetMyHwnd(_cmdId);

    switch (st)
    {
      case Sensitive:
	_Sensitive = val;               // set
	WinEnableWindow (myHwnd, val);
	break;

      case Hidden:
	if (val)
	  WinShowWindow (myHwnd, FALSE);
	else
	  WinShowWindow (myHwnd, TRUE);
	break;
    }
  }
//================>>> vTextInCmd::SetCmdStr <<<============================
  void vTextInCmd::SetCmdStr(char* str)
  {
    SysDebug1(Misc,"vTextInCmd::SetCmdStr(str:%s)\n",str)

    strcpy(_msg, str);
    HWND myHwnd = GetMyHwnd(_cmdId);
    WinSetWindowText(myHwnd, str);

  }
//====================>>> vRadioButtonCmd::CmdCallback <<<=======================
  void vTextInCmd::CmdCallback(UINT uMsg, MPARAM mp1, MPARAM mp2)
  {
    // Edit strings are noops except for EN_CHANGE

    if (uMsg == WM_CONTROL)
    {
      if (SHORT2FROMMP(mp1) == EN_CHANGE)
      {
	HWND myHwnd = GetMyHwnd(_cmdId);
	WinQueryWindowText(myHwnd, sizeof(_msg), _msg);
//	SysDebug1(OS2Dev,"vTextInCmd::CmdCallBack _msg:%s \n", _msg)
      }
    }
  }
