//===============================================================
// vWinPrinterC - a basic canvas for drawing
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#include <v/vos2.h>           // for OS/2 stuff
#include <math.h>

#include <v/vwinprdc.h>
#include <v/vapp.h>             // need access to the app
//-----------------------------------------------------------------------
//================>>> vWinPrinterDC::vWinPrinterDC <<<========================
  vWinPrinterDC::vWinPrinterDC() : vWinDC()
  {
    SysDebug(Constructor,"vWinPrinterDC::vWinPrinterDC() constructor\n")
    _isPrinterDC = 1;
  }
//================>>> vWinPrinterDC::~vWinPrinterDC <<<========================
  vWinPrinterDC::~vWinPrinterDC()
  {
    SysDebug(Destructor,"vWinPrinterDC::~vWinPrinterDC() destructor\n")
  }
//================>>> vWinPrinterDC::SetBackground <<<==========================
  void vWinPrinterDC::SetBackground(vColor& color)
  {
   _canvasBG = color.pixel();           // retrieve pixel value
    GpiSetBackColor (_hdc, _canvasBG);
  }
//======================>>> vWinPrinterDC::SetFont <<<===========================
  void vWinPrinterDC::SetFont(vFont& vf)
  {
    // Change the font associated with this window.
    _font = vf;
  }
//================>>> vWinPrinterDC::BeginPrinting <<<========================
// returns 0 if problem
  int vWinPrinterDC::BeginPrinting()
  {
    // after the printer is chosen and printing is about to start
    // we create the print PS
    // if a PS already exists for this printer, it will be destroyed and
    // re-created with the latest printer setup info
    _hdc = _printer.CreateHDC();   // set the _hdc in the printer canvas


    if (!_hdc)             // should not happen...
    {
      ERRORID err;
      err = WinGetLastError(theApp->AppHab());
      SysDebug1(Build,"vWinPrinter::BeginPrinting() failed to create _hdc (err=%x)\n",
        err)
      return 0;
    }

    // we include any document name provided by the app for queue ID
    _pages = 0;
    if (DevEscape (_printer.GetHDevC(), DEVESC_STARTDOC, strlen(_printer.GetDocName()),
      _printer.GetDocName(), NULL, NULL) != DEV_OK)
      return 0;

    BeginPage();
    return 1;
  }
//================>>> vWinPrinterDC::BeginPage <<<========================
  void vWinPrinterDC::BeginPage()
  {
    if (!_printer.GetHDC())             // should not happen...
    {
      return;
    }

    ++_pages;           // bump number of pages so far

    // we send a NEWFRAME command if this is not the first page
    // to eject the previous page
    if (_pages != 1)
    {
      DevEscape (_printer.GetHDevC(), DEVESC_NEWFRAME, strlen(_printer.GetDocName()),
     _printer.GetDocName(), NULL, NULL);
    }
    SysDebug(Build,"vWinPrinterDC::BeginPage()  beginning new page \n")
  }

//================>>> vWinPrinterDC::EndPage <<<========================
  void vWinPrinterDC::EndPage()
  {
    // this is a NO-OP for OS/2
  }
//================>>> vWinPrinterDC::EndPrinting <<<========================
  void vWinPrinterDC::EndPrinting()
  {
    USHORT jobID;
    LONG SizeJobID = sizeof(jobID);

    if (!_printer.GetHDC())
        return;
    // signal end of printjob and get job id
    DevEscape(_printer.GetHDevC(), DEVESC_ENDDOC, 0, NULL,
      &SizeJobID, (PBYTE) &jobID);
    _printer.SetJobID((int) jobID);

    SysDebug1(Build,"vWinPrinterDC::EndPrinting() Job ID is %u \n", _printer.GetJobID())

    // after print is complete free-up the print PS
    _printer.DestroyHDC();
  }
//=====================>>> vWinPrinterDC::SetPrinter <<<============================
 void vWinPrinterDC::SetPrinter(vPrinter& printer)
  {
    _printer = printer;

    // according to the docs, these are in 1/72 inch units (ie. 1 point)
    _physHeight = _printer.GetHeight();
    _physWidth = _printer.GetWidth();
  }

