/*
        This program is provided on an "as is" basis, without warranty of any
	kind. The entire risk as to the quality and performance of the program
	is borne by you.

    Report bugs to: july@cblink.net
*/

%{
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "v2i.h"
#include "yacc.h"

#define YY_INPUT(buf, result, max_size ) \
{ \
  int c = read_char(); \
  result = ( c == EOF ) ? YY_NULL: ( buf[0] = c, 1 ); \
}

%}

DIGIT           [0-9]
OCTALDIGIT      [0-7]
HEXDIGIT        [0-9A-Fa-f]
ID              [a-zA-Z\_][a-zA-Z0-9\_\$]*

%x COMMENT
%x SINGLECOMMENT
%s PREPROC

%%

 /* hexadecimal number */
"0"x{HEXDIGIT}+ {
        long result;

        sscanf( yytext + (*yytext == '$' ? 1 : 2), "%lx", &result );
        yylval.value = result;
        return CONST;
}

 /* octal number */
"0"{OCTALDIGIT}+ {
        long result;

        sscanf( yytext, "%lo", &result );
        yylval.value = result;
        return CONST;
}

 /* decimal number */
{DIGIT}+ {
        long result;

        sscanf( yytext, "%ld", &result );
        yylval.value = result;
        return CONST;
}

"//vbm1"        return VBM1;
"//vbm8"        return VBM8;

define		    BEGIN(PREPROC); return DEFINE;
unsigned	    return UNSIGNED;
static  	    return STATIC;
char	        return CHAR;

 /* identifier */
{ID}    {
        yylval.cp = strdup( yytext );
        return IDENT;
}

"//"    BEGIN(SINGLECOMMENT);

"/*"    BEGIN(COMMENT);

<PREPROC>{
    "\n"   BEGIN(INITIAL); return '\n';
}

<SINGLECOMMENT>{
	"\n"	BEGIN(INITIAL);
	.       /* eat anything */
}

<COMMENT>{
	[^*\n]*        	/* eat anything that's not a '*' */
	"*"+[^*/\n]*	/* eat up '*'s not followed by '/'s */
	"\n"           	/* ++line_num; multiline = 1; */
	"*"+"/"         BEGIN(INITIAL);
}

[ \t\n]+	/* eat up whitespaces */

. 		return yytext[0];

%%

int yywrap()
{
        return 1;
}

