# EXAMPLE makefile for V Icon Editor application...
#
# creates .exe's under $(BINDIR)
# assumes that vibmcpp or vibmcppd (debug library) already built
# using v.mak or vopengl.mak 
#
# to create debug versions enter: nmake DEBUG=1 /f viconed.mak
# to create release versions enter: nmake /f viconed.mak

include cfgibm.mkh

# ---------------------------------------------------------------------------
SRCDIR=$(VDIR)\iconed
INCDIR=$(VDIR)\iconed
BINFILE=$(BINDIR)\viconed.exe
RESFILE=$(OBJDIR)\vos2.res
DEFFILE=$(VSRCDIR)\vos2.def

OBJFILES= $(OBJDIR)\vstartup.obj \
 $(OBJDIR)\imageio.obj \
 $(OBJDIR)\viedcnv.obj \
 $(OBJDIR)\viedcmdw.obj \
 $(OBJDIR)\viedapp.obj \
 $(OBJDIR)\coldlg.obj \
 $(OBJDIR)\brshdlg.obj \


# ---------------------------------------------------------------------------
.PRECIOUS: $(BINFILE)

.cpp.obj :
 $(CC) $(CFLAGS) /C /Fo$@ $<

{$(SRCDIR)}.cpp{$(OBJDIR)}.obj :
 $(CC) $(CFLAGS) /I$(INCDIR) /C /Fo$@ $<

all : $(BINFILE)

dirs:
	@-mkdir $(OBJDIR)
	@-mkdir $(BINDIR)

clean :
	-del $(OBJDIR)\*.*
	-del $(BINDIR)\*.*

$(BINFILE) : $(OBJFILES) $(RESFILE) $(VLIB)
	-$(LD) $(LFLAGS) @<<
 $(OBJFILES),
 $@,
 NUL,
 $(LIBS),
 $(DEFFILE)
<<NOKEEP
    $(RC) $(RFLAGS) $(RESFILE) $@

# ---------------------------------------------------------------------------

# Minimum RESOURCE
$(OBJDIR)\vos2.res :: $(VSRCDIR)\vos2.rc \
        $(VSRCDIR)\vapp.ico \
        $(VSRCDIR)\collate.bmp
	@copy $(VSRCDIR)\vapp.ico .
	@copy $(VSRCDIR)\collate.bmp .
    $(RC) -r $(RFLAGS) $(VSRCDIR)\vos2.rc $@ 
	@-attrib -r .\vapp.ico
	@-attrib -r .\collate.bmp
	-del .\vapp.ico
	-del .\collate.bmp

# APP
$(OBJDIR)\vstartup.obj : $(VSRCDIR)\$$(@B).cpp 

$(OBJDIR)\imageio.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h 

$(OBJDIR)\viedcnv.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\viedcmdw.h $(VINCDIR)\vprinter.h \
 $(INCDIR)\brshdlg.h $(INCDIR)\coldlg.h $(INCDIR)\paldecla.h

$(OBJDIR)\viedcmdw.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(INCDIR)\viedcnv.h $(INCDIR)\viedapp.h \
 $(INCDIR)\brshdlg.h $(INCDIR)\coldlg.h 

$(OBJDIR)\viedapp.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(INCDIR)\viedcnv.h $(INCDIR)\viedcmdw.h \
 $(INCDIR)\brshdlg.h $(INCDIR)\coldlg.h 

$(OBJDIR)\coldlg.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(INCDIR)\viedcnv.h $(INCDIR)\viedcmdw.h $(INCDIR)\palclrs.h

$(OBJDIR)\brshdlg.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(INCDIR)\viedcnv.h $(INCDIR)\viedcmdw.h 
