//===============================================================
// vfont.h - The font class - Windows
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VFONT_H
#define VFONT_H

#include <v/v_defs.h>
#include <v/vos2.h>

  class V_EXPORT vCanvasPane;   // the vCanvasPane needs to the the X font
  class V_EXPORT vApp;          // the vApp needs Xfont, too
  class V_EXPORT vListCmd;
  class V_EXPORT vComboBoxCmd;

  enum vFontID	       // various font related ids
  {
    vfDefaultSystem,       // system default (DefaultVariable for OS/2)
    vfDefaultFixed,	       // the system default fixed font
    vfDefaultVariable,     // the system default variable font
    vfSerif,	       // serifed font - TimesRoman
    vfSansSerif,	       // SansSerif - Swiss or Helvetica
    vfFixed,	       // fixed font - Courier
    vfDecorative,	       // decorative - dingbat
    vfOtherFont,	       // for all other fonts
    vfNormal,	       // normal style, weight
    vfBold,		       // boldface
    vfItalic,	       // italic style
    vfEndOfList
  };

  const LONG LCID_MAX=254;
  const LONG DPM=28346;                  // decipoints per meter
  const LONG MAXPS=32;                   // max number of dc's per font
  const double  PI=3.14159265358979324;  // for angle calcs

  class V_EXPORT vFont    // make the font stuff a class to make it portable
  {
    friend class V_EXPORT vCanvasPane;
    friend class V_EXPORT vApp;

    public:  //---------------------------------------- public
      vFont(vFontID fam = vfDefaultFixed, int size = 10,
      vFontID sty = vfNormal, vFontID wt = vfNormal,
        int und = 0, int ang = 0);

      vFont(const vFont &ft);		// copy constructor

      ~vFont();

      vFont& operator =(const vFont& ft);  // vFont = vFont

      int operator ==(const vFont &ft) VCONST
        { return (_family == ft._family && _style == ft._style &&
          _weight == ft._weight && _pointSize == ft._pointSize  &&
	  _underlined == ft._underlined && _angle == ft._angle); }

      int operator !=(const vFont &ft) VCONST
        { return !(_family == ft._family && _style == ft._style &&
	  _weight == ft._weight && _pointSize == ft._pointSize  &&
	  _underlined == ft._underlined && _angle == ft._angle); }

      vFontID GetFamily() VCONST { return _family; }

      int GetPointSize() VCONST { return _pointSize; }

      vFontID GetStyle() VCONST { return _style; }

      vFontID GetWeight() VCONST { return _weight; }

      int GetUnderlined() VCONST { return _underlined; }

      int GetAngle() VCONST { return _angle; }


      void SetFontValues(vFontID fam = vfDefaultFixed, int size = 10,
        vFontID sty = vfNormal, vFontID wt = vfNormal, int und = 0);

      void vFont::SetWinFontValues(VCONST FONTDLG& fdlg);

      void LoadFont(HPS dc);	// make sure font with given id is loaded

      PCHARBUNDLE GetHFONT() { return &_cbFont; }

      LONG GetIsFromFntDlg() VCONST { return _isFromFntDlg; }
      PFATTRS GetPFAT() VCONST { return &_fat; }
      PFONTMETRICS GetFM() VCONST { return &_fm; }
//      FATTRS GetLOGFONT() VCONST { return _status_fid; }
//      ULONG GetFontColor() VCONST { return _fontColor; }

    protected:  //--------------------------------------- protected

    private:  //--------------------------------------- private
      void LoadBitmapFont( HPS dc );

      vFontID _family;	// family - vfSerif, etc.
      vFontID _style; 	// style - normal, italic, slant
      vFontID _weight;	// weight - normal, light, bold
      int _pointSize;		// point size of font
      int _underlined;	// if underlined or not
      int _angle;		// angle to print at

      CHARBUNDLE _cbFont;	// font charbundle
      FATTRS _fat;		// Font attributes
      FONTMETRICS _fm;        // Font metrics

      LONG _XDeviceRes;       // dc x resolution in pels/meter
      LONG _YDeviceRes;       // dc y resolution in pels/meter

      struct _STATUS          // used to track logical font creation
      {
        HPS dc;               // dc where font created
	LONG fid;             // LCID of font in dc
	SIZEF CharBoxSize;    // size of font if Adobe
      } _status[MAXPS];

      int _isFromFntDlg;	// font set from Font Dialog box
  };

#endif
