//===============================================================
//
// vos.cpp - Interface to OS dependent stuff (For OS/2)
//
// Copyright (C) 1999  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#include <v/vos2.h>
#include <v/vos.h>
#include <v/v_defs.h>

const int MaxCompNameLen = 256;

//=========================>>> vOS::vOS <<<==========================
  vOS::vOS()
  {
    // Constructor
    // This will be used to determing which OS we are running
    // under: e.g., NT vs 95
  }

//=========================>>> vOS::~vOS <<<==========================
  vOS::~vOS()
  {
    // Destructor
  }

//=========================>>> vOS::vDeleteFile <<<==========================
  int vOS::vDeleteFile(const char* filename)
  {
     return DosDelete(filename) == TRUE;
  }

//=========================>>> vOS::vChDrive <<<==========================
  int vOS::vChDrive(int drive)
  {
//    char temp [3] = "-:";
//    temp[0] = drive + 'A';
    return DosSetDefaultDisk(drive);
  }

//=========================>>> vOS::vGetUserName <<<==========================
  int vOS::vGetEnvVal(char* name, char* val, int maxlen)
  {
     const char *pResult;
//     s = getenv(name);
     APIRET rc = DosScanEnv(name, &pResult);  // returns 0 if okay

     if (!rc)
       strncpy(val, pResult, maxlen);

     return rc;
  }


//=========================>>> vOS::vGetUserName <<<==========================
  int vOS::vGetUserName( char* s, int len)
  {
    // Set s to user name
    // not sure if this is supported in OS/2 so will set to NULL for now
/*
    char UserName[MaxCompNameLen+1];
    ULONG cch = sizeof UserName;
*/
    s[0] = 0;
    return 0;
  }


//=========================>>> vOS::vGetHostName <<<==========================
  void vOS::vGetHostName(char* s, int len)
  {
    // Get host name

//    char HostName[MaxCompNameLen+1];
//    ULONG cch = MaxCompNameLen;

    // I think I can get this useing the TCP/IP API hostent...
    // but foir now just set to default
    strcpy(s, "PC_OS2");

/*
    if (::hostent(HostName, &cch))
    {
      strcpy(s,HostName);
    }
    else
      strcpy(s, "PC_OS2");
*/
  }

//=========================>>> vOS::vGetCWD <<<==========================
  int vOS::vGetCWD(char* buf, int len)
  {
    // Get name of current directory
    ULONG driveNumber;

    ULONG rv = DosQueryCurrentDir(driveNumber, buf, (ULONG*) &len);

    char temp[4] = "-:\\";
    temp[0] = driveNumber + 'A';

    return (int) rv;
  }

//=========================>>> vOS::vChDir <<<==========================
  int vOS::vChDir(const char *path)
  {
    if (path[0] == 0)           /* just checking... */
	return 0;

    if (*path == 0)             /* drive name only */
	return 0;

    return DosSetCurrentDir(path);        /* let the normal chdir() do the rest */
  }

//=========================>>> vOS::vSleep <<<===========================
  void vOS::vSleep(long ms)
  {
    DosSleep(ms);
  }

//=========================>>> vOS::vGetPid <<<==========================
  long vOS::vGetPid()
  {
    // return process ID of this process
    PTIB ptib;
    PPIB ppib;
    ULONG pid;
    DosGetInfoBlocks(&ptib, &ppib);

    return (long) ppib->pib_ulpid;
  }


//=========================>>> vOS::vRunProcess <<<==========================
  int vOS::vRunProcess(const char* cmd, const char* StdOut, const char* StdErr,
      const int Wait, const int minimize)
  {
    STARTDATA sd;
    ULONG sid;
    PID pid;
    APIRET rc;
    char PgmTitle[256];
    const ULONG objBufLen = 256;
    char objBuf[objBufLen];

    sd.Length = sizeof(STARTDATA);
    sd.Related = SSF_RELATED_INDEPENDENT;
    sd.FgBg = SSF_FGBG_FORE;
    sd.TraceOpt = SSF_TRACEOPT_NONE;
    sd.PgmName = (char *)cmd;
    strcpy(PgmTitle, "V-Process");
    sd.PgmTitle = PgmTitle;
    sd.PgmInputs = 0;
    sd.TermQ = 0;
    sd.Environment = 0;
    sd.InheritOpt = SSF_INHERTOPT_SHELL;
    sd.SessionType = SSF_TYPE_DEFAULT;
    sd.IconFile = 0;
    sd.PgmHandle = 0;

    sd.PgmControl = SSF_CONTROL_VISIBLE;
    if (minimize)
      sd.PgmControl |= SSF_CONTROL_MINIMIZE;
//    else
//      sd.PgmControl |= SSF_CONTROL_MAXIMIZE;

    sd.InitXPos = 0;
    sd.InitYPos = 0;
    sd.InitXSize = 0;
    sd.InitYSize = 0;
    sd.Reserved = 0;
    sd.ObjectBuffer = objBuf;
    sd.ObjectBuffLen = objBufLen;

    // Now, run the command
    if ( !DosStartSession(&sd, &sid, &pid) )
      return 99;

    if (!Wait)
	return 0;

    // Wait for the command to terminate before continuing
    return rc;
  }
