
          ****************
          ** C Compiler **
          ****************

    Put full path of file name into debugging information so
    that the debugger can find the source file without having
    to use 'set source'.
===========================================================

    /bt=netware turns on /fpr switch
===========================================================

    The floating point constant 0129.5 was not properly
    parsed (compiler thought that it was an octal constant
    and complained when it saw the '9' digit).
===========================================================

          ********************
          ** Code Generator **
          ********************

    recognizes more numeric operations as dangerous for purposes of hoisting
    (POW, MOD etc).
===========================================================

    bug in handling of large, overlapped moves was fixed
===========================================================

    would GP-fault when running low on memory and trying to
    optimize
===========================================================

    The following C++ code would use an incorrect offset for 
    the string literal "BAD" when compiled with the -ml -zc
    switches:

    class A {
	public:
	    virtual char * add( void ) { return "BAD"; }
    };
    
    int main() {
	
	A * it = new A;
	it->add();
	return 0;
    }
===========================================================

    The compiler no longer GPFaults when fixing up certain types
    of one iteration loops (loops which will go around exactly one time).
===========================================================

    Do not generate needless runtime calls to compare code pointers
    against NULL.
===========================================================

    A loop which was going to execute exactly one time followed by
    another loop (without intervening code) would cause incorrect code
    to be generated.
===========================================================

    Fixed a bug which caused data to be ejected into the wrong spot
    in a code segment when compiling with debugging optimization.
===========================================================

    When unrolling a loop we would not assign locations to temps on
    occassion which would result in an internal compiler error #30.
===========================================================

    Debugging information would cause problems with instruction scheduling.
===========================================================

    Fixed access of virtual function tables in large-code programs
    which were compiled with /zc.
===========================================================

    Under circumstances too complex to explain, bad code would be
    generated causing all sorts of stuff to happen.
===========================================================

    A loop which had an induction variable whose initial and final
    values were known and in which the induction variable was not
    updated on every time through the loop would sometimes get thrown
    out.

===========================================================

    Arithmetic operations on signed 16-bit integers would not be
    properly folded, resulting in bogus values.
===========================================================

    Output from the C++ compiler would sometimes not reference
    the correct offset for string literals if -zc -ml was
    specified.
===========================================================

    Constant folding of operations which use the EDX:EAX forms
    of mulitply would generate an ICE #28.
===========================================================

    The code generator would propagate the result of a conversion
    from a temp to another temp into another convert on the same
    operand even though the conversions were being carried out in
    different manners.
===========================================================

    Assignments of incompatible types to bit-fields would not
    get converted properly.
===========================================================

    Floating point compares would not be handled correctly if
    they were not used as part of an if statement (possible
    if fortran).
===========================================================

          ***************
          ** C Library **
          ***************

    Windows NT CLIB:
    - fixed dup() so that new handle is inheritable
    - fixed dup2() so that new handle is inheritable
    - fixed dup2() so that if 0, 1, or 2 are changed then
      Windows NT is notified so that POSIX redirection
      idioms work properly
===========================================================

    Windows NT CLIB: fixed _fullpath so that
    _fullpath( "con" ) works properly to get around a
    Windows NT bug  (Microsoft has been notified and
    will fix NT for a future release)
===========================================================

    added _fileno() to <stdio.h>
===========================================================

    added POSIX errors to <errno.h>
===========================================================

    Corrected OS/2 1.x library to remove extraneous
    reference to ___FPE_int.

    Fixed Floating point exception support in 16-bit DOS library.
===========================================================

    Fixed fseek() function to report an error condition when
    attempting to flush buffers before seeking yields an error.
===========================================================

    Fixed signal handling of SIGINT and SIGBREAK under
    extended DOS for Rational and Pharlap extenders.
===========================================================

    Windows NT CLIB: corrected a problem where the
    POSIX file handle table was not initialized early
    enough for C++ static initializers to execute properly
===========================================================

    fixed abort() for 386 -3s model for DOS4G and NT environments
===========================================================

    Mixing C and FORTRAN in Windows NT applications did not
    work correctly.
===========================================================

    The bsearch function could segment violate if it was
    given an array which contained only one element and
    the element size was very large.
===========================================================

    The mktime() function did not properly handle some
    unrepresentable values.
===========================================================

    Windows NT CLIB: Fixed dup2() to close the destination
    handle before aliasing the source handle to it.
===========================================================

    Windows NT CLIB: Fixed utime() to set file time to
    local time rather than GMT time.
===========================================================

    __WinLines_sem had incorrect underscores in NT -3s library
===========================================================

    Added cover function for EnumFontFamilies in 386 Windows library
===========================================================

    The atanh function returned the negative of the correct
    value.
===========================================================

    Windows NT CLIB:
    - fixed opendir/readdir/closedir to match size
      constants in <direct.h>
    - fixed _dos_findfirst/_dos_findnext to match size
      constants in <dos.h>
===========================================================

    Windows NT CLIB: Fixed opendir/readdir/closedir to
    return dates in local time rather than GMT
===========================================================

    Windows NT CLIB: Fixed stat/fstat to return
    dates in local time rather than GMT
===========================================================

    Windows NT CLIB: Fixed _dos_setftime/_dos_getftime to
    deal in local DOS times rather than GMT
===========================================================

    printf() with the 'G' format for floating point output
    did not correctly determine when to use the 'E' format
    if the exponent was negative.
===========================================================

    fread() of TEXT mode files did not properly handle
    reads going past the end of the file's buffer.
===========================================================

    Windows NT CLIB: Fixed kbhit() so that it doesn't
    think a key is in the buffer when the mouse moves,
    focus changes, or the user touches the ctrl key
===========================================================

    In the OS/2 2.x C libraries, if a thread created using
    _beginthread() called a 16-bit function, the code that
    performed the 32 to 16-bit thunking could crash.  The
    thunking code imposed some stack overhead that is now
    automatically supplied.
===========================================================

    Optimize fseek() for SEEK_CUR with negative offsets.
===========================================================

    Fixed a problem where floating point exceptions under
    Pharlap would not be properly caught if the exception
    handler offset was > 64K.
===========================================================

    Fixed freopen() for standard streams under default
    windowing applications.
===========================================================

    Modified OS/2 2.x signal() function to consider SIGINT
    and SIGBREAK to be the same thing.
===========================================================

    Fixed WILDARGV.C so that it can be compiled as a C++
    source file.
===========================================================

    Fix scanf() family of functions to not modify the user
    variable if no match for the format string is found in
    the input stream.
===========================================================

    Fix return code from __exit() under 3s for 32 bit Windows.
===========================================================

    Fix fread() to always attempt to fill user buffer.
===========================================================

    The memory allocator has been improved for DOS/4GW.  DPMI memory
    blocks will now be given back to the DPMI host when possible.
    'realloc' will try to expand a DPMI memory block if possible
    rather than allocating a new DPMI memory block and copying the
    old memory block to the new memory block.
===========================================================

    Startup code for Rational DOS extender no longer zeros the
    entire BSS, since the DOS extender will zero the pages when
    they are first created. This will speed up loading of applications
    that have large uninitialized arrays.
===========================================================

          ******************
          ** C++ Compiler **
          ******************

    dead code warnings leave dead code status alone now.
===========================================================

    static class temporaries caused problems during
    initialization of static items.
===========================================================

    __cdecl and __pascal don't force extern "C" semantics
    anymore (necessary for MFC 2.0 code).
===========================================================

    -dmacro#contents works properly now.
===========================================================

    The number of arguments was not checked properly for
    function pointer calls in all cases.
===========================================================

    locations improved for various error messages.
===========================================================

    access checking for file scope member definitions
    has been corrected.
    e.g.,
    	class S {
	    enum { SIZE = 10 };
	    static int a[SIZE];
	};
	int S::a[SIZE];
	         ^^^^ - used to diagnose as access to private
===========================================================

    complex class template processing (nested class template
    expansions that occurred during a file scope member
    definition) could cause a compiler fault in certain
    circumstances.
===========================================================

    allow some anachronisms to function (necessary for MFC 2.0
    to function properly).  Note that the current ISO/ANSI C++
    draft disallows this kind of code.  The portability and
    semantics of these constructs is questionable.

	    int address_of_parm_ref( X &r )
	    {
		return &r != NULL;
	    }
	    int address_of_local_ref( X *p )
	    {
		X &r = *p;
		return &r != NULL;
	    }
	    int S::NULL_this_check()
	    {
		return this ? 0 : field;
	    }
===========================================================

    fixed scanning of floating point constants that start
    with:

	[0-7]*[89]

    This looks like an octal constant but turns into a
    floating constant once we hit the '8' or '9'.
===========================================================

    Fixed the __stdcall calling convention to properly
    save EBX.
===========================================================

    LibMain and WinMain are default extern "C" functions now
    (MS C++ compatibility)
===========================================================

    - anonymous unions were not brace '{}' initialized
      properly
    - diagnosing too many initializers for anonymous unions
      did not work properly
===========================================================

    overload of class specific operator new incorrectly
    allowed some expressions if there was only one operator
    new declared in the class.  A diagnostic is now issued
    for incorrect new expressions in this case.
===========================================================

    prevent compiler from faulting if errors were detected
    during class template instantiation and the type of the
    incorrectly compiled class was used subsequently.
===========================================================

    fixed a compiler page fault that was caused by a
    class consisting of only one data member (if it
    was an array of classes with a constructor).
===========================================================

    fixed a problem with destructing temporaries that
    are created during processing of the ctor initializer
    list in a constructor
===========================================================

    made it easier to mix C and C++ code by importing the
    C++ run-time library in modules where there is a
    extern "C" definition (this allows users to use a
    main() compiled with the C compiler)
===========================================================

    fixed semantic checks for <expr>.~T() and <expr>->~T()
===========================================================

    The -nm switch did not allow all the legal filename
    characters to be used in the module name.
===========================================================

    Fixed a problem with #pragma aux (alias) name handling
    of parameter lists.
===========================================================

    Tweaked compiler to move function modifiers in
    circumstances where the modifier can unambiguously
    be applied to a function type (this previously
    generated semantic errors).
    e.g., typedef int (* __pascal PF)( int, int );
      ==> typedef int __pascal (* PF)( int, int );

===========================================================

    Fixed a page fault in the compiler that was caused by
    multiple identical unnamed structs that required
    destructors.
===========================================================

    Made error messages regarding conflicting storage classes
    dump the previous symbol's location.
===========================================================

    if not compiling strict ANSI C++, an undeclared file-scope
    friend function can be static.
===========================================================

    - fixed default alignment of segments to be int
    - fixed alignment of symbols to depend on -ot
    (both fixes bring C++ in line with C semantics)

===========================================================

    - fixed a problem with some error messages not printing
      in strict ANSI C++ mode
    - made binding of a temporary to a non-const reference
      a level 1 warning
===========================================================

    - fixed a problem with -oe<n> not generating code for
      functions in some circumstances
    - fixed a problem that caused extra inline functions to
      have their code generated out of line
===========================================================

    fixed a page fault in the compiler when it was fed:

    template <class T>
	struct S {
	    struct N {
		static int a;
	    }
	};

    // template <class T>
    int S<T>::N::a = 1;
===========================================================

    Fixed line number processing for #line <n> "file"
    directives.
===========================================================

    Fixed diagnosing of situations where an overload of
    a constructor could not be performed because there
    were no constructors with the right number of arguments
    and the number of available constructors was one
===========================================================

    Bumped a couple of annoying warnings up a couple of
    levels because there are no source code changes that
    can remove them short of #pragma-ing them out.
    - mangled name truncated (WATCOM C++ automatically
      generates a better name that will fit by chopping
      and adding a hash so this is purely informational)
    - cast causes ptr truncation (<i86.h> contained this)
    - defining pure virtual destructors (container classes)
===========================================================

    Fixed a problem where a default operator = was generated
    by the compiler even though the source code never tried
    to do an assignment of any classes.  If the default op=
    could not be generated (because of access errors), this
    results in the rejection of correct code by the compiler.

    Example:
	struct A {
	private:
	    void operator=(const A &);
	};
	
	struct B : A {
	    void operator=(int i);
	};
	
	void fn( int i )
	{
	    B x;
	    x = i;
	}
===========================================================

    Added check for assigning into a function type with
    +=, -=, etc.
===========================================================

    Fixed check in some pointer conversions to treat "char"
    as a unique type.  Fixed function pointer conversion
    checks to handle enums and chars properly as unique
    types.
===========================================================

    Fixed the compiler so that the following initialization
    works properly:

    void foo()
    {
	char a[10];
	char *p[1] = { a };
    }
===========================================================

    Fixed template function binding for the case of non-reference
    function parameters and constant arguments.

    Example:

	template <class Q>
	    struct S {
		int a;
	    };
	
	template <class T>
	    void foo( S<T> x )
	    {
	    }
	
	void ack( const S<int> &r )
	{
	    foo( r );
	}

===========================================================

    Fixed catch type analysis so that enums are considered
    as unique types.
===========================================================

    Fixed a problem with user-defined conversion function
    access declarations incorrectly modifying access to
    related user-defined conversions.
===========================================================

    Suppress compiler generated names from lists of class
    members and local variables in debugging information.
===========================================================

    Fixed base class operator =() calls in compiler generated
    operator = functions to match Borland and CFRONT when
    the base class operator =() is virtual.
===========================================================

    Added extension that allows zero sized arrays to be
    declared at the end of structures for C compatibility.
    e.g.,
	    struct S {
		int a;
		int b;
		char c[];
	    };
===========================================================

The following bugs were fixed:

	A break in dead code could cause extra "missing return" warnings
	to be issued or could result in missing "dead code" diagnostics.

	Some always-TRUE or always-FALSE expressions were not being diagnosed
	as constant boolean expressions.

	Integral truncations during conversions were not being diagnosed.

	Compiler error 70 could be generated for virtual destructors or
	virtual operator= when some special calling conventions were present.

	Throwing member pointers or function names did not always work
	properly.

	An uncalled function whose address was taken, could be diagnosed
	as being unreferenced.

	When the expressions for some mem-initializers could be eliminated,
	they were not analysed and so errors could be missed.

	Objects passed to catch handlers were not always destructed properly.

	Spurious error messages could be generated for initialization of
	non-const objects with the ":" operator.

	Missing virtual destructor or operator= functions were not always
	detected at link time.
    
===========================================================

    Fixed code generator informational messages to be warnings
    rather than errors.
===========================================================

    Changed /oe default to better match the C compiler
    in optimization semantics.
===========================================================

    Ignore memory model modifiers enclosed within a typedef
    when declaring an automatic variable (this allows some
    function template code to work properly in the presence
    of based/near/far memory model modifiers)
    example:
	template <class T>
	    void swap( T &l, T &r )
	    {
		T t; t = l; l = r; r = t;
	    }

	int __far x, __far y;
	...
	swap( x, y );
	...
===========================================================


    The -oe option did not allow for an equal sign between
    it and the number the way it should.
===========================================================

          *****************
          ** C++ Library **
          *****************

    void operator delete( void * ) now checks for a NULL
    pointer before it calls free().  This is necessary
    because in some environments free() may be replaced
    with a non-ANSI conforming free() that will not
    accept a NULL pointer (problem was detected in a
    Autodesk ADS C++ application because free() is
    overridden by ADS.LIB).
===========================================================

    cout object has ios::unitbuf format flag set by default
    to support better mixing of C++ iostream and C stdio.
===========================================================

    istream::getline() function corrected to set
    ios::failbit on return if no characters have been stored
    into the callers buffer.
===========================================================

    corrected logic in filebuf destructor to discern if
    associated file should be closed.
===========================================================

    string::operator >> now respects the ios::skipws format
    flag.
===========================================================

    corrected length computation in string::operator()()
    for extracting substrings.
===========================================================

    corrected a problem with termination error messages
    causing problems in -3s 386 models
===========================================================

    Fixes to list iterator append and insert which were inserting
    the new entry at the beginning of the list after an iterator error
    have been made.
    
    Pointer and Value single and double linked list find, findLast and
    get member functions now work with empty lists.  An index_range
    exception will be thrown if enabled.  If not, a value list will
    return a default initialized object, and a pointer list will
    return an unintialized pointer.
    
    A problem was fixed for double linked list iterators over lists
    containing only one element.
    
    
    Iterators now have the following semantics (some semantics were
    previously undocumented):
      If an iterator is constructed without a list being passed to the
      constructor and is not reset with a list, only the reset
      member function is valid.  All other operators or member functions
      will throw an undef_iter exception or return 0 (except for current
      which returns an default initialized object for value list iterators,
      and return an uninitialized pointer for pointer list iterators).
    
      After an iterator is reset or for a newly constructed iterator, the
      iterator is positioned before the first element in the list.
      
      When the iterator is positioned before the first element in the
      list, only the following operators/member functions are valid:
	  operator(), operator++, operator+=, container and reset
      The first increment positions the iterator at the first element in
      the list.
    
      If the iterator is incremented past the last element in the list
      using operator(), operator++, operator+= then 0 will be returned.
      Attempts to further increment the iterator using operator(),
      operator++ or operator+= will throw an undef_iter exception
      if it is enabled, or return 0 if it is not.  The iterator will
      then be positioned after the last element in the list.  When an
      iterator for a double linked list is past the end of the list,
      operator-- and operator-= are valid, with the first decrement
      positioning the iterator to the last element in list.
    
      If the iterator for a double linked list is decremented before
      the first element in the list using operator-- or operator-=
      then 0 will be returned.  Further attempts to decrement the
      iterator (or attempting to decrement an iterator which was reset
      or newly constructed) using operator-- or operator -= will throw an
      undef_iter exception if it is enabled, or return 0 if it is not.
      The iterator will then be positioned before the first element in
      the list.
    
      The following member functions have the following error semantics
      when an iterator is positioned before the first element or after
      the last element in the list:
    
	current: throw an undef_item exception if enabled, and
		 return 0 in the intrusive iterator, a default
		 initialized object in the value case, and an
		 uninitialized pointer in the pointer case.
	append: throw an indef_iter exception if enabled, and
		return 0.
	insert: (double linked list iterators only) throw an
		undef_iter if enabled, and return 0.
    
    
    A new exception, out_of_memory was added to WCListExcept and is
    thrown, if enabled, when an insert or append fails.
    
    If the insert and append member functions fail, they will throw
    the out_of_memory exception if enabled for the list, and return 0.
    Non-zero is returned on success.  This applies to all list classes
    and list iterator classes.
===========================================================

    Fixed the ifstream,ofstream,fstream constructors to
    handle the case where the user specifies an openmode
    bit but leaves off an indication of either ios::in or
    ios::out.  The ios::in and ios::out are implied in the
    type of fstream being instantiated.
===========================================================

    Fixed the istream::getline() function to set ios::failbit
    if the read terminates because the buffer is full before
    the delimeter is seen.
===========================================================

    Fixed the string::alloc_mult_size() member function to
    properly set the new allocation size.
===========================================================

    Added following const member functions to the String class:
	String::operator char const * () const;
	char const & String::operator () ( size_t __pos ) const;
	char const & String::operator [] ( size_t __pos ) const;
===========================================================

    Changed istream::getline() and istream::get() functions
    to not set ios::failbit if no characters have been stored
    into the user buffer *and* the delimiting character has
    been seen.
===========================================================

    Fixed ifstream constructor to not implicitly create
    files when ios::in specified.
===========================================================

    Added ios::sync_with_stdio(). It is an obsolete function
    but has been added for compatibility.
===========================================================

    The strstream::seekoff() function has been fixed to handle
    ios::in|ios::out style seeks.  It returns the new position of
    the put pointer.
===========================================================

    The strstream::strstream() constructor which takes an
    ios::openmode parameter now handles ios::atend or ios::append
    properly to only position the put pointer to the end of the buffer.
===========================================================

    The ifstream::ifstream() constructor that takes an
    ios::openmode parm implicitly has the ios::in bit turned
    on in all cases.
    The ofstream::ofstream() constructor that takes an
    ios::openmode parm implicitly has the ios::out bit turned
    on in all cases.
===========================================================

    Multi-threaded applications where more than one thread
    could throw an exception at the same time could
    go into an infinite loop in the C++ runtime.
===========================================================

    Multi-threaded NLM's sometimes failed to destroy static
    objects.

===========================================================

    Fixed Complex::operator-(double,complex) to properly
    set the sign of the imaginary component.
===========================================================

          *************
          ** DOS4/GW **
          *************

  All of the DOS/4GW error messages have been reorganized and renumbered.
  There is currently no document that describes all the conditions under
  which the errors can occur.
  
  The familiar "unexpected interrupt" message has been revised for clarity.
  It now gives both the exception number and a brief description of the
  exception.
  
  On a transfer stack overflow, the error message now includes the number of
  the interrupt that provoked the overflow and the address at which the
  interrupt occurred.
  
  Setting DOS4G=NULLP now catches attempts to read from the null pointer as
  well as attempts to write to it.
  
  The virtual memory manager will now silently accept bad configuration
  options.
  
  An incompatibility with cheap clone IDE disk controllers has been fixed.
  Some of these controllers, when installed in machines with clock speeds
  relatively fast for their processors, and with other cards on the bus,
  randomly generate interrupt 0Fh even if configured to use a different IRQ.
  On a computer with one of these hardware configurations, DOS/4GW would
  crash at random points while loading or running; the problem would never
  occur in a Windows DOS box.
  
  We have worked around a bug in the EMM386 distributed with DOS 6.0, which
  cropped up only without the NOEMS and NOVCPI options. If another
  application that allocated expanded (EMS) memory ran beforehand, DOS/4GW
  would hang on startup.
  
  DOS/4GW on Fujitsu FMR series computers no longer causes the system to
  crash on an interrupt F3h.
  
  The SS and ESP are no longer reported as zero on a recoverable stack fault.
  
  DOS/4GW is less susceptible to recursive faults while reporting an
  exception. It will detect most recursive fault conditions and terminate
  immediately.
  
  The trap flag is now properly preserved if a hardware interrupt or
  processor exception occurs while single-stepping in a debugger. This bug
  caused debuggers to occasionally "run away" during stepping for no obvious
  reason.
  
  A bug in handling exceptions when ESP was slightly greater than an even
  multiple of 10000h has been corrected.
  
  A bug that caused the system to reboot on INT 31/0001 (Free Descriptor)
  when DS and ES contained the segment register being cancelled is fixed.
  
  An obscure bug in INT 31/0002 (Segment to Descriptor) has been fixed.
  
  INT 31/0100 (Allocate DOS Memory Block) and INT 31/0102 (Resize DOS Memory
  Block) will now properly return the number of available paragraphs in BX
  when more memory is requested than is actually available.
  
  Several bugs in INT 31h/601h (Unlock Linear Region) have been corrected.
  
  Two bugs in INT 31h/800h (Physical Address Mapping), one with mapping more
  than 64K at a time and one with multiple mappings, have been corrected.
  
  INT 2 (the non-maskable interrupt) is once again passed down.
  
  DOS/4GW will now return carry clear on any attempt to unlock memory that
  isn't managed by the virtual memory manager (for example, low memory).
  
  An off-by-one-page bug in calculating the maximum address managed by VMM
  has been fixed.
  
  A bug that reduced application performance on 80486 machines, even when all
  code and data fit into physical memory, has been corrected.
  
  DOS/4GW is now more careful about recognizing the names of programs which
  require special treatment, for example DOS4GW.EXE. It is now possible to
  name your program something like XXDOS4GW.EXE.
  
  DOS/4GW once again opens programs using DOS "compatibility mode". This
  change allows multiple users to read the executable simultaneously. For
  example, WVIDEO can read the debugging information even if the .EXE file
  has been kept open for demand loading. Ironically, we switched away from
  compatibility mode to support an earlier version of WVIDEO.
  
  A bug in handling 16-bit relocations in 32-bit code that prevented programs
  from loading has been corrected.
  
  Freeing a descriptor that happens to be in the FS or GS registers now works
  properly. The value in FS or GS will be zeroed.
  
  Chaining to a previously installed interrupt handler will now correctly
  return the zero and carry flags.
  
  A bug where the EAX register was corrupted on a switch from real mode to
  protected mode has been fixed. This bug was only a problem in the absence
  of a VCPI or DPMI memory manager, when VMM was running, and when DOS STACKS
  was not set to 0,0.
===========================================================

          *************************
          ** FORTRAN 77 Compiler **
          *************************

    Passing a character array that was a field within a
    structure did not work correctly.
===========================================================

    It was possible for the compiler to crash when scanning
    code similar to the following:

    	IF( X..AND. )
===========================================================

    There was a problem with character variables in common
    when the /automatic switch was specified.
===========================================================

    The compiler would not evaluate the following expression
    correctly.

	'A'//B.C//'D'

    B is a structure that contains a character field C.
===========================================================

    The usage message for WFC specified WFC386.
===========================================================

    Specifying the /d2 and /nodescriptor options would cause
    a compiler error 3 for CHARACTER*(*) arrays.
===========================================================

    The wrong error message would be issued when data
    initialization in a DATA statement contained more
    constants than data items or vice versa.
===========================================================

    The compiler could crash if the FUNCTION statement starting
    a function subprogram had a syntax error.
===========================================================

    The error file would not be closed if the only error was an
    invalid command line (i.e. an invalid option).
===========================================================

    A compiler error 2 and/or 3 would be issued when in-lining
    statement functions (with the /oi or /ox options).  This
    would only occur if the statement function was of type
    complex and the expression for the statment function was
    a scalar (and vice versa).
===========================================================

    String descriptors for character variables were not being
    allocated on the stack when the /automatic switch was
    specified.
===========================================================

    A character select expression, other than a simple
    character variable, caused the compiler to crash.
===========================================================

    Fixed a problem with the /or (instruction scheduling)
    option and variables used in the IOSTAT= specifier of
    I/O statements.
===========================================================

    An incorrect warning message was being issued specifying
    that a character variable was used but not defined when
    the character variable was being defined by a substring
    operation as in the following example.

    	CHARACTER*10 CH
	CH(1:5) = '12345'
	PRINT *, CH(1:5)
	end
===========================================================

    Compiler generated incorrect code for formatted i/o when
    format specification was a character variable and /format
    option was specified.
===========================================================

          ************************
          ** FORTRAN 77 Library **
          ************************

    IARGC() and IGETARG() did not work in the default
    windowing environment for Windows.
===========================================================

    There were problems linking OS/2 2.x multithreaded
    applications when using "option caseexact".
===========================================================

    There was a problem printing a character string when
    the last byte of the string was the first byte of a
    double-byte character.  Double-byte character processing
    is performed when one of the /japanese, /chinese or
    /korean options is specified.
===========================================================

    It was not possible to detect integer overflows detected
    during a read operation (i.e. converting character data
    to integer data) by using ERR= or IOSTAT=.
===========================================================

    Printing complex numbers using free format could cause
    *'s in the output field if the real/imaginary parts were
    negative and had 3-digit exponents.
===========================================================

    Fixed a problem reading binary files using non-character
    arrays.  Binary files are files opened using
    ACCESS='SEQUENTIAL', FORM='UNFORMATTED' and RECORDTYPE='FIXED.
===========================================================

    Fixed a problem with DLL's where an open file would not
    get closed when the DLL terminated.
===========================================================

    If an OPEN statement failed, the unit would remain
    connected even if the unit was previously not connected.
===========================================================

    Fixed a problem with NAMELIST-directed I/O.  Under certain
    circumstances, array names beginning with the letter 't' were
    interpreted as the value .TRUE. resulting in a "type mismatch"
    error being issued.
===========================================================

    Added SEEKUNIT() function that allows the programmer to
    seek a binary file.  Binary files are files opened with
    ACCESS='SEQUENTIAL', FORM='UNFORMATTED' and RECORDTYPE='FIXED'.
    SEEKUNIT() is an integer function that returns zero if
    the operation succeeded and non-zero if it failed.  It
    requires three integer arguments.  The first is the unit
    number, the second is the offset within the file, and the
    third is SEEK_SET (seek from the beginning of the file) or
    SEEK_CUR (seek from the current position in the file).  SEEK_SET
    and SEEK_CUR are defined in FSUBLIB.FI in the SRC\FORTRAN
    directory  of the directory in which the software was installed.
===========================================================

    Invalid unformatted sequential files were created when an i/o
    list item spanned a physical record.  For example, if the physical
    record length was 10 (the default is 256) and three integers
    were displayed (each integer requires 4 bytes), the last integer
    would not fit in the physical record and causes incorrect
    information to be placed in the file.

          **********************
          ** Graphics Library **
          **********************

    Made _remappalette go faster in 16 and 256 colour modes.
===========================================================

    Added support for VESA devices in 386 protected mode.
===========================================================

    Improved the speed of the palette initialization in _setvideomode
    by making use of the faster _remappalette code.
===========================================================

    Added support for the FlashTek DOS extender.
===========================================================

          ********************
          ** C Header Files **
          ********************

    Fixed NetWare 4.0 header file <stdlib.h> so that it
    works properly with -oi when compiled as C++.
===========================================================

          ***************
          ** Librarian **
          ***************

    The last two elements of the ++ operator description
    on the help screen were reversed.
===========================================================

    The librarian now places COMDEF and COMDAT symbols into
    the library dictionary. This allows C++ template functions
    to be properly found and extracted from a library by
    the linker.
===========================================================

    When creating an import library for an Windows NT
    DLL, the librarian would crash if the total length
    of all the exported names was greater than 4K.
===========================================================

    Fixed check for overflowing library files under NT.
===========================================================

          ************
          ** Linker **
          ************

    The file specified by "option resource" for QNX executables
    was being opened for read/write access rather than just
    read.
===========================================================

    The OPTION INTERNALRELOCS directive did not work properly.
===========================================================

    There was a bug in option eliminate that occured when a PUBDEF
    record redefined a COMDAT record that was a virtual function in a
    base class, and the inheriting class was instantiated the virtual
    function was referenced _after_ the comdat was redefined. (phew)
    This could be made to happen with lots of templates.
===========================================================

    For files that only contain templated code, the debugging
    information was slightly out of whack
===========================================================

    The linker will not search library dictionary for uninitialized
    communal variables now.  (Needed so we can put communal variable
    definitions into the library dictionaries)
===========================================================

    In some cases it was possible for OS/2 1.x and Windows NT DLLs to
    lose a bit of uninitialized data.
===========================================================

    Added "format windows nt pharlap" and "runtime dosstyle"
    for the PharLap TNT dos extender.
===========================================================

    changed the message "DLL COMENT record invalid when not in OS2"  to
    "export and import records not valid for %f" since the old message
    is rather archaic.  (more than just OS2 supports DLLs now!)
    As well, disabled this warning message for the win386 extender.
===========================================================

    made the libfile command work with the LIB environment variable.
===========================================================

    put out linear addresses in qnx flat map files
===========================================================

    option rwr would not work if you compiled with /d2 but did not use
    debug all in the link file
===========================================================

          **********
          ** Make **
          **********

    WMAKE for NT was compiled with DOS file component
    constants so it only allowed 8.3 file names.
===========================================================

    WMAKE now handles c: commands for OS/2 and NT.
===========================================================

    WMAKE correctly touches files to the current time under NT
===========================================================

    always build targets if any of their dependents are
    updated with commands
===========================================================

    execute .error command list for .symbolic and .precious
    targets if an error occurs during the command list
===========================================================

          ***********************
          ** Windows SDK Tools **
          ***********************

   Fixed a resource compiler bug where Preload resources were sometimes
   corrupted when a fastload section was created in a large Windows
   executable.
===========================================================

    Fixed a resource compiler bug where double byte characters were
    not being properly translated to UNICODE for NT .res files.
===========================================================

    Fixed the resource compiler so it will not GP fault if there
    is no INCLUDE environment variable
===========================================================

    Fixed the resource compiler so it handles \a characters correctly
    in MENUITEM statements.
===========================================================

    Fixed the resource compiler so it handles custom controls
    in NT dialog boxes correctly.
===========================================================

    Fixed a resource compiler bug where windows executables were
    sometimes corrupted when run through the resource compiler
    without adding resources
===========================================================

          ************************
          ** Windows Supervisor **
          ************************

    Objects > 1MB in size were not handled properly.  This most
    frequently shows up with large bitmaps.
===========================================================

    Added code to check selector values before restoring DS and ES
    upon return from a DLL function call in case the DLL function
    ends up freeing the memory that the selector points to.
===========================================================

    The mmioOpen function is allowed to pass in a NULL pointer as
    the second parameter. The extender was causing an exception by
    trying to reference a field in this structure without checking
    to see if the pointer was NULL.
===========================================================

          ************
          ** WVIDEO **
          ************

    If you were in a function that had 2 or more local variables
    which only differed in case and the debugger was set to
    perform case insensitive lookups (the default) then an
    attempt to reference one of the local variables would cause
    the debugger to fault. E.g.:

        foo()
	{
	    int c, C;
	}

     And attempt to print the value of 'c' or 'C'.
===========================================================

    The QNX pmd.trp file did not properly access memory
    through the data selector when processing a dump
    file from a 32-bit flat model program.
===========================================================

    Make debug registers work when debugging a DOS4G application.
===========================================================

    The debugger would sometimes attempt to access a C++
    member before a routine's prologue had completed execution.
    An error message is now issued in this case.
===========================================================

    If an error occurred parsing the command line options
    right at the end of the command line (e.g. "wvideo /" )
    then a strange character would be displayed in the error
    message on some systems.
===========================================================

    Fixed a bug in WVPMHELP that could hang PM when
    a break point was hit in a dialog callback.
===========================================================

    The variable display window could not properly follow
    more than one level of pointer fields.
===========================================================

    Fixed the OS/2 hosted version of the debugger so that
    it works properly under PharLap's 286|DOS-Extender.
    In an OS/2 2.x DOS box you have to specify the

    	/TRAP=STD16

    option to force the use of the OS/2 1.x debugging
    interface code.
===========================================================

    Pressing the right mouse button did not work properly
    under OS/2.
===========================================================

    Comments in multi-line command lists (from invoke files)
    did not terminate properly at the end of line.
===========================================================

    Fixed some problems with asynchronous interruption
    of programs under DOS4G/W.
===========================================================

    Support use of ALT-<number> under OS/2 to allow entering
    any keyboard code.
===========================================================

    The default profile was using a colour scheme which
    did not look good on monochrome display adaptors.
===========================================================

          **************************************
          ** IBM WorkFrame/2 Support Programs **
          **************************************

    Fixes to WorkFrame/2, available in version 1.1, now make
    it possible to support automatic make file creation.  The
    language profiles for WATCOM languages have been changed
    to use IBM's make facility.

===========================================================

    WorkFrame/2 would crash when "link" was selected in the
    actions menu.
===========================================================

          ************
          ** WTOUCH **
          ************

    Fixed so that setting dates and times under Windows/NT
    works correctly if the machine is not in the GMT timezone.
===========================================================

    Fixed a weird problem for Windows/NT that was caused
    by NT not letting us touch an existing file but letting
    us truncate it!  The truncation is a result of WTOUCH
    trying to create a 0-length file because it assumes if
    it can't change the time-stamp, the file doesn't exist.
    Now we do not try to create a file if it already exists.
===========================================================
