package bench;
//import java.util.Random;

class Tree
   extends TestBase
{
    private int data;
    private Tree left = null;
    private Tree right = null;
    private int  numInserts;

    public Tree()
    {
        super("Binary Tree Inserts");
    }

    public void setData(int p1, int p2)
    {
        numInserts = p1;
    }

    public Tree(int d)
    {
        super("");
        data = d;
    }

    public final void performTest()
    {
        Random r = new Random();
        Tree t = null;  

        for (int i = 0; i < numInserts; i++)
        {
            int m = Math.abs(r.nextInt() % 1000);

            if(t == null)
            {
                t = new Tree(m);
            }
            else
            {
                t.insert(m);
            }
        }

        t.infix();
    }

    private final void insert(int n)
    {
        Tree node;

        if(n < data)
        {
            node = left;

            if(node != null)
            {
                node.insert(n);
            }
            else
            {
                node = new Tree(n);
            }
        }
        else if(n > data)
        {
            node = right;

            if(node != null)
            {
                node.insert(n);
            }
            else
            {
                node = new Tree(n);
            }
        }
    }

    private final void infix()
    {
        Tree node = left;

        if(node != null)
        {
            node.infix();
        }

        node = right;

        if(node != null)
        {
            node.infix();
        }
    }
}