IMPLEMENTATION MODULE XYplane;

(* 
            OBERON GRAPHICS STANDARD LIBRARY MODULE

   Aug 93 Diane Corney - adapted from modula library module graphics.mod

*)

FROM Xlib IMPORT DisplayPtr, Window, GC, XSetForeground,
                XOpenDisplay, XDefaultScreen, XWhitePixel, XBlackPixel,
                XCreateSimpleWindow, XDefaultRootWindow, XStoreName,
                XEvent, XEventsQueued, QueuedAfterFlush, XPending,
		XSelectInput, ExposureMask,
		XQueryPointer, XClearWindow,
		XAllocColor, Status, Fail,
		XAllocColorCells, XQueryColor,
		XCopyColormapAndFree, XInstallColormap,
		XCreateColormap,
		XDefaultVisual, AllocAll, AllocNone,
		ButtonPressMask, XNextEvent, XButtonEvent, ButtonPress,
		XDrawPoint, XFillRectangle, XDrawRectangle, XDefaultGC,
                XDrawString, Colormap, XColor, XStoreColor, XDrawLine,
                XMapRaised, XFlush, XDefaultColormap,
                XDestroyWindow, XCloseDisplay;
IMPORT StdError ;
FROM SYSTEM IMPORT CAST;

CONST
  erase = 0;
  draw = 1;
  mapW = 20;
  mapH = 400;
  setSize = 32;

VAR
  mydisplay : DisplayPtr;
  mywindow : Window;
  myscreen : INTEGER;
  myforeground, mybackground : CARDINAL ;
  mygc : GC;
  opened : BOOLEAN;
  i : INTEGER;
  bitmap : ARRAY [0..mapW-1],[0..mapH] OF BITSET;
  colourTable : ARRAY [0..255] OF CARDINAL;
  myColourMap : Colormap;

  PROCEDURE EventHappened () : BOOLEAN;

  (* Returns TRUE iff an event is waiting in the queue *)
  BEGIN (* EventHappened *)
    RETURN (XPending (mydisplay) > 0);
  END EventHappened;

  PROCEDURE ThrowEvent;

  (* Throws away the first event in the queue *)

  VAR
    throw : XEvent;

  BEGIN (* ThrowEvent *)
    XNextEvent(mydisplay, throw);
  END ThrowEvent;

  PROCEDURE Assert (cond : BOOLEAN; message : ARRAY OF CHAR);

  BEGIN (* Assert *)
    IF NOT cond THEN
      StdError.WriteString (message);
      IF opened THEN Close; END;
      HALT;
    END; (* IF *)
  END Assert;

  PROCEDURE Open(str : ARRAY OF CHAR);
  VAR
    throw : INTEGER;
  BEGIN
    IF opened THEN
      XSetForeground (mydisplay, mygc, mybackground);
      XFillRectangle (mydisplay, mywindow, mygc, X, Y, W, H);
      RETURN;
    END; (* IF *)
    (* Connect to the server: *)
    mydisplay := XOpenDisplay("");
    IF mydisplay = NIL THEN
      StdError.WriteString ("Cannot connect to server");
      StdError.WriteLn;
      HALT;
    END;
    (* Get a screen: *)
    myscreen := XDefaultScreen(mydisplay);
    (* Look up "black" and "white": *)
    mybackground := XWhitePixel(mydisplay, myscreen);
    myforeground := XBlackPixel(mydisplay, myscreen);
    mywindow := XCreateSimpleWindow (mydisplay,
                        XDefaultRootWindow(mydisplay), X, Y, W, H, 2,
                        myforeground, mybackground);
    (* Give the window manager a window name hint *)
    XStoreName(mydisplay, mywindow, str);
    (* Pop this window up on the screen: *)
    mygc := XDefaultGC (mydisplay, myscreen);
    myColourMap := XDefaultColormap (mydisplay, myscreen);
    SetUpColours (myColourMap, mydisplay);
    XMapRaised(mydisplay, mywindow);
    XSelectInput(mydisplay, mywindow, ExposureMask);
    REPEAT
    UNTIL EventHappened ();
    ThrowEvent;
    XSelectInput (mydisplay, mywindow, ButtonPressMask);
    ZeroBitmap;
    opened := TRUE;
  END Open;

  PROCEDURE Dot(x, y, mode : INTEGER);
  VAR
    cardX, cardY : CARDINAL;
  BEGIN (* Dot *)
    (* Draw a rectangle on mywindow at (x,y), width 1, height 1 *)
    Assert (opened, "Dot: graph screen not opened");
    IF ((mode = erase) OR (mode = draw)) AND 
       ((x >= 0) AND (x <= W)) AND ((y >= 0) AND (y <= H)) THEN
      cardX := VAL(CARDINAL,x);
      cardY := VAL(CARDINAL,H-y);
      IF mode = erase THEN (* draw in background colour *)
        XSetForeground (mydisplay, mygc, mybackground );
        EXCL(bitmap[cardX DIV setSize][cardY],cardX MOD setSize);
      ELSE
        (* mode = draw - draw in foreground colour *)
        XSetForeground (mydisplay, mygc, myforeground );
        INCL(bitmap[cardX DIV setSize][cardY],cardX MOD setSize);
      END;
      XDrawPoint(mydisplay, mywindow, mygc, cardX, cardY);
      XFlush(mydisplay);
    END;
  END Dot;

  PROCEDURE ColourDot(x, y, colour : INTEGER);
  VAR
    cardX, cardY : CARDINAL;
  BEGIN (* Dot *)
    (* Draw a rectangle on mywindow at (x,y), width 1, height 1 *)
    Assert (opened, "Dot: graph screen not opened");
    IF ((x >= 0) AND (x <= W)) AND ((y >= 0) AND (y <= H)) THEN
      cardX := VAL(CARDINAL,x);
      cardY := VAL(CARDINAL,H-y);
      XSetForeground (mydisplay, mygc, colour);
    END;
    XDrawPoint(mydisplay, mywindow, mygc, cardX, cardY);
    XFlush(mydisplay);
  END ColourDot;

  PROCEDURE ColourBox(x,y,colour,width,height : INTEGER);
  VAR
    cardX, cardY : CARDINAL;
  BEGIN (* Dot *)
    (* Draw a rectangle on mywindow at (x,y), width 1, height 1 *)
    Assert (opened, "Dot: graph screen not opened");
    IF ((x >= 0) AND (x <= W)) AND ((y >= 0) AND (y <= H)) THEN
      cardX := VAL(CARDINAL,x);
      cardY := VAL(CARDINAL,H-y);
      XSetForeground (mydisplay, mygc, colourTable[colour]);
    END;
    XFillRectangle(mydisplay, mywindow, mygc, cardX, cardY,width,height);
    XFlush(mydisplay);
  END ColourBox;

  PROCEDURE IsDot(x, y : INTEGER):BOOLEAN;
  VAR
    cardX, cardY : CARDINAL;
  BEGIN (* IsDot *)
    Assert (opened, "IsDot: graph screen not opened");
    IF ((x >= 0) AND (x <= W)) AND ((y >= 0) AND (y <= H)) THEN
      cardX := VAL(CARDINAL,x);
      cardY := VAL(CARDINAL,H-y);
      RETURN (cardX MOD setSize) IN bitmap[cardX DIV setSize][cardY];
    ELSE
      RETURN FALSE;
    END;
  END IsDot;

  PROCEDURE Close; (* Kills the graphics window for cleanup purposes *)
  BEGIN (* Close *)
    Assert (opened, "Close: graph screen not opened");
    XDestroyWindow (mydisplay, mywindow);
    XCloseDisplay (mydisplay);
    opened := FALSE;
  END Close;

  PROCEDURE Clear; (* clears the graphics window *)
  BEGIN
    Assert (opened, "Clear: graph screen not opened");
    XSetForeground (mydisplay, mygc, mybackground);
    XFillRectangle (mydisplay, mywindow, mygc, X, Y, W, H);
    ZeroBitmap;
  END Clear;

  PROCEDURE ZeroBitmap;
  VAR
    i,j : INTEGER;
  BEGIN
    FOR i := 0 TO mapW-1 DO
      FOR j := 0 TO mapH DO
        bitmap[i,j] := BITSET{};
      END;
    END;
  END ZeroBitmap;

  PROCEDURE SetUpColours (VAR colourMap : Colormap; VAR display : DisplayPtr);

  VAR
  colour, r, g, b, count : INTEGER;
    xColour : XColor;
    throw : Status;

    (*
     *  this procedure produces a wild palette of
     *  colours with big changes between each neighbour
     *
    PROCEDURE NextColour (VAR r, g, b : INTEGER);
    BEGIN (* NextColour *)


      colour := colour + 3 * 64 + 1 * 8 + 1;

      r := colour MOD 8;
      g := (colour DIV 8) MOD 8;
      b := (colour DIV (8 * 8)) MOD 8;
      r := r * 32;
      g := g * 32;
      b := b * 32;

    END NextColour;
     *)

    (*
     *  this procedure produces a ramp of primaries
     *  and secondary colours
     *)
    PROCEDURE NextColour (VAR r, g, b : INTEGER);
      VAR thing : BITSET;
          lsbs  : CARDINAL;
    BEGIN (* NextColour *)

      thing := CAST(BITSET,count DIV 16);
      lsbs  := count MOD 16;

      IF 0 IN thing THEN r := lsbs * 16 ELSE r := 0 END;
      IF 1 IN thing THEN g := lsbs * 16 ELSE g := 0 END;
      IF 2 IN thing THEN b := lsbs * 16 ELSE b := 0 END;

    END NextColour;

  BEGIN (* SetUpColours *)
    colour := 0;
    WITH xColour DO
      flags := CHR(7);
      r := 0;
      g := 0;
      b := 0;
      FOR count := 20 TO 255 DO
        red := r * 256;
        green := g * 256;
        blue := b * 256;
        throw := XAllocColor (display, colourMap, xColour);
        colourTable [count] := pixel;
        NextColour (r, g, b);
(*
        WriteCard (r, 10); WriteCard (g, 10); WriteCard (b, 10);
        WriteLn;
 *)
      END; (* FOR *)
    END; (* WITH *)
    (* Ensure that background maps to background *)
    colourTable [mybackground] := mybackground;
  END SetUpColours;


BEGIN (* Graphics *)
  opened := FALSE;
  X := 0;
  Y := 0;
  W := 640;
  H := 400;
END XYplane.
